#include "WheelInterface.h"
#include "globals.h"

#define BT_SEND 101

LPSTR winClassName = "G27LEDS";

HWND hRPMCap;
HWND hFirstLedsCap;
HWND hRedlineCap;

HWND hRPMEB;
HWND hFirstLedsEB;
HWND hRedlineEB;

HWND hSendBtn;

WheelInterface wheelIFace;

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_CREATE:
			HFONT hfDefault;

			hEditBox = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", "", 
									  WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL | ES_READONLY |
									  ES_MULTILINE | ES_AUTOVSCROLL, 
								      0, 0, 800, 120, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
			
			//Create captions for edit boxes
			hRPMCap = CreateWindowEx(0, "STATIC", "",
									 WS_CHILD | WS_VISIBLE | ES_READONLY,
									 0, 124, 80, 18, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
			SendMessage(hRPMCap, WM_SETTEXT, 0, (LPARAM)"RPM:");
			
			hFirstLedsCap = CreateWindowEx(0, "STATIC", "",
							   	 		   WS_CHILD | WS_VISIBLE | ES_READONLY,
									       0, 142, 80, 18, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
			SendMessage(hFirstLedsCap, WM_SETTEXT, 0, (LPARAM)"First LEDs:");
			
			hRedlineCap = CreateWindowEx(0, "STATIC", "",
							   	 		 WS_CHILD | WS_VISIBLE | ES_READONLY,
									     0, 160, 80, 18, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
			SendMessage(hRedlineCap, WM_SETTEXT, 0, (LPARAM)"Redline:");

			//Create edit boxes for RPM
			hRPMEB = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", "",
							   	 		 WS_CHILD | WS_VISIBLE,
									     80, 124, 80, 18, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
			hFirstLedsEB = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", "",
						 	   	 		  WS_CHILD | WS_VISIBLE,
									      80, 142, 80, 18, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
			hRedlineEB = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", "",
						 	   	 		WS_CHILD | WS_VISIBLE,
									    80, 160, 80, 18, hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);

			//Create big fsckng send button
			hSendBtn = CreateWindowEx(WS_DLGFRAME, "BUTTON", "",
						 	   	      WS_CHILD | WS_VISIBLE | ES_READONLY,
									  0, 183, 160, 36, hWnd, (HMENU)BT_SEND, GetModuleHandle(NULL), NULL);
			SendMessage(hSendBtn, WM_SETTEXT, 0, (LPARAM)"Send");

			if(hEditBox == NULL)
			{
				MessageBox(hWnd, "Could not create edit box.", "Error", MB_ICONERROR | MB_OK);
			}

			hfDefault = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
			SendMessage(hEditBox, WM_SETFONT, (WPARAM)hfDefault, MAKELPARAM(FALSE, 0));
			break;
		case WM_COMMAND:
			if(LOWORD(wParam) == BT_SEND) {
				//Get values from edit boxes
				int len, rpm, firstLeds, redline;
				char text[64];
				
				//Get RPM
				len = SendMessage(hRPMEB, WM_GETTEXT, 63, (LPARAM)text);
				if(len <= 0) break;
				rpm = atoi(text);

				//Get first LEDs
				len = SendMessage(hFirstLedsEB, WM_GETTEXT, 63, (LPARAM)text);
				if(len <= 0) break;
				firstLeds = atoi(text);

				//Get redline
				len = SendMessage(hRedlineEB, WM_GETTEXT, 63, (LPARAM)text);
				if(len <= 0) break;
				redline = atoi(text);

				//Send data to wheel
				wheelIFace.SendLeds(rpm, firstLeds, redline, TRUE);
			}
			break;
		case WM_CLOSE:
			DestroyWindow(hWnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			hEditBox = NULL;
			break;
		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
			break;
	}

	return S_OK;
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	//Create and initialize window class
	WNDCLASSEX wcx;

	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = 0;
	wcx.lpfnWndProc = WndProc;
	wcx.cbClsExtra = 0;
	wcx.cbWndExtra = 0;
	wcx.hInstance = hInstance;
	wcx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	wcx.hbrBackground = (HBRUSH)(COLOR_WINDOW);
	wcx.lpszMenuName = NULL;
	wcx.lpszClassName = winClassName;

	//Try to register window class
	if(!RegisterClassEx(&wcx))
	{
		//Couldn't register window class, tell the user and exit
		MessageBox(NULL, "Cannot register window class", "Initialization error", MB_ICONERROR | MB_OK);
		return E_FAIL;
	}

	//Try to create window
	hMWin = CreateWindowEx(WS_EX_CLIENTEDGE, winClassName, "G27Leds", WS_OVERLAPPEDWINDOW,
		                       CW_USEDEFAULT, CW_USEDEFAULT, 814, 272, NULL, NULL, hInstance, NULL);

	if(hMWin == NULL)
	{
		//Couldn't create window, tell the user and exit
		MessageBox(NULL, "Cannot create window", "Initialization error", MB_ICONERROR | MB_OK);
		return E_FAIL;
	}
	
	//Initialize DirectInput
	if(FAILED(wheelIFace.InitDirectInput()))
		//Error when trying to interface with the wheel, terminate
		return E_FAIL;

	//Display window
	ShowWindow(hMWin, nShowCmd);
	UpdateWindow(hMWin);

	//Enter the message loop
	MSG msg;
	while(GetMessage(&msg, NULL, NULL, NULL) > 0)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}