#include "outgaugeprocess.h"

#ifdef CIS_LINUX
#define SOCKET_ERROR -1
#define INVALID_SOCKET 0
#endif

OutGaugeProcess::OutGaugeProcess(word inPort, FuelDataProcess* inFDProc)
{
	ipAddr = "0.0.0.0";
	port = inPort;
	fDProc = inFDProc;
}

/** Initializes connection to LFS's OutGaugeProcess
 */
bool OutGaugeProcess::initConnection()
{
	//DEBUG: Tell the user what are we doing here
	std::wcout << "(OGProc)Attempting to connect to Outgauge" << std::endl;
	std::wcout << "Interface: " << ipAddr << " Port: " << port << std::endl;

	//Windows stuff only, needed by winsock
	#ifdef CIS_WINDOWS
	if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) {
		WSACleanup();
		std::cerr << "(OGProc)Critical: Failed to init WinSock" << std::endl;
		return EXIT_FAILURE;
	}
	#endif
  

	//Create an UDP socket
	ogSock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (ogSock == INVALID_SOCKET) {
		std::cerr << "(OGProc)Critical: Cannot create socket." << std::endl;
		#ifdef CIS_WINDOWS
		std::cerr << "(OGProc)Critical: WinSock reported: " << WSAGetLastError() << std::endl;
		WSACleanup();
		#endif
		std::cerr << "(OGProc)Cannot connect to LFS" << std::endl;
		return false;
	}

	// Bind to receive UDP packets.
	sockaddr_in saddr;
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = inet_addr(ipAddr);
	saddr.sin_port = htons(port);
	if (bind(ogSock, (sockaddr *)&saddr, sizeof(sockaddr)) == SOCKET_ERROR) {
		std::cerr << "(OGProc)Critical: Cannot bind socket" << std::endl;
		#ifdef CIS_LINUX
		close(ogSock);
		#endif
		#ifdef CIS_WINDOWS
		std::cerr << "(OGProc)Critical: WinSock reported: " << WSAGetLastError() << std::endl;
		closesocket(ogSock);
		WSACleanup();
		#endif
		std::cerr << "(OGProc)Cannot connect to LFS" << std::endl;
		return false;
	}

	std::cout << "(OGProc)Note: Connected to OutGauge" << std::endl;
  
	return true;  
}

/** The loop which recieves packets
 * from OutGauge
 */
void OutGaugeProcess::recieveOutGaugePackets()
{
	char recvbuf[BUFFER_SIZE];
	memset(recvbuf, 0, sizeof(recvbuf)); // Set recvbuf to zero.
	int bytes = 0;
 
	while(true) {
		bytes = recv(ogSock, recvbuf, BUFFER_SIZE, 0);
		if (bytes == 92 || bytes == 96)
			processPacket((OutGaugePack&)recvbuf);
		else if (bytes == 0) {
			std::cerr << "(OGProc)Critical: Lost connection to OutGauge" << std::endl;
			break;
		} else	{
			std::cerr << "(OGProc)Critical: Unknown error" << std::endl;
			break;
		} 
	}

	// Cleanup and exit.
	#ifdef CIS_LINUX
	close(ogSock);
	#endif
	#ifdef CIS_WINDOWS
	closesocket(ogSock);
	WSACleanup();
	#endif
};


/** Reads the OutGauge packet
 * and hands needed data over to FuelDataProcess
 */
void OutGaugeProcess::processPacket(OutGaugePack& packet)
{
	fDProc->process(packet.Fuel, packet.Speed, packet.Time, packet.Car, packet.PLID);
}