#ifndef _FUELDATAPROCESS_H
#define _FUELDATAPROCESS_H

#include "carfueldata.h"
#include "cinsim.h"
#include "confighandler.h"
#include "externaloutput.h"
#include <map>

#define UNITS_METRIC 0
#define UNITS_IMPERIAL 1
#define UNITS_US 2

#define MODE_INSTANT 0
#define MODE_AVERAGE 1
#define MODE_RANGE 2
#define MODE_PER_HOUR 3

class FuelDataProcess
{
  public:
	byte activePlid;		//PLID received in the last packet

	FuelDataProcess(CInsim*, ConfigHandler*);
	~FuelDataProcess();
	void process(const float, const float, const unsigned int, char* const, const byte);
	void incomingEvent(byte);
	void reInitPlr(byte);
	void reInitFull();
	void toggleUnits();
	void toggleMode();
    
  private:
	CInsim* inSim;
	pthread_mutex_t mapMutex;
	ConfigHandler* cfgHdl;
	ExternalOutput extOut;
	
	std::map<byte, CarFuelData*> carFD;
	std::map<byte, CarFuelData*>::iterator it;
	
	float deltaTime;		//Time difference between two last updates
	float deltaFuel;		//Fuel level difference between two last updates
	float deltaS;			//Distance traveled between two last updates
	char locCarID[4];		//Local copy of Car ID from OutGauge packet
    
	char* consUnitsDesc[3];
	char* consPHUnitsDesc[3];
	char* distUnitsDesc[3];
    
	//Button
	struct IS_BTN is_dispOutputBtn;
	struct IS_BTN is_switchUnitsBtn;
	struct IS_BTN is_switchModeBtn;
	struct IS_BTN is_resetAverageBtn;
	struct IS_BTN is_dispConfigBtn;
	struct IS_BTN is_upBtn;
	struct IS_BTN is_downBtn;
	struct IS_BTN is_leftBtn;
	struct IS_BTN is_rightBtn;
	struct IS_BTN is_backBtn;
    
	//Button functions
	struct IS_BFN is_delModeBtn;
	struct IS_BFN is_delResetBtn;
	struct IS_BFN is_delConfigBtn;
	struct IS_BFN is_delUpBtn;
	struct IS_BFN is_delDownBtn;
	struct IS_BFN is_delLeftBtn;
	struct IS_BFN is_delRightBtn;
	struct IS_BFN is_delUnitsBtn;
	struct IS_BFN is_delBackBtn;
	struct IS_BFN is_delAllBtn;
    
	short units;
	short mode;
    
	enum eventTypes {EV_TOGGLEUNITS,
		     EV_TOGGLEMODE,
		     EV_RESETAVG,
		     EV_DISPCONFIG,
		     EV_UP,
		     EV_DOWN,
		     EV_LEFT,
		     EV_RIGHT,
		     EV_BACK};
    
	const float convertCons(const float);
	const float convertVolume(const float);
	const float convertDistance(const float);
	void displayData(CarFuelData* const);
	float getTankVolume(char*);
	void sendConfigButtons();
	void sendControlButtons();
	void recalcButtonsPos();
};

#endif