#include "externaloutput.h"

ExternalOutput::ExternalOutput()
{
}

/** Attempts to initialize and display
*   the output window.*/
void ExternalOutput::displayWindow(void* inPtr)
{
#ifdef CIS_WINDOWS
	outWnd = new Win32Wnd(inPtr);
	outWnd->createWindow();
#endif
#ifdef CIS_LINUX
	outWnd = new GtkWnd();
	outWnd->createWindow();
#endif
}

/** Checks if the output window is opened.*/
bool ExternalOutput::checkState()
{
	return outWnd->checkState();
}

/**Passes new data to be displayed
*  to the window.*/
void ExternalOutput::updateData()
{
	outWnd->updateData(outputText);
}

ExternalOutput::~ExternalOutput()
{
	delete outWnd;
}

