// EconoMeter.cpp : Defines the entry point for the console application.
//
#include "outgaugeprocess.h"
#include "confighandler.h"


//Declare global variables
CInsim inSim;
ConfigHandler cfgHdl;
FuelDataProcess* fDProc = 0;
pthread_t p_outGaugeThread;

char* ipAddress_mbs;
char* adminPass_mbs;

//Thread for recieving OutGauge packets
void* recieveOutGaugePackets(void*)
{
	fDProc = new FuelDataProcess(&inSim, &cfgHdl);
	OutGaugeProcess ogProc((word)cfgHdl.outGaugePort, fDProc);
	if(!ogProc.initConnection()) {
		std::cerr << "(Main)Error: Error while initializing connection to OutGauge" << std::endl;
		std::cerr << "Bailing out!" << std::endl;
		exit(FAIL);
	}

	ogProc.recieveOutGaugePackets();
	return 0;
}


//Clean up and quit
void closeApp()
{
	pthread_cancel(p_outGaugeThread);
    if(fDProc != 0)
	delete fDProc;

    inSim.isclose();

    system("pause");
}   

int main(int argc, char** argv)
{
	//Greet the user:)
	std::cout << IS_PRODUCT_NAME << " ver.: " << VER_NUM << " " << "\'" CODENAME << "\' launching..." << std::endl;

	cfgHdl.loadConfigFile();

	//Convert IP address and adminPass to char
	ipAddress_mbs = new char[cfgHdl.ipAddress.length()+1];
	adminPass_mbs = new char[cfgHdl.adminPass.length()+1];
	wcstombs(ipAddress_mbs, cfgHdl.ipAddress.c_str(), cfgHdl.ipAddress.length()+1);
	wcstombs(adminPass_mbs, cfgHdl.adminPass.c_str(), cfgHdl.adminPass.length()+1);
  
	//Tell the user what he's actually told the app to do
	std::cout << "Connecting to LFS..." << std::endl;
	std::cout << "IP: " << ipAddress_mbs << std::endl;
	std::cout << "InSim port: " << cfgHdl.inSimPort << std::endl;
	std::cout << "OutGauge port: " << cfgHdl.outGaugePort << std::endl;
	std::cout << "Update rate(msecs): " << cfgHdl.updateSpeed << std::endl;
	std::cout << "Admin pass: " ;
	if(strcmp(adminPass_mbs, "") == 0)
		std::cout << "(empty)";
	else
		std::cout << "->" << adminPass_mbs << "<-";
  
	std::cout << std::endl;

	struct IS_VER is_Version;

	//Try to connect to InSim, retry up to 10 times if unsuccessful
	char attempts = 0;
	while(true) {
		if(inSim.init(ipAddress_mbs, (word)cfgHdl.inSimPort, IS_PRODUCT_NAME, adminPass_mbs, &is_Version, '!', ISF_LOCAL, cfgHdl.updateSpeed, 0) == FAIL) {
			std::cerr << "(Main)Error: Cannot connect to InSim!" << std::endl;
			std::cerr << "(Main)Note: Retrying in 2 seconds" << std::endl;
      
			//Multiplatformity strikes again...
			#ifdef CIS_LINUX
			sleep(2);
			#endif
			#ifdef CIS_WINDOWS
			Sleep(2000);
			#endif

			attempts++;
			if(attempts >= 10) {
				std::wcerr << "(Main)Critical: Connection to InSim could not be established!" << std::endl;
				std::wcerr << "Bailing out!" << std::endl;
				closeApp();
				return EXIT_FAIL;
			}
		} else
			 break;
	}
  
	//Init successful, print info about LFS and InSim version to verify that all went well
	std::wcout << "Connected to LFS " << is_Version.Version <<". InSim version " << is_Version.InSimVer << std::endl;
  
	//Check InSim version, if not 4 or 5, inform the user of possible problems
	if(is_Version.InSimVer < EC_INSIM_VER_MIN || is_Version.InSimVer > EC_INSIM_VER_MAX)
		std::wcout << "(Main)Warning: Unsupported InSim version detected! Econometer might not work properly." << std::endl;
  
	//No need for any fancy stuff, so let's go straight to UDP thread creation
	//Start OutGauge thread
	int outGaugeThread;
	if((outGaugeThread = pthread_create(&p_outGaugeThread, NULL, &recieveOutGaugePackets, NULL)) == FAIL) {
		std::wcerr << "(Main)Critical: Cannot start OutGauge thread!" << std::endl;
		std::wcerr << "Bailing out." << std::endl;
		closeApp();
		return EXIT_FAIL;
	}
  
	//Main loop for receiving InSim packets
	int tcpPacketType;
	bool canRun = true;
	while(canRun) {
		if(inSim.next_packet() == FAIL) {
			std::cerr << "(Main)Critical: Error getting next TCP packet." << std::endl;
			std::cerr << "Bailing out" << std::endl;
			closeApp();
			return EXIT_FAIL;
		}

		tcpPacketType = inSim.peek_packet();
		if(tcpPacketType == ISP_BTC) {	//Button clicked, handle the event
			struct IS_BTC* is_btnClicked = (struct IS_BTC*)inSim.get_packet();
			fDProc->incomingEvent(is_btnClicked->ClickID);
		}
		else if(tcpPacketType == ISP_CRS) {	//Car reset, reset the counter
			struct IS_CRS* is_Crs = (struct IS_CRS*)inSim.get_packet();
			fDProc->reInitPlr(is_Crs->PLID);
		}
		else if(tcpPacketType == ISP_RST) {	//Race (re)started, reset the counter
			fDProc->reInitFull();
		}
		else if(tcpPacketType == ISP_PLL) {	//Player left race, remove his/her consumption data
			struct IS_PLL* is_Pll = (struct IS_PLL*)inSim.get_packet();
			fDProc->reInitPlr(is_Pll->PLID);
		}
	}
  
	closeApp();
	return EXIT_OK;
}
