<?php
require_once('enc.php');

class CP936 implements Encoding
{
	public static function encode($utf8string)
	{
		$cp936encoded = '';
		$end = strlen($utf8string);

		for($i = 0; $i < $end;)
		{
			$ordv = ord($utf8string[$i]);

			// ASCII range, single byte
			if($ordv < 0x80)
			{
				$cp936encoded .= self::$encode_map[$utf8string[$i]];
				++$i;
			}

			// Multibyte
			else
			{
				$bytes = 2; // UTF-8 multibyte sequences are at least 2 byte wide
				for($j = 32; $ordv & $j; $j = $j >> 1)
				{
					++$bytes;
				}
				$cp936encoded .= self::$encode_map[substr($utf8string, $i, $bytes)];
				$i += $bytes;
			}
		}

		return $cp936encoded;
	}
	public static function decode($cp936string)
	{
		$utf8encoded = '';
		$end = strlen($cp936string);

		for($i = 0; $i < $end;)
		{
			$ordv = ord($cp936string[$i]);

			// ASCII range + -symbol, single byte
			if($ordv <= 0x80)
			{
				$utf8encoded .= self::$decode_map[$cp936string[$i]];
				++$i;
			}
			else
			{
				$utf8encoded .= self::$decode_map[substr($cp936string, $i, 2)];
				$i += 2;
			}
		}

		return $utf8encoded;
	}

	public static function contains($chr, $utf8=false)
	{
		return ($utf8 ? isset(self::$encode_map[$chr]) : isset(self::$decode_map[$chr]));
	}

	private static $encode_map = array(
		"\x00"		=> "\x00",	//NULL
		"\x01"		=> "\x01",	//START OF HEADING
		"\x02"		=> "\x02",	//START OF TEXT
		"\x03"		=> "\x03",	//END OF TEXT
		"\x04"		=> "\x04",	//END OF TRANSMISSION
		"\x05"		=> "\x05",	//ENQUIRY
		"\x06"		=> "\x06",	//ACKNOWLEDGE
		"\x07"		=> "\x07",	//BELL
		"\x08"		=> "\x08",	//BACKSPACE
		"\x09"		=> "\x09",	//HORIZONTAL TABULATION
		"\x0a"		=> "\x0a",	//LINE FEED
		"\x0b"		=> "\x0b",	//VERTICAL TABULATION
		"\x0c"		=> "\x0c",	//FORM FEED
		"\x0d"		=> "\x0d",	//CARRIAGE RETURN
		"\x0e"		=> "\x0e",	//SHIFT OUT
		"\x0f"		=> "\x0f",	//SHIFT IN
		"\x10"		=> "\x10",	//DATA LINK ESCAPE
		"\x11"		=> "\x11",	//DEVICE CONTROL ONE
		"\x12"		=> "\x12",	//DEVICE CONTROL TWO
		"\x13"		=> "\x13",	//DEVICE CONTROL THREE
		"\x14"		=> "\x14",	//DEVICE CONTROL FOUR
		"\x15"		=> "\x15",	//NEGATIVE ACKNOWLEDGE
		"\x16"		=> "\x16",	//SYNCHRONOUS IDLE
		"\x17"		=> "\x17",	//END OF TRANSMISSION BLOCK
		"\x18"		=> "\x18",	//CANCEL
		"\x19"		=> "\x19",	//END OF MEDIUM
		"\x1a"		=> "\x1a",	//SUBSTITUTE
		"\x1b"		=> "\x1b",	//ESCAPE
		"\x1c"		=> "\x1c",	//FILE SEPARATOR
		"\x1d"		=> "\x1d",	//GROUP SEPARATOR
		"\x1e"		=> "\x1e",	//RECORD SEPARATOR
		"\x1f"		=> "\x1f",	//UNIT SEPARATOR
		"\x20"		=> "\x20",	//SPACE
		"\x21"		=> "\x21",	//EXCLAMATION MARK
		"\x22"		=> "\x22",	//QUOTATION MARK
		"\x23"		=> "\x23",	//NUMBER SIGN
		"\x24"		=> "\x24",	//DOLLAR SIGN
		"\x25"		=> "\x25",	//PERCENT SIGN
		"\x26"		=> "\x26",	//AMPERSAND
		"\x27"		=> "\x27",	//APOSTROPHE
		"\x28"		=> "\x28",	//LEFT PARENTHESIS
		"\x29"		=> "\x29",	//RIGHT PARENTHESIS
		"\x2a"		=> "\x2a",	//ASTERISK
		"\x2b"		=> "\x2b",	//PLUS SIGN
		"\x2c"		=> "\x2c",	//COMMA
		"\x2d"		=> "\x2d",	//HYPHEN-MINUS
		"\x2e"		=> "\x2e",	//FULL STOP
		"\x2f"		=> "\x2f",	//SOLIDUS
		"\x30"		=> "\x30",	//DIGIT ZERO
		"\x31"		=> "\x31",	//DIGIT ONE
		"\x32"		=> "\x32",	//DIGIT TWO
		"\x33"		=> "\x33",	//DIGIT THREE
		"\x34"		=> "\x34",	//DIGIT FOUR
		"\x35"		=> "\x35",	//DIGIT FIVE
		"\x36"		=> "\x36",	//DIGIT SIX
		"\x37"		=> "\x37",	//DIGIT SEVEN
		"\x38"		=> "\x38",	//DIGIT EIGHT
		"\x39"		=> "\x39",	//DIGIT NINE
		"\x3a"		=> "\x3a",	//COLON
		"\x3b"		=> "\x3b",	//SEMICOLON
		"\x3c"		=> "\x3c",	//LESS-THAN SIGN
		"\x3d"		=> "\x3d",	//EQUALS SIGN
		"\x3e"		=> "\x3e",	//GREATER-THAN SIGN
		"\x3f"		=> "\x3f",	//QUESTION MARK
		"\x40"		=> "\x40",	//COMMERCIAL AT
		"\x41"		=> "\x41",	//LATIN CAPITAL LETTER A
		"\x42"		=> "\x42",	//LATIN CAPITAL LETTER B
		"\x43"		=> "\x43",	//LATIN CAPITAL LETTER C
		"\x44"		=> "\x44",	//LATIN CAPITAL LETTER D
		"\x45"		=> "\x45",	//LATIN CAPITAL LETTER E
		"\x46"		=> "\x46",	//LATIN CAPITAL LETTER F
		"\x47"		=> "\x47",	//LATIN CAPITAL LETTER G
		"\x48"		=> "\x48",	//LATIN CAPITAL LETTER H
		"\x49"		=> "\x49",	//LATIN CAPITAL LETTER I
		"\x4a"		=> "\x4a",	//LATIN CAPITAL LETTER J
		"\x4b"		=> "\x4b",	//LATIN CAPITAL LETTER K
		"\x4c"		=> "\x4c",	//LATIN CAPITAL LETTER L
		"\x4d"		=> "\x4d",	//LATIN CAPITAL LETTER M
		"\x4e"		=> "\x4e",	//LATIN CAPITAL LETTER N
		"\x4f"		=> "\x4f",	//LATIN CAPITAL LETTER O
		"\x50"		=> "\x50",	//LATIN CAPITAL LETTER P
		"\x51"		=> "\x51",	//LATIN CAPITAL LETTER Q
		"\x52"		=> "\x52",	//LATIN CAPITAL LETTER R
		"\x53"		=> "\x53",	//LATIN CAPITAL LETTER S
		"\x54"		=> "\x54",	//LATIN CAPITAL LETTER T
		"\x55"		=> "\x55",	//LATIN CAPITAL LETTER U
		"\x56"		=> "\x56",	//LATIN CAPITAL LETTER V
		"\x57"		=> "\x57",	//LATIN CAPITAL LETTER W
		"\x58"		=> "\x58",	//LATIN CAPITAL LETTER X
		"\x59"		=> "\x59",	//LATIN CAPITAL LETTER Y
		"\x5a"		=> "\x5a",	//LATIN CAPITAL LETTER Z
		"\x5b"		=> "\x5b",	//LEFT SQUARE BRACKET
		"\x5c"		=> "\x5c",	//REVERSE SOLIDUS
		"\x5d"		=> "\x5d",	//RIGHT SQUARE BRACKET
		"\x5e"		=> "\x5e",	//CIRCUMFLEX ACCENT
		"\x5f"		=> "\x5f",	//LOW LINE
		"\x60"		=> "\x60",	//GRAVE ACCENT
		"\x61"		=> "\x61",	//LATIN SMALL LETTER A
		"\x62"		=> "\x62",	//LATIN SMALL LETTER B
		"\x63"		=> "\x63",	//LATIN SMALL LETTER C
		"\x64"		=> "\x64",	//LATIN SMALL LETTER D
		"\x65"		=> "\x65",	//LATIN SMALL LETTER E
		"\x66"		=> "\x66",	//LATIN SMALL LETTER F
		"\x67"		=> "\x67",	//LATIN SMALL LETTER G
		"\x68"		=> "\x68",	//LATIN SMALL LETTER H
		"\x69"		=> "\x69",	//LATIN SMALL LETTER I
		"\x6a"		=> "\x6a",	//LATIN SMALL LETTER J
		"\x6b"		=> "\x6b",	//LATIN SMALL LETTER K
		"\x6c"		=> "\x6c",	//LATIN SMALL LETTER L
		"\x6d"		=> "\x6d",	//LATIN SMALL LETTER M
		"\x6e"		=> "\x6e",	//LATIN SMALL LETTER N
		"\x6f"		=> "\x6f",	//LATIN SMALL LETTER O
		"\x70"		=> "\x70",	//LATIN SMALL LETTER P
		"\x71"		=> "\x71",	//LATIN SMALL LETTER Q
		"\x72"		=> "\x72",	//LATIN SMALL LETTER R
		"\x73"		=> "\x73",	//LATIN SMALL LETTER S
		"\x74"		=> "\x74",	//LATIN SMALL LETTER T
		"\x75"		=> "\x75",	//LATIN SMALL LETTER U
		"\x76"		=> "\x76",	//LATIN SMALL LETTER V
		"\x77"		=> "\x77",	//LATIN SMALL LETTER W
		"\x78"		=> "\x78",	//LATIN SMALL LETTER X
		"\x79"		=> "\x79",	//LATIN SMALL LETTER Y
		"\x7a"		=> "\x7a",	//LATIN SMALL LETTER Z
		"\x7b"		=> "\x7b",	//LEFT CURLY BRACKET
		"\x7c"		=> "\x7c",	//VERTICAL LINE
		"\x7d"		=> "\x7d",	//RIGHT CURLY BRACKET
		"\x7e"		=> "\x7e",	//TILDE
		"\x7f"		=> "\x7f",	//DELETE
		"\xe2\x82\xac"		=> "\x80",	//EURO SIGN
		"\xe4\xb8\x82"		=> "\x81\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x84"		=> "\x81\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x85"		=> "\x81\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x86"		=> "\x81\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x8f"		=> "\x81\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x92"		=> "\x81\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x97"		=> "\x81\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x9f"		=> "\x81\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa0"		=> "\x81\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa1"		=> "\x81\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa3"		=> "\x81\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa6"		=> "\x81\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa9"		=> "\x81\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xae"		=> "\x81\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xaf"		=> "\x81\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb1"		=> "\x81\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb3"		=> "\x81\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb5"		=> "\x81\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb7"		=> "\x81\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xbc"		=> "\x81\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x80"		=> "\x81\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x81"		=> "\x81\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x82"		=> "\x81\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x84"		=> "\x81\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x86"		=> "\x81\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x8a"		=> "\x81\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x91"		=> "\x81\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x95"		=> "\x81\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x97"		=> "\x81\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x9a"		=> "\x81\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x9b"		=> "\x81\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa2"		=> "\x81\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa3"		=> "\x81\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa4"		=> "\x81\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa5"		=> "\x81\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa7"		=> "\x81\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa8"		=> "\x81\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xaa"		=> "\x81\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xab"		=> "\x81\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xac"		=> "\x81\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xad"		=> "\x81\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xae"		=> "\x81\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xaf"		=> "\x81\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb2"		=> "\x81\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb4"		=> "\x81\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb5"		=> "\x81\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb6"		=> "\x81\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb7"		=> "\x81\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb8"		=> "\x81\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb9"		=> "\x81\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xba"		=> "\x81\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xbb"		=> "\x81\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xbc"		=> "\x81\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xbd"		=> "\x81\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xbf"		=> "\x81\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x80"		=> "\x81\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x81"		=> "\x81\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x82"		=> "\x81\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x83"		=> "\x81\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x84"		=> "\x81\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x85"		=> "\x81\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x87"		=> "\x81\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x8a"		=> "\x81\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x90"		=> "\x81\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x96"		=> "\x81\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x97"		=> "\x81\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x99"		=> "\x81\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x9c"		=> "\x81\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x9d"		=> "\x81\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x9e"		=> "\x81\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa3"		=> "\x81\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xaa"		=> "\x81\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xaf"		=> "\x81\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb0"		=> "\x81\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb1"		=> "\x81\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb4"		=> "\x81\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb6"		=> "\x81\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb7"		=> "\x81\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb8"		=> "\x81\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb9"		=> "\x81\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xbc"		=> "\x81\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xbd"		=> "\x81\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xbe"		=> "\x81\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x88"		=> "\x81\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x8c"		=> "\x81\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x8f"		=> "\x81\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x90"		=> "\x81\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x92"		=> "\x81\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x9a"		=> "\x81\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x9b"		=> "\x81\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x9c"		=> "\x81\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa0"		=> "\x81\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa2"		=> "\x81\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa6"		=> "\x81\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa7"		=> "\x81\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa9"		=> "\x81\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xad"		=> "\x81\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xae"		=> "\x81\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xaf"		=> "\x81\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb1"		=> "\x81\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb4"		=> "\x81\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb8"		=> "\x81\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb9"		=> "\x81\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xba"		=> "\x81\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xbc"		=> "\x81\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xbe"		=> "\x81\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x80"		=> "\x81\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x82"		=> "\x81\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x83"		=> "\x81\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x84"		=> "\x81\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x85"		=> "\x81\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x86"		=> "\x81\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x87"		=> "\x81\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x88"		=> "\x81\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x8b"		=> "\x81\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x8c"		=> "\x81\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x92"		=> "\x81\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x93"		=> "\x81\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x94"		=> "\x81\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x95"		=> "\x81\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x96"		=> "\x81\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x9c"		=> "\x81\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x9d"		=> "\x81\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa1"		=> "\x81\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa3"		=> "\x81\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa8"		=> "\x81\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa9"		=> "\x81\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xac"		=> "\x81\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xad"		=> "\x81\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xae"		=> "\x81\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb1"		=> "\x81\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb3"		=> "\x81\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb5"		=> "\x81\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb7"		=> "\x81\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb9"		=> "\x81\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xbb"		=> "\x81\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xbe"		=> "\x81\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xbf"		=> "\x81\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x80"		=> "\x81\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x81"		=> "\x81\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x82"		=> "\x81\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x84"		=> "\x81\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x85"		=> "\x81\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x87"		=> "\x81\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x88"		=> "\x81\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x89"		=> "\x81\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x8a"		=> "\x81\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x8b"		=> "\x81\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x8c"		=> "\x81\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x92"		=> "\x81\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x94"		=> "\x81\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x96"		=> "\x81\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa1"		=> "\x81\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa2"		=> "\x81\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa6"		=> "\x81\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa8"		=> "\x81\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xaa"		=> "\x81\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xab"		=> "\x81\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xad"		=> "\x81\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xae"		=> "\x81\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb1"		=> "\x81\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb2"		=> "\x81\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb5"		=> "\x81\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb7"		=> "\x81\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb8"		=> "\x81\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb9"		=> "\x81\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xba"		=> "\x81\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xbd"		=> "\x81\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x80"		=> "\x81\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x81"		=> "\x81\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x82"		=> "\x81\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x85"		=> "\x81\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x86"		=> "\x81\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x87"		=> "\x81\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x8a"		=> "\x81\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x8c"		=> "\x81\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x8e"		=> "\x81\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x90"		=> "\x81\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x92"		=> "\x81\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x93"		=> "\x81\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x95"		=> "\x81\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x96"		=> "\x81\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x98"		=> "\x81\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x99"		=> "\x81\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x9a"		=> "\x81\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x9c"		=> "\x81\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x9e"		=> "\x81\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x9f"		=> "\x81\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa1"		=> "\x81\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa2"		=> "\x81\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa4"		=> "\x82\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xab"		=> "\x82\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xad"		=> "\x82\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb0"		=> "\x82\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb1"		=> "\x82\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb2"		=> "\x82\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb3"		=> "\x82\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb4"		=> "\x82\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb6"		=> "\x82\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb7"		=> "\x82\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb8"		=> "\x82\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb9"		=> "\x82\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xba"		=> "\x82\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xbb"		=> "\x82\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xbc"		=> "\x82\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xbd"		=> "\x82\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xbe"		=> "\x82\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x80"		=> "\x82\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x81"		=> "\x82\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x82"		=> "\x82\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x86"		=> "\x82\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x87"		=> "\x82\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x88"		=> "\x82\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x89"		=> "\x82\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x8b"		=> "\x82\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x8c"		=> "\x82\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x8d"		=> "\x82\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x92"		=> "\x82\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x93"		=> "\x82\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x94"		=> "\x82\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x95"		=> "\x82\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x96"		=> "\x82\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x99"		=> "\x82\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x9b"		=> "\x82\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa0"		=> "\x82\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa2"		=> "\x82\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa4"		=> "\x82\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa5"		=> "\x82\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa7"		=> "\x82\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xab"		=> "\x82\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xac"		=> "\x82\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb0"		=> "\x82\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb2"		=> "\x82\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb4"		=> "\x82\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb5"		=> "\x82\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb6"		=> "\x82\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb7"		=> "\x82\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb9"		=> "\x82\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xbb"		=> "\x82\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xbc"		=> "\x82\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xbd"		=> "\x82\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xbf"		=> "\x82\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x80"		=> "\x82\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x81"		=> "\x82\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x82"		=> "\x82\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x83"		=> "\x82\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x84"		=> "\x82\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x85"		=> "\x82\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x86"		=> "\x82\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x87"		=> "\x82\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x88"		=> "\x82\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x89"		=> "\x82\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x8a"		=> "\x82\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x8b"		=> "\x82\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x8e"		=> "\x82\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x90"		=> "\x82\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x91"		=> "\x82\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x93"		=> "\x82\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x95"		=> "\x82\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x96"		=> "\x82\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x97"		=> "\x82\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x9b"		=> "\x82\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x9d"		=> "\x82\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x9e"		=> "\x82\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa0"		=> "\x82\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa2"		=> "\x82\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa3"		=> "\x82\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa4"		=> "\x82\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa7"		=> "\x82\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xab"		=> "\x82\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xaf"		=> "\x82\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb0"		=> "\x82\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb1"		=> "\x82\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb2"		=> "\x82\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb3"		=> "\x82\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb4"		=> "\x82\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb5"		=> "\x82\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb6"		=> "\x82\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb7"		=> "\x82\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb8"		=> "\x82\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xb9"		=> "\x82\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xbb"		=> "\x82\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xbd"		=> "\x82\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xbf"		=> "\x82\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x80"		=> "\x82\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x81"		=> "\x82\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x82"		=> "\x82\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x84"		=> "\x82\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x85"		=> "\x82\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x86"		=> "\x82\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x89"		=> "\x82\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x8a"		=> "\x82\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x8b"		=> "\x82\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x8d"		=> "\x82\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x90"		=> "\x82\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x91"		=> "\x82\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x92"		=> "\x82\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x93"		=> "\x82\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x94"		=> "\x82\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x96"		=> "\x82\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x97"		=> "\x82\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x98"		=> "\x82\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x99"		=> "\x82\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x9b"		=> "\x82\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x9d"		=> "\x82\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x9e"		=> "\x82\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x9f"		=> "\x82\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa0"		=> "\x82\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa1"		=> "\x82\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa2"		=> "\x82\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa3"		=> "\x82\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa4"		=> "\x82\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa6"		=> "\x82\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa7"		=> "\x82\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa8"		=> "\x82\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa9"		=> "\x82\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xaa"		=> "\x82\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xab"		=> "\x82\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xad"		=> "\x82\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xae"		=> "\x82\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xaf"		=> "\x82\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb0"		=> "\x82\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb1"		=> "\x82\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb2"		=> "\x82\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb3"		=> "\x82\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb4"		=> "\x82\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb5"		=> "\x82\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb8"		=> "\x82\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb9"		=> "\x82\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xba"		=> "\x82\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xbc"		=> "\x82\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xbd"		=> "\x82\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x81"		=> "\x82\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x82"		=> "\x82\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x83"		=> "\x82\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x84"		=> "\x82\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x86"		=> "\x82\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x87"		=> "\x82\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x89"		=> "\x82\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x8a"		=> "\x82\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x8b"		=> "\x82\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x8c"		=> "\x82\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x8e"		=> "\x82\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x8f"		=> "\x82\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x90"		=> "\x82\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x91"		=> "\x82\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x92"		=> "\x82\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x93"		=> "\x82\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x94"		=> "\x82\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x95"		=> "\x82\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x96"		=> "\x82\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x97"		=> "\x82\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x98"		=> "\x82\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x99"		=> "\x82\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x9a"		=> "\x82\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x9b"		=> "\x82\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x9c"		=> "\x82\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x9d"		=> "\x82\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x9e"		=> "\x82\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x9f"		=> "\x82\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa0"		=> "\x82\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa1"		=> "\x82\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa2"		=> "\x82\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa4"		=> "\x82\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa6"		=> "\x82\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xaa"		=> "\x82\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xab"		=> "\x82\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xad"		=> "\x82\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xae"		=> "\x82\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xaf"		=> "\x82\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb0"		=> "\x82\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb1"		=> "\x82\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb3"		=> "\x82\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb4"		=> "\x82\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb5"		=> "\x82\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb6"		=> "\x82\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb7"		=> "\x82\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb8"		=> "\x82\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb9"		=> "\x82\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xbc"		=> "\x82\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xbd"		=> "\x83\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xbe"		=> "\x83\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xbf"		=> "\x83\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x80"		=> "\x83\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x81"		=> "\x83\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x82"		=> "\x83\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x83"		=> "\x83\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x84"		=> "\x83\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x85"		=> "\x83\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x86"		=> "\x83\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x87"		=> "\x83\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x88"		=> "\x83\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x89"		=> "\x83\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x8a"		=> "\x83\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x8b"		=> "\x83\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x8c"		=> "\x83\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x8d"		=> "\x83\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x8e"		=> "\x83\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x90"		=> "\x83\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x91"		=> "\x83\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x92"		=> "\x83\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x93"		=> "\x83\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x94"		=> "\x83\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x95"		=> "\x83\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x97"		=> "\x83\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x98"		=> "\x83\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x99"		=> "\x83\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x9b"		=> "\x83\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x9c"		=> "\x83\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x9d"		=> "\x83\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x9e"		=> "\x83\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x9f"		=> "\x83\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa0"		=> "\x83\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa1"		=> "\x83\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa2"		=> "\x83\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa3"		=> "\x83\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa4"		=> "\x83\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa5"		=> "\x83\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa8"		=> "\x83\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa9"		=> "\x83\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xaa"		=> "\x83\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xab"		=> "\x83\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xaf"		=> "\x83\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb0"		=> "\x83\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb1"		=> "\x83\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb2"		=> "\x83\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb4"		=> "\x83\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb6"		=> "\x83\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb7"		=> "\x83\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb8"		=> "\x83\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb9"		=> "\x83\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xba"		=> "\x83\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xbc"		=> "\x83\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xbd"		=> "\x83\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xbe"		=> "\x83\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xbf"		=> "\x83\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x80"		=> "\x83\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x81"		=> "\x83\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x82"		=> "\x83\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x83"		=> "\x83\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x84"		=> "\x83\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x85"		=> "\x83\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x88"		=> "\x83\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x89"		=> "\x83\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x8a"		=> "\x83\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x8c"		=> "\x83\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x8d"		=> "\x83\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x8e"		=> "\x83\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x8f"		=> "\x83\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x90"		=> "\x83\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x91"		=> "\x83\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x93"		=> "\x83\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x94"		=> "\x83\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x95"		=> "\x83\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x96"		=> "\x83\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x97"		=> "\x83\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x98"		=> "\x83\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x99"		=> "\x83\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x9a"		=> "\x83\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x9b"		=> "\x83\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x9c"		=> "\x83\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x9d"		=> "\x83\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x9e"		=> "\x83\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x9f"		=> "\x83\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa0"		=> "\x83\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa2"		=> "\x83\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa3"		=> "\x83\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa4"		=> "\x83\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa5"		=> "\x83\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa6"		=> "\x83\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa7"		=> "\x83\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa8"		=> "\x83\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa9"		=> "\x83\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xaa"		=> "\x83\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xab"		=> "\x83\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xac"		=> "\x83\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xad"		=> "\x83\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xae"		=> "\x83\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xaf"		=> "\x83\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb0"		=> "\x83\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb1"		=> "\x83\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb2"		=> "\x83\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb3"		=> "\x83\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb4"		=> "\x83\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb5"		=> "\x83\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb6"		=> "\x83\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb7"		=> "\x83\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb8"		=> "\x83\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xb9"		=> "\x83\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xba"		=> "\x83\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xbb"		=> "\x83\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xbc"		=> "\x83\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xbd"		=> "\x83\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xbe"		=> "\x83\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x82"		=> "\x83\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x87"		=> "\x83\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x8a"		=> "\x83\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x8c"		=> "\x83\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x8e"		=> "\x83\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x8f"		=> "\x83\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x90"		=> "\x83\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x92"		=> "\x83\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x93"		=> "\x83\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x97"		=> "\x83\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x98"		=> "\x83\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x99"		=> "\x83\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x9b"		=> "\x83\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x9d"		=> "\x83\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x9e"		=> "\x83\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x9f"		=> "\x83\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa0"		=> "\x83\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa1"		=> "\x83\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa3"		=> "\x83\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa4"		=> "\x83\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa6"		=> "\x83\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa7"		=> "\x83\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa9"		=> "\x83\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xaa"		=> "\x83\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xaf"		=> "\x83\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb2"		=> "\x83\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xba"		=> "\x83\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xbe"		=> "\x83\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xbf"		=> "\x83\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x83"		=> "\x83\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x84"		=> "\x83\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x86"		=> "\x83\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x87"		=> "\x83\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x8a"		=> "\x83\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x8b"		=> "\x83\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x8e"		=> "\x83\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x8f"		=> "\x83\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x90"		=> "\x83\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x91"		=> "\x83\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x93"		=> "\x83\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x94"		=> "\x83\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x98"		=> "\x83\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x9a"		=> "\x83\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x9d"		=> "\x83\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x9e"		=> "\x83\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x9f"		=> "\x83\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa1"		=> "\x83\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa3"		=> "\x83\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa6"		=> "\x83\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa7"		=> "\x83\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa8"		=> "\x83\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa9"		=> "\x83\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xaa"		=> "\x83\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xad"		=> "\x83\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xae"		=> "\x83\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb4"		=> "\x83\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb8"		=> "\x83\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb9"		=> "\x83\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xba"		=> "\x83\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xbe"		=> "\x83\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xbf"		=> "\x83\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x81"		=> "\x83\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x82"		=> "\x83\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x83"		=> "\x83\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x85"		=> "\x83\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x88"		=> "\x83\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x8a"		=> "\x83\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x8d"		=> "\x83\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x8e"		=> "\x83\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x90"		=> "\x83\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x92"		=> "\x83\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x93"		=> "\x83\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x94"		=> "\x83\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x95"		=> "\x83\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x96"		=> "\x83\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x97"		=> "\x83\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x98"		=> "\x84\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x99"		=> "\x84\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x9a"		=> "\x84\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x9c"		=> "\x84\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x9e"		=> "\x84\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x9f"		=> "\x84\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa2"		=> "\x84\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa3"		=> "\x84\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa5"		=> "\x84\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa6"		=> "\x84\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa7"		=> "\x84\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa8"		=> "\x84\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa9"		=> "\x84\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xaa"		=> "\x84\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xac"		=> "\x84\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xae"		=> "\x84\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb1"		=> "\x84\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb2"		=> "\x84\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb4"		=> "\x84\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb7"		=> "\x84\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xbe"		=> "\x84\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x84"		=> "\x84\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x85"		=> "\x84\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x89"		=> "\x84\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x8b"		=> "\x84\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x8c"		=> "\x84\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x8f"		=> "\x84\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x90"		=> "\x84\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x93"		=> "\x84\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x94"		=> "\x84\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x95"		=> "\x84\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x9c"		=> "\x84\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x9e"		=> "\x84\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x9f"		=> "\x84\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa1"		=> "\x84\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa2"		=> "\x84\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa3"		=> "\x84\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa5"		=> "\x84\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa6"		=> "\x84\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa7"		=> "\x84\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xaa"		=> "\x84\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xac"		=> "\x84\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xaf"		=> "\x84\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb1"		=> "\x84\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb2"		=> "\x84\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb4"		=> "\x84\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb5"		=> "\x84\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xbc"		=> "\x84\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xbe"		=> "\x84\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x84"		=> "\x84\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x85"		=> "\x84\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x86"		=> "\x84\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x87"		=> "\x84\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x88"		=> "\x84\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x89"		=> "\x84\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x8b"		=> "\x84\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x8e"		=> "\x84\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x8f"		=> "\x84\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x92"		=> "\x84\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x93"		=> "\x84\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x95"		=> "\x84\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x97"		=> "\x84\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x98"		=> "\x84\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x99"		=> "\x84\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x9a"		=> "\x84\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x9b"		=> "\x84\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x9d"		=> "\x84\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x9f"		=> "\x84\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa0"		=> "\x84\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa2"		=> "\x84\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa3"		=> "\x84\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa4"		=> "\x84\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa6"		=> "\x84\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa8"		=> "\x84\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xab"		=> "\x84\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xac"		=> "\x84\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xad"		=> "\x84\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xae"		=> "\x84\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb0"		=> "\x84\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb1"		=> "\x84\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb3"		=> "\x84\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb4"		=> "\x84\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb5"		=> "\x84\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb6"		=> "\x84\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb7"		=> "\x84\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb8"		=> "\x84\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb9"		=> "\x84\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xba"		=> "\x84\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xbb"		=> "\x84\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xbc"		=> "\x84\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xbe"		=> "\x84\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x80"		=> "\x84\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x83"		=> "\x84\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x84"		=> "\x84\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x85"		=> "\x84\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x86"		=> "\x84\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x87"		=> "\x84\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x89"		=> "\x84\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x8a"		=> "\x84\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x8b"		=> "\x84\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x8c"		=> "\x84\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x8d"		=> "\x84\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x8e"		=> "\x84\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x8f"		=> "\x84\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x91"		=> "\x84\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x92"		=> "\x84\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x94"		=> "\x84\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x95"		=> "\x84\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x96"		=> "\x84\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x97"		=> "\x84\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x98"		=> "\x84\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x99"		=> "\x84\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x9a"		=> "\x84\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x9c"		=> "\x84\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa4"		=> "\x84\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa5"		=> "\x84\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa6"		=> "\x84\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa7"		=> "\x84\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xae"		=> "\x84\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xaf"		=> "\x84\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb0"		=> "\x84\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb4"		=> "\x84\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb5"		=> "\x84\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb6"		=> "\x84\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb7"		=> "\x84\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb8"		=> "\x84\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb9"		=> "\x84\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xba"		=> "\x84\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xbb"		=> "\x84\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xbc"		=> "\x84\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xbd"		=> "\x84\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x80"		=> "\x84\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x81"		=> "\x84\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x82"		=> "\x84\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x84"		=> "\x84\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x85"		=> "\x84\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x86"		=> "\x84\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x88"		=> "\x84\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x8a"		=> "\x84\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x8c"		=> "\x84\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x8d"		=> "\x84\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x8e"		=> "\x84\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x8f"		=> "\x84\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x91"		=> "\x84\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x93"		=> "\x84\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x94"		=> "\x84\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x95"		=> "\x84\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x97"		=> "\x84\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x99"		=> "\x84\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x9a"		=> "\x84\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x9b"		=> "\x84\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x9c"		=> "\x84\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x9d"		=> "\x84\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x9e"		=> "\x84\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa0"		=> "\x84\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa1"		=> "\x84\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa2"		=> "\x84\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa3"		=> "\x84\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa5"		=> "\x84\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa6"		=> "\x84\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa7"		=> "\x84\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa8"		=> "\x84\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa9"		=> "\x84\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xaa"		=> "\x84\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xab"		=> "\x84\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xac"		=> "\x84\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xad"		=> "\x84\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xae"		=> "\x84\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xaf"		=> "\x84\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb1"		=> "\x84\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb2"		=> "\x84\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb3"		=> "\x84\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb4"		=> "\x84\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb5"		=> "\x84\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb6"		=> "\x84\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb7"		=> "\x84\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb8"		=> "\x84\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xbb"		=> "\x84\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xbc"		=> "\x84\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xbd"		=> "\x84\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x81"		=> "\x84\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x82"		=> "\x84\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x83"		=> "\x84\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x84"		=> "\x84\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x87"		=> "\x84\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x89"		=> "\x84\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x8a"		=> "\x84\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x8b"		=> "\x84\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x8c"		=> "\x84\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x8e"		=> "\x84\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x91"		=> "\x85\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x92"		=> "\x85\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x93"		=> "\x85\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x94"		=> "\x85\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x98"		=> "\x85\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x9b"		=> "\x85\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x9c"		=> "\x85\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x9e"		=> "\x85\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x9f"		=> "\x85\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa2"		=> "\x85\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa4"		=> "\x85\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa5"		=> "\x85\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa7"		=> "\x85\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa8"		=> "\x85\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa9"		=> "\x85\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xab"		=> "\x85\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xac"		=> "\x85\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xad"		=> "\x85\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xaf"		=> "\x85\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb0"		=> "\x85\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb1"		=> "\x85\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb2"		=> "\x85\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb3"		=> "\x85\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb4"		=> "\x85\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb5"		=> "\x85\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb6"		=> "\x85\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb7"		=> "\x85\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb8"		=> "\x85\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xbc"		=> "\x85\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xbd"		=> "\x85\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x80"		=> "\x85\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x82"		=> "\x85\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x84"		=> "\x85\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x86"		=> "\x85\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x8b"		=> "\x85\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x8c"		=> "\x85\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x8d"		=> "\x85\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x90"		=> "\x85\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x94"		=> "\x85\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x98"		=> "\x85\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x99"		=> "\x85\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x9b"		=> "\x85\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x9d"		=> "\x85\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa5"		=> "\x85\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa8"		=> "\x85\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xaa"		=> "\x85\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xac"		=> "\x85\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xad"		=> "\x85\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb2"		=> "\x85\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb6"		=> "\x85\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb9"		=> "\x85\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xbb"		=> "\x85\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xbc"		=> "\x85\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xbd"		=> "\x85\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xbe"		=> "\x85\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x80"		=> "\x85\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x81"		=> "\x85\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x83"		=> "\x85\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x87"		=> "\x85\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x88"		=> "\x85\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x8a"		=> "\x85\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x8e"		=> "\x85\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x8f"		=> "\x85\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x90"		=> "\x85\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x91"		=> "\x85\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x92"		=> "\x85\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x93"		=> "\x85\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x94"		=> "\x85\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x96"		=> "\x85\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x97"		=> "\x85\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x99"		=> "\x85\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x9b"		=> "\x85\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x9c"		=> "\x85\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x9e"		=> "\x85\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa0"		=> "\x85\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa1"		=> "\x85\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa4"		=> "\x85\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa7"		=> "\x85\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xaa"		=> "\x85\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xab"		=> "\x85\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xac"		=> "\x85\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xad"		=> "\x85\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xaf"		=> "\x85\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb0"		=> "\x85\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb1"		=> "\x85\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb2"		=> "\x85\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb3"		=> "\x85\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb4"		=> "\x85\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb5"		=> "\x85\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb7"		=> "\x85\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb8"		=> "\x85\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb9"		=> "\x85\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xba"		=> "\x85\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xbc"		=> "\x85\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xbd"		=> "\x85\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xbe"		=> "\x85\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x80"		=> "\x85\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x83"		=> "\x85\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x84"		=> "\x85\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x85"		=> "\x85\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x86"		=> "\x85\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x87"		=> "\x85\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x8e"		=> "\x85\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x8f"		=> "\x85\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x90"		=> "\x85\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x92"		=> "\x85\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x93"		=> "\x85\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x95"		=> "\x85\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x9a"		=> "\x85\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x9c"		=> "\x85\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x9d"		=> "\x85\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x9e"		=> "\x85\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa1"		=> "\x85\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa2"		=> "\x85\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa7"		=> "\x85\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb4"		=> "\x85\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xba"		=> "\x85\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xbe"		=> "\x85\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xbf"		=> "\x85\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x80"		=> "\x85\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x82"		=> "\x85\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x85"		=> "\x85\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x87"		=> "\x85\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x8b"		=> "\x85\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x94"		=> "\x85\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x98"		=> "\x85\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x99"		=> "\x85\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x9a"		=> "\x85\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x9c"		=> "\x85\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa2"		=> "\x85\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa4"		=> "\x85\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa5"		=> "\x85\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xaa"		=> "\x85\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb0"		=> "\x85\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb3"		=> "\x85\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb6"		=> "\x85\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb7"		=> "\x85\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xba"		=> "\x85\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xbd"		=> "\x85\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xbf"		=> "\x85\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x81"		=> "\x85\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x82"		=> "\x85\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x84"		=> "\x85\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x85"		=> "\x85\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x87"		=> "\x85\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x89"		=> "\x85\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x8c"		=> "\x85\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x8d"		=> "\x85\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x8e"		=> "\x85\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x8f"		=> "\x85\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x91"		=> "\x85\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x9a"		=> "\x85\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x9d"		=> "\x85\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x9e"		=> "\x85\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x9f"		=> "\x85\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa0"		=> "\x85\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa1"		=> "\x85\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa3"		=> "\x85\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa5"		=> "\x85\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa7"		=> "\x85\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa9"		=> "\x85\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xaa"		=> "\x85\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xab"		=> "\x85\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xac"		=> "\x85\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xad"		=> "\x85\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xae"		=> "\x85\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xaf"		=> "\x85\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb0"		=> "\x85\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb4"		=> "\x85\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb9"		=> "\x85\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xba"		=> "\x85\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xbe"		=> "\x85\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xbf"		=> "\x85\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x81"		=> "\x85\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x83"		=> "\x85\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x85"		=> "\x85\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x87"		=> "\x85\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x88"		=> "\x85\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x89"		=> "\x85\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x8a"		=> "\x85\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x8d"		=> "\x85\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x91"		=> "\x85\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x93"		=> "\x85\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x97"		=> "\x85\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x98"		=> "\x85\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x9c"		=> "\x85\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x9e"		=> "\x85\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x9f"		=> "\x85\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa0"		=> "\x85\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa1"		=> "\x85\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa2"		=> "\x86\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa5"		=> "\x86\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xae"		=> "\x86\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb0"		=> "\x86\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb2"		=> "\x86\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb5"		=> "\x86\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb6"		=> "\x86\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb7"		=> "\x86\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb9"		=> "\x86\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xba"		=> "\x86\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xbc"		=> "\x86\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xbe"		=> "\x86\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x83"		=> "\x86\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x85"		=> "\x86\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x8a"		=> "\x86\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x8b"		=> "\x86\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x96"		=> "\x86\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x98"		=> "\x86\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x9b"		=> "\x86\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa0"		=> "\x86\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa1"		=> "\x86\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa2"		=> "\x86\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa3"		=> "\x86\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa4"		=> "\x86\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xab"		=> "\x86\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xac"		=> "\x86\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xaf"		=> "\x86\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb0"		=> "\x86\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb1"		=> "\x86\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb4"		=> "\x86\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb5"		=> "\x86\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb6"		=> "\x86\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb7"		=> "\x86\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb8"		=> "\x86\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb9"		=> "\x86\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xbb"		=> "\x86\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xbe"		=> "\x86\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x80"		=> "\x86\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x82"		=> "\x86\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x83"		=> "\x86\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x84"		=> "\x86\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x85"		=> "\x86\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x88"		=> "\x86\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x8a"		=> "\x86\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x8b"		=> "\x86\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x8c"		=> "\x86\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x8d"		=> "\x86\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x8e"		=> "\x86\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x92"		=> "\x86\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x93"		=> "\x86\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x95"		=> "\x86\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x96"		=> "\x86\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x97"		=> "\x86\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x98"		=> "\x86\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x99"		=> "\x86\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x9a"		=> "\x86\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x9c"		=> "\x86\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x9d"		=> "\x86\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x9e"		=> "\x86\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x9f"		=> "\x86\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa1"		=> "\x86\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa5"		=> "\x86\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa6"		=> "\x86\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa8"		=> "\x86\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa9"		=> "\x86\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xab"		=> "\x86\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xad"		=> "\x86\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb2"		=> "\x86\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb4"		=> "\x86\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb5"		=> "\x86\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb6"		=> "\x86\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb8"		=> "\x86\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb9"		=> "\x86\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xba"		=> "\x86\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xbb"		=> "\x86\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xbd"		=> "\x86\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x80"		=> "\x86\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x82"		=> "\x86\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x85"		=> "\x86\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x87"		=> "\x86\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x88"		=> "\x86\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x8b"		=> "\x86\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x8c"		=> "\x86\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x8d"		=> "\x86\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x8e"		=> "\x86\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x8f"		=> "\x86\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x91"		=> "\x86\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x92"		=> "\x86\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x93"		=> "\x86\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x94"		=> "\x86\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x97"		=> "\x86\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x98"		=> "\x86\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x99"		=> "\x86\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x9a"		=> "\x86\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x9b"		=> "\x86\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x9d"		=> "\x86\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x9e"		=> "\x86\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x9f"		=> "\x86\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa0"		=> "\x86\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa2"		=> "\x86\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa3"		=> "\x86\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa8"		=> "\x86\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa9"		=> "\x86\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xab"		=> "\x86\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xaf"		=> "\x86\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb0"		=> "\x86\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb1"		=> "\x86\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb2"		=> "\x86\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb3"		=> "\x86\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb4"		=> "\x86\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb9"		=> "\x86\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xba"		=> "\x86\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xbd"		=> "\x86\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xbf"		=> "\x86\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x85"		=> "\x86\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x86"		=> "\x86\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x8c"		=> "\x86\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x8d"		=> "\x86\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x8e"		=> "\x86\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x90"		=> "\x86\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x92"		=> "\x86\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x93"		=> "\x86\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x95"		=> "\x86\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x96"		=> "\x86\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x97"		=> "\x86\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x9a"		=> "\x86\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x9b"		=> "\x86\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x9e"		=> "\x86\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa0"		=> "\x86\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa1"		=> "\x86\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa2"		=> "\x86\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa3"		=> "\x86\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa4"		=> "\x86\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa5"		=> "\x86\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa6"		=> "\x86\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa8"		=> "\x86\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa9"		=> "\x86\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xaa"		=> "\x86\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xab"		=> "\x86\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xac"		=> "\x86\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xad"		=> "\x86\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xae"		=> "\x86\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xaf"		=> "\x86\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb0"		=> "\x86\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb2"		=> "\x86\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb4"		=> "\x86\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb6"		=> "\x86\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb8"		=> "\x86\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xba"		=> "\x86\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xbc"		=> "\x86\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xbf"		=> "\x86\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x80"		=> "\x86\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x81"		=> "\x86\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x82"		=> "\x86\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x83"		=> "\x86\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x86"		=> "\x86\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x87"		=> "\x86\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x88"		=> "\x86\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x8a"		=> "\x86\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x8b"		=> "\x86\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x8e"		=> "\x86\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x8f"		=> "\x86\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x90"		=> "\x86\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x95"		=> "\x86\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x97"		=> "\x86\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x98"		=> "\x86\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x99"		=> "\x86\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x9a"		=> "\x86\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x9b"		=> "\x86\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x9e"		=> "\x86\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa0"		=> "\x86\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa2"		=> "\x86\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa7"		=> "\x86\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa9"		=> "\x86\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xad"		=> "\x86\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xae"		=> "\x86\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb0"		=> "\x86\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb1"		=> "\x86\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb4"		=> "\x86\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb6"		=> "\x86\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb8"		=> "\x86\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb9"		=> "\x86\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xba"		=> "\x86\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xbb"		=> "\x86\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xbc"		=> "\x86\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xbf"		=> "\x86\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x82"		=> "\x86\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x83"		=> "\x86\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x84"		=> "\x86\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x85"		=> "\x86\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x86"		=> "\x87\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x87"		=> "\x87\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x8a"		=> "\x87\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x8b"		=> "\x87\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x8d"		=> "\x87\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x90"		=> "\x87\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x91"		=> "\x87\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x92"		=> "\x87\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x93"		=> "\x87\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x94"		=> "\x87\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x95"		=> "\x87\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x96"		=> "\x87\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x97"		=> "\x87\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x99"		=> "\x87\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x9a"		=> "\x87\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x9c"		=> "\x87\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x9d"		=> "\x87\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa0"		=> "\x87\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa1"		=> "\x87\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa2"		=> "\x87\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa5"		=> "\x87\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa6"		=> "\x87\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa8"		=> "\x87\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa9"		=> "\x87\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xaa"		=> "\x87\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xab"		=> "\x87\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xae"		=> "\x87\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xaf"		=> "\x87\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb0"		=> "\x87\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb3"		=> "\x87\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb5"		=> "\x87\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb7"		=> "\x87\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb8"		=> "\x87\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xba"		=> "\x87\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xbc"		=> "\x87\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xbd"		=> "\x87\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xbe"		=> "\x87\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x80"		=> "\x87\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x81"		=> "\x87\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x82"		=> "\x87\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x83"		=> "\x87\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x84"		=> "\x87\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x85"		=> "\x87\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x86"		=> "\x87\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x87"		=> "\x87\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x88"		=> "\x87\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x89"		=> "\x87\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x8a"		=> "\x87\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x8b"		=> "\x87\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x8f"		=> "\x87\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x90"		=> "\x87\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x91"		=> "\x87\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x92"		=> "\x87\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x93"		=> "\x87\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x95"		=> "\x87\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x96"		=> "\x87\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x9a"		=> "\x87\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x9b"		=> "\x87\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x9d"		=> "\x87\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x9e"		=> "\x87\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x9f"		=> "\x87\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa0"		=> "\x87\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa1"		=> "\x87\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa3"		=> "\x87\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa5"		=> "\x87\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa6"		=> "\x87\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa7"		=> "\x87\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xad"		=> "\x87\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xae"		=> "\x87\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xaf"		=> "\x87\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb0"		=> "\x87\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb2"		=> "\x87\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb3"		=> "\x87\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb4"		=> "\x87\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb5"		=> "\x87\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb7"		=> "\x87\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb8"		=> "\x87\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb9"		=> "\x87\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xba"		=> "\x87\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xbd"		=> "\x87\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xbe"		=> "\x87\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xbf"		=> "\x87\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x80"		=> "\x87\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x81"		=> "\x87\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x82"		=> "\x87\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x83"		=> "\x87\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x84"		=> "\x87\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x87"		=> "\x87\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x88"		=> "\x87\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x89"		=> "\x87\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x8a"		=> "\x87\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x8b"		=> "\x87\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x8c"		=> "\x87\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x8d"		=> "\x87\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x90"		=> "\x87\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x91"		=> "\x87\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x92"		=> "\x87\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x94"		=> "\x87\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x95"		=> "\x87\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x96"		=> "\x87\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x97"		=> "\x87\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x98"		=> "\x87\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x99"		=> "\x87\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x9a"		=> "\x87\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x9b"		=> "\x87\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x9c"		=> "\x87\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x9d"		=> "\x87\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x9e"		=> "\x87\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x9f"		=> "\x87\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa0"		=> "\x87\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa1"		=> "\x87\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa2"		=> "\x87\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa4"		=> "\x87\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa5"		=> "\x87\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa6"		=> "\x87\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa7"		=> "\x87\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa8"		=> "\x87\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa9"		=> "\x87\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xaa"		=> "\x87\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xab"		=> "\x87\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xac"		=> "\x87\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xad"		=> "\x87\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xae"		=> "\x87\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb0"		=> "\x87\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb1"		=> "\x87\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb2"		=> "\x87\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb3"		=> "\x87\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb4"		=> "\x87\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb5"		=> "\x87\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb6"		=> "\x87\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb8"		=> "\x87\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb9"		=> "\x87\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xba"		=> "\x87\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xbb"		=> "\x87\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xbd"		=> "\x87\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xbe"		=> "\x87\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xbf"		=> "\x87\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x80"		=> "\x87\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x81"		=> "\x87\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x82"		=> "\x87\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x83"		=> "\x87\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x84"		=> "\x87\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x85"		=> "\x87\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x86"		=> "\x87\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x87"		=> "\x87\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x88"		=> "\x87\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x89"		=> "\x87\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x8b"		=> "\x87\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x8c"		=> "\x87\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x8d"		=> "\x87\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x8e"		=> "\x87\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x8f"		=> "\x87\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x90"		=> "\x87\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x91"		=> "\x87\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x92"		=> "\x87\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x93"		=> "\x87\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x95"		=> "\x87\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x96"		=> "\x87\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x98"		=> "\x87\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x99"		=> "\x87\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x9c"		=> "\x87\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa3"		=> "\x87\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa5"		=> "\x87\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa6"		=> "\x87\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa7"		=> "\x87\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa8"		=> "\x87\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa9"		=> "\x87\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xaa"		=> "\x87\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xac"		=> "\x87\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xae"		=> "\x87\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xaf"		=> "\x87\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb2"		=> "\x87\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb3"		=> "\x87\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb6"		=> "\x87\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb7"		=> "\x87\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb8"		=> "\x87\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xbb"		=> "\x87\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xbc"		=> "\x87\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x80"		=> "\x87\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x81"		=> "\x87\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x82"		=> "\x87\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x85"		=> "\x87\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x87"		=> "\x87\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x8b"		=> "\x87\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x8c"		=> "\x87\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x8d"		=> "\x87\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x8e"		=> "\x87\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x8f"		=> "\x87\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x90"		=> "\x87\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x91"		=> "\x87\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x92"		=> "\x88\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x93"		=> "\x88\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x94"		=> "\x88\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x95"		=> "\x88\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x96"		=> "\x88\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x97"		=> "\x88\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x98"		=> "\x88\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x99"		=> "\x88\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x9a"		=> "\x88\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x9b"		=> "\x88\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x9d"		=> "\x88\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x9e"		=> "\x88\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa0"		=> "\x88\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa1"		=> "\x88\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa2"		=> "\x88\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa4"		=> "\x88\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa5"		=> "\x88\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa6"		=> "\x88\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa7"		=> "\x88\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xab"		=> "\x88\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb1"		=> "\x88\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb2"		=> "\x88\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb4"		=> "\x88\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb5"		=> "\x88\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb6"		=> "\x88\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb7"		=> "\x88\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb8"		=> "\x88\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xbc"		=> "\x88\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xbd"		=> "\x88\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xbf"		=> "\x88\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x81"		=> "\x88\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x83"		=> "\x88\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x84"		=> "\x88\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x85"		=> "\x88\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x86"		=> "\x88\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x88"		=> "\x88\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x89"		=> "\x88\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x8b"		=> "\x88\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x92"		=> "\x88\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x93"		=> "\x88\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x94"		=> "\x88\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x95"		=> "\x88\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x96"		=> "\x88\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x98"		=> "\x88\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x99"		=> "\x88\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa2"		=> "\x88\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa3"		=> "\x88\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa5"		=> "\x88\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa7"		=> "\x88\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xac"		=> "\x88\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xae"		=> "\x88\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb0"		=> "\x88\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb1"		=> "\x88\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb2"		=> "\x88\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb4"		=> "\x88\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb5"		=> "\x88\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb8"		=> "\x88\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb9"		=> "\x88\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xba"		=> "\x88\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xbd"		=> "\x88\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xbe"		=> "\x88\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xbf"		=> "\x88\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x80"		=> "\x88\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x81"		=> "\x88\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x87"		=> "\x88\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x88"		=> "\x88\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x89"		=> "\x88\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x8a"		=> "\x88\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x8d"		=> "\x88\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x8e"		=> "\x88\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x8f"		=> "\x88\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x90"		=> "\x88\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x91"		=> "\x88\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x94"		=> "\x88\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x95"		=> "\x88\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x96"		=> "\x88\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x97"		=> "\x88\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x98"		=> "\x88\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x99"		=> "\x88\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x9a"		=> "\x88\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x9c"		=> "\x88\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x9d"		=> "\x88\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x9e"		=> "\x88\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x9f"		=> "\x88\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa5"		=> "\x88\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa8"		=> "\x88\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xaa"		=> "\x88\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xac"		=> "\x88\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xaf"		=> "\x88\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb0"		=> "\x88\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb1"		=> "\x88\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb3"		=> "\x88\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb5"		=> "\x88\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb6"		=> "\x88\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb7"		=> "\x88\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb9"		=> "\x88\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xba"		=> "\x88\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xbb"		=> "\x88\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xbc"		=> "\x88\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xbd"		=> "\x88\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xbe"		=> "\x88\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xbf"		=> "\x88\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x80"		=> "\x88\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x81"		=> "\x88\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x84"		=> "\x88\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x85"		=> "\x88\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x86"		=> "\x88\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x87"		=> "\x88\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x88"		=> "\x88\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x89"		=> "\x88\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x8a"		=> "\x88\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x8c"		=> "\x88\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x8d"		=> "\x88\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x90"		=> "\x88\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x91"		=> "\x88\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x93"		=> "\x88\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x96"		=> "\x88\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x97"		=> "\x88\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x9b"		=> "\x88\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x9c"		=> "\x88\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x9e"		=> "\x88\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa1"		=> "\x88\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa2"		=> "\x88\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa3"		=> "\x88\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa5"		=> "\x88\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa6"		=> "\x88\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa7"		=> "\x88\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa8"		=> "\x88\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa9"		=> "\x88\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xaa"		=> "\x88\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xab"		=> "\x88\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xac"		=> "\x88\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xae"		=> "\x88\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb0"		=> "\x88\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb1"		=> "\x88\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb2"		=> "\x88\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb3"		=> "\x88\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb5"		=> "\x88\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb6"		=> "\x88\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb7"		=> "\x88\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xbb"		=> "\x88\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xbc"		=> "\x88\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xbe"		=> "\x88\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xbf"		=> "\x88\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x81"		=> "\x88\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x83"		=> "\x88\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x84"		=> "\x88\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x85"		=> "\x88\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x88"		=> "\x88\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x89"		=> "\x88\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x8a"		=> "\x88\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x8c"		=> "\x88\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x8e"		=> "\x88\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x8f"		=> "\x88\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x90"		=> "\x88\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x92"		=> "\x88\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x93"		=> "\x88\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x94"		=> "\x88\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x96"		=> "\x88\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x97"		=> "\x88\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x98"		=> "\x88\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x9a"		=> "\x88\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x9b"		=> "\x88\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x9c"		=> "\x88\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x9d"		=> "\x88\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x9f"		=> "\x88\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa2"		=> "\x88\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa3"		=> "\x88\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa5"		=> "\x88\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa6"		=> "\x88\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa7"		=> "\x88\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa8"		=> "\x88\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa9"		=> "\x88\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xab"		=> "\x88\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xac"		=> "\x88\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xad"		=> "\x88\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xae"		=> "\x88\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xaf"		=> "\x88\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb1"		=> "\x88\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb2"		=> "\x88\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb3"		=> "\x88\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb4"		=> "\x88\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb6"		=> "\x88\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb7"		=> "\x88\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb8"		=> "\x88\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb9"		=> "\x88\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xba"		=> "\x88\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xbb"		=> "\x88\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xbc"		=> "\x88\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xbd"		=> "\x88\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xbe"		=> "\x89\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xbf"		=> "\x89\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x80"		=> "\x89\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x81"		=> "\x89\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x82"		=> "\x89\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x83"		=> "\x89\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x85"		=> "\x89\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x86"		=> "\x89\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x87"		=> "\x89\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x88"		=> "\x89\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x89"		=> "\x89\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x8a"		=> "\x89\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x8b"		=> "\x89\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x8e"		=> "\x89\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x8f"		=> "\x89\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x90"		=> "\x89\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x92"		=> "\x89\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x93"		=> "\x89\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x95"		=> "\x89\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x96"		=> "\x89\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x97"		=> "\x89\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x99"		=> "\x89\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x9a"		=> "\x89\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x9b"		=> "\x89\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x9c"		=> "\x89\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x9d"		=> "\x89\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x9f"		=> "\x89\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa0"		=> "\x89\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa1"		=> "\x89\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa2"		=> "\x89\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa3"		=> "\x89\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa4"		=> "\x89\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa6"		=> "\x89\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa7"		=> "\x89\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa8"		=> "\x89\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa9"		=> "\x89\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xaa"		=> "\x89\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xad"		=> "\x89\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xae"		=> "\x89\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xaf"		=> "\x89\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb0"		=> "\x89\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb1"		=> "\x89\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb2"		=> "\x89\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb3"		=> "\x89\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb4"		=> "\x89\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb5"		=> "\x89\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb6"		=> "\x89\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb7"		=> "\x89\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb8"		=> "\x89\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xb9"		=> "\x89\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xba"		=> "\x89\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xbb"		=> "\x89\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xbc"		=> "\x89\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xbd"		=> "\x89\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xbf"		=> "\x89\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x82"		=> "\x89\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x84"		=> "\x89\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x86"		=> "\x89\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x87"		=> "\x89\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x88"		=> "\x89\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x8a"		=> "\x89\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x8b"		=> "\x89\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x8c"		=> "\x89\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x8d"		=> "\x89\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x8e"		=> "\x89\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x8f"		=> "\x89\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x90"		=> "\x89\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x91"		=> "\x89\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x94"		=> "\x89\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x95"		=> "\x89\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x96"		=> "\x89\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x97"		=> "\x89\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x98"		=> "\x89\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x9b"		=> "\x89\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x9c"		=> "\x89\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x9d"		=> "\x89\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa0"		=> "\x89\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa1"		=> "\x89\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa2"		=> "\x89\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa3"		=> "\x89\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa4"		=> "\x89\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa5"		=> "\x89\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa6"		=> "\x89\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa7"		=> "\x89\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xaa"		=> "\x89\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xab"		=> "\x89\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xac"		=> "\x89\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xad"		=> "\x89\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xae"		=> "\x89\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xaf"		=> "\x89\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb0"		=> "\x89\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb1"		=> "\x89\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb2"		=> "\x89\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb3"		=> "\x89\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb4"		=> "\x89\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb5"		=> "\x89\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb6"		=> "\x89\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb7"		=> "\x89\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb8"		=> "\x89\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xb9"		=> "\x89\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xba"		=> "\x89\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xbb"		=> "\x89\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xbd"		=> "\x89\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xbe"		=> "\x89\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xbf"		=> "\x89\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x80"		=> "\x89\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x82"		=> "\x89\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x83"		=> "\x89\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x84"		=> "\x89\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x86"		=> "\x89\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x87"		=> "\x89\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x88"		=> "\x89\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x89"		=> "\x89\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x8a"		=> "\x89\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x8b"		=> "\x89\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x8c"		=> "\x89\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x8d"		=> "\x89\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x8e"		=> "\x89\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x8f"		=> "\x89\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x90"		=> "\x89\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x92"		=> "\x89\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x93"		=> "\x89\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x94"		=> "\x89\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x96"		=> "\x89\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x97"		=> "\x89\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x98"		=> "\x89\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x99"		=> "\x89\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x9a"		=> "\x89\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x9b"		=> "\x89\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x9c"		=> "\x89\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x9d"		=> "\x89\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x9e"		=> "\x89\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x9f"		=> "\x89\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa0"		=> "\x89\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa1"		=> "\x89\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa2"		=> "\x89\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa3"		=> "\x89\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa5"		=> "\x89\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa6"		=> "\x89\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa7"		=> "\x89\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa8"		=> "\x89\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa9"		=> "\x89\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xaa"		=> "\x89\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xad"		=> "\x89\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xaf"		=> "\x89\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb1"		=> "\x89\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb2"		=> "\x89\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb4"		=> "\x89\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb5"		=> "\x89\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb7"		=> "\x89\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb8"		=> "\x89\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xba"		=> "\x89\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xbb"		=> "\x89\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xbc"		=> "\x89\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xbd"		=> "\x89\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xbe"		=> "\x89\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xbf"		=> "\x89\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x80"		=> "\x89\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x81"		=> "\x89\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x83"		=> "\x89\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x85"		=> "\x89\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x86"		=> "\x89\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x88"		=> "\x89\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x89"		=> "\x89\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x8a"		=> "\x89\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x8b"		=> "\x89\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x8c"		=> "\x89\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x8e"		=> "\x89\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x90"		=> "\x89\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x91"		=> "\x89\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x92"		=> "\x89\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x93"		=> "\x89\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x97"		=> "\x89\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x98"		=> "\x89\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x9b"		=> "\x89\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x9d"		=> "\x89\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x9e"		=> "\x89\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa0"		=> "\x89\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa1"		=> "\x89\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa2"		=> "\x89\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa3"		=> "\x89\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa6"		=> "\x89\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa8"		=> "\x89\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xac"		=> "\x89\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb0"		=> "\x89\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb2"		=> "\x89\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb3"		=> "\x89\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb5"		=> "\x89\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb6"		=> "\x89\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xbb"		=> "\x89\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xbd"		=> "\x8a\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xbe"		=> "\x8a\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xbf"		=> "\x8a\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x80"		=> "\x8a\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x83"		=> "\x8a\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x85"		=> "\x8a\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x86"		=> "\x8a\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x8a"		=> "\x8a\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x8c"		=> "\x8a\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x8d"		=> "\x8a\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x90"		=> "\x8a\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x92"		=> "\x8a\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x93"		=> "\x8a\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x99"		=> "\x8a\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x9b"		=> "\x8a\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x9c"		=> "\x8a\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x9d"		=> "\x8a\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x9e"		=> "\x8a\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x9f"		=> "\x8a\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa1"		=> "\x8a\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa3"		=> "\x8a\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa4"		=> "\x8a\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa6"		=> "\x8a\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa7"		=> "\x8a\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa8"		=> "\x8a\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa9"		=> "\x8a\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xaa"		=> "\x8a\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xab"		=> "\x8a\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xac"		=> "\x8a\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xad"		=> "\x8a\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xae"		=> "\x8a\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xaf"		=> "\x8a\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb0"		=> "\x8a\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb1"		=> "\x8a\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb2"		=> "\x8a\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb5"		=> "\x8a\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb7"		=> "\x8a\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xba"		=> "\x8a\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xbb"		=> "\x8a\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xbc"		=> "\x8a\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xbe"		=> "\x8a\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xbf"		=> "\x8a\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x80"		=> "\x8a\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x85"		=> "\x8a\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x89"		=> "\x8a\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x8b"		=> "\x8a\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x8c"		=> "\x8a\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x8e"		=> "\x8a\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x8f"		=> "\x8a\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x90"		=> "\x8a\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x91"		=> "\x8a\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x94"		=> "\x8a\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x95"		=> "\x8a\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x98"		=> "\x8a\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x9a"		=> "\x8a\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x9b"		=> "\x8a\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x9c"		=> "\x8a\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x9d"		=> "\x8a\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x9f"		=> "\x8a\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa0"		=> "\x8a\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa1"		=> "\x8a\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa2"		=> "\x8a\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa6"		=> "\x8a\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa7"		=> "\x8a\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xac"		=> "\x8a\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xad"		=> "\x8a\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb0"		=> "\x8a\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb1"		=> "\x8a\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb3"		=> "\x8a\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb4"		=> "\x8a\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb5"		=> "\x8a\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb6"		=> "\x8a\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb7"		=> "\x8a\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb8"		=> "\x8a\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xba"		=> "\x8a\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xbc"		=> "\x8a\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xbd"		=> "\x8a\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xbf"		=> "\x8a\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x80"		=> "\x8a\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x81"		=> "\x8a\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x82"		=> "\x8a\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x83"		=> "\x8a\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x84"		=> "\x8a\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x85"		=> "\x8a\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x87"		=> "\x8a\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x88"		=> "\x8a\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x89"		=> "\x8a\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x8c"		=> "\x8a\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x8d"		=> "\x8a\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x8e"		=> "\x8a\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x8f"		=> "\x8a\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x95"		=> "\x8a\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x96"		=> "\x8a\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x99"		=> "\x8a\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x9b"		=> "\x8a\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x9e"		=> "\x8a\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x9f"		=> "\x8a\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa0"		=> "\x8a\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa1"		=> "\x8a\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa2"		=> "\x8a\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa4"		=> "\x8a\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa6"		=> "\x8a\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa7"		=> "\x8a\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa9"		=> "\x8a\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xaa"		=> "\x8a\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xab"		=> "\x8a\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xad"		=> "\x8a\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xae"		=> "\x8a\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xaf"		=> "\x8a\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb0"		=> "\x8a\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb1"		=> "\x8a\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb2"		=> "\x8a\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb3"		=> "\x8a\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb4"		=> "\x8a\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb5"		=> "\x8a\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb6"		=> "\x8a\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb7"		=> "\x8a\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xb8"		=> "\x8a\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xba"		=> "\x8a\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xbc"		=> "\x8a\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xbd"		=> "\x8a\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xbe"		=> "\x8a\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x80"		=> "\x8a\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x82"		=> "\x8a\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x8a"		=> "\x8a\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x8b"		=> "\x8a\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x8d"		=> "\x8a\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x8e"		=> "\x8a\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x8f"		=> "\x8a\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x90"		=> "\x8a\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x92"		=> "\x8a\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x94"		=> "\x8a\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x95"		=> "\x8a\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x96"		=> "\x8a\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x97"		=> "\x8a\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x99"		=> "\x8a\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x9a"		=> "\x8a\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x9b"		=> "\x8a\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x9d"		=> "\x8a\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x9e"		=> "\x8a\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa1"		=> "\x8a\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa2"		=> "\x8a\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa4"		=> "\x8a\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa6"		=> "\x8a\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa7"		=> "\x8a\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa8"		=> "\x8a\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xaa"		=> "\x8a\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xab"		=> "\x8a\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xac"		=> "\x8a\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xad"		=> "\x8a\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xae"		=> "\x8a\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xaf"		=> "\x8a\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb0"		=> "\x8a\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb3"		=> "\x8a\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb5"		=> "\x8a\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb7"		=> "\x8a\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb8"		=> "\x8a\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb9"		=> "\x8a\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xba"		=> "\x8a\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xbb"		=> "\x8a\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xbd"		=> "\x8a\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xbe"		=> "\x8a\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xbf"		=> "\x8a\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x81"		=> "\x8a\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x82"		=> "\x8a\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x83"		=> "\x8a\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x84"		=> "\x8a\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x85"		=> "\x8a\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x87"		=> "\x8a\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x88"		=> "\x8a\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x8b"		=> "\x8a\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x8c"		=> "\x8a\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x8d"		=> "\x8a\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x8e"		=> "\x8a\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x8f"		=> "\x8a\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x90"		=> "\x8a\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x91"		=> "\x8a\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x92"		=> "\x8a\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x93"		=> "\x8a\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x94"		=> "\x8a\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x96"		=> "\x8a\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x97"		=> "\x8a\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x98"		=> "\x8a\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x99"		=> "\x8a\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x9b"		=> "\x8a\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x9c"		=> "\x8a\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x9d"		=> "\x8a\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x9e"		=> "\x8a\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x9f"		=> "\x8a\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa0"		=> "\x8a\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa1"		=> "\x8b\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa3"		=> "\x8b\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa4"		=> "\x8b\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa5"		=> "\x8b\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa6"		=> "\x8b\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa8"		=> "\x8b\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xa9"		=> "\x8b\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xab"		=> "\x8b\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xac"		=> "\x8b\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xad"		=> "\x8b\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xae"		=> "\x8b\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xaf"		=> "\x8b\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb0"		=> "\x8b\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb1"		=> "\x8b\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb2"		=> "\x8b\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb3"		=> "\x8b\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb8"		=> "\x8b\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb9"		=> "\x8b\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xbb"		=> "\x8b\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xbc"		=> "\x8b\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xbd"		=> "\x8b\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xbe"		=> "\x8b\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x80"		=> "\x8b\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x81"		=> "\x8b\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x82"		=> "\x8b\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x83"		=> "\x8b\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x84"		=> "\x8b\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x85"		=> "\x8b\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x86"		=> "\x8b\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x87"		=> "\x8b\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x88"		=> "\x8b\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x89"		=> "\x8b\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x8a"		=> "\x8b\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x8b"		=> "\x8b\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x8c"		=> "\x8b\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x8d"		=> "\x8b\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x8e"		=> "\x8b\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x8f"		=> "\x8b\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x90"		=> "\x8b\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x91"		=> "\x8b\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x93"		=> "\x8b\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x94"		=> "\x8b\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x95"		=> "\x8b\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x96"		=> "\x8b\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x97"		=> "\x8b\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x98"		=> "\x8b\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x99"		=> "\x8b\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x9c"		=> "\x8b\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x9d"		=> "\x8b\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x9e"		=> "\x8b\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x9f"		=> "\x8b\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa0"		=> "\x8b\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa1"		=> "\x8b\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa2"		=> "\x8b\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa3"		=> "\x8b\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa4"		=> "\x8b\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa5"		=> "\x8b\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa6"		=> "\x8b\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa7"		=> "\x8b\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa8"		=> "\x8b\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xa9"		=> "\x8b\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xab"		=> "\x8b\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xac"		=> "\x8b\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xad"		=> "\x8b\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xae"		=> "\x8b\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xaf"		=> "\x8b\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb0"		=> "\x8b\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb1"		=> "\x8b\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb4"		=> "\x8b\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb6"		=> "\x8b\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb7"		=> "\x8b\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb9"		=> "\x8b\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xba"		=> "\x8b\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xbb"		=> "\x8b\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xbc"		=> "\x8b\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xbd"		=> "\x8b\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xbf"		=> "\x8b\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x80"		=> "\x8b\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x83"		=> "\x8b\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x84"		=> "\x8b\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x85"		=> "\x8b\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x86"		=> "\x8b\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x87"		=> "\x8b\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x88"		=> "\x8b\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x8a"		=> "\x8b\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x8b"		=> "\x8b\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x8d"		=> "\x8b\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x8e"		=> "\x8b\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x8f"		=> "\x8b\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x90"		=> "\x8b\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x91"		=> "\x8b\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x93"		=> "\x8b\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x95"		=> "\x8b\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x97"		=> "\x8b\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x99"		=> "\x8b\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x9a"		=> "\x8b\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x9b"		=> "\x8b\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x9d"		=> "\x8b\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x9e"		=> "\x8b\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x9f"		=> "\x8b\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa2"		=> "\x8b\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa4"		=> "\x8b\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa5"		=> "\x8b\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa7"		=> "\x8b\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa8"		=> "\x8b\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xaa"		=> "\x8b\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xac"		=> "\x8b\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xad"		=> "\x8b\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xae"		=> "\x8b\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xaf"		=> "\x8b\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb0"		=> "\x8b\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb2"		=> "\x8b\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb3"		=> "\x8b\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb4"		=> "\x8b\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb5"		=> "\x8b\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb6"		=> "\x8b\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb7"		=> "\x8b\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb8"		=> "\x8b\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xb9"		=> "\x8b\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xba"		=> "\x8b\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xbb"		=> "\x8b\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xbc"		=> "\x8b\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xbd"		=> "\x8b\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xbe"		=> "\x8b\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xbf"		=> "\x8b\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x80"		=> "\x8b\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x81"		=> "\x8b\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x82"		=> "\x8b\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x83"		=> "\x8b\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x84"		=> "\x8b\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x85"		=> "\x8b\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x86"		=> "\x8b\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x87"		=> "\x8b\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x88"		=> "\x8b\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x8a"		=> "\x8b\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x8b"		=> "\x8b\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x8c"		=> "\x8b\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x8d"		=> "\x8b\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x8e"		=> "\x8b\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x8f"		=> "\x8b\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x90"		=> "\x8b\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x91"		=> "\x8b\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x92"		=> "\x8b\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x93"		=> "\x8b\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x94"		=> "\x8b\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x95"		=> "\x8b\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x98"		=> "\x8b\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x99"		=> "\x8b\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x9a"		=> "\x8b\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x9b"		=> "\x8b\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x9c"		=> "\x8b\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x9d"		=> "\x8b\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x9e"		=> "\x8b\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\x9f"		=> "\x8b\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa0"		=> "\x8b\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa1"		=> "\x8b\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa2"		=> "\x8b\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa3"		=> "\x8b\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa4"		=> "\x8b\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa5"		=> "\x8b\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa6"		=> "\x8b\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa7"		=> "\x8b\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa8"		=> "\x8b\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xa9"		=> "\x8b\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xaa"		=> "\x8b\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xab"		=> "\x8b\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xac"		=> "\x8b\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xad"		=> "\x8b\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xae"		=> "\x8b\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xaf"		=> "\x8b\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb0"		=> "\x8b\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb1"		=> "\x8b\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb3"		=> "\x8b\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb5"		=> "\x8b\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb6"		=> "\x8b\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb8"		=> "\x8b\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb9"		=> "\x8b\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xba"		=> "\x8b\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xbb"		=> "\x8b\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xbc"		=> "\x8b\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xbd"		=> "\x8b\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xbe"		=> "\x8b\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xbf"		=> "\x8b\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x81"		=> "\x8b\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x82"		=> "\x8b\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x83"		=> "\x8b\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x84"		=> "\x8b\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x85"		=> "\x8b\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x86"		=> "\x8b\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x87"		=> "\x8b\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x88"		=> "\x8c\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x89"		=> "\x8c\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x8a"		=> "\x8c\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x8b"		=> "\x8c\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x8c"		=> "\x8c\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x8d"		=> "\x8c\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x8e"		=> "\x8c\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x8f"		=> "\x8c\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x92"		=> "\x8c\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x96"		=> "\x8c\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x9e"		=> "\x8c\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa0"		=> "\x8c\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa1"		=> "\x8c\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa7"		=> "\x8c\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa8"		=> "\x8c\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xab"		=> "\x8c\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xad"		=> "\x8c\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xae"		=> "\x8c\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xaf"		=> "\x8c\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb2"		=> "\x8c\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb4"		=> "\x8c\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb6"		=> "\x8c\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb7"		=> "\x8c\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb8"		=> "\x8c\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb9"		=> "\x8c\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xbb"		=> "\x8c\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xbc"		=> "\x8c\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xbe"		=> "\x8c\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xbf"		=> "\x8c\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x82"		=> "\x8c\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x86"		=> "\x8c\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x8a"		=> "\x8c\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x8d"		=> "\x8c\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x8e"		=> "\x8c\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x90"		=> "\x8c\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x91"		=> "\x8c\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x92"		=> "\x8c\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x94"		=> "\x8c\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x96"		=> "\x8c\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x9f"		=> "\x8c\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa7"		=> "\x8c\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa8"		=> "\x8c\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa9"		=> "\x8c\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xac"		=> "\x8c\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xad"		=> "\x8c\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xae"		=> "\x8c\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xaf"		=> "\x8c\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb1"		=> "\x8c\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb2"		=> "\x8c\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb7"		=> "\x8c\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xba"		=> "\x8c\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xbb"		=> "\x8c\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xbc"		=> "\x8c\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x80"		=> "\x8c\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x81"		=> "\x8c\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x83"		=> "\x8c\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x88"		=> "\x8c\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x89"		=> "\x8c\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x8a"		=> "\x8c\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x8b"		=> "\x8c\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x8d"		=> "\x8c\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x8e"		=> "\x8c\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x8f"		=> "\x8c\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x91"		=> "\x8c\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x94"		=> "\x8c\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x95"		=> "\x8c\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x96"		=> "\x8c\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x97"		=> "\x8c\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x98"		=> "\x8c\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x99"		=> "\x8c\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x9a"		=> "\x8c\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x9b"		=> "\x8c\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x9c"		=> "\x8c\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa0"		=> "\x8c\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa2"		=> "\x8c\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa3"		=> "\x8c\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa6"		=> "\x8c\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa7"		=> "\x8c\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa9"		=> "\x8c\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xaa"		=> "\x8c\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xab"		=> "\x8c\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xac"		=> "\x8c\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xad"		=> "\x8c\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xaf"		=> "\x8c\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb1"		=> "\x8c\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb2"		=> "\x8c\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb3"		=> "\x8c\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb4"		=> "\x8c\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb5"		=> "\x8c\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb6"		=> "\x8c\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb7"		=> "\x8c\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xbd"		=> "\x8c\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xbe"		=> "\x8c\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x80"		=> "\x8c\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x82"		=> "\x8c\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x83"		=> "\x8c\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x85"		=> "\x8c\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x87"		=> "\x8c\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x88"		=> "\x8c\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x8b"		=> "\x8c\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x8c"		=> "\x8c\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x8d"		=> "\x8c\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x8e"		=> "\x8c\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x90"		=> "\x8c\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x92"		=> "\x8c\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x93"		=> "\x8c\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x97"		=> "\x8c\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x99"		=> "\x8c\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x9b"		=> "\x8c\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x9e"		=> "\x8c\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x9f"		=> "\x8c\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa0"		=> "\x8c\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa1"		=> "\x8c\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa3"		=> "\x8c\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa6"		=> "\x8c\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa8"		=> "\x8c\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa9"		=> "\x8c\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xaa"		=> "\x8c\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xab"		=> "\x8c\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xad"		=> "\x8c\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xae"		=> "\x8c\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xaf"		=> "\x8c\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb0"		=> "\x8c\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb2"		=> "\x8c\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb3"		=> "\x8c\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb5"		=> "\x8c\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb6"		=> "\x8c\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb7"		=> "\x8c\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x83"		=> "\x8c\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x84"		=> "\x8c\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x86"		=> "\x8c\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x87"		=> "\x8c\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x8c"		=> "\x8c\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x8d"		=> "\x8c\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x92"		=> "\x8c\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x93"		=> "\x8c\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x94"		=> "\x8c\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x96"		=> "\x8c\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x97"		=> "\x8c\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x98"		=> "\x8c\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x9a"		=> "\x8c\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x9b"		=> "\x8c\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x9c"		=> "\x8c\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x9d"		=> "\x8c\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x9f"		=> "\x8c\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa2"		=> "\x8c\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa4"		=> "\x8c\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa7"		=> "\x8c\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa8"		=> "\x8c\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa9"		=> "\x8c\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xaa"		=> "\x8c\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xab"		=> "\x8c\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xac"		=> "\x8c\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xad"		=> "\x8c\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb0"		=> "\x8c\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb2"		=> "\x8c\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb3"		=> "\x8c\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb4"		=> "\x8c\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb5"		=> "\x8c\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb6"		=> "\x8c\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb7"		=> "\x8c\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb8"		=> "\x8c\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xbb"		=> "\x8c\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xbc"		=> "\x8c\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xbd"		=> "\x8c\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xbe"		=> "\x8c\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x80"		=> "\x8c\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x83"		=> "\x8c\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x84"		=> "\x8c\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x85"		=> "\x8c\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x86"		=> "\x8c\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x87"		=> "\x8c\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x89"		=> "\x8c\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x8a"		=> "\x8c\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x8b"		=> "\x8c\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x8e"		=> "\x8c\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x8f"		=> "\x8c\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x92"		=> "\x8c\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x93"		=> "\x8c\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x95"		=> "\x8c\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x9d"		=> "\x8c\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x9e"		=> "\x8c\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x9f"		=> "\x8c\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa0"		=> "\x8c\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa1"		=> "\x8c\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa4"		=> "\x8c\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa5"		=> "\x8c\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa6"		=> "\x8c\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa7"		=> "\x8c\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa8"		=> "\x8c\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xaa"		=> "\x8d\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xae"		=> "\x8d\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xaf"		=> "\x8d\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb0"		=> "\x8d\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb2"		=> "\x8d\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb4"		=> "\x8d\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb6"		=> "\x8d\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb9"		=> "\x8d\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xba"		=> "\x8d\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xbb"		=> "\x8d\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xbc"		=> "\x8d\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xbe"		=> "\x8d\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x80"		=> "\x8d\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x82"		=> "\x8d\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x83"		=> "\x8d\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x85"		=> "\x8d\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x86"		=> "\x8d\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x87"		=> "\x8d\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x88"		=> "\x8d\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x89"		=> "\x8d\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x8a"		=> "\x8d\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x8c"		=> "\x8d\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x8d"		=> "\x8d\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x8e"		=> "\x8d\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x8f"		=> "\x8d\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x90"		=> "\x8d\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x91"		=> "\x8d\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x93"		=> "\x8d\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x94"		=> "\x8d\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x95"		=> "\x8d\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x96"		=> "\x8d\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x97"		=> "\x8d\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x98"		=> "\x8d\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x9a"		=> "\x8d\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x9b"		=> "\x8d\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x9c"		=> "\x8d\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x9d"		=> "\x8d\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x9e"		=> "\x8d\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x9f"		=> "\x8d\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa0"		=> "\x8d\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa2"		=> "\x8d\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa3"		=> "\x8d\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa7"		=> "\x8d\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa9"		=> "\x8d\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xab"		=> "\x8d\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xac"		=> "\x8d\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xae"		=> "\x8d\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xaf"		=> "\x8d\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb1"		=> "\x8d\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb2"		=> "\x8d\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb3"		=> "\x8d\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb4"		=> "\x8d\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb5"		=> "\x8d\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb6"		=> "\x8d\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb7"		=> "\x8d\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb8"		=> "\x8d\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb9"		=> "\x8d\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xba"		=> "\x8d\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xbc"		=> "\x8d\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xbd"		=> "\x8d\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xbe"		=> "\x8d\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xbf"		=> "\x8d\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x80"		=> "\x8d\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x81"		=> "\x8d\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x84"		=> "\x8d\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x85"		=> "\x8d\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x88"		=> "\x8d\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x89"		=> "\x8d\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x8a"		=> "\x8d\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x8b"		=> "\x8d\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x8c"		=> "\x8d\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x8d"		=> "\x8d\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x8f"		=> "\x8d\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x90"		=> "\x8d\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x91"		=> "\x8d\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x92"		=> "\x8d\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x93"		=> "\x8d\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x95"		=> "\x8d\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x97"		=> "\x8d\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x98"		=> "\x8d\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x99"		=> "\x8d\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x9a"		=> "\x8d\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x9c"		=> "\x8d\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x9d"		=> "\x8d\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x9f"		=> "\x8d\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa0"		=> "\x8d\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa1"		=> "\x8d\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa2"		=> "\x8d\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa3"		=> "\x8d\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa5"		=> "\x8d\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa8"		=> "\x8d\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xaa"		=> "\x8d\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xab"		=> "\x8d\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xac"		=> "\x8d\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xaf"		=> "\x8d\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb0"		=> "\x8d\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb1"		=> "\x8d\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb2"		=> "\x8d\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb3"		=> "\x8d\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb5"		=> "\x8d\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb6"		=> "\x8d\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb7"		=> "\x8d\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb8"		=> "\x8d\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb9"		=> "\x8d\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xba"		=> "\x8d\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xbb"		=> "\x8d\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xbc"		=> "\x8d\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xbf"		=> "\x8d\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x80"		=> "\x8d\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x81"		=> "\x8d\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x82"		=> "\x8d\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x83"		=> "\x8d\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x84"		=> "\x8d\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x85"		=> "\x8d\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x86"		=> "\x8d\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x88"		=> "\x8d\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x89"		=> "\x8d\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x8d"		=> "\x8d\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x8e"		=> "\x8d\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x8f"		=> "\x8d\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x90"		=> "\x8d\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x91"		=> "\x8d\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x92"		=> "\x8d\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x93"		=> "\x8d\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x94"		=> "\x8d\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x95"		=> "\x8d\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x96"		=> "\x8d\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x97"		=> "\x8d\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x99"		=> "\x8d\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x9a"		=> "\x8d\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x9c"		=> "\x8d\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x9e"		=> "\x8d\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x9f"		=> "\x8d\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa0"		=> "\x8d\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa1"		=> "\x8d\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa2"		=> "\x8d\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa3"		=> "\x8d\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa4"		=> "\x8d\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa5"		=> "\x8d\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa6"		=> "\x8d\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa7"		=> "\x8d\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa8"		=> "\x8d\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xaa"		=> "\x8d\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xad"		=> "\x8d\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xae"		=> "\x8d\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb0"		=> "\x8d\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb1"		=> "\x8d\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb2"		=> "\x8d\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb3"		=> "\x8d\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb5"		=> "\x8d\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb6"		=> "\x8d\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb7"		=> "\x8d\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb8"		=> "\x8d\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb9"		=> "\x8d\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xba"		=> "\x8d\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xbb"		=> "\x8d\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xbc"		=> "\x8d\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xbd"		=> "\x8d\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xbe"		=> "\x8d\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xbf"		=> "\x8d\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x80"		=> "\x8d\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x81"		=> "\x8d\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x83"		=> "\x8d\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x84"		=> "\x8d\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x85"		=> "\x8d\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x86"		=> "\x8d\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x87"		=> "\x8d\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x88"		=> "\x8d\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x89"		=> "\x8d\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x8a"		=> "\x8d\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x8b"		=> "\x8d\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x8c"		=> "\x8d\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x8d"		=> "\x8d\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x8e"		=> "\x8d\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x8f"		=> "\x8d\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x90"		=> "\x8d\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x91"		=> "\x8d\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x92"		=> "\x8d\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x93"		=> "\x8d\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x94"		=> "\x8d\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x95"		=> "\x8d\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x96"		=> "\x8d\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x97"		=> "\x8d\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x98"		=> "\x8d\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x9a"		=> "\x8d\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x9b"		=> "\x8d\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x9c"		=> "\x8d\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x9e"		=> "\x8d\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x9f"		=> "\x8d\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa0"		=> "\x8d\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa1"		=> "\x8e\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa2"		=> "\x8e\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa3"		=> "\x8e\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa4"		=> "\x8e\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa5"		=> "\x8e\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa6"		=> "\x8e\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa7"		=> "\x8e\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa8"		=> "\x8e\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xa9"		=> "\x8e\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xaa"		=> "\x8e\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xab"		=> "\x8e\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xac"		=> "\x8e\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xad"		=> "\x8e\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xae"		=> "\x8e\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xaf"		=> "\x8e\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb0"		=> "\x8e\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb1"		=> "\x8e\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb2"		=> "\x8e\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb3"		=> "\x8e\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb4"		=> "\x8e\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb5"		=> "\x8e\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb6"		=> "\x8e\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb8"		=> "\x8e\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb9"		=> "\x8e\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xba"		=> "\x8e\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xbb"		=> "\x8e\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xbc"		=> "\x8e\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xbd"		=> "\x8e\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xbe"		=> "\x8e\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xbf"		=> "\x8e\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x80"		=> "\x8e\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x81"		=> "\x8e\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x82"		=> "\x8e\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x83"		=> "\x8e\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x84"		=> "\x8e\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x86"		=> "\x8e\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x87"		=> "\x8e\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x88"		=> "\x8e\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x89"		=> "\x8e\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x8a"		=> "\x8e\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x8b"		=> "\x8e\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x8c"		=> "\x8e\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x8e"		=> "\x8e\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x8f"		=> "\x8e\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x90"		=> "\x8e\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x91"		=> "\x8e\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x92"		=> "\x8e\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x93"		=> "\x8e\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x94"		=> "\x8e\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x95"		=> "\x8e\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x96"		=> "\x8e\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x97"		=> "\x8e\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x98"		=> "\x8e\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x99"		=> "\x8e\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x9a"		=> "\x8e\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x9c"		=> "\x8e\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x9f"		=> "\x8e\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa0"		=> "\x8e\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa3"		=> "\x8e\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa4"		=> "\x8e\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xaa"		=> "\x8e\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xac"		=> "\x8e\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xad"		=> "\x8e\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb0"		=> "\x8e\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb5"		=> "\x8e\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb6"		=> "\x8e\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb8"		=> "\x8e\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb9"		=> "\x8e\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xba"		=> "\x8e\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xbb"		=> "\x8e\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xbc"		=> "\x8e\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xbf"		=> "\x8e\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x80"		=> "\x8e\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x84"		=> "\x8e\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x87"		=> "\x8e\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x89"		=> "\x8e\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x8a"		=> "\x8e\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x8b"		=> "\x8e\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x8d"		=> "\x8e\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x8e"		=> "\x8e\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x92"		=> "\x8e\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x93"		=> "\x8e\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x97"		=> "\x8e\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x9e"		=> "\x8e\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x9f"		=> "\x8e\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa0"		=> "\x8e\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa1"		=> "\x8e\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa2"		=> "\x8e\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa3"		=> "\x8e\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa4"		=> "\x8e\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa5"		=> "\x8e\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa8"		=> "\x8e\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa9"		=> "\x8e\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xaa"		=> "\x8e\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xab"		=> "\x8e\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xac"		=> "\x8e\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xaf"		=> "\x8e\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb0"		=> "\x8e\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb2"		=> "\x8e\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb3"		=> "\x8e\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb4"		=> "\x8e\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb5"		=> "\x8e\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb6"		=> "\x8e\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb9"		=> "\x8e\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xba"		=> "\x8e\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xbe"		=> "\x8e\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xbf"		=> "\x8e\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x80"		=> "\x8e\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x81"		=> "\x8e\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x83"		=> "\x8e\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x86"		=> "\x8e\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x87"		=> "\x8e\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x88"		=> "\x8e\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x89"		=> "\x8e\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x8a"		=> "\x8e\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x8b"		=> "\x8e\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x8d"		=> "\x8e\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x8e"		=> "\x8e\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x8f"		=> "\x8e\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x90"		=> "\x8e\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x91"		=> "\x8e\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x92"		=> "\x8e\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x93"		=> "\x8e\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x96"		=> "\x8e\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x97"		=> "\x8e\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x98"		=> "\x8e\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x99"		=> "\x8e\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x9a"		=> "\x8e\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x9c"		=> "\x8e\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x9d"		=> "\x8e\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x9f"		=> "\x8e\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa0"		=> "\x8e\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa3"		=> "\x8e\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa4"		=> "\x8e\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa5"		=> "\x8e\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa6"		=> "\x8e\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa7"		=> "\x8e\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa8"		=> "\x8e\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa9"		=> "\x8e\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xaa"		=> "\x8e\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xab"		=> "\x8e\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xac"		=> "\x8e\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xad"		=> "\x8e\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xae"		=> "\x8e\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xaf"		=> "\x8e\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb0"		=> "\x8e\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb1"		=> "\x8e\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb5"		=> "\x8e\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb7"		=> "\x8e\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb9"		=> "\x8e\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xbe"		=> "\x8e\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x81"		=> "\x8e\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x82"		=> "\x8e\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x83"		=> "\x8e\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x85"		=> "\x8e\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x88"		=> "\x8e\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x89"		=> "\x8e\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x8c"		=> "\x8e\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x8d"		=> "\x8e\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x8e"		=> "\x8e\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x92"		=> "\x8e\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x98"		=> "\x8e\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x9b"		=> "\x8e\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x9d"		=> "\x8e\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa1"		=> "\x8e\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa2"		=> "\x8e\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa3"		=> "\x8e\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa4"		=> "\x8e\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa8"		=> "\x8e\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa9"		=> "\x8e\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xaa"		=> "\x8e\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xab"		=> "\x8e\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xac"		=> "\x8e\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xae"		=> "\x8e\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xaf"		=> "\x8e\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb0"		=> "\x8e\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb1"		=> "\x8e\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb2"		=> "\x8e\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb4"		=> "\x8e\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xba"		=> "\x8e\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xbb"		=> "\x8e\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xbc"		=> "\x8e\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xbd"		=> "\x8e\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xbf"		=> "\x8e\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x80"		=> "\x8e\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x81"		=> "\x8e\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x82"		=> "\x8e\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x83"		=> "\x8e\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x84"		=> "\x8e\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x85"		=> "\x8e\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x86"		=> "\x8f\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x87"		=> "\x8f\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x88"		=> "\x8f\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x8b"		=> "\x8f\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x8c"		=> "\x8f\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x8d"		=> "\x8f\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x8e"		=> "\x8f\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x8f"		=> "\x8f\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x90"		=> "\x8f\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x94"		=> "\x8f\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x95"		=> "\x8f\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x97"		=> "\x8f\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x98"		=> "\x8f\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x99"		=> "\x8f\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x9a"		=> "\x8f\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x9c"		=> "\x8f\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x9d"		=> "\x8f\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x9e"		=> "\x8f\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x9f"		=> "\x8f\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa0"		=> "\x8f\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa1"		=> "\x8f\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa2"		=> "\x8f\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa3"		=> "\x8f\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa4"		=> "\x8f\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa5"		=> "\x8f\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa6"		=> "\x8f\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa7"		=> "\x8f\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa9"		=> "\x8f\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xab"		=> "\x8f\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xac"		=> "\x8f\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xad"		=> "\x8f\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xae"		=> "\x8f\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xaf"		=> "\x8f\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb0"		=> "\x8f\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb1"		=> "\x8f\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb2"		=> "\x8f\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb3"		=> "\x8f\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb5"		=> "\x8f\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb8"		=> "\x8f\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb9"		=> "\x8f\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xbb"		=> "\x8f\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xbc"		=> "\x8f\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xbd"		=> "\x8f\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x85"		=> "\x8f\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x86"		=> "\x8f\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x87"		=> "\x8f\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x89"		=> "\x8f\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x8c"		=> "\x8f\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x8d"		=> "\x8f\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x8e"		=> "\x8f\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x90"		=> "\x8f\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x92"		=> "\x8f\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x94"		=> "\x8f\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x96"		=> "\x8f\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x99"		=> "\x8f\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x9a"		=> "\x8f\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x9c"		=> "\x8f\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x9d"		=> "\x8f\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x9e"		=> "\x8f\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa1"		=> "\x8f\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa2"		=> "\x8f\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa3"		=> "\x8f\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa4"		=> "\x8f\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa8"		=> "\x8f\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xab"		=> "\x8f\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xac"		=> "\x8f\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xae"		=> "\x8f\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb0"		=> "\x8f\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb2"		=> "\x8f\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb3"		=> "\x8f\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb4"		=> "\x8f\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb5"		=> "\x8f\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb6"		=> "\x8f\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb7"		=> "\x8f\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb8"		=> "\x8f\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xbb"		=> "\x8f\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xbd"		=> "\x8f\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xbe"		=> "\x8f\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xbf"		=> "\x8f\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x81"		=> "\x8f\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x82"		=> "\x8f\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x83"		=> "\x8f\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x84"		=> "\x8f\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x85"		=> "\x8f\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x86"		=> "\x8f\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x87"		=> "\x8f\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x88"		=> "\x8f\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x89"		=> "\x8f\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x8a"		=> "\x8f\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x8b"		=> "\x8f\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x8c"		=> "\x8f\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x8d"		=> "\x8f\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x8e"		=> "\x8f\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x8f"		=> "\x8f\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x91"		=> "\x8f\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x94"		=> "\x8f\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x99"		=> "\x8f\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x9a"		=> "\x8f\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x9b"		=> "\x8f\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x9c"		=> "\x8f\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x9e"		=> "\x8f\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x9f"		=> "\x8f\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa0"		=> "\x8f\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa3"		=> "\x8f\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa5"		=> "\x8f\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa7"		=> "\x8f\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa8"		=> "\x8f\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xab"		=> "\x8f\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xae"		=> "\x8f\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xaf"		=> "\x8f\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb2"		=> "\x8f\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb4"		=> "\x8f\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb5"		=> "\x8f\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb6"		=> "\x8f\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb8"		=> "\x8f\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xba"		=> "\x8f\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xbd"		=> "\x8f\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xbe"		=> "\x8f\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xbf"		=> "\x8f\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x83"		=> "\x8f\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x86"		=> "\x8f\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x8d"		=> "\x8f\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x8e"		=> "\x8f\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x8f"		=> "\x8f\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x91"		=> "\x8f\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x93"		=> "\x8f\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x94"		=> "\x8f\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x96"		=> "\x8f\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x9a"		=> "\x8f\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x9b"		=> "\x8f\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x9d"		=> "\x8f\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x9e"		=> "\x8f\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x9f"		=> "\x8f\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa0"		=> "\x8f\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa2"		=> "\x8f\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa3"		=> "\x8f\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa4"		=> "\x8f\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa5"		=> "\x8f\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa6"		=> "\x8f\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa7"		=> "\x8f\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa9"		=> "\x8f\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xab"		=> "\x8f\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xac"		=> "\x8f\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xaf"		=> "\x8f\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb0"		=> "\x8f\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb1"		=> "\x8f\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb2"		=> "\x8f\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb3"		=> "\x8f\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb4"		=> "\x8f\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb6"		=> "\x8f\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb8"		=> "\x8f\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb9"		=> "\x8f\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xba"		=> "\x8f\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xbb"		=> "\x8f\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xbe"		=> "\x8f\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xbf"		=> "\x8f\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x80"		=> "\x8f\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x81"		=> "\x8f\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x82"		=> "\x8f\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x87"		=> "\x8f\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x88"		=> "\x8f\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x8a"		=> "\x8f\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x8b"		=> "\x8f\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x8e"		=> "\x8f\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x93"		=> "\x8f\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x94"		=> "\x8f\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x95"		=> "\x8f\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x9a"		=> "\x8f\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x9b"		=> "\x8f\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x9c"		=> "\x8f\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x9e"		=> "\x8f\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x9f"		=> "\x8f\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa2"		=> "\x8f\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa3"		=> "\x8f\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa5"		=> "\x8f\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa6"		=> "\x8f\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa8"		=> "\x8f\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa9"		=> "\x8f\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xac"		=> "\x8f\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xaf"		=> "\x8f\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb0"		=> "\x8f\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb2"		=> "\x8f\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb3"		=> "\x8f\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb4"		=> "\x8f\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb6"		=> "\x8f\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb7"		=> "\x8f\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb9"		=> "\x8f\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xba"		=> "\x8f\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xbc"		=> "\x8f\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x87"		=> "\x8f\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x88"		=> "\x90\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x89"		=> "\x90\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x8b"		=> "\x90\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x8c"		=> "\x90\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x90"		=> "\x90\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x91"		=> "\x90\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x93"		=> "\x90\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x97"		=> "\x90\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x98"		=> "\x90\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x9a"		=> "\x90\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x9e"		=> "\x90\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x9f"		=> "\x90\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa2"		=> "\x90\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa3"		=> "\x90\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa4"		=> "\x90\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xac"		=> "\x90\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xad"		=> "\x90\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xae"		=> "\x90\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb0"		=> "\x90\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb1"		=> "\x90\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb2"		=> "\x90\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb3"		=> "\x90\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb4"		=> "\x90\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb6"		=> "\x90\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb7"		=> "\x90\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb8"		=> "\x90\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb9"		=> "\x90\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xba"		=> "\x90\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xbd"		=> "\x90\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xbe"		=> "\x90\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x80"		=> "\x90\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x84"		=> "\x90\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x85"		=> "\x90\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x86"		=> "\x90\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x87"		=> "\x90\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x88"		=> "\x90\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x89"		=> "\x90\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x8a"		=> "\x90\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x8c"		=> "\x90\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x8e"		=> "\x90\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x8f"		=> "\x90\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x91"		=> "\x90\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x93"		=> "\x90\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x94"		=> "\x90\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x96"		=> "\x90\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x97"		=> "\x90\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x98"		=> "\x90\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x9b"		=> "\x90\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x9c"		=> "\x90\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x9e"		=> "\x90\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x9f"		=> "\x90\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa0"		=> "\x90\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa1"		=> "\x90\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa5"		=> "\x90\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa6"		=> "\x90\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xae"		=> "\x90\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb1"		=> "\x90\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb2"		=> "\x90\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb4"		=> "\x90\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb5"		=> "\x90\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb7"		=> "\x90\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xbe"		=> "\x90\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x80"		=> "\x90\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x81"		=> "\x90\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x82"		=> "\x90\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x85"		=> "\x90\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x86"		=> "\x90\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x87"		=> "\x90\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x88"		=> "\x90\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x8a"		=> "\x90\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x8b"		=> "\x90\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x8e"		=> "\x90\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x8f"		=> "\x90\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x90"		=> "\x90\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x91"		=> "\x90\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x93"		=> "\x90\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x95"		=> "\x90\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x97"		=> "\x90\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x98"		=> "\x90\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x99"		=> "\x90\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x9c"		=> "\x90\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x9e"		=> "\x90\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa1"		=> "\x90\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa2"		=> "\x90\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa4"		=> "\x90\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa5"		=> "\x90\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa7"		=> "\x90\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa9"		=> "\x90\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xaa"		=> "\x90\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xae"		=> "\x90\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb0"		=> "\x90\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb3"		=> "\x90\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb5"		=> "\x90\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb6"		=> "\x90\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb7"		=> "\x90\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb9"		=> "\x90\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xba"		=> "\x90\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xbd"		=> "\x90\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xbe"		=> "\x90\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xbf"		=> "\x90\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x80"		=> "\x90\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x81"		=> "\x90\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x82"		=> "\x90\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x83"		=> "\x90\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x84"		=> "\x90\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x87"		=> "\x90\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x88"		=> "\x90\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x89"		=> "\x90\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x8c"		=> "\x90\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x8d"		=> "\x90\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x8e"		=> "\x90\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x8f"		=> "\x90\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x90"		=> "\x90\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x92"		=> "\x90\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x93"		=> "\x90\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x94"		=> "\x90\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x96"		=> "\x90\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x97"		=> "\x90\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x99"		=> "\x90\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x9b"		=> "\x90\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x9e"		=> "\x90\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa1"		=> "\x90\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa2"		=> "\x90\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa3"		=> "\x90\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa4"		=> "\x90\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa5"		=> "\x90\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xaa"		=> "\x90\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb1"		=> "\x90\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb2"		=> "\x90\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb5"		=> "\x90\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb7"		=> "\x90\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb8"		=> "\x90\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xbb"		=> "\x90\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xbc"		=> "\x90\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xbd"		=> "\x90\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xbe"		=> "\x90\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xbf"		=> "\x90\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x82"		=> "\x90\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x83"		=> "\x90\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x84"		=> "\x90\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x85"		=> "\x90\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x87"		=> "\x90\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x8a"		=> "\x90\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x8b"		=> "\x90\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x8c"		=> "\x90\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x90"		=> "\x90\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x91"		=> "\x90\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x92"		=> "\x90\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x93"		=> "\x90\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x94"		=> "\x90\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x96"		=> "\x90\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x97"		=> "\x90\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x98"		=> "\x90\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x99"		=> "\x90\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x9b"		=> "\x90\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x9c"		=> "\x90\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x9d"		=> "\x90\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x9e"		=> "\x90\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa1"		=> "\x90\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa2"		=> "\x90\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa5"		=> "\x90\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa8"		=> "\x90\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa9"		=> "\x90\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xaa"		=> "\x90\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xac"		=> "\x90\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xad"		=> "\x90\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xae"		=> "\x90\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xaf"		=> "\x90\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb0"		=> "\x90\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb1"		=> "\x90\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb2"		=> "\x90\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb3"		=> "\x90\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb4"		=> "\x90\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb5"		=> "\x90\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb6"		=> "\x90\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb7"		=> "\x90\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb8"		=> "\x90\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xb9"		=> "\x90\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xba"		=> "\x90\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xbb"		=> "\x90\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xbc"		=> "\x90\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xbd"		=> "\x90\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xbe"		=> "\x90\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x80"		=> "\x90\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x81"		=> "\x90\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x82"		=> "\x90\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x83"		=> "\x90\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x84"		=> "\x90\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x85"		=> "\x90\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x86"		=> "\x90\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x87"		=> "\x91\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x89"		=> "\x91\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x8b"		=> "\x91\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x8d"		=> "\x91\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x8f"		=> "\x91\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x90"		=> "\x91\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x92"		=> "\x91\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x93"		=> "\x91\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x94"		=> "\x91\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x96"		=> "\x91\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x97"		=> "\x91\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x98"		=> "\x91\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x99"		=> "\x91\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x9a"		=> "\x91\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x9b"		=> "\x91\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x9c"		=> "\x91\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x9e"		=> "\x91\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x9f"		=> "\x91\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa0"		=> "\x91\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa1"		=> "\x91\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa3"		=> "\x91\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa4"		=> "\x91\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa5"		=> "\x91\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa6"		=> "\x91\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa9"		=> "\x91\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xaa"		=> "\x91\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xab"		=> "\x91\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xac"		=> "\x91\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xad"		=> "\x91\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xae"		=> "\x91\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xaf"		=> "\x91\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb1"		=> "\x91\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb2"		=> "\x91\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb3"		=> "\x91\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb4"		=> "\x91\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb6"		=> "\x91\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb8"		=> "\x91\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb9"		=> "\x91\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xba"		=> "\x91\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xbb"		=> "\x91\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xbc"		=> "\x91\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xbd"		=> "\x91\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xbe"		=> "\x91\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xbf"		=> "\x91\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x80"		=> "\x91\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x81"		=> "\x91\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x82"		=> "\x91\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x83"		=> "\x91\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x84"		=> "\x91\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x85"		=> "\x91\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x86"		=> "\x91\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x87"		=> "\x91\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x88"		=> "\x91\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x89"		=> "\x91\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x8a"		=> "\x91\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x8c"		=> "\x91\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x8d"		=> "\x91\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x8f"		=> "\x91\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x90"		=> "\x91\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x91"		=> "\x91\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x92"		=> "\x91\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x93"		=> "\x91\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x95"		=> "\x91\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x96"		=> "\x91\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x97"		=> "\x91\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x98"		=> "\x91\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x99"		=> "\x91\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x9a"		=> "\x91\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x9b"		=> "\x91\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x9c"		=> "\x91\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x9e"		=> "\x91\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x9f"		=> "\x91\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa0"		=> "\x91\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa1"		=> "\x91\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa2"		=> "\x91\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa3"		=> "\x91\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa4"		=> "\x91\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa5"		=> "\x91\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa6"		=> "\x91\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xaa"		=> "\x91\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xab"		=> "\x91\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xad"		=> "\x91\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xae"		=> "\x91\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xaf"		=> "\x91\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb0"		=> "\x91\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb1"		=> "\x91\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb2"		=> "\x91\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb3"		=> "\x91\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb4"		=> "\x91\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb5"		=> "\x91\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb6"		=> "\x91\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb8"		=> "\x91\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb9"		=> "\x91\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xba"		=> "\x91\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xbb"		=> "\x91\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xbc"		=> "\x91\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xbd"		=> "\x91\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xbf"		=> "\x91\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x80"		=> "\x91\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x81"		=> "\x91\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x83"		=> "\x91\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x84"		=> "\x91\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x85"		=> "\x91\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x86"		=> "\x91\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x87"		=> "\x91\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x89"		=> "\x91\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x8c"		=> "\x91\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x8d"		=> "\x91\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x8e"		=> "\x91\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x8f"		=> "\x91\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x90"		=> "\x91\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x93"		=> "\x91\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x95"		=> "\x91\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x96"		=> "\x91\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x97"		=> "\x91\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x98"		=> "\x91\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x99"		=> "\x91\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x9a"		=> "\x91\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x9b"		=> "\x91\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x9c"		=> "\x91\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x9d"		=> "\x91\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x9e"		=> "\x91\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x9f"		=> "\x91\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa0"		=> "\x91\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa1"		=> "\x91\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa2"		=> "\x91\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa3"		=> "\x91\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa4"		=> "\x91\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa5"		=> "\x91\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa7"		=> "\x91\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa8"		=> "\x91\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa9"		=> "\x91\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xaa"		=> "\x91\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xab"		=> "\x91\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xac"		=> "\x91\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xad"		=> "\x91\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xae"		=> "\x91\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xaf"		=> "\x91\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb0"		=> "\x91\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb1"		=> "\x91\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb2"		=> "\x91\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb3"		=> "\x91\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb4"		=> "\x91\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb6"		=> "\x91\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb7"		=> "\x91\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb8"		=> "\x91\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb9"		=> "\x91\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xba"		=> "\x91\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xbb"		=> "\x91\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xbc"		=> "\x91\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xbd"		=> "\x91\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xbe"		=> "\x91\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x80"		=> "\x91\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x81"		=> "\x91\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x82"		=> "\x91\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x83"		=> "\x91\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x84"		=> "\x91\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x85"		=> "\x91\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x87"		=> "\x91\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x89"		=> "\x91\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x93"		=> "\x91\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x94"		=> "\x91\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x99"		=> "\x91\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x9c"		=> "\x91\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x9d"		=> "\x91\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x9e"		=> "\x91\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xa0"		=> "\x91\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xa3"		=> "\x91\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xa6"		=> "\x91\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xa7"		=> "\x91\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xa8"		=> "\x91\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xa9"		=> "\x91\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xab"		=> "\x91\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xad"		=> "\x91\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xaf"		=> "\x91\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb0"		=> "\x91\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb1"		=> "\x91\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb2"		=> "\x91\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb5"		=> "\x91\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb6"		=> "\x91\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb8"		=> "\x91\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb9"		=> "\x91\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xba"		=> "\x91\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xbb"		=> "\x91\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xbc"		=> "\x91\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x82"		=> "\x91\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x84"		=> "\x91\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x85"		=> "\x91\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x86"		=> "\x91\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x8a"		=> "\x91\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x8f"		=> "\x92\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x90"		=> "\x92\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x95"		=> "\x92\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x96"		=> "\x92\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x97"		=> "\x92\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x99"		=> "\x92\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x9a"		=> "\x92\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x9c"		=> "\x92\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x9d"		=> "\x92\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x9e"		=> "\x92\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x9f"		=> "\x92\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa0"		=> "\x92\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa1"		=> "\x92\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa2"		=> "\x92\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa4"		=> "\x92\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa5"		=> "\x92\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa8"		=> "\x92\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb1"		=> "\x92\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb2"		=> "\x92\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb4"		=> "\x92\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb5"		=> "\x92\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb7"		=> "\x92\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb8"		=> "\x92\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xba"		=> "\x92\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xbb"		=> "\x92\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xbd"		=> "\x92\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x81"		=> "\x92\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x82"		=> "\x92\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x83"		=> "\x92\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x85"		=> "\x92\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x86"		=> "\x92\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x87"		=> "\x92\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x88"		=> "\x92\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x8b"		=> "\x92\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x8c"		=> "\x92\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x8d"		=> "\x92\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x8e"		=> "\x92\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x8f"		=> "\x92\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x90"		=> "\x92\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x94"		=> "\x92\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x99"		=> "\x92\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x9c"		=> "\x92\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x9d"		=> "\x92\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x9e"		=> "\x92\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa3"		=> "\x92\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa6"		=> "\x92\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa7"		=> "\x92\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa9"		=> "\x92\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xaa"		=> "\x92\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xad"		=> "\x92\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xae"		=> "\x92\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xaf"		=> "\x92\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb0"		=> "\x92\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb2"		=> "\x92\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb3"		=> "\x92\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb4"		=> "\x92\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb6"		=> "\x92\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb7"		=> "\x92\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb8"		=> "\x92\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xba"		=> "\x92\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xbe"		=> "\x92\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x80"		=> "\x92\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x81"		=> "\x92\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x83"		=> "\x92\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x8b"		=> "\x92\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x8f"		=> "\x92\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x91"		=> "\x92\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x95"		=> "\x92\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x9d"		=> "\x92\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x9e"		=> "\x92\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa0"		=> "\x92\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa1"		=> "\x92\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa4"		=> "\x92\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xaa"		=> "\x92\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xab"		=> "\x92\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb0"		=> "\x92\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb2"		=> "\x92\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb5"		=> "\x92\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb8"		=> "\x92\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb9"		=> "\x92\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xba"		=> "\x92\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xbb"		=> "\x92\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x80"		=> "\x92\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x83"		=> "\x92\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x84"		=> "\x92\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x85"		=> "\x92\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x86"		=> "\x92\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x8a"		=> "\x92\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x8b"		=> "\x92\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x8c"		=> "\x92\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x8d"		=> "\x92\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x8f"		=> "\x92\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x90"		=> "\x92\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x92"		=> "\x92\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x93"		=> "\x92\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x94"		=> "\x92\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x95"		=> "\x92\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x97"		=> "\x92\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x98"		=> "\x92\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x99"		=> "\x92\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x9c"		=> "\x92\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa6"		=> "\x92\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa7"		=> "\x92\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa9"		=> "\x92\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xac"		=> "\x92\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xad"		=> "\x92\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xae"		=> "\x92\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb0"		=> "\x92\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb1"		=> "\x92\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb3"		=> "\x92\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb4"		=> "\x92\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb5"		=> "\x92\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb6"		=> "\x92\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb7"		=> "\x92\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb8"		=> "\x92\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xbb"		=> "\x92\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xbc"		=> "\x92\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xbe"		=> "\x92\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xbf"		=> "\x92\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x80"		=> "\x92\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x81"		=> "\x92\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x84"		=> "\x92\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x87"		=> "\x92\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x88"		=> "\x92\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x8a"		=> "\x92\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x91"		=> "\x92\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x92"		=> "\x92\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x93"		=> "\x92\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x94"		=> "\x92\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x96"		=> "\x92\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x97"		=> "\x92\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x98"		=> "\x92\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x99"		=> "\x92\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x9a"		=> "\x92\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x9b"		=> "\x92\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x9c"		=> "\x92\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x9d"		=> "\x92\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa0"		=> "\x92\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa4"		=> "\x92\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa5"		=> "\x92\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa6"		=> "\x92\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa8"		=> "\x92\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xaa"		=> "\x92\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xab"		=> "\x92\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xac"		=> "\x92\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xaf"		=> "\x92\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb0"		=> "\x92\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb2"		=> "\x92\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb3"		=> "\x92\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb4"		=> "\x92\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb5"		=> "\x92\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb8"		=> "\x92\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb9"		=> "\x92\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xbc"		=> "\x92\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xbd"		=> "\x92\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xbe"		=> "\x92\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xbf"		=> "\x92\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x81"		=> "\x92\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x83"		=> "\x92\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x84"		=> "\x92\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x85"		=> "\x92\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x86"		=> "\x92\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x8b"		=> "\x92\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x8d"		=> "\x92\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x91"		=> "\x92\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x93"		=> "\x92\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x94"		=> "\x92\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x95"		=> "\x92\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x97"		=> "\x92\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x99"		=> "\x92\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x9a"		=> "\x92\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x9b"		=> "\x92\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x9c"		=> "\x92\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x9d"		=> "\x92\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x9e"		=> "\x92\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x9f"		=> "\x92\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa1"		=> "\x92\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa4"		=> "\x92\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa6"		=> "\x92\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xab"		=> "\x92\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xaf"		=> "\x92\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb1"		=> "\x92\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb2"		=> "\x92\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb5"		=> "\x92\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb6"		=> "\x92\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb9"		=> "\x92\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xbb"		=> "\x92\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xbd"		=> "\x92\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xbf"		=> "\x92\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x80"		=> "\x92\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x81"		=> "\x93\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x82"		=> "\x93\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x83"		=> "\x93\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x85"		=> "\x93\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x87"		=> "\x93\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x88"		=> "\x93\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x8a"		=> "\x93\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x8b"		=> "\x93\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x8c"		=> "\x93\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x91"		=> "\x93\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x93"		=> "\x93\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x94"		=> "\x93\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x95"		=> "\x93\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x97"		=> "\x93\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x98"		=> "\x93\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x99"		=> "\x93\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x9a"		=> "\x93\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x9b"		=> "\x93\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x9c"		=> "\x93\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x9d"		=> "\x93\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x9f"		=> "\x93\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa2"		=> "\x93\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa4"		=> "\x93\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa5"		=> "\x93\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa6"		=> "\x93\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa7"		=> "\x93\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa8"		=> "\x93\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xab"		=> "\x93\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xac"		=> "\x93\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xae"		=> "\x93\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xaf"		=> "\x93\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb0"		=> "\x93\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb1"		=> "\x93\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb3"		=> "\x93\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb5"		=> "\x93\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb7"		=> "\x93\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb9"		=> "\x93\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xba"		=> "\x93\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xbb"		=> "\x93\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xbc"		=> "\x93\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xbe"		=> "\x93\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x83"		=> "\x93\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x84"		=> "\x93\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x86"		=> "\x93\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x87"		=> "\x93\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x88"		=> "\x93\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x89"		=> "\x93\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x8a"		=> "\x93\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x8d"		=> "\x93\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x8e"		=> "\x93\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x91"		=> "\x93\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x92"		=> "\x93\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x95"		=> "\x93\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x96"		=> "\x93\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x97"		=> "\x93\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x98"		=> "\x93\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x99"		=> "\x93\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x9a"		=> "\x93\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x9d"		=> "\x93\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x9f"		=> "\x93\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa2"		=> "\x93\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa3"		=> "\x93\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa4"		=> "\x93\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa5"		=> "\x93\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa7"		=> "\x93\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa8"		=> "\x93\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa9"		=> "\x93\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xab"		=> "\x93\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xae"		=> "\x93\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xaf"		=> "\x93\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb0"		=> "\x93\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb1"		=> "\x93\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb2"		=> "\x93\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb3"		=> "\x93\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb5"		=> "\x93\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb6"		=> "\x93\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb7"		=> "\x93\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb8"		=> "\x93\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xb9"		=> "\x93\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xbb"		=> "\x93\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xbc"		=> "\x93\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xbe"		=> "\x93\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x80"		=> "\x93\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x82"		=> "\x93\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x83"		=> "\x93\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x89"		=> "\x93\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x8b"		=> "\x93\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x8c"		=> "\x93\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x8d"		=> "\x93\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x8e"		=> "\x93\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x8f"		=> "\x93\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x90"		=> "\x93\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x91"		=> "\x93\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x93"		=> "\x93\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x95"		=> "\x93\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x96"		=> "\x93\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x97"		=> "\x93\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x99"		=> "\x93\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x9a"		=> "\x93\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x9b"		=> "\x93\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x9c"		=> "\x93\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x9d"		=> "\x93\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x9f"		=> "\x93\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa0"		=> "\x93\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa1"		=> "\x93\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa2"		=> "\x93\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa3"		=> "\x93\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa4"		=> "\x93\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa5"		=> "\x93\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa6"		=> "\x93\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa8"		=> "\x93\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xaa"		=> "\x93\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xab"		=> "\x93\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xac"		=> "\x93\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xae"		=> "\x93\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xaf"		=> "\x93\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb0"		=> "\x93\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb1"		=> "\x93\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb2"		=> "\x93\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb3"		=> "\x93\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb4"		=> "\x93\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb5"		=> "\x93\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb6"		=> "\x93\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb7"		=> "\x93\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xbb"		=> "\x93\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xbc"		=> "\x93\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xbd"		=> "\x93\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xbe"		=> "\x93\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xbf"		=> "\x93\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x80"		=> "\x93\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x81"		=> "\x93\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x83"		=> "\x93\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x86"		=> "\x93\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x88"		=> "\x93\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x89"		=> "\x93\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x8a"		=> "\x93\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x8b"		=> "\x93\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x8c"		=> "\x93\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x8d"		=> "\x93\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x8e"		=> "\x93\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x8f"		=> "\x93\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x90"		=> "\x93\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x93"		=> "\x93\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x94"		=> "\x93\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x97"		=> "\x93\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x98"		=> "\x93\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x9a"		=> "\x93\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x9b"		=> "\x93\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x9c"		=> "\x93\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x9d"		=> "\x93\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x9f"		=> "\x93\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa0"		=> "\x93\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa1"		=> "\x93\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa2"		=> "\x93\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa3"		=> "\x93\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa5"		=> "\x93\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa6"		=> "\x93\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa7"		=> "\x93\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa8"		=> "\x93\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xaa"		=> "\x93\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xab"		=> "\x93\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xaf"		=> "\x93\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb1"		=> "\x93\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb2"		=> "\x93\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb3"		=> "\x93\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb4"		=> "\x93\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb6"		=> "\x93\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb9"		=> "\x93\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xbb"		=> "\x93\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xbd"		=> "\x93\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xbe"		=> "\x93\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xbf"		=> "\x93\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x81"		=> "\x93\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x83"		=> "\x93\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x84"		=> "\x93\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x86"		=> "\x93\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x87"		=> "\x93\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x88"		=> "\x93\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x89"		=> "\x93\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x8a"		=> "\x93\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x8b"		=> "\x93\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x8c"		=> "\x93\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x8f"		=> "\x93\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x91"		=> "\x93\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x93"		=> "\x93\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x94"		=> "\x93\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x95"		=> "\x93\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x96"		=> "\x93\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x99"		=> "\x93\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x9a"		=> "\x93\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x9b"		=> "\x94\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x9c"		=> "\x94\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x9d"		=> "\x94\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x9f"		=> "\x94\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa0"		=> "\x94\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa1"		=> "\x94\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa3"		=> "\x94\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa5"		=> "\x94\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa7"		=> "\x94\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa8"		=> "\x94\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa9"		=> "\x94\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xaa"		=> "\x94\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xab"		=> "\x94\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xac"		=> "\x94\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xad"		=> "\x94\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xae"		=> "\x94\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xaf"		=> "\x94\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb0"		=> "\x94\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb1"		=> "\x94\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb2"		=> "\x94\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb3"		=> "\x94\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb4"		=> "\x94\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb5"		=> "\x94\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb6"		=> "\x94\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb7"		=> "\x94\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb8"		=> "\x94\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xb9"		=> "\x94\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xba"		=> "\x94\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xbb"		=> "\x94\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xbc"		=> "\x94\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xbd"		=> "\x94\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xbe"		=> "\x94\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xbf"		=> "\x94\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x81"		=> "\x94\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x82"		=> "\x94\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x83"		=> "\x94\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x84"		=> "\x94\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x85"		=> "\x94\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x86"		=> "\x94\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x87"		=> "\x94\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x88"		=> "\x94\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x8a"		=> "\x94\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x8b"		=> "\x94\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x8c"		=> "\x94\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x8d"		=> "\x94\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x8e"		=> "\x94\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x8f"		=> "\x94\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x90"		=> "\x94\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x91"		=> "\x94\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x93"		=> "\x94\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x94"		=> "\x94\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x95"		=> "\x94\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x96"		=> "\x94\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x97"		=> "\x94\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x99"		=> "\x94\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x9a"		=> "\x94\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x9b"		=> "\x94\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x9c"		=> "\x94\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x9d"		=> "\x94\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x9e"		=> "\x94\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x9f"		=> "\x94\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa0"		=> "\x94\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa1"		=> "\x94\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa2"		=> "\x94\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa3"		=> "\x94\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa4"		=> "\x94\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa6"		=> "\x94\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa7"		=> "\x94\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa8"		=> "\x94\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa9"		=> "\x94\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xaa"		=> "\x94\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xac"		=> "\x94\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xad"		=> "\x94\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb0"		=> "\x94\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb1"		=> "\x94\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb2"		=> "\x94\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb3"		=> "\x94\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb7"		=> "\x94\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xba"		=> "\x94\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xbc"		=> "\x94\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xbd"		=> "\x94\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x80"		=> "\x94\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x81"		=> "\x94\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x82"		=> "\x94\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x83"		=> "\x94\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x84"		=> "\x94\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x86"		=> "\x94\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x87"		=> "\x94\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x8a"		=> "\x94\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x8b"		=> "\x94\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x8d"		=> "\x94\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x8e"		=> "\x94\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x90"		=> "\x94\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x92"		=> "\x94\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x93"		=> "\x94\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x94"		=> "\x94\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x97"		=> "\x94\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x98"		=> "\x94\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x9a"		=> "\x94\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x9c"		=> "\x94\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x9f"		=> "\x94\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa0"		=> "\x94\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa1"		=> "\x94\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa4"		=> "\x94\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa5"		=> "\x94\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa7"		=> "\x94\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa8"		=> "\x94\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa9"		=> "\x94\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xaa"		=> "\x94\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xad"		=> "\x94\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xae"		=> "\x94\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xaf"		=> "\x94\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb1"		=> "\x94\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb3"		=> "\x94\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb5"		=> "\x94\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb6"		=> "\x94\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb8"		=> "\x94\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb9"		=> "\x94\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xba"		=> "\x94\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xbb"		=> "\x94\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xbc"		=> "\x94\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xbd"		=> "\x94\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xbe"		=> "\x94\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xbf"		=> "\x94\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x80"		=> "\x94\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x81"		=> "\x94\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x82"		=> "\x94\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x83"		=> "\x94\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x84"		=> "\x94\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x85"		=> "\x94\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x86"		=> "\x94\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x88"		=> "\x94\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x89"		=> "\x94\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x8a"		=> "\x94\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x8d"		=> "\x94\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x8e"		=> "\x94\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x8f"		=> "\x94\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x92"		=> "\x94\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x94"		=> "\x94\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x95"		=> "\x94\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x96"		=> "\x94\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x98"		=> "\x94\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x9a"		=> "\x94\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x9d"		=> "\x94\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x9e"		=> "\x94\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa0"		=> "\x94\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa2"		=> "\x94\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa3"		=> "\x94\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa6"		=> "\x94\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa8"		=> "\x94\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xaa"		=> "\x94\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xac"		=> "\x94\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xae"		=> "\x94\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb1"		=> "\x94\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb2"		=> "\x94\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb3"		=> "\x94\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb4"		=> "\x94\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb5"		=> "\x94\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb6"		=> "\x94\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb7"		=> "\x94\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb8"		=> "\x94\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xba"		=> "\x94\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xbb"		=> "\x94\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xbe"		=> "\x94\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xbf"		=> "\x94\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x80"		=> "\x94\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x82"		=> "\x94\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x87"		=> "\x94\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x88"		=> "\x94\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x89"		=> "\x94\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x8a"		=> "\x94\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x8d"		=> "\x94\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x90"		=> "\x94\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x91"		=> "\x94\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x93"		=> "\x94\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x94"		=> "\x94\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x95"		=> "\x94\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x98"		=> "\x94\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x99"		=> "\x94\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x9a"		=> "\x94\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x9b"		=> "\x94\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x9c"		=> "\x94\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x9d"		=> "\x94\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x9e"		=> "\x94\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x9f"		=> "\x94\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa1"		=> "\x94\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa3"		=> "\x94\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa4"		=> "\x94\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xaa"		=> "\x94\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xab"		=> "\x94\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb2"		=> "\x95\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb3"		=> "\x95\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb4"		=> "\x95\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb5"		=> "\x95\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb8"		=> "\x95\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb9"		=> "\x95\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xbb"		=> "\x95\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xbc"		=> "\x95\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xbd"		=> "\x95\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xbe"		=> "\x95\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xbf"		=> "\x95\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x81"		=> "\x95\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x84"		=> "\x95\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x85"		=> "\x95\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x87"		=> "\x95\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x88"		=> "\x95\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x89"		=> "\x95\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x8b"		=> "\x95\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x8d"		=> "\x95\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x90"		=> "\x95\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x91"		=> "\x95\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x92"		=> "\x95\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x96"		=> "\x95\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x97"		=> "\x95\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x98"		=> "\x95\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x9a"		=> "\x95\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x9b"		=> "\x95\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x9c"		=> "\x95\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x9e"		=> "\x95\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa1"		=> "\x95\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa2"		=> "\x95\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa3"		=> "\x95\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa4"		=> "\x95\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa6"		=> "\x95\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa9"		=> "\x95\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xaa"		=> "\x95\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xab"		=> "\x95\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xac"		=> "\x95\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xae"		=> "\x95\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xb0"		=> "\x95\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xb2"		=> "\x95\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xb3"		=> "\x95\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xb7"		=> "\x95\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xb8"		=> "\x95\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xb9"		=> "\x95\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xba"		=> "\x95\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xbb"		=> "\x95\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xbd"		=> "\x95\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xbf"		=> "\x95\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x80"		=> "\x95\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x82"		=> "\x95\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x84"		=> "\x95\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x85"		=> "\x95\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x86"		=> "\x95\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x87"		=> "\x95\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x88"		=> "\x95\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x89"		=> "\x95\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x8a"		=> "\x95\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x8d"		=> "\x95\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x8e"		=> "\x95\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x90"		=> "\x95\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x91"		=> "\x95\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x98"		=> "\x95\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x99"		=> "\x95\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x9b"		=> "\x95\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x9c"		=> "\x95\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x9d"		=> "\x95\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x9e"		=> "\x95\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa0"		=> "\x95\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa2"		=> "\x95\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa3"		=> "\x95\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa5"		=> "\x95\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa7"		=> "\x95\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa9"		=> "\x95\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xaa"		=> "\x95\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xab"		=> "\x95\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xac"		=> "\x95\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xad"		=> "\x95\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb1"		=> "\x95\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb2"		=> "\x95\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb3"		=> "\x95\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb5"		=> "\x95\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb8"		=> "\x95\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb9"		=> "\x95\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xbb"		=> "\x95\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xbc"		=> "\x95\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xbd"		=> "\x95\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xbf"		=> "\x95\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x80"		=> "\x95\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x81"		=> "\x95\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x83"		=> "\x95\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x85"		=> "\x95\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x86"		=> "\x95\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x88"		=> "\x95\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x89"		=> "\x95\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x8a"		=> "\x95\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x8b"		=> "\x95\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x8d"		=> "\x95\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x8e"		=> "\x95\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x8f"		=> "\x95\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x90"		=> "\x95\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x92"		=> "\x95\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x93"		=> "\x95\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x94"		=> "\x95\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x95"		=> "\x95\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x98"		=> "\x95\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x99"		=> "\x95\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x9a"		=> "\x95\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x9b"		=> "\x95\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x9c"		=> "\x95\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x9e"		=> "\x95\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x9f"		=> "\x95\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa0"		=> "\x95\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa1"		=> "\x95\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa2"		=> "\x95\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa3"		=> "\x95\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa4"		=> "\x95\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa5"		=> "\x95\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa6"		=> "\x95\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xa9"		=> "\x95\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xaa"		=> "\x95\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xab"		=> "\x95\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xac"		=> "\x95\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xad"		=> "\x95\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xaf"		=> "\x95\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb0"		=> "\x95\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb1"		=> "\x95\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb2"		=> "\x95\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb3"		=> "\x95\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb5"		=> "\x95\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb6"		=> "\x95\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb7"		=> "\x95\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb8"		=> "\x95\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xba"		=> "\x95\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xbb"		=> "\x95\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xbc"		=> "\x95\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xbd"		=> "\x95\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xbf"		=> "\x95\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x80"		=> "\x95\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x81"		=> "\x95\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x82"		=> "\x95\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x83"		=> "\x95\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x84"		=> "\x95\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x85"		=> "\x95\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x86"		=> "\x95\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x87"		=> "\x95\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x88"		=> "\x95\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x89"		=> "\x95\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x8a"		=> "\x95\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x8b"		=> "\x95\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x8c"		=> "\x95\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x8d"		=> "\x95\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x8e"		=> "\x95\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x8f"		=> "\x95\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x90"		=> "\x95\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x91"		=> "\x95\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x92"		=> "\x95\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x93"		=> "\x95\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x94"		=> "\x95\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x95"		=> "\x95\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x96"		=> "\x95\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x97"		=> "\x95\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x98"		=> "\x95\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x9a"		=> "\x95\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x9e"		=> "\x95\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x9f"		=> "\x95\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa0"		=> "\x95\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa1"		=> "\x95\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa2"		=> "\x95\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa3"		=> "\x95\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa4"		=> "\x95\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa5"		=> "\x95\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa7"		=> "\x95\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xa8"		=> "\x95\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xaa"		=> "\x95\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xab"		=> "\x95\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xac"		=> "\x95\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xad"		=> "\x95\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xae"		=> "\x95\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xaf"		=> "\x95\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb1"		=> "\x95\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb5"		=> "\x95\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb6"		=> "\x95\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb8"		=> "\x95\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xba"		=> "\x95\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xbb"		=> "\x95\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xbd"		=> "\x95\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x81"		=> "\x95\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x82"		=> "\x95\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x83"		=> "\x95\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x84"		=> "\x96\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x85"		=> "\x96\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x86"		=> "\x96\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x87"		=> "\x96\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x8c"		=> "\x96\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x8e"		=> "\x96\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x8f"		=> "\x96\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x91"		=> "\x96\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x92"		=> "\x96\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x93"		=> "\x96\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x96"		=> "\x96\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x98"		=> "\x96\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x99"		=> "\x96\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x9a"		=> "\x96\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x9c"		=> "\x96\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x9e"		=> "\x96\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa0"		=> "\x96\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa1"		=> "\x96\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa2"		=> "\x96\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa3"		=> "\x96\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa4"		=> "\x96\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa5"		=> "\x96\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa7"		=> "\x96\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa9"		=> "\x96\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xae"		=> "\x96\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb0"		=> "\x96\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb2"		=> "\x96\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb3"		=> "\x96\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb6"		=> "\x96\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb7"		=> "\x96\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb8"		=> "\x96\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb9"		=> "\x96\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xbb"		=> "\x96\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xbc"		=> "\x96\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xbe"		=> "\x96\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xbf"		=> "\x96\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x81"		=> "\x96\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x84"		=> "\x96\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x85"		=> "\x96\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x87"		=> "\x96\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x8a"		=> "\x96\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x8b"		=> "\x96\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x8d"		=> "\x96\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x92"		=> "\x96\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x94"		=> "\x96\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x95"		=> "\x96\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x97"		=> "\x96\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x98"		=> "\x96\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x99"		=> "\x96\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x9a"		=> "\x96\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x9b"		=> "\x96\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x9d"		=> "\x96\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa2"		=> "\x96\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa3"		=> "\x96\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa4"		=> "\x96\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa6"		=> "\x96\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa7"		=> "\x96\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xab"		=> "\x96\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xac"		=> "\x96\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xae"		=> "\x96\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xb1"		=> "\x96\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xb4"		=> "\x96\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xb6"		=> "\x96\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xb8"		=> "\x96\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xb9"		=> "\x96\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xba"		=> "\x96\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xbb"		=> "\x96\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xbd"		=> "\x96\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x80"		=> "\x96\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x82"		=> "\x96\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x83"		=> "\x96\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x85"		=> "\x96\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x86"		=> "\x96\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x88"		=> "\x96\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x8a"		=> "\x96\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x8c"		=> "\x96\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x8d"		=> "\x96\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x8e"		=> "\x96\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x8f"		=> "\x96\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x91"		=> "\x96\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x92"		=> "\x96\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x93"		=> "\x96\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x94"		=> "\x96\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x96"		=> "\x96\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x99"		=> "\x96\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x9b"		=> "\x96\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x9f"		=> "\x96\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa0"		=> "\x96\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa1"		=> "\x96\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa4"		=> "\x96\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa6"		=> "\x96\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa9"		=> "\x96\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xac"		=> "\x96\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xae"		=> "\x96\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xb1"		=> "\x96\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xb2"		=> "\x96\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xb4"		=> "\x96\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xb9"		=> "\x96\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xba"		=> "\x96\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xbb"		=> "\x96\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xbc"		=> "\x96\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xbd"		=> "\x96\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xbe"		=> "\x96\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xbf"		=> "\x96\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x80"		=> "\x96\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x82"		=> "\x96\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x85"		=> "\x96\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x86"		=> "\x96\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x87"		=> "\x96\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x88"		=> "\x96\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x89"		=> "\x96\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x8a"		=> "\x96\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x8b"		=> "\x96\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x8c"		=> "\x96\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x8d"		=> "\x96\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x8e"		=> "\x96\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x95"		=> "\x96\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x96"		=> "\x96\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x97"		=> "\x96\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x9b"		=> "\x96\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x9f"		=> "\x96\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa1"		=> "\x96\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa3"		=> "\x96\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa4"		=> "\x96\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa6"		=> "\x96\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa7"		=> "\x96\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa8"		=> "\x96\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xaa"		=> "\x96\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xab"		=> "\x96\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xad"		=> "\x96\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xae"		=> "\x96\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb2"		=> "\x96\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb5"		=> "\x96\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb6"		=> "\x96\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb7"		=> "\x96\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb8"		=> "\x96\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb9"		=> "\x96\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xba"		=> "\x96\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xbb"		=> "\x96\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xbc"		=> "\x96\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xbe"		=> "\x96\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x81"		=> "\x96\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x82"		=> "\x96\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x83"		=> "\x96\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x84"		=> "\x96\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x86"		=> "\x96\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x8d"		=> "\x96\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x90"		=> "\x96\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x92"		=> "\x96\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x94"		=> "\x96\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x95"		=> "\x96\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x98"		=> "\x96\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x99"		=> "\x96\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x9a"		=> "\x96\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x9b"		=> "\x96\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x9c"		=> "\x96\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x9e"		=> "\x96\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x9f"		=> "\x96\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa0"		=> "\x96\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa2"		=> "\x96\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa3"		=> "\x96\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa4"		=> "\x96\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa5"		=> "\x96\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa6"		=> "\x96\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa7"		=> "\x96\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa8"		=> "\x96\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xab"		=> "\x96\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xac"		=> "\x96\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xad"		=> "\x96\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xae"		=> "\x96\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xaf"		=> "\x96\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb0"		=> "\x96\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb1"		=> "\x96\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb4"		=> "\x96\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb5"		=> "\x96\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb6"		=> "\x96\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xba"		=> "\x96\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xbb"		=> "\x96\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xbf"		=> "\x96\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x87"		=> "\x96\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x8b"		=> "\x96\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x8d"		=> "\x96\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x8f"		=> "\x96\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x92"		=> "\x96\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x96"		=> "\x96\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x97"		=> "\x96\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x98"		=> "\x96\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x99"		=> "\x96\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x9a"		=> "\x96\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x9b"		=> "\x96\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x9c"		=> "\x97\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x9d"		=> "\x97\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x9e"		=> "\x97\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x9f"		=> "\x97\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xaa"		=> "\x97\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xac"		=> "\x97\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xad"		=> "\x97\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xae"		=> "\x97\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xaf"		=> "\x97\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb0"		=> "\x97\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb1"		=> "\x97\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb2"		=> "\x97\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb3"		=> "\x97\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb5"		=> "\x97\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb8"		=> "\x97\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb9"		=> "\x97\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xba"		=> "\x97\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xbb"		=> "\x97\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xbc"		=> "\x97\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xbd"		=> "\x97\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xbe"		=> "\x97\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xbf"		=> "\x97\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x80"		=> "\x97\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x82"		=> "\x97\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x84"		=> "\x97\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x87"		=> "\x97\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x88"		=> "\x97\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x89"		=> "\x97\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x8a"		=> "\x97\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x8b"		=> "\x97\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x8c"		=> "\x97\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x8d"		=> "\x97\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x8e"		=> "\x97\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x90"		=> "\x97\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x91"		=> "\x97\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x92"		=> "\x97\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x94"		=> "\x97\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x95"		=> "\x97\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x96"		=> "\x97\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x98"		=> "\x97\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x99"		=> "\x97\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x9a"		=> "\x97\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x9b"		=> "\x97\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x9c"		=> "\x97\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x9d"		=> "\x97\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x9e"		=> "\x97\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x9f"		=> "\x97\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa0"		=> "\x97\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa1"		=> "\x97\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa3"		=> "\x97\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa4"		=> "\x97\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa5"		=> "\x97\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa9"		=> "\x97\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xaa"		=> "\x97\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xab"		=> "\x97\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xac"		=> "\x97\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xae"		=> "\x97\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb1"		=> "\x97\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb2"		=> "\x97\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb4"		=> "\x97\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb6"		=> "\x97\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb7"		=> "\x97\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb8"		=> "\x97\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb9"		=> "\x97\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xba"		=> "\x97\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xbb"		=> "\x97\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xbc"		=> "\x97\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xbd"		=> "\x97\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xbe"		=> "\x97\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xbf"		=> "\x97\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x81"		=> "\x97\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x83"		=> "\x97\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x84"		=> "\x97\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x85"		=> "\x97\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x86"		=> "\x97\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x87"		=> "\x97\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x88"		=> "\x97\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x8a"		=> "\x97\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x8c"		=> "\x97\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x8e"		=> "\x97\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x8f"		=> "\x97\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x90"		=> "\x97\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x91"		=> "\x97\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x93"		=> "\x97\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x94"		=> "\x97\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x96"		=> "\x97\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x97"		=> "\x97\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x99"		=> "\x97\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x9b"		=> "\x97\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x9c"		=> "\x97\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x9d"		=> "\x97\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x9e"		=> "\x97\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x9f"		=> "\x97\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa1"		=> "\x97\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa2"		=> "\x97\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa4"		=> "\x97\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa5"		=> "\x97\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa6"		=> "\x97\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa7"		=> "\x97\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa8"		=> "\x97\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa9"		=> "\x97\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xaa"		=> "\x97\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xab"		=> "\x97\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xac"		=> "\x97\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xad"		=> "\x97\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xaf"		=> "\x97\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb2"		=> "\x97\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb3"		=> "\x97\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb4"		=> "\x97\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb6"		=> "\x97\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb7"		=> "\x97\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb8"		=> "\x97\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xbb"		=> "\x97\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xbd"		=> "\x97\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xbe"		=> "\x97\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xbf"		=> "\x97\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x80"		=> "\x97\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x82"		=> "\x97\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x83"		=> "\x97\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x84"		=> "\x97\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x86"		=> "\x97\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x87"		=> "\x97\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x88"		=> "\x97\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x89"		=> "\x97\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x8a"		=> "\x97\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x8c"		=> "\x97\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x8f"		=> "\x97\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x91"		=> "\x97\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x93"		=> "\x97\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x94"		=> "\x97\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x95"		=> "\x97\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x96"		=> "\x97\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x97"		=> "\x97\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x98"		=> "\x97\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x99"		=> "\x97\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x9a"		=> "\x97\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x9b"		=> "\x97\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x9c"		=> "\x97\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x9d"		=> "\x97\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x9e"		=> "\x97\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa1"		=> "\x97\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa2"		=> "\x97\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa3"		=> "\x97\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa5"		=> "\x97\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa6"		=> "\x97\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa7"		=> "\x97\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa8"		=> "\x97\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xa9"		=> "\x97\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xaa"		=> "\x97\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xab"		=> "\x97\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xac"		=> "\x97\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xae"		=> "\x97\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xaf"		=> "\x97\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb1"		=> "\x97\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb2"		=> "\x97\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb3"		=> "\x97\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb5"		=> "\x97\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb6"		=> "\x97\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb7"		=> "\x97\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb8"		=> "\x97\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xba"		=> "\x97\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xbb"		=> "\x97\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xbc"		=> "\x97\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xbe"		=> "\x97\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x80"		=> "\x97\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x81"		=> "\x97\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x83"		=> "\x97\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x84"		=> "\x97\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x85"		=> "\x97\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x86"		=> "\x97\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x87"		=> "\x97\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x88"		=> "\x97\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x89"		=> "\x97\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x8a"		=> "\x97\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x8b"		=> "\x97\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x8c"		=> "\x97\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x8d"		=> "\x97\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x8e"		=> "\x97\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x8f"		=> "\x97\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x90"		=> "\x97\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x91"		=> "\x97\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x92"		=> "\x97\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x93"		=> "\x97\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x95"		=> "\x97\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x96"		=> "\x97\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x98"		=> "\x97\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x99"		=> "\x97\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x9b"		=> "\x97\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x9c"		=> "\x97\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x9f"		=> "\x97\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa1"		=> "\x98\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa2"		=> "\x98\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa4"		=> "\x98\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa5"		=> "\x98\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa7"		=> "\x98\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa8"		=> "\x98\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xa9"		=> "\x98\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xaa"		=> "\x98\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xac"		=> "\x98\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xad"		=> "\x98\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xaf"		=> "\x98\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb0"		=> "\x98\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb2"		=> "\x98\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb3"		=> "\x98\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb4"		=> "\x98\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb5"		=> "\x98\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb6"		=> "\x98\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xba"		=> "\x98\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xbb"		=> "\x98\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xbd"		=> "\x98\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xbe"		=> "\x98\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xbf"		=> "\x98\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x81"		=> "\x98\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x83"		=> "\x98\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x85"		=> "\x98\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x8a"		=> "\x98\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x8b"		=> "\x98\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x8c"		=> "\x98\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x8e"		=> "\x98\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x8f"		=> "\x98\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x90"		=> "\x98\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x91"		=> "\x98\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x92"		=> "\x98\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x93"		=> "\x98\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x96"		=> "\x98\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x97"		=> "\x98\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x99"		=> "\x98\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x9a"		=> "\x98\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x9d"		=> "\x98\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x9e"		=> "\x98\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x9f"		=> "\x98\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa0"		=> "\x98\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa1"		=> "\x98\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa2"		=> "\x98\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa3"		=> "\x98\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa4"		=> "\x98\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa5"		=> "\x98\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa6"		=> "\x98\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa9"		=> "\x98\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xaa"		=> "\x98\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xac"		=> "\x98\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xae"		=> "\x98\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xaf"		=> "\x98\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb0"		=> "\x98\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb2"		=> "\x98\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb3"		=> "\x98\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb5"		=> "\x98\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb6"		=> "\x98\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb8"		=> "\x98\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb9"		=> "\x98\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xba"		=> "\x98\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xbc"		=> "\x98\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xbd"		=> "\x98\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xbe"		=> "\x98\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xbf"		=> "\x98\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x80"		=> "\x98\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x82"		=> "\x98\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x83"		=> "\x98\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x84"		=> "\x98\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x85"		=> "\x98\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x86"		=> "\x98\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x87"		=> "\x98\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x88"		=> "\x98\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x89"		=> "\x98\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x8b"		=> "\x98\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x8d"		=> "\x98\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x8f"		=> "\x98\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x91"		=> "\x98\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x92"		=> "\x98\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x93"		=> "\x98\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x95"		=> "\x98\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x96"		=> "\x98\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x97"		=> "\x98\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x98"		=> "\x98\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x99"		=> "\x98\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x9a"		=> "\x98\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x9c"		=> "\x98\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x9d"		=> "\x98\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x9e"		=> "\x98\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa1"		=> "\x98\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa2"		=> "\x98\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa3"		=> "\x98\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa4"		=> "\x98\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa5"		=> "\x98\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa6"		=> "\x98\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa7"		=> "\x98\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa8"		=> "\x98\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xa9"		=> "\x98\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xaa"		=> "\x98\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xab"		=> "\x98\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xac"		=> "\x98\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xae"		=> "\x98\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xaf"		=> "\x98\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb0"		=> "\x98\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb1"		=> "\x98\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb3"		=> "\x98\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb4"		=> "\x98\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb5"		=> "\x98\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb6"		=> "\x98\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb7"		=> "\x98\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb8"		=> "\x98\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xb9"		=> "\x98\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xba"		=> "\x98\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xbb"		=> "\x98\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xbc"		=> "\x98\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xbe"		=> "\x98\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x80"		=> "\x98\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x81"		=> "\x98\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x82"		=> "\x98\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x83"		=> "\x98\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x84"		=> "\x98\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x85"		=> "\x98\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x86"		=> "\x98\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x87"		=> "\x98\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x88"		=> "\x98\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x89"		=> "\x98\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x8b"		=> "\x98\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x8c"		=> "\x98\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x8d"		=> "\x98\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x8e"		=> "\x98\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x8f"		=> "\x98\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x90"		=> "\x98\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x91"		=> "\x98\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x92"		=> "\x98\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x93"		=> "\x98\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x94"		=> "\x98\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x95"		=> "\x98\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x96"		=> "\x98\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x99"		=> "\x98\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x9a"		=> "\x98\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x9b"		=> "\x98\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x9c"		=> "\x98\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x9d"		=> "\x98\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x9e"		=> "\x98\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa0"		=> "\x98\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa2"		=> "\x98\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa3"		=> "\x98\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa4"		=> "\x98\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa5"		=> "\x98\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa6"		=> "\x98\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa7"		=> "\x98\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa9"		=> "\x98\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xab"		=> "\x98\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xac"		=> "\x98\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xad"		=> "\x98\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xae"		=> "\x98\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb0"		=> "\x98\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb2"		=> "\x98\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb3"		=> "\x98\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb4"		=> "\x98\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb6"		=> "\x98\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb7"		=> "\x98\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb8"		=> "\x98\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb9"		=> "\x98\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xba"		=> "\x98\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xbb"		=> "\x98\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xbc"		=> "\x98\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xbf"		=> "\x98\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x80"		=> "\x98\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x81"		=> "\x98\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x82"		=> "\x98\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x83"		=> "\x98\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x85"		=> "\x98\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x86"		=> "\x98\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x88"		=> "\x98\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x89"		=> "\x98\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x8a"		=> "\x98\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x8b"		=> "\x98\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x8c"		=> "\x98\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x8d"		=> "\x98\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x8e"		=> "\x98\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x8f"		=> "\x98\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x91"		=> "\x98\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x92"		=> "\x98\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x93"		=> "\x98\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x94"		=> "\x98\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x95"		=> "\x98\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x96"		=> "\x98\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x97"		=> "\x98\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x9a"		=> "\x98\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x9c"		=> "\x99\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x9d"		=> "\x99\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x9e"		=> "\x99\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x9f"		=> "\x99\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa0"		=> "\x99\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa2"		=> "\x99\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa3"		=> "\x99\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa4"		=> "\x99\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa6"		=> "\x99\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa7"		=> "\x99\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa8"		=> "\x99\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa9"		=> "\x99\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xaa"		=> "\x99\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xab"		=> "\x99\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xac"		=> "\x99\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xad"		=> "\x99\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xae"		=> "\x99\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xaf"		=> "\x99\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb0"		=> "\x99\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb2"		=> "\x99\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb3"		=> "\x99\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb4"		=> "\x99\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb5"		=> "\x99\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb6"		=> "\x99\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb7"		=> "\x99\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb8"		=> "\x99\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xba"		=> "\x99\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xbb"		=> "\x99\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xbd"		=> "\x99\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xbe"		=> "\x99\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xbf"		=> "\x99\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x81"		=> "\x99\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x82"		=> "\x99\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x83"		=> "\x99\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x85"		=> "\x99\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x86"		=> "\x99\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x87"		=> "\x99\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x88"		=> "\x99\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x89"		=> "\x99\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x8a"		=> "\x99\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x8b"		=> "\x99\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x8c"		=> "\x99\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x8d"		=> "\x99\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x8f"		=> "\x99\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x92"		=> "\x99\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x93"		=> "\x99\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x94"		=> "\x99\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x95"		=> "\x99\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x96"		=> "\x99\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x98"		=> "\x99\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x99"		=> "\x99\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x9a"		=> "\x99\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x9b"		=> "\x99\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x9c"		=> "\x99\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x9d"		=> "\x99\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x9e"		=> "\x99\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x9f"		=> "\x99\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa1"		=> "\x99\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa2"		=> "\x99\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa3"		=> "\x99\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa4"		=> "\x99\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa5"		=> "\x99\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa6"		=> "\x99\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa7"		=> "\x99\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xa8"		=> "\x99\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xaa"		=> "\x99\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xad"		=> "\x99\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xae"		=> "\x99\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xaf"		=> "\x99\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb0"		=> "\x99\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb1"		=> "\x99\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb2"		=> "\x99\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb3"		=> "\x99\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb4"		=> "\x99\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb5"		=> "\x99\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb6"		=> "\x99\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb7"		=> "\x99\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb8"		=> "\x99\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xb9"		=> "\x99\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xba"		=> "\x99\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xbb"		=> "\x99\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xbc"		=> "\x99\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xbd"		=> "\x99\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xbe"		=> "\x99\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xbf"		=> "\x99\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x80"		=> "\x99\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x81"		=> "\x99\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x82"		=> "\x99\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x83"		=> "\x99\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x84"		=> "\x99\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x85"		=> "\x99\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x86"		=> "\x99\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x87"		=> "\x99\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x88"		=> "\x99\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x89"		=> "\x99\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x8a"		=> "\x99\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x8b"		=> "\x99\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x8c"		=> "\x99\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x8d"		=> "\x99\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x8e"		=> "\x99\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x8f"		=> "\x99\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x90"		=> "\x99\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x91"		=> "\x99\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x92"		=> "\x99\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x93"		=> "\x99\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x94"		=> "\x99\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x95"		=> "\x99\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x96"		=> "\x99\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x97"		=> "\x99\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x98"		=> "\x99\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x99"		=> "\x99\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x9a"		=> "\x99\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x9b"		=> "\x99\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x9c"		=> "\x99\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x9d"		=> "\x99\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x9e"		=> "\x99\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\x9f"		=> "\x99\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa0"		=> "\x99\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa1"		=> "\x99\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa2"		=> "\x99\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa3"		=> "\x99\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa4"		=> "\x99\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa5"		=> "\x99\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa6"		=> "\x99\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa7"		=> "\x99\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa8"		=> "\x99\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xa9"		=> "\x99\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xaa"		=> "\x99\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xab"		=> "\x99\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xac"		=> "\x99\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xad"		=> "\x99\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xae"		=> "\x99\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xaf"		=> "\x99\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb0"		=> "\x99\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb1"		=> "\x99\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb2"		=> "\x99\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb3"		=> "\x99\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb4"		=> "\x99\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb5"		=> "\x99\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb6"		=> "\x99\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb7"		=> "\x99\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb8"		=> "\x99\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xb9"		=> "\x99\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xba"		=> "\x99\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xbb"		=> "\x99\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xbc"		=> "\x99\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xbd"		=> "\x99\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xbe"		=> "\x99\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xab\xbf"		=> "\x99\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x80"		=> "\x99\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x81"		=> "\x99\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x82"		=> "\x99\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x83"		=> "\x99\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x84"		=> "\x99\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x85"		=> "\x99\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x86"		=> "\x99\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x87"		=> "\x99\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x88"		=> "\x99\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x89"		=> "\x99\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x8a"		=> "\x99\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x8b"		=> "\x99\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x8c"		=> "\x99\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x8d"		=> "\x99\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x8e"		=> "\x99\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x8f"		=> "\x99\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x90"		=> "\x99\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x91"		=> "\x99\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x92"		=> "\x99\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x93"		=> "\x99\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x94"		=> "\x99\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x95"		=> "\x99\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x96"		=> "\x99\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x97"		=> "\x99\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x98"		=> "\x99\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x99"		=> "\x99\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x9a"		=> "\x99\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x9b"		=> "\x99\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x9c"		=> "\x99\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x9d"		=> "\x99\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x9e"		=> "\x99\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\x9f"		=> "\x99\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa5"		=> "\x99\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa6"		=> "\x99\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa8"		=> "\x99\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa9"		=> "\x99\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xaa"		=> "\x99\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xab"		=> "\x99\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xac"		=> "\x99\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xad"		=> "\x99\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xae"		=> "\x99\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xaf"		=> "\x9a\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb0"		=> "\x9a\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb1"		=> "\x9a\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb3"		=> "\x9a\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb4"		=> "\x9a\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb5"		=> "\x9a\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb6"		=> "\x9a\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb8"		=> "\x9a\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xbb"		=> "\x9a\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xbc"		=> "\x9a\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xbd"		=> "\x9a\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xbf"		=> "\x9a\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x80"		=> "\x9a\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x81"		=> "\x9a\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x82"		=> "\x9a\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x84"		=> "\x9a\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x85"		=> "\x9a\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x88"		=> "\x9a\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x8a"		=> "\x9a\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x8b"		=> "\x9a\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x8d"		=> "\x9a\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x8e"		=> "\x9a\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x8f"		=> "\x9a\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x90"		=> "\x9a\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x91"		=> "\x9a\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x92"		=> "\x9a\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x93"		=> "\x9a\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x94"		=> "\x9a\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x95"		=> "\x9a\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x96"		=> "\x9a\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x97"		=> "\x9a\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x98"		=> "\x9a\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x9a"		=> "\x9a\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x9b"		=> "\x9a\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x9c"		=> "\x9a\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x9d"		=> "\x9a\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x9e"		=> "\x9a\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x9f"		=> "\x9a\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa0"		=> "\x9a\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa1"		=> "\x9a\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa8"		=> "\x9a\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa9"		=> "\x9a\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xab"		=> "\x9a\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xac"		=> "\x9a\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xad"		=> "\x9a\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xae"		=> "\x9a\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xaf"		=> "\x9a\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb0"		=> "\x9a\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb1"		=> "\x9a\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb2"		=> "\x9a\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb3"		=> "\x9a\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb4"		=> "\x9a\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb5"		=> "\x9a\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb6"		=> "\x9a\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb7"		=> "\x9a\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb8"		=> "\x9a\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xba"		=> "\x9a\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xbd"		=> "\x9a\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xbe"		=> "\x9a\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xbf"		=> "\x9a\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x80"		=> "\x9a\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x85"		=> "\x9a\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x88"		=> "\x9a\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x8c"		=> "\x9a\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x8e"		=> "\x9a\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x8f"		=> "\x9a\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x90"		=> "\x9a\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x91"		=> "\x9a\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x94"		=> "\x9a\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x95"		=> "\x9a\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x97"		=> "\x9a\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x98"		=> "\x9a\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x99"		=> "\x9a\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x9c"		=> "\x9a\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x9d"		=> "\x9a\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x9e"		=> "\x9a\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x9f"		=> "\x9a\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa0"		=> "\x9a\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa2"		=> "\x9a\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa3"		=> "\x9a\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa4"		=> "\x9a\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa5"		=> "\x9a\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa6"		=> "\x9a\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa7"		=> "\x9a\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa8"		=> "\x9a\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xa9"		=> "\x9a\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xab"		=> "\x9a\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xac"		=> "\x9a\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xad"		=> "\x9a\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xae"		=> "\x9a\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xaf"		=> "\x9a\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb0"		=> "\x9a\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb1"		=> "\x9a\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb2"		=> "\x9a\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb6"		=> "\x9a\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb8"		=> "\x9a\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb9"		=> "\x9a\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xba"		=> "\x9a\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xbb"		=> "\x9a\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xbc"		=> "\x9a\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xbd"		=> "\x9a\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xbe"		=> "\x9a\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x80"		=> "\x9a\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x83"		=> "\x9a\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x84"		=> "\x9a\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x86"		=> "\x9a\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x87"		=> "\x9a\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x88"		=> "\x9a\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x89"		=> "\x9a\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x8a"		=> "\x9a\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x8c"		=> "\x9a\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x8e"		=> "\x9a\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x90"		=> "\x9a\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x91"		=> "\x9a\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x98"		=> "\x9a\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x9a"		=> "\x9a\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x9c"		=> "\x9a\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x9d"		=> "\x9a\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x9e"		=> "\x9a\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x9f"		=> "\x9a\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa0"		=> "\x9a\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa2"		=> "\x9a\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa3"		=> "\x9a\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa4"		=> "\x9a\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa5"		=> "\x9a\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa6"		=> "\x9a\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa7"		=> "\x9a\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa8"		=> "\x9a\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa9"		=> "\x9a\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xac"		=> "\x9a\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xad"		=> "\x9a\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xae"		=> "\x9a\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb0"		=> "\x9a\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb1"		=> "\x9a\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb2"		=> "\x9a\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb4"		=> "\x9a\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb6"		=> "\x9a\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb7"		=> "\x9a\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xb8"		=> "\x9a\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xba"		=> "\x9a\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xbb"		=> "\x9a\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xbc"		=> "\x9a\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xbe"		=> "\x9a\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xbf"		=> "\x9a\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x80"		=> "\x9a\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x81"		=> "\x9a\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x82"		=> "\x9a\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x83"		=> "\x9a\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x84"		=> "\x9a\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x88"		=> "\x9a\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x89"		=> "\x9a\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x8a"		=> "\x9a\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x8b"		=> "\x9a\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x8c"		=> "\x9a\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x8e"		=> "\x9a\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x92"		=> "\x9a\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x97"		=> "\x9a\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x9c"		=> "\x9a\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x9d"		=> "\x9a\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x9e"		=> "\x9a\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa0"		=> "\x9a\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa3"		=> "\x9a\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa5"		=> "\x9a\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xab"		=> "\x9a\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xac"		=> "\x9a\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xad"		=> "\x9a\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb1"		=> "\x9a\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb3"		=> "\x9a\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb6"		=> "\x9a\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb7"		=> "\x9a\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb9"		=> "\x9a\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xba"		=> "\x9a\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xbb"		=> "\x9a\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xbc"		=> "\x9a\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xbe"		=> "\x9a\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xbf"		=> "\x9a\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x83"		=> "\x9a\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x84"		=> "\x9a\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x85"		=> "\x9a\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x88"		=> "\x9a\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x8b"		=> "\x9a\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x8c"		=> "\x9a\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x8d"		=> "\x9a\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x8e"		=> "\x9a\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x8f"		=> "\x9a\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x91"		=> "\x9a\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x92"		=> "\x9a\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x93"		=> "\x9a\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x96"		=> "\x9a\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x98"		=> "\x9a\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x99"		=> "\x9b\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x9a"		=> "\x9b\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa2"		=> "\x9b\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa3"		=> "\x9b\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa5"		=> "\x9b\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa6"		=> "\x9b\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa7"		=> "\x9b\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xab"		=> "\x9b\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xac"		=> "\x9b\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xad"		=> "\x9b\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xae"		=> "\x9b\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xaf"		=> "\x9b\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb1"		=> "\x9b\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb3"		=> "\x9b\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb5"		=> "\x9b\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb7"		=> "\x9b\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb8"		=> "\x9b\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xba"		=> "\x9b\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xbb"		=> "\x9b\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xbc"		=> "\x9b\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xbf"		=> "\x9b\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x80"		=> "\x9b\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x84"		=> "\x9b\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x87"		=> "\x9b\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x8a"		=> "\x9b\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x8b"		=> "\x9b\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x8d"		=> "\x9b\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x8e"		=> "\x9b\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x91"		=> "\x9b\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x92"		=> "\x9b\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x95"		=> "\x9b\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x96"		=> "\x9b\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x97"		=> "\x9b\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x98"		=> "\x9b\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x9a"		=> "\x9b\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x9c"		=> "\x9b\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x9d"		=> "\x9b\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x9e"		=> "\x9b\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa0"		=> "\x9b\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa2"		=> "\x9b\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa8"		=> "\x9b\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xac"		=> "\x9b\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xaf"		=> "\x9b\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb0"		=> "\x9b\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb4"		=> "\x9b\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb5"		=> "\x9b\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb6"		=> "\x9b\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb7"		=> "\x9b\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xba"		=> "\x9b\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x80"		=> "\x9b\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x81"		=> "\x9b\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x82"		=> "\x9b\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x83"		=> "\x9b\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x86"		=> "\x9b\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x87"		=> "\x9b\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x88"		=> "\x9b\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x8b"		=> "\x9b\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x8d"		=> "\x9b\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x8e"		=> "\x9b\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x8f"		=> "\x9b\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x91"		=> "\x9b\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x92"		=> "\x9b\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x98"		=> "\x9b\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x99"		=> "\x9b\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x9a"		=> "\x9b\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x9c"		=> "\x9b\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x9d"		=> "\x9b\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x9f"		=> "\x9b\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa4"		=> "\x9b\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa6"		=> "\x9b\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa7"		=> "\x9b\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa9"		=> "\x9b\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xac"		=> "\x9b\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xad"		=> "\x9b\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb2"		=> "\x9b\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb4"		=> "\x9b\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb9"		=> "\x9b\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xbf"		=> "\x9b\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x80"		=> "\x9b\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x82"		=> "\x9b\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x83"		=> "\x9b\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x85"		=> "\x9b\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x86"		=> "\x9b\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x88"		=> "\x9b\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x89"		=> "\x9b\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x8a"		=> "\x9b\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x8d"		=> "\x9b\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x8f"		=> "\x9b\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x90"		=> "\x9b\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x91"		=> "\x9b\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x93"		=> "\x9b\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x94"		=> "\x9b\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x95"		=> "\x9b\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x96"		=> "\x9b\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x98"		=> "\x9b\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x9c"		=> "\x9b\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x9d"		=> "\x9b\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x9f"		=> "\x9b\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa0"		=> "\x9b\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa1"		=> "\x9b\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa2"		=> "\x9b\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa3"		=> "\x9b\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa4"		=> "\x9b\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa6"		=> "\x9b\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa8"		=> "\x9b\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa9"		=> "\x9b\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xac"		=> "\x9b\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xad"		=> "\x9b\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xaf"		=> "\x9b\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb0"		=> "\x9b\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb4"		=> "\x9b\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb6"		=> "\x9b\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb7"		=> "\x9b\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb8"		=> "\x9b\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xba"		=> "\x9b\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xbf"		=> "\x9b\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x80"		=> "\x9b\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x82"		=> "\x9b\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x84"		=> "\x9b\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x89"		=> "\x9b\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x8c"		=> "\x9b\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x90"		=> "\x9b\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x95"		=> "\x9b\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x96"		=> "\x9b\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x97"		=> "\x9b\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x98"		=> "\x9b\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x9b"		=> "\x9b\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x9d"		=> "\x9b\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x9f"		=> "\x9b\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa1"		=> "\x9b\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa2"		=> "\x9b\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa4"		=> "\x9b\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa5"		=> "\x9b\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa7"		=> "\x9b\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa8"		=> "\x9b\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xab"		=> "\x9b\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xac"		=> "\x9b\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xad"		=> "\x9b\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb0"		=> "\x9b\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb1"		=> "\x9b\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb2"		=> "\x9b\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb3"		=> "\x9b\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb5"		=> "\x9b\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb6"		=> "\x9b\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb9"		=> "\x9b\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xba"		=> "\x9b\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xbb"		=> "\x9b\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xbd"		=> "\x9b\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xbe"		=> "\x9b\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xbf"		=> "\x9b\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x80"		=> "\x9b\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x81"		=> "\x9b\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x83"		=> "\x9b\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x84"		=> "\x9b\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x86"		=> "\x9b\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x87"		=> "\x9b\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x8a"		=> "\x9b\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x8b"		=> "\x9b\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x8d"		=> "\x9b\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x8f"		=> "\x9b\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x90"		=> "\x9b\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x92"		=> "\x9b\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x96"		=> "\x9b\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x97"		=> "\x9b\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x98"		=> "\x9b\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x99"		=> "\x9b\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x9a"		=> "\x9b\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x9c"		=> "\x9b\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa2"		=> "\x9b\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa5"		=> "\x9b\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xac"		=> "\x9b\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xad"		=> "\x9b\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb0"		=> "\x9b\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb1"		=> "\x9b\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb3"		=> "\x9b\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb4"		=> "\x9b\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb6"		=> "\x9b\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb7"		=> "\x9b\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb9"		=> "\x9b\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xba"		=> "\x9b\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xbb"		=> "\x9b\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xbc"		=> "\x9b\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xbd"		=> "\x9b\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xbe"		=> "\x9b\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x81"		=> "\x9b\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x82"		=> "\x9b\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x83"		=> "\x9b\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x88"		=> "\x9b\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x89"		=> "\x9b\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x8a"		=> "\x9b\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x8d"		=> "\x9c\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x8e"		=> "\x9c\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x8f"		=> "\x9c\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x90"		=> "\x9c\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x92"		=> "\x9c\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x93"		=> "\x9c\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x94"		=> "\x9c\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x95"		=> "\x9c\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x97"		=> "\x9c\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x9a"		=> "\x9c\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x9b"		=> "\x9c\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x9c"		=> "\x9c\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x9f"		=> "\x9c\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa2"		=> "\x9c\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa3"		=> "\x9c\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa5"		=> "\x9c\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa7"		=> "\x9c\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa8"		=> "\x9c\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa9"		=> "\x9c\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xaa"		=> "\x9c\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xad"		=> "\x9c\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xaf"		=> "\x9c\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb0"		=> "\x9c\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb2"		=> "\x9c\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb4"		=> "\x9c\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb5"		=> "\x9c\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb6"		=> "\x9c\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb8"		=> "\x9c\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xba"		=> "\x9c\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xbd"		=> "\x9c\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xbe"		=> "\x9c\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xbf"		=> "\x9c\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x80"		=> "\x9c\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x81"		=> "\x9c\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x82"		=> "\x9c\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x83"		=> "\x9c\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x84"		=> "\x9c\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x86"		=> "\x9c\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x87"		=> "\x9c\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x88"		=> "\x9c\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x89"		=> "\x9c\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x8b"		=> "\x9c\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x8f"		=> "\x9c\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x92"		=> "\x9c\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x93"		=> "\x9c\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x95"		=> "\x9c\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x98"		=> "\x9c\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x99"		=> "\x9c\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x9b"		=> "\x9c\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x9c"		=> "\x9c\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x9e"		=> "\x9c\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x9f"		=> "\x9c\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa2"		=> "\x9c\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa6"		=> "\x9c\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa7"		=> "\x9c\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa8"		=> "\x9c\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xaa"		=> "\x9c\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xac"		=> "\x9c\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xae"		=> "\x9c\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb0"		=> "\x9c\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb1"		=> "\x9c\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb3"		=> "\x9c\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb5"		=> "\x9c\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb6"		=> "\x9c\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb7"		=> "\x9c\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb9"		=> "\x9c\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xbb"		=> "\x9c\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xbc"		=> "\x9c\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xbd"		=> "\x9c\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xbe"		=> "\x9c\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xbf"		=> "\x9c\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x80"		=> "\x9c\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x81"		=> "\x9c\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x82"		=> "\x9c\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x85"		=> "\x9c\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x86"		=> "\x9c\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x87"		=> "\x9c\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x88"		=> "\x9c\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x89"		=> "\x9c\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x8a"		=> "\x9c\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x8b"		=> "\x9c\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x8c"		=> "\x9c\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x8f"		=> "\x9c\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x90"		=> "\x9c\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x91"		=> "\x9c\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x92"		=> "\x9c\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x95"		=> "\x9c\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x97"		=> "\x9c\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x99"		=> "\x9c\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x9a"		=> "\x9c\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x9c"		=> "\x9c\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x9d"		=> "\x9c\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x9e"		=> "\x9c\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa0"		=> "\x9c\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa1"		=> "\x9c\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa2"		=> "\x9c\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa3"		=> "\x9c\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa4"		=> "\x9c\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa5"		=> "\x9c\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa6"		=> "\x9c\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa7"		=> "\x9c\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa8"		=> "\x9c\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xa9"		=> "\x9c\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xaa"		=> "\x9c\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xac"		=> "\x9c\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xad"		=> "\x9c\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xaf"		=> "\x9c\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb0"		=> "\x9c\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb1"		=> "\x9c\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb2"		=> "\x9c\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb3"		=> "\x9c\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb4"		=> "\x9c\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb5"		=> "\x9c\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb6"		=> "\x9c\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb7"		=> "\x9c\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb8"		=> "\x9c\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xb9"		=> "\x9c\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xba"		=> "\x9c\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xbb"		=> "\x9c\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xbc"		=> "\x9c\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xbd"		=> "\x9c\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x80"		=> "\x9c\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x81"		=> "\x9c\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x82"		=> "\x9c\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x84"		=> "\x9c\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x87"		=> "\x9c\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x88"		=> "\x9c\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x8a"		=> "\x9c\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x8b"		=> "\x9c\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x8c"		=> "\x9c\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x8d"		=> "\x9c\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x8e"		=> "\x9c\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x91"		=> "\x9c\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x92"		=> "\x9c\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x93"		=> "\x9c\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x94"		=> "\x9c\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x95"		=> "\x9c\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x96"		=> "\x9c\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x97"		=> "\x9c\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x99"		=> "\x9c\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x9a"		=> "\x9c\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x9b"		=> "\x9c\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x9d"		=> "\x9c\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x9e"		=> "\x9c\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa0"		=> "\x9c\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa1"		=> "\x9c\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa3"		=> "\x9c\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa4"		=> "\x9c\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa6"		=> "\x9c\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa8"		=> "\x9c\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa9"		=> "\x9c\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xab"		=> "\x9c\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xac"		=> "\x9c\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xad"		=> "\x9c\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xae"		=> "\x9c\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xb0"		=> "\x9c\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xb3"		=> "\x9c\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xb5"		=> "\x9c\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xb8"		=> "\x9c\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xb9"		=> "\x9c\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xbc"		=> "\x9c\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xbe"		=> "\x9c\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xbf"		=> "\x9c\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x80"		=> "\x9c\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x83"		=> "\x9c\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x84"		=> "\x9c\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x85"		=> "\x9c\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x86"		=> "\x9c\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x88"		=> "\x9c\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x89"		=> "\x9c\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x8a"		=> "\x9c\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x8c"		=> "\x9c\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x8d"		=> "\x9c\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x8e"		=> "\x9c\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x90"		=> "\x9c\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x92"		=> "\x9c\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x96"		=> "\x9c\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x98"		=> "\x9c\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x99"		=> "\x9c\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x9b"		=> "\x9c\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x9c"		=> "\x9c\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x9d"		=> "\x9c\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa3"		=> "\x9c\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa7"		=> "\x9c\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xaa"		=> "\x9c\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xab"		=> "\x9c\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xac"		=> "\x9c\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xad"		=> "\x9c\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xae"		=> "\x9c\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xaf"		=> "\x9c\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb0"		=> "\x9d\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb1"		=> "\x9d\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb2"		=> "\x9d\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb3"		=> "\x9d\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb5"		=> "\x9d\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb6"		=> "\x9d\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb7"		=> "\x9d\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb8"		=> "\x9d\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xba"		=> "\x9d\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xbb"		=> "\x9d\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xbc"		=> "\x9d\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xbd"		=> "\x9d\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xbe"		=> "\x9d\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xbf"		=> "\x9d\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x80"		=> "\x9d\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x81"		=> "\x9d\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x83"		=> "\x9d\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x84"		=> "\x9d\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x85"		=> "\x9d\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x87"		=> "\x9d\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x88"		=> "\x9d\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x8a"		=> "\x9d\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x8b"		=> "\x9d\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x8c"		=> "\x9d\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x8d"		=> "\x9d\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x8e"		=> "\x9d\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x90"		=> "\x9d\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x91"		=> "\x9d\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x92"		=> "\x9d\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x96"		=> "\x9d\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x97"		=> "\x9d\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x98"		=> "\x9d\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x99"		=> "\x9d\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x9a"		=> "\x9d\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x9b"		=> "\x9d\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x9c"		=> "\x9d\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x9d"		=> "\x9d\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x9e"		=> "\x9d\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x9f"		=> "\x9d\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa1"		=> "\x9d\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa2"		=> "\x9d\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa3"		=> "\x9d\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa5"		=> "\x9d\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa6"		=> "\x9d\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa7"		=> "\x9d\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa8"		=> "\x9d\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xac"		=> "\x9d\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xae"		=> "\x9d\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb0"		=> "\x9d\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb2"		=> "\x9d\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb4"		=> "\x9d\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb5"		=> "\x9d\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb7"		=> "\x9d\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb8"		=> "\x9d\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb9"		=> "\x9d\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xba"		=> "\x9d\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xbb"		=> "\x9d\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xbc"		=> "\x9d\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xbd"		=> "\x9d\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xbf"		=> "\x9d\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x80"		=> "\x9d\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x81"		=> "\x9d\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x82"		=> "\x9d\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x83"		=> "\x9d\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x84"		=> "\x9d\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x85"		=> "\x9d\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x88"		=> "\x9d\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x89"		=> "\x9d\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x8a"		=> "\x9d\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x8c"		=> "\x9d\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x8e"		=> "\x9d\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x8f"		=> "\x9d\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x90"		=> "\x9d\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x91"		=> "\x9d\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x92"		=> "\x9d\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x93"		=> "\x9d\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x94"		=> "\x9d\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x95"		=> "\x9d\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x96"		=> "\x9d\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x97"		=> "\x9d\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x99"		=> "\x9d\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x9a"		=> "\x9d\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x9b"		=> "\x9d\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x9d"		=> "\x9d\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x9f"		=> "\x9d\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa0"		=> "\x9d\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa1"		=> "\x9d\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa3"		=> "\x9d\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa4"		=> "\x9d\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa5"		=> "\x9d\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa7"		=> "\x9d\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa8"		=> "\x9d\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa9"		=> "\x9d\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xaa"		=> "\x9d\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xab"		=> "\x9d\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xac"		=> "\x9d\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xaf"		=> "\x9d\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb0"		=> "\x9d\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb1"		=> "\x9d\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb3"		=> "\x9d\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb5"		=> "\x9d\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb6"		=> "\x9d\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb7"		=> "\x9d\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xb9"		=> "\x9d\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xbb"		=> "\x9d\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xbd"		=> "\x9d\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xbe"		=> "\x9d\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xbf"		=> "\x9d\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x80"		=> "\x9d\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x81"		=> "\x9d\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x82"		=> "\x9d\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x83"		=> "\x9d\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x85"		=> "\x9d\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x86"		=> "\x9d\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x87"		=> "\x9d\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x8a"		=> "\x9d\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x8b"		=> "\x9d\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x8f"		=> "\x9d\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x90"		=> "\x9d\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x91"		=> "\x9d\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x92"		=> "\x9d\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x93"		=> "\x9d\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x94"		=> "\x9d\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x95"		=> "\x9d\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x96"		=> "\x9d\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x97"		=> "\x9d\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x98"		=> "\x9d\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x99"		=> "\x9d\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x9a"		=> "\x9d\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x9b"		=> "\x9d\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x9d"		=> "\x9d\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x9e"		=> "\x9d\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x9f"		=> "\x9d\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa0"		=> "\x9d\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa2"		=> "\x9d\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa3"		=> "\x9d\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa4"		=> "\x9d\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa5"		=> "\x9d\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa6"		=> "\x9d\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa8"		=> "\x9d\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa9"		=> "\x9d\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xaa"		=> "\x9d\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xab"		=> "\x9d\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xac"		=> "\x9d\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xad"		=> "\x9d\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xae"		=> "\x9d\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xaf"		=> "\x9d\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb0"		=> "\x9d\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb1"		=> "\x9d\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb2"		=> "\x9d\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb4"		=> "\x9d\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb5"		=> "\x9d\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb7"		=> "\x9d\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb8"		=> "\x9d\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xba"		=> "\x9d\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xbb"		=> "\x9d\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xbc"		=> "\x9d\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xbd"		=> "\x9d\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xbe"		=> "\x9d\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xbf"		=> "\x9d\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x81"		=> "\x9d\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x83"		=> "\x9d\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x84"		=> "\x9d\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x85"		=> "\x9d\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x86"		=> "\x9d\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x87"		=> "\x9d\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x88"		=> "\x9d\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x8a"		=> "\x9d\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x8b"		=> "\x9d\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x8c"		=> "\x9d\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x8d"		=> "\x9d\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x8e"		=> "\x9d\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x8f"		=> "\x9d\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x90"		=> "\x9d\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x93"		=> "\x9d\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x94"		=> "\x9d\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x95"		=> "\x9d\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x96"		=> "\x9d\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x97"		=> "\x9d\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x98"		=> "\x9d\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x99"		=> "\x9d\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x9a"		=> "\x9d\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x9b"		=> "\x9d\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x9c"		=> "\x9d\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x9d"		=> "\x9d\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x9f"		=> "\x9d\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa2"		=> "\x9d\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa3"		=> "\x9d\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa4"		=> "\x9d\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa5"		=> "\x9d\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa6"		=> "\x9e\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa7"		=> "\x9e\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa8"		=> "\x9e\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xa9"		=> "\x9e\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xaa"		=> "\x9e\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xab"		=> "\x9e\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xac"		=> "\x9e\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xad"		=> "\x9e\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb0"		=> "\x9e\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb1"		=> "\x9e\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb2"		=> "\x9e\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb3"		=> "\x9e\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb4"		=> "\x9e\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb5"		=> "\x9e\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb6"		=> "\x9e\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb7"		=> "\x9e\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb8"		=> "\x9e\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xb9"		=> "\x9e\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xba"		=> "\x9e\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xbb"		=> "\x9e\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xbc"		=> "\x9e\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xbd"		=> "\x9e\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xbe"		=> "\x9e\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\xbf"		=> "\x9e\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x80"		=> "\x9e\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x81"		=> "\x9e\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x82"		=> "\x9e\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x83"		=> "\x9e\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x84"		=> "\x9e\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x85"		=> "\x9e\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x86"		=> "\x9e\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x87"		=> "\x9e\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x88"		=> "\x9e\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x89"		=> "\x9e\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x8a"		=> "\x9e\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x8b"		=> "\x9e\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x8c"		=> "\x9e\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x8d"		=> "\x9e\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x8e"		=> "\x9e\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x8f"		=> "\x9e\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x90"		=> "\x9e\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x92"		=> "\x9e\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x93"		=> "\x9e\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x94"		=> "\x9e\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x95"		=> "\x9e\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x96"		=> "\x9e\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x97"		=> "\x9e\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x98"		=> "\x9e\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x99"		=> "\x9e\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x9c"		=> "\x9e\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x9d"		=> "\x9e\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x9e"		=> "\x9e\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x9f"		=> "\x9e\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa0"		=> "\x9e\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa1"		=> "\x9e\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa2"		=> "\x9e\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa4"		=> "\x9e\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa5"		=> "\x9e\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa6"		=> "\x9e\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa7"		=> "\x9e\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa8"		=> "\x9e\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xa9"		=> "\x9e\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xaa"		=> "\x9e\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xab"		=> "\x9e\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xac"		=> "\x9e\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xad"		=> "\x9e\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xae"		=> "\x9e\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xaf"		=> "\x9e\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb0"		=> "\x9e\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb1"		=> "\x9e\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb2"		=> "\x9e\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb3"		=> "\x9e\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb4"		=> "\x9e\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb6"		=> "\x9e\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb7"		=> "\x9e\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xb8"		=> "\x9e\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xba"		=> "\x9e\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xbb"		=> "\x9e\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xbc"		=> "\x9e\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xbd"		=> "\x9e\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xbe"		=> "\x9e\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\xbf"		=> "\x9e\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x80"		=> "\x9e\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x81"		=> "\x9e\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x82"		=> "\x9e\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x83"		=> "\x9e\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x84"		=> "\x9e\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x85"		=> "\x9e\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x86"		=> "\x9e\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x87"		=> "\x9e\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x88"		=> "\x9e\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x89"		=> "\x9e\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x8a"		=> "\x9e\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x8b"		=> "\x9e\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x8d"		=> "\x9e\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x8e"		=> "\x9e\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x90"		=> "\x9e\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x91"		=> "\x9e\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x92"		=> "\x9e\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x93"		=> "\x9e\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x94"		=> "\x9e\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x95"		=> "\x9e\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x96"		=> "\x9e\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x97"		=> "\x9e\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x98"		=> "\x9e\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x99"		=> "\x9e\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x9a"		=> "\x9e\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x9b"		=> "\x9e\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x9c"		=> "\x9e\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x9d"		=> "\x9e\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x9f"		=> "\x9e\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa0"		=> "\x9e\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa1"		=> "\x9e\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa2"		=> "\x9e\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa3"		=> "\x9e\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa4"		=> "\x9e\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa5"		=> "\x9e\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa6"		=> "\x9e\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa7"		=> "\x9e\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa8"		=> "\x9e\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xa9"		=> "\x9e\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xaa"		=> "\x9e\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xae"		=> "\x9e\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb1"		=> "\x9e\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb2"		=> "\x9e\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb3"		=> "\x9e\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb4"		=> "\x9e\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb7"		=> "\x9e\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb9"		=> "\x9e\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xba"		=> "\x9e\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xbb"		=> "\x9e\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xbd"		=> "\x9e\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x81"		=> "\x9e\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x82"		=> "\x9e\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x83"		=> "\x9e\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x84"		=> "\x9e\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x86"		=> "\x9e\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x87"		=> "\x9e\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x88"		=> "\x9e\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x8b"		=> "\x9e\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x8c"		=> "\x9e\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x8d"		=> "\x9e\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x8f"		=> "\x9e\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x90"		=> "\x9e\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x91"		=> "\x9e\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x93"		=> "\x9e\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x97"		=> "\x9e\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x98"		=> "\x9e\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x9a"		=> "\x9e\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x9b"		=> "\x9e\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x9e"		=> "\x9e\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x9f"		=> "\x9e\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa0"		=> "\x9e\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa1"		=> "\x9e\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa2"		=> "\x9e\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa3"		=> "\x9e\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa4"		=> "\x9e\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa5"		=> "\x9e\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa6"		=> "\x9e\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa7"		=> "\x9e\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa8"		=> "\x9e\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xa9"		=> "\x9e\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xaa"		=> "\x9e\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb0"		=> "\x9e\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb2"		=> "\x9e\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb4"		=> "\x9e\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb5"		=> "\x9e\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb6"		=> "\x9e\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xba"		=> "\x9e\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xbe"		=> "\x9e\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xbf"		=> "\x9e\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x84"		=> "\x9e\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x85"		=> "\x9e\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x86"		=> "\x9e\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x87"		=> "\x9e\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x89"		=> "\x9e\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x8b"		=> "\x9e\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x8c"		=> "\x9e\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x8d"		=> "\x9e\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x8e"		=> "\x9e\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x8f"		=> "\x9e\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x90"		=> "\x9e\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x91"		=> "\x9e\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x92"		=> "\x9e\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x93"		=> "\x9e\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x94"		=> "\x9e\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x95"		=> "\x9e\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x96"		=> "\x9e\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x97"		=> "\x9e\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x9a"		=> "\x9e\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x9c"		=> "\x9f\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x9d"		=> "\x9f\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x9e"		=> "\x9f\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa0"		=> "\x9f\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa1"		=> "\x9f\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa2"		=> "\x9f\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa3"		=> "\x9f\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa5"		=> "\x9f\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xaa"		=> "\x9f\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xae"		=> "\x9f\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb0"		=> "\x9f\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb1"		=> "\x9f\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb2"		=> "\x9f\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb3"		=> "\x9f\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb4"		=> "\x9f\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb5"		=> "\x9f\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb6"		=> "\x9f\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb8"		=> "\x9f\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xba"		=> "\x9f\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xbb"		=> "\x9f\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xbc"		=> "\x9f\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xbe"		=> "\x9f\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xbf"		=> "\x9f\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x80"		=> "\x9f\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x81"		=> "\x9f\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x82"		=> "\x9f\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x83"		=> "\x9f\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x84"		=> "\x9f\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x85"		=> "\x9f\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x86"		=> "\x9f\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x87"		=> "\x9f\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x88"		=> "\x9f\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x8b"		=> "\x9f\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x8c"		=> "\x9f\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x8d"		=> "\x9f\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x8e"		=> "\x9f\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x8f"		=> "\x9f\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x91"		=> "\x9f\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x92"		=> "\x9f\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x94"		=> "\x9f\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x97"		=> "\x9f\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x9b"		=> "\x9f\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x9c"		=> "\x9f\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x9d"		=> "\x9f\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x9e"		=> "\x9f\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x9f"		=> "\x9f\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa0"		=> "\x9f\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa1"		=> "\x9f\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa2"		=> "\x9f\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa3"		=> "\x9f\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa4"		=> "\x9f\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa5"		=> "\x9f\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa7"		=> "\x9f\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa8"		=> "\x9f\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa9"		=> "\x9f\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xaa"		=> "\x9f\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xab"		=> "\x9f\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xac"		=> "\x9f\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xad"		=> "\x9f\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xae"		=> "\x9f\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb2"		=> "\x9f\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb3"		=> "\x9f\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb4"		=> "\x9f\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb5"		=> "\x9f\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb7"		=> "\x9f\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb8"		=> "\x9f\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb9"		=> "\x9f\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xba"		=> "\x9f\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xbb"		=> "\x9f\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xbc"		=> "\x9f\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xbd"		=> "\x9f\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xbe"		=> "\x9f\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xbf"		=> "\x9f\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x80"		=> "\x9f\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x81"		=> "\x9f\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x82"		=> "\x9f\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x83"		=> "\x9f\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x84"		=> "\x9f\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x86"		=> "\x9f\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x87"		=> "\x9f\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x88"		=> "\x9f\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x89"		=> "\x9f\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x8b"		=> "\x9f\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x8d"		=> "\x9f\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x8f"		=> "\x9f\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x90"		=> "\x9f\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x91"		=> "\x9f\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x92"		=> "\x9f\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x93"		=> "\x9f\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x94"		=> "\x9f\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x95"		=> "\x9f\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x96"		=> "\x9f\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x97"		=> "\x9f\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x98"		=> "\x9f\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x99"		=> "\x9f\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x9a"		=> "\x9f\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x9b"		=> "\x9f\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x9d"		=> "\x9f\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x9f"		=> "\x9f\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa0"		=> "\x9f\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa1"		=> "\x9f\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa2"		=> "\x9f\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa3"		=> "\x9f\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa5"		=> "\x9f\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa9"		=> "\x9f\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xaa"		=> "\x9f\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xab"		=> "\x9f\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xac"		=> "\x9f\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xad"		=> "\x9f\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xaf"		=> "\x9f\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb0"		=> "\x9f\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb1"		=> "\x9f\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb4"		=> "\x9f\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb5"		=> "\x9f\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb6"		=> "\x9f\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb7"		=> "\x9f\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xb9"		=> "\x9f\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xbb"		=> "\x9f\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xbc"		=> "\x9f\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xbe"		=> "\x9f\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xbf"		=> "\x9f\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x80"		=> "\x9f\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x81"		=> "\x9f\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x82"		=> "\x9f\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x83"		=> "\x9f\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x85"		=> "\x9f\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x86"		=> "\x9f\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x87"		=> "\x9f\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x88"		=> "\x9f\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x89"		=> "\x9f\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x8b"		=> "\x9f\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x8c"		=> "\x9f\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x8d"		=> "\x9f\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x8e"		=> "\x9f\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x90"		=> "\x9f\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x91"		=> "\x9f\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x92"		=> "\x9f\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x93"		=> "\x9f\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x95"		=> "\x9f\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x96"		=> "\x9f\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x97"		=> "\x9f\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x9a"		=> "\x9f\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x9b"		=> "\x9f\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x9c"		=> "\x9f\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x9d"		=> "\x9f\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x9e"		=> "\x9f\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa1"		=> "\x9f\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa2"		=> "\x9f\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa3"		=> "\x9f\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa4"		=> "\x9f\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa5"		=> "\x9f\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa6"		=> "\x9f\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa7"		=> "\x9f\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xa9"		=> "\x9f\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xaa"		=> "\x9f\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xab"		=> "\x9f\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xad"		=> "\x9f\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xae"		=> "\x9f\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xaf"		=> "\x9f\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb0"		=> "\x9f\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb1"		=> "\x9f\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb2"		=> "\x9f\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb4"		=> "\x9f\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb6"		=> "\x9f\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb7"		=> "\x9f\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xb8"		=> "\x9f\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xba"		=> "\x9f\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xbb"		=> "\x9f\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xbc"		=> "\x9f\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xbd"		=> "\x9f\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xbe"		=> "\x9f\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xbf"		=> "\x9f\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x80"		=> "\x9f\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x81"		=> "\x9f\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x82"		=> "\x9f\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x84"		=> "\x9f\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x85"		=> "\x9f\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x86"		=> "\x9f\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x87"		=> "\x9f\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x88"		=> "\x9f\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x89"		=> "\x9f\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x8a"		=> "\x9f\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x8b"		=> "\x9f\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x8c"		=> "\x9f\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x8d"		=> "\x9f\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x8f"		=> "\x9f\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x90"		=> "\x9f\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x91"		=> "\x9f\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x92"		=> "\x9f\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x93"		=> "\x9f\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x96"		=> "\xa0\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x97"		=> "\xa0\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x98"		=> "\xa0\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x99"		=> "\xa0\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x9a"		=> "\xa0\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x9b"		=> "\xa0\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x9c"		=> "\xa0\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x9d"		=> "\xa0\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x9e"		=> "\xa0\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x9f"		=> "\xa0\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa1"		=> "\xa0\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa2"		=> "\xa0\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa3"		=> "\xa0\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa4"		=> "\xa0\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa6"		=> "\xa0\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa8"		=> "\xa0\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa9"		=> "\xa0\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xaa"		=> "\xa0\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xab"		=> "\xa0\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xac"		=> "\xa0\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xad"		=> "\xa0\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xaf"		=> "\xa0\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb0"		=> "\xa0\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb1"		=> "\xa0\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb2"		=> "\xa0\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb3"		=> "\xa0\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb4"		=> "\xa0\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb5"		=> "\xa0\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb6"		=> "\xa0\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb7"		=> "\xa0\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xb8"		=> "\xa0\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xba"		=> "\xa0\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xbb"		=> "\xa0\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xbc"		=> "\xa0\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xbd"		=> "\xa0\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xbe"		=> "\xa0\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xbf"		=> "\xa0\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x80"		=> "\xa0\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x81"		=> "\xa0\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x82"		=> "\xa0\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x83"		=> "\xa0\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x84"		=> "\xa0\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x85"		=> "\xa0\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x87"		=> "\xa0\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x88"		=> "\xa0\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x89"		=> "\xa0\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x8a"		=> "\xa0\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x8b"		=> "\xa0\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x8c"		=> "\xa0\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x8d"		=> "\xa0\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x8e"		=> "\xa0\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x8f"		=> "\xa0\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x90"		=> "\xa0\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x91"		=> "\xa0\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x92"		=> "\xa0\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x93"		=> "\xa0\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x94"		=> "\xa0\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x95"		=> "\xa0\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x96"		=> "\xa0\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x97"		=> "\xa0\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x98"		=> "\xa0\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x99"		=> "\xa0\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x9a"		=> "\xa0\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x9b"		=> "\xa0\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x9c"		=> "\xa0\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x9e"		=> "\xa0\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x9f"		=> "\xa0\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa0"		=> "\xa0\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa1"		=> "\xa0\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa2"		=> "\xa0\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa3"		=> "\xa0\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa4"		=> "\xa0\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa5"		=> "\xa0\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa6"		=> "\xa0\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa7"		=> "\xa0\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xa9"		=> "\xa0\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xab"		=> "\xa0\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xad"		=> "\xa0\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xae"		=> "\xa0\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xaf"		=> "\xa0\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb2"		=> "\xa0\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb3"		=> "\xa0\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb4"		=> "\xa0\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xba"		=> "\xa0\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xbc"		=> "\xa0\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xbe"		=> "\xa0\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x80"		=> "\xa0\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x81"		=> "\xa0\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x82"		=> "\xa0\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x83"		=> "\xa0\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x84"		=> "\xa0\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x85"		=> "\xa0\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x86"		=> "\xa0\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x89"		=> "\xa0\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x8a"		=> "\xa0\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x8b"		=> "\xa0\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x8e"		=> "\xa0\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x8f"		=> "\xa0\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x90"		=> "\xa0\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x91"		=> "\xa0\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x93"		=> "\xa0\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x94"		=> "\xa0\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x95"		=> "\xa0\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x97"		=> "\xa0\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x98"		=> "\xa0\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x9a"		=> "\xa0\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x9c"		=> "\xa0\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x9e"		=> "\xa0\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa0"		=> "\xa0\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa3"		=> "\xa0\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa4"		=> "\xa0\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa5"		=> "\xa0\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa8"		=> "\xa0\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xaa"		=> "\xa0\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xab"		=> "\xa0\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xac"		=> "\xa0\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xad"		=> "\xa0\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb0"		=> "\xa0\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb1"		=> "\xa0\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb3"		=> "\xa0\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb4"		=> "\xa0\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb6"		=> "\xa0\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb7"		=> "\xa0\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb8"		=> "\xa0\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xbb"		=> "\xa0\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xbc"		=> "\xa0\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xbd"		=> "\xa0\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x82"		=> "\xa0\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x83"		=> "\xa0\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x85"		=> "\xa0\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x86"		=> "\xa0\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x87"		=> "\xa0\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x88"		=> "\xa0\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x89"		=> "\xa0\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x8c"		=> "\xa0\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x8e"		=> "\xa0\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x90"		=> "\xa0\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x91"		=> "\xa0\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x93"		=> "\xa0\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x94"		=> "\xa0\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x95"		=> "\xa0\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x96"		=> "\xa0\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x97"		=> "\xa0\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x98"		=> "\xa0\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x99"		=> "\xa0\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x9a"		=> "\xa0\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x9b"		=> "\xa0\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x9c"		=> "\xa0\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x9d"		=> "\xa0\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x9e"		=> "\xa0\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa0"		=> "\xa0\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa1"		=> "\xa0\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa2"		=> "\xa0\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa3"		=> "\xa0\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa4"		=> "\xa0\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa5"		=> "\xa0\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa6"		=> "\xa0\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa7"		=> "\xa0\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa8"		=> "\xa0\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xa9"		=> "\xa0\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xaa"		=> "\xa0\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xab"		=> "\xa0\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xae"		=> "\xa0\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb1"		=> "\xa0\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb2"		=> "\xa0\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb3"		=> "\xa0\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb5"		=> "\xa0\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xba"		=> "\xa0\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xbb"		=> "\xa0\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xbc"		=> "\xa0\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xbd"		=> "\xa0\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xbe"		=> "\xa0\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xbf"		=> "\xa0\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x80"		=> "\xa0\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x85"		=> "\xa0\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x86"		=> "\xa0\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x87"		=> "\xa0\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x89"		=> "\xa0\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x8a"		=> "\xa0\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x8b"		=> "\xa0\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x8c"		=> "\xa0\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x8f"		=> "\xa0\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x91"		=> "\xa0\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x93"		=> "\xa0\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x94"		=> "\xa0\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x95"		=> "\xa0\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x96"		=> "\xa0\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x98"		=> "\xa0\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x9a"		=> "\xa0\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x9b"		=> "\xa0\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe3\x80\x80"		=> "\xa1\xa1",	//IDEOGRAPHIC SPACE
		"\xe3\x80\x81"		=> "\xa1\xa2",	//IDEOGRAPHIC COMMA
		"\xe3\x80\x82"		=> "\xa1\xa3",	//IDEOGRAPHIC FULL STOP
		"\xc2\xb7"		=> "\xa1\xa4",	//MIDDLE DOT
		"\xcb\x89"		=> "\xa1\xa5",	//MODIFIER LETTER MACRON
		"\xcb\x87"		=> "\xa1\xa6",	//CARON
		"\xc2\xa8"		=> "\xa1\xa7",	//DIAERESIS
		"\xe3\x80\x83"		=> "\xa1\xa8",	//DITTO MARK
		"\xe3\x80\x85"		=> "\xa1\xa9",	//IDEOGRAPHIC ITERATION MARK
		"\xe2\x80\x94"		=> "\xa1\xaa",	//EM DASH
		"\xef\xbd\x9e"		=> "\xa1\xab",	//FULLWIDTH TILDE
		"\xe2\x80\x96"		=> "\xa1\xac",	//DOUBLE VERTICAL LINE
		"\xe2\x80\xa6"		=> "\xa1\xad",	//HORIZONTAL ELLIPSIS
		"\xe2\x80\x98"		=> "\xa1\xae",	//LEFT SINGLE QUOTATION MARK
		"\xe2\x80\x99"		=> "\xa1\xaf",	//RIGHT SINGLE QUOTATION MARK
		"\xe2\x80\x9c"		=> "\xa1\xb0",	//LEFT DOUBLE QUOTATION MARK
		"\xe2\x80\x9d"		=> "\xa1\xb1",	//RIGHT DOUBLE QUOTATION MARK
		"\xe3\x80\x94"		=> "\xa1\xb2",	//LEFT TORTOISE SHELL BRACKET
		"\xe3\x80\x95"		=> "\xa1\xb3",	//RIGHT TORTOISE SHELL BRACKET
		"\xe3\x80\x88"		=> "\xa1\xb4",	//LEFT ANGLE BRACKET
		"\xe3\x80\x89"		=> "\xa1\xb5",	//RIGHT ANGLE BRACKET
		"\xe3\x80\x8a"		=> "\xa1\xb6",	//LEFT DOUBLE ANGLE BRACKET
		"\xe3\x80\x8b"		=> "\xa1\xb7",	//RIGHT DOUBLE ANGLE BRACKET
		"\xe3\x80\x8c"		=> "\xa1\xb8",	//LEFT CORNER BRACKET
		"\xe3\x80\x8d"		=> "\xa1\xb9",	//RIGHT CORNER BRACKET
		"\xe3\x80\x8e"		=> "\xa1\xba",	//LEFT WHITE CORNER BRACKET
		"\xe3\x80\x8f"		=> "\xa1\xbb",	//RIGHT WHITE CORNER BRACKET
		"\xe3\x80\x96"		=> "\xa1\xbc",	//LEFT WHITE LENTICULAR BRACKET
		"\xe3\x80\x97"		=> "\xa1\xbd",	//RIGHT WHITE LENTICULAR BRACKET
		"\xe3\x80\x90"		=> "\xa1\xbe",	//LEFT BLACK LENTICULAR BRACKET
		"\xe3\x80\x91"		=> "\xa1\xbf",	//RIGHT BLACK LENTICULAR BRACKET
		"\xc2\xb1"		=> "\xa1\xc0",	//PLUS-MINUS SIGN
		"\xc3\x97"		=> "\xa1\xc1",	//MULTIPLICATION SIGN
		"\xc3\xb7"		=> "\xa1\xc2",	//DIVISION SIGN
		"\xe2\x88\xb6"		=> "\xa1\xc3",	//RATIO
		"\xe2\x88\xa7"		=> "\xa1\xc4",	//LOGICAL AND
		"\xe2\x88\xa8"		=> "\xa1\xc5",	//LOGICAL OR
		"\xe2\x88\x91"		=> "\xa1\xc6",	//N-ARY SUMMATION
		"\xe2\x88\x8f"		=> "\xa1\xc7",	//N-ARY PRODUCT
		"\xe2\x88\xaa"		=> "\xa1\xc8",	//UNION
		"\xe2\x88\xa9"		=> "\xa1\xc9",	//INTERSECTION
		"\xe2\x88\x88"		=> "\xa1\xca",	//ELEMENT OF
		"\xe2\x88\xb7"		=> "\xa1\xcb",	//PROPORTION
		"\xe2\x88\x9a"		=> "\xa1\xcc",	//SQUARE ROOT
		"\xe2\x8a\xa5"		=> "\xa1\xcd",	//UP TACK
		"\xe2\x88\xa5"		=> "\xa1\xce",	//PARALLEL TO
		"\xe2\x88\xa0"		=> "\xa1\xcf",	//ANGLE
		"\xe2\x8c\x92"		=> "\xa1\xd0",	//ARC
		"\xe2\x8a\x99"		=> "\xa1\xd1",	//CIRCLED DOT OPERATOR
		"\xe2\x88\xab"		=> "\xa1\xd2",	//INTEGRAL
		"\xe2\x88\xae"		=> "\xa1\xd3",	//CONTOUR INTEGRAL
		"\xe2\x89\xa1"		=> "\xa1\xd4",	//IDENTICAL TO
		"\xe2\x89\x8c"		=> "\xa1\xd5",	//ALL EQUAL TO
		"\xe2\x89\x88"		=> "\xa1\xd6",	//ALMOST EQUAL TO
		"\xe2\x88\xbd"		=> "\xa1\xd7",	//REVERSED TILDE
		"\xe2\x88\x9d"		=> "\xa1\xd8",	//PROPORTIONAL TO
		"\xe2\x89\xa0"		=> "\xa1\xd9",	//NOT EQUAL TO
		"\xe2\x89\xae"		=> "\xa1\xda",	//NOT LESS-THAN
		"\xe2\x89\xaf"		=> "\xa1\xdb",	//NOT GREATER-THAN
		"\xe2\x89\xa4"		=> "\xa1\xdc",	//LESS-THAN OR EQUAL TO
		"\xe2\x89\xa5"		=> "\xa1\xdd",	//GREATER-THAN OR EQUAL TO
		"\xe2\x88\x9e"		=> "\xa1\xde",	//INFINITY
		"\xe2\x88\xb5"		=> "\xa1\xdf",	//BECAUSE
		"\xe2\x88\xb4"		=> "\xa1\xe0",	//THEREFORE
		"\xe2\x99\x82"		=> "\xa1\xe1",	//MALE SIGN
		"\xe2\x99\x80"		=> "\xa1\xe2",	//FEMALE SIGN
		"\xc2\xb0"		=> "\xa1\xe3",	//DEGREE SIGN
		"\xe2\x80\xb2"		=> "\xa1\xe4",	//PRIME
		"\xe2\x80\xb3"		=> "\xa1\xe5",	//DOUBLE PRIME
		"\xe2\x84\x83"		=> "\xa1\xe6",	//DEGREE CELSIUS
		"\xef\xbc\x84"		=> "\xa1\xe7",	//FULLWIDTH DOLLAR SIGN
		"\xc2\xa4"		=> "\xa1\xe8",	//CURRENCY SIGN
		"\xef\xbf\xa0"		=> "\xa1\xe9",	//FULLWIDTH CENT SIGN
		"\xef\xbf\xa1"		=> "\xa1\xea",	//FULLWIDTH POUND SIGN
		"\xe2\x80\xb0"		=> "\xa1\xeb",	//PER MILLE SIGN
		"\xc2\xa7"		=> "\xa1\xec",	//SECTION SIGN
		"\xe2\x84\x96"		=> "\xa1\xed",	//NUMERO SIGN
		"\xe2\x98\x86"		=> "\xa1\xee",	//WHITE STAR
		"\xe2\x98\x85"		=> "\xa1\xef",	//BLACK STAR
		"\xe2\x97\x8b"		=> "\xa1\xf0",	//WHITE CIRCLE
		"\xe2\x97\x8f"		=> "\xa1\xf1",	//BLACK CIRCLE
		"\xe2\x97\x8e"		=> "\xa1\xf2",	//BULLSEYE
		"\xe2\x97\x87"		=> "\xa1\xf3",	//WHITE DIAMOND
		"\xe2\x97\x86"		=> "\xa1\xf4",	//BLACK DIAMOND
		"\xe2\x96\xa1"		=> "\xa1\xf5",	//WHITE SQUARE
		"\xe2\x96\xa0"		=> "\xa1\xf6",	//BLACK SQUARE
		"\xe2\x96\xb3"		=> "\xa1\xf7",	//WHITE UP-POINTING TRIANGLE
		"\xe2\x96\xb2"		=> "\xa1\xf8",	//BLACK UP-POINTING TRIANGLE
		"\xe2\x80\xbb"		=> "\xa1\xf9",	//REFERENCE MARK
		"\xe2\x86\x92"		=> "\xa1\xfa",	//RIGHTWARDS ARROW
		"\xe2\x86\x90"		=> "\xa1\xfb",	//LEFTWARDS ARROW
		"\xe2\x86\x91"		=> "\xa1\xfc",	//UPWARDS ARROW
		"\xe2\x86\x93"		=> "\xa1\xfd",	//DOWNWARDS ARROW
		"\xe3\x80\x93"		=> "\xa1\xfe",	//GETA MARK
		"\xe2\x85\xb0"		=> "\xa2\xa1",	//SMALL ROMAN NUMERAL ONE
		"\xe2\x85\xb1"		=> "\xa2\xa2",	//SMALL ROMAN NUMERAL TWO
		"\xe2\x85\xb2"		=> "\xa2\xa3",	//SMALL ROMAN NUMERAL THREE
		"\xe2\x85\xb3"		=> "\xa2\xa4",	//SMALL ROMAN NUMERAL FOUR
		"\xe2\x85\xb4"		=> "\xa2\xa5",	//SMALL ROMAN NUMERAL FIVE
		"\xe2\x85\xb5"		=> "\xa2\xa6",	//SMALL ROMAN NUMERAL SIX
		"\xe2\x85\xb6"		=> "\xa2\xa7",	//SMALL ROMAN NUMERAL SEVEN
		"\xe2\x85\xb7"		=> "\xa2\xa8",	//SMALL ROMAN NUMERAL EIGHT
		"\xe2\x85\xb8"		=> "\xa2\xa9",	//SMALL ROMAN NUMERAL NINE
		"\xe2\x85\xb9"		=> "\xa2\xaa",	//SMALL ROMAN NUMERAL TEN
		"\xe2\x92\x88"		=> "\xa2\xb1",	//DIGIT ONE FULL STOP
		"\xe2\x92\x89"		=> "\xa2\xb2",	//DIGIT TWO FULL STOP
		"\xe2\x92\x8a"		=> "\xa2\xb3",	//DIGIT THREE FULL STOP
		"\xe2\x92\x8b"		=> "\xa2\xb4",	//DIGIT FOUR FULL STOP
		"\xe2\x92\x8c"		=> "\xa2\xb5",	//DIGIT FIVE FULL STOP
		"\xe2\x92\x8d"		=> "\xa2\xb6",	//DIGIT SIX FULL STOP
		"\xe2\x92\x8e"		=> "\xa2\xb7",	//DIGIT SEVEN FULL STOP
		"\xe2\x92\x8f"		=> "\xa2\xb8",	//DIGIT EIGHT FULL STOP
		"\xe2\x92\x90"		=> "\xa2\xb9",	//DIGIT NINE FULL STOP
		"\xe2\x92\x91"		=> "\xa2\xba",	//NUMBER TEN FULL STOP
		"\xe2\x92\x92"		=> "\xa2\xbb",	//NUMBER ELEVEN FULL STOP
		"\xe2\x92\x93"		=> "\xa2\xbc",	//NUMBER TWELVE FULL STOP
		"\xe2\x92\x94"		=> "\xa2\xbd",	//NUMBER THIRTEEN FULL STOP
		"\xe2\x92\x95"		=> "\xa2\xbe",	//NUMBER FOURTEEN FULL STOP
		"\xe2\x92\x96"		=> "\xa2\xbf",	//NUMBER FIFTEEN FULL STOP
		"\xe2\x92\x97"		=> "\xa2\xc0",	//NUMBER SIXTEEN FULL STOP
		"\xe2\x92\x98"		=> "\xa2\xc1",	//NUMBER SEVENTEEN FULL STOP
		"\xe2\x92\x99"		=> "\xa2\xc2",	//NUMBER EIGHTEEN FULL STOP
		"\xe2\x92\x9a"		=> "\xa2\xc3",	//NUMBER NINETEEN FULL STOP
		"\xe2\x92\x9b"		=> "\xa2\xc4",	//NUMBER TWENTY FULL STOP
		"\xe2\x91\xb4"		=> "\xa2\xc5",	//PARENTHESIZED DIGIT ONE
		"\xe2\x91\xb5"		=> "\xa2\xc6",	//PARENTHESIZED DIGIT TWO
		"\xe2\x91\xb6"		=> "\xa2\xc7",	//PARENTHESIZED DIGIT THREE
		"\xe2\x91\xb7"		=> "\xa2\xc8",	//PARENTHESIZED DIGIT FOUR
		"\xe2\x91\xb8"		=> "\xa2\xc9",	//PARENTHESIZED DIGIT FIVE
		"\xe2\x91\xb9"		=> "\xa2\xca",	//PARENTHESIZED DIGIT SIX
		"\xe2\x91\xba"		=> "\xa2\xcb",	//PARENTHESIZED DIGIT SEVEN
		"\xe2\x91\xbb"		=> "\xa2\xcc",	//PARENTHESIZED DIGIT EIGHT
		"\xe2\x91\xbc"		=> "\xa2\xcd",	//PARENTHESIZED DIGIT NINE
		"\xe2\x91\xbd"		=> "\xa2\xce",	//PARENTHESIZED NUMBER TEN
		"\xe2\x91\xbe"		=> "\xa2\xcf",	//PARENTHESIZED NUMBER ELEVEN
		"\xe2\x91\xbf"		=> "\xa2\xd0",	//PARENTHESIZED NUMBER TWELVE
		"\xe2\x92\x80"		=> "\xa2\xd1",	//PARENTHESIZED NUMBER THIRTEEN
		"\xe2\x92\x81"		=> "\xa2\xd2",	//PARENTHESIZED NUMBER FOURTEEN
		"\xe2\x92\x82"		=> "\xa2\xd3",	//PARENTHESIZED NUMBER FIFTEEN
		"\xe2\x92\x83"		=> "\xa2\xd4",	//PARENTHESIZED NUMBER SIXTEEN
		"\xe2\x92\x84"		=> "\xa2\xd5",	//PARENTHESIZED NUMBER SEVENTEEN
		"\xe2\x92\x85"		=> "\xa2\xd6",	//PARENTHESIZED NUMBER EIGHTEEN
		"\xe2\x92\x86"		=> "\xa2\xd7",	//PARENTHESIZED NUMBER NINETEEN
		"\xe2\x92\x87"		=> "\xa2\xd8",	//PARENTHESIZED NUMBER TWENTY
		"\xe2\x91\xa0"		=> "\xa2\xd9",	//CIRCLED DIGIT ONE
		"\xe2\x91\xa1"		=> "\xa2\xda",	//CIRCLED DIGIT TWO
		"\xe2\x91\xa2"		=> "\xa2\xdb",	//CIRCLED DIGIT THREE
		"\xe2\x91\xa3"		=> "\xa2\xdc",	//CIRCLED DIGIT FOUR
		"\xe2\x91\xa4"		=> "\xa2\xdd",	//CIRCLED DIGIT FIVE
		"\xe2\x91\xa5"		=> "\xa2\xde",	//CIRCLED DIGIT SIX
		"\xe2\x91\xa6"		=> "\xa2\xdf",	//CIRCLED DIGIT SEVEN
		"\xe2\x91\xa7"		=> "\xa2\xe0",	//CIRCLED DIGIT EIGHT
		"\xe2\x91\xa8"		=> "\xa2\xe1",	//CIRCLED DIGIT NINE
		"\xe2\x91\xa9"		=> "\xa2\xe2",	//CIRCLED NUMBER TEN
		"\xe3\x88\xa0"		=> "\xa2\xe5",	//PARENTHESIZED IDEOGRAPH ONE
		"\xe3\x88\xa1"		=> "\xa2\xe6",	//PARENTHESIZED IDEOGRAPH TWO
		"\xe3\x88\xa2"		=> "\xa2\xe7",	//PARENTHESIZED IDEOGRAPH THREE
		"\xe3\x88\xa3"		=> "\xa2\xe8",	//PARENTHESIZED IDEOGRAPH FOUR
		"\xe3\x88\xa4"		=> "\xa2\xe9",	//PARENTHESIZED IDEOGRAPH FIVE
		"\xe3\x88\xa5"		=> "\xa2\xea",	//PARENTHESIZED IDEOGRAPH SIX
		"\xe3\x88\xa6"		=> "\xa2\xeb",	//PARENTHESIZED IDEOGRAPH SEVEN
		"\xe3\x88\xa7"		=> "\xa2\xec",	//PARENTHESIZED IDEOGRAPH EIGHT
		"\xe3\x88\xa8"		=> "\xa2\xed",	//PARENTHESIZED IDEOGRAPH NINE
		"\xe3\x88\xa9"		=> "\xa2\xee",	//PARENTHESIZED IDEOGRAPH TEN
		"\xe2\x85\xa0"		=> "\xa2\xf1",	//ROMAN NUMERAL ONE
		"\xe2\x85\xa1"		=> "\xa2\xf2",	//ROMAN NUMERAL TWO
		"\xe2\x85\xa2"		=> "\xa2\xf3",	//ROMAN NUMERAL THREE
		"\xe2\x85\xa3"		=> "\xa2\xf4",	//ROMAN NUMERAL FOUR
		"\xe2\x85\xa4"		=> "\xa2\xf5",	//ROMAN NUMERAL FIVE
		"\xe2\x85\xa5"		=> "\xa2\xf6",	//ROMAN NUMERAL SIX
		"\xe2\x85\xa6"		=> "\xa2\xf7",	//ROMAN NUMERAL SEVEN
		"\xe2\x85\xa7"		=> "\xa2\xf8",	//ROMAN NUMERAL EIGHT
		"\xe2\x85\xa8"		=> "\xa2\xf9",	//ROMAN NUMERAL NINE
		"\xe2\x85\xa9"		=> "\xa2\xfa",	//ROMAN NUMERAL TEN
		"\xe2\x85\xaa"		=> "\xa2\xfb",	//ROMAN NUMERAL ELEVEN
		"\xe2\x85\xab"		=> "\xa2\xfc",	//ROMAN NUMERAL TWELVE
		"\xef\xbc\x81"		=> "\xa3\xa1",	//FULLWIDTH EXCLAMATION MARK
		"\xef\xbc\x82"		=> "\xa3\xa2",	//FULLWIDTH QUOTATION MARK
		"\xef\xbc\x83"		=> "\xa3\xa3",	//FULLWIDTH NUMBER SIGN
		"\xef\xbf\xa5"		=> "\xa3\xa4",	//FULLWIDTH YEN SIGN
		"\xef\xbc\x85"		=> "\xa3\xa5",	//FULLWIDTH PERCENT SIGN
		"\xef\xbc\x86"		=> "\xa3\xa6",	//FULLWIDTH AMPERSAND
		"\xef\xbc\x87"		=> "\xa3\xa7",	//FULLWIDTH APOSTROPHE
		"\xef\xbc\x88"		=> "\xa3\xa8",	//FULLWIDTH LEFT PARENTHESIS
		"\xef\xbc\x89"		=> "\xa3\xa9",	//FULLWIDTH RIGHT PARENTHESIS
		"\xef\xbc\x8a"		=> "\xa3\xaa",	//FULLWIDTH ASTERISK
		"\xef\xbc\x8b"		=> "\xa3\xab",	//FULLWIDTH PLUS SIGN
		"\xef\xbc\x8c"		=> "\xa3\xac",	//FULLWIDTH COMMA
		"\xef\xbc\x8d"		=> "\xa3\xad",	//FULLWIDTH HYPHEN-MINUS
		"\xef\xbc\x8e"		=> "\xa3\xae",	//FULLWIDTH FULL STOP
		"\xef\xbc\x8f"		=> "\xa3\xaf",	//FULLWIDTH SOLIDUS
		"\xef\xbc\x90"		=> "\xa3\xb0",	//FULLWIDTH DIGIT ZERO
		"\xef\xbc\x91"		=> "\xa3\xb1",	//FULLWIDTH DIGIT ONE
		"\xef\xbc\x92"		=> "\xa3\xb2",	//FULLWIDTH DIGIT TWO
		"\xef\xbc\x93"		=> "\xa3\xb3",	//FULLWIDTH DIGIT THREE
		"\xef\xbc\x94"		=> "\xa3\xb4",	//FULLWIDTH DIGIT FOUR
		"\xef\xbc\x95"		=> "\xa3\xb5",	//FULLWIDTH DIGIT FIVE
		"\xef\xbc\x96"		=> "\xa3\xb6",	//FULLWIDTH DIGIT SIX
		"\xef\xbc\x97"		=> "\xa3\xb7",	//FULLWIDTH DIGIT SEVEN
		"\xef\xbc\x98"		=> "\xa3\xb8",	//FULLWIDTH DIGIT EIGHT
		"\xef\xbc\x99"		=> "\xa3\xb9",	//FULLWIDTH DIGIT NINE
		"\xef\xbc\x9a"		=> "\xa3\xba",	//FULLWIDTH COLON
		"\xef\xbc\x9b"		=> "\xa3\xbb",	//FULLWIDTH SEMICOLON
		"\xef\xbc\x9c"		=> "\xa3\xbc",	//FULLWIDTH LESS-THAN SIGN
		"\xef\xbc\x9d"		=> "\xa3\xbd",	//FULLWIDTH EQUALS SIGN
		"\xef\xbc\x9e"		=> "\xa3\xbe",	//FULLWIDTH GREATER-THAN SIGN
		"\xef\xbc\x9f"		=> "\xa3\xbf",	//FULLWIDTH QUESTION MARK
		"\xef\xbc\xa0"		=> "\xa3\xc0",	//FULLWIDTH COMMERCIAL AT
		"\xef\xbc\xa1"		=> "\xa3\xc1",	//FULLWIDTH LATIN CAPITAL LETTER A
		"\xef\xbc\xa2"		=> "\xa3\xc2",	//FULLWIDTH LATIN CAPITAL LETTER B
		"\xef\xbc\xa3"		=> "\xa3\xc3",	//FULLWIDTH LATIN CAPITAL LETTER C
		"\xef\xbc\xa4"		=> "\xa3\xc4",	//FULLWIDTH LATIN CAPITAL LETTER D
		"\xef\xbc\xa5"		=> "\xa3\xc5",	//FULLWIDTH LATIN CAPITAL LETTER E
		"\xef\xbc\xa6"		=> "\xa3\xc6",	//FULLWIDTH LATIN CAPITAL LETTER F
		"\xef\xbc\xa7"		=> "\xa3\xc7",	//FULLWIDTH LATIN CAPITAL LETTER G
		"\xef\xbc\xa8"		=> "\xa3\xc8",	//FULLWIDTH LATIN CAPITAL LETTER H
		"\xef\xbc\xa9"		=> "\xa3\xc9",	//FULLWIDTH LATIN CAPITAL LETTER I
		"\xef\xbc\xaa"		=> "\xa3\xca",	//FULLWIDTH LATIN CAPITAL LETTER J
		"\xef\xbc\xab"		=> "\xa3\xcb",	//FULLWIDTH LATIN CAPITAL LETTER K
		"\xef\xbc\xac"		=> "\xa3\xcc",	//FULLWIDTH LATIN CAPITAL LETTER L
		"\xef\xbc\xad"		=> "\xa3\xcd",	//FULLWIDTH LATIN CAPITAL LETTER M
		"\xef\xbc\xae"		=> "\xa3\xce",	//FULLWIDTH LATIN CAPITAL LETTER N
		"\xef\xbc\xaf"		=> "\xa3\xcf",	//FULLWIDTH LATIN CAPITAL LETTER O
		"\xef\xbc\xb0"		=> "\xa3\xd0",	//FULLWIDTH LATIN CAPITAL LETTER P
		"\xef\xbc\xb1"		=> "\xa3\xd1",	//FULLWIDTH LATIN CAPITAL LETTER Q
		"\xef\xbc\xb2"		=> "\xa3\xd2",	//FULLWIDTH LATIN CAPITAL LETTER R
		"\xef\xbc\xb3"		=> "\xa3\xd3",	//FULLWIDTH LATIN CAPITAL LETTER S
		"\xef\xbc\xb4"		=> "\xa3\xd4",	//FULLWIDTH LATIN CAPITAL LETTER T
		"\xef\xbc\xb5"		=> "\xa3\xd5",	//FULLWIDTH LATIN CAPITAL LETTER U
		"\xef\xbc\xb6"		=> "\xa3\xd6",	//FULLWIDTH LATIN CAPITAL LETTER V
		"\xef\xbc\xb7"		=> "\xa3\xd7",	//FULLWIDTH LATIN CAPITAL LETTER W
		"\xef\xbc\xb8"		=> "\xa3\xd8",	//FULLWIDTH LATIN CAPITAL LETTER X
		"\xef\xbc\xb9"		=> "\xa3\xd9",	//FULLWIDTH LATIN CAPITAL LETTER Y
		"\xef\xbc\xba"		=> "\xa3\xda",	//FULLWIDTH LATIN CAPITAL LETTER Z
		"\xef\xbc\xbb"		=> "\xa3\xdb",	//FULLWIDTH LEFT SQUARE BRACKET
		"\xef\xbc\xbc"		=> "\xa3\xdc",	//FULLWIDTH REVERSE SOLIDUS
		"\xef\xbc\xbd"		=> "\xa3\xdd",	//FULLWIDTH RIGHT SQUARE BRACKET
		"\xef\xbc\xbe"		=> "\xa3\xde",	//FULLWIDTH CIRCUMFLEX ACCENT
		"\xef\xbc\xbf"		=> "\xa3\xdf",	//FULLWIDTH LOW LINE
		"\xef\xbd\x80"		=> "\xa3\xe0",	//FULLWIDTH GRAVE ACCENT
		"\xef\xbd\x81"		=> "\xa3\xe1",	//FULLWIDTH LATIN SMALL LETTER A
		"\xef\xbd\x82"		=> "\xa3\xe2",	//FULLWIDTH LATIN SMALL LETTER B
		"\xef\xbd\x83"		=> "\xa3\xe3",	//FULLWIDTH LATIN SMALL LETTER C
		"\xef\xbd\x84"		=> "\xa3\xe4",	//FULLWIDTH LATIN SMALL LETTER D
		"\xef\xbd\x85"		=> "\xa3\xe5",	//FULLWIDTH LATIN SMALL LETTER E
		"\xef\xbd\x86"		=> "\xa3\xe6",	//FULLWIDTH LATIN SMALL LETTER F
		"\xef\xbd\x87"		=> "\xa3\xe7",	//FULLWIDTH LATIN SMALL LETTER G
		"\xef\xbd\x88"		=> "\xa3\xe8",	//FULLWIDTH LATIN SMALL LETTER H
		"\xef\xbd\x89"		=> "\xa3\xe9",	//FULLWIDTH LATIN SMALL LETTER I
		"\xef\xbd\x8a"		=> "\xa3\xea",	//FULLWIDTH LATIN SMALL LETTER J
		"\xef\xbd\x8b"		=> "\xa3\xeb",	//FULLWIDTH LATIN SMALL LETTER K
		"\xef\xbd\x8c"		=> "\xa3\xec",	//FULLWIDTH LATIN SMALL LETTER L
		"\xef\xbd\x8d"		=> "\xa3\xed",	//FULLWIDTH LATIN SMALL LETTER M
		"\xef\xbd\x8e"		=> "\xa3\xee",	//FULLWIDTH LATIN SMALL LETTER N
		"\xef\xbd\x8f"		=> "\xa3\xef",	//FULLWIDTH LATIN SMALL LETTER O
		"\xef\xbd\x90"		=> "\xa3\xf0",	//FULLWIDTH LATIN SMALL LETTER P
		"\xef\xbd\x91"		=> "\xa3\xf1",	//FULLWIDTH LATIN SMALL LETTER Q
		"\xef\xbd\x92"		=> "\xa3\xf2",	//FULLWIDTH LATIN SMALL LETTER R
		"\xef\xbd\x93"		=> "\xa3\xf3",	//FULLWIDTH LATIN SMALL LETTER S
		"\xef\xbd\x94"		=> "\xa3\xf4",	//FULLWIDTH LATIN SMALL LETTER T
		"\xef\xbd\x95"		=> "\xa3\xf5",	//FULLWIDTH LATIN SMALL LETTER U
		"\xef\xbd\x96"		=> "\xa3\xf6",	//FULLWIDTH LATIN SMALL LETTER V
		"\xef\xbd\x97"		=> "\xa3\xf7",	//FULLWIDTH LATIN SMALL LETTER W
		"\xef\xbd\x98"		=> "\xa3\xf8",	//FULLWIDTH LATIN SMALL LETTER X
		"\xef\xbd\x99"		=> "\xa3\xf9",	//FULLWIDTH LATIN SMALL LETTER Y
		"\xef\xbd\x9a"		=> "\xa3\xfa",	//FULLWIDTH LATIN SMALL LETTER Z
		"\xef\xbd\x9b"		=> "\xa3\xfb",	//FULLWIDTH LEFT CURLY BRACKET
		"\xef\xbd\x9c"		=> "\xa3\xfc",	//FULLWIDTH VERTICAL LINE
		"\xef\xbd\x9d"		=> "\xa3\xfd",	//FULLWIDTH RIGHT CURLY BRACKET
		"\xef\xbf\xa3"		=> "\xa3\xfe",	//FULLWIDTH MACRON
		"\xe3\x81\x81"		=> "\xa4\xa1",	//HIRAGANA LETTER SMALL A
		"\xe3\x81\x82"		=> "\xa4\xa2",	//HIRAGANA LETTER A
		"\xe3\x81\x83"		=> "\xa4\xa3",	//HIRAGANA LETTER SMALL I
		"\xe3\x81\x84"		=> "\xa4\xa4",	//HIRAGANA LETTER I
		"\xe3\x81\x85"		=> "\xa4\xa5",	//HIRAGANA LETTER SMALL U
		"\xe3\x81\x86"		=> "\xa4\xa6",	//HIRAGANA LETTER U
		"\xe3\x81\x87"		=> "\xa4\xa7",	//HIRAGANA LETTER SMALL E
		"\xe3\x81\x88"		=> "\xa4\xa8",	//HIRAGANA LETTER E
		"\xe3\x81\x89"		=> "\xa4\xa9",	//HIRAGANA LETTER SMALL O
		"\xe3\x81\x8a"		=> "\xa4\xaa",	//HIRAGANA LETTER O
		"\xe3\x81\x8b"		=> "\xa4\xab",	//HIRAGANA LETTER KA
		"\xe3\x81\x8c"		=> "\xa4\xac",	//HIRAGANA LETTER GA
		"\xe3\x81\x8d"		=> "\xa4\xad",	//HIRAGANA LETTER KI
		"\xe3\x81\x8e"		=> "\xa4\xae",	//HIRAGANA LETTER GI
		"\xe3\x81\x8f"		=> "\xa4\xaf",	//HIRAGANA LETTER KU
		"\xe3\x81\x90"		=> "\xa4\xb0",	//HIRAGANA LETTER GU
		"\xe3\x81\x91"		=> "\xa4\xb1",	//HIRAGANA LETTER KE
		"\xe3\x81\x92"		=> "\xa4\xb2",	//HIRAGANA LETTER GE
		"\xe3\x81\x93"		=> "\xa4\xb3",	//HIRAGANA LETTER KO
		"\xe3\x81\x94"		=> "\xa4\xb4",	//HIRAGANA LETTER GO
		"\xe3\x81\x95"		=> "\xa4\xb5",	//HIRAGANA LETTER SA
		"\xe3\x81\x96"		=> "\xa4\xb6",	//HIRAGANA LETTER ZA
		"\xe3\x81\x97"		=> "\xa4\xb7",	//HIRAGANA LETTER SI
		"\xe3\x81\x98"		=> "\xa4\xb8",	//HIRAGANA LETTER ZI
		"\xe3\x81\x99"		=> "\xa4\xb9",	//HIRAGANA LETTER SU
		"\xe3\x81\x9a"		=> "\xa4\xba",	//HIRAGANA LETTER ZU
		"\xe3\x81\x9b"		=> "\xa4\xbb",	//HIRAGANA LETTER SE
		"\xe3\x81\x9c"		=> "\xa4\xbc",	//HIRAGANA LETTER ZE
		"\xe3\x81\x9d"		=> "\xa4\xbd",	//HIRAGANA LETTER SO
		"\xe3\x81\x9e"		=> "\xa4\xbe",	//HIRAGANA LETTER ZO
		"\xe3\x81\x9f"		=> "\xa4\xbf",	//HIRAGANA LETTER TA
		"\xe3\x81\xa0"		=> "\xa4\xc0",	//HIRAGANA LETTER DA
		"\xe3\x81\xa1"		=> "\xa4\xc1",	//HIRAGANA LETTER TI
		"\xe3\x81\xa2"		=> "\xa4\xc2",	//HIRAGANA LETTER DI
		"\xe3\x81\xa3"		=> "\xa4\xc3",	//HIRAGANA LETTER SMALL TU
		"\xe3\x81\xa4"		=> "\xa4\xc4",	//HIRAGANA LETTER TU
		"\xe3\x81\xa5"		=> "\xa4\xc5",	//HIRAGANA LETTER DU
		"\xe3\x81\xa6"		=> "\xa4\xc6",	//HIRAGANA LETTER TE
		"\xe3\x81\xa7"		=> "\xa4\xc7",	//HIRAGANA LETTER DE
		"\xe3\x81\xa8"		=> "\xa4\xc8",	//HIRAGANA LETTER TO
		"\xe3\x81\xa9"		=> "\xa4\xc9",	//HIRAGANA LETTER DO
		"\xe3\x81\xaa"		=> "\xa4\xca",	//HIRAGANA LETTER NA
		"\xe3\x81\xab"		=> "\xa4\xcb",	//HIRAGANA LETTER NI
		"\xe3\x81\xac"		=> "\xa4\xcc",	//HIRAGANA LETTER NU
		"\xe3\x81\xad"		=> "\xa4\xcd",	//HIRAGANA LETTER NE
		"\xe3\x81\xae"		=> "\xa4\xce",	//HIRAGANA LETTER NO
		"\xe3\x81\xaf"		=> "\xa4\xcf",	//HIRAGANA LETTER HA
		"\xe3\x81\xb0"		=> "\xa4\xd0",	//HIRAGANA LETTER BA
		"\xe3\x81\xb1"		=> "\xa4\xd1",	//HIRAGANA LETTER PA
		"\xe3\x81\xb2"		=> "\xa4\xd2",	//HIRAGANA LETTER HI
		"\xe3\x81\xb3"		=> "\xa4\xd3",	//HIRAGANA LETTER BI
		"\xe3\x81\xb4"		=> "\xa4\xd4",	//HIRAGANA LETTER PI
		"\xe3\x81\xb5"		=> "\xa4\xd5",	//HIRAGANA LETTER HU
		"\xe3\x81\xb6"		=> "\xa4\xd6",	//HIRAGANA LETTER BU
		"\xe3\x81\xb7"		=> "\xa4\xd7",	//HIRAGANA LETTER PU
		"\xe3\x81\xb8"		=> "\xa4\xd8",	//HIRAGANA LETTER HE
		"\xe3\x81\xb9"		=> "\xa4\xd9",	//HIRAGANA LETTER BE
		"\xe3\x81\xba"		=> "\xa4\xda",	//HIRAGANA LETTER PE
		"\xe3\x81\xbb"		=> "\xa4\xdb",	//HIRAGANA LETTER HO
		"\xe3\x81\xbc"		=> "\xa4\xdc",	//HIRAGANA LETTER BO
		"\xe3\x81\xbd"		=> "\xa4\xdd",	//HIRAGANA LETTER PO
		"\xe3\x81\xbe"		=> "\xa4\xde",	//HIRAGANA LETTER MA
		"\xe3\x81\xbf"		=> "\xa4\xdf",	//HIRAGANA LETTER MI
		"\xe3\x82\x80"		=> "\xa4\xe0",	//HIRAGANA LETTER MU
		"\xe3\x82\x81"		=> "\xa4\xe1",	//HIRAGANA LETTER ME
		"\xe3\x82\x82"		=> "\xa4\xe2",	//HIRAGANA LETTER MO
		"\xe3\x82\x83"		=> "\xa4\xe3",	//HIRAGANA LETTER SMALL YA
		"\xe3\x82\x84"		=> "\xa4\xe4",	//HIRAGANA LETTER YA
		"\xe3\x82\x85"		=> "\xa4\xe5",	//HIRAGANA LETTER SMALL YU
		"\xe3\x82\x86"		=> "\xa4\xe6",	//HIRAGANA LETTER YU
		"\xe3\x82\x87"		=> "\xa4\xe7",	//HIRAGANA LETTER SMALL YO
		"\xe3\x82\x88"		=> "\xa4\xe8",	//HIRAGANA LETTER YO
		"\xe3\x82\x89"		=> "\xa4\xe9",	//HIRAGANA LETTER RA
		"\xe3\x82\x8a"		=> "\xa4\xea",	//HIRAGANA LETTER RI
		"\xe3\x82\x8b"		=> "\xa4\xeb",	//HIRAGANA LETTER RU
		"\xe3\x82\x8c"		=> "\xa4\xec",	//HIRAGANA LETTER RE
		"\xe3\x82\x8d"		=> "\xa4\xed",	//HIRAGANA LETTER RO
		"\xe3\x82\x8e"		=> "\xa4\xee",	//HIRAGANA LETTER SMALL WA
		"\xe3\x82\x8f"		=> "\xa4\xef",	//HIRAGANA LETTER WA
		"\xe3\x82\x90"		=> "\xa4\xf0",	//HIRAGANA LETTER WI
		"\xe3\x82\x91"		=> "\xa4\xf1",	//HIRAGANA LETTER WE
		"\xe3\x82\x92"		=> "\xa4\xf2",	//HIRAGANA LETTER WO
		"\xe3\x82\x93"		=> "\xa4\xf3",	//HIRAGANA LETTER N
		"\xe3\x82\xa1"		=> "\xa5\xa1",	//KATAKANA LETTER SMALL A
		"\xe3\x82\xa2"		=> "\xa5\xa2",	//KATAKANA LETTER A
		"\xe3\x82\xa3"		=> "\xa5\xa3",	//KATAKANA LETTER SMALL I
		"\xe3\x82\xa4"		=> "\xa5\xa4",	//KATAKANA LETTER I
		"\xe3\x82\xa5"		=> "\xa5\xa5",	//KATAKANA LETTER SMALL U
		"\xe3\x82\xa6"		=> "\xa5\xa6",	//KATAKANA LETTER U
		"\xe3\x82\xa7"		=> "\xa5\xa7",	//KATAKANA LETTER SMALL E
		"\xe3\x82\xa8"		=> "\xa5\xa8",	//KATAKANA LETTER E
		"\xe3\x82\xa9"		=> "\xa5\xa9",	//KATAKANA LETTER SMALL O
		"\xe3\x82\xaa"		=> "\xa5\xaa",	//KATAKANA LETTER O
		"\xe3\x82\xab"		=> "\xa5\xab",	//KATAKANA LETTER KA
		"\xe3\x82\xac"		=> "\xa5\xac",	//KATAKANA LETTER GA
		"\xe3\x82\xad"		=> "\xa5\xad",	//KATAKANA LETTER KI
		"\xe3\x82\xae"		=> "\xa5\xae",	//KATAKANA LETTER GI
		"\xe3\x82\xaf"		=> "\xa5\xaf",	//KATAKANA LETTER KU
		"\xe3\x82\xb0"		=> "\xa5\xb0",	//KATAKANA LETTER GU
		"\xe3\x82\xb1"		=> "\xa5\xb1",	//KATAKANA LETTER KE
		"\xe3\x82\xb2"		=> "\xa5\xb2",	//KATAKANA LETTER GE
		"\xe3\x82\xb3"		=> "\xa5\xb3",	//KATAKANA LETTER KO
		"\xe3\x82\xb4"		=> "\xa5\xb4",	//KATAKANA LETTER GO
		"\xe3\x82\xb5"		=> "\xa5\xb5",	//KATAKANA LETTER SA
		"\xe3\x82\xb6"		=> "\xa5\xb6",	//KATAKANA LETTER ZA
		"\xe3\x82\xb7"		=> "\xa5\xb7",	//KATAKANA LETTER SI
		"\xe3\x82\xb8"		=> "\xa5\xb8",	//KATAKANA LETTER ZI
		"\xe3\x82\xb9"		=> "\xa5\xb9",	//KATAKANA LETTER SU
		"\xe3\x82\xba"		=> "\xa5\xba",	//KATAKANA LETTER ZU
		"\xe3\x82\xbb"		=> "\xa5\xbb",	//KATAKANA LETTER SE
		"\xe3\x82\xbc"		=> "\xa5\xbc",	//KATAKANA LETTER ZE
		"\xe3\x82\xbd"		=> "\xa5\xbd",	//KATAKANA LETTER SO
		"\xe3\x82\xbe"		=> "\xa5\xbe",	//KATAKANA LETTER ZO
		"\xe3\x82\xbf"		=> "\xa5\xbf",	//KATAKANA LETTER TA
		"\xe3\x83\x80"		=> "\xa5\xc0",	//KATAKANA LETTER DA
		"\xe3\x83\x81"		=> "\xa5\xc1",	//KATAKANA LETTER TI
		"\xe3\x83\x82"		=> "\xa5\xc2",	//KATAKANA LETTER DI
		"\xe3\x83\x83"		=> "\xa5\xc3",	//KATAKANA LETTER SMALL TU
		"\xe3\x83\x84"		=> "\xa5\xc4",	//KATAKANA LETTER TU
		"\xe3\x83\x85"		=> "\xa5\xc5",	//KATAKANA LETTER DU
		"\xe3\x83\x86"		=> "\xa5\xc6",	//KATAKANA LETTER TE
		"\xe3\x83\x87"		=> "\xa5\xc7",	//KATAKANA LETTER DE
		"\xe3\x83\x88"		=> "\xa5\xc8",	//KATAKANA LETTER TO
		"\xe3\x83\x89"		=> "\xa5\xc9",	//KATAKANA LETTER DO
		"\xe3\x83\x8a"		=> "\xa5\xca",	//KATAKANA LETTER NA
		"\xe3\x83\x8b"		=> "\xa5\xcb",	//KATAKANA LETTER NI
		"\xe3\x83\x8c"		=> "\xa5\xcc",	//KATAKANA LETTER NU
		"\xe3\x83\x8d"		=> "\xa5\xcd",	//KATAKANA LETTER NE
		"\xe3\x83\x8e"		=> "\xa5\xce",	//KATAKANA LETTER NO
		"\xe3\x83\x8f"		=> "\xa5\xcf",	//KATAKANA LETTER HA
		"\xe3\x83\x90"		=> "\xa5\xd0",	//KATAKANA LETTER BA
		"\xe3\x83\x91"		=> "\xa5\xd1",	//KATAKANA LETTER PA
		"\xe3\x83\x92"		=> "\xa5\xd2",	//KATAKANA LETTER HI
		"\xe3\x83\x93"		=> "\xa5\xd3",	//KATAKANA LETTER BI
		"\xe3\x83\x94"		=> "\xa5\xd4",	//KATAKANA LETTER PI
		"\xe3\x83\x95"		=> "\xa5\xd5",	//KATAKANA LETTER HU
		"\xe3\x83\x96"		=> "\xa5\xd6",	//KATAKANA LETTER BU
		"\xe3\x83\x97"		=> "\xa5\xd7",	//KATAKANA LETTER PU
		"\xe3\x83\x98"		=> "\xa5\xd8",	//KATAKANA LETTER HE
		"\xe3\x83\x99"		=> "\xa5\xd9",	//KATAKANA LETTER BE
		"\xe3\x83\x9a"		=> "\xa5\xda",	//KATAKANA LETTER PE
		"\xe3\x83\x9b"		=> "\xa5\xdb",	//KATAKANA LETTER HO
		"\xe3\x83\x9c"		=> "\xa5\xdc",	//KATAKANA LETTER BO
		"\xe3\x83\x9d"		=> "\xa5\xdd",	//KATAKANA LETTER PO
		"\xe3\x83\x9e"		=> "\xa5\xde",	//KATAKANA LETTER MA
		"\xe3\x83\x9f"		=> "\xa5\xdf",	//KATAKANA LETTER MI
		"\xe3\x83\xa0"		=> "\xa5\xe0",	//KATAKANA LETTER MU
		"\xe3\x83\xa1"		=> "\xa5\xe1",	//KATAKANA LETTER ME
		"\xe3\x83\xa2"		=> "\xa5\xe2",	//KATAKANA LETTER MO
		"\xe3\x83\xa3"		=> "\xa5\xe3",	//KATAKANA LETTER SMALL YA
		"\xe3\x83\xa4"		=> "\xa5\xe4",	//KATAKANA LETTER YA
		"\xe3\x83\xa5"		=> "\xa5\xe5",	//KATAKANA LETTER SMALL YU
		"\xe3\x83\xa6"		=> "\xa5\xe6",	//KATAKANA LETTER YU
		"\xe3\x83\xa7"		=> "\xa5\xe7",	//KATAKANA LETTER SMALL YO
		"\xe3\x83\xa8"		=> "\xa5\xe8",	//KATAKANA LETTER YO
		"\xe3\x83\xa9"		=> "\xa5\xe9",	//KATAKANA LETTER RA
		"\xe3\x83\xaa"		=> "\xa5\xea",	//KATAKANA LETTER RI
		"\xe3\x83\xab"		=> "\xa5\xeb",	//KATAKANA LETTER RU
		"\xe3\x83\xac"		=> "\xa5\xec",	//KATAKANA LETTER RE
		"\xe3\x83\xad"		=> "\xa5\xed",	//KATAKANA LETTER RO
		"\xe3\x83\xae"		=> "\xa5\xee",	//KATAKANA LETTER SMALL WA
		"\xe3\x83\xaf"		=> "\xa5\xef",	//KATAKANA LETTER WA
		"\xe3\x83\xb0"		=> "\xa5\xf0",	//KATAKANA LETTER WI
		"\xe3\x83\xb1"		=> "\xa5\xf1",	//KATAKANA LETTER WE
		"\xe3\x83\xb2"		=> "\xa5\xf2",	//KATAKANA LETTER WO
		"\xe3\x83\xb3"		=> "\xa5\xf3",	//KATAKANA LETTER N
		"\xe3\x83\xb4"		=> "\xa5\xf4",	//KATAKANA LETTER VU
		"\xe3\x83\xb5"		=> "\xa5\xf5",	//KATAKANA LETTER SMALL KA
		"\xe3\x83\xb6"		=> "\xa5\xf6",	//KATAKANA LETTER SMALL KE
		"\xce\x91"		=> "\xa6\xa1",	//GREEK CAPITAL LETTER ALPHA
		"\xce\x92"		=> "\xa6\xa2",	//GREEK CAPITAL LETTER BETA
		"\xce\x93"		=> "\xa6\xa3",	//GREEK CAPITAL LETTER GAMMA
		"\xce\x94"		=> "\xa6\xa4",	//GREEK CAPITAL LETTER DELTA
		"\xce\x95"		=> "\xa6\xa5",	//GREEK CAPITAL LETTER EPSILON
		"\xce\x96"		=> "\xa6\xa6",	//GREEK CAPITAL LETTER ZETA
		"\xce\x97"		=> "\xa6\xa7",	//GREEK CAPITAL LETTER ETA
		"\xce\x98"		=> "\xa6\xa8",	//GREEK CAPITAL LETTER THETA
		"\xce\x99"		=> "\xa6\xa9",	//GREEK CAPITAL LETTER IOTA
		"\xce\x9a"		=> "\xa6\xaa",	//GREEK CAPITAL LETTER KAPPA
		"\xce\x9b"		=> "\xa6\xab",	//GREEK CAPITAL LETTER LAMDA
		"\xce\x9c"		=> "\xa6\xac",	//GREEK CAPITAL LETTER MU
		"\xce\x9d"		=> "\xa6\xad",	//GREEK CAPITAL LETTER NU
		"\xce\x9e"		=> "\xa6\xae",	//GREEK CAPITAL LETTER XI
		"\xce\x9f"		=> "\xa6\xaf",	//GREEK CAPITAL LETTER OMICRON
		"\xce\xa0"		=> "\xa6\xb0",	//GREEK CAPITAL LETTER PI
		"\xce\xa1"		=> "\xa6\xb1",	//GREEK CAPITAL LETTER RHO
		"\xce\xa3"		=> "\xa6\xb2",	//GREEK CAPITAL LETTER SIGMA
		"\xce\xa4"		=> "\xa6\xb3",	//GREEK CAPITAL LETTER TAU
		"\xce\xa5"		=> "\xa6\xb4",	//GREEK CAPITAL LETTER UPSILON
		"\xce\xa6"		=> "\xa6\xb5",	//GREEK CAPITAL LETTER PHI
		"\xce\xa7"		=> "\xa6\xb6",	//GREEK CAPITAL LETTER CHI
		"\xce\xa8"		=> "\xa6\xb7",	//GREEK CAPITAL LETTER PSI
		"\xce\xa9"		=> "\xa6\xb8",	//GREEK CAPITAL LETTER OMEGA
		"\xce\xb1"		=> "\xa6\xc1",	//GREEK SMALL LETTER ALPHA
		"\xce\xb2"		=> "\xa6\xc2",	//GREEK SMALL LETTER BETA
		"\xce\xb3"		=> "\xa6\xc3",	//GREEK SMALL LETTER GAMMA
		"\xce\xb4"		=> "\xa6\xc4",	//GREEK SMALL LETTER DELTA
		"\xce\xb5"		=> "\xa6\xc5",	//GREEK SMALL LETTER EPSILON
		"\xce\xb6"		=> "\xa6\xc6",	//GREEK SMALL LETTER ZETA
		"\xce\xb7"		=> "\xa6\xc7",	//GREEK SMALL LETTER ETA
		"\xce\xb8"		=> "\xa6\xc8",	//GREEK SMALL LETTER THETA
		"\xce\xb9"		=> "\xa6\xc9",	//GREEK SMALL LETTER IOTA
		"\xce\xba"		=> "\xa6\xca",	//GREEK SMALL LETTER KAPPA
		"\xce\xbb"		=> "\xa6\xcb",	//GREEK SMALL LETTER LAMDA
		"\xce\xbc"		=> "\xa6\xcc",	//GREEK SMALL LETTER MU
		"\xce\xbd"		=> "\xa6\xcd",	//GREEK SMALL LETTER NU
		"\xce\xbe"		=> "\xa6\xce",	//GREEK SMALL LETTER XI
		"\xce\xbf"		=> "\xa6\xcf",	//GREEK SMALL LETTER OMICRON
		"\xcf\x80"		=> "\xa6\xd0",	//GREEK SMALL LETTER PI
		"\xcf\x81"		=> "\xa6\xd1",	//GREEK SMALL LETTER RHO
		"\xcf\x83"		=> "\xa6\xd2",	//GREEK SMALL LETTER SIGMA
		"\xcf\x84"		=> "\xa6\xd3",	//GREEK SMALL LETTER TAU
		"\xcf\x85"		=> "\xa6\xd4",	//GREEK SMALL LETTER UPSILON
		"\xcf\x86"		=> "\xa6\xd5",	//GREEK SMALL LETTER PHI
		"\xcf\x87"		=> "\xa6\xd6",	//GREEK SMALL LETTER CHI
		"\xcf\x88"		=> "\xa6\xd7",	//GREEK SMALL LETTER PSI
		"\xcf\x89"		=> "\xa6\xd8",	//GREEK SMALL LETTER OMEGA
		"\xef\xb8\xb5"		=> "\xa6\xe0",	//PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
		"\xef\xb8\xb6"		=> "\xa6\xe1",	//PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
		"\xef\xb8\xb9"		=> "\xa6\xe2",	//PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
		"\xef\xb8\xba"		=> "\xa6\xe3",	//PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
		"\xef\xb8\xbf"		=> "\xa6\xe4",	//PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
		"\xef\xb9\x80"		=> "\xa6\xe5",	//PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
		"\xef\xb8\xbd"		=> "\xa6\xe6",	//PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
		"\xef\xb8\xbe"		=> "\xa6\xe7",	//PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
		"\xef\xb9\x81"		=> "\xa6\xe8",	//PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
		"\xef\xb9\x82"		=> "\xa6\xe9",	//PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
		"\xef\xb9\x83"		=> "\xa6\xea",	//PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
		"\xef\xb9\x84"		=> "\xa6\xeb",	//PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
		"\xef\xb8\xbb"		=> "\xa6\xee",	//PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
		"\xef\xb8\xbc"		=> "\xa6\xef",	//PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
		"\xef\xb8\xb7"		=> "\xa6\xf0",	//PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
		"\xef\xb8\xb8"		=> "\xa6\xf1",	//PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
		"\xef\xb8\xb1"		=> "\xa6\xf2",	//PRESENTATION FORM FOR VERTICAL EM DASH
		"\xef\xb8\xb3"		=> "\xa6\xf4",	//PRESENTATION FORM FOR VERTICAL LOW LINE
		"\xef\xb8\xb4"		=> "\xa6\xf5",	//PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
		"\xd0\x90"		=> "\xa7\xa1",	//CYRILLIC CAPITAL LETTER A
		"\xd0\x91"		=> "\xa7\xa2",	//CYRILLIC CAPITAL LETTER BE
		"\xd0\x92"		=> "\xa7\xa3",	//CYRILLIC CAPITAL LETTER VE
		"\xd0\x93"		=> "\xa7\xa4",	//CYRILLIC CAPITAL LETTER GHE
		"\xd0\x94"		=> "\xa7\xa5",	//CYRILLIC CAPITAL LETTER DE
		"\xd0\x95"		=> "\xa7\xa6",	//CYRILLIC CAPITAL LETTER IE
		"\xd0\x81"		=> "\xa7\xa7",	//CYRILLIC CAPITAL LETTER IO
		"\xd0\x96"		=> "\xa7\xa8",	//CYRILLIC CAPITAL LETTER ZHE
		"\xd0\x97"		=> "\xa7\xa9",	//CYRILLIC CAPITAL LETTER ZE
		"\xd0\x98"		=> "\xa7\xaa",	//CYRILLIC CAPITAL LETTER I
		"\xd0\x99"		=> "\xa7\xab",	//CYRILLIC CAPITAL LETTER SHORT I
		"\xd0\x9a"		=> "\xa7\xac",	//CYRILLIC CAPITAL LETTER KA
		"\xd0\x9b"		=> "\xa7\xad",	//CYRILLIC CAPITAL LETTER EL
		"\xd0\x9c"		=> "\xa7\xae",	//CYRILLIC CAPITAL LETTER EM
		"\xd0\x9d"		=> "\xa7\xaf",	//CYRILLIC CAPITAL LETTER EN
		"\xd0\x9e"		=> "\xa7\xb0",	//CYRILLIC CAPITAL LETTER O
		"\xd0\x9f"		=> "\xa7\xb1",	//CYRILLIC CAPITAL LETTER PE
		"\xd0\xa0"		=> "\xa7\xb2",	//CYRILLIC CAPITAL LETTER ER
		"\xd0\xa1"		=> "\xa7\xb3",	//CYRILLIC CAPITAL LETTER ES
		"\xd0\xa2"		=> "\xa7\xb4",	//CYRILLIC CAPITAL LETTER TE
		"\xd0\xa3"		=> "\xa7\xb5",	//CYRILLIC CAPITAL LETTER U
		"\xd0\xa4"		=> "\xa7\xb6",	//CYRILLIC CAPITAL LETTER EF
		"\xd0\xa5"		=> "\xa7\xb7",	//CYRILLIC CAPITAL LETTER HA
		"\xd0\xa6"		=> "\xa7\xb8",	//CYRILLIC CAPITAL LETTER TSE
		"\xd0\xa7"		=> "\xa7\xb9",	//CYRILLIC CAPITAL LETTER CHE
		"\xd0\xa8"		=> "\xa7\xba",	//CYRILLIC CAPITAL LETTER SHA
		"\xd0\xa9"		=> "\xa7\xbb",	//CYRILLIC CAPITAL LETTER SHCHA
		"\xd0\xaa"		=> "\xa7\xbc",	//CYRILLIC CAPITAL LETTER HARD SIGN
		"\xd0\xab"		=> "\xa7\xbd",	//CYRILLIC CAPITAL LETTER YERU
		"\xd0\xac"		=> "\xa7\xbe",	//CYRILLIC CAPITAL LETTER SOFT SIGN
		"\xd0\xad"		=> "\xa7\xbf",	//CYRILLIC CAPITAL LETTER E
		"\xd0\xae"		=> "\xa7\xc0",	//CYRILLIC CAPITAL LETTER YU
		"\xd0\xaf"		=> "\xa7\xc1",	//CYRILLIC CAPITAL LETTER YA
		"\xd0\xb0"		=> "\xa7\xd1",	//CYRILLIC SMALL LETTER A
		"\xd0\xb1"		=> "\xa7\xd2",	//CYRILLIC SMALL LETTER BE
		"\xd0\xb2"		=> "\xa7\xd3",	//CYRILLIC SMALL LETTER VE
		"\xd0\xb3"		=> "\xa7\xd4",	//CYRILLIC SMALL LETTER GHE
		"\xd0\xb4"		=> "\xa7\xd5",	//CYRILLIC SMALL LETTER DE
		"\xd0\xb5"		=> "\xa7\xd6",	//CYRILLIC SMALL LETTER IE
		"\xd1\x91"		=> "\xa7\xd7",	//CYRILLIC SMALL LETTER IO
		"\xd0\xb6"		=> "\xa7\xd8",	//CYRILLIC SMALL LETTER ZHE
		"\xd0\xb7"		=> "\xa7\xd9",	//CYRILLIC SMALL LETTER ZE
		"\xd0\xb8"		=> "\xa7\xda",	//CYRILLIC SMALL LETTER I
		"\xd0\xb9"		=> "\xa7\xdb",	//CYRILLIC SMALL LETTER SHORT I
		"\xd0\xba"		=> "\xa7\xdc",	//CYRILLIC SMALL LETTER KA
		"\xd0\xbb"		=> "\xa7\xdd",	//CYRILLIC SMALL LETTER EL
		"\xd0\xbc"		=> "\xa7\xde",	//CYRILLIC SMALL LETTER EM
		"\xd0\xbd"		=> "\xa7\xdf",	//CYRILLIC SMALL LETTER EN
		"\xd0\xbe"		=> "\xa7\xe0",	//CYRILLIC SMALL LETTER O
		"\xd0\xbf"		=> "\xa7\xe1",	//CYRILLIC SMALL LETTER PE
		"\xd1\x80"		=> "\xa7\xe2",	//CYRILLIC SMALL LETTER ER
		"\xd1\x81"		=> "\xa7\xe3",	//CYRILLIC SMALL LETTER ES
		"\xd1\x82"		=> "\xa7\xe4",	//CYRILLIC SMALL LETTER TE
		"\xd1\x83"		=> "\xa7\xe5",	//CYRILLIC SMALL LETTER U
		"\xd1\x84"		=> "\xa7\xe6",	//CYRILLIC SMALL LETTER EF
		"\xd1\x85"		=> "\xa7\xe7",	//CYRILLIC SMALL LETTER HA
		"\xd1\x86"		=> "\xa7\xe8",	//CYRILLIC SMALL LETTER TSE
		"\xd1\x87"		=> "\xa7\xe9",	//CYRILLIC SMALL LETTER CHE
		"\xd1\x88"		=> "\xa7\xea",	//CYRILLIC SMALL LETTER SHA
		"\xd1\x89"		=> "\xa7\xeb",	//CYRILLIC SMALL LETTER SHCHA
		"\xd1\x8a"		=> "\xa7\xec",	//CYRILLIC SMALL LETTER HARD SIGN
		"\xd1\x8b"		=> "\xa7\xed",	//CYRILLIC SMALL LETTER YERU
		"\xd1\x8c"		=> "\xa7\xee",	//CYRILLIC SMALL LETTER SOFT SIGN
		"\xd1\x8d"		=> "\xa7\xef",	//CYRILLIC SMALL LETTER E
		"\xd1\x8e"		=> "\xa7\xf0",	//CYRILLIC SMALL LETTER YU
		"\xd1\x8f"		=> "\xa7\xf1",	//CYRILLIC SMALL LETTER YA
		"\xcb\x8a"		=> "\xa8\x40",	//MODIFIER LETTER ACUTE ACCENT
		"\xcb\x8b"		=> "\xa8\x41",	//MODIFIER LETTER GRAVE ACCENT
		"\xcb\x99"		=> "\xa8\x42",	//DOT ABOVE
		"\xe2\x80\x93"		=> "\xa8\x43",	//EN DASH
		"\xe2\x80\x95"		=> "\xa8\x44",	//HORIZONTAL BAR
		"\xe2\x80\xa5"		=> "\xa8\x45",	//TWO DOT LEADER
		"\xe2\x80\xb5"		=> "\xa8\x46",	//REVERSED PRIME
		"\xe2\x84\x85"		=> "\xa8\x47",	//CARE OF
		"\xe2\x84\x89"		=> "\xa8\x48",	//DEGREE FAHRENHEIT
		"\xe2\x86\x96"		=> "\xa8\x49",	//NORTH WEST ARROW
		"\xe2\x86\x97"		=> "\xa8\x4a",	//NORTH EAST ARROW
		"\xe2\x86\x98"		=> "\xa8\x4b",	//SOUTH EAST ARROW
		"\xe2\x86\x99"		=> "\xa8\x4c",	//SOUTH WEST ARROW
		"\xe2\x88\x95"		=> "\xa8\x4d",	//DIVISION SLASH
		"\xe2\x88\x9f"		=> "\xa8\x4e",	//RIGHT ANGLE
		"\xe2\x88\xa3"		=> "\xa8\x4f",	//DIVIDES
		"\xe2\x89\x92"		=> "\xa8\x50",	//APPROXIMATELY EQUAL TO OR THE IMAGE OF
		"\xe2\x89\xa6"		=> "\xa8\x51",	//LESS-THAN OVER EQUAL TO
		"\xe2\x89\xa7"		=> "\xa8\x52",	//GREATER-THAN OVER EQUAL TO
		"\xe2\x8a\xbf"		=> "\xa8\x53",	//RIGHT TRIANGLE
		"\xe2\x95\x90"		=> "\xa8\x54",	//BOX DRAWINGS DOUBLE HORIZONTAL
		"\xe2\x95\x91"		=> "\xa8\x55",	//BOX DRAWINGS DOUBLE VERTICAL
		"\xe2\x95\x92"		=> "\xa8\x56",	//BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
		"\xe2\x95\x93"		=> "\xa8\x57",	//BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
		"\xe2\x95\x94"		=> "\xa8\x58",	//BOX DRAWINGS DOUBLE DOWN AND RIGHT
		"\xe2\x95\x95"		=> "\xa8\x59",	//BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
		"\xe2\x95\x96"		=> "\xa8\x5a",	//BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
		"\xe2\x95\x97"		=> "\xa8\x5b",	//BOX DRAWINGS DOUBLE DOWN AND LEFT
		"\xe2\x95\x98"		=> "\xa8\x5c",	//BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
		"\xe2\x95\x99"		=> "\xa8\x5d",	//BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
		"\xe2\x95\x9a"		=> "\xa8\x5e",	//BOX DRAWINGS DOUBLE UP AND RIGHT
		"\xe2\x95\x9b"		=> "\xa8\x5f",	//BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
		"\xe2\x95\x9c"		=> "\xa8\x60",	//BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
		"\xe2\x95\x9d"		=> "\xa8\x61",	//BOX DRAWINGS DOUBLE UP AND LEFT
		"\xe2\x95\x9e"		=> "\xa8\x62",	//BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
		"\xe2\x95\x9f"		=> "\xa8\x63",	//BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
		"\xe2\x95\xa0"		=> "\xa8\x64",	//BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
		"\xe2\x95\xa1"		=> "\xa8\x65",	//BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
		"\xe2\x95\xa2"		=> "\xa8\x66",	//BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
		"\xe2\x95\xa3"		=> "\xa8\x67",	//BOX DRAWINGS DOUBLE VERTICAL AND LEFT
		"\xe2\x95\xa4"		=> "\xa8\x68",	//BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
		"\xe2\x95\xa5"		=> "\xa8\x69",	//BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
		"\xe2\x95\xa6"		=> "\xa8\x6a",	//BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
		"\xe2\x95\xa7"		=> "\xa8\x6b",	//BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
		"\xe2\x95\xa8"		=> "\xa8\x6c",	//BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
		"\xe2\x95\xa9"		=> "\xa8\x6d",	//BOX DRAWINGS DOUBLE UP AND HORIZONTAL
		"\xe2\x95\xaa"		=> "\xa8\x6e",	//BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
		"\xe2\x95\xab"		=> "\xa8\x6f",	//BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
		"\xe2\x95\xac"		=> "\xa8\x70",	//BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
		"\xe2\x95\xad"		=> "\xa8\x71",	//BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
		"\xe2\x95\xae"		=> "\xa8\x72",	//BOX DRAWINGS LIGHT ARC DOWN AND LEFT
		"\xe2\x95\xaf"		=> "\xa8\x73",	//BOX DRAWINGS LIGHT ARC UP AND LEFT
		"\xe2\x95\xb0"		=> "\xa8\x74",	//BOX DRAWINGS LIGHT ARC UP AND RIGHT
		"\xe2\x95\xb1"		=> "\xa8\x75",	//BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
		"\xe2\x95\xb2"		=> "\xa8\x76",	//BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
		"\xe2\x95\xb3"		=> "\xa8\x77",	//BOX DRAWINGS LIGHT DIAGONAL CROSS
		"\xe2\x96\x81"		=> "\xa8\x78",	//LOWER ONE EIGHTH BLOCK
		"\xe2\x96\x82"		=> "\xa8\x79",	//LOWER ONE QUARTER BLOCK
		"\xe2\x96\x83"		=> "\xa8\x7a",	//LOWER THREE EIGHTHS BLOCK
		"\xe2\x96\x84"		=> "\xa8\x7b",	//LOWER HALF BLOCK
		"\xe2\x96\x85"		=> "\xa8\x7c",	//LOWER FIVE EIGHTHS BLOCK
		"\xe2\x96\x86"		=> "\xa8\x7d",	//LOWER THREE QUARTERS BLOCK
		"\xe2\x96\x87"		=> "\xa8\x7e",	//LOWER SEVEN EIGHTHS BLOCK
		"\xe2\x96\x88"		=> "\xa8\x80",	//FULL BLOCK
		"\xe2\x96\x89"		=> "\xa8\x81",	//LEFT SEVEN EIGHTHS BLOCK
		"\xe2\x96\x8a"		=> "\xa8\x82",	//LEFT THREE QUARTERS BLOCK
		"\xe2\x96\x8b"		=> "\xa8\x83",	//LEFT FIVE EIGHTHS BLOCK
		"\xe2\x96\x8c"		=> "\xa8\x84",	//LEFT HALF BLOCK
		"\xe2\x96\x8d"		=> "\xa8\x85",	//LEFT THREE EIGHTHS BLOCK
		"\xe2\x96\x8e"		=> "\xa8\x86",	//LEFT ONE QUARTER BLOCK
		"\xe2\x96\x8f"		=> "\xa8\x87",	//LEFT ONE EIGHTH BLOCK
		"\xe2\x96\x93"		=> "\xa8\x88",	//DARK SHADE
		"\xe2\x96\x94"		=> "\xa8\x89",	//UPPER ONE EIGHTH BLOCK
		"\xe2\x96\x95"		=> "\xa8\x8a",	//RIGHT ONE EIGHTH BLOCK
		"\xe2\x96\xbc"		=> "\xa8\x8b",	//BLACK DOWN-POINTING TRIANGLE
		"\xe2\x96\xbd"		=> "\xa8\x8c",	//WHITE DOWN-POINTING TRIANGLE
		"\xe2\x97\xa2"		=> "\xa8\x8d",	//BLACK LOWER RIGHT TRIANGLE
		"\xe2\x97\xa3"		=> "\xa8\x8e",	//BLACK LOWER LEFT TRIANGLE
		"\xe2\x97\xa4"		=> "\xa8\x8f",	//BLACK UPPER LEFT TRIANGLE
		"\xe2\x97\xa5"		=> "\xa8\x90",	//BLACK UPPER RIGHT TRIANGLE
		"\xe2\x98\x89"		=> "\xa8\x91",	//SUN
		"\xe2\x8a\x95"		=> "\xa8\x92",	//CIRCLED PLUS
		"\xe3\x80\x92"		=> "\xa8\x93",	//POSTAL MARK
		"\xe3\x80\x9d"		=> "\xa8\x94",	//REVERSED DOUBLE PRIME QUOTATION MARK
		"\xe3\x80\x9e"		=> "\xa8\x95",	//DOUBLE PRIME QUOTATION MARK
		"\xc4\x81"		=> "\xa8\xa1",	//LATIN SMALL LETTER A WITH MACRON
		"\xc3\xa1"		=> "\xa8\xa2",	//LATIN SMALL LETTER A WITH ACUTE
		"\xc7\x8e"		=> "\xa8\xa3",	//LATIN SMALL LETTER A WITH CARON
		"\xc3\xa0"		=> "\xa8\xa4",	//LATIN SMALL LETTER A WITH GRAVE
		"\xc4\x93"		=> "\xa8\xa5",	//LATIN SMALL LETTER E WITH MACRON
		"\xc3\xa9"		=> "\xa8\xa6",	//LATIN SMALL LETTER E WITH ACUTE
		"\xc4\x9b"		=> "\xa8\xa7",	//LATIN SMALL LETTER E WITH CARON
		"\xc3\xa8"		=> "\xa8\xa8",	//LATIN SMALL LETTER E WITH GRAVE
		"\xc4\xab"		=> "\xa8\xa9",	//LATIN SMALL LETTER I WITH MACRON
		"\xc3\xad"		=> "\xa8\xaa",	//LATIN SMALL LETTER I WITH ACUTE
		"\xc7\x90"		=> "\xa8\xab",	//LATIN SMALL LETTER I WITH CARON
		"\xc3\xac"		=> "\xa8\xac",	//LATIN SMALL LETTER I WITH GRAVE
		"\xc5\x8d"		=> "\xa8\xad",	//LATIN SMALL LETTER O WITH MACRON
		"\xc3\xb3"		=> "\xa8\xae",	//LATIN SMALL LETTER O WITH ACUTE
		"\xc7\x92"		=> "\xa8\xaf",	//LATIN SMALL LETTER O WITH CARON
		"\xc3\xb2"		=> "\xa8\xb0",	//LATIN SMALL LETTER O WITH GRAVE
		"\xc5\xab"		=> "\xa8\xb1",	//LATIN SMALL LETTER U WITH MACRON
		"\xc3\xba"		=> "\xa8\xb2",	//LATIN SMALL LETTER U WITH ACUTE
		"\xc7\x94"		=> "\xa8\xb3",	//LATIN SMALL LETTER U WITH CARON
		"\xc3\xb9"		=> "\xa8\xb4",	//LATIN SMALL LETTER U WITH GRAVE
		"\xc7\x96"		=> "\xa8\xb5",	//LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
		"\xc7\x98"		=> "\xa8\xb6",	//LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
		"\xc7\x9a"		=> "\xa8\xb7",	//LATIN SMALL LETTER U WITH DIAERESIS AND CARON
		"\xc7\x9c"		=> "\xa8\xb8",	//LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
		"\xc3\xbc"		=> "\xa8\xb9",	//LATIN SMALL LETTER U WITH DIAERESIS
		"\xc3\xaa"		=> "\xa8\xba",	//LATIN SMALL LETTER E WITH CIRCUMFLEX
		"\xc9\x91"		=> "\xa8\xbb",	//LATIN SMALL LETTER ALPHA
		"\xc5\x84"		=> "\xa8\xbd",	//LATIN SMALL LETTER N WITH ACUTE
		"\xc5\x88"		=> "\xa8\xbe",	//LATIN SMALL LETTER N WITH CARON
		"\xc9\xa1"		=> "\xa8\xc0",	//LATIN SMALL LETTER SCRIPT G
		"\xe3\x84\x85"		=> "\xa8\xc5",	//BOPOMOFO LETTER B
		"\xe3\x84\x86"		=> "\xa8\xc6",	//BOPOMOFO LETTER P
		"\xe3\x84\x87"		=> "\xa8\xc7",	//BOPOMOFO LETTER M
		"\xe3\x84\x88"		=> "\xa8\xc8",	//BOPOMOFO LETTER F
		"\xe3\x84\x89"		=> "\xa8\xc9",	//BOPOMOFO LETTER D
		"\xe3\x84\x8a"		=> "\xa8\xca",	//BOPOMOFO LETTER T
		"\xe3\x84\x8b"		=> "\xa8\xcb",	//BOPOMOFO LETTER N
		"\xe3\x84\x8c"		=> "\xa8\xcc",	//BOPOMOFO LETTER L
		"\xe3\x84\x8d"		=> "\xa8\xcd",	//BOPOMOFO LETTER G
		"\xe3\x84\x8e"		=> "\xa8\xce",	//BOPOMOFO LETTER K
		"\xe3\x84\x8f"		=> "\xa8\xcf",	//BOPOMOFO LETTER H
		"\xe3\x84\x90"		=> "\xa8\xd0",	//BOPOMOFO LETTER J
		"\xe3\x84\x91"		=> "\xa8\xd1",	//BOPOMOFO LETTER Q
		"\xe3\x84\x92"		=> "\xa8\xd2",	//BOPOMOFO LETTER X
		"\xe3\x84\x93"		=> "\xa8\xd3",	//BOPOMOFO LETTER ZH
		"\xe3\x84\x94"		=> "\xa8\xd4",	//BOPOMOFO LETTER CH
		"\xe3\x84\x95"		=> "\xa8\xd5",	//BOPOMOFO LETTER SH
		"\xe3\x84\x96"		=> "\xa8\xd6",	//BOPOMOFO LETTER R
		"\xe3\x84\x97"		=> "\xa8\xd7",	//BOPOMOFO LETTER Z
		"\xe3\x84\x98"		=> "\xa8\xd8",	//BOPOMOFO LETTER C
		"\xe3\x84\x99"		=> "\xa8\xd9",	//BOPOMOFO LETTER S
		"\xe3\x84\x9a"		=> "\xa8\xda",	//BOPOMOFO LETTER A
		"\xe3\x84\x9b"		=> "\xa8\xdb",	//BOPOMOFO LETTER O
		"\xe3\x84\x9c"		=> "\xa8\xdc",	//BOPOMOFO LETTER E
		"\xe3\x84\x9d"		=> "\xa8\xdd",	//BOPOMOFO LETTER EH
		"\xe3\x84\x9e"		=> "\xa8\xde",	//BOPOMOFO LETTER AI
		"\xe3\x84\x9f"		=> "\xa8\xdf",	//BOPOMOFO LETTER EI
		"\xe3\x84\xa0"		=> "\xa8\xe0",	//BOPOMOFO LETTER AU
		"\xe3\x84\xa1"		=> "\xa8\xe1",	//BOPOMOFO LETTER OU
		"\xe3\x84\xa2"		=> "\xa8\xe2",	//BOPOMOFO LETTER AN
		"\xe3\x84\xa3"		=> "\xa8\xe3",	//BOPOMOFO LETTER EN
		"\xe3\x84\xa4"		=> "\xa8\xe4",	//BOPOMOFO LETTER ANG
		"\xe3\x84\xa5"		=> "\xa8\xe5",	//BOPOMOFO LETTER ENG
		"\xe3\x84\xa6"		=> "\xa8\xe6",	//BOPOMOFO LETTER ER
		"\xe3\x84\xa7"		=> "\xa8\xe7",	//BOPOMOFO LETTER I
		"\xe3\x84\xa8"		=> "\xa8\xe8",	//BOPOMOFO LETTER U
		"\xe3\x84\xa9"		=> "\xa8\xe9",	//BOPOMOFO LETTER IU
		"\xe3\x80\xa1"		=> "\xa9\x40",	//HANGZHOU NUMERAL ONE
		"\xe3\x80\xa2"		=> "\xa9\x41",	//HANGZHOU NUMERAL TWO
		"\xe3\x80\xa3"		=> "\xa9\x42",	//HANGZHOU NUMERAL THREE
		"\xe3\x80\xa4"		=> "\xa9\x43",	//HANGZHOU NUMERAL FOUR
		"\xe3\x80\xa5"		=> "\xa9\x44",	//HANGZHOU NUMERAL FIVE
		"\xe3\x80\xa6"		=> "\xa9\x45",	//HANGZHOU NUMERAL SIX
		"\xe3\x80\xa7"		=> "\xa9\x46",	//HANGZHOU NUMERAL SEVEN
		"\xe3\x80\xa8"		=> "\xa9\x47",	//HANGZHOU NUMERAL EIGHT
		"\xe3\x80\xa9"		=> "\xa9\x48",	//HANGZHOU NUMERAL NINE
		"\xe3\x8a\xa3"		=> "\xa9\x49",	//CIRCLED IDEOGRAPH CORRECT
		"\xe3\x8e\x8e"		=> "\xa9\x4a",	//SQUARE MG
		"\xe3\x8e\x8f"		=> "\xa9\x4b",	//SQUARE KG
		"\xe3\x8e\x9c"		=> "\xa9\x4c",	//SQUARE MM
		"\xe3\x8e\x9d"		=> "\xa9\x4d",	//SQUARE CM
		"\xe3\x8e\x9e"		=> "\xa9\x4e",	//SQUARE KM
		"\xe3\x8e\xa1"		=> "\xa9\x4f",	//SQUARE M SQUARED
		"\xe3\x8f\x84"		=> "\xa9\x50",	//SQUARE CC
		"\xe3\x8f\x8e"		=> "\xa9\x51",	//SQUARE KM CAPITAL
		"\xe3\x8f\x91"		=> "\xa9\x52",	//SQUARE LN
		"\xe3\x8f\x92"		=> "\xa9\x53",	//SQUARE LOG
		"\xe3\x8f\x95"		=> "\xa9\x54",	//SQUARE MIL
		"\xef\xb8\xb0"		=> "\xa9\x55",	//PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
		"\xef\xbf\xa2"		=> "\xa9\x56",	//FULLWIDTH NOT SIGN
		"\xef\xbf\xa4"		=> "\xa9\x57",	//FULLWIDTH BROKEN BAR
		"\xe2\x84\xa1"		=> "\xa9\x59",	//TELEPHONE SIGN
		"\xe3\x88\xb1"		=> "\xa9\x5a",	//PARENTHESIZED IDEOGRAPH STOCK
		"\xe2\x80\x90"		=> "\xa9\x5c",	//HYPHEN
		"\xe3\x83\xbc"		=> "\xa9\x60",	//KATAKANA-HIRAGANA PROLONGED SOUND MARK
		"\xe3\x82\x9b"		=> "\xa9\x61",	//KATAKANA-HIRAGANA VOICED SOUND MARK
		"\xe3\x82\x9c"		=> "\xa9\x62",	//KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
		"\xe3\x83\xbd"		=> "\xa9\x63",	//KATAKANA ITERATION MARK
		"\xe3\x83\xbe"		=> "\xa9\x64",	//KATAKANA VOICED ITERATION MARK
		"\xe3\x80\x86"		=> "\xa9\x65",	//IDEOGRAPHIC CLOSING MARK
		"\xe3\x82\x9d"		=> "\xa9\x66",	//HIRAGANA ITERATION MARK
		"\xe3\x82\x9e"		=> "\xa9\x67",	//HIRAGANA VOICED ITERATION MARK
		"\xef\xb9\x89"		=> "\xa9\x68",	//DASHED OVERLINE
		"\xef\xb9\x8a"		=> "\xa9\x69",	//CENTRELINE OVERLINE
		"\xef\xb9\x8b"		=> "\xa9\x6a",	//WAVY OVERLINE
		"\xef\xb9\x8c"		=> "\xa9\x6b",	//DOUBLE WAVY OVERLINE
		"\xef\xb9\x8d"		=> "\xa9\x6c",	//DASHED LOW LINE
		"\xef\xb9\x8e"		=> "\xa9\x6d",	//CENTRELINE LOW LINE
		"\xef\xb9\x8f"		=> "\xa9\x6e",	//WAVY LOW LINE
		"\xef\xb9\x90"		=> "\xa9\x6f",	//SMALL COMMA
		"\xef\xb9\x91"		=> "\xa9\x70",	//SMALL IDEOGRAPHIC COMMA
		"\xef\xb9\x92"		=> "\xa9\x71",	//SMALL FULL STOP
		"\xef\xb9\x94"		=> "\xa9\x72",	//SMALL SEMICOLON
		"\xef\xb9\x95"		=> "\xa9\x73",	//SMALL COLON
		"\xef\xb9\x96"		=> "\xa9\x74",	//SMALL QUESTION MARK
		"\xef\xb9\x97"		=> "\xa9\x75",	//SMALL EXCLAMATION MARK
		"\xef\xb9\x99"		=> "\xa9\x76",	//SMALL LEFT PARENTHESIS
		"\xef\xb9\x9a"		=> "\xa9\x77",	//SMALL RIGHT PARENTHESIS
		"\xef\xb9\x9b"		=> "\xa9\x78",	//SMALL LEFT CURLY BRACKET
		"\xef\xb9\x9c"		=> "\xa9\x79",	//SMALL RIGHT CURLY BRACKET
		"\xef\xb9\x9d"		=> "\xa9\x7a",	//SMALL LEFT TORTOISE SHELL BRACKET
		"\xef\xb9\x9e"		=> "\xa9\x7b",	//SMALL RIGHT TORTOISE SHELL BRACKET
		"\xef\xb9\x9f"		=> "\xa9\x7c",	//SMALL NUMBER SIGN
		"\xef\xb9\xa0"		=> "\xa9\x7d",	//SMALL AMPERSAND
		"\xef\xb9\xa1"		=> "\xa9\x7e",	//SMALL ASTERISK
		"\xef\xb9\xa2"		=> "\xa9\x80",	//SMALL PLUS SIGN
		"\xef\xb9\xa3"		=> "\xa9\x81",	//SMALL HYPHEN-MINUS
		"\xef\xb9\xa4"		=> "\xa9\x82",	//SMALL LESS-THAN SIGN
		"\xef\xb9\xa5"		=> "\xa9\x83",	//SMALL GREATER-THAN SIGN
		"\xef\xb9\xa6"		=> "\xa9\x84",	//SMALL EQUALS SIGN
		"\xef\xb9\xa8"		=> "\xa9\x85",	//SMALL REVERSE SOLIDUS
		"\xef\xb9\xa9"		=> "\xa9\x86",	//SMALL DOLLAR SIGN
		"\xef\xb9\xaa"		=> "\xa9\x87",	//SMALL PERCENT SIGN
		"\xef\xb9\xab"		=> "\xa9\x88",	//SMALL COMMERCIAL AT
		"\xe3\x80\x87"		=> "\xa9\x96",	//IDEOGRAPHIC NUMBER ZERO
		"\xe2\x94\x80"		=> "\xa9\xa4",	//BOX DRAWINGS LIGHT HORIZONTAL
		"\xe2\x94\x81"		=> "\xa9\xa5",	//BOX DRAWINGS HEAVY HORIZONTAL
		"\xe2\x94\x82"		=> "\xa9\xa6",	//BOX DRAWINGS LIGHT VERTICAL
		"\xe2\x94\x83"		=> "\xa9\xa7",	//BOX DRAWINGS HEAVY VERTICAL
		"\xe2\x94\x84"		=> "\xa9\xa8",	//BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
		"\xe2\x94\x85"		=> "\xa9\xa9",	//BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
		"\xe2\x94\x86"		=> "\xa9\xaa",	//BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
		"\xe2\x94\x87"		=> "\xa9\xab",	//BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
		"\xe2\x94\x88"		=> "\xa9\xac",	//BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
		"\xe2\x94\x89"		=> "\xa9\xad",	//BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
		"\xe2\x94\x8a"		=> "\xa9\xae",	//BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
		"\xe2\x94\x8b"		=> "\xa9\xaf",	//BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
		"\xe2\x94\x8c"		=> "\xa9\xb0",	//BOX DRAWINGS LIGHT DOWN AND RIGHT
		"\xe2\x94\x8d"		=> "\xa9\xb1",	//BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
		"\xe2\x94\x8e"		=> "\xa9\xb2",	//BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
		"\xe2\x94\x8f"		=> "\xa9\xb3",	//BOX DRAWINGS HEAVY DOWN AND RIGHT
		"\xe2\x94\x90"		=> "\xa9\xb4",	//BOX DRAWINGS LIGHT DOWN AND LEFT
		"\xe2\x94\x91"		=> "\xa9\xb5",	//BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
		"\xe2\x94\x92"		=> "\xa9\xb6",	//BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
		"\xe2\x94\x93"		=> "\xa9\xb7",	//BOX DRAWINGS HEAVY DOWN AND LEFT
		"\xe2\x94\x94"		=> "\xa9\xb8",	//BOX DRAWINGS LIGHT UP AND RIGHT
		"\xe2\x94\x95"		=> "\xa9\xb9",	//BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
		"\xe2\x94\x96"		=> "\xa9\xba",	//BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
		"\xe2\x94\x97"		=> "\xa9\xbb",	//BOX DRAWINGS HEAVY UP AND RIGHT
		"\xe2\x94\x98"		=> "\xa9\xbc",	//BOX DRAWINGS LIGHT UP AND LEFT
		"\xe2\x94\x99"		=> "\xa9\xbd",	//BOX DRAWINGS UP LIGHT AND LEFT HEAVY
		"\xe2\x94\x9a"		=> "\xa9\xbe",	//BOX DRAWINGS UP HEAVY AND LEFT LIGHT
		"\xe2\x94\x9b"		=> "\xa9\xbf",	//BOX DRAWINGS HEAVY UP AND LEFT
		"\xe2\x94\x9c"		=> "\xa9\xc0",	//BOX DRAWINGS LIGHT VERTICAL AND RIGHT
		"\xe2\x94\x9d"		=> "\xa9\xc1",	//BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
		"\xe2\x94\x9e"		=> "\xa9\xc2",	//BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
		"\xe2\x94\x9f"		=> "\xa9\xc3",	//BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
		"\xe2\x94\xa0"		=> "\xa9\xc4",	//BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
		"\xe2\x94\xa1"		=> "\xa9\xc5",	//BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
		"\xe2\x94\xa2"		=> "\xa9\xc6",	//BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
		"\xe2\x94\xa3"		=> "\xa9\xc7",	//BOX DRAWINGS HEAVY VERTICAL AND RIGHT
		"\xe2\x94\xa4"		=> "\xa9\xc8",	//BOX DRAWINGS LIGHT VERTICAL AND LEFT
		"\xe2\x94\xa5"		=> "\xa9\xc9",	//BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
		"\xe2\x94\xa6"		=> "\xa9\xca",	//BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
		"\xe2\x94\xa7"		=> "\xa9\xcb",	//BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
		"\xe2\x94\xa8"		=> "\xa9\xcc",	//BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
		"\xe2\x94\xa9"		=> "\xa9\xcd",	//BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
		"\xe2\x94\xaa"		=> "\xa9\xce",	//BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
		"\xe2\x94\xab"		=> "\xa9\xcf",	//BOX DRAWINGS HEAVY VERTICAL AND LEFT
		"\xe2\x94\xac"		=> "\xa9\xd0",	//BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
		"\xe2\x94\xad"		=> "\xa9\xd1",	//BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
		"\xe2\x94\xae"		=> "\xa9\xd2",	//BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
		"\xe2\x94\xaf"		=> "\xa9\xd3",	//BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
		"\xe2\x94\xb0"		=> "\xa9\xd4",	//BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
		"\xe2\x94\xb1"		=> "\xa9\xd5",	//BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
		"\xe2\x94\xb2"		=> "\xa9\xd6",	//BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
		"\xe2\x94\xb3"		=> "\xa9\xd7",	//BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
		"\xe2\x94\xb4"		=> "\xa9\xd8",	//BOX DRAWINGS LIGHT UP AND HORIZONTAL
		"\xe2\x94\xb5"		=> "\xa9\xd9",	//BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
		"\xe2\x94\xb6"		=> "\xa9\xda",	//BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
		"\xe2\x94\xb7"		=> "\xa9\xdb",	//BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
		"\xe2\x94\xb8"		=> "\xa9\xdc",	//BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
		"\xe2\x94\xb9"		=> "\xa9\xdd",	//BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
		"\xe2\x94\xba"		=> "\xa9\xde",	//BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
		"\xe2\x94\xbb"		=> "\xa9\xdf",	//BOX DRAWINGS HEAVY UP AND HORIZONTAL
		"\xe2\x94\xbc"		=> "\xa9\xe0",	//BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
		"\xe2\x94\xbd"		=> "\xa9\xe1",	//BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
		"\xe2\x94\xbe"		=> "\xa9\xe2",	//BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
		"\xe2\x94\xbf"		=> "\xa9\xe3",	//BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
		"\xe2\x95\x80"		=> "\xa9\xe4",	//BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
		"\xe2\x95\x81"		=> "\xa9\xe5",	//BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
		"\xe2\x95\x82"		=> "\xa9\xe6",	//BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
		"\xe2\x95\x83"		=> "\xa9\xe7",	//BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
		"\xe2\x95\x84"		=> "\xa9\xe8",	//BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
		"\xe2\x95\x85"		=> "\xa9\xe9",	//BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
		"\xe2\x95\x86"		=> "\xa9\xea",	//BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
		"\xe2\x95\x87"		=> "\xa9\xeb",	//BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
		"\xe2\x95\x88"		=> "\xa9\xec",	//BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
		"\xe2\x95\x89"		=> "\xa9\xed",	//BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
		"\xe2\x95\x8a"		=> "\xa9\xee",	//BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
		"\xe2\x95\x8b"		=> "\xa9\xef",	//BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
		"\xe7\x8b\x9c"		=> "\xaa\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x9d"		=> "\xaa\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x9f"		=> "\xaa\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa2"		=> "\xaa\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa3"		=> "\xaa\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa4"		=> "\xaa\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa5"		=> "\xaa\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa6"		=> "\xaa\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa7"		=> "\xaa\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xaa"		=> "\xaa\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xab"		=> "\xaa\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb5"		=> "\xaa\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb6"		=> "\xaa\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb9"		=> "\xaa\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xbd"		=> "\xaa\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xbe"		=> "\xaa\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xbf"		=> "\xaa\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x80"		=> "\xaa\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x82"		=> "\xaa\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x84"		=> "\xaa\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x85"		=> "\xaa\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x86"		=> "\xaa\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x87"		=> "\xaa\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x88"		=> "\xaa\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x89"		=> "\xaa\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x8b"		=> "\xaa\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x8c"		=> "\xaa\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x8d"		=> "\xaa\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x8f"		=> "\xaa\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x90"		=> "\xaa\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x91"		=> "\xaa\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x92"		=> "\xaa\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x94"		=> "\xaa\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x98"		=> "\xaa\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x99"		=> "\xaa\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x9a"		=> "\xaa\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x9f"		=> "\xaa\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa0"		=> "\xaa\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa3"		=> "\xaa\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa4"		=> "\xaa\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa6"		=> "\xaa\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa7"		=> "\xaa\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa8"		=> "\xaa\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xad"		=> "\xaa\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xaf"		=> "\xaa\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb0"		=> "\xaa\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb2"		=> "\xaa\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb3"		=> "\xaa\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb5"		=> "\xaa\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb6"		=> "\xaa\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xba"		=> "\xaa\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xbb"		=> "\xaa\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xbc"		=> "\xaa\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xbd"		=> "\xaa\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x80"		=> "\xaa\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x81"		=> "\xaa\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x82"		=> "\xaa\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x83"		=> "\xaa\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x84"		=> "\xaa\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x85"		=> "\xaa\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x86"		=> "\xaa\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x87"		=> "\xaa\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x88"		=> "\xaa\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x89"		=> "\xaa\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x8a"		=> "\xaa\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x8b"		=> "\xaa\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x8c"		=> "\xaa\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x8e"		=> "\xaa\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x8f"		=> "\xaa\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x91"		=> "\xaa\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x93"		=> "\xaa\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x94"		=> "\xaa\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x95"		=> "\xaa\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x96"		=> "\xaa\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x98"		=> "\xaa\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x99"		=> "\xaa\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x9a"		=> "\xaa\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x9b"		=> "\xaa\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x9c"		=> "\xaa\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x9d"		=> "\xaa\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x9e"		=> "\xaa\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x9f"		=> "\xaa\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa1"		=> "\xaa\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa2"		=> "\xaa\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa3"		=> "\xaa\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa4"		=> "\xaa\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa5"		=> "\xaa\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa6"		=> "\xaa\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa7"		=> "\xaa\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa8"		=> "\xaa\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa9"		=> "\xaa\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xaa"		=> "\xaa\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xab"		=> "\xaa\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xae"		=> "\xaa\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb0"		=> "\xaa\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb1"		=> "\xaa\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb2"		=> "\xab\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb3"		=> "\xab\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb4"		=> "\xab\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb5"		=> "\xab\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb6"		=> "\xab\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb7"		=> "\xab\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb8"		=> "\xab\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xb9"		=> "\xab\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xba"		=> "\xab\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xbb"		=> "\xab\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xbc"		=> "\xab\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xbd"		=> "\xab\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xbf"		=> "\xab\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x80"		=> "\xab\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x81"		=> "\xab\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x82"		=> "\xab\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x83"		=> "\xab\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x85"		=> "\xab\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x86"		=> "\xab\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x88"		=> "\xab\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x8a"		=> "\xab\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x8c"		=> "\xab\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x8d"		=> "\xab\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x8f"		=> "\xab\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x90"		=> "\xab\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x92"		=> "\xab\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x93"		=> "\xab\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x94"		=> "\xab\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x95"		=> "\xab\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x97"		=> "\xab\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x98"		=> "\xab\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x99"		=> "\xab\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x9a"		=> "\xab\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x9c"		=> "\xab\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x9d"		=> "\xab\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x9e"		=> "\xab\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa0"		=> "\xab\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa1"		=> "\xab\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa3"		=> "\xab\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa4"		=> "\xab\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa5"		=> "\xab\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa6"		=> "\xab\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa7"		=> "\xab\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa8"		=> "\xab\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xaa"		=> "\xab\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xac"		=> "\xab\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xad"		=> "\xab\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb1"		=> "\xab\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb4"		=> "\xab\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb5"		=> "\xab\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb6"		=> "\xab\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb8"		=> "\xab\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb9"		=> "\xab\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xbc"		=> "\xab\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xbd"		=> "\xab\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xbe"		=> "\xab\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xbf"		=> "\xab\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x81"		=> "\xab\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x83"		=> "\xab\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x84"		=> "\xab\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x85"		=> "\xab\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x86"		=> "\xab\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x87"		=> "\xab\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x8b"		=> "\xab\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x8c"		=> "\xab\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x8e"		=> "\xab\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x92"		=> "\xab\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x93"		=> "\xab\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x94"		=> "\xab\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x95"		=> "\xab\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x96"		=> "\xab\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x97"		=> "\xab\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x98"		=> "\xab\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x9a"		=> "\xab\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x9b"		=> "\xab\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x9c"		=> "\xab\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x9d"		=> "\xab\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x9f"		=> "\xab\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa1"		=> "\xab\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa2"		=> "\xab\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa3"		=> "\xab\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa4"		=> "\xab\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa6"		=> "\xab\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa8"		=> "\xab\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xaa"		=> "\xab\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xab"		=> "\xab\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xac"		=> "\xab\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xae"		=> "\xab\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xaf"		=> "\xab\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb0"		=> "\xab\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb1"		=> "\xab\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb3"		=> "\xab\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb4"		=> "\xab\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb5"		=> "\xab\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb6"		=> "\xab\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb7"		=> "\xab\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb8"		=> "\xac\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xb9"		=> "\xac\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xba"		=> "\xac\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xbb"		=> "\xac\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xbc"		=> "\xac\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xbd"		=> "\xac\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xbe"		=> "\xac\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xbf"		=> "\xac\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x80"		=> "\xac\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x81"		=> "\xac\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x82"		=> "\xac\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x84"		=> "\xac\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x87"		=> "\xac\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x88"		=> "\xac\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x8b"		=> "\xac\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x8c"		=> "\xac\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x8d"		=> "\xac\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x8e"		=> "\xac\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x91"		=> "\xac\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x92"		=> "\xac\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x93"		=> "\xac\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x94"		=> "\xac\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x95"		=> "\xac\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x96"		=> "\xac\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x97"		=> "\xac\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x98"		=> "\xac\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x99"		=> "\xac\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x9c"		=> "\xac\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x9d"		=> "\xac\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x9e"		=> "\xac\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x9f"		=> "\xac\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa0"		=> "\xac\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa1"		=> "\xac\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa3"		=> "\xac\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa4"		=> "\xac\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa7"		=> "\xac\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa9"		=> "\xac\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xab"		=> "\xac\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xad"		=> "\xac\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xaf"		=> "\xac\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb1"		=> "\xac\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb2"		=> "\xac\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb7"		=> "\xac\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb8"		=> "\xac\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb9"		=> "\xac\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xba"		=> "\xac\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xbb"		=> "\xac\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xbd"		=> "\xac\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xbe"		=> "\xac\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xbf"		=> "\xac\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x80"		=> "\xac\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x82"		=> "\xac\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x83"		=> "\xac\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x84"		=> "\xac\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x85"		=> "\xac\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x86"		=> "\xac\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x87"		=> "\xac\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x88"		=> "\xac\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x89"		=> "\xac\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x8a"		=> "\xac\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x8b"		=> "\xac\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x8c"		=> "\xac\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x8d"		=> "\xac\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x8e"		=> "\xac\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x8f"		=> "\xac\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x90"		=> "\xac\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x91"		=> "\xac\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x92"		=> "\xac\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x93"		=> "\xac\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x94"		=> "\xac\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x96"		=> "\xac\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x98"		=> "\xac\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x9d"		=> "\xac\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa0"		=> "\xac\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa1"		=> "\xac\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa2"		=> "\xac\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa3"		=> "\xac\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa4"		=> "\xac\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa5"		=> "\xac\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa6"		=> "\xac\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa7"		=> "\xac\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa8"		=> "\xac\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xa9"		=> "\xac\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xaa"		=> "\xac\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xab"		=> "\xac\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xac"		=> "\xac\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xae"		=> "\xac\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xaf"		=> "\xac\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb1"		=> "\xac\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb2"		=> "\xac\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb3"		=> "\xac\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb4"		=> "\xac\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb5"		=> "\xac\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb8"		=> "\xac\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb9"		=> "\xac\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xba"		=> "\xac\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xbb"		=> "\xad\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xbc"		=> "\xad\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xbd"		=> "\xad\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xbf"		=> "\xad\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x82"		=> "\xad\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x84"		=> "\xad\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x85"		=> "\xad\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x86"		=> "\xad\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x88"		=> "\xad\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x89"		=> "\xad\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x8a"		=> "\xad\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x8c"		=> "\xad\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x8d"		=> "\xad\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x8f"		=> "\xad\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x91"		=> "\xad\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x92"		=> "\xad\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x93"		=> "\xad\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x94"		=> "\xad\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x95"		=> "\xad\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x96"		=> "\xad\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x97"		=> "\xad\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x98"		=> "\xad\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x99"		=> "\xad\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x9a"		=> "\xad\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x9b"		=> "\xad\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x9d"		=> "\xad\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x9f"		=> "\xad\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa0"		=> "\xad\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa1"		=> "\xad\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa2"		=> "\xad\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa3"		=> "\xad\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa4"		=> "\xad\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa5"		=> "\xad\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xa6"		=> "\xad\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xaa"		=> "\xad\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xab"		=> "\xad\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xac"		=> "\xad\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xad"		=> "\xad\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xae"		=> "\xad\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xaf"		=> "\xad\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb0"		=> "\xad\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb1"		=> "\xad\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb2"		=> "\xad\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb3"		=> "\xad\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb4"		=> "\xad\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb5"		=> "\xad\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb6"		=> "\xad\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb7"		=> "\xad\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb8"		=> "\xad\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xb9"		=> "\xad\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xbb"		=> "\xad\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xbc"		=> "\xad\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xbd"		=> "\xad\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xbe"		=> "\xad\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\xbf"		=> "\xad\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x80"		=> "\xad\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x81"		=> "\xad\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x82"		=> "\xad\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x83"		=> "\xad\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x84"		=> "\xad\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x85"		=> "\xad\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x86"		=> "\xad\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x87"		=> "\xad\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x88"		=> "\xad\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x89"		=> "\xad\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x8a"		=> "\xad\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x8b"		=> "\xad\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x8c"		=> "\xad\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x8d"		=> "\xad\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x8e"		=> "\xad\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x8f"		=> "\xad\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x90"		=> "\xad\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x91"		=> "\xad\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x93"		=> "\xad\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x94"		=> "\xad\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x95"		=> "\xad\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x96"		=> "\xad\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x97"		=> "\xad\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x98"		=> "\xad\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x99"		=> "\xad\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x9a"		=> "\xad\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x9b"		=> "\xad\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x9d"		=> "\xad\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x9f"		=> "\xad\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa1"		=> "\xad\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa5"		=> "\xad\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa7"		=> "\xad\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa8"		=> "\xad\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa9"		=> "\xad\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xaa"		=> "\xad\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xab"		=> "\xad\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xac"		=> "\xad\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xad"		=> "\xad\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb0"		=> "\xad\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb1"		=> "\xad\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb2"		=> "\xad\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb3"		=> "\xae\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb5"		=> "\xae\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb8"		=> "\xae\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb9"		=> "\xae\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xba"		=> "\xae\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xbb"		=> "\xae\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xbc"		=> "\xae\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xbd"		=> "\xae\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xbe"		=> "\xae\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x80"		=> "\xae\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x81"		=> "\xae\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x82"		=> "\xae\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x83"		=> "\xae\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x85"		=> "\xae\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x86"		=> "\xae\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x87"		=> "\xae\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x88"		=> "\xae\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x89"		=> "\xae\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x8a"		=> "\xae\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x8b"		=> "\xae\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x8c"		=> "\xae\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x8e"		=> "\xae\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x90"		=> "\xae\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x92"		=> "\xae\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x94"		=> "\xae\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x95"		=> "\xae\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x96"		=> "\xae\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x97"		=> "\xae\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x9b"		=> "\xae\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x9d"		=> "\xae\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x9e"		=> "\xae\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa0"		=> "\xae\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa1"		=> "\xae\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa2"		=> "\xae\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa3"		=> "\xae\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa4"		=> "\xae\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa6"		=> "\xae\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa7"		=> "\xae\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xaa"		=> "\xae\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xae"		=> "\xae\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb4"		=> "\xae\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb6"		=> "\xae\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb9"		=> "\xae\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xbc"		=> "\xae\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xbd"		=> "\xae\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xbf"		=> "\xae\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x81"		=> "\xae\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x82"		=> "\xae\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x83"		=> "\xae\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x84"		=> "\xae\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x86"		=> "\xae\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x87"		=> "\xae\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x89"		=> "\xae\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x8a"		=> "\xae\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x8d"		=> "\xae\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x90"		=> "\xae\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x91"		=> "\xae\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x92"		=> "\xae\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x93"		=> "\xae\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x95"		=> "\xae\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x96"		=> "\xae\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x97"		=> "\xae\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x98"		=> "\xae\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x9d"		=> "\xae\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x9e"		=> "\xae\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x9f"		=> "\xae\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa0"		=> "\xae\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa1"		=> "\xae\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa2"		=> "\xae\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa3"		=> "\xae\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa4"		=> "\xae\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa7"		=> "\xae\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa8"		=> "\xae\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa9"		=> "\xae\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xab"		=> "\xae\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xac"		=> "\xae\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xad"		=> "\xae\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xae"		=> "\xae\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xaf"		=> "\xae\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb0"		=> "\xae\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb1"		=> "\xae\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb3"		=> "\xae\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb5"		=> "\xae\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb6"		=> "\xae\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb7"		=> "\xae\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xba"		=> "\xae\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xbb"		=> "\xae\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xbc"		=> "\xae\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xbd"		=> "\xae\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xbe"		=> "\xae\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x80"		=> "\xae\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x81"		=> "\xae\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x82"		=> "\xae\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x84"		=> "\xae\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x85"		=> "\xae\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x87"		=> "\xae\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x88"		=> "\xaf\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x89"		=> "\xaf\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x8a"		=> "\xaf\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x8c"		=> "\xaf\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x8d"		=> "\xaf\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x8e"		=> "\xaf\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x90"		=> "\xaf\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x93"		=> "\xaf\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x95"		=> "\xaf\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x98"		=> "\xaf\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x9b"		=> "\xaf\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x9c"		=> "\xaf\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x9e"		=> "\xaf\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa2"		=> "\xaf\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa6"		=> "\xaf\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa7"		=> "\xaf\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa8"		=> "\xaf\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa9"		=> "\xaf\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xaa"		=> "\xaf\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xad"		=> "\xaf\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xb6"		=> "\xaf\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xb7"		=> "\xaf\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xba"		=> "\xaf\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xbb"		=> "\xaf\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xbf"		=> "\xaf\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x80"		=> "\xaf\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x81"		=> "\xaf\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x86"		=> "\xaf\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x8b"		=> "\xaf\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x8c"		=> "\xaf\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x8e"		=> "\xaf\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x8f"		=> "\xaf\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x90"		=> "\xaf\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x91"		=> "\xaf\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x93"		=> "\xaf\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x97"		=> "\xaf\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x99"		=> "\xaf\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x9a"		=> "\xaf\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x9c"		=> "\xaf\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x9d"		=> "\xaf\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x9f"		=> "\xaf\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xa0"		=> "\xaf\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xa1"		=> "\xaf\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xa5"		=> "\xaf\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xa9"		=> "\xaf\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xac"		=> "\xaf\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xad"		=> "\xaf\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xae"		=> "\xaf\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xaf"		=> "\xaf\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb2"		=> "\xaf\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb3"		=> "\xaf\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb5"		=> "\xaf\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb6"		=> "\xaf\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb7"		=> "\xaf\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb8"		=> "\xaf\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xba"		=> "\xaf\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xbb"		=> "\xaf\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xbd"		=> "\xaf\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xbe"		=> "\xaf\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x82"		=> "\xaf\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x84"		=> "\xaf\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x86"		=> "\xaf\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x87"		=> "\xaf\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x88"		=> "\xaf\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x89"		=> "\xaf\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x8b"		=> "\xaf\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x8d"		=> "\xaf\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x8e"		=> "\xaf\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x8f"		=> "\xaf\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x91"		=> "\xaf\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x92"		=> "\xaf\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x93"		=> "\xaf\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x94"		=> "\xaf\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x96"		=> "\xaf\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x9a"		=> "\xaf\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x9c"		=> "\xaf\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x9d"		=> "\xaf\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x9e"		=> "\xaf\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa1"		=> "\xaf\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa3"		=> "\xaf\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa7"		=> "\xaf\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa8"		=> "\xaf\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xac"		=> "\xaf\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xae"		=> "\xaf\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xaf"		=> "\xaf\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb1"		=> "\xaf\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb2"		=> "\xaf\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb6"		=> "\xaf\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb7"		=> "\xaf\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb9"		=> "\xaf\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xba"		=> "\xaf\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xbb"		=> "\xaf\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xbd"		=> "\xaf\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x81"		=> "\xaf\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x82"		=> "\xaf\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x84"		=> "\xaf\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x85"		=> "\xb0\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x86"		=> "\xb0\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x87"		=> "\xb0\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x88"		=> "\xb0\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x89"		=> "\xb0\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x8a"		=> "\xb0\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x8b"		=> "\xb0\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x8e"		=> "\xb0\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x8f"		=> "\xb0\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x90"		=> "\xb0\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x91"		=> "\xb0\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x92"		=> "\xb0\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x93"		=> "\xb0\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x95"		=> "\xb0\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x97"		=> "\xb0\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x98"		=> "\xb0\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x99"		=> "\xb0\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x9a"		=> "\xb0\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x9b"		=> "\xb0\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x9d"		=> "\xb0\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x9f"		=> "\xb0\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa0"		=> "\xb0\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa1"		=> "\xb0\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa2"		=> "\xb0\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa4"		=> "\xb0\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa5"		=> "\xb0\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa6"		=> "\xb0\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa7"		=> "\xb0\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa8"		=> "\xb0\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa9"		=> "\xb0\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xaa"		=> "\xb0\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xac"		=> "\xb0\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xad"		=> "\xb0\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xae"		=> "\xb0\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb0"		=> "\xb0\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb1"		=> "\xb0\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb2"		=> "\xb0\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb3"		=> "\xb0\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb4"		=> "\xb0\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb5"		=> "\xb0\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb6"		=> "\xb0\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb7"		=> "\xb0\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb9"		=> "\xb0\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xba"		=> "\xb0\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xbc"		=> "\xb0\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xbf"		=> "\xb0\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x80"		=> "\xb0\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x81"		=> "\xb0\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x83"		=> "\xb0\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x85"		=> "\xb0\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x89"		=> "\xb0\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x8a"		=> "\xb0\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x8c"		=> "\xb0\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x8d"		=> "\xb0\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x8f"		=> "\xb0\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x90"		=> "\xb0\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x92"		=> "\xb0\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x94"		=> "\xb0\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x95"		=> "\xb0\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x97"		=> "\xb0\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x98"		=> "\xb0\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x9a"		=> "\xb0\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x9b"		=> "\xb0\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x9c"		=> "\xb0\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x9d"		=> "\xb0\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x9e"		=> "\xb0\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x9f"		=> "\xb0\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa0"		=> "\xb0\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa1"		=> "\xb0\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa2"		=> "\xb0\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa3"		=> "\xb0\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa5"		=> "\xb0\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa6"		=> "\xb0\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa7"		=> "\xb0\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa8"		=> "\xb0\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xa9"		=> "\xb0\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xaa"		=> "\xb0\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xab"		=> "\xb0\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xac"		=> "\xb0\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xad"		=> "\xb0\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xaf"		=> "\xb0\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb0"		=> "\xb0\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb3"		=> "\xb0\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb5"		=> "\xb0\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb6"		=> "\xb0\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb7"		=> "\xb0\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb8"		=> "\xb0\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb9"		=> "\xb0\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xba"		=> "\xb0\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xbb"		=> "\xb0\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xbc"		=> "\xb0\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xbd"		=> "\xb0\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xbe"		=> "\xb0\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x80"		=> "\xb0\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x81"		=> "\xb0\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x83"		=> "\xb0\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x8a"		=> "\xb0\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xbf"		=> "\xb0\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x83"		=> "\xb0\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa8"		=> "\xb0\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x8e"		=> "\xb0\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x89"		=> "\xb0\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x80"		=> "\xb0\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x91"		=> "\xb0\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\x8c"		=> "\xb0\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xbc"		=> "\xb0\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xae"		=> "\xb0\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xbe"		=> "\xb0\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x8d"		=> "\xb0\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb1"		=> "\xb0\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x98"		=> "\xb0\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9e\x8d"		=> "\xb0\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa8"		=> "\xb0\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x89"		=> "\xb0\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xba"		=> "\xb0\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x89"		=> "\xb0\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x97"		=> "\xb0\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb8"		=> "\xb0\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xba"		=> "\xb0\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x88"		=> "\xb0\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xae"		=> "\xb0\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x82"		=> "\xb0\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x8e"		=> "\xb0\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb9"		=> "\xb0\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x96"		=> "\xb0\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\xac"		=> "\xb0\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb1"		=> "\xb0\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x84"		=> "\xb0\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xb2"		=> "\xb0\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa5"		=> "\xb0\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x8a"		=> "\xb0\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xb3"		=> "\xb0\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xad"		=> "\xb0\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x8c"		=> "\xb0\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x92"		=> "\xb0\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xad"		=> "\xb0\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa7"		=> "\xb0\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x86"		=> "\xb0\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xab"		=> "\xb0\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa4"		=> "\xb0\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb4"		=> "\xb0\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x94"		=> "\xb0\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x8b"		=> "\xb0\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xb6"		=> "\xb0\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x8a"		=> "\xb0\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x99"		=> "\xb0\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x9d"		=> "\xb0\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\xb8"		=> "\xb0\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa2"		=> "\xb0\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb8"		=> "\xb0\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xbd"		=> "\xb0\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x8f"		=> "\xb0\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xbe"		=> "\xb0\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x86"		=> "\xb0\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb0"		=> "\xb0\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa5"		=> "\xb0\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x9c"		=> "\xb0\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x97"		=> "\xb0\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x91"		=> "\xb0\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xad"		=> "\xb0\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xac"		=> "\xb0\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb3"		=> "\xb0\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xac"		=> "\xb0\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x81"		=> "\xb0\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xbf"		=> "\xb0\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x88"		=> "\xb0\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xae"		=> "\xb0\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x8c"		=> "\xb0\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb4"		=> "\xb0\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa3"		=> "\xb0\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x8a"		=> "\xb0\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x9e"		=> "\xb0\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x8a"		=> "\xb0\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa6"		=> "\xb0\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xae"		=> "\xb0\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x86"		=> "\xb0\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x9c"		=> "\xb0\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x80"		=> "\xb0\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x91"		=> "\xb0\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x92"		=> "\xb0\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x85"		=> "\xb0\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x8c"		=> "\xb0\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x91"		=> "\xb0\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x8d"		=> "\xb0\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa4"		=> "\xb0\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x9e"		=> "\xb0\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x9e"		=> "\xb0\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x85"		=> "\xb0\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x92"		=> "\xb0\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa5"		=> "\xb0\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x84"		=> "\xb1\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x87"		=> "\xb1\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x89"		=> "\xb1\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x8b"		=> "\xb1\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x8c"		=> "\xb1\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x93"		=> "\xb1\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x95"		=> "\xb1\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x99"		=> "\xb1\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x9a"		=> "\xb1\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x9c"		=> "\xb1\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x9d"		=> "\xb1\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x9e"		=> "\xb1\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa0"		=> "\xb1\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa1"		=> "\xb1\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa2"		=> "\xb1\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa3"		=> "\xb1\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa4"		=> "\xb1\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa6"		=> "\xb1\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa7"		=> "\xb1\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa8"		=> "\xb1\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xa9"		=> "\xb1\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xaa"		=> "\xb1\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xab"		=> "\xb1\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xac"		=> "\xb1\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xad"		=> "\xb1\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb0"		=> "\xb1\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb3"		=> "\xb1\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb5"		=> "\xb1\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb6"		=> "\xb1\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb7"		=> "\xb1\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xba"		=> "\xb1\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xbb"		=> "\xb1\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xbd"		=> "\xb1\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xbf"		=> "\xb1\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x80"		=> "\xb1\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x82"		=> "\xb1\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x83"		=> "\xb1\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x85"		=> "\xb1\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x86"		=> "\xb1\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x8a"		=> "\xb1\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x8c"		=> "\xb1\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x8e"		=> "\xb1\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x8f"		=> "\xb1\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x90"		=> "\xb1\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x91"		=> "\xb1\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x92"		=> "\xb1\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x93"		=> "\xb1\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x94"		=> "\xb1\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x95"		=> "\xb1\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x96"		=> "\xb1\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x97"		=> "\xb1\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x98"		=> "\xb1\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x9b"		=> "\xb1\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x9c"		=> "\xb1\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x9d"		=> "\xb1\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x9e"		=> "\xb1\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa1"		=> "\xb1\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa3"		=> "\xb1\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa4"		=> "\xb1\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa5"		=> "\xb1\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa7"		=> "\xb1\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xaa"		=> "\xb1\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xab"		=> "\xb1\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xac"		=> "\xb1\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xae"		=> "\xb1\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb0"		=> "\xb1\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb1"		=> "\xb1\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb2"		=> "\xb1\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb3"		=> "\xb1\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb4"		=> "\xb1\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb9"		=> "\xb1\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xbb"		=> "\xb1\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xbd"		=> "\xb1\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xbe"		=> "\xb1\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xbf"		=> "\xb1\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x82"		=> "\xb1\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x84"		=> "\xb1\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x85"		=> "\xb1\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x86"		=> "\xb1\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x88"		=> "\xb1\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x89"		=> "\xb1\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x8a"		=> "\xb1\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x8b"		=> "\xb1\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x8c"		=> "\xb1\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x8d"		=> "\xb1\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x8e"		=> "\xb1\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x8f"		=> "\xb1\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x92"		=> "\xb1\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x93"		=> "\xb1\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x94"		=> "\xb1\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x95"		=> "\xb1\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x96"		=> "\xb1\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x97"		=> "\xb1\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x98"		=> "\xb1\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x99"		=> "\xb1\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x9c"		=> "\xb1\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x84"		=> "\xb1\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\xb9"		=> "\xb1\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x9d"		=> "\xb1\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa1"		=> "\xb1\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb1"		=> "\xb1\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x9d"		=> "\xb1\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb1"		=> "\xb1\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa5"		=> "\xb1\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xb4"		=> "\xb1\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb9"		=> "\xb1\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb2\x8d"		=> "\xb1\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\x86"		=> "\xb1\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xaf"		=> "\xb1\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x91"		=> "\xb1\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb2"		=> "\xb1\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x91"		=> "\xb1\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x97"		=> "\xb1\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x88"		=> "\xb1\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x8c"		=> "\xb1\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x9d"		=> "\xb1\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa1"		=> "\xb1\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x8d"		=> "\xb1\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x88"		=> "\xb1\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x87"		=> "\xb1\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xab"		=> "\xb1\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x99"		=> "\xb1\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xab"		=> "\xb1\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x94"		=> "\xb1\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xaf"		=> "\xb1\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xac"		=> "\xb1\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa8"		=> "\xb1\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa9"		=> "\xb1\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb7"		=> "\xb1\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xad"		=> "\xb1\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb5"		=> "\xb1\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa6"		=> "\xb1\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb8"		=> "\xb1\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xbc"		=> "\xb1\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\xbb"		=> "\xb1\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x94"		=> "\xb1\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x99"		=> "\xb1\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x94"		=> "\xb1\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xbc"		=> "\xb1\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa7"		=> "\xb1\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x96"		=> "\xb1\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xbd"		=> "\xb1\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x95"		=> "\xb1\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x99"		=> "\xb1\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x96"		=> "\xb1\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x81"		=> "\xb1\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x87"		=> "\xb1\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb9"		=> "\xb1\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xad"		=> "\xb1\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x9d"		=> "\xb1\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x8a"		=> "\xb1\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x85"		=> "\xb1\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x9f"		=> "\xb1\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x81"		=> "\xb1\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x82"		=> "\xb1\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xbf"		=> "\xb1\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x9b"		=> "\xb1\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9e\xad"		=> "\xb1\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb9"		=> "\xb1\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x96"		=> "\xb1\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xac"		=> "\xb1\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x81"		=> "\xb1\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xbf"		=> "\xb1\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x98"		=> "\xb1\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x9e"		=> "\xb1\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa8"		=> "\xb1\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa9"		=> "\xb1\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xab"		=> "\xb1\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x8d"		=> "\xb1\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x87"		=> "\xb1\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xaa"		=> "\xb1\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x98"		=> "\xb1\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa8"		=> "\xb1\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb3\x96"		=> "\xb1\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x8b"		=> "\xb1\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xab"		=> "\xb1\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xaa"		=> "\xb1\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xac"		=> "\xb1\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x8c"		=> "\xb1\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x92"		=> "\xb1\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa8"		=> "\xb1\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xbe"		=> "\xb1\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x88"		=> "\xb1\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb5"		=> "\xb1\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb0"		=> "\xb1\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x84"		=> "\xb1\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x99"		=> "\xb1\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x89"		=> "\xb1\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xbc"		=> "\xb1\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb3"		=> "\xb1\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x9d"		=> "\xb2\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x9e"		=> "\xb2\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x9f"		=> "\xb2\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa0"		=> "\xb2\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa4"		=> "\xb2\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa7"		=> "\xb2\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa9"		=> "\xb2\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xaa"		=> "\xb2\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xad"		=> "\xb2\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xae"		=> "\xb2\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xaf"		=> "\xb2\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb0"		=> "\xb2\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb1"		=> "\xb2\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb2"		=> "\xb2\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb3"		=> "\xb2\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb4"		=> "\xb2\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb5"		=> "\xb2\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb6"		=> "\xb2\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb7"		=> "\xb2\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb8"		=> "\xb2\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xba"		=> "\xb2\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xbb"		=> "\xb2\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xbc"		=> "\xb2\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x81"		=> "\xb2\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x82"		=> "\xb2\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x83"		=> "\xb2\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x86"		=> "\xb2\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x87"		=> "\xb2\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x88"		=> "\xb2\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x89"		=> "\xb2\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x8a"		=> "\xb2\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x8b"		=> "\xb2\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x8f"		=> "\xb2\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x90"		=> "\xb2\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x93"		=> "\xb2\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x94"		=> "\xb2\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x95"		=> "\xb2\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x96"		=> "\xb2\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x97"		=> "\xb2\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x98"		=> "\xb2\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x99"		=> "\xb2\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x9a"		=> "\xb2\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x9b"		=> "\xb2\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x9c"		=> "\xb2\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x9d"		=> "\xb2\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x9e"		=> "\xb2\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa1"		=> "\xb2\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa3"		=> "\xb2\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa4"		=> "\xb2\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa6"		=> "\xb2\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa8"		=> "\xb2\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xab"		=> "\xb2\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xad"		=> "\xb2\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xae"		=> "\xb2\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xaf"		=> "\xb2\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb1"		=> "\xb2\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb2"		=> "\xb2\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb4"		=> "\xb2\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb6"		=> "\xb2\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb7"		=> "\xb2\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb8"		=> "\xb2\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb9"		=> "\xb2\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xba"		=> "\xb2\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xbc"		=> "\xb2\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xbe"		=> "\xb2\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x80"		=> "\xb2\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x81"		=> "\xb2\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x82"		=> "\xb2\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x83"		=> "\xb2\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x84"		=> "\xb2\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x85"		=> "\xb2\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x86"		=> "\xb2\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x87"		=> "\xb2\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x88"		=> "\xb2\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x89"		=> "\xb2\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x8a"		=> "\xb2\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x8b"		=> "\xb2\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x8c"		=> "\xb2\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x8e"		=> "\xb2\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x8f"		=> "\xb2\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x90"		=> "\xb2\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x91"		=> "\xb2\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x92"		=> "\xb2\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x93"		=> "\xb2\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x94"		=> "\xb2\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x95"		=> "\xb2\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x96"		=> "\xb2\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x98"		=> "\xb2\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x99"		=> "\xb2\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x9a"		=> "\xb2\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x9d"		=> "\xb2\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x9e"		=> "\xb2\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x9f"		=> "\xb2\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa0"		=> "\xb2\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa1"		=> "\xb2\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa4"		=> "\xb2\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x85"		=> "\xb2\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb6"		=> "\xb2\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xbb"		=> "\xb2\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa0"		=> "\xb2\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xad"		=> "\xb2\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa8"		=> "\xb2\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xb5"		=> "\xb2\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa2"		=> "\xb2\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x9a"		=> "\xb2\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x83"		=> "\xb2\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x8f"		=> "\xb2\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x82"		=> "\xb2\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x94"		=> "\xb2\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xaf"		=> "\xb2\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x9b"		=> "\xb2\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb6"		=> "\xb2\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x96"		=> "\xb2\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x8a"		=> "\xb2\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa4"		=> "\xb2\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x8a"		=> "\xb2\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xb3"		=> "\xb2\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x95"		=> "\xb2\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x9c"		=> "\xb2\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xba"		=> "\xb2\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa5"		=> "\xb2\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa0"		=> "\xb2\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x8d"		=> "\xb2\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x83"		=> "\xb2\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa5"		=> "\xb2\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xbf"		=> "\xb2\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa8"		=> "\xb2\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x96"		=> "\xb2\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa6"		=> "\xb2\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x9c"		=> "\xb2\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x81"		=> "\xb2\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x90"		=> "\xb2\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x8d"		=> "\xb2\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa2"		=> "\xb2\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xac"		=> "\xb2\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa9"		=> "\xb2\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x87"		=> "\xb2\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa9"		=> "\xb2\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x9c"		=> "\xb2\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa1"		=> "\xb2\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa4\x90"		=> "\xb2\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x82"		=> "\xb2\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x95"		=> "\xb2\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x8b"		=> "\xb2\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xad"		=> "\xb2\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa8"		=> "\xb2\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xbf"		=> "\xb2\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x8d"		=> "\xb2\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb1"		=> "\xb2\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x93"		=> "\xb2\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa7"		=> "\xb2\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x8f"		=> "\xb2\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x8d"		=> "\xb2\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x99"		=> "\xb2\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\xbd"		=> "\xb2\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb9"		=> "\xb2\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x89"		=> "\xb2\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x95"		=> "\xb2\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x96"		=> "\xb2\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa7"		=> "\xb2\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x8c"		=> "\xb2\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x8b"		=> "\xb2\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x82"		=> "\xb2\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xad"		=> "\xb2\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x92"		=> "\xb2\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x89"		=> "\xb2\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xac"		=> "\xb2\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb6"		=> "\xb2\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa5"		=> "\xb2\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb4"		=> "\xb2\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xbd"		=> "\xb2\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x9f"		=> "\xb2\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x94"		=> "\xb2\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xae"		=> "\xb2\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa7"		=> "\xb2\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x86"		=> "\xb2\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb4"		=> "\xb2\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xba"		=> "\xb2\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x80"		=> "\xb2\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xba"		=> "\xb2\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x89"		=> "\xb2\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x8b"		=> "\xb2\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x97"		=> "\xb2\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xa0"		=> "\xb2\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xb2"		=> "\xb2\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa7"		=> "\xb2\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x90"		=> "\xb2\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\xa4"		=> "\xb2\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x8c"		=> "\xb2\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x96"		=> "\xb2\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa6"		=> "\xb3\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa8"		=> "\xb3\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xaa"		=> "\xb3\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xaf"		=> "\xb3\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb0"		=> "\xb3\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb1"		=> "\xb3\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb2"		=> "\xb3\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb4"		=> "\xb3\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb5"		=> "\xb3\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb7"		=> "\xb3\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb9"		=> "\xb3\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xba"		=> "\xb3\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xbb"		=> "\xb3\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xbc"		=> "\xb3\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x83"		=> "\xb3\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x84"		=> "\xb3\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x85"		=> "\xb3\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x86"		=> "\xb3\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x87"		=> "\xb3\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x88"		=> "\xb3\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x8a"		=> "\xb3\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x8b"		=> "\xb3\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x8e"		=> "\xb3\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x8f"		=> "\xb3\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x90"		=> "\xb3\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x93"		=> "\xb3\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x95"		=> "\xb3\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x99"		=> "\xb3\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x9b"		=> "\xb3\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x9e"		=> "\xb3\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xa0"		=> "\xb3\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xa1"		=> "\xb3\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xa2"		=> "\xb3\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xa4"		=> "\xb3\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xa8"		=> "\xb3\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xaa"		=> "\xb3\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xab"		=> "\xb3\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xae"		=> "\xb3\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xaf"		=> "\xb3\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb1"		=> "\xb3\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb2"		=> "\xb3\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb3"		=> "\xb3\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb5"		=> "\xb3\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb6"		=> "\xb3\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xbd"		=> "\xb3\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xbf"		=> "\xb3\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x81"		=> "\xb3\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x82"		=> "\xb3\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x83"		=> "\xb3\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x84"		=> "\xb3\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x86"		=> "\xb3\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x88"		=> "\xb3\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x89"		=> "\xb3\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x8a"		=> "\xb3\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x8b"		=> "\xb3\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x8d"		=> "\xb3\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x8f"		=> "\xb3\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x91"		=> "\xb3\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x93"		=> "\xb3\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x94"		=> "\xb3\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x98"		=> "\xb3\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x99"		=> "\xb3\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x9a"		=> "\xb3\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x9b"		=> "\xb3\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x9c"		=> "\xb3\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x9e"		=> "\xb3\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x9f"		=> "\xb3\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa0"		=> "\xb3\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa1"		=> "\xb3\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa2"		=> "\xb3\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa3"		=> "\xb3\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa4"		=> "\xb3\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa5"		=> "\xb3\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa6"		=> "\xb3\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa7"		=> "\xb3\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa8"		=> "\xb3\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xa9"		=> "\xb3\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xaf"		=> "\xb3\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb0"		=> "\xb3\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb1"		=> "\xb3\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb2"		=> "\xb3\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb3"		=> "\xb3\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb4"		=> "\xb3\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb5"		=> "\xb3\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb6"		=> "\xb3\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb8"		=> "\xb3\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb9"		=> "\xb3\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xba"		=> "\xb3\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xbb"		=> "\xb3\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xbd"		=> "\xb3\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xbe"		=> "\xb3\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xbf"		=> "\xb3\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x80"		=> "\xb3\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x81"		=> "\xb3\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x82"		=> "\xb3\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x83"		=> "\xb3\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xba"		=> "\xb3\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x9d"		=> "\xb3\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb8"		=> "\xb3\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\xbf"		=> "\xb3\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xbf"		=> "\xb3\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa0"		=> "\xb3\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x82"		=> "\xb3\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x9e"		=> "\xb3\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x85"		=> "\xb3\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb1"		=> "\xb3\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa1"		=> "\xb3\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x85"		=> "\xb3\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x84"		=> "\xb3\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x9e"		=> "\xb3\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x9d"		=> "\xb3\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb2"		=> "\xb3\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xae"		=> "\xb3\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa2"		=> "\xb3\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb5"		=> "\xb3\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x92"		=> "\xb3\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa6"		=> "\xb3\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xaf"		=> "\xb3\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa4"		=> "\xb3\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa3"		=> "\xb3\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xbb"		=> "\xb3\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x88"		=> "\xb3\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb4"		=> "\xb3\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa3"		=> "\xb3\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb0"		=> "\xb3\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x98"		=> "\xb3\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa8"		=> "\xb3\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb1"		=> "\xb3\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x89"		=> "\xb3\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x88"		=> "\xb3\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x81"		=> "\xb3\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xac"		=> "\xb3\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x91"		=> "\xb3\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb0"		=> "\xb3\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x8e"		=> "\xb3\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x99"		=> "\xb3\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x90"		=> "\xb3\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x88"		=> "\xb3\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x98"		=> "\xb3\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x8b"		=> "\xb3\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa9"		=> "\xb3\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x84"		=> "\xb3\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x9a"		=> "\xb3\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xbf"		=> "\xb3\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x9e"		=> "\xb3\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x8b"		=> "\xb3\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa4"		=> "\xb3\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x83"		=> "\xb3\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb4"		=> "\xb3\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x81"		=> "\xb3\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x99"		=> "\xb3\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa0"		=> "\xb3\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x9f"		=> "\xb3\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x9b"		=> "\xb3\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xb0"		=> "\xb3\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xbb"		=> "\xb3\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbd\xbf"		=> "\xb3\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x88"		=> "\xb3\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xba"		=> "\xb3\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa4"		=> "\xb3\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x85"		=> "\xb3\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa5"		=> "\xb3\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xbd"		=> "\xb3\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x85"		=> "\xb3\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb2"		=> "\xb3\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xab"		=> "\xb3\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x87"		=> "\xb3\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa0"		=> "\xb3\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xbd"		=> "\xb3\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xac"		=> "\xb3\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb4"		=> "\xb3\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x8c"		=> "\xb3\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa0"		=> "\xb3\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x81"		=> "\xb3\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb9"		=> "\xb3\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x87"		=> "\xb3\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb8"		=> "\xb3\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x85"		=> "\xb3\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x91"		=> "\xb3\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xad"		=> "\xb3\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x9d"		=> "\xb3\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xba"		=> "\xb3\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xb1"		=> "\xb3\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa8"		=> "\xb3\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x87"		=> "\xb3\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x84"		=> "\xb3\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x8f"		=> "\xb3\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x81"		=> "\xb3\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xa4"		=> "\xb3\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x9a"		=> "\xb3\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x84"		=> "\xb4\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x85"		=> "\xb4\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x86"		=> "\xb4\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x88"		=> "\xb4\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x8a"		=> "\xb4\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x8b"		=> "\xb4\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x8f"		=> "\xb4\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x90"		=> "\xb4\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x92"		=> "\xb4\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x94"		=> "\xb4\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x95"		=> "\xb4\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x96"		=> "\xb4\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x99"		=> "\xb4\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x9d"		=> "\xb4\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x9e"		=> "\xb4\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa0"		=> "\xb4\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa2"		=> "\xb4\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa4"		=> "\xb4\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa6"		=> "\xb4\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa8"		=> "\xb4\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xa9"		=> "\xb4\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xaa"		=> "\xb4\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xab"		=> "\xb4\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xac"		=> "\xb4\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xad"		=> "\xb4\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xae"		=> "\xb4\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xaf"		=> "\xb4\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb5"		=> "\xb4\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb6"		=> "\xb4\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb7"		=> "\xb4\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb8"		=> "\xb4\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xba"		=> "\xb4\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xbb"		=> "\xb4\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xbc"		=> "\xb4\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xbd"		=> "\xb4\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xbf"		=> "\xb4\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x80"		=> "\xb4\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x82"		=> "\xb4\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x83"		=> "\xb4\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x84"		=> "\xb4\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x86"		=> "\xb4\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x87"		=> "\xb4\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x88"		=> "\xb4\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x8c"		=> "\xb4\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x8d"		=> "\xb4\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x8e"		=> "\xb4\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x8f"		=> "\xb4\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x91"		=> "\xb4\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x92"		=> "\xb4\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x93"		=> "\xb4\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x96"		=> "\xb4\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x97"		=> "\xb4\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x98"		=> "\xb4\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x9a"		=> "\xb4\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x9b"		=> "\xb4\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x9c"		=> "\xb4\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x9d"		=> "\xb4\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x9e"		=> "\xb4\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x9f"		=> "\xb4\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa0"		=> "\xb4\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa1"		=> "\xb4\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa2"		=> "\xb4\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa3"		=> "\xb4\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa4"		=> "\xb4\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa5"		=> "\xb4\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa6"		=> "\xb4\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa7"		=> "\xb4\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa9"		=> "\xb4\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xaa"		=> "\xb4\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xab"		=> "\xb4\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xad"		=> "\xb4\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xae"		=> "\xb4\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xaf"		=> "\xb4\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb0"		=> "\xb4\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb1"		=> "\xb4\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb3"		=> "\xb4\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb5"		=> "\xb4\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb6"		=> "\xb4\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb8"		=> "\xb4\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb9"		=> "\xb4\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xbb"		=> "\xb4\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xbc"		=> "\xb4\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xbd"		=> "\xb4\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xbe"		=> "\xb4\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xbf"		=> "\xb4\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x80"		=> "\xb4\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x82"		=> "\xb4\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x83"		=> "\xb4\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x84"		=> "\xb4\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x86"		=> "\xb4\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x87"		=> "\xb4\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x88"		=> "\xb4\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x89"		=> "\xb4\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x8a"		=> "\xb4\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x8b"		=> "\xb4\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x8c"		=> "\xb4\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x80"		=> "\xb4\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa8"		=> "\xb4\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x97"		=> "\xb4\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x90"		=> "\xb4\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa6"		=> "\xb4\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x84"		=> "\xb4\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa3"		=> "\xb4\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x9d"		=> "\xb4\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xbf"		=> "\xb4\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xbd"		=> "\xb4\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa0"		=> "\xb4\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb9"		=> "\xb4\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x98"		=> "\xb4\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb2"		=> "\xb4\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xae"		=> "\xb4\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x97"		=> "\xb4\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa2"		=> "\xb4\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x8a"		=> "\xb4\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xaf"		=> "\xb4\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x9b"		=> "\xb4\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb9"		=> "\xb4\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x8a"		=> "\xb4\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb6"		=> "\xb4\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xa4"		=> "\xb4\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x82"		=> "\xb4\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa5"		=> "\xb4\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xbf"		=> "\xb4\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x87"		=> "\xb4\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x87"		=> "\xb4\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb3"		=> "\xb4\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xaf"		=> "\xb4\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa2"		=> "\xb4\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb3"		=> "\xb4\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb0"		=> "\xb4\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xb5"		=> "\xb4\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa8"		=> "\xb4\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x81"		=> "\xb4\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x8c"		=> "\xb4\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x9e"		=> "\xb4\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x88"		=> "\xb4\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb7"		=> "\xb4\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x8d"		=> "\xb4\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa4"		=> "\xb4\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xba"		=> "\xb4\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x90"		=> "\xb4\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa1"		=> "\xb4\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xaa"		=> "\xb4\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb1"		=> "\xb4\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb1"		=> "\xb4\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x86"		=> "\xb4\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x8e"		=> "\xb4\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x9b"		=> "\xb4\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x91"		=> "\xb4\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x97"		=> "\xb4\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x8b"		=> "\xb4\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x87"		=> "\xb4\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x83"		=> "\xb4\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xbf"		=> "\xb4\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa1"		=> "\xb4\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x9c"		=> "\xb4\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa7"		=> "\xb4\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x94"		=> "\xb4\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xac"		=> "\xb4\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x86"		=> "\xb4\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x81"		=> "\xb4\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb9"		=> "\xb4\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xac"		=> "\xb4\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xa0"		=> "\xb4\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x91"		=> "\xb4\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x98"		=> "\xb4\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb8"		=> "\xb4\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x8b"		=> "\xb4\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xae"		=> "\xb4\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x93"		=> "\xb4\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xaa"		=> "\xb4\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xab"		=> "\xb4\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x99"		=> "\xb4\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xad"		=> "\xb4\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xbe"		=> "\xb4\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x94"		=> "\xb4\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa9"		=> "\xb4\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x93"		=> "\xb4\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa7"		=> "\xb4\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x86"		=> "\xb4\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xb9"		=> "\xb4\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa3"		=> "\xb4\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb4"		=> "\xb4\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa6"		=> "\xb4\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x86"		=> "\xb4\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa3"		=> "\xb4\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb7"		=> "\xb4\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x8b"		=> "\xb4\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x85"		=> "\xb4\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xae"		=> "\xb4\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x8d"		=> "\xb5\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x8e"		=> "\xb5\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x8f"		=> "\xb5\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x90"		=> "\xb5\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x91"		=> "\xb5\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x92"		=> "\xb5\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x94"		=> "\xb5\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x95"		=> "\xb5\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x96"		=> "\xb5\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x97"		=> "\xb5\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x98"		=> "\xb5\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x99"		=> "\xb5\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x9a"		=> "\xb5\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x9b"		=> "\xb5\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x9c"		=> "\xb5\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x9d"		=> "\xb5\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x9f"		=> "\xb5\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa0"		=> "\xb5\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa1"		=> "\xb5\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa2"		=> "\xb5\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa3"		=> "\xb5\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa5"		=> "\xb5\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa6"		=> "\xb5\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa7"		=> "\xb5\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa8"		=> "\xb5\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xa9"		=> "\xb5\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xaa"		=> "\xb5\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xab"		=> "\xb5\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xac"		=> "\xb5\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xad"		=> "\xb5\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xae"		=> "\xb5\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xaf"		=> "\xb5\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb0"		=> "\xb5\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb1"		=> "\xb5\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb2"		=> "\xb5\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb3"		=> "\xb5\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb5"		=> "\xb5\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb6"		=> "\xb5\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb7"		=> "\xb5\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb8"		=> "\xb5\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xb9"		=> "\xb5\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xbd"		=> "\xb5\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xbf"		=> "\xb5\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x82"		=> "\xb5\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x83"		=> "\xb5\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x84"		=> "\xb5\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x85"		=> "\xb5\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x87"		=> "\xb5\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x8a"		=> "\xb5\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x8b"		=> "\xb5\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x8c"		=> "\xb5\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x8d"		=> "\xb5\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x8e"		=> "\xb5\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x8f"		=> "\xb5\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x90"		=> "\xb5\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x91"		=> "\xb5\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x92"		=> "\xb5\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x94"		=> "\xb5\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x95"		=> "\xb5\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x98"		=> "\xb5\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x99"		=> "\xb5\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa1"		=> "\xb5\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa3"		=> "\xb5\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa4"		=> "\xb5\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa6"		=> "\xb5\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa9"		=> "\xb5\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xaa"		=> "\xb5\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xab"		=> "\xb5\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xac"		=> "\xb5\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xae"		=> "\xb5\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb0"		=> "\xb5\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb1"		=> "\xb5\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb2"		=> "\xb5\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb3"		=> "\xb5\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb4"		=> "\xb5\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb5"		=> "\xb5\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb6"		=> "\xb5\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb9"		=> "\xb5\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xbb"		=> "\xb5\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xbc"		=> "\xb5\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xbd"		=> "\xb5\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xbe"		=> "\xb5\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xbf"		=> "\xb5\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x82"		=> "\xb5\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x83"		=> "\xb5\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x86"		=> "\xb5\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x87"		=> "\xb5\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x88"		=> "\xb5\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x89"		=> "\xb5\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x8b"		=> "\xb5\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x8c"		=> "\xb5\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x8d"		=> "\xb5\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x8e"		=> "\xb5\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x90"		=> "\xb5\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x91"		=> "\xb5\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x92"		=> "\xb5\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa0"		=> "\xb5\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xbd"		=> "\xb5\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x85"		=> "\xb5\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb9"		=> "\xb5\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x95"		=> "\xb5\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb8"		=> "\xb5\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb8"		=> "\xb5\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x86"		=> "\xb5\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa6"		=> "\xb5\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xae"		=> "\xb5\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x86"		=> "\xb5\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xae"		=> "\xb5\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa1"		=> "\xb5\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x9e"		=> "\xb5\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb9"		=> "\xb5\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x8b"		=> "\xb5\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x93"		=> "\xb5\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa1"		=> "\xb5\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x9a"		=> "\xb5\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa1"		=> "\xb5\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xa3"		=> "\xb5\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x80"		=> "\xb5\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa3"		=> "\xb5\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x88"		=> "\xb5\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x92"		=> "\xb5\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x9b"		=> "\xb5\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb7"		=> "\xb5\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xbc"		=> "\xb5\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb0"		=> "\xb5\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xbb"		=> "\xb5\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xbc"		=> "\xb5\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x93"		=> "\xb5\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x97"		=> "\xb5\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb7"		=> "\xb5\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x97"		=> "\xb5\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x84"		=> "\xb5\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xac"		=> "\xb5\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xaf"		=> "\xb5\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xbb"		=> "\xb5\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x89"		=> "\xb5\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xaa"		=> "\xb5\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb3"		=> "\xb5\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x93"		=> "\xb5\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa4"		=> "\xb5\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x8e"		=> "\xb5\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xb4"		=> "\xb5\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xaa"		=> "\xb5\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x8c"		=> "\xb5\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x9b"		=> "\xb5\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x84"		=> "\xb5\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa4"		=> "\xb5\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x9f"		=> "\xb5\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa1"		=> "\xb5\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb5"		=> "\xb5\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x95"		=> "\xb5\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb0"		=> "\xb5\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x82"		=> "\xb5\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xac"		=> "\xb5\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x9d"		=> "\xb5\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x9f"		=> "\xb5\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x92"		=> "\xb5\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x94"		=> "\xb5\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\xa0"		=> "\xb5\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x82"		=> "\xb5\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x87"		=> "\xb5\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x98"		=> "\xb5\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb9"		=> "\xb5\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb8"		=> "\xb5\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\x9b"		=> "\xb5\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xab"		=> "\xb5\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb5"		=> "\xb5\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x83"		=> "\xb5\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb8"		=> "\xb5\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x97"		=> "\xb5\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa6"		=> "\xb5\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa0"		=> "\xb5\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x80"		=> "\xb5\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xbf"		=> "\xb5\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x89"		=> "\xb5\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xbc"		=> "\xb5\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x95"		=> "\xb5\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x8b"		=> "\xb5\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x81"		=> "\xb5\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x89"		=> "\xb5\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x8a"		=> "\xb5\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x93"		=> "\xb5\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x83"		=> "\xb5\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x8c"		=> "\xb5\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb9"		=> "\xb5\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x9f"		=> "\xb5\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb6"		=> "\xb5\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xad"		=> "\xb5\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x8d"		=> "\xb5\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa0"		=> "\xb5\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x93"		=> "\xb6\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x94"		=> "\xb6\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x95"		=> "\xb6\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x96"		=> "\xb6\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x97"		=> "\xb6\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x98"		=> "\xb6\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x99"		=> "\xb6\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x9b"		=> "\xb6\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x9c"		=> "\xb6\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x9d"		=> "\xb6\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x9e"		=> "\xb6\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x9f"		=> "\xb6\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa0"		=> "\xb6\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa1"		=> "\xb6\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa2"		=> "\xb6\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa3"		=> "\xb6\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa4"		=> "\xb6\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa5"		=> "\xb6\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa6"		=> "\xb6\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa8"		=> "\xb6\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xa9"		=> "\xb6\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xaa"		=> "\xb6\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xab"		=> "\xb6\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xac"		=> "\xb6\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xad"		=> "\xb6\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xae"		=> "\xb6\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xaf"		=> "\xb6\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb0"		=> "\xb6\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb1"		=> "\xb6\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb2"		=> "\xb6\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb4"		=> "\xb6\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb5"		=> "\xb6\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb6"		=> "\xb6\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb7"		=> "\xb6\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb8"		=> "\xb6\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xbc"		=> "\xb6\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xbf"		=> "\xb6\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x82"		=> "\xb6\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x84"		=> "\xb6\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x85"		=> "\xb6\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x87"		=> "\xb6\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x88"		=> "\xb6\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x8a"		=> "\xb6\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x8c"		=> "\xb6\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x8e"		=> "\xb6\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x8f"		=> "\xb6\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x90"		=> "\xb6\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x93"		=> "\xb6\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x94"		=> "\xb6\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x96"		=> "\xb6\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x97"		=> "\xb6\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x99"		=> "\xb6\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x9a"		=> "\xb6\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x9b"		=> "\xb6\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x9c"		=> "\xb6\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x9d"		=> "\xb6\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x9e"		=> "\xb6\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa0"		=> "\xb6\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa1"		=> "\xb6\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa2"		=> "\xb6\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa5"		=> "\xb6\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa8"		=> "\xb6\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xaa"		=> "\xb6\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xac"		=> "\xb6\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xae"		=> "\xb6\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb1"		=> "\xb6\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb2"		=> "\xb6\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb3"		=> "\xb6\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb4"		=> "\xb6\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb5"		=> "\xb6\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb6"		=> "\xb6\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb7"		=> "\xb6\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb9"		=> "\xb6\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xba"		=> "\xb6\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xbc"		=> "\xb6\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xbe"		=> "\xb6\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xbf"		=> "\xb6\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x81"		=> "\xb6\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x84"		=> "\xb6\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x85"		=> "\xb6\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x87"		=> "\xb6\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x88"		=> "\xb6\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x89"		=> "\xb6\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x8a"		=> "\xb6\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x8c"		=> "\xb6\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x8f"		=> "\xb6\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x90"		=> "\xb6\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x91"		=> "\xb6\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x92"		=> "\xb6\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x93"		=> "\xb6\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x95"		=> "\xb6\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x96"		=> "\xb6\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x98"		=> "\xb6\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x99"		=> "\xb6\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x9b"		=> "\xb6\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x9c"		=> "\xb6\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x81"		=> "\xb6\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xaf"		=> "\xb6\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xae"		=> "\xb6\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x89"		=> "\xb6\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xb6"		=> "\xb6\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\x8e"		=> "\xb6\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xad"		=> "\xb6\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x9a"		=> "\xb6\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa2"		=> "\xb6\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa2"		=> "\xb6\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x9c"		=> "\xb6\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xac"		=> "\xb6\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa3"		=> "\xb6\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x82"		=> "\xb6\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa8"		=> "\xb6\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x8b"		=> "\xb6\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x97"		=> "\xb6\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xab"		=> "\xb6\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xbb"		=> "\xb6\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x9e"		=> "\xb6\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x9c"		=> "\xb6\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x96"		=> "\xb6\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x97"		=> "\xb6\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xa1"		=> "\xb6\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x86"		=> "\xb6\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x97"		=> "\xb6\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x98"		=> "\xb6\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xbd"		=> "\xb6\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa3"		=> "\xb6\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x92"		=> "\xb6\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x8a"		=> "\xb6\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xac"		=> "\xb6\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xbb"		=> "\xb6\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb5"		=> "\xb6\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xb9"		=> "\xb6\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x8c"		=> "\xb6\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x9c"		=> "\xb6\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x80"		=> "\xb6\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x9a"		=> "\xb6\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa6"		=> "\xb6\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa1"		=> "\xb6\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x92"		=> "\xb6\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xaf"		=> "\xb6\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xad"		=> "\xb6\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xbb"		=> "\xb6\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb5"		=> "\xb6\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xad"		=> "\xb6\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x8e"		=> "\xb6\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x86"		=> "\xb6\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x91"		=> "\xb6\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x9f"		=> "\xb6\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xb9"		=> "\xb6\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa9"		=> "\xb6\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa8"		=> "\xb6\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb2"		=> "\xb6\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa6"		=> "\xb6\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xbf"		=> "\xb6\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa4"		=> "\xb6\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x9d"		=> "\xb6\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xbe"		=> "\xb6\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x81"		=> "\xb6\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x87"		=> "\xb6\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x86"		=> "\xb6\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x9a"		=> "\xb6\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xba"		=> "\xb6\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x9b"		=> "\xb6\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb2"		=> "\xb6\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb5"		=> "\xb6\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xba"		=> "\xb6\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb5"		=> "\xb6\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x81"		=> "\xb6\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb0"		=> "\xb6\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x95"		=> "\xb6\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xbe"		=> "\xb6\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa8"		=> "\xb6\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\x85"		=> "\xb6\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x84"		=> "\xb6\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x9d"		=> "\xb6\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb9"		=> "\xb6\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa5"		=> "\xb6\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb6"		=> "\xb6\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x84"		=> "\xb6\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xbc"		=> "\xb6\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x8f"		=> "\xb6\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x82"		=> "\xb6\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xbf"		=> "\xb6\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa9"		=> "\xb6\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x8c"		=> "\xb6\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xbf"		=> "\xb6\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb3"		=> "\xb6\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x94"		=> "\xb6\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb5"		=> "\xb6\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb1"		=> "\xb6\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x8c"		=> "\xb6\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x9d"		=> "\xb7\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x9f"		=> "\xb7\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa1"		=> "\xb7\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa2"		=> "\xb7\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa4"		=> "\xb7\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa5"		=> "\xb7\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa6"		=> "\xb7\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa7"		=> "\xb7\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa8"		=> "\xb7\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xa9"		=> "\xb7\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xaa"		=> "\xb7\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xab"		=> "\xb7\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xac"		=> "\xb7\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xad"		=> "\xb7\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xae"		=> "\xb7\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xaf"		=> "\xb7\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb0"		=> "\xb7\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb1"		=> "\xb7\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb2"		=> "\xb7\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb4"		=> "\xb7\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb5"		=> "\xb7\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb6"		=> "\xb7\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb8"		=> "\xb7\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xba"		=> "\xb7\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xbe"		=> "\xb7\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x80"		=> "\xb7\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x81"		=> "\xb7\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x82"		=> "\xb7\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x83"		=> "\xb7\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x84"		=> "\xb7\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x85"		=> "\xb7\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x87"		=> "\xb7\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x88"		=> "\xb7\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x89"		=> "\xb7\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x8a"		=> "\xb7\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x8b"		=> "\xb7\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x8c"		=> "\xb7\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x8d"		=> "\xb7\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x8e"		=> "\xb7\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x8f"		=> "\xb7\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x90"		=> "\xb7\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x92"		=> "\xb7\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x93"		=> "\xb7\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x94"		=> "\xb7\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x95"		=> "\xb7\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x96"		=> "\xb7\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x98"		=> "\xb7\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x99"		=> "\xb7\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x9a"		=> "\xb7\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x9b"		=> "\xb7\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x9c"		=> "\xb7\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x9d"		=> "\xb7\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x9e"		=> "\xb7\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x9f"		=> "\xb7\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa0"		=> "\xb7\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa1"		=> "\xb7\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa2"		=> "\xb7\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa3"		=> "\xb7\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa4"		=> "\xb7\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa5"		=> "\xb7\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa6"		=> "\xb7\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa7"		=> "\xb7\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa8"		=> "\xb7\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xa9"		=> "\xb7\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xaa"		=> "\xb7\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xab"		=> "\xb7\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xac"		=> "\xb7\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xad"		=> "\xb7\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xae"		=> "\xb7\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xaf"		=> "\xb7\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb1"		=> "\xb7\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb2"		=> "\xb7\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb3"		=> "\xb7\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb5"		=> "\xb7\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xbb"		=> "\xb7\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xbc"		=> "\xb7\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xbd"		=> "\xb7\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xbe"		=> "\xb7\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x82"		=> "\xb7\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x85"		=> "\xb7\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x87"		=> "\xb7\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x89"		=> "\xb7\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x8a"		=> "\xb7\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x8b"		=> "\xb7\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x8c"		=> "\xb7\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x8e"		=> "\xb7\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x8f"		=> "\xb7\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x90"		=> "\xb7\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x93"		=> "\xb7\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x94"		=> "\xb7\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x99"		=> "\xb7\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x9a"		=> "\xb7\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x9b"		=> "\xb7\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x9e"		=> "\xb7\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa1"		=> "\xb7\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa2"		=> "\xb7\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb0"		=> "\xb7\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x91"		=> "\xb7\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x9a"		=> "\xb7\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x8f"		=> "\xb7\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x90"		=> "\xb7\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x8f"		=> "\xb7\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x80"		=> "\xb7\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x95"		=> "\xb7\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x90"		=> "\xb7\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa9"		=> "\xb7\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x86"		=> "\xb7\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xaa"		=> "\xb7\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xbb"		=> "\xb7\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x8a"		=> "\xb7\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xbe"		=> "\xb7\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x92"		=> "\xb7\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x81"		=> "\xb7\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa1"		=> "\xb7\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa6"		=> "\xb7\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x8d"		=> "\xb7\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x94"		=> "\xb7\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x83"		=> "\xb7\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa9"		=> "\xb7\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xaf"		=> "\xb7\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xad"		=> "\xb7\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x9b"		=> "\xb7\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x8a"		=> "\xb7\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb3"		=> "\xb7\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb9"		=> "\xb7\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xaa"		=> "\xb7\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xbf"		=> "\xb7\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xb2"		=> "\xb7\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa8"		=> "\xb7\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xbf"		=> "\xb7\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xbf"		=> "\xb7\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xba"		=> "\xb7\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xbe"		=> "\xb7\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb2"		=> "\xb7\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\x9e"		=> "\xb7\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa1"		=> "\xb7\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa3\x9e"		=> "\xb7\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa5"		=> "\xb7\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xaa"		=> "\xb7\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xbd"		=> "\xb7\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa0"		=> "\xb7\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xba"		=> "\xb7\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x9f"		=> "\xb7\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb8"		=> "\xb7\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb9"		=> "\xb7\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xac"		=> "\xb7\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x9a"		=> "\xb7\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa9"		=> "\xb7\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x9b"		=> "\xb7\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x86"		=> "\xb7\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb7"		=> "\xb7\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x9f"		=> "\xb7\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x9a"		=> "\xb7\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xbe"		=> "\xb7\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x89"		=> "\xb7\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x8b"		=> "\xb7\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xbd"		=> "\xb7\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xbf"		=> "\xb7\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa4"		=> "\xb7\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xaa"		=> "\xb7\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb0"		=> "\xb7\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x81"		=> "\xb7\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xab"		=> "\xb7\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x82"		=> "\xb7\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xb0"		=> "\xb7\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x8b"		=> "\xb7\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa3\x8e"		=> "\xb7\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xaf"		=> "\xb7\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xbd"		=> "\xb7\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa2"		=> "\xb7\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xaf"		=> "\xb7\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x9d"		=> "\xb7\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xbd"		=> "\xb7\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x89"		=> "\xb7\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa4"		=> "\xb7\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x9b"		=> "\xb7\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa6"		=> "\xb7\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xab"		=> "\xb7\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb7"		=> "\xb7\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa4"		=> "\xb7\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb5"		=> "\xb7\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb6"		=> "\xb7\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x82"		=> "\xb7\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x90"		=> "\xb7\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x85"		=> "\xb7\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x9f"		=> "\xb7\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa6"		=> "\xb7\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x8f"		=> "\xb7\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x98"		=> "\xb7\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x8d"		=> "\xb7\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa3"		=> "\xb8\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa4"		=> "\xb8\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa7"		=> "\xb8\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa9"		=> "\xb8\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xaa"		=> "\xb8\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xab"		=> "\xb8\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xae"		=> "\xb8\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xaf"		=> "\xb8\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb0"		=> "\xb8\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb1"		=> "\xb8\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb2"		=> "\xb8\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb4"		=> "\xb8\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb5"		=> "\xb8\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb6"		=> "\xb8\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb7"		=> "\xb8\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb8"		=> "\xb8\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xb9"		=> "\xb8\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xba"		=> "\xb8\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xbb"		=> "\xb8\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xbc"		=> "\xb8\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xbd"		=> "\xb8\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xbe"		=> "\xb8\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x80"		=> "\xb8\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x81"		=> "\xb8\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x82"		=> "\xb8\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x83"		=> "\xb8\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x84"		=> "\xb8\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x85"		=> "\xb8\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x86"		=> "\xb8\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x87"		=> "\xb8\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x88"		=> "\xb8\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x89"		=> "\xb8\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x8a"		=> "\xb8\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x8c"		=> "\xb8\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x8d"		=> "\xb8\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x8e"		=> "\xb8\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x8f"		=> "\xb8\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x90"		=> "\xb8\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x91"		=> "\xb8\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x92"		=> "\xb8\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x93"		=> "\xb8\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x94"		=> "\xb8\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x95"		=> "\xb8\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x97"		=> "\xb8\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x98"		=> "\xb8\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x9a"		=> "\xb8\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x9b"		=> "\xb8\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x9c"		=> "\xb8\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x9d"		=> "\xb8\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa1"		=> "\xb8\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa2"		=> "\xb8\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa4"		=> "\xb8\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa7"		=> "\xb8\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa8"		=> "\xb8\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa9"		=> "\xb8\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xaa"		=> "\xb8\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xab"		=> "\xb8\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xac"		=> "\xb8\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xae"		=> "\xb8\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb0"		=> "\xb8\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb1"		=> "\xb8\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb2"		=> "\xb8\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb3"		=> "\xb8\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb4"		=> "\xb8\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb5"		=> "\xb8\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb6"		=> "\xb8\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb7"		=> "\xb8\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb8"		=> "\xb8\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xbb"		=> "\xb8\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xbc"		=> "\xb8\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xbe"		=> "\xb8\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x80"		=> "\xb8\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x81"		=> "\xb8\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x82"		=> "\xb8\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x85"		=> "\xb8\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x87"		=> "\xb8\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x89"		=> "\xb8\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x8c"		=> "\xb8\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x8d"		=> "\xb8\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x8e"		=> "\xb8\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x90"		=> "\xb8\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x92"		=> "\xb8\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x93"		=> "\xb8\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x96"		=> "\xb8\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x97"		=> "\xb8\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x98"		=> "\xb8\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x9a"		=> "\xb8\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x9c"		=> "\xb8\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x9d"		=> "\xb8\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x9f"		=> "\xb8\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa1"		=> "\xb8\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa2"		=> "\xb8\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa3"		=> "\xb8\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa7"		=> "\xb8\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xa9"		=> "\xb8\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xad"		=> "\xb8\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xae"		=> "\xb8\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xaa"		=> "\xb8\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x8f"		=> "\xb8\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb1"		=> "\xb8\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x97"		=> "\xb8\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xab"		=> "\xb8\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x9a"		=> "\xb8\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x85"		=> "\xb8\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xaf"		=> "\xb8\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x9c"		=> "\xb8\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa7"		=> "\xb8\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xaf"		=> "\xb8\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x91"		=> "\xb8\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x9c"		=> "\xb8\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x90"		=> "\xb8\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb4"		=> "\xb8\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xaf"		=> "\xb8\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x86"		=> "\xb8\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x8b"		=> "\xb8\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x8d"		=> "\xb8\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x85"		=> "\xb8\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x98"		=> "\xb8\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x9c"		=> "\xb8\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb6"		=> "\xb8\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb9"		=> "\xb8\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x9f"		=> "\xb8\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x8c"		=> "\xb8\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa3"		=> "\xb8\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x84"		=> "\xb8\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x87"		=> "\xb8\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x9a"		=> "\xb8\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x90"		=> "\xb8\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb6"		=> "\xb8\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x8e"		=> "\xb8\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa5"		=> "\xb8\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb9"		=> "\xb8\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x82"		=> "\xb8\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x99"		=> "\xb8\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x96"		=> "\xb8\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x89"		=> "\xb8\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb2"		=> "\xb8\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x98"		=> "\xb8\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x86"		=> "\xb8\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x91"		=> "\xb8\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xbf"		=> "\xb8\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x9d"		=> "\xb8\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb6"		=> "\xb8\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x9f"		=> "\xb8\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x86"		=> "\xb8\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa2"		=> "\xb8\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa3"		=> "\xb8\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x88"		=> "\xb8\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x9a"		=> "\xb8\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa2"		=> "\xb8\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xb8"		=> "\xb8\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x9b"		=> "\xb8\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb2"		=> "\xb8\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x97"		=> "\xb8\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xaf"		=> "\xb8\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa0"		=> "\xb8\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x99"		=> "\xb8\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x8b"		=> "\xb8\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xab\x98"		=> "\xb8\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x8f"		=> "\xb8\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x94"		=> "\xb8\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x95"		=> "\xb8\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x9e"		=> "\xb8\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x90"		=> "\xb8\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xbf"		=> "\xb8\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x8a"		=> "\xb8\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa5"		=> "\xb8\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x8c"		=> "\xb8\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x81"		=> "\xb8\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x88"		=> "\xb8\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xbd"		=> "\xb8\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb3"		=> "\xb8\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x99"		=> "\xb8\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xb2"		=> "\xb8\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xa9"		=> "\xb8\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x9b"		=> "\xb8\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xbc"		=> "\xb8\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa4"		=> "\xb8\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x81"		=> "\xb8\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x94"		=> "\xb8\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xac"		=> "\xb8\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xaa"		=> "\xb8\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x84"		=> "\xb8\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x99"		=> "\xb8\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb9"		=> "\xb8\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x9f"		=> "\xb8\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x95"		=> "\xb8\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb4"		=> "\xb8\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x9a"		=> "\xb8\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb9"		=> "\xb8\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xaf"		=> "\xb9\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb0"		=> "\xb9\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb2"		=> "\xb9\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb4"		=> "\xb9\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb5"		=> "\xb9\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb6"		=> "\xb9\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb7"		=> "\xb9\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xb9"		=> "\xb9\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xbb"		=> "\xb9\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xbd"		=> "\xb9\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xbf"		=> "\xb9\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x80"		=> "\xb9\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x81"		=> "\xb9\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x82"		=> "\xb9\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x83"		=> "\xb9\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x84"		=> "\xb9\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x86"		=> "\xb9\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x88"		=> "\xb9\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x8a"		=> "\xb9\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x8d"		=> "\xb9\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x8e"		=> "\xb9\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x93"		=> "\xb9\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x95"		=> "\xb9\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x97"		=> "\xb9\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x99"		=> "\xb9\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x9c"		=> "\xb9\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x9e"		=> "\xb9\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x9f"		=> "\xb9\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa1"		=> "\xb9\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa3"		=> "\xb9\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa4"		=> "\xb9\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa5"		=> "\xb9\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa6"		=> "\xb9\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa7"		=> "\xb9\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa8"		=> "\xb9\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xa9"		=> "\xb9\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xaa"		=> "\xb9\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xab"		=> "\xb9\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xac"		=> "\xb9\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xad"		=> "\xb9\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xaf"		=> "\xb9\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb0"		=> "\xb9\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb3"		=> "\xb9\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb4"		=> "\xb9\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb6"		=> "\xb9\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb8"		=> "\xb9\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xba"		=> "\xb9\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xbc"		=> "\xb9\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xbd"		=> "\xb9\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xbf"		=> "\xb9\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x81"		=> "\xb9\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x82"		=> "\xb9\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x83"		=> "\xb9\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x84"		=> "\xb9\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x86"		=> "\xb9\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x87"		=> "\xb9\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x88"		=> "\xb9\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x89"		=> "\xb9\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x8a"		=> "\xb9\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x8b"		=> "\xb9\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x8c"		=> "\xb9\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x8e"		=> "\xb9\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x8f"		=> "\xb9\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x91"		=> "\xb9\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x92"		=> "\xb9\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x93"		=> "\xb9\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x96"		=> "\xb9\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x98"		=> "\xb9\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x99"		=> "\xb9\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x9a"		=> "\xb9\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x9b"		=> "\xb9\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x9e"		=> "\xb9\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x9f"		=> "\xb9\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xa0"		=> "\xb9\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xa3"		=> "\xb9\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xa4"		=> "\xb9\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xa5"		=> "\xb9\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xae"		=> "\xb9\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xaf"		=> "\xb9\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb0"		=> "\xb9\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb2"		=> "\xb9\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb3"		=> "\xb9\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb5"		=> "\xb9\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb6"		=> "\xb9\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb7"		=> "\xb9\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb9"		=> "\xb9\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xba"		=> "\xb9\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xbb"		=> "\xb9\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xbc"		=> "\xb9\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xbd"		=> "\xb9\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xbe"		=> "\xb9\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xbf"		=> "\xb9\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x80"		=> "\xb9\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x82"		=> "\xb9\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x83"		=> "\xb9\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x84"		=> "\xb9\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x82"		=> "\xb9\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xbf"		=> "\xb9\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x97"		=> "\xb9\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa5"		=> "\xb9\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xbb"		=> "\xb9\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x9f"		=> "\xb9\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xad"		=> "\xb9\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbe\x9a"		=> "\xb9\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x9b"		=> "\xb9\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xac"		=> "\xb9\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xac"		=> "\xb9\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xab"		=> "\xb9\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x93"		=> "\xb9\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa9"		=> "\xb9\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x9e"		=> "\xb9\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb1"		=> "\xb9\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa1"		=> "\xb9\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb1"		=> "\xb9\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa9"		=> "\xb9\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xbe"		=> "\xb9\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x9f"		=> "\xb9\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x9f"		=> "\xb9\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x97"		=> "\xb9\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa2"		=> "\xb9\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x84"		=> "\xb9\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xad"		=> "\xb9\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x9f"		=> "\xb9\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x9c"		=> "\xb9\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x87"		=> "\xb9\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x95"		=> "\xb9\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x8d"		=> "\xb9\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb0"		=> "\xb9\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xbd"		=> "\xb9\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa4"		=> "\xb9\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x91"		=> "\xb9\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\x93"		=> "\xb9\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa4"		=> "\xb9\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x8a"		=> "\xb9\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\xa8"		=> "\xb9\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb7"		=> "\xb9\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa1"		=> "\xb9\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x85"		=> "\xb9\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xbe"		=> "\xb9\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xba"		=> "\xb9\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x87"		=> "\xb9\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xae"		=> "\xb9\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\x9c"		=> "\xb9\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x90"		=> "\xb9\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa1"		=> "\xb9\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x82"		=> "\xb9\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x82"		=> "\xb9\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x96"		=> "\xb9\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x90"		=> "\xb9\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xaa"		=> "\xb9\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xba"		=> "\xb9\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb3"		=> "\xb9\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x98"		=> "\xb9\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa0"		=> "\xb9\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x82"		=> "\xb9\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xa1"		=> "\xb9\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x86"		=> "\xb9\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x90"		=> "\xb9\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xaf"		=> "\xb9\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\x8c"		=> "\xb9\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xaf"		=> "\xb9\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x89"		=> "\xb9\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xbf"		=> "\xb9\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x9b"		=> "\xb9\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb0"		=> "\xb9\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x84"		=> "\xb9\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xad"		=> "\xb9\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x85"		=> "\xb9\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x92"		=> "\xb9\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbe\x9f"		=> "\xb9\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xba"		=> "\xb9\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa8"		=> "\xb9\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xac\xbc"		=> "\xb9\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa1"		=> "\xb9\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xb8"		=> "\xb9\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x82"		=> "\xb9\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x9c"		=> "\xb9\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xaa"		=> "\xb9\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb5"		=> "\xb9\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xbd"		=> "\xb9\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x8a"		=> "\xb9\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x9a"		=> "\xb9\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x8d"		=> "\xb9\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x85"		=> "\xb9\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xad"		=> "\xb9\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xbd"		=> "\xb9\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x9c"		=> "\xb9\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb9"		=> "\xb9\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x87"		=> "\xb9\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x88"		=> "\xb9\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x85"		=> "\xba\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x88"		=> "\xba\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x89"		=> "\xba\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x8a"		=> "\xba\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x8b"		=> "\xba\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x8d"		=> "\xba\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x8e"		=> "\xba\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x8f"		=> "\xba\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x90"		=> "\xba\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x92"		=> "\xba\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x94"		=> "\xba\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x95"		=> "\xba\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x96"		=> "\xba\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x97"		=> "\xba\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x98"		=> "\xba\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x9b"		=> "\xba\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x9c"		=> "\xba\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x9e"		=> "\xba\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x9f"		=> "\xba\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa0"		=> "\xba\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa2"		=> "\xba\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa3"		=> "\xba\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa4"		=> "\xba\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa7"		=> "\xba\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa8"		=> "\xba\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xa9"		=> "\xba\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xab"		=> "\xba\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xac"		=> "\xba\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xad"		=> "\xba\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xaf"		=> "\xba\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb0"		=> "\xba\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb2"		=> "\xba\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb3"		=> "\xba\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb4"		=> "\xba\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb5"		=> "\xba\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb6"		=> "\xba\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb8"		=> "\xba\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb9"		=> "\xba\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xba"		=> "\xba\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xbb"		=> "\xba\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xbd"		=> "\xba\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xbf"		=> "\xba\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x80"		=> "\xba\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x81"		=> "\xba\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x82"		=> "\xba\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x83"		=> "\xba\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x84"		=> "\xba\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x85"		=> "\xba\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x86"		=> "\xba\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x88"		=> "\xba\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x89"		=> "\xba\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x8a"		=> "\xba\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x8d"		=> "\xba\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x8e"		=> "\xba\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x90"		=> "\xba\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x91"		=> "\xba\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x92"		=> "\xba\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x93"		=> "\xba\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x94"		=> "\xba\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x95"		=> "\xba\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x97"		=> "\xba\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x98"		=> "\xba\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x99"		=> "\xba\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x9a"		=> "\xba\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x9b"		=> "\xba\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x9c"		=> "\xba\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x9d"		=> "\xba\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\x9e"		=> "\xba\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa0"		=> "\xba\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa1"		=> "\xba\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa2"		=> "\xba\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa3"		=> "\xba\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa4"		=> "\xba\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa5"		=> "\xba\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa8"		=> "\xba\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa9"		=> "\xba\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xab"		=> "\xba\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xac"		=> "\xba\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xad"		=> "\xba\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xae"		=> "\xba\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xaf"		=> "\xba\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb0"		=> "\xba\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb1"		=> "\xba\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb2"		=> "\xba\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb3"		=> "\xba\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb4"		=> "\xba\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb5"		=> "\xba\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb6"		=> "\xba\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb7"		=> "\xba\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xb9"		=> "\xba\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xba"		=> "\xba\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xbb"		=> "\xba\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xbc"		=> "\xba\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xbd"		=> "\xba\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xbe"		=> "\xba\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x82"		=> "\xba\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\xb8"		=> "\xba\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa9"		=> "\xba\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb7"		=> "\xba\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa6"		=> "\xba\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa5"		=> "\xba\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb3"		=> "\xba\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x87"		=> "\xba\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xa3"		=> "\xba\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa8"		=> "\xba\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xaf"		=> "\xba\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xa9"		=> "\xba\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xab"		=> "\xba\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb5"		=> "\xba\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x92"		=> "\xba\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xbd"		=> "\xba\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x8a"		=> "\xba\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x95"		=> "\xba\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb0"		=> "\xba\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xbc"		=> "\xba\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x8d"		=> "\xba\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb1"		=> "\xba\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xbe"		=> "\xba\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x8d"		=> "\xba\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x8a"		=> "\xba\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x97"		=> "\xba\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x89"		=> "\xba\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xaf"		=> "\xba\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xad"		=> "\xba\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xaa"		=> "\xba\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x95"		=> "\xba\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x8e"		=> "\xba\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xaa"		=> "\xba\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xab"		=> "\xba\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x9d"		=> "\xba\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xbd"		=> "\xba\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x97"		=> "\xba\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb7"		=> "\xba\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa9"		=> "\xba\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb5"		=> "\xba\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x9d"		=> "\xba\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb7"		=> "\xba\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x8f"		=> "\xba\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb8"		=> "\xba\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xbe"		=> "\xba\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x8c"		=> "\xba\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x95"		=> "\xba\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x88"		=> "\xba\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x92"		=> "\xba\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x89"		=> "\xba\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x82"		=> "\xba\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb3"		=> "\xba\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb8"		=> "\xba\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xab"		=> "\xba\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x90"		=> "\xba\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\xa4"		=> "\xba\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xba"		=> "\xba\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xbf"		=> "\xba\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x91"		=> "\xba\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x95"		=> "\xba\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x88"		=> "\xba\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa0"		=> "\xba\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa8"		=> "\xba\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xbc"		=> "\xba\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa8"		=> "\xba\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xaa"		=> "\xba\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa1"		=> "\xba\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x92"		=> "\xba\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xb0"		=> "\xba\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x84"		=> "\xba\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x98"		=> "\xba\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb9"		=> "\xba\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xbf"		=> "\xba\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xaa"		=> "\xba\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x8f"		=> "\xba\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x98"		=> "\xba\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xa2"		=> "\xba\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x89"		=> "\xba\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xaf"		=> "\xba\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb4"		=> "\xba\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xbc"		=> "\xba\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x9a"		=> "\xba\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x99"		=> "\xba\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x8e"		=> "\xba\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xbc"		=> "\xba\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x8e"		=> "\xba\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xbd"		=> "\xba\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x9a"		=> "\xba\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb6"		=> "\xba\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xab"		=> "\xba\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xa1"		=> "\xba\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb4"		=> "\xba\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x90"		=> "\xba\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x8a"		=> "\xba\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x96"		=> "\xba\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x83"		=> "\xbb\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x84"		=> "\xbb\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x85"		=> "\xbb\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x86"		=> "\xbb\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x87"		=> "\xbb\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x88"		=> "\xbb\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x89"		=> "\xbb\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x8a"		=> "\xbb\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x8b"		=> "\xbb\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x8c"		=> "\xbb\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x8e"		=> "\xbb\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x8f"		=> "\xbb\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x90"		=> "\xbb\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x91"		=> "\xbb\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x92"		=> "\xbb\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x93"		=> "\xbb\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x94"		=> "\xbb\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x95"		=> "\xbb\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x96"		=> "\xbb\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x97"		=> "\xbb\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x98"		=> "\xbb\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x99"		=> "\xbb\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x9a"		=> "\xbb\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x9b"		=> "\xbb\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x9c"		=> "\xbb\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x9d"		=> "\xbb\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x9e"		=> "\xbb\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x9f"		=> "\xbb\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa0"		=> "\xbb\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa1"		=> "\xbb\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa2"		=> "\xbb\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa3"		=> "\xbb\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa4"		=> "\xbb\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa5"		=> "\xbb\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa6"		=> "\xbb\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa7"		=> "\xbb\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa8"		=> "\xbb\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xa9"		=> "\xbb\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xaa"		=> "\xbb\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xab"		=> "\xbb\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xac"		=> "\xbb\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xad"		=> "\xbb\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xae"		=> "\xbb\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xaf"		=> "\xbb\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb0"		=> "\xbb\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb1"		=> "\xbb\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb2"		=> "\xbb\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb5"		=> "\xbb\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb6"		=> "\xbb\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb7"		=> "\xbb\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb8"		=> "\xbb\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb9"		=> "\xbb\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xba"		=> "\xbb\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xbe"		=> "\xbb\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xbf"		=> "\xbb\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x80"		=> "\xbb\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x81"		=> "\xbb\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x82"		=> "\xbb\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x83"		=> "\xbb\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x84"		=> "\xbb\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x85"		=> "\xbb\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x86"		=> "\xbb\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x87"		=> "\xbb\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x88"		=> "\xbb\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x8a"		=> "\xbb\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x8b"		=> "\xbb\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x8c"		=> "\xbb\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x8d"		=> "\xbb\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x8e"		=> "\xbb\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x8f"		=> "\xbb\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x90"		=> "\xbb\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x93"		=> "\xbb\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x94"		=> "\xbb\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x96"		=> "\xbb\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x99"		=> "\xbb\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x9a"		=> "\xbb\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x9b"		=> "\xbb\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa0"		=> "\xbb\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa1"		=> "\xbb\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa3"		=> "\xbb\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa6"		=> "\xbb\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa7"		=> "\xbb\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa8"		=> "\xbb\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa9"		=> "\xbb\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xab"		=> "\xbb\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xac"		=> "\xbb\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xad"		=> "\xbb\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xaf"		=> "\xbb\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb0"		=> "\xbb\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb4"		=> "\xbb\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb5"		=> "\xbb\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb6"		=> "\xbb\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb7"		=> "\xbb\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb8"		=> "\xbb\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xba"		=> "\xbb\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xbb"		=> "\xbb\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa7"		=> "\xbb\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x8e"		=> "\xbb\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xac"		=> "\xbb\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa4"		=> "\xbb\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x92"		=> "\xbb\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xaa"		=> "\xbb\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xb7"		=> "\xbb\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb1"		=> "\xbb\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x97"		=> "\xbb\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x8e"		=> "\xbb\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xbe"		=> "\xbb\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x91"		=> "\xbb\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xbb"		=> "\xbb\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x92"		=> "\xbb\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x96"		=> "\xbb\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x9d"		=> "\xbb\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x90"		=> "\xbb\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x8a"		=> "\xbb\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x80"		=> "\xbb\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xae"		=> "\xbb\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x8f"		=> "\xbb\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa2"		=> "\xbb\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xaf"		=> "\xbb\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x93"		=> "\xbb\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x98"		=> "\xbb\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x93"		=> "\xbb\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa2"		=> "\xbb\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa3"		=> "\xbb\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa4"		=> "\xbb\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xaa"		=> "\xbb\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa2"		=> "\xbb\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x95"		=> "\xbb\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa3"		=> "\xbb\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa6"		=> "\xbb\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xbb"		=> "\xbb\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x92"		=> "\xbb\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x8c"		=> "\xbb\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x84"		=> "\xbb\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xba"		=> "\xbb\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x97"		=> "\xbb\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb0\xa7"		=> "\xbb\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x87"		=> "\xbb\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb0"		=> "\xbb\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb6"		=> "\xbb\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x8c"		=> "\xbb\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x83"		=> "\xbb\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x8c"		=> "\xbb\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x8d"		=> "\xbb\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x8e"		=> "\xbb\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb0"		=> "\xbb\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa5"		=> "\xbb\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x89"		=> "\xbb\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xbd"		=> "\xbb\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa2"		=> "\xbb\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x94"		=> "\xbb\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x9e"		=> "\xbb\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x81"		=> "\xbb\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x94"		=> "\xbb\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa7"		=> "\xbb\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x89"		=> "\xbb\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa0"		=> "\xbb\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa6"		=> "\xbb\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xbf"		=> "\xbb\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xbd"		=> "\xbb\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x9a"		=> "\xbb\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa9"		=> "\xbb\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x87"		=> "\xbb\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb3"		=> "\xbb\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb2"		=> "\xbb\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x98"		=> "\xbb\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa4"		=> "\xbb\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x8f"		=> "\xbb\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x9a"		=> "\xbb\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xad\x82"		=> "\xbb\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x91"		=> "\xbb\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb7"		=> "\xbb\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x81"		=> "\xbb\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xbb"		=> "\xbb\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x99"		=> "\xbb\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xab"		=> "\xbb\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb7"		=> "\xbb\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x96"		=> "\xbb\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x91"		=> "\xbb\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x8d"		=> "\xbb\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa7"		=> "\xbb\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xb8"		=> "\xbb\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xbb"		=> "\xbb\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xbe"		=> "\xbb\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xba"		=> "\xbb\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xba"		=> "\xbb\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xb8"		=> "\xbb\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xbd"		=> "\xbb\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xaf"		=> "\xbb\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x95"		=> "\xbb\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xbf"		=> "\xbc\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x80"		=> "\xbc\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x82"		=> "\xbc\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x83"		=> "\xbc\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x84"		=> "\xbc\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x86"		=> "\xbc\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x89"		=> "\xbc\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x8b"		=> "\xbc\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x8e"		=> "\xbc\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x8f"		=> "\xbc\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x90"		=> "\xbc\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x91"		=> "\xbc\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x92"		=> "\xbc\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x93"		=> "\xbc\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x94"		=> "\xbc\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x98"		=> "\xbc\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x9a"		=> "\xbc\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x9b"		=> "\xbc\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x9d"		=> "\xbc\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x9e"		=> "\xbc\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa1"		=> "\xbc\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa2"		=> "\xbc\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa3"		=> "\xbc\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa4"		=> "\xbc\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa5"		=> "\xbc\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa6"		=> "\xbc\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa7"		=> "\xbc\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa9"		=> "\xbc\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xaa"		=> "\xbc\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xab"		=> "\xbc\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xac"		=> "\xbc\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xad"		=> "\xbc\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xae"		=> "\xbc\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb0"		=> "\xbc\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb1"		=> "\xbc\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb2"		=> "\xbc\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb3"		=> "\xbc\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb4"		=> "\xbc\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb5"		=> "\xbc\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb6"		=> "\xbc\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb7"		=> "\xbc\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xb9"		=> "\xbc\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xba"		=> "\xbc\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xbc"		=> "\xbc\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xbd"		=> "\xbc\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xbe"		=> "\xbc\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xbf"		=> "\xbc\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x80"		=> "\xbc\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x81"		=> "\xbc\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x82"		=> "\xbc\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x83"		=> "\xbc\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x84"		=> "\xbc\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x85"		=> "\xbc\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x86"		=> "\xbc\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x87"		=> "\xbc\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x88"		=> "\xbc\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x89"		=> "\xbc\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x8b"		=> "\xbc\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x8c"		=> "\xbc\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x8d"		=> "\xbc\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x8e"		=> "\xbc\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x8f"		=> "\xbc\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x90"		=> "\xbc\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x91"		=> "\xbc\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x92"		=> "\xbc\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x93"		=> "\xbc\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x94"		=> "\xbc\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x95"		=> "\xbc\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x96"		=> "\xbc\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x97"		=> "\xbc\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x98"		=> "\xbc\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x99"		=> "\xbc\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x9a"		=> "\xbc\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x9b"		=> "\xbc\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x9c"		=> "\xbc\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x9d"		=> "\xbc\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x9e"		=> "\xbc\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x9f"		=> "\xbc\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa1"		=> "\xbc\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa3"		=> "\xbc\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa4"		=> "\xbc\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa5"		=> "\xbc\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa6"		=> "\xbc\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa8"		=> "\xbc\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa9"		=> "\xbc\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xaa"		=> "\xbc\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xac"		=> "\xbc\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xad"		=> "\xbc\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xae"		=> "\xbc\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb0"		=> "\xbc\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb1"		=> "\xbc\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb2"		=> "\xbc\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb3"		=> "\xbc\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb4"		=> "\xbc\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb5"		=> "\xbc\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb6"		=> "\xbc\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x8c"		=> "\xbc\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xa5"		=> "\xbc\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb9"		=> "\xbc\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbf\x80"		=> "\xbc\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa5"		=> "\xbc\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xa1"		=> "\xbc\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xac"		=> "\xbc\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa9"		=> "\xbc\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x89"		=> "\xbc\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x89"		=> "\xbc\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x81"		=> "\xbc\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x98"		=> "\xbc\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x91"		=> "\xbc\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\x8d"		=> "\xbc\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x86"		=> "\xbc\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x8a"		=> "\xbc\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa5"		=> "\xbc\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xbe"		=> "\xbc\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb2"		=> "\xbc\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb3"		=> "\xbc\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x89"		=> "\xbc\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xa7"		=> "\xbc\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa4"		=> "\xbc\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xa0"		=> "\xbc\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x8a"		=> "\xbc\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb1"		=> "\xbc\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x9f"		=> "\xbc\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x80"		=> "\xbc\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x80"		=> "\xbc\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa3"		=> "\xbc\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x8e"		=> "\xbc\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xad"		=> "\xbc\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x82"		=> "\xbc\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb8"		=> "\xbc\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x8e"		=> "\xbc\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x84"		=> "\xbc\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x82"		=> "\xbc\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa1"		=> "\xbc\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb0"		=> "\xbc\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa2"		=> "\xbc\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x8c"		=> "\xbc\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x85"		=> "\xbc\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x93"		=> "\xbc\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa7"		=> "\xbc\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xaa"		=> "\xbc\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x89"		=> "\xbc\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xb7"		=> "\xbc\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb9"		=> "\xbc\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb3"		=> "\xbc\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb6"		=> "\xbc\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa0"		=> "\xbc\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x9a"		=> "\xbc\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x8a"		=> "\xbc\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xbe"		=> "\xbc\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb2"		=> "\xbc\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xbe"		=> "\xbc\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x87"		=> "\xbc\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xbc"		=> "\xbc\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb7"		=> "\xbc\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xb6"		=> "\xbc\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xbe"		=> "\xbc\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x81"		=> "\xbc\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xbc"		=> "\xbc\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x91"		=> "\xbc\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x9a"		=> "\xbc\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x96"		=> "\xbc\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xba"		=> "\xbc\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb4"		=> "\xbc\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x8e"		=> "\xbc\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xbc"		=> "\xbc\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa9"		=> "\xbc\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb0"		=> "\xbc\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb8"		=> "\xbc\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x84"		=> "\xbc\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa7"		=> "\xbc\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x80"		=> "\xbc\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xac"		=> "\xbc\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb1"		=> "\xbc\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xb7"		=> "\xbc\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa3"		=> "\xbc\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa1"		=> "\xbc\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x80"		=> "\xbc\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xad"		=> "\xbc\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xaa"		=> "\xbc\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x8f"		=> "\xbc\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x90"		=> "\xbc\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa7\x9b"		=> "\xbc\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb4"		=> "\xbc\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb5"		=> "\xbc\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb1"		=> "\xbc\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x81"		=> "\xbc\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xae"		=> "\xbc\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xad"		=> "\xbc\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb6"		=> "\xbc\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb7"		=> "\xbd\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb8"		=> "\xbd\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xb9"		=> "\xbd\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xba"		=> "\xbd\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xbb"		=> "\xbd\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xbc"		=> "\xbd\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xbd"		=> "\xbd\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xbe"		=> "\xbd\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xbf"		=> "\xbd\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x80"		=> "\xbd\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x81"		=> "\xbd\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x82"		=> "\xbd\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x83"		=> "\xbd\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x84"		=> "\xbd\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x85"		=> "\xbd\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x86"		=> "\xbd\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x87"		=> "\xbd\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x88"		=> "\xbd\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x89"		=> "\xbd\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x8a"		=> "\xbd\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x8b"		=> "\xbd\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x8c"		=> "\xbd\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x8d"		=> "\xbd\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x8e"		=> "\xbd\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x8f"		=> "\xbd\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x90"		=> "\xbd\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x91"		=> "\xbd\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x92"		=> "\xbd\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x93"		=> "\xbd\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x94"		=> "\xbd\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x95"		=> "\xbd\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x96"		=> "\xbd\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x97"		=> "\xbd\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x98"		=> "\xbd\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x99"		=> "\xbd\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x9a"		=> "\xbd\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x9b"		=> "\xbd\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x9c"		=> "\xbd\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x9d"		=> "\xbd\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x9e"		=> "\xbd\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\x9f"		=> "\xbd\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa0"		=> "\xbd\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa1"		=> "\xbd\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa2"		=> "\xbd\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa3"		=> "\xbd\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa4"		=> "\xbd\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa5"		=> "\xbd\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa6"		=> "\xbd\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa7"		=> "\xbd\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa8"		=> "\xbd\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xa9"		=> "\xbd\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xaa"		=> "\xbd\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xab"		=> "\xbd\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xac"		=> "\xbd\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xad"		=> "\xbd\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xaf"		=> "\xbd\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb0"		=> "\xbd\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb1"		=> "\xbd\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb2"		=> "\xbd\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb3"		=> "\xbd\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb4"		=> "\xbd\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb5"		=> "\xbd\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb6"		=> "\xbd\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb8"		=> "\xbd\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xb9"		=> "\xbd\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xba"		=> "\xbd\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xbb"		=> "\xbd\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xbc"		=> "\xbd\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xbd"		=> "\xbd\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xbe"		=> "\xbd\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xbf"		=> "\xbd\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x80"		=> "\xbd\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x81"		=> "\xbd\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x82"		=> "\xbd\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x83"		=> "\xbd\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x84"		=> "\xbd\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x85"		=> "\xbd\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x86"		=> "\xbd\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x87"		=> "\xbd\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x88"		=> "\xbd\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x89"		=> "\xbd\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x8a"		=> "\xbd\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x8b"		=> "\xbd\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x8c"		=> "\xbd\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x8d"		=> "\xbd\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x8e"		=> "\xbd\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x8f"		=> "\xbd\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x90"		=> "\xbd\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x91"		=> "\xbd\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x92"		=> "\xbd\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x93"		=> "\xbd\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x94"		=> "\xbd\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x95"		=> "\xbd\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x96"		=> "\xbd\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x97"		=> "\xbd\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x98"		=> "\xbd\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xa5"		=> "\xbd\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb0"		=> "\xbd\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x91"		=> "\xbd\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xaf"		=> "\xbd\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x90"		=> "\xbd\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x85"		=> "\xbd\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa7"		=> "\xbd\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xba"		=> "\xbd\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb5"		=> "\xbd\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x9c"		=> "\xbd\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x86"		=> "\xbd\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x86"		=> "\xbd\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x9f"		=> "\xbd\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x86"		=> "\xbd\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x8b"		=> "\xbd\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xa8"		=> "\xbd\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x96"		=> "\xbd\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb2"		=> "\xbd\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa0"		=> "\xbd\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xb1"		=> "\xbd\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x8d"		=> "\xbd\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x89"		=> "\xbd\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x92"		=> "\xbd\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\x81"		=> "\xbd\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xa6"		=> "\xbd\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb6"		=> "\xbd\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa4"		=> "\xbd\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x8a"		=> "\xbd\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x87"		=> "\xbd\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x84"		=> "\xbd\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x87"		=> "\xbd\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xbc"		=> "\xbd\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x85"		=> "\xbd\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xb0"		=> "\xbd\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xab"		=> "\xbd\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa5"		=> "\xbd\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x9a"		=> "\xbd\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa1"		=> "\xbd\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x92"		=> "\xbd\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xba"		=> "\xbd\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xb4"		=> "\xbd\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x9e"		=> "\xbd\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xbf"		=> "\xbd\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x99"		=> "\xbd\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xb5"		=> "\xbd\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xbf"		=> "\xbd\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x83"		=> "\xbd\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xab"		=> "\xbd\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x96"		=> "\xbd\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xad"		=> "\xbd\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa5"		=> "\xbd\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x86"		=> "\xbd\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xb8"		=> "\xbd\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x97"		=> "\xbd\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xb6"		=> "\xbd\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xaa"		=> "\xbd\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xab"		=> "\xbd\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x82"		=> "\xbd\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x94"		=> "\xbd\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xb0"		=> "\xbd\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb7"		=> "\xbd\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xab"		=> "\xbd\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xad"		=> "\xbd\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x81"		=> "\xbd\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x93"		=> "\xbd\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa3"		=> "\xbd\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x90"		=> "\xbd\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x92"		=> "\xbd\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x89"		=> "\xbd\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa5"		=> "\xbd\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x8c"		=> "\xbd\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x9f"		=> "\xbd\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x8b"		=> "\xbd\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa5"		=> "\xbd\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xab"		=> "\xbd\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x8a"		=> "\xbd\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xbe"		=> "\xbd\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x8b"		=> "\xbd\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa4"		=> "\xbd\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x91"		=> "\xbd\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x8a"		=> "\xbd\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xa5"		=> "\xbd\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x9f"		=> "\xbd\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa7"		=> "\xbd\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xa6"		=> "\xbd\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x85"		=> "\xbd\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa8"		=> "\xbd\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x9b"		=> "\xbd\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xb3"		=> "\xbd\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x8b"		=> "\xbd\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x81"		=> "\xbd\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x91"		=> "\xbd\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xac"		=> "\xbd\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb8"		=> "\xbd\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x99"		=> "\xbe\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x9a"		=> "\xbe\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x9b"		=> "\xbe\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x9c"		=> "\xbe\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x9d"		=> "\xbe\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x9e"		=> "\xbe\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\x9f"		=> "\xbe\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa0"		=> "\xbe\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa1"		=> "\xbe\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa2"		=> "\xbe\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa3"		=> "\xbe\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa4"		=> "\xbe\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa5"		=> "\xbe\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa7"		=> "\xbe\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa8"		=> "\xbe\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xa9"		=> "\xbe\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xaa"		=> "\xbe\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xab"		=> "\xbe\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xac"		=> "\xbe\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xad"		=> "\xbe\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xaf"		=> "\xbe\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb0"		=> "\xbe\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb1"		=> "\xbe\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb2"		=> "\xbe\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb3"		=> "\xbe\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb4"		=> "\xbe\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb5"		=> "\xbe\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb6"		=> "\xbe\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb7"		=> "\xbe\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb8"		=> "\xbe\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xb9"		=> "\xbe\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xba"		=> "\xbe\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xbb"		=> "\xbe\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xbc"		=> "\xbe\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xbd"		=> "\xbe\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xbe"		=> "\xbe\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb6\xbf"		=> "\xbe\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x80"		=> "\xbe\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x81"		=> "\xbe\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x82"		=> "\xbe\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x83"		=> "\xbe\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x84"		=> "\xbe\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x85"		=> "\xbe\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x86"		=> "\xbe\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x87"		=> "\xbe\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x88"		=> "\xbe\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x89"		=> "\xbe\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x8a"		=> "\xbe\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x8b"		=> "\xbe\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x8c"		=> "\xbe\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x8d"		=> "\xbe\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x8e"		=> "\xbe\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x8f"		=> "\xbe\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x90"		=> "\xbe\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x91"		=> "\xbe\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x92"		=> "\xbe\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x93"		=> "\xbe\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x94"		=> "\xbe\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x95"		=> "\xbe\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x96"		=> "\xbe\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x97"		=> "\xbe\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x98"		=> "\xbe\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x99"		=> "\xbe\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x9a"		=> "\xbe\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x9b"		=> "\xbe\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x9c"		=> "\xbe\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x9d"		=> "\xbe\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x9e"		=> "\xbe\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\x9f"		=> "\xbe\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa0"		=> "\xbe\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa1"		=> "\xbe\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa2"		=> "\xbe\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa3"		=> "\xbe\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa4"		=> "\xbe\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa5"		=> "\xbe\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa6"		=> "\xbe\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa7"		=> "\xbe\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa8"		=> "\xbe\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xa9"		=> "\xbe\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xaa"		=> "\xbe\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xab"		=> "\xbe\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xac"		=> "\xbe\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xad"		=> "\xbe\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xae"		=> "\xbe\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xaf"		=> "\xbe\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb0"		=> "\xbe\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb1"		=> "\xbe\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb2"		=> "\xbe\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb3"		=> "\xbe\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb4"		=> "\xbe\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb5"		=> "\xbe\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb6"		=> "\xbe\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb7"		=> "\xbe\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb8"		=> "\xbe\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xb9"		=> "\xbe\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xba"		=> "\xbe\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xbd"		=> "\xbe\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb2"		=> "\xbe\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x86"		=> "\xbe\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa2"		=> "\xbe\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x8e"		=> "\xbe\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x9b"		=> "\xbe\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb6"		=> "\xbe\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb2\xb8"		=> "\xbe\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xac"		=> "\xbe\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x8a"		=> "\xbe\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xbe"		=> "\xbe\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb3"		=> "\xbe\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x8f"		=> "\xbe\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x95"		=> "\xbe\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa6"		=> "\xbe\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xaf"		=> "\xbe\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x88"		=> "\xbe\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\x99"		=> "\xbe\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x83"		=> "\xbe\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xac"		=> "\xbe\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x9c"		=> "\xbe\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x84"		=> "\xbe\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x89"		=> "\xbe\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\x96"		=> "\xbe\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x9f"		=> "\xbe\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x9e"		=> "\xbe\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x80"		=> "\xbe\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xaf"		=> "\xbe\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x98"		=> "\xbe\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xaa"		=> "\xbe\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb6"		=> "\xbe\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xa0"		=> "\xbe\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x96"		=> "\xbe\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xad"		=> "\xbe\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x85"		=> "\xbe\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb8"		=> "\xbe\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x9d"		=> "\xbe\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x92"		=> "\xbe\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa9"		=> "\xbe\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x91"		=> "\xbe\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa7"		=> "\xbe\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xbc"		=> "\xbe\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x85"		=> "\xbe\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x8e"		=> "\xbe\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb1"		=> "\xbe\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x9a"		=> "\xbe\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9e\xa0"		=> "\xbe\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x98"		=> "\xbe\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x99"		=> "\xbe\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xbd"		=> "\xbe\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x85"		=> "\xbe\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xb9"		=> "\xbe\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x8a"		=> "\xbe\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x80"		=> "\xbe\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x80"		=> "\xbe\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa9"		=> "\xbe\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xbe"		=> "\xbe\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xae"		=> "\xbe\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x9a"		=> "\xbe\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x92"		=> "\xbe\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xae"		=> "\xbe\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa8"		=> "\xbe\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb7"		=> "\xbe\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x9d"		=> "\xbe\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x9e"		=> "\xbe\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xaf"		=> "\xbe\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb1"		=> "\xbe\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa5"		=> "\xbe\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xa7"		=> "\xbe\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xac"		=> "\xbe\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa7"		=> "\xbe\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x90"		=> "\xbe\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\x83"		=> "\xbe\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x9f"		=> "\xbe\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa6"		=> "\xbe\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb7"		=> "\xbe\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb7"		=> "\xbe\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa2"		=> "\xbe\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x85"		=> "\xbe\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xab"		=> "\xbe\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x89"		=> "\xbe\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x98"		=> "\xbe\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x94"		=> "\xbe\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb5"		=> "\xbe\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x89"		=> "\xbe\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb3"		=> "\xbe\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x80"		=> "\xbe\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x9d"		=> "\xbe\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x87"		=> "\xbe\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x8c"		=> "\xbe\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa7"		=> "\xbe\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x9b"		=> "\xbe\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x9b"		=> "\xbe\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xbb"		=> "\xbe\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xbb"		=> "\xbf\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xbc"		=> "\xbf\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xbd"		=> "\xbf\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xbe"		=> "\xbf\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb7\xbf"		=> "\xbf\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x80"		=> "\xbf\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x81"		=> "\xbf\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x82"		=> "\xbf\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x83"		=> "\xbf\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x84"		=> "\xbf\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x85"		=> "\xbf\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x86"		=> "\xbf\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x87"		=> "\xbf\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x88"		=> "\xbf\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x89"		=> "\xbf\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x8a"		=> "\xbf\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x8b"		=> "\xbf\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x8c"		=> "\xbf\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x8d"		=> "\xbf\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x8e"		=> "\xbf\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x8f"		=> "\xbf\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x90"		=> "\xbf\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x91"		=> "\xbf\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x92"		=> "\xbf\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x93"		=> "\xbf\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x94"		=> "\xbf\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x95"		=> "\xbf\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x96"		=> "\xbf\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x97"		=> "\xbf\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x98"		=> "\xbf\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x99"		=> "\xbf\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x9a"		=> "\xbf\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x9b"		=> "\xbf\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x9c"		=> "\xbf\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x9d"		=> "\xbf\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x9e"		=> "\xbf\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\x9f"		=> "\xbf\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa0"		=> "\xbf\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa1"		=> "\xbf\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa2"		=> "\xbf\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa3"		=> "\xbf\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa4"		=> "\xbf\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa5"		=> "\xbf\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa6"		=> "\xbf\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa7"		=> "\xbf\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa8"		=> "\xbf\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xa9"		=> "\xbf\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xaa"		=> "\xbf\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xab"		=> "\xbf\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xac"		=> "\xbf\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xad"		=> "\xbf\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xae"		=> "\xbf\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xaf"		=> "\xbf\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb0"		=> "\xbf\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb1"		=> "\xbf\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb2"		=> "\xbf\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb3"		=> "\xbf\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb4"		=> "\xbf\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb5"		=> "\xbf\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb6"		=> "\xbf\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb7"		=> "\xbf\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb8"		=> "\xbf\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xb9"		=> "\xbf\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xba"		=> "\xbf\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xbc"		=> "\xbf\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xbd"		=> "\xbf\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xbe"		=> "\xbf\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb8\xbf"		=> "\xbf\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x80"		=> "\xbf\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x82"		=> "\xbf\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x83"		=> "\xbf\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x84"		=> "\xbf\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x85"		=> "\xbf\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x86"		=> "\xbf\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x88"		=> "\xbf\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x89"		=> "\xbf\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x8a"		=> "\xbf\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x8b"		=> "\xbf\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x8c"		=> "\xbf\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x8d"		=> "\xbf\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x8e"		=> "\xbf\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x8f"		=> "\xbf\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x90"		=> "\xbf\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x91"		=> "\xbf\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x92"		=> "\xbf\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x93"		=> "\xbf\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x94"		=> "\xbf\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x95"		=> "\xbf\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x96"		=> "\xbf\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x97"		=> "\xbf\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x98"		=> "\xbf\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x99"		=> "\xbf\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x9a"		=> "\xbf\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x9b"		=> "\xbf\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x9c"		=> "\xbf\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x9d"		=> "\xbf\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x8a"		=> "\xbf\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa3"		=> "\xbf\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x9a"		=> "\xbf\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa1"		=> "\xbf\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x8f"		=> "\xbf\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x80"		=> "\xbf\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x96"		=> "\xbf\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa1"		=> "\xbf\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xaf"		=> "\xbf\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x80"		=> "\xbf\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa9"		=> "\xbf\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xb7"		=> "\xbf\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xaf"		=> "\xbf\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa8"		=> "\xbf\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x8a"		=> "\xbf\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xaa"		=> "\xbf\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x98"		=> "\xbf\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x8e"		=> "\xbf\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x8d"		=> "\xbf\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x8b"		=> "\xbf\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb7"		=> "\xbf\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb7"		=> "\xbf\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xa0"		=> "\xbf\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x9b"		=> "\xbf\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x97"		=> "\xbf\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa2"		=> "\xbf\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x95"		=> "\xbf\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x83"		=> "\xbf\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb7"		=> "\xbf\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa4"		=> "\xbf\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xa0"		=> "\xbf\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb7"		=> "\xbf\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x9b"		=> "\xbf\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xaf"		=> "\xbf\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb5"		=> "\xbf\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x95"		=> "\xbf\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x97"		=> "\xbf\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x91"		=> "\xbf\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb3"		=> "\xbf\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb3"		=> "\xbf\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xaf"		=> "\xbf\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb4"		=> "\xbf\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x8b"		=> "\xbf\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xbb"		=> "\xbf\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa2"		=> "\xbf\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xbe"		=> "\xbf\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xaf"		=> "\xbf\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x83"		=> "\xbf\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa6"		=> "\xbf\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb3"		=> "\xbf\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x91"		=> "\xbf\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xad"		=> "\xbf\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xba"		=> "\xbf\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x90"		=> "\xbf\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x94"		=> "\xbf\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa7"		=> "\xbf\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa0"		=> "\xbf\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa3"		=> "\xbf\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa3"		=> "\xbf\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x87"		=> "\xbf\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xaf"		=> "\xbf\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xad"		=> "\xbf\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x9f"		=> "\xbf\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa6"		=> "\xbf\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xb7"		=> "\xbf\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x93"		=> "\xbf\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xa4"		=> "\xbf\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb8"		=> "\xbf\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xae"		=> "\xbf\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x8e"		=> "\xbf\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa8"		=> "\xbf\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xaf"		=> "\xbf\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x97"		=> "\xbf\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xb7"		=> "\xbf\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa9"		=> "\xbf\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xab"		=> "\xbf\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xbd"		=> "\xbf\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xbe"		=> "\xbf\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa1"		=> "\xbf\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x90"		=> "\xbf\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x82"		=> "\xbf\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x86"		=> "\xbf\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xbf"		=> "\xbf\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xb6"		=> "\xbf\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb7"		=> "\xbf\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb5"		=> "\xbf\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x8f"		=> "\xbf\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x94"		=> "\xbf\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xbf"		=> "\xbf\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xa5"		=> "\xbf\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb5"		=> "\xbf\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x8e"		=> "\xbf\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xad\x81"		=> "\xbf\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x80"		=> "\xbf\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x9e"		=> "\xc0\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\x9f"		=> "\xc0\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa0"		=> "\xc0\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa1"		=> "\xc0\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa2"		=> "\xc0\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa3"		=> "\xc0\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa4"		=> "\xc0\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa5"		=> "\xc0\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa6"		=> "\xc0\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa7"		=> "\xc0\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa8"		=> "\xc0\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xa9"		=> "\xc0\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xaa"		=> "\xc0\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xab"		=> "\xc0\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xac"		=> "\xc0\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xad"		=> "\xc0\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xae"		=> "\xc0\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xaf"		=> "\xc0\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb0"		=> "\xc0\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb1"		=> "\xc0\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb2"		=> "\xc0\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb3"		=> "\xc0\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb4"		=> "\xc0\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb5"		=> "\xc0\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb6"		=> "\xc0\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb7"		=> "\xc0\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb8"		=> "\xc0\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xb9"		=> "\xc0\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xba"		=> "\xc0\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xbb"		=> "\xc0\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xbc"		=> "\xc0\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xbd"		=> "\xc0\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xbe"		=> "\xc0\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb9\xbf"		=> "\xc0\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x80"		=> "\xc0\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x81"		=> "\xc0\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x83"		=> "\xc0\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x84"		=> "\xc0\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x85"		=> "\xc0\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x86"		=> "\xc0\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x87"		=> "\xc0\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x88"		=> "\xc0\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x89"		=> "\xc0\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x8a"		=> "\xc0\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x8b"		=> "\xc0\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x8c"		=> "\xc0\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x8d"		=> "\xc0\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x8e"		=> "\xc0\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x8f"		=> "\xc0\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x90"		=> "\xc0\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x91"		=> "\xc0\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x92"		=> "\xc0\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x93"		=> "\xc0\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x94"		=> "\xc0\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x95"		=> "\xc0\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x96"		=> "\xc0\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x97"		=> "\xc0\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x98"		=> "\xc0\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x99"		=> "\xc0\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x9a"		=> "\xc0\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x9c"		=> "\xc0\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x9d"		=> "\xc0\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x9e"		=> "\xc0\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xae"		=> "\xc0\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb4"		=> "\xc0\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xbb"		=> "\xc0\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xbc"		=> "\xc0\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x96"		=> "\xc0\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa4"		=> "\xc0\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xac"		=> "\xc0\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb9"		=> "\xc0\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x8a"		=> "\xc0\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x90"		=> "\xc0\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x9e"		=> "\xc0\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xb7"		=> "\xc0\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xb9"		=> "\xc0\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xbb"		=> "\xc0\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xbc"		=> "\xc0\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xbd"		=> "\xc0\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xbe"		=> "\xc0\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xbf"		=> "\xc0\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x80"		=> "\xc0\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x81"		=> "\xc0\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x83"		=> "\xc0\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x86"		=> "\xc0\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x87"		=> "\xc0\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x88"		=> "\xc0\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x89"		=> "\xc0\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x8a"		=> "\xc0\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x8b"		=> "\xc0\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x8c"		=> "\xc0\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x8d"		=> "\xc0\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x8e"		=> "\xc0\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x8f"		=> "\xc0\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x92"		=> "\xc0\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x93"		=> "\xc0\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x88"		=> "\xc0\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa7"		=> "\xc0\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x83"		=> "\xc0\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa4"		=> "\xc0\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x86"		=> "\xc0\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x86"		=> "\xc0\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb0"		=> "\xc0\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xac"		=> "\xc0\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa9"		=> "\xc0\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x93"		=> "\xc0\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x94"		=> "\xc0\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x83"		=> "\xc0\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x89"		=> "\xc0\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x87"		=> "\xc0\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xa1"		=> "\xc0\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x8a"		=> "\xc0\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa3"		=> "\xc0\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa6"		=> "\xc0\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb1"		=> "\xc0\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa5"		=> "\xc0\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x96"		=> "\xc0\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x9d"		=> "\xc0\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xaa"		=> "\xc0\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x8f"		=> "\xc0\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa6"		=> "\xc0\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xae"		=> "\xc0\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x91"		=> "\xc0\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb0"		=> "\xc0\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x9c"		=> "\xc0\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb0"		=> "\xc0\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xbd"		=> "\xc0\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x88"		=> "\xc0\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x92"		=> "\xc0\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x86"		=> "\xc0\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x82"		=> "\xc0\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa5"		=> "\xc0\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x85"		=> "\xc0\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x94"		=> "\xc0\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xbc"		=> "\xc0\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x8a"		=> "\xc0\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x8e"		=> "\xc0\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x97"		=> "\xc0\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xaa"		=> "\xc0\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x9e"		=> "\xc0\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb3"		=> "\xc0\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa2"		=> "\xc0\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x81"		=> "\xc0\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xac"		=> "\xc0\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa5"		=> "\xc0\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xaa"		=> "\xc0\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x99"		=> "\xc0\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x9d"		=> "\xc0\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x92"		=> "\xc0\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x90"		=> "\xc0\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\xb7"		=> "\xc0\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\xad"		=> "\xc0\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xbe"		=> "\xc0\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x8a"		=> "\xc0\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xaf"		=> "\xc0\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\xa1"		=> "\xc0\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x92"		=> "\xc0\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x82"		=> "\xc0\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x8b"		=> "\xc0\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xbb"		=> "\xc0\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xaa"		=> "\xc0\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xb1"		=> "\xc0\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x9e"		=> "\xc0\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb7"		=> "\xc0\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x98"		=> "\xc0\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa8"		=> "\xc0\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x81"		=> "\xc0\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x8e"		=> "\xc0\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb1"		=> "\xc0\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb8"		=> "\xc0\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xbb"		=> "\xc0\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x93"		=> "\xc0\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x86"		=> "\xc0\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x8e"		=> "\xc0\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x8c"		=> "\xc0\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb2\xa4"		=> "\xc0\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xbc"		=> "\xc0\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x89"		=> "\xc0\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x94"		=> "\xc0\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x8f"		=> "\xc0\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x97"		=> "\xc0\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xbd"		=> "\xc0\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x89"		=> "\xc0\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xb1"		=> "\xc0\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xbe"		=> "\xc0\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x86"		=> "\xc0\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa9"		=> "\xc0\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\x88"		=> "\xc0\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x8b"		=> "\xc0\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x90"		=> "\xc0\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x96"		=> "\xc1\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x99"		=> "\xc1\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x9b"		=> "\xc1\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x9c"		=> "\xc1\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x9d"		=> "\xc1\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x9e"		=> "\xc1\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa0"		=> "\xc1\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa3"		=> "\xc1\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa4"		=> "\xc1\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa5"		=> "\xc1\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa6"		=> "\xc1\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa7"		=> "\xc1\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xab"		=> "\xc1\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xac"		=> "\xc1\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xad"		=> "\xc1\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xaf"		=> "\xc1\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb0"		=> "\xc1\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb3"		=> "\xc1\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb5"		=> "\xc1\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb6"		=> "\xc1\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb7"		=> "\xc1\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb8"		=> "\xc1\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xba"		=> "\xc1\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xbb"		=> "\xc1\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xbc"		=> "\xc1\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xbd"		=> "\xc1\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xbf"		=> "\xc1\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x80"		=> "\xc1\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x82"		=> "\xc1\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x83"		=> "\xc1\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x84"		=> "\xc1\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x85"		=> "\xc1\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x86"		=> "\xc1\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x87"		=> "\xc1\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x88"		=> "\xc1\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x89"		=> "\xc1\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x8b"		=> "\xc1\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x8d"		=> "\xc1\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x8f"		=> "\xc1\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x90"		=> "\xc1\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x91"		=> "\xc1\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x92"		=> "\xc1\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x93"		=> "\xc1\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x95"		=> "\xc1\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x96"		=> "\xc1\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x97"		=> "\xc1\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x98"		=> "\xc1\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x99"		=> "\xc1\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x9b"		=> "\xc1\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x9c"		=> "\xc1\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa0"		=> "\xc1\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa2"		=> "\xc1\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa3"		=> "\xc1\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa5"		=> "\xc1\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa6"		=> "\xc1\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa8"		=> "\xc1\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa9"		=> "\xc1\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xaa"		=> "\xc1\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xab"		=> "\xc1\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xac"		=> "\xc1\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xad"		=> "\xc1\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xae"		=> "\xc1\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb1"		=> "\xc1\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb3"		=> "\xc1\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb4"		=> "\xc1\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb5"		=> "\xc1\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb6"		=> "\xc1\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb7"		=> "\xc1\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xba"		=> "\xc1\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xbb"		=> "\xc1\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xbe"		=> "\xc1\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x80"		=> "\xc1\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x82"		=> "\xc1\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x83"		=> "\xc1\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x84"		=> "\xc1\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x86"		=> "\xc1\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x87"		=> "\xc1\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x88"		=> "\xc1\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x89"		=> "\xc1\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x8b"		=> "\xc1\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x8d"		=> "\xc1\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x8f"		=> "\xc1\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x90"		=> "\xc1\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x91"		=> "\xc1\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x92"		=> "\xc1\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x93"		=> "\xc1\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x96"		=> "\xc1\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x97"		=> "\xc1\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x99"		=> "\xc1\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x9a"		=> "\xc1\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x9b"		=> "\xc1\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x9c"		=> "\xc1\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x9d"		=> "\xc1\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x9e"		=> "\xc1\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xa2"		=> "\xc1\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xa3"		=> "\xc1\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xa2"		=> "\xc1\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x8b"		=> "\xc1\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x92"		=> "\xc1\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa5"		=> "\xc1\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\xb6"		=> "\xc1\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x9b"		=> "\xc1\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x92\x83"		=> "\xc1\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa9"		=> "\xc1\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa9"		=> "\xc1\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x94"		=> "\xc1\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb2"		=> "\xc1\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x9e"		=> "\xc1\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\xb0"		=> "\xc1\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x89"		=> "\xc1\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x9c"		=> "\xc1\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x9f"		=> "\xc1\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x98"		=> "\xc1\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x9b"		=> "\xc1\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb8"		=> "\xc1\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xbe"		=> "\xc1\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x8b"		=> "\xc1\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xbc"		=> "\xc1\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x83"		=> "\xc1\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xae"		=> "\xc1\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x89"		=> "\xc1\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x81"		=> "\xc1\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xb1"		=> "\xc1\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xaf"		=> "\xc1\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa4"		=> "\xc1\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x86"		=> "\xc1\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x8f"		=> "\xc1\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xbe"		=> "\xc1\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xae"		=> "\xc1\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x85"		=> "\xc1\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xa9"		=> "\xc1\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x8a"		=> "\xc1\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x9a"		=> "\xc1\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x97"		=> "\xc1\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x8e"		=> "\xc1\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa5"		=> "\xc1\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xbd"		=> "\xc1\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xa6"		=> "\xc1\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x86"		=> "\xc1\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x82"		=> "\xc1\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\xa3"		=> "\xc1\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x96"		=> "\xc1\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x99"		=> "\xc1\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x97"		=> "\xc1\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x82"		=> "\xc1\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x88"		=> "\xc1\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa3"		=> "\xc1\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x8e"		=> "\xc1\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb3"		=> "\xc1\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x97"		=> "\xc1\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xb7"		=> "\xc1\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x96"		=> "\xc1\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb4"		=> "\xc1\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xbb"		=> "\xc1\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb3\x9e"		=> "\xc1\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x8b"		=> "\xc1\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x9b"		=> "\xc1\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x81"		=> "\xc1\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x9d"		=> "\xc1\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x8e"		=> "\xc1\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb2"		=> "\xc1\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb1"		=> "\xc1\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\xb6"		=> "\xc1\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbe\x84"		=> "\xc1\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x83"		=> "\xc1\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb6"		=> "\xc1\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x9a"		=> "\xc1\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x8c"		=> "\xc1\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb5"		=> "\xc1\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xb5"		=> "\xc1\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xad"		=> "\xc1\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x86"		=> "\xc1\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa6"		=> "\xc1\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa4"		=> "\xc1\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x9c"		=> "\xc1\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x89"		=> "\xc1\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb4"		=> "\xc1\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xab"		=> "\xc1\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x8f"		=> "\xc1\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x99"		=> "\xc1\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x98"		=> "\xc1\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa4"		=> "\xc1\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x81"		=> "\xc1\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb3"		=> "\xc1\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xad"		=> "\xc1\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbe\x99"		=> "\xc1\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x8b"		=> "\xc1\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x99"		=> "\xc1\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\xbc"		=> "\xc1\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\xbf"		=> "\xc1\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xa4"		=> "\xc2\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xa7"		=> "\xc2\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xa8"		=> "\xc2\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xaa"		=> "\xc2\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xab"		=> "\xc2\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xac"		=> "\xc2\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xad"		=> "\xc2\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xaf"		=> "\xc2\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb2"		=> "\xc2\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb4"		=> "\xc2\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb5"		=> "\xc2\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb6"		=> "\xc2\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb7"		=> "\xc2\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb8"		=> "\xc2\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xb9"		=> "\xc2\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xba"		=> "\xc2\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xbd"		=> "\xc2\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xbe"		=> "\xc2\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xbf"		=> "\xc2\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x82"		=> "\xc2\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x87"		=> "\xc2\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x88"		=> "\xc2\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x89"		=> "\xc2\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x8a"		=> "\xc2\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x8e"		=> "\xc2\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x8f"		=> "\xc2\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x91"		=> "\xc2\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x93"		=> "\xc2\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x9a"		=> "\xc2\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x9b"		=> "\xc2\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x9d"		=> "\xc2\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x9e"		=> "\xc2\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x9f"		=> "\xc2\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xa1"		=> "\xc2\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xa3"		=> "\xc2\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xa4"		=> "\xc2\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xab"		=> "\xc2\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xac"		=> "\xc2\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xad"		=> "\xc2\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xae"		=> "\xc2\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xaf"		=> "\xc2\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb0"		=> "\xc2\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb2"		=> "\xc2\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb4"		=> "\xc2\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb9"		=> "\xc2\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xba"		=> "\xc2\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xbc"		=> "\xc2\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xbe"		=> "\xc2\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x80"		=> "\xc2\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x81"		=> "\xc2\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x84"		=> "\xc2\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x85"		=> "\xc2\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x87"		=> "\xc2\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x88"		=> "\xc2\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x89"		=> "\xc2\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x8e"		=> "\xc2\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x8f"		=> "\xc2\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x90"		=> "\xc2\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x91"		=> "\xc2\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x93"		=> "\xc2\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x95"		=> "\xc2\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x96"		=> "\xc2\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x97"		=> "\xc2\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x99"		=> "\xc2\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x9b"		=> "\xc2\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x9c"		=> "\xc2\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x9d"		=> "\xc2\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x9e"		=> "\xc2\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x9f"		=> "\xc2\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa0"		=> "\xc2\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa1"		=> "\xc2\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa2"		=> "\xc2\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa3"		=> "\xc2\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa4"		=> "\xc2\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa5"		=> "\xc2\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa6"		=> "\xc2\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa7"		=> "\xc2\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xa8"		=> "\xc2\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xab"		=> "\xc2\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xac"		=> "\xc2\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xad"		=> "\xc2\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xae"		=> "\xc2\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xaf"		=> "\xc2\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb0"		=> "\xc2\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb2"		=> "\xc2\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb3"		=> "\xc2\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb4"		=> "\xc2\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb5"		=> "\xc2\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb6"		=> "\xc2\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb7"		=> "\xc2\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb8"		=> "\xc2\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xb9"		=> "\xc2\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xba"		=> "\xc2\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xbb"		=> "\xc2\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xbc"		=> "\xc2\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xbd"		=> "\xc2\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x86"		=> "\xc2\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x84"		=> "\xc2\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa2"		=> "\xc2\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x87"		=> "\xc2\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\xbc"		=> "\xc2\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x84"		=> "\xc2\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x82"		=> "\xc2\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x93"		=> "\xc2\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x8f"		=> "\xc2\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x8b"		=> "\xc2\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa6"		=> "\xc2\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa2"		=> "\xc2\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x85"		=> "\xc2\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x90"		=> "\xc2\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x89"		=> "\xc2\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb3"		=> "\xc2\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa4"		=> "\xc2\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x8f"		=> "\xc2\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb2\x81"		=> "\xc2\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xba\x93"		=> "\xc2\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x8c"		=> "\xc2\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\xb2"		=> "\xc2\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xaf"		=> "\xc2\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x82"		=> "\xc2\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\xbf"		=> "\xc2\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x9e"		=> "\xc2\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x84"		=> "\xc2\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x95"		=> "\xc2\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x86"		=> "\xc2\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\xae"		=> "\xc2\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xb4"		=> "\xc2\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x95"		=> "\xc2\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x9d"		=> "\xc2\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa3"		=> "\xc2\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x85"		=> "\xc2\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa5"		=> "\xc2\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa1"		=> "\xc2\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x95"		=> "\xc2\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x91"		=> "\xc2\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xaf"		=> "\xc2\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x8b"		=> "\xc2\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x87"		=> "\xc2\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa4"		=> "\xc2\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xbf"		=> "\xc2\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa6"		=> "\xc2\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x9b"		=> "\xc2\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xaa"		=> "\xc2\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa6"		=> "\xc2\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb5"		=> "\xc2\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb1"		=> "\xc2\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa0"		=> "\xc2\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa5"		=> "\xc2\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa1"		=> "\xc2\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xae"		=> "\xc2\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa6"		=> "\xc2\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x91"		=> "\xc2\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa6"		=> "\xc2\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb6"		=> "\xc2\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xba"		=> "\xc2\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x9d"		=> "\xc2\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xba"		=> "\xc2\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x97"		=> "\xc2\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xbb"		=> "\xc2\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xa3"		=> "\xc2\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xa9"		=> "\xc2\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\xa1"		=> "\xc2\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb8"		=> "\xc2\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xbd"		=> "\xc2\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x9b"		=> "\xc2\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x86"		=> "\xc2\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x9c"		=> "\xc2\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x88"		=> "\xc2\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xba\xbb"		=> "\xc2\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x9b"		=> "\xc2\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x81"		=> "\xc2\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x82"		=> "\xc2\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xac"		=> "\xc2\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x82"		=> "\xc2\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x9b"		=> "\xc2\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x97"		=> "\xc2\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x8b"		=> "\xc2\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb0"		=> "\xc2\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xba\xa6"		=> "\xc2\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x96"		=> "\xc2\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x88"		=> "\xc2\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x89"		=> "\xc2\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x92"		=> "\xc2\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x92"		=> "\xc2\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xae"		=> "\xc2\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa1"		=> "\xc2\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x93"		=> "\xc2\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xbc"		=> "\xc2\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xa2"		=> "\xc2\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xab"		=> "\xc2\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\xbe"		=> "\xc3\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x81"		=> "\xc3\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x82"		=> "\xc3\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x85"		=> "\xc3\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x88"		=> "\xc3\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x8a"		=> "\xc3\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x8d"		=> "\xc3\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x8e"		=> "\xc3\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x8f"		=> "\xc3\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x90"		=> "\xc3\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x91"		=> "\xc3\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x92"		=> "\xc3\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x94"		=> "\xc3\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x95"		=> "\xc3\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x97"		=> "\xc3\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x99"		=> "\xc3\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x9e"		=> "\xc3\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa3"		=> "\xc3\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa6"		=> "\xc3\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa7"		=> "\xc3\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa8"		=> "\xc3\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xac"		=> "\xc3\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb0"		=> "\xc3\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb3"		=> "\xc3\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb5"		=> "\xc3\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb6"		=> "\xc3\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb8"		=> "\xc3\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb9"		=> "\xc3\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xbb"		=> "\xc3\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x85"		=> "\xc3\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x87"		=> "\xc3\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x88"		=> "\xc3\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x89"		=> "\xc3\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x8a"		=> "\xc3\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x8b"		=> "\xc3\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x8f"		=> "\xc3\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x90"		=> "\xc3\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x91"		=> "\xc3\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x92"		=> "\xc3\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x93"		=> "\xc3\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x94"		=> "\xc3\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x95"		=> "\xc3\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x98"		=> "\xc3\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x9f"		=> "\xc3\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xa0"		=> "\xc3\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xa2"		=> "\xc3\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xa3"		=> "\xc3\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xa6"		=> "\xc3\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xae"		=> "\xc3\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb5"		=> "\xc3\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb7"		=> "\xc3\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb9"		=> "\xc3\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xbb"		=> "\xc3\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xbe"		=> "\xc3\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xbf"		=> "\xc3\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x80"		=> "\xc3\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x81"		=> "\xc3\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x83"		=> "\xc3\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x84"		=> "\xc3\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x85"		=> "\xc3\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x87"		=> "\xc3\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x88"		=> "\xc3\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x8b"		=> "\xc3\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x8c"		=> "\xc3\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x95"		=> "\xc3\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x97"		=> "\xc3\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x99"		=> "\xc3\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x9b"		=> "\xc3\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x9c"		=> "\xc3\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x9d"		=> "\xc3\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x9f"		=> "\xc3\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa0"		=> "\xc3\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa1"		=> "\xc3\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa2"		=> "\xc3\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa3"		=> "\xc3\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa4"		=> "\xc3\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa5"		=> "\xc3\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa6"		=> "\xc3\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa7"		=> "\xc3\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa8"		=> "\xc3\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xa9"		=> "\xc3\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xaa"		=> "\xc3\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xab"		=> "\xc3\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xad"		=> "\xc3\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xae"		=> "\xc3\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb0"		=> "\xc3\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb3"		=> "\xc3\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb4"		=> "\xc3\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb5"		=> "\xc3\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb7"		=> "\xc3\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb9"		=> "\xc3\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xba"		=> "\xc3\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xbb"		=> "\xc3\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xbc"		=> "\xc3\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xbd"		=> "\xc3\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xbf"		=> "\xc3\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa9"		=> "\xc3\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x92"		=> "\xc3\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xab"		=> "\xc3\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb2"		=> "\xc3\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x93"		=> "\xc3\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x99"		=> "\xc3\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xbd"		=> "\xc3\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xab"		=> "\xc3\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x85"		=> "\xc3\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x9a"		=> "\xc3\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x9b"		=> "\xc3\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x9b"		=> "\xc3\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x86"		=> "\xc3\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xaf"		=> "\xc3\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x82"		=> "\xc3\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x92"		=> "\xc3\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xbd"		=> "\xc3\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x8c"		=> "\xc3\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb8"		=> "\xc3\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x88"		=> "\xc3\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xab"		=> "\xc3\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x9a"		=> "\xc3\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\x85"		=> "\xc3\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xb6"		=> "\xc3\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x89"		=> "\xc3\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa4"		=> "\xc3\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa1"		=> "\xc3\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x89"		=> "\xc3\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x92"		=> "\xc3\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x81"		=> "\xc3\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x8f"		=> "\xc3\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x8e"		=> "\xc3\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa7"		=> "\xc3\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x90"		=> "\xc3\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xb9"		=> "\xc3\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\x9a"		=> "\xc3\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xa8"		=> "\xc3\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb7"		=> "\xc3\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xac"		=> "\xc3\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x8c"		=> "\xc3\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x99"		=> "\xc3\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\xac"		=> "\xc3\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x9f"		=> "\xc3\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xb0"		=> "\xc3\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x9b"		=> "\xc3\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa6"		=> "\xc3\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x9f"		=> "\xc3\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xaf"		=> "\xc3\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x9a"		=> "\xc3\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xa1"		=> "\xc3\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x9c"		=> "\xc3\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb7"		=> "\xc3\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x9c"		=> "\xc3\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa5"		=> "\xc3\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb3"		=> "\xc3\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x98"		=> "\xc3\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x85"		=> "\xc3\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x8c"		=> "\xc3\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x9c"		=> "\xc3\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x86"		=> "\xc3\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x82"		=> "\xc3\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x89"		=> "\xc3\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa0"		=> "\xc3\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb5"		=> "\xc3\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x95"		=> "\xc3\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x8d"		=> "\xc3\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x89"		=> "\xc3\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa9"		=> "\xc3\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x85"		=> "\xc3\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xa2"		=> "\xc3\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x97"		=> "\xc3\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x8f"		=> "\xc3\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x84"		=> "\xc3\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x90"		=> "\xc3\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x92"		=> "\xc3\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xba"		=> "\xc3\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x99"		=> "\xc3\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x99"		=> "\xc3\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x91"		=> "\xc3\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xad"		=> "\xc3\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x91"		=> "\xc3\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xbf"		=> "\xc3\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xbf"		=> "\xc3\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x8f"		=> "\xc3\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xaf"		=> "\xc3\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xbd"		=> "\xc3\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x8e"		=> "\xc3\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x9f"		=> "\xc3\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xa3"		=> "\xc3\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xad"		=> "\xc3\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x8d"		=> "\xc3\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xbd"		=> "\xc3\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xac"		=> "\xc3\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb8"		=> "\xc3\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x80"		=> "\xc4\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x81"		=> "\xc4\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x82"		=> "\xc4\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x83"		=> "\xc4\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x84"		=> "\xc4\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x85"		=> "\xc4\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x87"		=> "\xc4\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x89"		=> "\xc4\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x8d"		=> "\xc4\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x8e"		=> "\xc4\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x8f"		=> "\xc4\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x92"		=> "\xc4\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x96"		=> "\xc4\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x97"		=> "\xc4\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x98"		=> "\xc4\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x9b"		=> "\xc4\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x9c"		=> "\xc4\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x9d"		=> "\xc4\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x9e"		=> "\xc4\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x9f"		=> "\xc4\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa1"		=> "\xc4\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa2"		=> "\xc4\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa3"		=> "\xc4\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa4"		=> "\xc4\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa6"		=> "\xc4\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa8"		=> "\xc4\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xaa"		=> "\xc4\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xab"		=> "\xc4\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xac"		=> "\xc4\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xaf"		=> "\xc4\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb2"		=> "\xc4\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb3"		=> "\xc4\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb5"		=> "\xc4\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb6"		=> "\xc4\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb7"		=> "\xc4\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb8"		=> "\xc4\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x81"		=> "\xc4\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x83"		=> "\xc4\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x84"		=> "\xc4\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x85"		=> "\xc4\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x86"		=> "\xc4\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x87"		=> "\xc4\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x89"		=> "\xc4\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x8b"		=> "\xc4\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x8c"		=> "\xc4\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x8d"		=> "\xc4\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x8e"		=> "\xc4\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x90"		=> "\xc4\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x92"		=> "\xc4\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x93"		=> "\xc4\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x94"		=> "\xc4\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x95"		=> "\xc4\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x96"		=> "\xc4\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x97"		=> "\xc4\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x99"		=> "\xc4\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x9a"		=> "\xc4\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x9e"		=> "\xc4\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x9f"		=> "\xc4\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa0"		=> "\xc4\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa1"		=> "\xc4\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa2"		=> "\xc4\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa4"		=> "\xc4\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa5"		=> "\xc4\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa7"		=> "\xc4\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa9"		=> "\xc4\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xab"		=> "\xc4\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xac"		=> "\xc4\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xad"		=> "\xc4\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xae"		=> "\xc4\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xaf"		=> "\xc4\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb0"		=> "\xc4\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb1"		=> "\xc4\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb2"		=> "\xc4\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb4"		=> "\xc4\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb5"		=> "\xc4\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb6"		=> "\xc4\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb7"		=> "\xc4\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb8"		=> "\xc4\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb9"		=> "\xc4\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xbc"		=> "\xc4\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xbd"		=> "\xc4\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xbe"		=> "\xc4\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xbf"		=> "\xc4\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x84"		=> "\xc4\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x85"		=> "\xc4\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x87"		=> "\xc4\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x88"		=> "\xc4\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x89"		=> "\xc4\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x8b"		=> "\xc4\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x8d"		=> "\xc4\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x8e"		=> "\xc4\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x8f"		=> "\xc4\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x90"		=> "\xc4\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x91"		=> "\xc4\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x92"		=> "\xc4\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x93"		=> "\xc4\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xb9"		=> "\xc4\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x91"		=> "\xc4\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xa1"		=> "\xc4\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x9c"		=> "\xc4\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\xa8"		=> "\xc4\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xa9"		=> "\xc4\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xad\x94"		=> "\xc4\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xb9"		=> "\xc4\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xab"		=> "\xc4\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xab"		=> "\xc4\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xa8"		=> "\xc4\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x98"		=> "\xc4\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xab"		=> "\xc4\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xa0"		=> "\xc4\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x9e"		=> "\xc4\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x8c"		=> "\xc4\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x8b"		=> "\xc4\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x9f"		=> "\xc4\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x90"		=> "\xc4\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x87"		=> "\xc4\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa1"		=> "\xc4\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa9"		=> "\xc4\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x86"		=> "\xc4\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x8d"		=> "\xc4\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x93"		=> "\xc4\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\xae"		=> "\xc4\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x95"		=> "\xc4\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x9f"		=> "\xc4\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x95"		=> "\xc4\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xa8"		=> "\xc4\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xae"		=> "\xc4\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa6"		=> "\xc4\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa7"		=> "\xc4\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x86"		=> "\xc4\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xbf"		=> "\xc4\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xaa"		=> "\xc4\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x90"		=> "\xc4\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa0"		=> "\xc4\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa3"		=> "\xc4\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x9c"		=> "\xc4\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb3"		=> "\xc4\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x96"		=> "\xc4\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x83"		=> "\xc4\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb6"		=> "\xc4\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x90"		=> "\xc4\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x88"		=> "\xc4\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x97"		=> "\xc4\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb7"		=> "\xc4\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\xbe"		=> "\xc4\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x8a"		=> "\xc4\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa0"		=> "\xc4\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x91"		=> "\xc4\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xbc"		=> "\xc4\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb9"		=> "\xc4\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x96"		=> "\xc4\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa2"		=> "\xc4\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x81"		=> "\xc4\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x85"		=> "\xc4\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\xa9"		=> "\xc4\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xbd"		=> "\xc4\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xae"		=> "\xc4\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x93"		=> "\xc4\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xaa"		=> "\xc4\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa5"		=> "\xc4\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xbc"		=> "\xc4\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x9f"		=> "\xc4\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa0"		=> "\xc4\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xbf"		=> "\xc4\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xbb"		=> "\xc4\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x86"		=> "\xc4\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xba"		=> "\xc4\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xab"		=> "\xc4\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x88"		=> "\xc4\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb4"		=> "\xc4\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xbe"		=> "\xc4\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb5"		=> "\xc4\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xbb"		=> "\xc4\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb5"		=> "\xc4\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x98"		=> "\xc4\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xbf"		=> "\xc4\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\x9f"		=> "\xc4\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xbf"		=> "\xc4\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x8f"		=> "\xc4\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x82"		=> "\xc4\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xbd"		=> "\xc4\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xae"		=> "\xc4\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x8a"		=> "\xc4\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x8d"		=> "\xc4\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x85"		=> "\xc4\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa8"		=> "\xc4\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xa0"		=> "\xc4\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x9e"		=> "\xc4\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x9d"		=> "\xc4\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x81"		=> "\xc4\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x94"		=> "\xc5\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x95"		=> "\xc5\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x96"		=> "\xc5\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x97"		=> "\xc5\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x98"		=> "\xc5\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x99"		=> "\xc5\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x9a"		=> "\xc5\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x9b"		=> "\xc5\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x9c"		=> "\xc5\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x9d"		=> "\xc5\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x9e"		=> "\xc5\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x9f"		=> "\xc5\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa0"		=> "\xc5\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa1"		=> "\xc5\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa2"		=> "\xc5\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa4"		=> "\xc5\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa5"		=> "\xc5\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa6"		=> "\xc5\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa8"		=> "\xc5\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xa9"		=> "\xc5\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xab"		=> "\xc5\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xae"		=> "\xc5\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xaf"		=> "\xc5\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb0"		=> "\xc5\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb1"		=> "\xc5\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb2"		=> "\xc5\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb5"		=> "\xc5\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb6"		=> "\xc5\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb7"		=> "\xc5\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb8"		=> "\xc5\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb9"		=> "\xc5\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xba"		=> "\xc5\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xbd"		=> "\xc5\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xbf"		=> "\xc5\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x83"		=> "\xc5\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x87"		=> "\xc5\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x88"		=> "\xc5\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x89"		=> "\xc5\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x8a"		=> "\xc5\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x8b"		=> "\xc5\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x8e"		=> "\xc5\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x8f"		=> "\xc5\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x91"		=> "\xc5\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x93"		=> "\xc5\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x95"		=> "\xc5\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x96"		=> "\xc5\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x97"		=> "\xc5\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x98"		=> "\xc5\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x99"		=> "\xc5\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x9a"		=> "\xc5\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x9d"		=> "\xc5\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xa0"		=> "\xc5\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xa4"		=> "\xc5\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xa5"		=> "\xc5\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xa6"		=> "\xc5\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xa7"		=> "\xc5\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xa9"		=> "\xc5\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xae"		=> "\xc5\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb2"		=> "\xc5\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xba"		=> "\xc5\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xbc"		=> "\xc5\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xbd"		=> "\xc5\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xbf"		=> "\xc5\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x80"		=> "\xc5\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x81"		=> "\xc5\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x82"		=> "\xc5\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x83"		=> "\xc5\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x85"		=> "\xc5\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x86"		=> "\xc5\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x88"		=> "\xc5\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x8a"		=> "\xc5\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x8c"		=> "\xc5\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x8d"		=> "\xc5\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x8e"		=> "\xc5\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x90"		=> "\xc5\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x91"		=> "\xc5\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x92"		=> "\xc5\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x93"		=> "\xc5\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x94"		=> "\xc5\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x95"		=> "\xc5\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x96"		=> "\xc5\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x97"		=> "\xc5\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x99"		=> "\xc5\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x9b"		=> "\xc5\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x9c"		=> "\xc5\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x9d"		=> "\xc5\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x9e"		=> "\xc5\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa0"		=> "\xc5\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa1"		=> "\xc5\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa2"		=> "\xc5\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa3"		=> "\xc5\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa4"		=> "\xc5\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa5"		=> "\xc5\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa6"		=> "\xc5\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa7"		=> "\xc5\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xa9"		=> "\xc5\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa7"		=> "\xc5\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x9e"		=> "\xc5\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x9b"		=> "\xc5\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xad"		=> "\xc5\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xae"		=> "\xc5\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xbd"		=> "\xc5\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x93"		=> "\xc5\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x93"		=> "\xc5\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x9c"		=> "\xc5\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x84"		=> "\xc5\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb4"		=> "\xc5\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xaa"		=> "\xc5\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x92"		=> "\xc5\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb3"		=> "\xc5\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x96"		=> "\xc5\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x90"		=> "\xc5\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x9f"		=> "\xc5\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xaa"		=> "\xc5\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xa6"		=> "\xc5\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xaf"		=> "\xc5\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xba"		=> "\xc5\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa6"		=> "\xc5\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa7"		=> "\xc5\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xa5"		=> "\xc5\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb4"		=> "\xc5\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x95"		=> "\xc5\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x95"		=> "\xc5\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb6"		=> "\xc5\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa4"		=> "\xc5\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xaa"		=> "\xc5\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb4"		=> "\xc5\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xac"		=> "\xc5\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x95"		=> "\xc5\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x95"		=> "\xc5\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb6"		=> "\xc5\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x8d"		=> "\xc5\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x92"		=> "\xc5\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x8c"		=> "\xc5\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x98"		=> "\xc5\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x83"		=> "\xc5\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xbe"		=> "\xc5\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x80"		=> "\xc5\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x98"		=> "\xc5\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x98"		=> "\xc5\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa3\x90"		=> "\xc5\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xbc"		=> "\xc5\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x94"		=> "\xc5\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa4"		=> "\xc5\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x9b"		=> "\xc5\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x93"		=> "\xc5\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x9e"		=> "\xc5\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x81"		=> "\xc5\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xaa"		=> "\xc5\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x96"		=> "\xc5\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x9b"		=> "\xc5\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x86"		=> "\xc5\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa8"		=> "\xc5\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xae"		=> "\xc5\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x8d"		=> "\xc5\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x91"		=> "\xc5\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa1"		=> "\xc5\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb8"		=> "\xc5\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x9a"		=> "\xc5\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb9"		=> "\xc5\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb4"		=> "\xc5\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x94"		=> "\xc5\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xaa"		=> "\xc5\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x8d"		=> "\xc5\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa9"		=> "\xc5\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x9b"		=> "\xc5\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb7"		=> "\xc5\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x86"		=> "\xc5\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb0"		=> "\xc5\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa8"		=> "\xc5\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb9"		=> "\xc5\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\x8e"		=> "\xc5\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xad"		=> "\xc5\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xac"		=> "\xc5\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x9a"		=> "\xc5\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xbc"		=> "\xc5\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\xb7"		=> "\xc5\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xa8"		=> "\xc5\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x8b"		=> "\xc5\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\x8f"		=> "\xc5\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa7"		=> "\xc5\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb0"		=> "\xc5\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xaf"		=> "\xc5\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x92"		=> "\xc5\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\xb9"		=> "\xc5\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb9"		=> "\xc5\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xab"		=> "\xc5\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x88"		=> "\xc5\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb5"		=> "\xc5\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x97"		=> "\xc5\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xaa"		=> "\xc6\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xab"		=> "\xc6\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xac"		=> "\xc6\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xad"		=> "\xc6\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb1"		=> "\xc6\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb5"		=> "\xc6\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb6"		=> "\xc6\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb7"		=> "\xc6\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb8"		=> "\xc6\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xbb"		=> "\xc6\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xbc"		=> "\xc6\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x80"		=> "\xc6\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x81"		=> "\xc6\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x83"		=> "\xc6\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x85"		=> "\xc6\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x86"		=> "\xc6\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x87"		=> "\xc6\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x89"		=> "\xc6\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x8c"		=> "\xc6\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x90"		=> "\xc6\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x93"		=> "\xc6\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x94"		=> "\xc6\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x95"		=> "\xc6\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x96"		=> "\xc6\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x9a"		=> "\xc6\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x9b"		=> "\xc6\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x9e"		=> "\xc6\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa0"		=> "\xc6\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa2"		=> "\xc6\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa3"		=> "\xc6\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa7"		=> "\xc6\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb2"		=> "\xc6\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb5"		=> "\xc6\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb6"		=> "\xc6\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xba"		=> "\xc6\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xbb"		=> "\xc6\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xbc"		=> "\xc6\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xbf"		=> "\xc6\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x80"		=> "\xc6\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x82"		=> "\xc6\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x83"		=> "\xc6\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x85"		=> "\xc6\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x86"		=> "\xc6\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x89"		=> "\xc6\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x90"		=> "\xc6\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x96"		=> "\xc6\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x99"		=> "\xc6\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x9a"		=> "\xc6\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x9d"		=> "\xc6\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa2"		=> "\xc6\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa7"		=> "\xc6\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa8"		=> "\xc6\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa9"		=> "\xc6\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xaa"		=> "\xc6\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xac"		=> "\xc6\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xad"		=> "\xc6\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xae"		=> "\xc6\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb0"		=> "\xc6\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb2"		=> "\xc6\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb3"		=> "\xc6\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb5"		=> "\xc6\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb6"		=> "\xc6\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb8"		=> "\xc6\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xba"		=> "\xc6\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xbc"		=> "\xc6\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xbd"		=> "\xc6\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xbe"		=> "\xc6\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xbf"		=> "\xc6\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x80"		=> "\xc6\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x8a"		=> "\xc6\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x8b"		=> "\xc6\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x8d"		=> "\xc6\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x90"		=> "\xc6\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x92"		=> "\xc6\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x93"		=> "\xc6\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x96"		=> "\xc6\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x98"		=> "\xc6\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x99"		=> "\xc6\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x9d"		=> "\xc6\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x9e"		=> "\xc6\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x9f"		=> "\xc6\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa0"		=> "\xc6\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa1"		=> "\xc6\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa2"		=> "\xc6\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa3"		=> "\xc6\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa4"		=> "\xc6\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa5"		=> "\xc6\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa6"		=> "\xc6\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xa9"		=> "\xc6\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xaa"		=> "\xc6\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xae"		=> "\xc6\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb0"		=> "\xc6\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb2"		=> "\xc6\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb7"		=> "\xc6\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xbb"		=> "\xc6\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xbd"		=> "\xc6\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa4"		=> "\xc6\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xbe"		=> "\xc6\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xb2"		=> "\xc6\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xae"		=> "\xc6\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xb9"		=> "\xc6\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x9e"		=> "\xc6\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xbb"		=> "\xc6\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x81"		=> "\xc6\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xac"		=> "\xc6\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x87"		=> "\xc6\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x8f"		=> "\xc6\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x87"		=> "\xc6\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x97"		=> "\xc6\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa3\x98"		=> "\xc6\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x82"		=> "\xc6\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa2"		=> "\xc6\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa8"		=> "\xc6\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x87"		=> "\xc6\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa5"		=> "\xc6\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xbc"		=> "\xc6\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x91"		=> "\xc6\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xab"		=> "\xc6\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x81"		=> "\xc6\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x98"		=> "\xc6\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x92"		=> "\xc6\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xaa"		=> "\xc6\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb9"		=> "\xc6\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x8d"		=> "\xc6\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb3"		=> "\xc6\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xad"		=> "\xc6\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xb6"		=> "\xc6\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x84"		=> "\xc6\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x8f"		=> "\xc6\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa1"		=> "\xc6\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xbc"		=> "\xc6\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x87"		=> "\xc6\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x86"		=> "\xc6\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb4"		=> "\xc6\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xad\x84"		=> "\xc6\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xab"		=> "\xc6\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x95"		=> "\xc6\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x96"		=> "\xc6\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x91"		=> "\xc6\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xba"		=> "\xc6\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x86"		=> "\xc6\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x86"		=> "\xc6\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa1"		=> "\xc6\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa9"		=> "\xc6\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb2"		=> "\xc6\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x94"		=> "\xc6\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb4"		=> "\xc6\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x83"		=> "\xc6\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xae"		=> "\xc6\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xa6"		=> "\xc6\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb1"		=> "\xc6\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x9d"		=> "\xc6\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x80\x91"		=> "\xc6\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x9f"		=> "\xc6\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xba"		=> "\xc6\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x96"		=> "\xc6\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x9a"		=> "\xc6\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xbb"		=> "\xc6\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x83"		=> "\xc6\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x84"		=> "\xc6\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x86"		=> "\xc6\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x92"		=> "\xc6\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x8f"		=> "\xc6\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb6"		=> "\xc6\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x8b"		=> "\xc6\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x87"		=> "\xc6\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa7"		=> "\xc6\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\xa6"		=> "\xc6\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x8e"		=> "\xc6\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x90"		=> "\xc6\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbd\x90"		=> "\xc6\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x97"		=> "\xc6\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x88"		=> "\xc6\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x81"		=> "\xc6\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x91"		=> "\xc6\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb7"		=> "\xc6\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x82"		=> "\xc6\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x9e"		=> "\xc6\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x81"		=> "\xc6\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xaf"		=> "\xc6\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x91"		=> "\xc6\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x8c"		=> "\xc6\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa8"		=> "\xc6\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x94"		=> "\xc6\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x84"		=> "\xc6\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x83"		=> "\xc6\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xbd"		=> "\xc6\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa3"		=> "\xc6\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xab"		=> "\xc6\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x90"		=> "\xc6\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xbe"		=> "\xc7\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xbf"		=> "\xc7\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x81"		=> "\xc7\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x82"		=> "\xc7\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x84"		=> "\xc7\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x85"		=> "\xc7\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x88"		=> "\xc7\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x8a"		=> "\xc7\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x8b"		=> "\xc7\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x8c"		=> "\xc7\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x8d"		=> "\xc7\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x8e"		=> "\xc7\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x93"		=> "\xc7\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x95"		=> "\xc7\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x96"		=> "\xc7\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x97"		=> "\xc7\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x98"		=> "\xc7\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x99"		=> "\xc7\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x9d"		=> "\xc7\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa2"		=> "\xc7\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb0"		=> "\xc7\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb1"		=> "\xc7\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb2"		=> "\xc7\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb3"		=> "\xc7\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb4"		=> "\xc7\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb5"		=> "\xc7\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb6"		=> "\xc7\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb9"		=> "\xc7\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xba"		=> "\xc7\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xbe"		=> "\xc7\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xbf"		=> "\xc7\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x80"		=> "\xc7\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x81"		=> "\xc7\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x82"		=> "\xc7\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x83"		=> "\xc7\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x84"		=> "\xc7\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x87"		=> "\xc7\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x88"		=> "\xc7\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x8a"		=> "\xc7\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x8b"		=> "\xc7\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x8c"		=> "\xc7\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x8d"		=> "\xc7\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x8f"		=> "\xc7\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x90"		=> "\xc7\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x91"		=> "\xc7\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x94"		=> "\xc7\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x95"		=> "\xc7\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x96"		=> "\xc7\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x97"		=> "\xc7\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x99"		=> "\xc7\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x9a"		=> "\xc7\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x9d"		=> "\xc7\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x9f"		=> "\xc7\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa1"		=> "\xc7\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa2"		=> "\xc7\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa3"		=> "\xc7\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa4"		=> "\xc7\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa5"		=> "\xc7\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa6"		=> "\xc7\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa7"		=> "\xc7\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xac"		=> "\xc7\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xad"		=> "\xc7\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xae"		=> "\xc7\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xaf"		=> "\xc7\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb5"		=> "\xc7\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xbb"		=> "\xc7\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xbe"		=> "\xc7\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xbf"		=> "\xc7\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x82"		=> "\xc7\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x83"		=> "\xc7\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x84"		=> "\xc7\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x86"		=> "\xc7\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x88"		=> "\xc7\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x89"		=> "\xc7\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x8b"		=> "\xc7\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x8d"		=> "\xc7\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x8e"		=> "\xc7\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x90"		=> "\xc7\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x91"		=> "\xc7\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x92"		=> "\xc7\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x93"		=> "\xc7\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x95"		=> "\xc7\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x97"		=> "\xc7\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x99"		=> "\xc7\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x9a"		=> "\xc7\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x9b"		=> "\xc7\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x9e"		=> "\xc7\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa2"		=> "\xc7\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa3"		=> "\xc7\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa4"		=> "\xc7\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa6"		=> "\xc7\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa7"		=> "\xc7\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa8"		=> "\xc7\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xab"		=> "\xc7\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xac"		=> "\xc7\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xad"		=> "\xc7\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb0"		=> "\xc7\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xbd"		=> "\xc7\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb5"		=> "\xc7\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa6"		=> "\xc7\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x8e"		=> "\xc7\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x85"		=> "\xc7\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x83"		=> "\xc7\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x81"		=> "\xc7\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\xbe"		=> "\xc7\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x9f"		=> "\xc7\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa6"		=> "\xc7\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xbe"		=> "\xc7\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x94"		=> "\xc7\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xb1"		=> "\xc7\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xb3"		=> "\xc7\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x8d"		=> "\xc7\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x9c"		=> "\xc7\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa3"		=> "\xc7\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x85"		=> "\xc7\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb4"		=> "\xc7\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x91"		=> "\xc7\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x8c"		=> "\xc7\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa0"		=> "\xc7\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x89"		=> "\xc7\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xaa"		=> "\xc7\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x9b"		=> "\xc7\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x94"		=> "\xc7\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x8c"		=> "\xc7\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x99"		=> "\xc7\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb7"		=> "\xc7\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xba"		=> "\xc7\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xa2"		=> "\xc7\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\x87"		=> "\xc7\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xb9"		=> "\xc7\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb2"		=> "\xc7\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x84"		=> "\xc7\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xa5"		=> "\xc7\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa7"		=> "\xc7\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x94"		=> "\xc7\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa8"		=> "\xc7\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa7"		=> "\xc7\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9e\x98"		=> "\xc7\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xac"		=> "\xc7\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x98"		=> "\xc7\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xad"		=> "\xc7\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x8f"		=> "\xc7\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x8d"		=> "\xc7\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x87"		=> "\xc7\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x84"		=> "\xc7\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x94"		=> "\xc7\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xaf"		=> "\xc7\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x83"		=> "\xc7\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa6"		=> "\xc7\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xb5"		=> "\xc7\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb2"		=> "\xc7\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa6"		=> "\xc7\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xb4"		=> "\xc7\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xa4"		=> "\xc7\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb9"		=> "\xc7\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x92"		=> "\xc7\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xbd"		=> "\xc7\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x9d"		=> "\xc7\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x81"		=> "\xc7\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\x92"		=> "\xc7\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xbb"		=> "\xc7\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa2"		=> "\xc7\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xbe"		=> "\xc7\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xbf"		=> "\xc7\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x85"		=> "\xc7\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x8e"		=> "\xc7\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb4"		=> "\xc7\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb0"		=> "\xc7\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x85"		=> "\xc7\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xb7"		=> "\xc7\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb7"		=> "\xc7\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x86"		=> "\xc7\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xbc"		=> "\xc7\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb7"		=> "\xc7\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x8b"		=> "\xc7\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x98"		=> "\xc7\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb1"		=> "\xc7\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x83"		=> "\xc7\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x82"		=> "\xc7\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x9a"		=> "\xc7\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x8b"		=> "\xc7\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x85"		=> "\xc7\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x8b"		=> "\xc7\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xba"		=> "\xc7\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x86"		=> "\xc7\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb2"		=> "\xc7\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xaf"		=> "\xc7\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x88"		=> "\xc7\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xb1"		=> "\xc7\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa0"		=> "\xc7\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xae"		=> "\xc8\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xaf"		=> "\xc8\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb3"		=> "\xc8\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb4"		=> "\xc8\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb5"		=> "\xc8\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb6"		=> "\xc8\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb7"		=> "\xc8\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xba"		=> "\xc8\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xbb"		=> "\xc8\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xbc"		=> "\xc8\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xbe"		=> "\xc8\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xbf"		=> "\xc8\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x80"		=> "\xc8\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x82"		=> "\xc8\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x85"		=> "\xc8\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x87"		=> "\xc8\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x88"		=> "\xc8\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x89"		=> "\xc8\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x8a"		=> "\xc8\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x90"		=> "\xc8\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x92"		=> "\xc8\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x93"		=> "\xc8\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x94"		=> "\xc8\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x95"		=> "\xc8\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x96"		=> "\xc8\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x97"		=> "\xc8\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x99"		=> "\xc8\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x9a"		=> "\xc8\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x9b"		=> "\xc8\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x9e"		=> "\xc8\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x9f"		=> "\xc8\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa0"		=> "\xc8\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa1"		=> "\xc8\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa2"		=> "\xc8\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa3"		=> "\xc8\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa9"		=> "\xc8\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xaa"		=> "\xc8\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xab"		=> "\xc8\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xac"		=> "\xc8\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xad"		=> "\xc8\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xae"		=> "\xc8\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xaf"		=> "\xc8\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb0"		=> "\xc8\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb2"		=> "\xc8\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb3"		=> "\xc8\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb4"		=> "\xc8\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb5"		=> "\xc8\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb6"		=> "\xc8\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb7"		=> "\xc8\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb9"		=> "\xc8\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xba"		=> "\xc8\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xbb"		=> "\xc8\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xbe"		=> "\xc8\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xbf"		=> "\xc8\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x80"		=> "\xc8\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x81"		=> "\xc8\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x82"		=> "\xc8\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x83"		=> "\xc8\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x84"		=> "\xc8\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x85"		=> "\xc8\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x87"		=> "\xc8\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x88"		=> "\xc8\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x89"		=> "\xc8\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x8a"		=> "\xc8\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x8b"		=> "\xc8\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x8c"		=> "\xc8\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x8d"		=> "\xc8\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x8e"		=> "\xc8\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x8f"		=> "\xc8\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x90"		=> "\xc8\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x92"		=> "\xc8\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x93"		=> "\xc8\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x94"		=> "\xc8\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x95"		=> "\xc8\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x96"		=> "\xc8\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x98"		=> "\xc8\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x9d"		=> "\xc8\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x9e"		=> "\xc8\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x9f"		=> "\xc8\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa0"		=> "\xc8\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa2"		=> "\xc8\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa4"		=> "\xc8\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa5"		=> "\xc8\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa6"		=> "\xc8\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa7"		=> "\xc8\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa8"		=> "\xc8\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xaa"		=> "\xc8\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xae"		=> "\xc8\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xaf"		=> "\xc8\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb0"		=> "\xc8\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb2"		=> "\xc8\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb4"		=> "\xc8\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb7"		=> "\xc8\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb9"		=> "\xc8\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xbb"		=> "\xc8\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xbc"		=> "\xc8\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x96"		=> "\xc8\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb6"		=> "\xc8\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbe\x8b"		=> "\xc8\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa3"		=> "\xc8\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xbb"		=> "\xc8\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x88"		=> "\xc8\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\xa7"		=> "\xc8\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x83"		=> "\xc8\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x9b"		=> "\xc8\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x89"		=> "\xc8\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa8"		=> "\xc8\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x8a"		=> "\xc8\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb3"		=> "\xc8\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xac"		=> "\xc8\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb8"		=> "\xc8\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x9d"		=> "\xc8\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xba"		=> "\xc8\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x94"		=> "\xc8\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb8"		=> "\xc8\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb4"		=> "\xc8\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\x8a"		=> "\xc8\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xb7"		=> "\xc8\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xae"		=> "\xc8\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x80"		=> "\xc8\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x99"		=> "\xc8\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa4"		=> "\xc8\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb6"		=> "\xc8\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x83"		=> "\xc8\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x89"		=> "\xc8\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x93"		=> "\xc8\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa4"		=> "\xc8\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xa4"		=> "\xc8\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x98"		=> "\xc8\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xb7"		=> "\xc8\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa9"		=> "\xc8\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb6"		=> "\xc8\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xb0"		=> "\xc8\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x95"		=> "\xc8\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb9"		=> "\xc8\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xad"		=> "\xc8\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xac"		=> "\xc8\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x81"		=> "\xc8\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xba"		=> "\xc8\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x8d"		=> "\xc8\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xa7"		=> "\xc8\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xbb"		=> "\xc8\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa4"		=> "\xc8\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x83"		=> "\xc8\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x8a"		=> "\xc8\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xab"		=> "\xc8\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x94"		=> "\xc8\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x8d"		=> "\xc8\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa5"		=> "\xc8\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x8e"		=> "\xc8\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb8"		=> "\xc8\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x89"		=> "\xc8\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa3"		=> "\xc8\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x8d"		=> "\xc8\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x94"		=> "\xc8\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xb6"		=> "\xc8\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb9"		=> "\xc8\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x92"		=> "\xc8\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x97"		=> "\xc8\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x89"		=> "\xc8\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x94"		=> "\xc8\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x89"		=> "\xc8\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb9"		=> "\xc8\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x95"		=> "\xc8\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x92"		=> "\xc8\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xba"		=> "\xc8\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x82"		=> "\xc8\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb1"		=> "\xc8\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xb3"		=> "\xc8\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x9d"		=> "\xc8\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xa5"		=> "\xc8\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa5"		=> "\xc8\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xaf"		=> "\xc8\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xae"		=> "\xc8\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x8a"		=> "\xc8\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x9e"		=> "\xc8\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x90"		=> "\xc8\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb0"		=> "\xc8\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa6"		=> "\xc8\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa5"		=> "\xc8\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xb1"		=> "\xc8\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x92"		=> "\xc8\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x92"		=> "\xc8\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa8"		=> "\xc8\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xae"		=> "\xc8\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb3\x83"		=> "\xc8\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x9e"		=> "\xc8\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x9b"		=> "\xc8\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x89"		=> "\xc8\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x81"		=> "\xc8\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xbd"		=> "\xc9\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xbe"		=> "\xc9\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xbf"		=> "\xc9\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x80"		=> "\xc9\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x81"		=> "\xc9\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x83"		=> "\xc9\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x84"		=> "\xc9\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x85"		=> "\xc9\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x86"		=> "\xc9\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x8a"		=> "\xc9\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x8d"		=> "\xc9\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x8f"		=> "\xc9\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x90"		=> "\xc9\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x91"		=> "\xc9\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x92"		=> "\xc9\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x93"		=> "\xc9\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x94"		=> "\xc9\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x95"		=> "\xc9\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x96"		=> "\xc9\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x98"		=> "\xc9\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x9a"		=> "\xc9\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x9b"		=> "\xc9\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x9d"		=> "\xc9\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x9e"		=> "\xc9\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x9f"		=> "\xc9\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa0"		=> "\xc9\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa2"		=> "\xc9\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa3"		=> "\xc9\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa4"		=> "\xc9\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa5"		=> "\xc9\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa6"		=> "\xc9\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa7"		=> "\xc9\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa8"		=> "\xc9\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa9"		=> "\xc9\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xaa"		=> "\xc9\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xab"		=> "\xc9\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xac"		=> "\xc9\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xad"		=> "\xc9\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xae"		=> "\xc9\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb0"		=> "\xc9\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb1"		=> "\xc9\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb3"		=> "\xc9\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb5"		=> "\xc9\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb6"		=> "\xc9\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb7"		=> "\xc9\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xbb"		=> "\xc9\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xbc"		=> "\xc9\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xbe"		=> "\xc9\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x80"		=> "\xc9\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x82"		=> "\xc9\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x83"		=> "\xc9\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x85"		=> "\xc9\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x86"		=> "\xc9\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x87"		=> "\xc9\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x88"		=> "\xc9\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x8b"		=> "\xc9\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x8c"		=> "\xc9\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x8e"		=> "\xc9\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x8f"		=> "\xc9\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x92"		=> "\xc9\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x94"		=> "\xc9\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x95"		=> "\xc9\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x97"		=> "\xc9\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x98"		=> "\xc9\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x99"		=> "\xc9\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x9a"		=> "\xc9\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x9b"		=> "\xc9\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x9c"		=> "\xc9\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x9e"		=> "\xc9\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa1"		=> "\xc9\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa2"		=> "\xc9\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa4"		=> "\xc9\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa7"		=> "\xc9\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa8"		=> "\xc9\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa9"		=> "\xc9\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xaa"		=> "\xc9\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xab"		=> "\xc9\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xad"		=> "\xc9\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xae"		=> "\xc9\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xaf"		=> "\xc9\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb1"		=> "\xc9\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb2"		=> "\xc9\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb3"		=> "\xc9\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb4"		=> "\xc9\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb5"		=> "\xc9\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb6"		=> "\xc9\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb7"		=> "\xc9\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb8"		=> "\xc9\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb9"		=> "\xc9\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xba"		=> "\xc9\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xbb"		=> "\xc9\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xbd"		=> "\xc9\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xbe"		=> "\xc9\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x80"		=> "\xc9\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x81"		=> "\xc9\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x82"		=> "\xc9\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x9e"		=> "\xc9\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xa3"		=> "\xc9\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x91"		=> "\xc9\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x93"		=> "\xc9\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa7"		=> "\xc9\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x94"		=> "\xc9\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x9a"		=> "\xc9\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xab"		=> "\xc9\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x82"		=> "\xc9\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\x9f"		=> "\xc9\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb2"		=> "\xc9\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa9"		=> "\xc9\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xae"		=> "\xc9\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa7"		=> "\xc9\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x8e"		=> "\xc9\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x82"		=> "\xc9\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x80"		=> "\xc9\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb9"		=> "\xc9\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x99"		=> "\xc9\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb1"		=> "\xc9\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xbb"		=> "\xc9\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa5"		=> "\xc9\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\x9e"		=> "\xc9\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x9b"		=> "\xc9\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x92"		=> "\xc9\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x8a"		=> "\xc9\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xab"		=> "\xc9\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x89"		=> "\xc9\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb1"		=> "\xc9\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xa0"		=> "\xc9\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xbd"		=> "\xc9\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xab"		=> "\xc9\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xaa"		=> "\xc9\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x95"		=> "\xc9\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x85"		=> "\xc9\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa1"		=> "\xc9\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xb3"		=> "\xc9\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x84"		=> "\xc9\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x95"		=> "\xc9\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x87"		=> "\xc9\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xae"		=> "\xc9\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x92"		=> "\xc9\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa4"		=> "\xc9\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x86"		=> "\xc9\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x8f"		=> "\xc9\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x8c"		=> "\xc9\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x8a"		=> "\xc9\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x9a"		=> "\xc9\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb3"		=> "\xc9\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa2"		=> "\xc9\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x8e"		=> "\xc9\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x8d"		=> "\xc9\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xa7"		=> "\xc9\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x8d"		=> "\xc9\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xba"		=> "\xc9\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xb6"		=> "\xc9\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x91"		=> "\xc9\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa8"		=> "\xc9\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb5"		=> "\xc9\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x8d"		=> "\xc9\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xa2"		=> "\xc9\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x8a"		=> "\xc9\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x87"		=> "\xc9\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x8c"		=> "\xc9\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x8d"		=> "\xc9\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa6"		=> "\xc9\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x84"		=> "\xc9\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x84"		=> "\xc9\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x91"		=> "\xc9\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x89"		=> "\xc9\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xbe"		=> "\xc9\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xbe"		=> "\xc9\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb7"		=> "\xc9\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb3"		=> "\xc9\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xbb"		=> "\xc9\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb8"		=> "\xc9\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xab"		=> "\xc9\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb1"		=> "\xc9\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xa0"		=> "\xc9\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x85"		=> "\xc9\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x9e"		=> "\xc9\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x88"		=> "\xc9\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa1"		=> "\xc9\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb6"		=> "\xc9\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x9a"		=> "\xc9\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xbe"		=> "\xc9\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x8e"		=> "\xc9\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x97"		=> "\xc9\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb0"		=> "\xc9\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x9f"		=> "\xc9\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa5"		=> "\xc9\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb2"		=> "\xc9\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x87"		=> "\xc9\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb3"		=> "\xc9\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x83"		=> "\xca\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x84"		=> "\xca\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x85"		=> "\xca\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x86"		=> "\xca\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x87"		=> "\xca\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x88"		=> "\xca\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x89"		=> "\xca\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x8a"		=> "\xca\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x8b"		=> "\xca\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x8d"		=> "\xca\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x8e"		=> "\xca\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x8f"		=> "\xca\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x90"		=> "\xca\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x92"		=> "\xca\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x94"		=> "\xca\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x95"		=> "\xca\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x96"		=> "\xca\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x98"		=> "\xca\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x99"		=> "\xca\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x9b"		=> "\xca\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x9c"		=> "\xca\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x9d"		=> "\xca\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x9e"		=> "\xca\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa0"		=> "\xca\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa2"		=> "\xca\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa3"		=> "\xca\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa4"		=> "\xca\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa5"		=> "\xca\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa6"		=> "\xca\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa7"		=> "\xca\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa8"		=> "\xca\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xa9"		=> "\xca\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xaa"		=> "\xca\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xad"		=> "\xca\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xae"		=> "\xca\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xaf"		=> "\xca\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb0"		=> "\xca\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb1"		=> "\xca\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb2"		=> "\xca\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb3"		=> "\xca\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb4"		=> "\xca\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb5"		=> "\xca\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb6"		=> "\xca\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xbe"		=> "\xca\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xbf"		=> "\xca\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x80"		=> "\xca\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x81"		=> "\xca\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x82"		=> "\xca\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x84"		=> "\xca\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x85"		=> "\xca\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x86"		=> "\xca\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x87"		=> "\xca\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x8b"		=> "\xca\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x8c"		=> "\xca\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x8d"		=> "\xca\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x8e"		=> "\xca\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x8f"		=> "\xca\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x90"		=> "\xca\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x91"		=> "\xca\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x92"		=> "\xca\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x93"		=> "\xca\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x94"		=> "\xca\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x95"		=> "\xca\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x97"		=> "\xca\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x98"		=> "\xca\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x9a"		=> "\xca\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x9b"		=> "\xca\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x9c"		=> "\xca\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x9d"		=> "\xca\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x9f"		=> "\xca\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa0"		=> "\xca\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa1"		=> "\xca\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa2"		=> "\xca\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa3"		=> "\xca\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa5"		=> "\xca\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa6"		=> "\xca\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa7"		=> "\xca\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa9"		=> "\xca\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xaa"		=> "\xca\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xab"		=> "\xca\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xac"		=> "\xca\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xad"		=> "\xca\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xae"		=> "\xca\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xaf"		=> "\xca\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb0"		=> "\xca\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb1"		=> "\xca\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb3"		=> "\xca\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb5"		=> "\xca\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb6"		=> "\xca\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb7"		=> "\xca\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb8"		=> "\xca\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xbc"		=> "\xca\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xbd"		=> "\xca\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xbf"		=> "\xca\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x80"		=> "\xca\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x81"		=> "\xca\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x81"		=> "\xca\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x9b"		=> "\xca\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa9"		=> "\xca\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x9c"		=> "\xca\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa3"		=> "\xca\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x88"		=> "\xca\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb1"		=> "\xca\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xae"		=> "\xca\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xbd"		=> "\xca\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xbf"		=> "\xca\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x97"		=> "\xca\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb8"		=> "\xca\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb1"		=> "\xca\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x81"		=> "\xca\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xb3"		=> "\xca\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xbe"		=> "\xca\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xb6"		=> "\xca\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x80"		=> "\xca\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa3\x9f"		=> "\xca\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x80"		=> "\xca\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x9e"		=> "\xca\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x86"		=> "\xca\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb2"		=> "\xca\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa2"		=> "\xca\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xbf"		=> "\xca\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x8e"		=> "\xca\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xb6"		=> "\xca\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x8b"		=> "\xca\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x8f"		=> "\xca\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa4\xba"		=> "\xca\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xab"		=> "\xca\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x96"		=> "\xca\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xbf"		=> "\xca\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x8b"		=> "\xca\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xad"		=> "\xca\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x93"		=> "\xca\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x9d"		=> "\xca\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xbf"		=> "\xca\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xaf"		=> "\xca\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x9c"		=> "\xca\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xac"		=> "\xca\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x82"		=> "\xca\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x95"		=> "\xca\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x8d"		=> "\xca\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x8a"		=> "\xca\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb0"		=> "\xca\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x8f"		=> "\xca\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x82"		=> "\xca\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x83"		=> "\xca\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa4"		=> "\xca\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x86"		=> "\xca\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x95"		=> "\xca\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb6"		=> "\xca\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x8b"		=> "\xca\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x96"		=> "\xca\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x88"		=> "\xca\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xbf"		=> "\xca\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x88"		=> "\xca\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xae"		=> "\xca\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x97"		=> "\xca\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xa6"		=> "\xca\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xbd"		=> "\xca\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xac"		=> "\xca\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa2"		=> "\xca\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb3"		=> "\xca\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x8a"		=> "\xca\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x92"		=> "\xca\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x93"		=> "\xca\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x94"		=> "\xca\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x92"		=> "\xca\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x91"		=> "\xca\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x8f"		=> "\xca\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa6"		=> "\xca\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x8e"		=> "\xca\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xb0"		=> "\xca\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x9f"		=> "\xca\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xaf"		=> "\xca\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x91"		=> "\xca\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\x99"		=> "\xca\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xb2"		=> "\xca\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x80"		=> "\xca\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x8d"		=> "\xca\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\xa0"		=> "\xca\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x9e"		=> "\xca\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xaf"		=> "\xca\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb0"		=> "\xca\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x91"		=> "\xca\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x9f"		=> "\xca\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x8d"		=> "\xca\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x96"		=> "\xca\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x85"		=> "\xca\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb6"		=> "\xca\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb0"		=> "\xca\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb1"		=> "\xca\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x82"		=> "\xcb\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x83"		=> "\xcb\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x86"		=> "\xcb\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x88"		=> "\xcb\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x89"		=> "\xcb\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x8a"		=> "\xcb\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x8b"		=> "\xcb\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x8c"		=> "\xcb\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x8d"		=> "\xcb\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x8e"		=> "\xcb\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x90"		=> "\xcb\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x91"		=> "\xcb\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x92"		=> "\xcb\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x93"		=> "\xcb\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x94"		=> "\xcb\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x95"		=> "\xcb\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x96"		=> "\xcb\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x97"		=> "\xcb\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x98"		=> "\xcb\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x99"		=> "\xcb\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x9a"		=> "\xcb\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x9d"		=> "\xcb\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x9e"		=> "\xcb\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x9f"		=> "\xcb\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa0"		=> "\xcb\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa1"		=> "\xcb\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa2"		=> "\xcb\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa3"		=> "\xcb\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa5"		=> "\xcb\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa6"		=> "\xcb\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa7"		=> "\xcb\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa9"		=> "\xcb\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xab"		=> "\xcb\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xac"		=> "\xcb\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xad"		=> "\xcb\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb1"		=> "\xcb\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb2"		=> "\xcb\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb3"		=> "\xcb\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb4"		=> "\xcb\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb5"		=> "\xcb\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb6"		=> "\xcb\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb8"		=> "\xcb\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xba"		=> "\xcb\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xbb"		=> "\xcb\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xbc"		=> "\xcb\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xbd"		=> "\xcb\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xbe"		=> "\xcb\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xbf"		=> "\xcb\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x80"		=> "\xcb\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x82"		=> "\xcb\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x83"		=> "\xcb\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x84"		=> "\xcb\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x85"		=> "\xcb\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x86"		=> "\xcb\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x87"		=> "\xcb\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x88"		=> "\xcb\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x8a"		=> "\xcb\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x8b"		=> "\xcb\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x8c"		=> "\xcb\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x8d"		=> "\xcb\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x8e"		=> "\xcb\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x91"		=> "\xcb\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x92"		=> "\xcb\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x94"		=> "\xcb\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x96"		=> "\xcb\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x97"		=> "\xcb\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x98"		=> "\xcb\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x99"		=> "\xcb\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x9a"		=> "\xcb\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x9b"		=> "\xcb\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x9d"		=> "\xcb\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x9e"		=> "\xcb\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x9f"		=> "\xcb\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa0"		=> "\xcb\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa1"		=> "\xcb\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa2"		=> "\xcb\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa3"		=> "\xcb\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa5"		=> "\xcb\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa6"		=> "\xcb\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa7"		=> "\xcb\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa8"		=> "\xcb\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xaa"		=> "\xcb\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xab"		=> "\xcb\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xac"		=> "\xcb\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xad"		=> "\xcb\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xae"		=> "\xcb\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xaf"		=> "\xcb\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb0"		=> "\xcb\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb1"		=> "\xcb\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb2"		=> "\xcb\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb3"		=> "\xcb\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb4"		=> "\xcb\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb5"		=> "\xcb\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb6"		=> "\xcb\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb7"		=> "\xcb\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb8"		=> "\xcb\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x95"		=> "\xcb\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb7"		=> "\xcb\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x8d"		=> "\xcb\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x94"		=> "\xcb\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb0"		=> "\xcb\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa9"		=> "\xcb\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x85"		=> "\xcb\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x93"		=> "\xcb\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb4"		=> "\xcb\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x9c"		=> "\xcb\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x8c"		=> "\xcb\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xbd"		=> "\xcb\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x81"		=> "\xcb\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb4"		=> "\xcb\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xa1"		=> "\xcb\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x8e"		=> "\xcb\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xae"		=> "\xcb\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xac"		=> "\xcb\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xba"		=> "\xcb\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x9c"		=> "\xcb\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb4"		=> "\xcb\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x95"		=> "\xcb\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x94"		=> "\xcb\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x81"		=> "\xcb\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xaf"		=> "\xcb\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x95"		=> "\xcb\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb6"		=> "\xcb\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x9d"		=> "\xcb\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x81"		=> "\xcb\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb8"		=> "\xcb\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x9d"		=> "\xcb\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xbb"		=> "\xcb\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x86"		=> "\xcb\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xba"		=> "\xcb\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa3"		=> "\xcb\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x9b"		=> "\xcb\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xba"		=> "\xcb\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xbc"		=> "\xcb\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb2"		=> "\xcb\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb3"		=> "\xcb\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xbe"		=> "\xcb\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb8"		=> "\xcb\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x82"		=> "\xcb\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x82"		=> "\xcb\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x81"		=> "\xcb\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x8b"		=> "\xcb\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xbc"		=> "\xcb\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb5"		=> "\xcb\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x9c"		=> "\xcb\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x98"		=> "\xcb\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x9e"		=> "\xcb\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xbd"		=> "\xcb\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x8f"		=> "\xcb\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xa5"		=> "\xcb\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x97"		=> "\xcb\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa0"		=> "\xcb\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x9f"		=> "\xcb\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x9f"		=> "\xcb\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xb3"		=> "\xcb\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x91"		=> "\xcb\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xaf"		=> "\xcb\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xbf"		=> "\xcb\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x89"		=> "\xcb\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x83"		=> "\xcb\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xb8"		=> "\xcb\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x9c"		=> "\xcb\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\x97"		=> "\xcb\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xbd"		=> "\xcb\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x8b"		=> "\xcb\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x8f"		=> "\xcb\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa5"		=> "\xcb\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xab\x93"		=> "\xcb\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x8e"		=> "\xcb\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x81"		=> "\xcb\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\x97"		=> "\xcb\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x82"		=> "\xcb\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\xa7"		=> "\xcb\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x9f"		=> "\xcb\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x99"		=> "\xcb\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x9f"		=> "\xcb\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x8b"		=> "\xcb\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x91"		=> "\xcb\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xad"		=> "\xcb\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x86"		=> "\xcb\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xa9"		=> "\xcb\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\x90"		=> "\xcb\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xa2"		=> "\xcb\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x81"		=> "\xcb\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x80"		=> "\xcb\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x8c"		=> "\xcb\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x96"		=> "\xcb\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x83"		=> "\xcb\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\xb9"		=> "\xcb\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x94"		=> "\xcb\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xb9"		=> "\xcc\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xba"		=> "\xcc\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xbc"		=> "\xcc\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xbd"		=> "\xcc\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xbe"		=> "\xcc\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x80"		=> "\xcc\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x81"		=> "\xcc\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x82"		=> "\xcc\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x83"		=> "\xcc\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x84"		=> "\xcc\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x86"		=> "\xcc\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x87"		=> "\xcc\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x88"		=> "\xcc\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x89"		=> "\xcc\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x8a"		=> "\xcc\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x8b"		=> "\xcc\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x8c"		=> "\xcc\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x8d"		=> "\xcc\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x8e"		=> "\xcc\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x8f"		=> "\xcc\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x90"		=> "\xcc\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x92"		=> "\xcc\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x93"		=> "\xcc\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x94"		=> "\xcc\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x95"		=> "\xcc\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x97"		=> "\xcc\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x98"		=> "\xcc\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x99"		=> "\xcc\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x9a"		=> "\xcc\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x9b"		=> "\xcc\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x9c"		=> "\xcc\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x9d"		=> "\xcc\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x9e"		=> "\xcc\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x9f"		=> "\xcc\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa0"		=> "\xcc\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa1"		=> "\xcc\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa2"		=> "\xcc\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa3"		=> "\xcc\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa4"		=> "\xcc\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa5"		=> "\xcc\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa6"		=> "\xcc\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa8"		=> "\xcc\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xaa"		=> "\xcc\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xab"		=> "\xcc\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xac"		=> "\xcc\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xad"		=> "\xcc\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xae"		=> "\xcc\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xaf"		=> "\xcc\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb0"		=> "\xcc\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb1"		=> "\xcc\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb2"		=> "\xcc\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb3"		=> "\xcc\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb4"		=> "\xcc\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb5"		=> "\xcc\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb6"		=> "\xcc\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb7"		=> "\xcc\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb9"		=> "\xcc\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xba"		=> "\xcc\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xbb"		=> "\xcc\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xbd"		=> "\xcc\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xbe"		=> "\xcc\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xbf"		=> "\xcc\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x80"		=> "\xcc\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x81"		=> "\xcc\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x82"		=> "\xcc\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x83"		=> "\xcc\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x84"		=> "\xcc\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x85"		=> "\xcc\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x86"		=> "\xcc\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x87"		=> "\xcc\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x88"		=> "\xcc\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x89"		=> "\xcc\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x8a"		=> "\xcc\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x8b"		=> "\xcc\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x8c"		=> "\xcc\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x92"		=> "\xcc\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x93"		=> "\xcc\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x95"		=> "\xcc\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x96"		=> "\xcc\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x97"		=> "\xcc\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x98"		=> "\xcc\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x99"		=> "\xcc\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x9b"		=> "\xcc\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x9c"		=> "\xcc\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x9d"		=> "\xcc\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x9f"		=> "\xcc\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa0"		=> "\xcc\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa1"		=> "\xcc\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa3"		=> "\xcc\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa4"		=> "\xcc\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa5"		=> "\xcc\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa6"		=> "\xcc\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa7"		=> "\xcc\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa8"		=> "\xcc\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xa9"		=> "\xcc\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xaa"		=> "\xcc\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xad"		=> "\xcc\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x9e"		=> "\xcc\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x8b"		=> "\xcc\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x8f"		=> "\xcc\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x8e"		=> "\xcc\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x94"		=> "\xcc\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xac"		=> "\xcc\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb0"		=> "\xcc\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb0"		=> "\xcc\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x9e"		=> "\xcc\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xaa"		=> "\xcc\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x81"		=> "\xcc\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb0"		=> "\xcc\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x8d"		=> "\xcc\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x8a"		=> "\xcc\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xaa"		=> "\xcc\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xab"		=> "\xcc\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\xa9"		=> "\xcc\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x9b"		=> "\xcc\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x80"		=> "\xcc\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\xb0"		=> "\xcc\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\xad"		=> "\xcc\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xad"		=> "\xcc\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x88"		=> "\xcc\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa6"		=> "\xcc\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xaf"		=> "\xcc\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x92"		=> "\xcc\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\xb3"		=> "\xcc\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa2"		=> "\xcc\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb9"		=> "\xcc\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xad"		=> "\xcc\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa4"		=> "\xcc\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x98"		=> "\xcc\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xaa"		=> "\xcc\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x82"		=> "\xcc\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\xa0"		=> "\xcc\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x9b"		=> "\xcc\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x90"		=> "\xcc\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x96"		=> "\xcc\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x98"		=> "\xcc\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xba"		=> "\xcc\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x8c"		=> "\xcc\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x9f"		=> "\xcc\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xab"		=> "\xcc\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x8f"		=> "\xcc\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x9b"		=> "\xcc\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x94"		=> "\xcc\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa6"		=> "\xcc\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x84"		=> "\xcc\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x83"		=> "\xcc\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x83"		=> "\xcc\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x98"		=> "\xcc\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xb6"		=> "\xcc\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa8"		=> "\xcc\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x97"		=> "\xcc\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xb9"		=> "\xcc\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xa4"		=> "\xcc\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xbe"		=> "\xcc\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xbc"		=> "\xcc\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x8a"		=> "\xcc\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xaf"		=> "\xcc\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x94"		=> "\xcc\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa2"		=> "\xcc\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x91"		=> "\xcc\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x90"		=> "\xcc\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x98"		=> "\xcc\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x84"		=> "\xcc\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xbc"		=> "\xcc\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x93"		=> "\xcc\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xbf"		=> "\xcc\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x8f"		=> "\xcc\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x95"		=> "\xcc\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x95"		=> "\xcc\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x83"		=> "\xcc\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x89"		=> "\xcc\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa9"		=> "\xcc\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xbb"		=> "\xcc\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xab"		=> "\xcc\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb0"		=> "\xcc\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x9c"		=> "\xcc\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xac"		=> "\xcc\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x94"		=> "\xcc\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x86"		=> "\xcc\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x91"		=> "\xcc\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa1"		=> "\xcc\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xa2"		=> "\xcc\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xba"		=> "\xcc\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb3"		=> "\xcc\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xb4"		=> "\xcc\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x81"		=> "\xcc\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x96"		=> "\xcc\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x85"		=> "\xcc\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xac"		=> "\xcc\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x83"		=> "\xcc\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xad"		=> "\xcd\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xaf"		=> "\xcd\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb0"		=> "\xcd\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb2"		=> "\xcd\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb3"		=> "\xcd\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb4"		=> "\xcd\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb5"		=> "\xcd\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb6"		=> "\xcd\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb7"		=> "\xcd\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xb8"		=> "\xcd\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x83"		=> "\xcd\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x84"		=> "\xcd\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x85"		=> "\xcd\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x86"		=> "\xcd\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x87"		=> "\xcd\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x88"		=> "\xcd\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x89"		=> "\xcd\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x8e"		=> "\xcd\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x8f"		=> "\xcd\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x90"		=> "\xcd\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x91"		=> "\xcd\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x92"		=> "\xcd\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x94"		=> "\xcd\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x96"		=> "\xcd\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x97"		=> "\xcd\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x98"		=> "\xcd\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x99"		=> "\xcd\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x9a"		=> "\xcd\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x9b"		=> "\xcd\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x9e"		=> "\xcd\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x9f"		=> "\xcd\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xa0"		=> "\xcd\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xa1"		=> "\xcd\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xa2"		=> "\xcd\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xa5"		=> "\xcd\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xa6"		=> "\xcd\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xab"		=> "\xcd\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xad"		=> "\xcd\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xae"		=> "\xcd\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xb2"		=> "\xcd\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xb3"		=> "\xcd\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xb7"		=> "\xcd\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xb8"		=> "\xcd\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xb9"		=> "\xcd\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xbb"		=> "\xcd\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xbc"		=> "\xcd\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xbd"		=> "\xcd\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xbe"		=> "\xcd\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xbf"		=> "\xcd\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x81"		=> "\xcd\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x82"		=> "\xcd\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x83"		=> "\xcd\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x85"		=> "\xcd\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x88"		=> "\xcd\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x8c"		=> "\xcd\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x8d"		=> "\xcd\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x92"		=> "\xcd\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x93"		=> "\xcd\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x95"		=> "\xcd\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x96"		=> "\xcd\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x97"		=> "\xcd\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x9a"		=> "\xcd\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x9c"		=> "\xcd\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x9d"		=> "\xcd\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa0"		=> "\xcd\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa1"		=> "\xcd\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa2"		=> "\xcd\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa3"		=> "\xcd\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa5"		=> "\xcd\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa6"		=> "\xcd\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa7"		=> "\xcd\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xa8"		=> "\xcd\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xaa"		=> "\xcd\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xab"		=> "\xcd\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xac"		=> "\xcd\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xaf"		=> "\xcd\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xb5"		=> "\xcd\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xb6"		=> "\xcd\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xb7"		=> "\xcd\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xba"		=> "\xcd\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xbb"		=> "\xcd\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xbc"		=> "\xcd\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xbd"		=> "\xcd\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xbf"		=> "\xcd\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x81"		=> "\xcd\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x84"		=> "\xcd\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x85"		=> "\xcd\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x86"		=> "\xcd\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x8b"		=> "\xcd\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x8c"		=> "\xcd\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x8e"		=> "\xcd\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x8f"		=> "\xcd\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x90"		=> "\xcd\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x91"		=> "\xcd\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x94"		=> "\xcd\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x96"		=> "\xcd\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x80"		=> "\xcd\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb7"		=> "\xcd\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x9c"		=> "\xcd\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xad"		=> "\xcd\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xad"		=> "\xcd\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xba"		=> "\xcd\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\x87"		=> "\xcd\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x9a"		=> "\xcd\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x90"		=> "\xcd\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xae"		=> "\xcd\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xb3"		=> "\xcd\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x8c"		=> "\xcd\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x9c"		=> "\xcd\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa4"		=> "\xcd\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa5"		=> "\xcd\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xb6"		=> "\xcd\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x85"		=> "\xcd\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x92"		=> "\xcd\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x9f"		=> "\xcd\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x9b"		=> "\xcd\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xb7"		=> "\xcd\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x95"		=> "\xcd\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb4"		=> "\xcd\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x8f"		=> "\xcd\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb8"		=> "\xcd\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x83"		=> "\xcd\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x81"		=> "\xcd\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xbe"		=> "\xcd\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x92"		=> "\xcd\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x94"		=> "\xcd\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x82"		=> "\xcd\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xa0"		=> "\xcd\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x9f"		=> "\xcd\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x90"		=> "\xcd\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x94"		=> "\xcd\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x8d"		=> "\xcd\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa2"		=> "\xcd\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa8"		=> "\xcd\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x93"		=> "\xcd\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xbf"		=> "\xcd\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x95"		=> "\xcd\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xaa"		=> "\xcd\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x80"		=> "\xcd\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x9e"		=> "\xcd\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xaf"		=> "\xcd\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x80"		=> "\xcd\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x96"		=> "\xcd\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x98"		=> "\xcd\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\xb1"		=> "\xcd\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xb5"		=> "\xcd\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x80"		=> "\xcd\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xae"		=> "\xcd\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xbc"		=> "\xcd\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xad"		=> "\xcd\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\xa5"		=> "\xcd\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x93"		=> "\xcd\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xbe"		=> "\xcd\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x96"		=> "\xcd\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x87"		=> "\xcd\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x99"		=> "\xcd\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xbc"		=> "\xcd\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x83"		=> "\xcd\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xa6"		=> "\xcd\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x9c"		=> "\xcd\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xaa"		=> "\xcd\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x96"		=> "\xcd\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x8c"		=> "\xcd\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xaf"		=> "\xcd\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\xbe"		=> "\xcd\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xa9"		=> "\xcd\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xbd"		=> "\xcd\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb8"		=> "\xcd\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xb7"		=> "\xcd\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x8c"		=> "\xcd\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa2\x97"		=> "\xcd\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xbd"		=> "\xcd\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x9a"		=> "\xcd\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x96"		=> "\xcd\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x8b"		=> "\xcd\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x9b"		=> "\xcd\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\x89"		=> "\xcd\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x87"		=> "\xcd\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x95"		=> "\xcd\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xaa"		=> "\xcd\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x8b"		=> "\xcd\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa1"		=> "\xcd\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x89"		=> "\xcd\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x91"		=> "\xcd\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x80"		=> "\xcd\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xba"		=> "\xcd\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x9b"		=> "\xcd\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x98"		=> "\xcd\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x84"		=> "\xcd\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\x81"		=> "\xcd\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x99"		=> "\xce\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x9b"		=> "\xce\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x9d"		=> "\xce\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x9f"		=> "\xce\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xa0"		=> "\xce\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xa4"		=> "\xce\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xa6"		=> "\xce\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xa7"		=> "\xce\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xa8"		=> "\xce\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xaa"		=> "\xce\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xab"		=> "\xce\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xac"		=> "\xce\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xad"		=> "\xce\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xaf"		=> "\xce\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb0"		=> "\xce\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb2"		=> "\xce\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb3"		=> "\xce\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb5"		=> "\xce\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb6"		=> "\xce\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb8"		=> "\xce\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xb9"		=> "\xce\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xba"		=> "\xce\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xbc"		=> "\xce\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\xbd"		=> "\xce\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x80"		=> "\xce\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x81"		=> "\xce\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x82"		=> "\xce\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x83"		=> "\xce\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x84"		=> "\xce\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x85"		=> "\xce\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x86"		=> "\xce\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x8a"		=> "\xce\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x8b"		=> "\xce\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x8d"		=> "\xce\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x8f"		=> "\xce\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x90"		=> "\xce\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x91"		=> "\xce\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x92"		=> "\xce\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x94"		=> "\xce\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x95"		=> "\xce\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x96"		=> "\xce\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x98"		=> "\xce\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x9a"		=> "\xce\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x9b"		=> "\xce\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x9c"		=> "\xce\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x9d"		=> "\xce\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x9e"		=> "\xce\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x9f"		=> "\xce\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xa1"		=> "\xce\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xa2"		=> "\xce\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xa6"		=> "\xce\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xa7"		=> "\xce\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xa8"		=> "\xce\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xa9"		=> "\xce\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xaa"		=> "\xce\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xab"		=> "\xce\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xac"		=> "\xce\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xad"		=> "\xce\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xaf"		=> "\xce\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb1"		=> "\xce\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb2"		=> "\xce\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb3"		=> "\xce\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb5"		=> "\xce\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb7"		=> "\xce\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb8"		=> "\xce\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xb9"		=> "\xce\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xba"		=> "\xce\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\xbf"		=> "\xce\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x80"		=> "\xce\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x81"		=> "\xce\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x84"		=> "\xce\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x86"		=> "\xce\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x87"		=> "\xce\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x89"		=> "\xce\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x8a"		=> "\xce\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x8c"		=> "\xce\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x8e"		=> "\xce\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x8f"		=> "\xce\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x90"		=> "\xce\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x91"		=> "\xce\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x92"		=> "\xce\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x94"		=> "\xce\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x95"		=> "\xce\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x96"		=> "\xce\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x98"		=> "\xce\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x99"		=> "\xce\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x9a"		=> "\xce\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x9b"		=> "\xce\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x9c"		=> "\xce\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x9d"		=> "\xce\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\x9e"		=> "\xce\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa0"		=> "\xce\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa1"		=> "\xce\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa2"		=> "\xce\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa3"		=> "\xce\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa4"		=> "\xce\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x8d"		=> "\xce\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xae"		=> "\xce\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb1"		=> "\xce\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xa6"		=> "\xce\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x9d"		=> "\xce\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x85"		=> "\xce\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb4"		=> "\xce\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xaf"		=> "\xce\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x9f"		=> "\xce\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xba"		=> "\xce\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbd\x8d"		=> "\xce\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xb4"		=> "\xce\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x87"		=> "\xce\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x8e"		=> "\xce\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x94"		=> "\xce\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x9f"		=> "\xce\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xaa"		=> "\xce\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xbe"		=> "\xce\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xac"		=> "\xce\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xaa"		=> "\xce\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x9a"		=> "\xce\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb3"		=> "\xce\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x8f"		=> "\xce\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x83"		=> "\xce\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x82"		=> "\xce\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xad\x8f"		=> "\xce\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x8d"		=> "\xce\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xad"		=> "\xce\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x93"		=> "\xce\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x89"		=> "\xce\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb0"		=> "\xce\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xab"		=> "\xce\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\x9f"		=> "\xce\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa9"		=> "\xce\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x8a"		=> "\xce\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x87"		=> "\xce\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xbb"		=> "\xce\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb9"		=> "\xce\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xbb"		=> "\xce\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\xb3"		=> "\xce\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\x8a"		=> "\xce\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xae"		=> "\xce\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa1"		=> "\xce\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x81"		=> "\xce\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x93\xae"		=> "\xce\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x9d"		=> "\xce\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x97"		=> "\xce\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa1"		=> "\xce\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x9d"		=> "\xce\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x91"		=> "\xce\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa1"		=> "\xce\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa7"		=> "\xce\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa1"		=> "\xce\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x83"		=> "\xce\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xab"		=> "\xce\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x9c"		=> "\xce\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa8"		=> "\xce\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x8c"		=> "\xce\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa1"		=> "\xce\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xac"		=> "\xce\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x8b"		=> "\xce\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa0"		=> "\xce\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x9c"		=> "\xce\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xa7"		=> "\xce\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xbe"		=> "\xce\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb4"		=> "\xce\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x8b"		=> "\xce\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa6"		=> "\xce\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x94"		=> "\xce\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x82"		=> "\xce\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x88"		=> "\xce\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x9e"		=> "\xce\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x8d"		=> "\xce\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xae"		=> "\xce\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x9e"		=> "\xce\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x8a"		=> "\xce\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\xbe"		=> "\xce\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xa4"		=> "\xce\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xa9"		=> "\xce\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xbf"		=> "\xce\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa1"		=> "\xce\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x9f"		=> "\xce\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xaf"		=> "\xce\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x94"		=> "\xce\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x99"		=> "\xce\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x90"		=> "\xce\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xbf"		=> "\xce\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x92"		=> "\xce\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xbd"		=> "\xce\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xb0"		=> "\xce\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xbb"		=> "\xce\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb8"		=> "\xce\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xa1"		=> "\xce\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\xba"		=> "\xce\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa5"		=> "\xcf\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa6"		=> "\xcf\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa7"		=> "\xcf\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xa9"		=> "\xcf\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xaa"		=> "\xcf\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xae"		=> "\xcf\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb0"		=> "\xcf\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb1"		=> "\xcf\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb2"		=> "\xcf\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb4"		=> "\xcf\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb6"		=> "\xcf\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb7"		=> "\xcf\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb8"		=> "\xcf\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xb9"		=> "\xcf\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xbb"		=> "\xcf\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xbc"		=> "\xcf\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xbe"		=> "\xcf\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9e\xbf"		=> "\xcf\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x81"		=> "\xcf\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x82"		=> "\xcf\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x83"		=> "\xcf\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x84"		=> "\xcf\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x85"		=> "\xcf\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x87"		=> "\xcf\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x88"		=> "\xcf\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x89"		=> "\xcf\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x8c"		=> "\xcf\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x8d"		=> "\xcf\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x8e"		=> "\xcf\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x8f"		=> "\xcf\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x90"		=> "\xcf\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x94"		=> "\xcf\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x95"		=> "\xcf\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x96"		=> "\xcf\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x97"		=> "\xcf\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x98"		=> "\xcf\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x99"		=> "\xcf\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x9a"		=> "\xcf\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x9c"		=> "\xcf\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x9d"		=> "\xcf\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x9e"		=> "\xcf\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\x9f"		=> "\xcf\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa1"		=> "\xcf\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa2"		=> "\xcf\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa3"		=> "\xcf\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa4"		=> "\xcf\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa6"		=> "\xcf\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa7"		=> "\xcf\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa8"		=> "\xcf\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xa9"		=> "\xcf\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xab"		=> "\xcf\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xac"		=> "\xcf\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xad"		=> "\xcf\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xaf"		=> "\xcf\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb0"		=> "\xcf\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb1"		=> "\xcf\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb2"		=> "\xcf\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb3"		=> "\xcf\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb4"		=> "\xcf\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb5"		=> "\xcf\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb6"		=> "\xcf\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb7"		=> "\xcf\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb8"		=> "\xcf\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xba"		=> "\xcf\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xbb"		=> "\xcf\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xbc"		=> "\xcf\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xbd"		=> "\xcf\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xbf"		=> "\xcf\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x80"		=> "\xcf\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x81"		=> "\xcf\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x82"		=> "\xcf\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x84"		=> "\xcf\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x85"		=> "\xcf\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x86"		=> "\xcf\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x87"		=> "\xcf\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x88"		=> "\xcf\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x89"		=> "\xcf\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x8b"		=> "\xcf\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x8c"		=> "\xcf\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x8d"		=> "\xcf\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x8e"		=> "\xcf\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x8f"		=> "\xcf\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x90"		=> "\xcf\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x91"		=> "\xcf\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x92"		=> "\xcf\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x94"		=> "\xcf\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x97"		=> "\xcf\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x98"		=> "\xcf\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x99"		=> "\xcf\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x9a"		=> "\xcf\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x9c"		=> "\xcf\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x9d"		=> "\xcf\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x9e"		=> "\xcf\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x9f"		=> "\xcf\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa0"		=> "\xcf\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa3"		=> "\xcf\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x80"		=> "\xcf\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xaf"		=> "\xcf\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x8c"		=> "\xcf\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x89"		=> "\xcf\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\x9d"		=> "\xcf\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x95"		=> "\xcf\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x9c"		=> "\xcf\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x84"		=> "\xcf\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\xaf"		=> "\xcf\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xaa"		=> "\xcf\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x90"		=> "\xcf\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\x80"		=> "\xcf\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaa\x84"		=> "\xcf\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xad"		=> "\xcf\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xad"		=> "\xcf\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa0"		=> "\xcf\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaa\xb3"		=> "\xcf\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x9c"		=> "\xcf\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xa3"		=> "\xcf\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x97"		=> "\xcf\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\xbb"		=> "\xcf\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x99"		=> "\xcf\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x8f"		=> "\xcf\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x86"		=> "\xcf\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\x8e"		=> "\xcf\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\xbe"		=> "\xcf\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa3"		=> "\xcf\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x9e"		=> "\xcf\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x96"		=> "\xcf\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x87"		=> "\xcf\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa1"		=> "\xcf\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa0"		=> "\xcf\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xad"		=> "\xcf\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x8b"		=> "\xcf\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa6"		=> "\xcf\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x8f"		=> "\xcf\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x93"		=> "\xcf\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x80"		=> "\xcf\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xa8"		=> "\xcf\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x88"		=> "\xcf\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x99"		=> "\xcf\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb2\x9c"		=> "\xcf\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xa4"		=> "\xcf\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb8"		=> "\xcf\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa4"		=> "\xcf\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x94"		=> "\xcf\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\xb7"		=> "\xcf\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb2"		=> "\xcf\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x8e"		=> "\xcf\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa6"		=> "\xcf\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xab\x8c"		=> "\xcf\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xbe"		=> "\xcf\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xa9"		=> "\xcf\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\xb0"		=> "\xcf\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xae"		=> "\xcf\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xbf"		=> "\xcf\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xba"		=> "\xcf\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x85"		=> "\xcf\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xa1"		=> "\xcf\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xaa"		=> "\xcf\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xb7"		=> "\xcf\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x90"		=> "\xcf\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xbf"		=> "\xcf\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb8"		=> "\xcf\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa2"		=> "\xcf\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\xb6"		=> "\xcf\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x99"		=> "\xcf\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xae\xb1"		=> "\xcf\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x84"		=> "\xcf\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x98"		=> "\xcf\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa1"		=> "\xcf\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x94"		=> "\xcf\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\xa5"		=> "\xcf\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa6"		=> "\xcf\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb3"		=> "\xcf\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x8d"		=> "\xcf\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xab"		=> "\xcf\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xb9"		=> "\xcf\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb7"		=> "\xcf\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa9\xa1"		=> "\xcf\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x8f"		=> "\xcf\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x91"		=> "\xcf\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa1"		=> "\xcf\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa7"		=> "\xcf\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\x9d"		=> "\xcf\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x84"		=> "\xcf\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x8a"		=> "\xcf\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xae"		=> "\xcf\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xa3"		=> "\xcf\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x80"		=> "\xcf\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x88"		=> "\xcf\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb5"		=> "\xcf\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x86"		=> "\xcf\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x93"		=> "\xcf\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa4"		=> "\xd0\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa5"		=> "\xd0\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa6"		=> "\xd0\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa7"		=> "\xd0\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa8"		=> "\xd0\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xa9"		=> "\xd0\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xaa"		=> "\xd0\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xab"		=> "\xd0\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xac"		=> "\xd0\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xad"		=> "\xd0\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xae"		=> "\xd0\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xaf"		=> "\xd0\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb0"		=> "\xd0\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb1"		=> "\xd0\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb3"		=> "\xd0\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb4"		=> "\xd0\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb5"		=> "\xd0\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb6"		=> "\xd0\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb7"		=> "\xd0\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xb8"		=> "\xd0\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xba"		=> "\xd0\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xbb"		=> "\xd0\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xbd"		=> "\xd0\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xbe"		=> "\xd0\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\xbf"		=> "\xd0\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x81"		=> "\xd0\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x82"		=> "\xd0\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x83"		=> "\xd0\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x86"		=> "\xd0\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x87"		=> "\xd0\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x88"		=> "\xd0\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x89"		=> "\xd0\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x8a"		=> "\xd0\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x8b"		=> "\xd0\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x8e"		=> "\xd0\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x8f"		=> "\xd0\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x90"		=> "\xd0\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x91"		=> "\xd0\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x92"		=> "\xd0\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x93"		=> "\xd0\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x95"		=> "\xd0\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x96"		=> "\xd0\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x98"		=> "\xd0\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x9a"		=> "\xd0\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x9b"		=> "\xd0\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x9c"		=> "\xd0\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x9d"		=> "\xd0\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x9e"		=> "\xd0\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x9f"		=> "\xd0\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa0"		=> "\xd0\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa6"		=> "\xd0\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa7"		=> "\xd0\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xaa"		=> "\xd0\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xad"		=> "\xd0\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xaf"		=> "\xd0\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb1"		=> "\xd0\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb3"		=> "\xd0\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb4"		=> "\xd0\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb5"		=> "\xd0\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb6"		=> "\xd0\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb8"		=> "\xd0\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb9"		=> "\xd0\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xba"		=> "\xd0\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xbb"		=> "\xd0\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xbc"		=> "\xd0\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x80"		=> "\xd0\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x83"		=> "\xd0\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x86"		=> "\xd0\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x87"		=> "\xd0\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x89"		=> "\xd0\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x8a"		=> "\xd0\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x8c"		=> "\xd0\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x8e"		=> "\xd0\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x8f"		=> "\xd0\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x90"		=> "\xd0\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x91"		=> "\xd0\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x93"		=> "\xd0\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x94"		=> "\xd0\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x95"		=> "\xd0\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x97"		=> "\xd0\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x98"		=> "\xd0\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x99"		=> "\xd0\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x9a"		=> "\xd0\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x9b"		=> "\xd0\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x9d"		=> "\xd0\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x9e"		=> "\xd0\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x9f"		=> "\xd0\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa0"		=> "\xd0\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa1"		=> "\xd0\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa3"		=> "\xd0\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa5"		=> "\xd0\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa6"		=> "\xd0\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa7"		=> "\xd0\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa8"		=> "\xd0\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa9"		=> "\xd0\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xaa"		=> "\xd0\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x8f"		=> "\xd0\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x9d"		=> "\xd0\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xa1"		=> "\xd0\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x96"		=> "\xd0\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb8"		=> "\xd0\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xac\x91"		=> "\xd0\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\x88"		=> "\xd0\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa5\x94"		=> "\xd0\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x9b"		=> "\xd0\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\x87"		=> "\xd0\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x8e"		=> "\xd0\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9e\x8b"		=> "\xd0\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x8f"		=> "\xd0\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x9f"		=> "\xd0\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xba"		=> "\xd0\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xaa"		=> "\xd0\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x9c"		=> "\xd0\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x81"		=> "\xd0\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x90"		=> "\xd0\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x99"		=> "\xd0\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa2\xb0"		=> "\xd0\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb8"		=> "\xd0\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9f\xb9"		=> "\xd0\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x88"		=> "\xd0\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x84"		=> "\xd0\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xbb"		=> "\xd0\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa2"		=> "\xd0\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x91"		=> "\xd0\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xaa"		=> "\xd0\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xaf"		=> "\xd0\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x8c"		=> "\xd0\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xa3"		=> "\xd0\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x9b"		=> "\xd0\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xb0"		=> "\xd0\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xbb"		=> "\xd0\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x83"		=> "\xd0\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa1"		=> "\xd0\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x85"		=> "\xd0\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x9f"		=> "\xd0\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xa5"		=> "\xd0\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa9"		=> "\xd0\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xba"		=> "\xd0\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb4"		=> "\xd0\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x91"		=> "\xd0\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x8b"		=> "\xd0\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa2"		=> "\xd0\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa2"		=> "\xd0\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x8c"		=> "\xd0\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x92"		=> "\xd0\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xb8"		=> "\xd0\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x8f"		=> "\xd0\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa7"		=> "\xd0\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x93"		=> "\xd0\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x84"		=> "\xd0\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb6"		=> "\xd0\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb8"		=> "\xd0\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x88"		=> "\xd0\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb9"		=> "\xd0\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x84"		=> "\xd0\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x8a"		=> "\xd0\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x91"		=> "\xd0\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xae"		=> "\xd0\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x9e"		=> "\xd0\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xbd"		=> "\xd0\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x85"		=> "\xd0\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x88"		=> "\xd0\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x80"		=> "\xd0\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x96"		=> "\xd0\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xa3"		=> "\xd0\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x9f"		=> "\xd0\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x8c"		=> "\xd0\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x80"		=> "\xd0\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x9a"		=> "\xd0\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x98"		=> "\xd0\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xbb"		=> "\xd0\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x90"		=> "\xd0\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb8"		=> "\xd0\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x84"		=> "\xd0\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x97"		=> "\xd0\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x99"		=> "\xd0\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xad"		=> "\xd0\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x8f"		=> "\xd0\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x9c"		=> "\xd0\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xa4"		=> "\xd0\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb5\xae"		=> "\xd0\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xbf"		=> "\xd0\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xaa"		=> "\xd0\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xad"		=> "\xd0\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa9"		=> "\xd0\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xa7"		=> "\xd0\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xa3"		=> "\xd0\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xac"		=> "\xd0\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x8b"		=> "\xd0\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x84"		=> "\xd0\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xac"		=> "\xd1\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xae"		=> "\xd1\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xaf"		=> "\xd1\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb0"		=> "\xd1\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb2"		=> "\xd1\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb3"		=> "\xd1\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb4"		=> "\xd1\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb5"		=> "\xd1\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb6"		=> "\xd1\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb8"		=> "\xd1\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xb9"		=> "\xd1\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xba"		=> "\xd1\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xbb"		=> "\xd1\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xbd"		=> "\xd1\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xbe"		=> "\xd1\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xbf"		=> "\xd1\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x80"		=> "\xd1\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x83"		=> "\xd1\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x84"		=> "\xd1\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x87"		=> "\xd1\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x88"		=> "\xd1\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x8a"		=> "\xd1\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x8b"		=> "\xd1\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x8c"		=> "\xd1\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x8d"		=> "\xd1\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x8f"		=> "\xd1\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x90"		=> "\xd1\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x91"		=> "\xd1\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x93"		=> "\xd1\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x96"		=> "\xd1\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x97"		=> "\xd1\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x9a"		=> "\xd1\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x9b"		=> "\xd1\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x9c"		=> "\xd1\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x9d"		=> "\xd1\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x9e"		=> "\xd1\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xa0"		=> "\xd1\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xa1"		=> "\xd1\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xa6"		=> "\xd1\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xa7"		=> "\xd1\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xa9"		=> "\xd1\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xaa"		=> "\xd1\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xab"		=> "\xd1\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xac"		=> "\xd1\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xad"		=> "\xd1\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xae"		=> "\xd1\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xaf"		=> "\xd1\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb2"		=> "\xd1\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb5"		=> "\xd1\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb6"		=> "\xd1\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xb7"		=> "\xd1\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xba"		=> "\xd1\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xbb"		=> "\xd1\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xbd"		=> "\xd1\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\xbf"		=> "\xd1\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x80"		=> "\xd1\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x81"		=> "\xd1\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x83"		=> "\xd1\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x84"		=> "\xd1\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x85"		=> "\xd1\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x86"		=> "\xd1\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x87"		=> "\xd1\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x88"		=> "\xd1\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x89"		=> "\xd1\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x8b"		=> "\xd1\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x8c"		=> "\xd1\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x8d"		=> "\xd1\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x8e"		=> "\xd1\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x8f"		=> "\xd1\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x91"		=> "\xd1\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x94"		=> "\xd1\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x95"		=> "\xd1\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x96"		=> "\xd1\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x97"		=> "\xd1\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x98"		=> "\xd1\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x9c"		=> "\xd1\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x9d"		=> "\xd1\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x9e"		=> "\xd1\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\x9f"		=> "\xd1\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa0"		=> "\xd1\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa2"		=> "\xd1\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa3"		=> "\xd1\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa4"		=> "\xd1\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa6"		=> "\xd1\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa7"		=> "\xd1\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa8"		=> "\xd1\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xa9"		=> "\xd1\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xac"		=> "\xd1\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xad"		=> "\xd1\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xae"		=> "\xd1\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xaf"		=> "\xd1\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb1"		=> "\xd1\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb2"		=> "\xd1\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb3"		=> "\xd1\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb5"		=> "\xd1\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb7"		=> "\xd1\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x89"		=> "\xd1\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x99\xa3"		=> "\xd1\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa9"		=> "\xd1\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x9a"		=> "\xd1\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xb4"		=> "\xd1\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x9b"		=> "\xd1\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xa6"		=> "\xd1\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa9\xb4"		=> "\xd1\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\xaa"		=> "\xd1\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x80"		=> "\xd1\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x8b"		=> "\xd1\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x86\x8f"		=> "\xd1\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xaa"		=> "\xd1\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xac"		=> "\xd1\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa2"		=> "\xd1\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xbb"		=> "\xd1\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xaf"		=> "\xd1\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa1"		=> "\xd1\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x89"		=> "\xd1\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x9b"		=> "\xd1\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xad"		=> "\xd1\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xaf"		=> "\xd1\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x8a"		=> "\xd1\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x85"		=> "\xd1\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x8b"		=> "\xd1\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xbc"		=> "\xd1\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xa6"		=> "\xd1\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xad"		=> "\xd1\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x80"		=> "\xd1\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xab"		=> "\xd1\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xbd"		=> "\xd1\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x89\x99"		=> "\xd1\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x9c"		=> "\xd1\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x96"		=> "\xd1\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x99"		=> "\xd1\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xaf"		=> "\xd1\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x85"		=> "\xd1\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x91"		=> "\xd1\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x9a"		=> "\xd1\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb6"		=> "\xd1\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\x89"		=> "\xd1\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xbd"		=> "\xd1\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x89"		=> "\xd1\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x9f"		=> "\xd1\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xb9"		=> "\xd1\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x90"		=> "\xd1\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa5"		=> "\xd1\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x94"		=> "\xd1\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x92"		=> "\xd1\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa9"		=> "\xd1\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb6"		=> "\xd1\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x80"		=> "\xd1\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x9c"		=> "\xd1\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x8e"		=> "\xd1\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x8e"		=> "\xd1\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xbf"		=> "\xd1\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x84"		=> "\xd1\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xa9"		=> "\xd1\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xbc"		=> "\xd1\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\x8d"		=> "\xd1\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\x94"		=> "\xd1\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb3"		=> "\xd1\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xb0"		=> "\xd1\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\x95"		=> "\xd1\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x8c"		=> "\xd1\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x9a"		=> "\xd1\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x81"		=> "\xd1\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x81"		=> "\xd1\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa6"		=> "\xd1\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x84\xb0"		=> "\xd1\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb4"		=> "\xd1\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x9a"		=> "\xd1\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\x8c"		=> "\xd1\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x83"		=> "\xd1\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xae"		=> "\xd1\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xaf"		=> "\xd1\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa7"		=> "\xd1\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\xa8"		=> "\xd1\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xac"		=> "\xd1\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xaf"		=> "\xd1\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xa1"		=> "\xd1\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\x8a"		=> "\xd1\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\x8b"		=> "\xd1\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xb3"		=> "\xd1\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xa7"		=> "\xd1\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb0"		=> "\xd1\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x92"		=> "\xd1\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xbb"		=> "\xd1\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xb7"		=> "\xd1\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xbe"		=> "\xd1\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x80"		=> "\xd1\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\xb0"		=> "\xd1\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x96"		=> "\xd1\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x91\xb6"		=> "\xd1\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb8"		=> "\xd2\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xb9"		=> "\xd2\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xba"		=> "\xd2\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xbb"		=> "\xd2\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xbc"		=> "\xd2\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xbd"		=> "\xd2\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xbe"		=> "\xd2\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa4\xbf"		=> "\xd2\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x80"		=> "\xd2\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x82"		=> "\xd2\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x83"		=> "\xd2\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x85"		=> "\xd2\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x86"		=> "\xd2\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x87"		=> "\xd2\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x88"		=> "\xd2\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x89"		=> "\xd2\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x8a"		=> "\xd2\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x8b"		=> "\xd2\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x8c"		=> "\xd2\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x8d"		=> "\xd2\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x8e"		=> "\xd2\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x8f"		=> "\xd2\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x90"		=> "\xd2\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x91"		=> "\xd2\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x92"		=> "\xd2\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x93"		=> "\xd2\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x94"		=> "\xd2\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x95"		=> "\xd2\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x96"		=> "\xd2\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x97"		=> "\xd2\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x98"		=> "\xd2\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x99"		=> "\xd2\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x9a"		=> "\xd2\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x9b"		=> "\xd2\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x9c"		=> "\xd2\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\x9d"		=> "\xd2\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa0"		=> "\xd2\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa1"		=> "\xd2\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa2"		=> "\xd2\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa3"		=> "\xd2\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa4"		=> "\xd2\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa5"		=> "\xd2\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa7"		=> "\xd2\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa8"		=> "\xd2\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xa9"		=> "\xd2\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xaa"		=> "\xd2\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xab"		=> "\xd2\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xac"		=> "\xd2\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xad"		=> "\xd2\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xae"		=> "\xd2\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xaf"		=> "\xd2\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb0"		=> "\xd2\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb1"		=> "\xd2\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb2"		=> "\xd2\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb3"		=> "\xd2\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb4"		=> "\xd2\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb5"		=> "\xd2\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb6"		=> "\xd2\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb7"		=> "\xd2\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb8"		=> "\xd2\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xb9"		=> "\xd2\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xba"		=> "\xd2\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xbc"		=> "\xd2\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xbd"		=> "\xd2\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa5\xbe"		=> "\xd2\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x80"		=> "\xd2\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x82"		=> "\xd2\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x84"		=> "\xd2\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x85"		=> "\xd2\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x87"		=> "\xd2\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x88"		=> "\xd2\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x89"		=> "\xd2\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x8a"		=> "\xd2\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x8b"		=> "\xd2\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x8c"		=> "\xd2\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x8d"		=> "\xd2\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x8e"		=> "\xd2\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x8f"		=> "\xd2\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x90"		=> "\xd2\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x91"		=> "\xd2\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x92"		=> "\xd2\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x93"		=> "\xd2\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x94"		=> "\xd2\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x95"		=> "\xd2\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x96"		=> "\xd2\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x97"		=> "\xd2\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x98"		=> "\xd2\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x99"		=> "\xd2\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x9a"		=> "\xd2\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x9b"		=> "\xd2\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x9c"		=> "\xd2\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x9d"		=> "\xd2\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x9e"		=> "\xd2\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x9f"		=> "\xd2\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa0"		=> "\xd2\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa1"		=> "\xd2\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x87"		=> "\xd2\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa7"		=> "\xd2\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa5"		=> "\xd2\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x91"		=> "\xd2\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa3"		=> "\xd2\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\x9a"		=> "\xd2\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xac"		=> "\xd2\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x80"		=> "\xd2\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xaf"		=> "\xd2\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\x81"		=> "\xd2\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x80"		=> "\xd2\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\xb0"		=> "\xd2\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x8e"		=> "\xd2\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb6"		=> "\xd2\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xb7"		=> "\xd2\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x8e"		=> "\xd2\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb6"		=> "\xd2\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x9f"		=> "\xd2\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa1\xb5"		=> "\xd2\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x96"		=> "\xd2\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x9a"		=> "\xd2\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb6"		=> "\xd2\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb3"		=> "\xd2\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x85\x8b"		=> "\xd2\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x9c"		=> "\xd2\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xb2"		=> "\xd2\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x80"		=> "\xd2\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xb9"		=> "\xd2\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xbb"		=> "\xd2\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x96"		=> "\xd2\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xb1"		=> "\xd2\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x9d"		=> "\xd2\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x8a"		=> "\xd2\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa3"		=> "\xd2\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x90"		=> "\xd2\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xb7"		=> "\xd2\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x97"		=> "\xd2\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xbb"		=> "\xd2\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xaa"		=> "\xd2\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xb0"		=> "\xd2\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\x91"		=> "\xd2\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x82"		=> "\xd2\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x9c"		=> "\xd2\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xa8"		=> "\xd2\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\x9d"		=> "\xd2\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x85"		=> "\xd2\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\x81"		=> "\xd2\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x9a"		=> "\xd2\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xb2"		=> "\xd2\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x99"		=> "\xd2\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa3"		=> "\xd2\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa5"		=> "\xd2\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xba"		=> "\xd2\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x91"		=> "\xd2\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\x93"		=> "\xd2\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x91"		=> "\xd2\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xb9"		=> "\xd2\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xbf"		=> "\xd2\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb9"		=> "\xd2\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x86"		=> "\xd2\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb8"		=> "\xd2\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x84"		=> "\xd2\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xab"		=> "\xd2\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa6"		=> "\xd2\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x94"		=> "\xd2\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x8f"		=> "\xd2\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x85"		=> "\xd2\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x86"		=> "\xd2\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x89"		=> "\xd2\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x8a"		=> "\xd2\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\xa2"		=> "\xd2\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa3"		=> "\xd2\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xae"		=> "\xd2\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x8a"		=> "\xd2\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x91"		=> "\xd2\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x82"		=> "\xd2\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\xbc"		=> "\xd2\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbf\x8c"		=> "\xd2\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x8e"		=> "\xd2\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb5"		=> "\xd2\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xab"		=> "\xd2\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa0"		=> "\xd2\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\xb7"		=> "\xd2\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xb3"		=> "\xd2\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xb4"		=> "\xd2\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xbb"		=> "\xd2\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x9f"		=> "\xd2\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xb6"		=> "\xd2\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xab"		=> "\xd2\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x85"		=> "\xd2\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xae"		=> "\xd2\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb9"		=> "\xd2\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x95"		=> "\xd2\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x90"		=> "\xd2\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa2"		=> "\xd3\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa3"		=> "\xd3\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa4"		=> "\xd3\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa5"		=> "\xd3\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa6"		=> "\xd3\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa7"		=> "\xd3\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa8"		=> "\xd3\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xa9"		=> "\xd3\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xaa"		=> "\xd3\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xab"		=> "\xd3\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xac"		=> "\xd3\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xad"		=> "\xd3\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xae"		=> "\xd3\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xaf"		=> "\xd3\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb0"		=> "\xd3\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb1"		=> "\xd3\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb2"		=> "\xd3\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb3"		=> "\xd3\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb4"		=> "\xd3\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb5"		=> "\xd3\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb6"		=> "\xd3\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb7"		=> "\xd3\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb8"		=> "\xd3\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xb9"		=> "\xd3\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xba"		=> "\xd3\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xbb"		=> "\xd3\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xbc"		=> "\xd3\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xbd"		=> "\xd3\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xbe"		=> "\xd3\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa6\xbf"		=> "\xd3\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x80"		=> "\xd3\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x83"		=> "\xd3\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x8d"		=> "\xd3\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x93"		=> "\xd3\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x94"		=> "\xd3\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x95"		=> "\xd3\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x97"		=> "\xd3\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x98"		=> "\xd3\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x99"		=> "\xd3\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x9b"		=> "\xd3\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x9d"		=> "\xd3\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\x9f"		=> "\xd3\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa0"		=> "\xd3\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa1"		=> "\xd3\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa2"		=> "\xd3\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa4"		=> "\xd3\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa7"		=> "\xd3\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa8"		=> "\xd3\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xa9"		=> "\xd3\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xaa"		=> "\xd3\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xac"		=> "\xd3\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xad"		=> "\xd3\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xae"		=> "\xd3\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb0"		=> "\xd3\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb1"		=> "\xd3\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb2"		=> "\xd3\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb4"		=> "\xd3\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb5"		=> "\xd3\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb6"		=> "\xd3\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb7"		=> "\xd3\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb8"		=> "\xd3\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xb9"		=> "\xd3\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xba"		=> "\xd3\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xbb"		=> "\xd3\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xbc"		=> "\xd3\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xbd"		=> "\xd3\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xbe"		=> "\xd3\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa7\xbf"		=> "\xd3\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x81"		=> "\xd3\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x82"		=> "\xd3\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x83"		=> "\xd3\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x84"		=> "\xd3\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x85"		=> "\xd3\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x86"		=> "\xd3\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x88"		=> "\xd3\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x89"		=> "\xd3\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x8a"		=> "\xd3\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x8b"		=> "\xd3\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x8c"		=> "\xd3\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x8d"		=> "\xd3\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x8e"		=> "\xd3\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x8f"		=> "\xd3\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x90"		=> "\xd3\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x91"		=> "\xd3\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x92"		=> "\xd3\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x93"		=> "\xd3\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x94"		=> "\xd3\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x95"		=> "\xd3\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x96"		=> "\xd3\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x97"		=> "\xd3\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x98"		=> "\xd3\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x99"		=> "\xd3\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x9a"		=> "\xd3\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x9b"		=> "\xd3\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x9c"		=> "\xd3\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x9d"		=> "\xd3\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xb0"		=> "\xd3\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb1"		=> "\xd3\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\xb1"		=> "\xd3\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa9\xb4"		=> "\xd3\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb9\xb0"		=> "\xd3\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x94"		=> "\xd3\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\xa8"		=> "\xd3\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb9"		=> "\xd3\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa4"		=> "\xd3\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa5"		=> "\xd3\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa7"		=> "\xd3\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9d\x87"		=> "\xd3\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x8e"		=> "\xd3\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa2"		=> "\xd3\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x88"		=> "\xd3\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb1"		=> "\xd3\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x96"		=> "\xd3\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa1\xac"		=> "\xd3\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa0"		=> "\xd3\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x9f"		=> "\xd3\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa5"		=> "\xd3\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa3"		=> "\xd3\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\x83"		=> "\xd3\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x88"		=> "\xd3\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb8"		=> "\xd3\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\x8d"		=> "\xd3\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x8a"		=> "\xd3\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xb9"		=> "\xd3\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x8f"		=> "\xd3\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb3"		=> "\xd3\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\x8c"		=> "\xd3\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb8"		=> "\xd3\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xbf"		=> "\xd3\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x87"		=> "\xd3\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xa8"		=> "\xd3\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xbd"		=> "\xd3\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x98"		=> "\xd3\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa0"		=> "\xd3\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa7"		=> "\xd3\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa4"		=> "\xd3\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\xb1"		=> "\xd3\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xae"		=> "\xd3\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\x80"		=> "\xd3\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb9"		=> "\xd3\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xb9"		=> "\xd3\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xb8"		=> "\xd3\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x89"		=> "\xd3\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x89"		=> "\xd3\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x8b"		=> "\xd3\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb3"		=> "\xd3\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x91"		=> "\xd3\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x89"		=> "\xd3\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb1"		=> "\xd3\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x88"		=> "\xd3\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xbc"		=> "\xd3\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x82"		=> "\xd3\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\xa4"		=> "\xd3\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x8e"		=> "\xd3\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x82"		=> "\xd3\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\x86"		=> "\xd3\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x99\x9e"		=> "\xd3\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x9a"		=> "\xd3\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x86"		=> "\xd3\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x99"		=> "\xd3\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x9e"		=> "\xd3\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xbe"		=> "\xd3\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb1\xbc"		=> "\xd3\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x89"		=> "\xd3\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x9d"		=> "\xd3\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x94"		=> "\xd3\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x85"		=> "\xd3\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x88"		=> "\xd3\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa8\xb1"		=> "\xd3\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9b\xa8"		=> "\xd3\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x8e"		=> "\xd3\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xbf"		=> "\xd3\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xb9"		=> "\xd3\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x87"		=> "\xd3\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xad"		=> "\xd3\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xbd"		=> "\xd3\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8e\x89"		=> "\xd3\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x9f"		=> "\xd3\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x8b"		=> "\xd3\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x81"		=> "\xd3\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x81"		=> "\xd3\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x87"		=> "\xd3\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xbb"		=> "\xd3\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xaa"		=> "\xd3\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa1"		=> "\xd3\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x88"		=> "\xd3\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xac\xb2"		=> "\xd3\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb1"		=> "\xd3\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xb2"		=> "\xd3\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x89"		=> "\xd3\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x9e"		=> "\xd4\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x9f"		=> "\xd4\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa0"		=> "\xd4\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa1"		=> "\xd4\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa2"		=> "\xd4\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa3"		=> "\xd4\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa4"		=> "\xd4\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa5"		=> "\xd4\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa6"		=> "\xd4\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa7"		=> "\xd4\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa8"		=> "\xd4\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xa9"		=> "\xd4\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xaa"		=> "\xd4\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xab"		=> "\xd4\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xac"		=> "\xd4\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xad"		=> "\xd4\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xae"		=> "\xd4\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xaf"		=> "\xd4\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb0"		=> "\xd4\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb1"		=> "\xd4\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb2"		=> "\xd4\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb3"		=> "\xd4\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb4"		=> "\xd4\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb5"		=> "\xd4\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb6"		=> "\xd4\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb7"		=> "\xd4\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb8"		=> "\xd4\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xb9"		=> "\xd4\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xba"		=> "\xd4\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xbb"		=> "\xd4\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xbc"		=> "\xd4\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xbd"		=> "\xd4\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\xbf"		=> "\xd4\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x80"		=> "\xd4\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x81"		=> "\xd4\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x82"		=> "\xd4\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x83"		=> "\xd4\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x84"		=> "\xd4\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x85"		=> "\xd4\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x86"		=> "\xd4\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x87"		=> "\xd4\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x89"		=> "\xd4\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x8a"		=> "\xd4\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x8b"		=> "\xd4\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x8c"		=> "\xd4\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x8d"		=> "\xd4\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x8e"		=> "\xd4\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x8f"		=> "\xd4\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x90"		=> "\xd4\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x91"		=> "\xd4\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x92"		=> "\xd4\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x93"		=> "\xd4\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x94"		=> "\xd4\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x95"		=> "\xd4\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x96"		=> "\xd4\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x97"		=> "\xd4\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x98"		=> "\xd4\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x99"		=> "\xd4\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x9a"		=> "\xd4\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x9b"		=> "\xd4\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x9c"		=> "\xd4\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x9d"		=> "\xd4\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x9e"		=> "\xd4\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\x9f"		=> "\xd4\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa0"		=> "\xd4\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa1"		=> "\xd4\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa2"		=> "\xd4\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa3"		=> "\xd4\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa4"		=> "\xd4\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa5"		=> "\xd4\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa6"		=> "\xd4\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa7"		=> "\xd4\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa8"		=> "\xd4\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xa9"		=> "\xd4\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xaa"		=> "\xd4\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xab"		=> "\xd4\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xac"		=> "\xd4\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xad"		=> "\xd4\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xae"		=> "\xd4\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xaf"		=> "\xd4\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb0"		=> "\xd4\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb1"		=> "\xd4\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb2"		=> "\xd4\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb3"		=> "\xd4\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb4"		=> "\xd4\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb5"		=> "\xd4\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb6"		=> "\xd4\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb7"		=> "\xd4\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb8"		=> "\xd4\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xba"		=> "\xd4\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xbb"		=> "\xd4\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xbc"		=> "\xd4\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xbd"		=> "\xd4\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xbe"		=> "\xd4\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xbf"		=> "\xd4\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x80"		=> "\xd4\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\xb4"		=> "\xd4\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\x93"		=> "\xd4\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x95"		=> "\xd4\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa2\x84"		=> "\xd4\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xab"		=> "\xd4\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xad"		=> "\xd4\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xb8\xb3"		=> "\xd4\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x8a"		=> "\xd4\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa4"		=> "\xd4\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x83"		=> "\xd4\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa3"		=> "\xd4\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\x81"		=> "\xd4\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x9f"		=> "\xd4\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb4"		=> "\xd4\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x95"		=> "\xd4\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xad"		=> "\xd4\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x98"		=> "\xd4\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x86"		=> "\xd4\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xbf"		=> "\xd4\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xba\x90"		=> "\xd4\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x98"		=> "\xd4\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x9c"		=> "\xd4\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x91"		=> "\xd4\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xbf"		=> "\xd4\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa8"		=> "\xd4\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xa2"		=> "\xd4\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xb0"		=> "\xd4\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xa6"		=> "\xd4\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x8a"		=> "\xd4\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x83"		=> "\xd4\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xa5"		=> "\xd4\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb3"		=> "\xd4\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa4"		=> "\xd4\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x88"		=> "\xd4\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xa6"		=> "\xd4\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x85"		=> "\xd4\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x98"		=> "\xd4\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x91"		=> "\xd4\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa7"		=> "\xd4\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x80"		=> "\xd4\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xa8"		=> "\xd4\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x81"		=> "\xd4\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x90"		=> "\xd4\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb4"		=> "\xd4\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x9d"		=> "\xd4\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\x95"		=> "\xd4\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9f\xb5"		=> "\xd4\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x95"		=> "\xd4\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x9d"		=> "\xd4\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xb8"		=> "\xd4\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x82"		=> "\xd4\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xbd"		=> "\xd4\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x89"		=> "\xd4\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xbe"		=> "\xd4\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\xb0"		=> "\xd4\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xbd"		=> "\xd4\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x8d"		=> "\xd4\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa8"		=> "\xd4\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb1"		=> "\xd4\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x92"		=> "\xd4\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9a\x82"		=> "\xd4\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x9e"		=> "\xd4\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x83"		=> "\xd4\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x8f"		=> "\xd4\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xac"		=> "\xd4\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xad"		=> "\xd4\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb3\x9f"		=> "\xd4\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xbf"		=> "\xd4\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xbb"		=> "\xd4\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\xa3"		=> "\xd4\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa9"		=> "\xd4\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbe\xa1"		=> "\xd4\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9a\xa4"		=> "\xd4\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x81"		=> "\xd4\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xaa"		=> "\xd4\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa0"		=> "\xd4\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\x82"		=> "\xd4\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xb6"		=> "\xd4\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xa5"		=> "\xd4\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa3"		=> "\xd4\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xa9"		=> "\xd4\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x99"		=> "\xd4\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xbd"		=> "\xd4\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xbc"		=> "\xd4\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x8e"		=> "\xd4\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x9e"		=> "\xd4\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x8e"		=> "\xd4\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9b\xbe"		=> "\xd4\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa0"		=> "\xd4\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x8e"		=> "\xd4\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb3"		=> "\xd4\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\xa3"		=> "\xd4\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xad"		=> "\xd4\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa7"		=> "\xd4\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x81"		=> "\xd5\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x82"		=> "\xd5\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x83"		=> "\xd5\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x84"		=> "\xd5\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x85"		=> "\xd5\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x86"		=> "\xd5\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x87"		=> "\xd5\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x88"		=> "\xd5\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x8b"		=> "\xd5\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x8c"		=> "\xd5\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x8d"		=> "\xd5\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x8e"		=> "\xd5\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x8f"		=> "\xd5\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x90"		=> "\xd5\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x91"		=> "\xd5\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x92"		=> "\xd5\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x94"		=> "\xd5\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x95"		=> "\xd5\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x96"		=> "\xd5\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x97"		=> "\xd5\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x98"		=> "\xd5\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x99"		=> "\xd5\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x9a"		=> "\xd5\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x9b"		=> "\xd5\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x9c"		=> "\xd5\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x9d"		=> "\xd5\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x9e"		=> "\xd5\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\x9f"		=> "\xd5\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa0"		=> "\xd5\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa1"		=> "\xd5\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa2"		=> "\xd5\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa3"		=> "\xd5\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa4"		=> "\xd5\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa5"		=> "\xd5\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa6"		=> "\xd5\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa7"		=> "\xd5\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa8"		=> "\xd5\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xa9"		=> "\xd5\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xaa"		=> "\xd5\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xab"		=> "\xd5\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xac"		=> "\xd5\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xad"		=> "\xd5\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xae"		=> "\xd5\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xaf"		=> "\xd5\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb0"		=> "\xd5\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb1"		=> "\xd5\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb2"		=> "\xd5\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb3"		=> "\xd5\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb4"		=> "\xd5\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb5"		=> "\xd5\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb6"		=> "\xd5\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb7"		=> "\xd5\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb8"		=> "\xd5\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xb9"		=> "\xd5\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xba"		=> "\xd5\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xbb"		=> "\xd5\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xbc"		=> "\xd5\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xbd"		=> "\xd5\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xbe"		=> "\xd5\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaa\xbf"		=> "\xd5\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x80"		=> "\xd5\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x81"		=> "\xd5\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x82"		=> "\xd5\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x83"		=> "\xd5\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x84"		=> "\xd5\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x85"		=> "\xd5\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x86"		=> "\xd5\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x87"		=> "\xd5\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x88"		=> "\xd5\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x89"		=> "\xd5\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x8a"		=> "\xd5\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x8b"		=> "\xd5\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x8c"		=> "\xd5\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x8d"		=> "\xd5\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x8e"		=> "\xd5\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x8f"		=> "\xd5\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x90"		=> "\xd5\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x91"		=> "\xd5\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x92"		=> "\xd5\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x93"		=> "\xd5\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x94"		=> "\xd5\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x95"		=> "\xd5\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x96"		=> "\xd5\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x97"		=> "\xd5\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x98"		=> "\xd5\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x99"		=> "\xd5\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x9a"		=> "\xd5\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x9b"		=> "\xd5\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x9c"		=> "\xd5\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x9d"		=> "\xd5\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x9e"		=> "\xd5\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\x9f"		=> "\xd5\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa0"		=> "\xd5\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa1"		=> "\xd5\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa2"		=> "\xd5\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa3"		=> "\xd5\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xa1"		=> "\xd5\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb8"		=> "\xd5\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\xa8"		=> "\xd5\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x85"		=> "\xd5\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa6\xa8"		=> "\xd5\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x8b"		=> "\xd5\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x8d"		=> "\xd5\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\xb8"		=> "\xd5\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x88"		=> "\xd5\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x98"		=> "\xd5\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x8b"		=> "\xd5\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x85"		=> "\xd5\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x84"		=> "\xd5\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xba"		=> "\xd5\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xaf\xa8"		=> "\xd5\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xbb"		=> "\xd5\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\xa1"		=> "\xd5\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa9\xb9"		=> "\xd5\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\x98"		=> "\xd5\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xbe"		=> "\xd5\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x8f"		=> "\xd5\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\xa9"		=> "\xd5\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x97"		=> "\xd5\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xad"		=> "\xd5\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\x95"		=> "\xd5\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xb8"		=> "\xd5\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\x88"		=> "\xd5\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa0"		=> "\xd5\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x98"		=> "\xd5\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\x99"		=> "\xd5\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb9\x9b"		=> "\xd5\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xbd"		=> "\xd5\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa8\x9f"		=> "\xd5\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xa0"		=> "\xd5\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb0"		=> "\xd5\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbc\xb3"		=> "\xd5\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\xa0"		=> "\xd5\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x8c"		=> "\xd5\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb6\xa8"		=> "\xd5\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9d\x96"		=> "\xd5\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x88"		=> "\xd5\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x90"		=> "\xd5\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa6"		=> "\xd5\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x97"		=> "\xd5\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\x80"		=> "\xd5\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x98\xb4"		=> "\xd5\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x9c"		=> "\xd5\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x9b"		=> "\xd5\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xad"		=> "\xd5\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xbe"		=> "\xd5\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xbc"		=> "\xd5\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb5"		=> "\xd5\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xa7"		=> "\xd5\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xa9"		=> "\xd5\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x86"		=> "\xd5\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x87"		=> "\xd5\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xac"		=> "\xd5\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xae"		=> "\xd5\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x98"		=> "\xd5\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb2"		=> "\xd5\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\xb0"		=> "\xd5\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x99"		=> "\xd5\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\x85"		=> "\xd5\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\x97"		=> "\xd5\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x97"		=> "\xd5\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x99"		=> "\xd5\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x99"		=> "\xd5\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\x8d"		=> "\xd5\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x96\x9f"		=> "\xd5\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9c\x9f"		=> "\xd5\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x84"		=> "\xd5\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\xa7"		=> "\xd5\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xbb"		=> "\xd5\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x9e"		=> "\xd5\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x88"		=> "\xd5\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xa6"		=> "\xd5\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x95"		=> "\xd5\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x96\xb9"		=> "\xd5\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x8a"		=> "\xd5\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9c\x87"		=> "\xd5\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xaf"		=> "\xd5\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x95\x87"		=> "\xd5\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xb5"		=> "\xd5\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb8"		=> "\xd5\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa3"		=> "\xd5\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x81"		=> "\xd5\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x81"		=> "\xd5\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb0"		=> "\xd5\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x89"		=> "\xd5\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x94"		=> "\xd5\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x95\xb4"		=> "\xd5\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xaf"		=> "\xd5\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa3"		=> "\xd5\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xbf"		=> "\xd5\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa4"		=> "\xd6\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa5"		=> "\xd6\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa6"		=> "\xd6\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa7"		=> "\xd6\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa8"		=> "\xd6\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xa9"		=> "\xd6\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xaa"		=> "\xd6\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xab"		=> "\xd6\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xac"		=> "\xd6\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xad"		=> "\xd6\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xae"		=> "\xd6\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xaf"		=> "\xd6\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb0"		=> "\xd6\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb1"		=> "\xd6\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb2"		=> "\xd6\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb3"		=> "\xd6\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb4"		=> "\xd6\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb5"		=> "\xd6\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb6"		=> "\xd6\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb7"		=> "\xd6\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb8"		=> "\xd6\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xb9"		=> "\xd6\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xba"		=> "\xd6\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xbb"		=> "\xd6\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xbc"		=> "\xd6\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xbd"		=> "\xd6\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xbe"		=> "\xd6\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xab\xbf"		=> "\xd6\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x80"		=> "\xd6\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x81"		=> "\xd6\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x82"		=> "\xd6\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x83"		=> "\xd6\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x84"		=> "\xd6\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x85"		=> "\xd6\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x86"		=> "\xd6\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x88"		=> "\xd6\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x89"		=> "\xd6\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x8a"		=> "\xd6\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x8b"		=> "\xd6\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x8c"		=> "\xd6\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x8d"		=> "\xd6\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x8e"		=> "\xd6\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x8f"		=> "\xd6\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x90"		=> "\xd6\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x91"		=> "\xd6\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x92"		=> "\xd6\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x93"		=> "\xd6\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x94"		=> "\xd6\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x95"		=> "\xd6\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x96"		=> "\xd6\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x97"		=> "\xd6\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x98"		=> "\xd6\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x99"		=> "\xd6\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x9a"		=> "\xd6\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x9b"		=> "\xd6\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x9c"		=> "\xd6\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x9d"		=> "\xd6\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x9e"		=> "\xd6\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\x9f"		=> "\xd6\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa0"		=> "\xd6\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa1"		=> "\xd6\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa2"		=> "\xd6\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa3"		=> "\xd6\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa4"		=> "\xd6\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa5"		=> "\xd6\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa7"		=> "\xd6\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa8"		=> "\xd6\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xa9"		=> "\xd6\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xaa"		=> "\xd6\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xab"		=> "\xd6\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xac"		=> "\xd6\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xad"		=> "\xd6\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xae"		=> "\xd6\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xaf"		=> "\xd6\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb0"		=> "\xd6\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb1"		=> "\xd6\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb2"		=> "\xd6\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb3"		=> "\xd6\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb4"		=> "\xd6\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb5"		=> "\xd6\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb6"		=> "\xd6\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb7"		=> "\xd6\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb8"		=> "\xd6\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xb9"		=> "\xd6\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xba"		=> "\xd6\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xbb"		=> "\xd6\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xbc"		=> "\xd6\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xbd"		=> "\xd6\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xbe"		=> "\xd6\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xac\xbf"		=> "\xd6\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x80"		=> "\xd6\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x81"		=> "\xd6\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x82"		=> "\xd6\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x83"		=> "\xd6\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x84"		=> "\xd6\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x85"		=> "\xd6\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xa7"		=> "\xd6\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x87"		=> "\xd6\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x91"		=> "\xd6\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x81"		=> "\xd6\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x9d"		=> "\xd6\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9e\x9d"		=> "\xd6\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xaf"		=> "\xd6\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb1"		=> "\xd6\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9c\x98"		=> "\xd6\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\xa5"		=> "\xd6\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xa2"		=> "\xd6\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x82"		=> "\xd6\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x81"		=> "\xd6\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x8b"		=> "\xd6\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x87"		=> "\xd6\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x81\x8c"		=> "\xd6\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\xb4"		=> "\xd6\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x8d"		=> "\xd6\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xae\x96"		=> "\xd6\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xa7"		=> "\xd6\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xbc"		=> "\xd6\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x84"		=> "\xd6\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x80"		=> "\xd6\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x87"		=> "\xd6\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xad\xa2"		=> "\xd6\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xbe"		=> "\xd6\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xaa"		=> "\xd6\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\xa8"		=> "\xd6\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb8"		=> "\xd6\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x97"		=> "\xd6\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\x9a"		=> "\xd6\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb7"		=> "\xd6\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb3"		=> "\xd6\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xb4"		=> "\xd6\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xae"		=> "\xd6\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x9c"		=> "\xd6\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x99"		=> "\xd6\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb6"		=> "\xd6\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x99\xba"		=> "\xd6\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\xa9"		=> "\xd6\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa8\x9a"		=> "\xd6\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa8"		=> "\xd6\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x82\x99"		=> "\xd6\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x97\x94"		=> "\xd6\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x9e"		=> "\xd6\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xbb"		=> "\xd6\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaa\x92"		=> "\xd6\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xad"		=> "\xd6\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9b\x85"		=> "\xd6\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa0"		=> "\xd6\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\x9f"		=> "\xd6\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xb7"		=> "\xd6\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x88"		=> "\xd6\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x8d"		=> "\xd6\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\xbf"		=> "\xd6\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x8d"		=> "\xd6\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb2"		=> "\xd6\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x97"		=> "\xd6\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x9f"		=> "\xd6\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa8"		=> "\xd6\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x9e"		=> "\xd6\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb4\xb2"		=> "\xd6\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x8c"		=> "\xd6\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb2\xa5"		=> "\xd6\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xb4"		=> "\xd6\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x82\x98"		=> "\xd6\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x9a"		=> "\xd6\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x92"		=> "\xd6\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9a\xb1"		=> "\xd6\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x99"		=> "\xd6\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xbc"		=> "\xd6\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xaa\xa4"		=> "\xd6\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8f\xa0"		=> "\xd6\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa0\xaa"		=> "\xd6\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x9b"		=> "\xd6\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\xb1"		=> "\xd6\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xaa"		=> "\xd6\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb8"		=> "\xd6\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x9b"		=> "\xd6\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x90"		=> "\xd6\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xab\xb9"		=> "\xd6\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x83\x9b"		=> "\xd6\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x85\xae"		=> "\xd6\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x84"		=> "\xd6\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa9"		=> "\xd6\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb1"		=> "\xd6\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xbb"		=> "\xd6\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x97"		=> "\xd6\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\xb1"		=> "\xd6\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa9"		=> "\xd6\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x9b\x80"		=> "\xd6\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xae"		=> "\xd6\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x93\xb8"		=> "\xd6\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xad\x91"		=> "\xd6\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x86"		=> "\xd7\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x87"		=> "\xd7\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x88"		=> "\xd7\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x89"		=> "\xd7\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x8a"		=> "\xd7\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x8b"		=> "\xd7\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x8c"		=> "\xd7\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x8d"		=> "\xd7\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x8e"		=> "\xd7\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x8f"		=> "\xd7\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x90"		=> "\xd7\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x91"		=> "\xd7\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x92"		=> "\xd7\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x93"		=> "\xd7\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x94"		=> "\xd7\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x95"		=> "\xd7\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x96"		=> "\xd7\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x97"		=> "\xd7\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x98"		=> "\xd7\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x99"		=> "\xd7\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x9a"		=> "\xd7\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x9b"		=> "\xd7\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x9c"		=> "\xd7\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x9d"		=> "\xd7\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x9e"		=> "\xd7\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\x9f"		=> "\xd7\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa0"		=> "\xd7\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa1"		=> "\xd7\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa2"		=> "\xd7\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa3"		=> "\xd7\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa4"		=> "\xd7\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa5"		=> "\xd7\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa7"		=> "\xd7\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa8"		=> "\xd7\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xa9"		=> "\xd7\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xaa"		=> "\xd7\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xab"		=> "\xd7\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xad"		=> "\xd7\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xae"		=> "\xd7\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xaf"		=> "\xd7\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb0"		=> "\xd7\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb1"		=> "\xd7\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb2"		=> "\xd7\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb3"		=> "\xd7\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb4"		=> "\xd7\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb5"		=> "\xd7\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb6"		=> "\xd7\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb7"		=> "\xd7\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb8"		=> "\xd7\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xb9"		=> "\xd7\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xba"		=> "\xd7\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xbb"		=> "\xd7\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xbc"		=> "\xd7\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xbd"		=> "\xd7\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xbe"		=> "\xd7\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xad\xbf"		=> "\xd7\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x80"		=> "\xd7\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x81"		=> "\xd7\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x82"		=> "\xd7\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x83"		=> "\xd7\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x84"		=> "\xd7\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x85"		=> "\xd7\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x86"		=> "\xd7\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x87"		=> "\xd7\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x88"		=> "\xd7\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x89"		=> "\xd7\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x8a"		=> "\xd7\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x8b"		=> "\xd7\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x8c"		=> "\xd7\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x8d"		=> "\xd7\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x8e"		=> "\xd7\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x8f"		=> "\xd7\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x90"		=> "\xd7\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x91"		=> "\xd7\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x92"		=> "\xd7\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x93"		=> "\xd7\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x94"		=> "\xd7\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x95"		=> "\xd7\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x96"		=> "\xd7\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x97"		=> "\xd7\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x98"		=> "\xd7\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x99"		=> "\xd7\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x9a"		=> "\xd7\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x9b"		=> "\xd7\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x9c"		=> "\xd7\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x9d"		=> "\xd7\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x9e"		=> "\xd7\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\x9f"		=> "\xd7\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xac"		=> "\xd7\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb1"		=> "\xd7\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xbb"		=> "\xd7\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x87"		=> "\xd7\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x90"		=> "\xd7\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xaa"		=> "\xd7\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x89"		=> "\xd7\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x9e"		=> "\xd7\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x8f"		=> "\xd7\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xa8"		=> "\xd7\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x9d"		=> "\xd7\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa9\xbb"		=> "\xd7\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x93"		=> "\xd7\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xaa"		=> "\xd7\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xbd"		=> "\xd7\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x93"		=> "\xd7\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa0\x96"		=> "\xd7\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xac"		=> "\xd7\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb0"		=> "\xd7\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x9a"		=> "\xd7\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xaf\x86"		=> "\xd7\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\xa9"		=> "\xd7\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x84"		=> "\xd7\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x85"		=> "\xd7\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa6\x86"		=> "\xd7\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x9e"		=> "\xd7\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\xae"		=> "\xd7\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb6"		=> "\xd7\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa4\x8e"		=> "\xd7\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x94\xa5"		=> "\xd7\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xbd"		=> "\xd7\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x98"		=> "\xd7\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa0"		=> "\xd7\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbc\x80"		=> "\xd7\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x86"		=> "\xd7\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x86"		=> "\xd7\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x89"		=> "\xd7\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x99"		=> "\xd7\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x93"		=> "\xd7\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa1\x8c"		=> "\xd7\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x90\xa2"		=> "\xd7\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x81"		=> "\xd7\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x8c"		=> "\xd7\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x84"		=> "\xd7\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\x80"		=> "\xd7\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x81\xbc"		=> "\xd7\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb5\x8a"		=> "\xd7\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xb9"		=> "\xd7\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa8"		=> "\xd7\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x84"		=> "\xd7\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa7\xbf"		=> "\xd7\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x8b"		=> "\xd7\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb7\x84"		=> "\xd7\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x9c"		=> "\xd7\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb4\xab"		=> "\xd7\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x94"		=> "\xd7\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xbd"		=> "\xd7\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xbb\x93"		=> "\xd7\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x90"		=> "\xd7\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x87\xaa"		=> "\xd7\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb8\x8d"		=> "\xd7\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x97"		=> "\xd7\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xac\x83"		=> "\xd7\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xa3\x95"		=> "\xd7\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xaa"		=> "\xd7\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xae\x97"		=> "\xd7\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\xbc"		=> "\xd7\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xbb"		=> "\xd7\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\xb5"		=> "\xd7\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb9"		=> "\xd7\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb0"		=> "\xd7\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x8f"		=> "\xd7\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x8d"		=> "\xd7\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa7\x9f"		=> "\xd7\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb3"		=> "\xd7\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x92"		=> "\xd7\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x97\x8f"		=> "\xd7\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa5\x96"		=> "\xd7\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x85"		=> "\xd7\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xbb"		=> "\xd7\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbb\x84"		=> "\xd7\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x92\xbb"		=> "\xd7\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xba\x82"		=> "\xd7\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb4"		=> "\xd7\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x89"		=> "\xd7\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9c\x80"		=> "\xd7\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\xaa"		=> "\xd7\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\x8a"		=> "\xd7\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb5"		=> "\xd7\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x98\xa8"		=> "\xd7\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xa6"		=> "\xd7\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x90"		=> "\xd7\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x9f\x9e"		=> "\xd7\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x9a"		=> "\xd7\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x9c"		=> "\xd7\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x90"		=> "\xd7\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa7"		=> "\xd7\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb8"		=> "\xd8\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb9"		=> "\xd8\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xba"		=> "\xd8\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xbb"		=> "\xd8\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xbc"		=> "\xd8\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xbd"		=> "\xd8\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xbe"		=> "\xd8\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xbf"		=> "\xd8\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x80"		=> "\xd8\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x82"		=> "\xd8\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x83"		=> "\xd8\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x84"		=> "\xd8\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x85"		=> "\xd8\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x88"		=> "\xd8\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x8a"		=> "\xd8\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x8b"		=> "\xd8\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x8d"		=> "\xd8\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x8e"		=> "\xd8\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x8f"		=> "\xd8\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x90"		=> "\xd8\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x91"		=> "\xd8\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x92"		=> "\xd8\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x93"		=> "\xd8\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x94"		=> "\xd8\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x96"		=> "\xd8\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x97"		=> "\xd8\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x98"		=> "\xd8\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x99"		=> "\xd8\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x9b"		=> "\xd8\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x9c"		=> "\xd8\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x9d"		=> "\xd8\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x9e"		=> "\xd8\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\x9f"		=> "\xd8\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa0"		=> "\xd8\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa3"		=> "\xd8\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa4"		=> "\xd8\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa5"		=> "\xd8\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa6"		=> "\xd8\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa7"		=> "\xd8\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa8"		=> "\xd8\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xa9"		=> "\xd8\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xac"		=> "\xd8\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xad"		=> "\xd8\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xae"		=> "\xd8\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xaf"		=> "\xd8\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb0"		=> "\xd8\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb1"		=> "\xd8\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb2"		=> "\xd8\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb4"		=> "\xd8\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb5"		=> "\xd8\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb6"		=> "\xd8\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb7"		=> "\xd8\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xbb"		=> "\xd8\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xbc"		=> "\xd8\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xbd"		=> "\xd8\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xbe"		=> "\xd8\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xbf"		=> "\xd8\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x80"		=> "\xd8\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x81"		=> "\xd8\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x83"		=> "\xd8\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x84"		=> "\xd8\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x86"		=> "\xd8\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x87"		=> "\xd8\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x88"		=> "\xd8\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x8b"		=> "\xd8\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x8d"		=> "\xd8\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x8e"		=> "\xd8\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x8f"		=> "\xd8\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x90"		=> "\xd8\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x91"		=> "\xd8\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x92"		=> "\xd8\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x93"		=> "\xd8\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x95"		=> "\xd8\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x96"		=> "\xd8\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x97"		=> "\xd8\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x99"		=> "\xd8\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x9a"		=> "\xd8\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x9b"		=> "\xd8\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x9c"		=> "\xd8\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x9d"		=> "\xd8\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x9e"		=> "\xd8\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\x9f"		=> "\xd8\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa0"		=> "\xd8\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa1"		=> "\xd8\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa2"		=> "\xd8\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa3"		=> "\xd8\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa4"		=> "\xd8\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa5"		=> "\xd8\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa6"		=> "\xd8\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa7"		=> "\xd8\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa8"		=> "\xd8\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xa9"		=> "\xd8\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xaa"		=> "\xd8\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xab"		=> "\xd8\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xac"		=> "\xd8\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xad"		=> "\xd8\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x8d"		=> "\xd8\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x8c"		=> "\xd8\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x80"		=> "\xd8\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x90"		=> "\xd8\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xbf"		=> "\xd8\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x85"		=> "\xd8\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x95"		=> "\xd8\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x98"		=> "\xd8\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\x9e"		=> "\xd8\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xac\xb2"		=> "\xd8\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\xac"		=> "\xd8\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa9"		=> "\xd8\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xa8"		=> "\xd8\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\xba"		=> "\xd8\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xbf"		=> "\xd8\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x95"		=> "\xd8\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x87"		=> "\xd8\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xad"		=> "\xd8\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xbb"		=> "\xd8\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xae"		=> "\xd8\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\x90"		=> "\xd8\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x9f"		=> "\xd8\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x83\xa4"		=> "\xd8\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x97"		=> "\xd8\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xaf\x93"		=> "\xd8\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9d\xbe"		=> "\xd8\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\x97"		=> "\xd8\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xb6"		=> "\xd8\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x9f"		=> "\xd8\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\x90"		=> "\xd8\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\x9c"		=> "\xd8\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb9\xa9"		=> "\xd8\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\x93"		=> "\xd8\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x88"		=> "\xd8\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xad\x9b"		=> "\xd8\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xac"		=> "\xd8\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x8f"		=> "\xd8\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x84"		=> "\xd8\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x8d"		=> "\xd8\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\x9d"		=> "\xd8\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa3"		=> "\xd8\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xa5"		=> "\xd8\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xae"		=> "\xd8\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9d\xa5"		=> "\xd8\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x9d"		=> "\xd8\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x9a"		=> "\xd8\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb5"		=> "\xd8\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xa6"		=> "\xd8\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xae"		=> "\xd8\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\xbe"		=> "\xd8\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x9c"		=> "\xd8\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa6"		=> "\xd8\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa3"		=> "\xd8\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x82"		=> "\xd8\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x88"		=> "\xd8\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x8e"		=> "\xd8\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xad"		=> "\xd8\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xb3"		=> "\xd8\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\xbf"		=> "\xd8\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x80"		=> "\xd8\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x8c"		=> "\xd8\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x9e"		=> "\xd8\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xa1"		=> "\xd8\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\x9c"		=> "\xd8\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xaf"		=> "\xd8\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x89\xbd"		=> "\xd8\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x82"		=> "\xd8\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x81"		=> "\xd8\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x90"		=> "\xd8\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\x93"		=> "\xd8\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x82"		=> "\xd8\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbd\x94"		=> "\xd8\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xbb"		=> "\xd8\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x83"		=> "\xd8\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x89"		=> "\xd8\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x82"		=> "\xd8\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa8"		=> "\xd8\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xa1"		=> "\xd8\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xab"		=> "\xd8\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x9e"		=> "\xd8\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x9b"		=> "\xd8\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb3"		=> "\xd8\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa2"		=> "\xd8\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa4"		=> "\xd8\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\xb5"		=> "\xd8\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa5"		=> "\xd8\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xa7"		=> "\xd8\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\x89"		=> "\xd8\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xab"		=> "\xd8\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x9e"		=> "\xd8\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa7"		=> "\xd8\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xb8"		=> "\xd8\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x9a"		=> "\xd8\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x9d"		=> "\xd8\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xae"		=> "\xd9\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xaf"		=> "\xd9\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb0"		=> "\xd9\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb1"		=> "\xd9\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb2"		=> "\xd9\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb3"		=> "\xd9\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb4"		=> "\xd9\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb5"		=> "\xd9\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb6"		=> "\xd9\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb7"		=> "\xd9\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb8"		=> "\xd9\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xb9"		=> "\xd9\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xba"		=> "\xd9\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xbb"		=> "\xd9\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xbc"		=> "\xd9\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xbd"		=> "\xd9\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xbe"		=> "\xd9\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb2\xbf"		=> "\xd9\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x80"		=> "\xd9\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x81"		=> "\xd9\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x82"		=> "\xd9\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x83"		=> "\xd9\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x84"		=> "\xd9\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x85"		=> "\xd9\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x86"		=> "\xd9\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x87"		=> "\xd9\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x88"		=> "\xd9\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x89"		=> "\xd9\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x8a"		=> "\xd9\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x8b"		=> "\xd9\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x8c"		=> "\xd9\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x8d"		=> "\xd9\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x8e"		=> "\xd9\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x8f"		=> "\xd9\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x90"		=> "\xd9\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x91"		=> "\xd9\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x92"		=> "\xd9\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x93"		=> "\xd9\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x94"		=> "\xd9\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x95"		=> "\xd9\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x96"		=> "\xd9\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x97"		=> "\xd9\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x98"		=> "\xd9\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x99"		=> "\xd9\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x9a"		=> "\xd9\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x9b"		=> "\xd9\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x9c"		=> "\xd9\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x9d"		=> "\xd9\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x9e"		=> "\xd9\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\x9f"		=> "\xd9\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa0"		=> "\xd9\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa1"		=> "\xd9\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa2"		=> "\xd9\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa3"		=> "\xd9\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa4"		=> "\xd9\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa5"		=> "\xd9\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa6"		=> "\xd9\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa7"		=> "\xd9\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa8"		=> "\xd9\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xa9"		=> "\xd9\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xaa"		=> "\xd9\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xab"		=> "\xd9\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xac"		=> "\xd9\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xad"		=> "\xd9\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xae"		=> "\xd9\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xaf"		=> "\xd9\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb0"		=> "\xd9\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb1"		=> "\xd9\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb2"		=> "\xd9\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb3"		=> "\xd9\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb4"		=> "\xd9\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb5"		=> "\xd9\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb6"		=> "\xd9\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb7"		=> "\xd9\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb8"		=> "\xd9\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xb9"		=> "\xd9\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xba"		=> "\xd9\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xbb"		=> "\xd9\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xbc"		=> "\xd9\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xbd"		=> "\xd9\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xbe"		=> "\xd9\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb3\xbf"		=> "\xd9\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x80"		=> "\xd9\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x81"		=> "\xd9\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x82"		=> "\xd9\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x83"		=> "\xd9\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x84"		=> "\xd9\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x85"		=> "\xd9\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x86"		=> "\xd9\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x87"		=> "\xd9\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x88"		=> "\xd9\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x89"		=> "\xd9\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x8a"		=> "\xd9\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x8b"		=> "\xd9\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x8c"		=> "\xd9\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x8d"		=> "\xd9\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x9f"		=> "\xd9\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x97"		=> "\xd9\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xb2"		=> "\xd9\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbc\xbd"		=> "\xd9\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb6"		=> "\xd9\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xb4"		=> "\xd9\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x91"		=> "\xd9\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x89"		=> "\xd9\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x83"		=> "\xd9\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x8f"		=> "\xd9\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xbe"		=> "\xd9\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xbb"		=> "\xd9\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xaa"		=> "\xd9\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xbc"		=> "\xd9\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\xac"		=> "\xd9\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbe\x94"		=> "\xd9\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa6"		=> "\xd9\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa8"		=> "\xd9\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xaa"		=> "\xd9\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x85"		=> "\xd9\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x9a"		=> "\xd9\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xa3"		=> "\xd9\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x9c"		=> "\xd9\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x91"		=> "\xd9\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x9f"		=> "\xd9\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb8"		=> "\xd9\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa9"		=> "\xd9\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x8c"		=> "\xd9\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xb3"		=> "\xd9\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xac"		=> "\xd9\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x8f"		=> "\xd9\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xae"		=> "\xd9\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xad"		=> "\xd9\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\xbe"		=> "\xd9\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x9c"		=> "\xd9\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\x8c"		=> "\xd9\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa5"		=> "\xd9\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x80\xa8"		=> "\xd9\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xbe"		=> "\xd9\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x83"		=> "\xd9\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x95"		=> "\xd9\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x88"		=> "\xd9\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\x8e"		=> "\xd9\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xac"		=> "\xd9\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x81\xbb"		=> "\xd9\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa5"		=> "\xd9\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa7"		=> "\xd9\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xa9"		=> "\xd9\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x82\xba"		=> "\xd9\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\x96"		=> "\xd9\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x86"		=> "\xd9\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xad"		=> "\xd9\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xac"		=> "\xd9\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xa6"		=> "\xd9\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x83\xae"		=> "\xd9\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x87"		=> "\xd9\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x84\x8b"		=> "\xd9\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbb\x9d"		=> "\xd9\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xbd"		=> "\xd9\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\x98"		=> "\xd9\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbd\xa5"		=> "\xd9\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xbf\x8e"		=> "\xd9\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbe\xa0"		=> "\xd9\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x86"		=> "\xd9\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xb1\xb4"		=> "\xd9\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\xae"		=> "\xd9\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xbd"		=> "\xd9\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbb\x89"		=> "\xd9\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x98"		=> "\xd9\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x81"		=> "\xd9\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x94"		=> "\xd9\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb9"		=> "\xd9\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x8d"		=> "\xd9\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa8\x87"		=> "\xd9\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x90"		=> "\xd9\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xab"		=> "\xd9\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x99"		=> "\xd9\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x95"		=> "\xd9\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xa0"		=> "\xd9\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x85\x96"		=> "\xd9\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb3"		=> "\xd9\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xae"		=> "\xd9\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa2\xa4"		=> "\xd9\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xba\xb5"		=> "\xd9\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x84\x94"		=> "\xd9\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa3\x92"		=> "\xd9\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xa6\x80"		=> "\xd9\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xac\xb4"		=> "\xd9\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa0\x83"		=> "\xd9\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\xbe\xb8"		=> "\xd9\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xab"		=> "\xd9\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xb1"		=> "\xd9\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xbd"		=> "\xd9\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xbc"		=> "\xd9\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x8e"		=> "\xda\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x8f"		=> "\xda\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x90"		=> "\xda\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x91"		=> "\xda\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x92"		=> "\xda\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x93"		=> "\xda\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x94"		=> "\xda\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x95"		=> "\xda\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x96"		=> "\xda\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x97"		=> "\xda\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x98"		=> "\xda\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x99"		=> "\xda\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x9a"		=> "\xda\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x9b"		=> "\xda\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\x9c"		=> "\xda\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb4\xa0"		=> "\xda\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x91"		=> "\xda\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x92"		=> "\xda\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x97"		=> "\xda\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x9f"		=> "\xda\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa5"		=> "\xda\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa8"		=> "\xda\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xa9"		=> "\xda\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xaa"		=> "\xda\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xac"		=> "\xda\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xae"		=> "\xda\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xaf"		=> "\xda\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb1"		=> "\xda\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb2"		=> "\xda\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb8"		=> "\xda\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xb9"		=> "\xda\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xba"		=> "\xda\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xbb"		=> "\xda\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xbc"		=> "\xda\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xbd"		=> "\xda\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xbe"		=> "\xda\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\xbf"		=> "\xda\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x80"		=> "\xda\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x82"		=> "\xda\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x83"		=> "\xda\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x86"		=> "\xda\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x87"		=> "\xda\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x88"		=> "\xda\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x89"		=> "\xda\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x8c"		=> "\xda\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x8d"		=> "\xda\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x8e"		=> "\xda\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x8f"		=> "\xda\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x90"		=> "\xda\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x92"		=> "\xda\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x93"		=> "\xda\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x95"		=> "\xda\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x96"		=> "\xda\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x97"		=> "\xda\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x98"		=> "\xda\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x99"		=> "\xda\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x9a"		=> "\xda\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x9b"		=> "\xda\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x9c"		=> "\xda\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x9d"		=> "\xda\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\x9e"		=> "\xda\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa0"		=> "\xda\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa1"		=> "\xda\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa2"		=> "\xda\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa4"		=> "\xda\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa5"		=> "\xda\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa6"		=> "\xda\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa7"		=> "\xda\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa8"		=> "\xda\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xa9"		=> "\xda\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xaa"		=> "\xda\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xab"		=> "\xda\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xac"		=> "\xda\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xad"		=> "\xda\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xae"		=> "\xda\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xaf"		=> "\xda\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb0"		=> "\xda\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb2"		=> "\xda\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb6"		=> "\xda\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb7"		=> "\xda\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xb9"		=> "\xda\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xbb"		=> "\xda\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb6\xbd"		=> "\xda\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x80"		=> "\xda\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x81"		=> "\xda\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x82"		=> "\xda\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x85"		=> "\xda\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x87"		=> "\xda\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x88"		=> "\xda\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x89"		=> "\xda\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x8a"		=> "\xda\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x8d"		=> "\xda\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x90"		=> "\xda\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x92"		=> "\xda\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x93"		=> "\xda\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x94"		=> "\xda\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\x87"		=> "\xda\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\x96"		=> "\xda\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa2"		=> "\xda\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x86\xa5"		=> "\xda\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa0"		=> "\xda\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa6"		=> "\xda\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xa7"		=> "\xda\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xaa"		=> "\xda\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb4"		=> "\xda\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb5"		=> "\xda\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xae\xb7"		=> "\xda\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x82"		=> "\xda\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x83"		=> "\xda\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x8b"		=> "\xda\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x8f"		=> "\xda\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x8e"		=> "\xda\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x92"		=> "\xda\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x93"		=> "\xda\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x94"		=> "\xda\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x96"		=> "\xda\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x98"		=> "\xda\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x99"		=> "\xda\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x9c"		=> "\xda\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\x9f"		=> "\xda\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa0"		=> "\xda\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa4"		=> "\xda\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa8"		=> "\xda\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xa9"		=> "\xda\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xae"		=> "\xda\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb0"		=> "\xda\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb3"		=> "\xda\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb6"		=> "\xda\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xb9"		=> "\xda\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xbc"		=> "\xda\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xaf\xbf"		=> "\xda\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x80"		=> "\xda\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x82"		=> "\xda\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x84"		=> "\xda\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x87"		=> "\xda\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x8c"		=> "\xda\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x8f"		=> "\xda\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x91"		=> "\xda\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x92"		=> "\xda\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x94"		=> "\xda\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x95"		=> "\xda\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x96"		=> "\xda\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x99"		=> "\xda\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x9b"		=> "\xda\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x98"		=> "\xda\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x9d"		=> "\xda\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\x9f"		=> "\xda\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa0"		=> "\xda\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa1"		=> "\xda\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa5"		=> "\xda\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xa7"		=> "\xda\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xaa"		=> "\xda\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xab"		=> "\xda\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xae"		=> "\xda\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xaf"		=> "\xda\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb2"		=> "\xda\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb3"		=> "\xda\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb5"		=> "\xda\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb0\xb6"		=> "\xda\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xa9"		=> "\xda\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\xba"		=> "\xda\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x9d"		=> "\xda\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xa2"		=> "\xda\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xa1"		=> "\xda\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xb1"		=> "\xda\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xaa"		=> "\xda\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xbd"		=> "\xda\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\xbc"		=> "\xda\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x82"		=> "\xda\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x89"		=> "\xda\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x94"		=> "\xda\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\x9f"		=> "\xda\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xa7"		=> "\xda\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xac"		=> "\xda\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xb2"		=> "\xda\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x99\xb4"		=> "\xda\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x88"		=> "\xda\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x8d"		=> "\xda\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\x97"		=> "\xda\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\xb0"		=> "\xda\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x97"		=> "\xda\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x9b"		=> "\xda\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x9d"		=> "\xda\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x99"		=> "\xda\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xac"		=> "\xda\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa1"		=> "\xda\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb4"		=> "\xda\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb3"		=> "\xda\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb6"		=> "\xda\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xba"		=> "\xda\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x95"		=> "\xdb\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x98"		=> "\xdb\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x99"		=> "\xdb\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\x9c"		=> "\xdb\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa0"		=> "\xdb\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa1"		=> "\xdb\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa2"		=> "\xdb\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa5"		=> "\xdb\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa6"		=> "\xdb\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa7"		=> "\xdb\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xa9"		=> "\xdb\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xad"		=> "\xdb\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xae"		=> "\xdb\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb0"		=> "\xdb\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb1"		=> "\xdb\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb2"		=> "\xdb\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb4"		=> "\xdb\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xb6"		=> "\xdb\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xbc"		=> "\xdb\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xbe"		=> "\xdb\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb7\xbf"		=> "\xdb\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x80"		=> "\xdb\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x81"		=> "\xdb\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x82"		=> "\xdb\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x83"		=> "\xdb\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x84"		=> "\xdb\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x86"		=> "\xdb\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x87"		=> "\xdb\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x88"		=> "\xdb\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x8b"		=> "\xdb\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x8d"		=> "\xdb\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x8e"		=> "\xdb\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x90"		=> "\xdb\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x91"		=> "\xdb\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x92"		=> "\xdb\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x93"		=> "\xdb\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x95"		=> "\xdb\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x96"		=> "\xdb\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x97"		=> "\xdb\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x98"		=> "\xdb\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x99"		=> "\xdb\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x9a"		=> "\xdb\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x9b"		=> "\xdb\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\x9c"		=> "\xdb\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa0"		=> "\xdb\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa1"		=> "\xdb\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa4"		=> "\xdb\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa5"		=> "\xdb\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa6"		=> "\xdb\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa7"		=> "\xdb\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xa8"		=> "\xdb\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xab"		=> "\xdb\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xad"		=> "\xdb\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb0"		=> "\xdb\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb2"		=> "\xdb\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb3"		=> "\xdb\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb4"		=> "\xdb\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb6"		=> "\xdb\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb7"		=> "\xdb\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xb8"		=> "\xdb\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xbb"		=> "\xdb\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xbc"		=> "\xdb\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xbe"		=> "\xdb\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb8\xbf"		=> "\xdb\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x83"		=> "\xdb\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x85"		=> "\xdb\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x86"		=> "\xdb\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x8c"		=> "\xdb\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x8d"		=> "\xdb\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x8e"		=> "\xdb\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x8f"		=> "\xdb\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x90"		=> "\xdb\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x93"		=> "\xdb\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x94"		=> "\xdb\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x95"		=> "\xdb\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x96"		=> "\xdb\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x97"		=> "\xdb\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x98"		=> "\xdb\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x9a"		=> "\xdb\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x9b"		=> "\xdb\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x9c"		=> "\xdb\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x9d"		=> "\xdb\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x9e"		=> "\xdb\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\x9f"		=> "\xdb\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa0"		=> "\xdb\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa1"		=> "\xdb\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa2"		=> "\xdb\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa3"		=> "\xdb\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa4"		=> "\xdb\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa5"		=> "\xdb\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa7"		=> "\xdb\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xa8"		=> "\xdb\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xaa"		=> "\xdb\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xab"		=> "\xdb\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xae"		=> "\xdb\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb1"		=> "\xdb\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb8"		=> "\xdb\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb0"		=> "\xdb\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x8f"		=> "\xdb\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x85"		=> "\xdb\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xbe"		=> "\xdb\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x90"		=> "\xdb\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x84"		=> "\xdb\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x87"		=> "\xdb\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x93"		=> "\xdb\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa6"		=> "\xdb\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa2"		=> "\xdb\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x9c"		=> "\xdb\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x97"		=> "\xdb\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x9b"		=> "\xdb\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xab"		=> "\xdb\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xaf"		=> "\xdb\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xbe"		=> "\xdb\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x84"		=> "\xdb\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa2"		=> "\xdb\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x9e"		=> "\xdb\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa3"		=> "\xdb\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb1"		=> "\xdb\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xaf"		=> "\xdb\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb9"		=> "\xdb\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x83"		=> "\xdb\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x86"		=> "\xdb\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x88\x8d"		=> "\xdb\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x82"		=> "\xdb\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xa2"		=> "\xdb\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xac"		=> "\xdb\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xad"		=> "\xdb\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8a\xbe"		=> "\xdb\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xbf"		=> "\xdb\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x90"		=> "\xdb\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\x96"		=> "\xdb\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8b\xb0"		=> "\xdb\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\x9f"		=> "\xdb\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x87\xae"		=> "\xdb\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9f\x8d"		=> "\xdb\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xb4"		=> "\xdb\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xb5"		=> "\xdb\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x87\xbc"		=> "\xdb\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xac\xaf"		=> "\xdb\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8e\xb6"		=> "\xdb\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x81"		=> "\xdb\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x95\x9a"		=> "\xdb\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\xaf"		=> "\xdb\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x8c"		=> "\xdb\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa9"		=> "\xdb\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa1"		=> "\xdb\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xbe"		=> "\xdb\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\xbc"		=> "\xdb\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x85"		=> "\xdb\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa3\x91"		=> "\xdb\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xa9"		=> "\xdb\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xac"		=> "\xdb\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xaa"		=> "\xdb\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb3"		=> "\xdb\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xb9"		=> "\xdb\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xae"		=> "\xdb\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xaf"		=> "\xdb\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x9c"		=> "\xdb\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\xbb"		=> "\xdb\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\x82"		=> "\xdb\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa9"		=> "\xdb\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x85"		=> "\xdb\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xab"		=> "\xdb\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x86"		=> "\xdb\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xbc"		=> "\xdb\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xbb"		=> "\xdb\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xa8"		=> "\xdb\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xad"		=> "\xdb\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb6"		=> "\xdb\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9d\xb3"		=> "\xdb\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xad"		=> "\xdb\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa4"		=> "\xdb\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x8c"		=> "\xdb\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb2"		=> "\xdb\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x8f"		=> "\xdb\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa7"		=> "\xdb\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb4"		=> "\xdb\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\x93"		=> "\xdb\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xa0"		=> "\xdb\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x95"		=> "\xdb\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x98"		=> "\xdb\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x9a"		=> "\xdb\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x99"		=> "\xdb\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x92"		=> "\xdb\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9e\xb8"		=> "\xdb\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb4"		=> "\xdb\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xaf"		=> "\xdb\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xb8"		=> "\xdb\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xa4"		=> "\xdb\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\x9d"		=> "\xdb\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb3"		=> "\xdc\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb5"		=> "\xdc\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb7"		=> "\xdc\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb8"		=> "\xdc\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xb9"		=> "\xdc\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xba"		=> "\xdc\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xbb"		=> "\xdc\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xbd"		=> "\xdc\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb9\xbe"		=> "\xdc\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x80"		=> "\xdc\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x82"		=> "\xdc\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x83"		=> "\xdc\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x84"		=> "\xdc\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x86"		=> "\xdc\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x88"		=> "\xdc\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x89"		=> "\xdc\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x8a"		=> "\xdc\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x8b"		=> "\xdc\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x8c"		=> "\xdc\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x8d"		=> "\xdc\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x8e"		=> "\xdc\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x91"		=> "\xdc\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x92"		=> "\xdc\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x93"		=> "\xdc\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x95"		=> "\xdc\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x96"		=> "\xdc\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x97"		=> "\xdc\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x98"		=> "\xdc\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x99"		=> "\xdc\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x9a"		=> "\xdc\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x9b"		=> "\xdc\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x9d"		=> "\xdc\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\x9f"		=> "\xdc\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa0"		=> "\xdc\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa1"		=> "\xdc\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa2"		=> "\xdc\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa3"		=> "\xdc\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa4"		=> "\xdc\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa5"		=> "\xdc\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa6"		=> "\xdc\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa7"		=> "\xdc\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa8"		=> "\xdc\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xa9"		=> "\xdc\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xaa"		=> "\xdc\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xad"		=> "\xdc\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xae"		=> "\xdc\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb0"		=> "\xdc\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb1"		=> "\xdc\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb3"		=> "\xdc\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb4"		=> "\xdc\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb5"		=> "\xdc\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb6"		=> "\xdc\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb7"		=> "\xdc\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb8"		=> "\xdc\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xb9"		=> "\xdc\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xbb"		=> "\xdc\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xbc"		=> "\xdc\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xbd"		=> "\xdc\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xbe"		=> "\xdc\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xba\xbf"		=> "\xdc\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x80"		=> "\xdc\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x81"		=> "\xdc\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x82"		=> "\xdc\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x83"		=> "\xdc\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x84"		=> "\xdc\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x85"		=> "\xdc\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x86"		=> "\xdc\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x87"		=> "\xdc\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x88"		=> "\xdc\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x89"		=> "\xdc\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x8a"		=> "\xdc\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x8b"		=> "\xdc\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x8c"		=> "\xdc\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x8d"		=> "\xdc\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x8f"		=> "\xdc\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x90"		=> "\xdc\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x91"		=> "\xdc\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x92"		=> "\xdc\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x93"		=> "\xdc\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x94"		=> "\xdc\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x95"		=> "\xdc\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x96"		=> "\xdc\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x97"		=> "\xdc\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x98"		=> "\xdc\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x99"		=> "\xdc\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x9a"		=> "\xdc\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x9b"		=> "\xdc\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x9c"		=> "\xdc\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x9d"		=> "\xdc\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x9e"		=> "\xdc\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\x9f"		=> "\xdc\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa0"		=> "\xdc\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa1"		=> "\xdc\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa2"		=> "\xdc\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa3"		=> "\xdc\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa4"		=> "\xdc\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x8b"		=> "\xdc\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x8d"		=> "\xdc\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xbd"		=> "\xdc\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9f\xad"		=> "\xdc\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x80"		=> "\xdc\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x9e"		=> "\xdc\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x99"		=> "\xdc\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\x84"		=> "\xdc\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\xa0"		=> "\xdc\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xa5"		=> "\xdc\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa1\xac"		=> "\xdc\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x81"		=> "\xdc\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x89"		=> "\xdc\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x9a"		=> "\xdc\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa2\x80"		=> "\xdc\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\xa8"		=> "\xdc\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xbc\x99"		=> "\xdc\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xbf"		=> "\xdc\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xb9"		=> "\xdc\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xbd"		=> "\xdc\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x89\xbf"		=> "\xdc\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x8f"		=> "\xdc\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x8a"		=> "\xdc\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa8"		=> "\xdc\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x84"		=> "\xdc\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x8e"		=> "\xdc\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x91"		=> "\xdc\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x97"		=> "\xdc\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x99"		=> "\xdc\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xab"		=> "\xdc\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb8"		=> "\xdc\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xbe"		=> "\xdc\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb0"		=> "\xdc\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x88"		=> "\xdc\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x8a"		=> "\xdc\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa3"		=> "\xdc\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x98"		=> "\xdc\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb7"		=> "\xdc\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xae"		=> "\xdc\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x8b"		=> "\xdc\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x8c"		=> "\xdc\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x81"		=> "\xdc\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa9"		=> "\xdc\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xb4"		=> "\xdc\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa1"		=> "\xdc\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xaa"		=> "\xdc\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\x9f"		=> "\xdc\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x84"		=> "\xdc\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x8e"		=> "\xdc\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8a\xa4"		=> "\xdc\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa1"		=> "\xdc\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x89"		=> "\xdc\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb7"		=> "\xdc\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa4"		=> "\xdc\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x8f"		=> "\xdc\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x87"		=> "\xdc\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x9c"		=> "\xdc\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xb4"		=> "\xdc\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x92"		=> "\xdc\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x98"		=> "\xdc\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x8c"		=> "\xdc\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xbb"		=> "\xdc\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x93"		=> "\xdc\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x91"		=> "\xdc\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x9a"		=> "\xdc\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x86"		=> "\xdc\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x94"		=> "\xdc\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x95"		=> "\xdc\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\xa0"		=> "\xdc\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8b\x95"		=> "\xdc\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x9c"		=> "\xdc\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x91"		=> "\xdc\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x9b"		=> "\xdc\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x9c"		=> "\xdc\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x88"		=> "\xdc\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x92"		=> "\xdc\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xbc"		=> "\xdc\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb4"		=> "\xdc\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb1"		=> "\xdc\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x9b"		=> "\xdc\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x9e"		=> "\xdc\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xaf"		=> "\xdc\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x8f"		=> "\xdc\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x87"		=> "\xdc\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x83"		=> "\xdc\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x9f"		=> "\xdc\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\x80"		=> "\xdc\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x97"		=> "\xdc\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa0"		=> "\xdc\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xad"		=> "\xdc\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xba"		=> "\xdc\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\xb3"		=> "\xdc\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa6"		=> "\xdc\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa5"		=> "\xdc\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa5"		=> "\xdd\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa6"		=> "\xdd\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa7"		=> "\xdd\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa8"		=> "\xdd\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xa9"		=> "\xdd\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xaa"		=> "\xdd\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xab"		=> "\xdd\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xac"		=> "\xdd\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xad"		=> "\xdd\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xae"		=> "\xdd\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xaf"		=> "\xdd\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb0"		=> "\xdd\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb1"		=> "\xdd\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb2"		=> "\xdd\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb3"		=> "\xdd\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb4"		=> "\xdd\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb5"		=> "\xdd\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb6"		=> "\xdd\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb7"		=> "\xdd\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb8"		=> "\xdd\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xb9"		=> "\xdd\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xba"		=> "\xdd\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xbb"		=> "\xdd\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xbc"		=> "\xdd\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xbd"		=> "\xdd\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xbe"		=> "\xdd\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbb\xbf"		=> "\xdd\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x80"		=> "\xdd\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x81"		=> "\xdd\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x82"		=> "\xdd\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x83"		=> "\xdd\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x84"		=> "\xdd\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x85"		=> "\xdd\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x86"		=> "\xdd\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x87"		=> "\xdd\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x88"		=> "\xdd\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x89"		=> "\xdd\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x8a"		=> "\xdd\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x8b"		=> "\xdd\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x8c"		=> "\xdd\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x8d"		=> "\xdd\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x8e"		=> "\xdd\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x8f"		=> "\xdd\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x90"		=> "\xdd\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x91"		=> "\xdd\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x92"		=> "\xdd\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x93"		=> "\xdd\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x94"		=> "\xdd\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x95"		=> "\xdd\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x96"		=> "\xdd\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x97"		=> "\xdd\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x98"		=> "\xdd\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x99"		=> "\xdd\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x9a"		=> "\xdd\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x9b"		=> "\xdd\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x9c"		=> "\xdd\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x9d"		=> "\xdd\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x9e"		=> "\xdd\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\x9f"		=> "\xdd\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa0"		=> "\xdd\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa1"		=> "\xdd\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa2"		=> "\xdd\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa3"		=> "\xdd\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa4"		=> "\xdd\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa5"		=> "\xdd\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa6"		=> "\xdd\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa7"		=> "\xdd\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa8"		=> "\xdd\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xa9"		=> "\xdd\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xaa"		=> "\xdd\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xab"		=> "\xdd\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xac"		=> "\xdd\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xad"		=> "\xdd\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xae"		=> "\xdd\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xaf"		=> "\xdd\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb0"		=> "\xdd\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb1"		=> "\xdd\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb2"		=> "\xdd\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb3"		=> "\xdd\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb4"		=> "\xdd\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb5"		=> "\xdd\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb6"		=> "\xdd\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb7"		=> "\xdd\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb8"		=> "\xdd\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xb9"		=> "\xdd\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xba"		=> "\xdd\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xbb"		=> "\xdd\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xbc"		=> "\xdd\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xbd"		=> "\xdd\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xbe"		=> "\xdd\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbc\xbf"		=> "\xdd\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x80"		=> "\xdd\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x81"		=> "\xdd\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x82"		=> "\xdd\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x83"		=> "\xdd\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x84"		=> "\xdd\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa8"		=> "\xdd\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8c\x9b"		=> "\xdd\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xa9"		=> "\xdd\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xac"		=> "\xdd\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xaa"		=> "\xdd\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xad"		=> "\xdd\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xae"		=> "\xdd\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb0"		=> "\xdd\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xb8"		=> "\xdd\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb3"		=> "\xdd\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb4"		=> "\xdd\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa0"		=> "\xdd\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xaa"		=> "\xdd\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x93"		=> "\xdd\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x9c"		=> "\xdd\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x85"		=> "\xdd\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xbc"		=> "\xdd\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb6"		=> "\xdd\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa9"		=> "\xdd\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xbd"		=> "\xdd\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xb8"		=> "\xdd\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8d\xbb"		=> "\xdd\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x98"		=> "\xdd\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\x9e"		=> "\xdd\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xa8"		=> "\xdd\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xba"		=> "\xdd\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8e\xbc"		=> "\xdd\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x81"		=> "\xdd\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x81"		=> "\xdd\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa5"		=> "\xdd\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x98"		=> "\xdd\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa0\x87"		=> "\xdd\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x98"		=> "\xdd\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x8b"		=> "\xdd\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x9d"		=> "\xdd\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xbd"		=> "\xdd\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x96"		=> "\xdd\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x9c"		=> "\xdd\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb8"		=> "\xdd\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x91"		=> "\xdd\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x86"		=> "\xdd\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x94"		=> "\xdd\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x9f"		=> "\xdd\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x8f"		=> "\xdd\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\x83"		=> "\xdd\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb8"		=> "\xdd\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb9"		=> "\xdd\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xaa"		=> "\xdd\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x85"		=> "\xdd\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\x80"		=> "\xdd\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xa6"		=> "\xdd\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xb0"		=> "\xdd\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x8f\xa1"		=> "\xdd\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x9c"		=> "\xdd\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x91"		=> "\xdd\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x9a"		=> "\xdd\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x99"		=> "\xdd\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb3"		=> "\xdd\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x87"		=> "\xdd\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x88"		=> "\xdd\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xba"		=> "\xdd\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x89"		=> "\xdd\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb8"		=> "\xdd\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xbc"		=> "\xdd\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\x86"		=> "\xdd\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xa9"		=> "\xdd\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xb6"		=> "\xdd\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x8c"		=> "\xdd\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x8e"		=> "\xdd\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x90\xb1"		=> "\xdd\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x91\xad"		=> "\xdd\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x81"		=> "\xdd\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x8d"		=> "\xdd\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x90"		=> "\xdd\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa6"		=> "\xdd\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xbd"		=> "\xdd\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x93"		=> "\xdd\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\x8a"		=> "\xdd\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xbf"		=> "\xdd\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xba"		=> "\xdd\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa0"		=> "\xdd\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xa1"		=> "\xdd\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb9"		=> "\xdd\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\xb4"		=> "\xdd\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x92\x97"		=> "\xdd\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa5"		=> "\xdd\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xa3"		=> "\xdd\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x8c"		=> "\xdd\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x8d"		=> "\xdd\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb8"		=> "\xdd\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xb0"		=> "\xdd\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xb9"		=> "\xdd\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\x9f"		=> "\xdd\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xba"		=> "\xdd\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x85"		=> "\xde\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x86"		=> "\xde\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x87"		=> "\xde\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x88"		=> "\xde\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x89"		=> "\xde\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x8a"		=> "\xde\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x8b"		=> "\xde\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x8c"		=> "\xde\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x8d"		=> "\xde\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x8e"		=> "\xde\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x8f"		=> "\xde\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x90"		=> "\xde\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x91"		=> "\xde\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x92"		=> "\xde\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x93"		=> "\xde\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x94"		=> "\xde\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x95"		=> "\xde\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x96"		=> "\xde\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x97"		=> "\xde\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x98"		=> "\xde\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x99"		=> "\xde\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x9a"		=> "\xde\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x9b"		=> "\xde\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x9c"		=> "\xde\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x9d"		=> "\xde\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x9e"		=> "\xde\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\x9f"		=> "\xde\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa0"		=> "\xde\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa1"		=> "\xde\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa2"		=> "\xde\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa3"		=> "\xde\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa4"		=> "\xde\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xa5"		=> "\xde\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbd\xaa"		=> "\xde\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x80"		=> "\xde\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x8c"		=> "\xde\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x92"		=> "\xde\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x9d"		=> "\xde\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa0"		=> "\xde\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa1"		=> "\xde\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa2"		=> "\xde\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa4"		=> "\xde\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa5"		=> "\xde\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa6"		=> "\xde\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xa7"		=> "\xde\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xaa"		=> "\xde\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xac"		=> "\xde\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xad"		=> "\xde\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xae"		=> "\xde\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xaf"		=> "\xde\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb2"		=> "\xde\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb3"		=> "\xde\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb4"		=> "\xde\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb5"		=> "\xde\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb7"		=> "\xde\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xb8"		=> "\xde\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xba"		=> "\xde\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xbb"		=> "\xde\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xbc"		=> "\xde\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\xbf"		=> "\xde\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x80"		=> "\xde\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x83"		=> "\xde\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x86"		=> "\xde\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x89"		=> "\xde\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x8a"		=> "\xde\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x8b"		=> "\xde\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x8c"		=> "\xde\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x8d"		=> "\xde\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x8f"		=> "\xde\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x92"		=> "\xde\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x96"		=> "\xde\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x97"		=> "\xde\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\x9a"		=> "\xde\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xa0"		=> "\xde\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xa1"		=> "\xde\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xa3"		=> "\xde\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xa7"		=> "\xde\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xac"		=> "\xde\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xaf"		=> "\xde\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb1"		=> "\xde\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb2"		=> "\xde\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb4"		=> "\xde\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb5"		=> "\xde\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xb6"		=> "\xde\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xba"		=> "\xde\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xbb"		=> "\xde\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xbc"		=> "\xde\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xbe"		=> "\xde\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbf\xbf"		=> "\xde\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x87"		=> "\xde\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x88"		=> "\xde\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x8c"		=> "\xde\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x8e"		=> "\xde\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x93"		=> "\xde\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x95"		=> "\xde\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x98"		=> "\xde\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x96"		=> "\xde\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x94\xbb"		=> "\xde\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xbf"		=> "\xde\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x93\xbc"		=> "\xde\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x99"		=> "\xde\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x88"		=> "\xde\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa8"		=> "\xde\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xa4"		=> "\xde\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x9e"		=> "\xde\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xba"		=> "\xde\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x9e\xa2"		=> "\xde\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\x83"		=> "\xde\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb2"		=> "\xde\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xbb"		=> "\xde\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa4"		=> "\xde\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xa8"		=> "\xde\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x87"		=> "\xde\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x8f"		=> "\xde\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x95\xb9"		=> "\xde\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xae"		=> "\xde\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x9c"		=> "\xde\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\x85"		=> "\xde\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb9"		=> "\xde\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb7"		=> "\xde\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x96\xb0"		=> "\xde\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x93"		=> "\xde\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x81"		=> "\xde\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\x9c"		=> "\xde\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x97\xbf"		=> "\xde\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa7"		=> "\xde\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x85"		=> "\xde\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xa9"		=> "\xde\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\x96"		=> "\xde\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x98\xbc"		=> "\xde\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xbe"		=> "\xde\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x88"		=> "\xde\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xbc"		=> "\xde\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x81"		=> "\xde\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x80\xb7"		=> "\xde\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x95"		=> "\xde\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x9a"		=> "\xde\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa5\x98"		=> "\xde\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8c\x8f"		=> "\xde\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa2"		=> "\xde\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xa5"		=> "\xde\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xac"		=> "\xde\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb0\xb4"		=> "\xde\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\x8c"		=> "\xde\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x89\xaa"		=> "\xde\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\x9f"		=> "\xde\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8a\xbb"		=> "\xde\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x8a"		=> "\xde\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x9a"		=> "\xde\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\x97"		=> "\xde\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xae"		=> "\xde\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xa2"		=> "\xde\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8b\xb6"		=> "\xde\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8c\xb9"		=> "\xde\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x8b"		=> "\xde\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\x83"		=> "\xde\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xad"		=> "\xde\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb6"		=> "\xde\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xb1"		=> "\xde\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xba"		=> "\xde\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x8e"		=> "\xde\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xb4"		=> "\xde\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xad"		=> "\xde\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xac"		=> "\xde\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\x8a"		=> "\xde\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8d\xa9"		=> "\xde\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xae"		=> "\xde\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xbc"		=> "\xde\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb2"		=> "\xde\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xb8"		=> "\xde\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xa0"		=> "\xde\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\xbf"		=> "\xde\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x84"		=> "\xde\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x9e"		=> "\xde\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x8e"		=> "\xde\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x92"		=> "\xde\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8f\x86"		=> "\xde\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x8e\xbe"		=> "\xde\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x85"		=> "\xde\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x81"		=> "\xde\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x8b"		=> "\xde\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x9b"		=> "\xde\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa0"		=> "\xde\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\x8c"		=> "\xde\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa6"		=> "\xde\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x90\xa1"		=> "\xde\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\x9e"		=> "\xde\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x84"		=> "\xde\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xad"		=> "\xde\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x96"		=> "\xde\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x99"		=> "\xdf\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\x9c"		=> "\xdf\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa3"		=> "\xdf\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa4"		=> "\xdf\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa5"		=> "\xdf\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa7"		=> "\xdf\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa8"		=> "\xdf\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xa9"		=> "\xdf\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xaa"		=> "\xdf\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xab"		=> "\xdf\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xac"		=> "\xdf\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb0"		=> "\xdf\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb1"		=> "\xdf\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb2"		=> "\xdf\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb3"		=> "\xdf\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb4"		=> "\xdf\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb7"		=> "\xdf\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xb9"		=> "\xdf\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xba"		=> "\xdf\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xbd"		=> "\xdf\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x80\xbf"		=> "\xdf\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x80"		=> "\xdf\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x83"		=> "\xdf\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x85"		=> "\xdf\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x86"		=> "\xdf\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x88"		=> "\xdf\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x89"		=> "\xdf\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x8a"		=> "\xdf\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x8b"		=> "\xdf\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x8c"		=> "\xdf\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x8e"		=> "\xdf\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x94"		=> "\xdf\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x95"		=> "\xdf\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x96"		=> "\xdf\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x99"		=> "\xdf\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x9a"		=> "\xdf\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x9c"		=> "\xdf\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x9d"		=> "\xdf\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x9e"		=> "\xdf\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\x9f"		=> "\xdf\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa0"		=> "\xdf\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa1"		=> "\xdf\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa4"		=> "\xdf\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa6"		=> "\xdf\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa7"		=> "\xdf\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xa9"		=> "\xdf\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xaa"		=> "\xdf\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xab"		=> "\xdf\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xac"		=> "\xdf\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xaf"		=> "\xdf\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb0"		=> "\xdf\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb1"		=> "\xdf\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb2"		=> "\xdf\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb3"		=> "\xdf\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb6"		=> "\xdf\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb7"		=> "\xdf\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb8"		=> "\xdf\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xb9"		=> "\xdf\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xba"		=> "\xdf\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xbb"		=> "\xdf\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xbc"		=> "\xdf\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x81\xbe"		=> "\xdf\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x81"		=> "\xdf\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x84"		=> "\xdf\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x85"		=> "\xdf\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x86"		=> "\xdf\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x87"		=> "\xdf\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x89"		=> "\xdf\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x8a"		=> "\xdf\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x8c"		=> "\xdf\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x8d"		=> "\xdf\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x8e"		=> "\xdf\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x8f"		=> "\xdf\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x90"		=> "\xdf\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x92"		=> "\xdf\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x94"		=> "\xdf\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x96"		=> "\xdf\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x98"		=> "\xdf\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x9a"		=> "\xdf\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x9c"		=> "\xdf\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x9e"		=> "\xdf\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\x9f"		=> "\xdf\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa0"		=> "\xdf\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa4"		=> "\xdf\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa5"		=> "\xdf\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa7"		=> "\xdf\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa8"		=> "\xdf\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xa9"		=> "\xdf\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xab"		=> "\xdf\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xad"		=> "\xdf\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb2"		=> "\xdf\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xb7"		=> "\xdf\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xbc"		=> "\xdf\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xbd"		=> "\xdf\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x82\xbf"		=> "\xdf\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x80"		=> "\xdf\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x91\xba"		=> "\xdf\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb7"		=> "\xdf\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xb8"		=> "\xdf\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\x99"		=> "\xdf\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x92\xba"		=> "\xdf\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x80"		=> "\xdf\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x90"		=> "\xdf\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\x97"		=> "\xdf\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa4"		=> "\xdf\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x93\xa2"		=> "\xdf\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\x89"		=> "\xdf\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xa5"		=> "\xdf\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x94\xae"		=> "\xdf\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x8b"		=> "\xdf\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x92"		=> "\xdf\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x94\x99"		=> "\xdf\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbc\x91"		=> "\xdf\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8d\x9f"		=> "\xdf\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xb1"		=> "\xdf\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xbd"		=> "\xdf\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa9"		=> "\xdf\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xa8"		=> "\xdf\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x8f\xbb"		=> "\xdf\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x92"		=> "\xdf\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x96"		=> "\xdf\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\x86"		=> "\xdf\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x8b"		=> "\xdf\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x92"		=> "\xdf\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x93"		=> "\xdf\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x94"		=> "\xdf\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x96"		=> "\xdf\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x83"		=> "\xdf\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa1"		=> "\xdf\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x97"		=> "\xdf\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\x99"		=> "\xdf\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xa3"		=> "\xdf\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x90\xb2"		=> "\xdf\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x82"		=> "\xdf\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x94"		=> "\xdf\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb7"		=> "\xdf\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb1"		=> "\xdf\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa4"		=> "\xdf\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x9a"		=> "\xdf\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x9b"		=> "\xdf\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x84"		=> "\xdf\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb6"		=> "\xdf\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xa6"		=> "\xdf\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\x9d"		=> "\xdf\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x90"		=> "\xdf\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xad"		=> "\xdf\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x82"		=> "\xdf\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xb4"		=> "\xdf\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x92"		=> "\xdf\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa7"		=> "\xdf\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa6"		=> "\xdf\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x93"		=> "\xdf\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x94"		=> "\xdf\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x91\xb2"		=> "\xdf\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa3"		=> "\xdf\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x95"		=> "\xdf\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xbb"		=> "\xdf\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xbf"		=> "\xdf\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x8c"		=> "\xdf\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x99"		=> "\xdf\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x9a"		=> "\xdf\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x9c"		=> "\xdf\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa9"		=> "\xdf\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xaa"		=> "\xdf\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x92\xa4"		=> "\xdf\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x9d"		=> "\xdf\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x8f"		=> "\xdf\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\x9e"		=> "\xdf\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x9b"		=> "\xdf\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xa7"		=> "\xdf\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa0"		=> "\xdf\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xbd"		=> "\xdf\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x94"		=> "\xdf\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x93\xb3"		=> "\xdf\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa2"		=> "\xdf\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa3"		=> "\xdf\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x8f"		=> "\xdf\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\x91"		=> "\xdf\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xa7"		=> "\xdf\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xaa"		=> "\xdf\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xa7"		=> "\xdf\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x8f"		=> "\xdf\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb5"		=> "\xdf\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x89"		=> "\xdf\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xad"		=> "\xdf\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x81"		=> "\xdf\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x95"		=> "\xdf\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xbf"		=> "\xdf\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x90"		=> "\xdf\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xbc"		=> "\xdf\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x82"		=> "\xe0\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x83"		=> "\xe0\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x86"		=> "\xe0\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x88"		=> "\xe0\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x89"		=> "\xe0\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x8b"		=> "\xe0\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x8c"		=> "\xe0\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x8d"		=> "\xe0\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x92"		=> "\xe0\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x94"		=> "\xe0\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x95"		=> "\xe0\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x96"		=> "\xe0\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x98"		=> "\xe0\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x99"		=> "\xe0\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x9a"		=> "\xe0\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x9e"		=> "\xe0\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\x9f"		=> "\xe0\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa0"		=> "\xe0\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa3"		=> "\xe0\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa4"		=> "\xe0\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa5"		=> "\xe0\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xa9"		=> "\xe0\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xaa"		=> "\xe0\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xac"		=> "\xe0\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xae"		=> "\xe0\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb0"		=> "\xe0\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb1"		=> "\xe0\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb2"		=> "\xe0\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb3"		=> "\xe0\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb5"		=> "\xe0\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb6"		=> "\xe0\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb7"		=> "\xe0\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xb9"		=> "\xe0\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xba"		=> "\xe0\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xbb"		=> "\xe0\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xbc"		=> "\xe0\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x83\xbf"		=> "\xe0\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x80"		=> "\xe0\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x81"		=> "\xe0\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x83"		=> "\xe0\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x85"		=> "\xe0\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x86"		=> "\xe0\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x87"		=> "\xe0\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x88"		=> "\xe0\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x89"		=> "\xe0\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x8a"		=> "\xe0\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x8b"		=> "\xe0\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x8c"		=> "\xe0\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x8d"		=> "\xe0\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x8e"		=> "\xe0\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x8f"		=> "\xe0\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x90"		=> "\xe0\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x91"		=> "\xe0\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x92"		=> "\xe0\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x93"		=> "\xe0\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x94"		=> "\xe0\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x95"		=> "\xe0\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x96"		=> "\xe0\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x97"		=> "\xe0\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x98"		=> "\xe0\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x9a"		=> "\xe0\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x9b"		=> "\xe0\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x9c"		=> "\xe0\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x9d"		=> "\xe0\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\x9f"		=> "\xe0\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa0"		=> "\xe0\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa1"		=> "\xe0\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa4"		=> "\xe0\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa5"		=> "\xe0\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa6"		=> "\xe0\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa7"		=> "\xe0\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa8"		=> "\xe0\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xa9"		=> "\xe0\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xaa"		=> "\xe0\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xab"		=> "\xe0\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xac"		=> "\xe0\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xad"		=> "\xe0\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xae"		=> "\xe0\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb0"		=> "\xe0\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb2"		=> "\xe0\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb3"		=> "\xe0\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb4"		=> "\xe0\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb5"		=> "\xe0\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb6"		=> "\xe0\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb7"		=> "\xe0\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xb8"		=> "\xe0\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xba"		=> "\xe0\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xbb"		=> "\xe0\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xbc"		=> "\xe0\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xbd"		=> "\xe0\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xbe"		=> "\xe0\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x84\xbf"		=> "\xe0\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x80"		=> "\xe0\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x81"		=> "\xe0\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x82"		=> "\xe0\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x84"		=> "\xe0\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb7"		=> "\xe0\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x96"		=> "\xe0\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb5"		=> "\xe0\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb6"		=> "\xe0\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xb7"		=> "\xe0\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb3"		=> "\xe0\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x94\xb0"		=> "\xe0\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\x9c"		=> "\xe0\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x8b"		=> "\xe0\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x92"		=> "\xe0\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x83"		=> "\xe0\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb1"		=> "\xe0\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xb9"		=> "\xe0\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x88"		=> "\xe0\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x81"		=> "\xe0\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x9f"		=> "\xe0\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xbe"		=> "\xe0\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x96"		=> "\xe0\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x91"		=> "\xe0\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x95\xbb"		=> "\xe0\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x9f"		=> "\xe0\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xbd"		=> "\xe0\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\xbe"		=> "\xe0\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x94"		=> "\xe0\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x96\x99"		=> "\xe0\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xaa"		=> "\xe0\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb7"		=> "\xe0\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x89"		=> "\xe0\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x9f"		=> "\xe0\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x91"		=> "\xe0\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xab"		=> "\xe0\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xac"		=> "\xe0\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x94"		=> "\xe0\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa6"		=> "\xe0\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x9d"		=> "\xe0\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x84"		=> "\xe0\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xaf"		=> "\xe0\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa5"		=> "\xe0\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb2"		=> "\xe0\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb3"		=> "\xe0\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x8c"		=> "\xe0\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\x8d"		=> "\xe0\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa8"		=> "\xe0\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xb5"		=> "\xe0\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xa4"		=> "\xe0\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xbe\x94"		=> "\xe0\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x9e"		=> "\xe0\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x88"		=> "\xe0\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x8c"		=> "\xe0\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x81"		=> "\xe0\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa4"		=> "\xe0\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa3"		=> "\xe0\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x97\xbe"		=> "\xe0\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\x80"		=> "\xe0\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xa7"		=> "\xe0\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xad"		=> "\xe0\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x98"		=> "\xe0\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xb9"		=> "\xe0\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x97"		=> "\xe0\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x98\xac"		=> "\xe0\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x8d"		=> "\xe0\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa2"		=> "\xe0\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x99"		=> "\xe0\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x9c"		=> "\xe0\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x8c"		=> "\xe0\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\x94"		=> "\xe0\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x86"		=> "\xe0\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xa4"		=> "\xe0\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xb1"		=> "\xe0\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xab"		=> "\xe0\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xbb"		=> "\xe0\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x99\xbc"		=> "\xe0\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x85"		=> "\xe0\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\x93"		=> "\xe0\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9a\xaf"		=> "\xe0\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x94"		=> "\xe0\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x97"		=> "\xe0\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\x9d"		=> "\xe0\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xa1"		=> "\xe0\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb5"		=> "\xe0\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xab"		=> "\xe0\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xb9"		=> "\xe0\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9b\xbf"		=> "\xe0\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x84"		=> "\xe0\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x8a"		=> "\xe0\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x89"		=> "\xe0\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\x9c\x9c"		=> "\xe0\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x8f"		=> "\xe0\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x99"		=> "\xe0\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x94"		=> "\xe0\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\x91"		=> "\xe0\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb1"		=> "\xe0\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xbb"		=> "\xe0\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xbc"		=> "\xe0\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x85"		=> "\xe1\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x87"		=> "\xe1\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x88"		=> "\xe1\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x91"		=> "\xe1\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x93"		=> "\xe1\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x94"		=> "\xe1\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x95"		=> "\xe1\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x96"		=> "\xe1\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x98"		=> "\xe1\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x99"		=> "\xe1\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x9b"		=> "\xe1\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x9c"		=> "\xe1\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\x9f"		=> "\xe1\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xa0"		=> "\xe1\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xa6"		=> "\xe1\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xa7"		=> "\xe1\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xa8"		=> "\xe1\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xab"		=> "\xe1\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xad"		=> "\xe1\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xb3"		=> "\xe1\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xba"		=> "\xe1\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xbb"		=> "\xe1\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x85\xbc"		=> "\xe1\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x80"		=> "\xe1\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x81"		=> "\xe1\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x82"		=> "\xe1\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x83"		=> "\xe1\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x84"		=> "\xe1\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x86"		=> "\xe1\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x88"		=> "\xe1\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x8a"		=> "\xe1\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x8e"		=> "\xe1\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x8f"		=> "\xe1\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x93"		=> "\xe1\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x94"		=> "\xe1\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x95"		=> "\xe1\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x96"		=> "\xe1\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x97"		=> "\xe1\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x98"		=> "\xe1\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x99"		=> "\xe1\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x9c"		=> "\xe1\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x9d"		=> "\xe1\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x9e"		=> "\xe1\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\x9f"		=> "\xe1\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa0"		=> "\xe1\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa1"		=> "\xe1\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa4"		=> "\xe1\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa5"		=> "\xe1\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa6"		=> "\xe1\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa7"		=> "\xe1\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa8"		=> "\xe1\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xa9"		=> "\xe1\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xab"		=> "\xe1\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xac"		=> "\xe1\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb0"		=> "\xe1\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb1"		=> "\xe1\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb2"		=> "\xe1\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb3"		=> "\xe1\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb6"		=> "\xe1\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb7"		=> "\xe1\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb8"		=> "\xe1\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xb9"		=> "\xe1\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xbb"		=> "\xe1\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xbc"		=> "\xe1\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xbd"		=> "\xe1\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xbe"		=> "\xe1\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x86\xbf"		=> "\xe1\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x80"		=> "\xe1\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x81"		=> "\xe1\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x82"		=> "\xe1\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x83"		=> "\xe1\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x84"		=> "\xe1\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x85"		=> "\xe1\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x86"		=> "\xe1\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x88"		=> "\xe1\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x8b"		=> "\xe1\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x90"		=> "\xe1\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x92"		=> "\xe1\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x93"		=> "\xe1\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x94"		=> "\xe1\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x95"		=> "\xe1\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x96"		=> "\xe1\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x97"		=> "\xe1\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x98"		=> "\xe1\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x99"		=> "\xe1\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x9a"		=> "\xe1\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x9b"		=> "\xe1\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x9d"		=> "\xe1\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x9e"		=> "\xe1\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\x9f"		=> "\xe1\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa0"		=> "\xe1\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa1"		=> "\xe1\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa2"		=> "\xe1\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa3"		=> "\xe1\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa4"		=> "\xe1\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa5"		=> "\xe1\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb8\xb7"		=> "\xe1\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x84"		=> "\xe1\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x94"		=> "\xe1\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x9b"		=> "\xe1\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\x9e"		=> "\xe1\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb9\xa1"		=> "\xe1\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x8c"		=> "\xe1\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb1\xba"		=> "\xe1\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x8d"		=> "\xe1\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x90"		=> "\xe1\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x96"		=> "\xe1\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x88"		=> "\xe1\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x98"		=> "\xe1\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x99"		=> "\xe1\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x91"		=> "\xe1\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x9a"		=> "\xe1\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\x9c"		=> "\xe1\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb5"		=> "\xe1\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa2"		=> "\xe1\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xbd"		=> "\xe1\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xac"		=> "\xe1\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xab"		=> "\xe1\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb1"		=> "\xe1\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xa3"		=> "\xe1\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x81"		=> "\xe1\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb2\xb7"		=> "\xe1\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x84"		=> "\xe1\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x92"		=> "\xe1\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa4"		=> "\xe1\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\x8b"		=> "\xe1\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb3\xa5"		=> "\xe1\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x82"		=> "\xe1\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x83"		=> "\xe1\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa7"		=> "\xe1\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa6"		=> "\xe1\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xae"		=> "\xe1\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xa4"		=> "\xe1\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x9e"		=> "\xe1\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x86"		=> "\xe1\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\x9b"		=> "\xe1\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x98"		=> "\xe1\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xbe"		=> "\xe1\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xb4"		=> "\xe1\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb4\xbd"		=> "\xe1\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xac"		=> "\xe1\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x9b"		=> "\xe1\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xaf"		=> "\xe1\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x9d"		=> "\xe1\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xab"		=> "\xe1\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x8b"		=> "\xe1\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\x8a"		=> "\xe1\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xa9"		=> "\xe1\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb5\xb4"		=> "\xe1\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x82"		=> "\xe1\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x99"		=> "\xe1\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\x9d"		=> "\xe1\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb1\xb3"		=> "\xe1\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb6\xb7"		=> "\xe1\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xb7\x85"		=> "\xe1\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb3"		=> "\xe1\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xb7"		=> "\xe1\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x82"		=> "\xe1\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x87"		=> "\xe1\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x89"		=> "\xe1\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x8c"		=> "\xe1\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x95"		=> "\xe1\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x99"		=> "\xe1\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\x9c"		=> "\xe1\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xa8"		=> "\xe1\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xad"		=> "\xe1\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xb5"		=> "\xe1\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbe\xbc"		=> "\xe1\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xa1\xa2"		=> "\xe1\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbd\xa1"		=> "\xe1\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xad"		=> "\xe1\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb0"		=> "\xe1\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb4"		=> "\xe1\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb7"		=> "\xe1\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8a\xb8"		=> "\xe1\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x83"		=> "\xe1\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x81"		=> "\xe1\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x8e"		=> "\xe1\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x8d"		=> "\xe1\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\x92"		=> "\xe1\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa8"		=> "\xe1\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xaf"		=> "\xe1\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xa9"		=> "\xe1\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb2"		=> "\xe1\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb4"		=> "\xe1\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb7"		=> "\xe1\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x81"		=> "\xe1\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xb3"		=> "\xe1\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x83"		=> "\xe1\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xba"		=> "\xe1\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa6"		=> "\xe2\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa7"		=> "\xe2\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa8"		=> "\xe2\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xa9"		=> "\xe2\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xaa"		=> "\xe2\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xab"		=> "\xe2\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xac"		=> "\xe2\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xad"		=> "\xe2\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xae"		=> "\xe2\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xaf"		=> "\xe2\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb0"		=> "\xe2\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb1"		=> "\xe2\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb2"		=> "\xe2\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb3"		=> "\xe2\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb4"		=> "\xe2\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb5"		=> "\xe2\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb6"		=> "\xe2\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb7"		=> "\xe2\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb8"		=> "\xe2\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xb9"		=> "\xe2\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xba"		=> "\xe2\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xbb"		=> "\xe2\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xbc"		=> "\xe2\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xbd"		=> "\xe2\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xbe"		=> "\xe2\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x87\xbf"		=> "\xe2\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x80"		=> "\xe2\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x81"		=> "\xe2\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x82"		=> "\xe2\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x83"		=> "\xe2\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x84"		=> "\xe2\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x85"		=> "\xe2\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x86"		=> "\xe2\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x87"		=> "\xe2\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x88"		=> "\xe2\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x89"		=> "\xe2\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x8a"		=> "\xe2\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x8b"		=> "\xe2\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x8c"		=> "\xe2\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x8d"		=> "\xe2\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x8e"		=> "\xe2\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x8f"		=> "\xe2\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x90"		=> "\xe2\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x91"		=> "\xe2\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x92"		=> "\xe2\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x93"		=> "\xe2\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x94"		=> "\xe2\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x95"		=> "\xe2\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x96"		=> "\xe2\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x97"		=> "\xe2\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x98"		=> "\xe2\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x99"		=> "\xe2\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x9a"		=> "\xe2\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x9b"		=> "\xe2\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x9c"		=> "\xe2\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x9d"		=> "\xe2\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x9e"		=> "\xe2\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\x9f"		=> "\xe2\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa0"		=> "\xe2\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa1"		=> "\xe2\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa2"		=> "\xe2\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa3"		=> "\xe2\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa4"		=> "\xe2\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa5"		=> "\xe2\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa6"		=> "\xe2\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa7"		=> "\xe2\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa8"		=> "\xe2\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xa9"		=> "\xe2\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xaa"		=> "\xe2\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xab"		=> "\xe2\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xac"		=> "\xe2\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xad"		=> "\xe2\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xae"		=> "\xe2\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xaf"		=> "\xe2\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb0"		=> "\xe2\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb1"		=> "\xe2\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb2"		=> "\xe2\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb3"		=> "\xe2\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb4"		=> "\xe2\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb5"		=> "\xe2\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb6"		=> "\xe2\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb7"		=> "\xe2\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb8"		=> "\xe2\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xb9"		=> "\xe2\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xba"		=> "\xe2\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xbb"		=> "\xe2\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xbc"		=> "\xe2\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xbd"		=> "\xe2\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xbe"		=> "\xe2\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x88\xbf"		=> "\xe2\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x80"		=> "\xe2\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x81"		=> "\xe2\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x82"		=> "\xe2\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x83"		=> "\xe2\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x84"		=> "\xe2\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x85"		=> "\xe2\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8b\xbb"		=> "\xe2\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x97"		=> "\xe2\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x93"		=> "\xe2\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa1"		=> "\xe2\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x8a"		=> "\xe2\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x9e"		=> "\xe2\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x9d"		=> "\xe2\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\x95"		=> "\xe2\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa2"		=> "\xe2\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb9"		=> "\xe2\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xa5"		=> "\xe2\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xac"		=> "\xe2\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb8"		=> "\xe2\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8c\xb1"		=> "\xe2\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x90"		=> "\xe2\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x8d"		=> "\xe2\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\x97"		=> "\xe2\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xa0"		=> "\xe2\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xac"		=> "\xe2\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xaf"		=> "\xe2\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x8d\xbe"		=> "\xe2\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x88\x9b"		=> "\xe2\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa5"		=> "\xe2\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa3\xa7"		=> "\xe2\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\xa4"		=> "\xe2\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xa4\x82"		=> "\xe2\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xa3"		=> "\xe2\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xa7"		=> "\xe2\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xa8"		=> "\xe2\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xa9"		=> "\xe2\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xaa"		=> "\xe2\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xab"		=> "\xe2\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xac"		=> "\xe2\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb4"		=> "\xe2\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xb7"		=> "\xe2\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa5\xbd"		=> "\xe2\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x80"		=> "\xe2\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x84"		=> "\xe2\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x87"		=> "\xe2\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x8a"		=> "\xe2\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x8d"		=> "\xe2\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x90"		=> "\xe2\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x91"		=> "\xe2\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x93"		=> "\xe2\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x94"		=> "\xe2\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\xa6\x95"		=> "\xe2\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x80"		=> "\xe2\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x91"		=> "\xe2\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x8b"		=> "\xe2\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\x96"		=> "\xe2\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa5"		=> "\xe2\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xa0"		=> "\xe2\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb9"		=> "\xe2\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb5"		=> "\xe2\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xbe"		=> "\xe2\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xba\xb3"		=> "\xe2\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe8\xb5\x93"		=> "\xe2\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x92"		=> "\xe2\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x91"		=> "\xe2\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\x9b"		=> "\xe2\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xa8"		=> "\xe2\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbb\xaa"		=> "\xe2\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe8\x86\xba"		=> "\xe2\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x84"		=> "\xe2\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x89"		=> "\xe2\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x96"		=> "\xe2\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x8f"		=> "\xe2\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x83"		=> "\xe2\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xae"		=> "\xe2\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x84"		=> "\xe2\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa1"		=> "\xe2\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xa4"		=> "\xe2\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xbe"		=> "\xe2\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x85"		=> "\xe2\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x86"		=> "\xe2\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xaa"		=> "\xe2\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xad"		=> "\xe2\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\xb8"		=> "\xe2\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x99"		=> "\xe2\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xb5"		=> "\xe2\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa6"		=> "\xe2\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x9b"		=> "\xe2\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x8f"		=> "\xe2\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x8d"		=> "\xe2\xf4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa9"		=> "\xe2\xf5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xab"		=> "\xe2\xf6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\x8a"		=> "\xe2\xf7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xbf"		=> "\xe2\xf8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x80\xa1"		=> "\xe2\xf9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb8"		=> "\xe2\xfa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xb9"		=> "\xe2\xfb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xbb"		=> "\xe2\xfc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xba"		=> "\xe2\xfd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\x82"		=> "\xe2\xfe",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x86"		=> "\xe3\x40",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x87"		=> "\xe3\x41",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x88"		=> "\xe3\x42",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x89"		=> "\xe3\x43",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x8a"		=> "\xe3\x44",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x8b"		=> "\xe3\x45",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x8c"		=> "\xe3\x46",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x8d"		=> "\xe3\x47",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x8e"		=> "\xe3\x48",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x8f"		=> "\xe3\x49",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x90"		=> "\xe3\x4a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x91"		=> "\xe3\x4b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x92"		=> "\xe3\x4c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x93"		=> "\xe3\x4d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x94"		=> "\xe3\x4e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x95"		=> "\xe3\x4f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x96"		=> "\xe3\x50",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x97"		=> "\xe3\x51",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x98"		=> "\xe3\x52",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x99"		=> "\xe3\x53",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x9a"		=> "\xe3\x54",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x9b"		=> "\xe3\x55",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x9c"		=> "\xe3\x56",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x9d"		=> "\xe3\x57",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x9e"		=> "\xe3\x58",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\x9f"		=> "\xe3\x59",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa0"		=> "\xe3\x5a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa1"		=> "\xe3\x5b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa2"		=> "\xe3\x5c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa3"		=> "\xe3\x5d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa4"		=> "\xe3\x5e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa5"		=> "\xe3\x5f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa6"		=> "\xe3\x60",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa7"		=> "\xe3\x61",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa8"		=> "\xe3\x62",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xa9"		=> "\xe3\x63",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xaa"		=> "\xe3\x64",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xab"		=> "\xe3\x65",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xac"		=> "\xe3\x66",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xad"		=> "\xe3\x67",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xae"		=> "\xe3\x68",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xaf"		=> "\xe3\x69",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb0"		=> "\xe3\x6a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb1"		=> "\xe3\x6b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb2"		=> "\xe3\x6c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb3"		=> "\xe3\x6d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb5"		=> "\xe3\x6e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb6"		=> "\xe3\x6f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb7"		=> "\xe3\x70",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb8"		=> "\xe3\x71",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xb9"		=> "\xe3\x72",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xba"		=> "\xe3\x73",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xbb"		=> "\xe3\x74",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xbc"		=> "\xe3\x75",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xbd"		=> "\xe3\x76",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xbe"		=> "\xe3\x77",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x89\xbf"		=> "\xe3\x78",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x80"		=> "\xe3\x79",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x81"		=> "\xe3\x7a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x82"		=> "\xe3\x7b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x83"		=> "\xe3\x7c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x84"		=> "\xe3\x7d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x85"		=> "\xe3\x7e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x86"		=> "\xe3\x80",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x87"		=> "\xe3\x81",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x88"		=> "\xe3\x82",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x89"		=> "\xe3\x83",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x8a"		=> "\xe3\x84",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x8b"		=> "\xe3\x85",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x8c"		=> "\xe3\x86",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x8d"		=> "\xe3\x87",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x8f"		=> "\xe3\x88",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x90"		=> "\xe3\x89",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x91"		=> "\xe3\x8a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x92"		=> "\xe3\x8b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x93"		=> "\xe3\x8c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x94"		=> "\xe3\x8d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x95"		=> "\xe3\x8e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x96"		=> "\xe3\x8f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x97"		=> "\xe3\x90",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x98"		=> "\xe3\x91",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x99"		=> "\xe3\x92",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x9a"		=> "\xe3\x93",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x9b"		=> "\xe3\x94",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x9c"		=> "\xe3\x95",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x9d"		=> "\xe3\x96",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x9e"		=> "\xe3\x97",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\x9f"		=> "\xe3\x98",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa0"		=> "\xe3\x99",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa1"		=> "\xe3\x9a",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa2"		=> "\xe3\x9b",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa3"		=> "\xe3\x9c",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa4"		=> "\xe3\x9d",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa5"		=> "\xe3\x9e",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa6"		=> "\xe3\x9f",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x8a\xa7"		=> "\xe3\xa0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xaa"		=> "\xe3\xa1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x81\xbd"		=> "\xe3\xa2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x96"		=> "\xe3\xa3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x9a"		=> "\xe3\xa4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xad"		=> "\xe3\xa5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x9d"		=> "\xe3\xa6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x83"		=> "\xe3\xa7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x92"		=> "\xe3\xa8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x8c"		=> "\xe3\xa9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\x9b"		=> "\xe3\xaa",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xac"		=> "\xe3\xab",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xbb"		=> "\xe3\xac",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb1"		=> "\xe3\xad",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x9d"		=> "\xe3\xae",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x98"		=> "\xe3\xaf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x86"		=> "\xe3\xb0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\x9a"		=> "\xe3\xb1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x82\xb4"		=> "\xe3\xb2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa0"		=> "\xe3\xb3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa6"		=> "\xe3\xb4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x95"		=> "\xe3\xb5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xa3"		=> "\xe3\xb6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x83\xb4"		=> "\xe3\xb7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x80"		=> "\xe3\xb8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\x8e"		=> "\xe3\xb9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x84\xab"		=> "\xe3\xba",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\x8a"		=> "\xe3\xbb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x85\xb5"		=> "\xe3\xbc",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xac"		=> "\xe3\xbd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\x94"		=> "\xe3\xbe",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xa7"		=> "\xe3\xbf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x86\xb7"		=> "\xe3\xc0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\x94"		=> "\xe3\xc1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x87\xb5"		=> "\xe3\xc2",	//CJK UNIFIED IDEOGRAPH
		"\xe5\xbf\x9d"		=> "\xe3\xc3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x9a\xb3"		=> "\xe3\xc4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xa9"		=> "\xe3\xc5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xab"		=> "\xe3\xc6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb1"		=> "\xe3\xc7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb3"		=> "\xe3\xc8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb5"		=> "\xe3\xc9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xb6"		=> "\xe3\xca",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xbc"		=> "\xe3\xcb",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x97\xbe"		=> "\xe3\xcc",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x83"		=> "\xe3\xcd",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x84"		=> "\xe3\xce",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x86"		=> "\xe3\xcf",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x88"		=> "\xe3\xd0",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x8a"		=> "\xe3\xd1",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x8b"		=> "\xe3\xd2",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x8c"		=> "\xe3\xd3",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x8d"		=> "\xe3\xd4",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x8f"		=> "\xe3\xd5",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x92"		=> "\xe3\xd6",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x95"		=> "\xe3\xd7",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x96"		=> "\xe3\xd8",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x97"		=> "\xe3\xd9",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x99"		=> "\xe3\xda",	//CJK UNIFIED IDEOGRAPH
		"\xe9\x98\x9a"		=> "\xe3\xdb",	//CJK UNIFIED IDEOGRAPH
		"\xe4\xb8\xac"		=> "\xe3\xdc",	//CJK UNIFIED IDEOGRAPH
		"\xe7\x88\xbf"		=> "\xe3\xdd",	//CJK UNIFIED IDEOGRAPH
		"\xe6\x88\x95"		=> "\xe3\xde",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb0\xb5"		=> "\xe3\xdf",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x94"		=> "\xe3\xe0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x9c"		=> "\xe3\xe1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\x8a"		=> "\xe3\xe2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa3"		=> "\xe3\xe3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x85"		=> "\xe3\xe4",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x90"		=> "\xe3\xe5",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x94"		=> "\xe3\xe6",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x8c"		=> "\xe3\xe7",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa8"		=> "\xe3\xe8",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xa9"		=> "\xe3\xe9",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb4"		=> "\xe3\xea",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb1\xb6"		=> "\xe3\xeb",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\x86"		=> "\xe3\xec",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xa9"		=> "\xe3\xed",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x90"		=> "\xe3\xee",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x94"		=> "\xe3\xef",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb2\xad"		=> "\xe3\xf0",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb7"		=> "\xe3\xf1",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb8"		=> "\xe3\xf2",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\xb1"		=> "\xe3\xf3",	//CJK UNIFIED IDEOGRAPH
		"\xe6\xb3\x97"		=> "\xe3\xf4",	//CJK UNIFIED IDEOG