// HackBouncer.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <winsock2.h>
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>

typedef unsigned char byte;
typedef unsigned short word;
typedef struct NodeLap NodeLap;
typedef struct CompCar CompCar;
typedef struct {
	int x;
	int y;
	int z;
} Vec;
typedef struct {
	float x;
	float y;
	float z;
} Vector;
#include "InSim.h"

#define UDP_SIZE 512
#define KEY_I 0x49
#define HWKEY_I 0x17

fd_set fds;
timeval tval;
SOCKET ogSock;
WSADATA wsaData;
char inBuffer[UDP_SIZE];	//Stores OutGauge packet

DWORD ogThrID = 0;
DWORD chkBounceThrID = 1;
HANDLE ogPackMutex;
HANDLE threads[2];
struct {
	bool ogPackOK;
	bool ogConnOK;
} threadComm;

unsigned int delay = 41;
unsigned int timeCutoff = 0;
bool engineOn = true;

DWORD WINAPI checkBounce(LPVOID);
void closeConnection();
float getCutoffRPM(char*);
int initOutGauge(char*, word);
DWORD WINAPI receiveOGPacks(LPVOID);
void toggleIKey();

int _tmain(int argc, _TCHAR* argv[])
{
	if(argc > 1) {
		delay = _tstoi(argv[1]);
		std::cout << "Delay set to: " << delay << " msecs" << std::endl;
	}

	if(initOutGauge("127.0.0.1", 30000) != 0)
		return -1;

	std::cout << "(main)Info: OutGauge connection initialized" << std::endl;

	//Initialize threadComm struct
	threadComm.ogConnOK = true;
	threadComm.ogPackOK = true;

	ogPackMutex = CreateMutex(NULL, FALSE, NULL);

	//Start threads
	threads[0] = CreateThread(NULL, 0, receiveOGPacks, NULL, 0, &ogThrID);
	if(threads[0] == 0) {
		MessageBox(NULL, L"Cannot start thread 0", L"Critical", MB_ICONERROR | MB_OK);
		return -1;
	}
	threads[1] = CreateThread(NULL, 0, checkBounce, NULL, 0, &chkBounceThrID);
	if(threads[1] == 0) {
		MessageBox(NULL, L"Cannot start thread 0", L"Critical", MB_ICONERROR | MB_OK);
		return -1;
	}

	//Wait for threads to finish
	for(int i = 0; i < 2; i++) {
		WaitForSingleObject(threads[i], INFINITE);
		std::cout << "Thread " << i << " finished" << std::endl;
	}

	closeConnection();

	return 0;
}

/** Receives packets from OutGauge */
DWORD WINAPI receiveOGPacks(LPVOID lpArg) {
	int n, received;

	while(true) {
		received = 0;

		WaitForSingleObject(ogPackMutex, INFINITE);		//Lock mutex so that checkBounce thread doesn't read packet while we receive it

		n = select(ogSock, &fds, NULL, NULL, &tval);
		if (n == 0) {	//Connection timed out
			threadComm.ogPackOK = false;
			threadComm.ogConnOK = false;
			MessageBox(NULL, L"Lost connection to OutGauge.", L"Connection error", MB_ICONERROR | MB_OK);
			break;
		} else if(n < 0) {	//Something went wrong
			threadComm.ogPackOK = false;
			threadComm.ogConnOK = false;
			MessageBox(NULL, L"Unspecified connection error", L"Connection error", MB_ICONERROR | MB_OK);
			break;
		}

		received = recvfrom(ogSock, inBuffer, UDP_SIZE, 0, NULL, NULL);
		
		if (received > 512) {	//Winsock reported error
			threadComm.ogPackOK = false;
			threadComm.ogConnOK = false;
			MessageBox(NULL, L"WSA error", L"Critical", MB_ICONERROR | MB_OK);
			break;
		} else if (received != 92 && received != 96)  {		//Not an OutGauge packet
			threadComm.ogPackOK = false;
			std::cout << "Unknown packet received. Size: " << received << std::endl;
		} else
			threadComm.ogPackOK = true;
		
		ReleaseMutex(ogPackMutex);
	}

	return 0;
}

/** Reads received OutGauge packet and
	checks if the engine is at the redline */
DWORD WINAPI checkBounce(LPVOID lpArg) {
	while(true) {
		WaitForSingleObject(ogPackMutex, INFINITE);	//Lock mutex so that receiveOGPacks cannot read new packet while we read it
		//Check if we have correct data
		if(!threadComm.ogConnOK)	//OutGauge connection crashed, exit loop
			break;
		if(!threadComm.ogPackOK)	//Malformed packet, ignore it
			continue;
	
		//Store data from packet locally so we can release the mutex
		OutGaugePack* pack = (OutGaugePack*)inBuffer;
		char car[4];
		memcpy(car, pack->Car, 4);
		float RPM = pack->RPM;
		unsigned int time = pack->Time;
		ReleaseMutex(ogPackMutex);

		//Check which car is selected and set the redline accordingly
		float cutoffRPM = getCutoffRPM(car);
		if(cutoffRPM == 0)	//Unknown car or a car without a starter (BF1)
			continue;

		if((RPM > cutoffRPM) && engineOn) {		//Cut ignition off
			toggleIKey();
			timeCutoff = time;
			engineOn = false;
			std::cout << "engine off, RPM: " << RPM << std::endl;
		} else if ((time > timeCutoff+200) && !engineOn) {	//Get ignition back on
			std::cout << time << " " << timeCutoff << " " << timeCutoff+300 << std::endl;
			toggleIKey();
			std::cout << "engine on" << std::endl;
			engineOn = true;
		}
	}

	return 0;
}

/** Presses and releases "I" key */
void toggleIKey()
{
	keybd_event(KEY_I, HWKEY_I, 0, 0);
	Sleep(delay);
	keybd_event(KEY_I, HWKEY_I, KEYEVENTF_KEYUP, 0);
}

/** Checks what car is selected
	and returns its redline RPM*/
float getCutoffRPM(char* car)
{
	if(strcmp("UF1", car) == 0) return 6950.0;
	else if(strcmp("XFG", car) == 0) return 7950.0;
	else if(strcmp("XRG", car) == 0) return 6950.0;
	else if(strcmp("XFG", car) == 0) return 7950.0;
	else if(strcmp("LX4", car) == 0) return 8950.0;
	else if(strcmp("LX6", car) == 0) return 8950.0;
	else if(strcmp("XFG", car) == 0) return 7950.0;
	else if(strcmp("RB4", car) == 0) return 7450.0;
	else if(strcmp("FXO", car) == 0) return 7450.0;
	else if(strcmp("XRT", car) == 0) return 7450.0;
	else if(strcmp("XFG", car) == 0) return 7950.0;
	else if(strcmp("RAC", car) == 0) return 6950.0;
	else if(strcmp("FZ5", car) == 0) return 7950.0;
	else if(strcmp("UFR", car) == 0) return 8950.0;
	else if(strcmp("XFR", car) == 0) return 7950.0;
	else if(strcmp("FXR", car) == 0) return 7450.0;
	else if(strcmp("XRR", car) == 0) return 7450.0;
	else if(strcmp("FZR", car) == 0) return 8450.0;
	else if(strcmp("MRT", car) == 0) return 12800.0;
	else if(strcmp("FBM", car) == 0) return 9000.0;
	else if(strcmp("FOX", car) == 0) return 7450.0;
	else if(strcmp("XFG", car) == 0) return 7950.0;
	else if(strcmp("FO8", car) == 0) return 9450.0;
	else if(strcmp("XFG", car) == 0) return 7950.0;
	else return 0;
}


/** Close connection and tidy up */
void closeConnection() {
	closesocket(ogSock);
	WSACleanup();
}

/** Initialize and set up connection to OutGauge */
int initOutGauge(char* ipAddr, word port)
{
	//Init Winsock
	if(WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) {
		MessageBox(NULL, L"Cannot initialize WinSock", L"Critical", MB_ICONERROR | MB_OK);
		WSACleanup();
		return -1;
	}

	//Create socket
	ogSock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if(ogSock == INVALID_SOCKET) {
		MessageBox(NULL, L"Cannot create socket", L"Critical", MB_ICONERROR | MB_OK);
		WSACleanup();
		return -1;
	}

	//Setup socket
	sockaddr_in saddr;
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = inet_addr(ipAddr);
	saddr.sin_port = htons(port);

	//Bind socket
	if(bind(ogSock, (sockaddr*)&saddr, sizeof(saddr)) != 0) {
		MessageBox(NULL, L"Cannot bind socket", L"Critical", MB_ICONERROR | MB_OK);
		closesocket(ogSock);
		WSACleanup();
		return -1;
	}

	//Set timeout
	FD_ZERO(&fds);
	FD_SET(ogSock, &fds);
	tval.tv_usec = 0;
	tval.tv_sec = 60;	//30 second timeout

	//All done
	return 0;
}



