﻿namespace LFS_External.OutGauge
{
    using System;

    public class Flags
    {
        [Flags]
        public enum OutGaugeFlags : ushort
        {
            OG_SHIFT = 1,	// key
            OG_CTRL = 2,	// key

            OG_TURBO = 8192,// show turbo gauge
            OG_KM = 16384,	// if not set - user prefers MILES
            OG_BAR = 32768,	// if not set - user prefers PSI
        }

        [Flags]
        public enum DashLightFlags : uint
        {
            DL_SHIFT = 1,			// bit 0	- shift light
            DL_FULLBEAM = 2,		// bit 1	- full beam
            DL_HANDBRAKE = 4,		// bit 2	- handbrake
            DL_PITSPEED = 8,		// bit 3	- pit speed limiter
            DL_TC = 16,				// bit 4	- TC active or switched off
            DL_SIGNAL_L = 32,		// bit 5	- left turn signal
            DL_SIGNAL_R = 64,		// bit 6	- right turn signal
            DL_SIGNAL_ANY = 128,		// bit 7	- shared turn signal
            DL_OILWARN = 256,			// bit 8	- oil pressure warning
            DL_BATTERY = 512,			// bit 9	- battery warning
            DL_ABS = 1024,				// bit 10	- ABS active or switched off
            DL_SPARE = 2048,			// bit 11
            DL_NUM = 4096
        }
    }
}

