﻿namespace LFS_External
{
    using LFS_External.InSim;
    using System;
    using System.Text;

    internal static class MakePacket
    {
        public static byte[] ISP_BFN(Enums.BtnFunc Type, byte ClickID, byte UniqueID)
        {
            LFS_External.Packets.IS_BFN sourceStruct = new LFS_External.Packets.IS_BFN();
            sourceStruct.Size = 8;
            sourceStruct.Type = 0x2a;
            sourceStruct.ReqI = 1;
            sourceStruct.SubT = Type;
            sourceStruct.ClickID = ClickID;
            sourceStruct.UCID = UniqueID;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_BTN(string ButtonText, LFS_External.InSim.Flags.ButtonStyles Style, byte Height, byte Width, byte Top, byte Left, byte ClickID, byte UniqueID, byte RequestID, bool AlwaysVisible)
        {
            LFS_External.Packets.IS_BTN sourceStruct = new LFS_External.Packets.IS_BTN();
            sourceStruct.Size = 0xfc;
            sourceStruct.ReqI = RequestID;
            sourceStruct.Type = 0x2d;
            sourceStruct.UCID = UniqueID;
            sourceStruct.BStyle = Style;
            sourceStruct.ClickID = ClickID;
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[0x40];
            encoding.GetBytes(ButtonText, 0, ButtonText.Length, bytes, 0);
            sourceStruct.Text = ButtonText;
            sourceStruct.TypeIn = 0;
            if (AlwaysVisible)
            {
                sourceStruct.Inst = 0x80;
            }
            sourceStruct.H = Height;
            sourceStruct.W = Width;
            sourceStruct.T = Top;
            sourceStruct.L = Left;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_BTN(string ButtonText, string DialogCaption, LFS_External.InSim.Flags.ButtonStyles Style, byte Height, byte Width, byte Top, byte Left, byte TypeIn, byte ClickID, byte UniqueID, byte RequestID, bool AlwaysVisible)
        {
            LFS_External.Packets.IS_BTN sourceStruct = new LFS_External.Packets.IS_BTN();
            char ch = '\0';
            string s = string.Concat(new object[] { ch, DialogCaption, ch, ButtonText });
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[240];
            encoding.GetBytes(s, 0, s.Length, bytes, 0);
            sourceStruct.Text = s;
            sourceStruct.Size = 0xfc;
            sourceStruct.ReqI = RequestID;
            sourceStruct.Type = 0x2d;
            sourceStruct.UCID = UniqueID;
            sourceStruct.BStyle = Style;
            sourceStruct.ClickID = ClickID;
            sourceStruct.TypeIn = TypeIn;
            if (AlwaysVisible)
            {
                sourceStruct.Inst = 0x80;
            }
            sourceStruct.H = Height;
            sourceStruct.W = Width;
            sourceStruct.T = Top;
            sourceStruct.L = Left;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_CPP(int X, int Y, int Z, ushort H, ushort P, ushort R, byte PlayerID, byte InGameCam, float FOV, ushort Time, LFS_External.InSim.Flags.StateFlags Flags)
        {
            LFS_External.Packets.IS_CPP sourceStruct = new LFS_External.Packets.IS_CPP();
            sourceStruct.Size = 0x20;
            sourceStruct.Type = 9;
            sourceStruct.ReqI = 1;
            sourceStruct.Zero = 0;
            sourceStruct.X = X;
            sourceStruct.Y = Y;
            sourceStruct.Z = Z;
            sourceStruct.H = H;
            sourceStruct.P = P;
            sourceStruct.R = R;
            sourceStruct.ViewPLID = PlayerID;
            sourceStruct.InGameCam = InGameCam;
            sourceStruct.FOV = FOV;
            sourceStruct.Time = Time;
            sourceStruct.Flags = Flags;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_ISI(ushort UDPPort, ushort Flags, char Prefix, ushort MCI_NLP_Interval, string AdminPass, string AppName)
        {
            LFS_External.Packets.IS_ISI sourceStruct = new LFS_External.Packets.IS_ISI();
            sourceStruct.Size = 0x2c;
            sourceStruct.ReqI = 1;
            sourceStruct.Type = Enums.Packets.ISP_ISI;
            sourceStruct.Zero = 0;
            sourceStruct.UDPPort = UDPPort;
            sourceStruct.Flags = Flags;
            sourceStruct.Sp0 = 0;
            sourceStruct.Interval = MCI_NLP_Interval;
            sourceStruct.Prefix = (byte) Prefix;
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[0x10];
            byte[] buffer2 = new byte[0x10];
            encoding.GetBytes(AdminPass, 0, AdminPass.Length, bytes, 0);
            encoding.GetBytes(AppName, 0, AppName.Length, buffer2, 0);
            sourceStruct.Admin = AdminPass;
            sourceStruct.IName = AppName;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_MOD(int Bits16, int RefreshRate, int Width, int Height)
        {
            LFS_External.Packets.IS_MOD sourceStruct = new LFS_External.Packets.IS_MOD();
            sourceStruct.Size = 20;
            sourceStruct.Type = Enums.Packets.ISP_MOD;
            sourceStruct.ReqI = 0;
            sourceStruct.Zero = 0;
            sourceStruct.Bits16 = Bits16;
            sourceStruct.RR = RefreshRate;
            sourceStruct.Width = Width;
            sourceStruct.Height = Height;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_MSL(string Message, Enums.MSL_Sound Sound)
        {
            LFS_External.Packets.IS_MSL sourceStruct = new LFS_External.Packets.IS_MSL();
            sourceStruct.Size = 0x84;
            sourceStruct.ReqI = 0;
            sourceStruct.Type = Enums.Packets.ISP_MSL;
            sourceStruct.Sound = Sound;
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[0x80];
            encoding.GetBytes(Message, 0, Message.Length, bytes, 0);
            sourceStruct.Msg = Message;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_MST(string Message)
        {
            LFS_External.Packets.IS_MST sourceStruct = new LFS_External.Packets.IS_MST();
            sourceStruct.Size = 0x44;
            sourceStruct.ReqI = 0;
            sourceStruct.Type = Enums.Packets.ISP_MST;
            sourceStruct.Zero = 0;
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[0x40];
            encoding.GetBytes(Message, 0, Message.Length, bytes, 0);
            sourceStruct.Msg = Message;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_MSX(string Message)
        {
            LFS_External.Packets.IS_MSX sourceStruct = new LFS_External.Packets.IS_MSX();
            sourceStruct.Size = 100;
            sourceStruct.ReqI = 0;
            sourceStruct.Type = Enums.Packets.ISP_MSX;
            sourceStruct.Zero = 0;
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[0x60];
            encoding.GetBytes(Message, 0, Message.Length, bytes, 0);
            sourceStruct.Msg = Message;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_MTC(string Message, byte UniqueID, byte PlayerID, Enums.MSL_Sound Sound)
        {
            LFS_External.Packets.IS_MTC sourceStruct = new LFS_External.Packets.IS_MTC();
            sourceStruct.Size = 136;
            sourceStruct.ReqI = 0;
            sourceStruct.Type = Enums.Packets.ISP_MTC;
            sourceStruct.Sound = Sound;
            sourceStruct.UCID = UniqueID;
            sourceStruct.PLID = PlayerID;
            sourceStruct.Sp2 = 0;
            sourceStruct.Sp3 = 0;
            ASCIIEncoding encoding = new ASCIIEncoding();
            byte[] bytes = new byte[0x40];
            encoding.GetBytes(Message, 0, Message.Length, bytes, 0);
            sourceStruct.Msg = Message;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_SCC(byte PlayerID, byte InGameCamera)
        {
            LFS_External.Packets.IS_SCC sourceStruct = new LFS_External.Packets.IS_SCC();
            sourceStruct.Size = 8;
            sourceStruct.Type = Enums.Packets.ISP_SCC;
            sourceStruct.ReqI = 0;
            sourceStruct.Zero = 0;
            sourceStruct.ViewPLID = PlayerID;
            sourceStruct.InGameCam = InGameCamera;
            sourceStruct.Sp2 = 0;
            sourceStruct.Sp3 = 0;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_SCH(char Char, LFS_External.InSim.Flags.SCHFlags Flags)
        {
            LFS_External.Packets.IS_SCH sourceStruct = new LFS_External.Packets.IS_SCH();
            sourceStruct.Size = 8;
            sourceStruct.ReqI = 0;
            sourceStruct.Type = Enums.Packets.ISP_SCH;
            sourceStruct.Zero = 0;
            sourceStruct.CharB = (byte) Char;
            sourceStruct.Flags = (byte) Flags;
            sourceStruct.Spare2 = 0;
            sourceStruct.Spare3 = 0;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_SFP(LFS_External.InSim.Flags.StateFlags Flags, byte OffOn)
        {
            LFS_External.Packets.IS_SFP sourceStruct = new LFS_External.Packets.IS_SFP();
            sourceStruct.Size = 8;
            sourceStruct.Type = Enums.Packets.ISP_SFP;
            sourceStruct.ReqI = 0;
            sourceStruct.Zero = 0;
            sourceStruct.Flag = (ushort) Flags;
            sourceStruct.OffOn = OffOn;
            sourceStruct.Sp3 = 0;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_SMALL(Enums.Small Type, byte ReqI, uint Value)
        {
            LFS_External.Packets.IS_SMALL sourceStruct = new LFS_External.Packets.IS_SMALL();
            sourceStruct.ReqI = ReqI;
            sourceStruct.Size = 8;
            sourceStruct.SubT = Type;
            sourceStruct.Type = Enums.Packets.ISP_SMALL;
            sourceStruct.UVal = Value;
            return Util.PacketToData(sourceStruct);
        }

        public static byte[] ISP_TINY(Enums.Tiny Type, byte ReqI)
        {
            LFS_External.Packets.IS_TINY sourceStruct = new LFS_External.Packets.IS_TINY();
            sourceStruct.ReqI = ReqI;
            sourceStruct.Size = 4;
            sourceStruct.SubT = Type;
            sourceStruct.Type = Enums.Packets.ISP_TINY;
            return Util.PacketToData(sourceStruct);
        }
    }
}

