﻿namespace LFS_External.InSim
{
    using System;

    public class Flags
    {
        [Flags]
        public enum ButtonClickFlags : byte
        {
            ISB_CTRL = 4,
            ISB_LMB = 1,
            ISB_RMB = 2,
            ISB_SHIFT = 8
        }

        [Flags]
        public enum ButtonStyles : byte
        {
            ISB_C1 = 1,
            ISB_C2 = 2,
            ISB_C4 = 4,
            ISB_CLICK = 8,
            ISB_DARK = 0x20,
            ISB_LEFT = 0x40,
            ISB_LIGHT = 0x10,
            ISB_RIGHT = 0x80
        }

        [Flags]
        public enum CompCarFlags : byte
        {
            CCI_BLUE = 1,
            CCI_FIRST = 0x40,
            CCI_LAST = 0x80,
            CCI_YELLOW = 2
        }

        [Flags]
        public enum ConfirmationFlags : byte
        {
            CONF_CONFIRMED = 2,
            CONF_DID_NOT_PIT = 0x40,
            CONF_DISQ = 0x4c,
            CONF_MENTIONED = 1,
            CONF_PENALTY_30 = 0x10,
            CONF_PENALTY_45 = 0x20,
            CONF_PENALTY_DT = 4,
            CONF_PENALTY_SG = 8,
            CONF_TIME = 0x30
        }

        [Flags]
        public enum InSimFlags : byte
        {
            ISF_LOCAL = 4,
            ISF_MCI = 0x20,
            ISF_MSO_COLS = 8,
            ISF_NLP = 0x10,
            ISF_RES_0 = 1,
            ISF_RES_1 = 2,
            ISF_CON = 64
        }

        [Flags]
        public enum PitWorkFlags : uint
        {
            PSE_BODY_MAJOR = 0x8000,
            PSE_BODY_MINOR = 0x4000,
            PSE_FR_DAM = 4,
            PSE_FR_WHL = 8,
            PSE_LE_FR_DAM = 0x10,
            PSE_LE_FR_WHL = 0x20,
            PSE_LE_RE_DAM = 0x400,
            PSE_LE_RE_WHL = 0x800,
            PSE_NOTHING = 1,
            PSE_RE_DAM = 0x100,
            PSE_RE_WHL = 0x200,
            PSE_REFUEL = 0x20000,
            PSE_RI_FR_DAM = 0x40,
            PSE_RI_FR_WHL = 0x80,
            PSE_RI_RE_DAM = 0xffe,
            PSE_RI_RE_WHL = 0x2000,
            PSE_SETUP = 0x10000,
            PSE_STOP = 2
        }

        [Flags]
        public enum PlayerFlags : ushort
        {
            PIF_AUTOCLUTCH = 0x200,
            PIF_AUTOGEARS = 8,
            PIF_AXIS_CLUTCH = 0x80,
            PIF_CUSTOM_VIEW = 0x2000,
            PIF_GC_BLIP = 4,
            PIF_GC_CUT = 2,
            PIF_HELP_B = 0x40,
            PIF_INPITS = 0x100,
            PIF_KB_NO_HELP = 0x800,
            PIF_KB_STABILISED = 0x1000,
            PIF_MOUSE = 0x400,
            PIF_RESERVED = 0x20,
            PIF_SHIFTER = 0x10,
            PIF_SWAPSIDE = 1
        }

        [Flags]
        public enum RaceFlags : ushort
        {
            HOSTF_CAN_RESET = 0x80,
            HOSTF_CAN_SELECT = 2,
            HOSTF_CAN_VOTE = 1,
            HOSTF_FCV = 0x100,
            HOSTF_MID_RACE = 0x20,
            HOSTF_MUST_PIT = 0x40
        }

        [Flags]
        public enum SCHFlags : byte
        {
            Control = 2,
            None = 0,
            Shift = 1
        }

        [Flags]
        public enum StateFlags : ushort
        {
            ISS_FRONT_END = 0x100,
            ISS_GAME = 1,
            ISS_MPSPEEDUP = 0x400,
            ISS_MULTI = 0x200,
            ISS_PAUSED = 4,
            ISS_REPLAY = 2,
            ISS_SHIFTU = 8,
            ISS_SHIFTU_FOLLOW = 0x20,
            ISS_16 = 0x10,
            ISS_SHIFTU_NO_OPT = 0x40,
            ISS_SHOW_2D = 0x80,
            ISS_SOUND_MUTE = 0x1000,
            ISS_VIEW_OVERRIDE = 0x2000,
            ISS_VISIBLE = 0x4000,
            ISS_WINDOWED = 0x800
        }
    }
}

