﻿namespace LFS_External
{
    using System;
    using System.Runtime.InteropServices;

    internal static class Util
    {
        public static object DataToPacket(byte[] Data, object DestStruct)
        {
            IntPtr ptr = Marshal.AllocHGlobal(Marshal.SizeOf(DestStruct));
            GCHandle handle = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            Marshal.Copy(Data, 0, ptr, Data.Length);
            DestStruct = Marshal.PtrToStructure(ptr, DestStruct.GetType());
            handle.Free();
            Marshal.FreeHGlobal(ptr);
            return DestStruct;
        }

        public static byte[] PacketToData(object SourceStruct)
        {
            int cb = Marshal.SizeOf(SourceStruct);
            IntPtr ptr = Marshal.AllocHGlobal(cb);
            GCHandle handle = GCHandle.Alloc(ptr);
            byte[] destination = new byte[cb];
            Marshal.StructureToPtr(SourceStruct, ptr, false);
            Marshal.Copy(ptr, destination, 0, cb);
            handle.Free();
            Marshal.FreeHGlobal(ptr);
            return destination;
        }
    }
}

