﻿namespace LFS_External
{
    using System;
    using System.Net;
    using System.Net.Sockets;
    using System.Threading;

    public abstract class UDPListener
    {
        private bool _exit = false;
        protected int _port;
        private enuState _state = enuState.Closed;
        private const int BUFFERSIZE = 0x200;
        private UdpClient udpClient;
        private IPEndPoint udpEP;

        protected UDPListener()
        {
        }

        public void Close()
        {
            if (this._state != enuState.Closed)
            {
                this._exit = true;
                byte[] dgram = new byte[1];
                this.udpClient.Send(dgram, 1, "localhost", this._port);
                this._state = enuState.Closed;
            }
        }

        protected abstract void DataReceived(byte[] data);
        public void Listen()
        {
            if (this._state != enuState.Listening)
            {
                new Thread(new ThreadStart(this.UDPListen)).Start();
                this._state = enuState.Listening;
            }
        }

        private void UDPListen()
        {
            try
            {
                this.udpEP = new IPEndPoint(IPAddress.Any, this._port);
                this.udpClient = new UdpClient(this.udpEP);
            }
            catch (Exception)
            {
                this._state = enuState.Closed;
                this._exit = true;
                return;
            }
            while (!this._exit)
            {
                byte[] data = new byte[0x200];
                data = this.udpClient.Receive(ref this.udpEP);
                this.DataReceived(data);
            }
            this.udpClient.Close();
        }

        public enuState State
        {
            get
            {
                return this._state;
            }
        }

        public enum enuState
        {
            Closed,
            Listening
        }
    }
}

