﻿namespace LFS_External.InSim
{
    using LFS_External;
    using System;
    using System.Diagnostics;
    using System.Net;
    using System.Net.Sockets;
    using System.Runtime.CompilerServices;
    using System.Threading;

    public class InSimInterface : IInSimInterface
    {
        private string _name = "Default InSimInterface";
        private InSimState _state = InSimState.Disconnected;
        private const int BUFFERSIZE = 0x400;
        private InSimSettings cfg;
        private bool CheckPassword = true;
        private TcpClient Client;
        private bool DoMonitor = true;
        private IPEndPoint EP;
        private InSimExceptions Error = InSimExceptions.None;
        private bool IsReconnect;
        private byte[] partialpacket = null;
        private int partialpacketbleft = 0;
        private int partialpacketindex = 0;
        private NetworkStream Stream;
        private bool ThreadRun = true;
        private Thread trdTCPListen;
        private Thread trdUDPListen;
        private UdpClient udpClient;
        private IPEndPoint udpEP;

        public event AXC_EventHandler AXC_Received;

        public event AXI_EventHandler AXI_Received;

        public event AXO_EventHandler AXO_Received;

        public event BFN_EventHandler BFN_Received;

        public event BTC_EventHandler BTC_Received;

        public event BTT_EventHandler BTT_Received;

        public event CCH_EventHandler CCH_Received;

        public event CLR_EventHandler CLR_Received;

        public event CNL_EventHandler CNL_Received;

        public event ConnectionLost_EventHandler ConnectionLost;

        public event CPP_EventHandler CPP_Received;

        public event CPR_EventHandler CPR_Received;

        public event CRS_EventHandler CRS_Received;

        public event FIN_EventHandler FIN_Received;

        public event FLG_EventHandler FLG_Received;

        public event III_EventHandler III_Received;

        public event ISM_EventHandler ISM_Received;

        public event LAP_EventHandler LAP_Received;

        public event MCI_EventHandler MCI_Received;

        public event MPE_EventHandler MPE_Received;

        public event MSO_EventHandler MSO_Received;

        public event NCN_EventHandler NCN_Received;

        public event NLP_EventHandler NLP_Received;

        public event NPL_EventHandler NPL_Received;

        public event PEN_EventHandler PEN_Received;

        public event PFL_EventHandler PFL_Received;

        public event PIT_EventHandler PIT_Received;

        public event PLA_EventHandler PLA_Received;

        public event PLL_EventHandler PLL_Received;

        public event PLP_EventHandler PLP_Received;

        public event PSF_EventHandler PSF_Received;

        public event Reconnected_EventHandler Reconnected;

        public event REN_EventHandler REN_Received;

        public event REO_EventHandler REO_Received;

        public event REPLY_EventHandler REPLY_Received;

        public event RES_EventHandler RES_Received;

        public event RST_EventHandler RST_Received;

        public event RTP_EventHandler RTP_Received;

        public event SPX_EventHandler SPX_Received;

        public event STA_EventHandler STA_Received;

        public event TOC_EventHandler TOC_Received;

        public event VER_EventHandler VER_Received;

        public event VTA_EventHandler VTA_Received;

        public event VTC_EventHandler VTC_Received;

        public event VTN_EventHandler VTN_Received;

        public event CON_EventHandler CON_Received;

        public InSimInterface(InSimSettings Settings)
        {
            string str = "";
            if (Settings.AdminPass.Length > 0x10)
            {
                str = str + "Admin password too long, 16 chars max allowed.\n";
            }
            if (Settings.AppName.Length > 0x10)
            {
                str = str + "Application Name too long, 16 chars max allowed.\n";
            }
            if (Settings.PortNumber == 0)
            {
                str = str + "Port number 0 is not valid\n";
            }
            if (str != "")
            {
                throw new InvalidConfigurationException(str + "\nVerify you InSimSettings parameters for incorrect values.");
            }
            this.cfg = Settings;
            this.InitializeConnection();
        }

        public void Close()
        {
            if (this._state != InSimState.Disconnected)
            {
                if (this.Client.Connected)
                {
                    this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_CLOSE, 0));
                }
                this._state = InSimState.Disconnected;
                this.ThreadRun = false;
                this.DoMonitor = false;
                if (this.udpClient != null)
                {
                    byte[] dgram = new byte[1];
                    this.udpClient.Send(dgram, 1, "localhost", this.cfg.UdpReplyPort);
                }
            }
        }

        public void Connect()
        {
            if (this._state != InSimState.Connected)
            {
                this.ThreadRun = true;
                this.DoMonitor = true;
                this.Error = InSimExceptions.None;
                if (this.cfg == null)
                {
                    throw new Exception("Unable to connect, InSim interface not properly initialized.");
                }
                try
                {
                    this.Client = new TcpClient();
                    this.Client.Connect(this.EP);
                    this.Stream = this.Client.GetStream();
                    this._state = InSimState.Connected;
                }
                catch (SocketException)
                {
                    if (!this.IsReconnect)
                    {
                        if (this._state == InSimState.Connected)
                        {
                            this._state = InSimState.Disconnected;
                        }
                        throw new UnableToConnectToInSimException("The InSim Interface was unable to connect to the remote InSim host.");
                    }
                    this._state = InSimState.LostConnection;
                }
                if (this.cfg.UdpReplyPort > 0)
                {
                    try
                    {
                        this.udpEP = new IPEndPoint(IPAddress.Any, this.cfg.UdpReplyPort);
                        this.udpClient = new UdpClient(this.udpEP);
                    }
                    catch (SocketException)
                    {
                    }
                }
                if (this.Client.Connected)
                {
                    if (this.trdTCPListen.ThreadState == System.Threading.ThreadState.Unstarted)
                    {
                        this.trdTCPListen.Start();
                    }
                    else if (this.trdTCPListen.ThreadState == System.Threading.ThreadState.Stopped)
                    {
                        this.trdTCPListen = new Thread(new ThreadStart(this.listen_tcp));
                        this.trdTCPListen.Start();
                    }
                    if (this.trdUDPListen != null)
                    {
                        if (this.trdUDPListen.ThreadState == System.Threading.ThreadState.Unstarted)
                        {
                            this.trdUDPListen.Start();
                        }
                        else if (this.trdUDPListen.ThreadState == System.Threading.ThreadState.Stopped)
                        {
                            this.trdUDPListen = new Thread(new ThreadStart(this.listen_udp));
                            this.trdUDPListen.Start();
                        }
                    }
                    if (this.cfg.AutoReconnectDelay != 0)
                    {
                        new Thread(new ThreadStart(this.ConnectionMonitor)).Start();
                    }
                    this.Send(MakePacket.ISP_ISI(this.cfg.UdpReplyPort, (ushort)this.cfg.Flags, this.cfg.CommandPrefix, this.cfg.MCI_NLP_Interval, this.cfg.AdminPass, this.cfg.AppName));
                    while (this.CheckPassword)
                    {
                        Thread.Sleep(100);
                        if (this.Error == InSimExceptions.BadAdminPassword)
                        {
                            this._state = InSimState.Disconnected;
                            throw new AdminPasswordDoesNotMatchException("Admin password does not match InSim host password.");
                        }
                    }
                }
            }
        }

        private void ConnectionMonitor()
        {
            while (this.DoMonitor)
            {
                Thread.Sleep(500);
                if (this._state == InSimState.LostConnection)
                {
                    this.Close();
                    this.IsReconnect = true;
                    Thread.Sleep(500);
                    this.Connect();
                    if (this._state != InSimState.Connected)
                    {
                        Thread.Sleep((int)this.cfg.AutoReconnectDelay);
                    }
                    else
                    {
                        if (this.Reconnected != null)
                        {
                            this.Reconnected();
                        }
                        this.IsReconnect = false;
                    }
                }
            }
        }

        private void InitializeConnection()
        {
            this.trdTCPListen = new Thread(new ThreadStart(this.listen_tcp));
            if (this.cfg.UdpReplyPort > 0)
            {
                this.trdUDPListen = new Thread(new ThreadStart(this.listen_udp));
            }
            this.EP = new IPEndPoint(this.cfg.ServerIP, this.cfg.PortNumber);
        }

        private void listen_tcp()
        {
            byte num2 = 0;
            byte[] buffer = new byte[0x400];
            byte[] destinationArray = new byte[0];
            int num3 = 0;
            int length = 0;
            int index = 0;
            int num6 = 0;
            int destinationIndex = 0;
            int num8 = 0;
            int sourceIndex = 0;
            int num10 = 1;
            bool flag = false;
            bool flag2 = false;
            bool flag3 = false;
            while (this.ThreadRun)
            {
                if (!flag3)
                {
                    num3 = this.Stream.Read(buffer, 0, 0x400);
                }
                if (this.CheckPassword)
                {
                    int num11 = 0;
                    for (int i = 0; i < 0x400; i++)
                    {
                        num11 += buffer[i];
                    }
                    if (num11 == 0)
                    {
                        if (num2 >= 2)
                        {
                            this.Error = InSimExceptions.BadAdminPassword;
                            this._state = InSimState.Disconnected;
                            this.ThreadRun = false;
                            continue;
                        }
                        num2 = (byte)(num2 + 1);
                    }
                    else
                    {
                        this.CheckPassword = false;
                    }
                }
                if (num3 > 0)
                {
                    if (!flag)
                    {
                        length = buffer[index];
                    }
                    if (flag || ((num3 - index) < length))
                    {
                        if (num10 == 1)
                        {
                            flag = true;
                            num8 = length;
                            sourceIndex = index;
                            num6 = num3 - index;
                            flag3 = false;
                            destinationIndex = 0;
                            destinationArray = new byte[length];
                        }
                        else
                        {
                            if (num8 > num3)
                            {
                                num6 = num3;
                            }
                            else
                            {
                                num6 = num8;
                            }
                            sourceIndex = 0;
                        }
                        num8 -= num6;
                        if (num8 == 0)
                        {
                            flag2 = true;
                            flag = false;
                            num10 = 1;
                        }
                        else
                        {
                            flag2 = false;
                            num10++;
                        }
                        Array.Copy(buffer, sourceIndex, destinationArray, destinationIndex, num6);
                        destinationIndex += num6;
                        if (flag2)
                        {
                            if ((num3 - num6) > 0)
                            {
                                flag3 = true;
                                index = num6;
                            }
                            else
                            {
                                flag3 = false;
                                index = 0;
                            }
                            this.TCP_PacketReceived(destinationArray);
                        }
                    }
                    else
                    {
                        destinationArray = new byte[length];
                        Array.Copy(buffer, index, destinationArray, 0, length);
                        if ((num3 - (length + index)) > 0)
                        {
                            flag3 = true;
                            index += length;
                        }
                        else
                        {
                            flag3 = false;
                            index = 0;
                        }
                        this.TCP_PacketReceived(destinationArray);
                    }
                }
                else
                {
                    if (num2 >= 2)
                    {
                        this._state = InSimState.LostConnection;
                        this.ThreadRun = false;
                        if (!((this.ConnectionLost == null) || this.IsReconnect))
                        {
                            this.ConnectionLost();
                        }
                        continue;
                    }
                    num2 = (byte)(num2 + 1);
                }
            }
        }

        private void listen_udp()
        {
            while (this.ThreadRun)
            {
                byte[] data = new byte[0x400];
                data = this.udpClient.Receive(ref this.udpEP);
                this.UDP_PacketReceived(data);
            }
            this.udpClient.Close();
        }

        private void ParsePacket(byte[] packet, Enums.Protocol Protocol)
        {
            switch (((Enums.Packets)packet[1]))
            {
                case Enums.Packets.ISP_VER:
                    {
                        LFS_External.Packets.IS_VER destStruct = new LFS_External.Packets.IS_VER();
                        destStruct = (LFS_External.Packets.IS_VER)Util.DataToPacket(packet, destStruct);
                        if (this.VER_Received != null)
                        {
                            this.VER_Received(destStruct);
                        }
                        return;
                    }
                case Enums.Packets.ISP_TINY:
                    switch (((Enums.Tiny)packet[3]))
                    {
                        case Enums.Tiny.TINY_REPLY:
                            if (this.REPLY_Received != null)
                            {
                                this.REPLY_Received();
                            }
                            return;

                        case Enums.Tiny.TINY_VTC:
                            if (this.VTC_Received != null)
                            {
                                this.VTC_Received();
                            }
                            return;

                        case Enums.Tiny.TINY_MPE:
                            if (this.MPE_Received != null)
                            {
                                this.MPE_Received();
                            }
                            return;

                        case Enums.Tiny.TINY_REN:
                            if (this.REN_Received != null)
                            {
                                this.REN_Received();
                            }
                            return;

                        case Enums.Tiny.TINY_CLR:
                            if (this.CLR_Received != null)
                            {
                                this.CLR_Received();
                            }
                            return;

                        case Enums.Tiny.TINY_AXC:
                            if (this.AXC_Received != null)
                            {
                                this.AXC_Received();
                            }
                            return;

                        case Enums.Tiny.TINY_NONE:
                            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_NONE, 0));
                            return;
                    }
                    break;

                case Enums.Packets.ISP_SMALL:
                    {
                        LFS_External.Packets.IS_SMALL is_small = new LFS_External.Packets.IS_SMALL();
                        is_small = (LFS_External.Packets.IS_SMALL)Util.DataToPacket(packet, is_small);
                        Enums.Small subT = is_small.SubT;
                        if (subT == Enums.Small.SMALL_VTA)
                        {
                            if (this.VTA_Received != null)
                            {
                                this.VTA_Received(packet[4]);
                            }
                            return;
                        }
                        if (subT != Enums.Small.SMALL_RTP)
                        {
                            Debug.WriteLine("Received unknown SMALL packet: " + is_small.SubT.ToString());
                            return;
                        }
                        if (this.RTP_Received != null)
                        {
                            this.RTP_Received(is_small.UVal);
                        }
                        return;
                    }
                case Enums.Packets.ISP_STA:
                    {
                        LFS_External.Packets.IS_STA is_sta = new LFS_External.Packets.IS_STA();
                        is_sta = (LFS_External.Packets.IS_STA)Util.DataToPacket(packet, is_sta);
                        if (this.STA_Received != null)
                        {
                            this.STA_Received(is_sta);
                        }
                        return;
                    }
                case Enums.Packets.ISP_CPP:
                    {
                        LFS_External.Packets.IS_CPP is_cpp = new LFS_External.Packets.IS_CPP();
                        is_cpp = (LFS_External.Packets.IS_CPP)Util.DataToPacket(packet, is_cpp);
                        if (this.CPP_Received != null)
                        {
                            this.CPP_Received(is_cpp);
                        }
                        return;
                    }
                case Enums.Packets.ISP_ISM:
                    {
                        LFS_External.Packets.IS_ISM is_ism = new LFS_External.Packets.IS_ISM();
                        is_ism = (LFS_External.Packets.IS_ISM)Util.DataToPacket(packet, is_ism);
                        if (this.ISM_Received != null)
                        {
                            this.ISM_Received(is_ism);
                        }
                        return;
                    }
                case Enums.Packets.ISP_MSO:
                    {
                        LFS_External.Packets.IS_MSO is_mso = new LFS_External.Packets.IS_MSO();
                        is_mso = (LFS_External.Packets.IS_MSO)Util.DataToPacket(packet, is_mso);
                        if (this.MSO_Received != null)
                        {
                            this.MSO_Received(is_mso);
                        }
                        return;
                    }
                case Enums.Packets.ISP_III:
                    {
                        LFS_External.Packets.IS_III is_iii = new LFS_External.Packets.IS_III();
                        is_iii = (LFS_External.Packets.IS_III)Util.DataToPacket(packet, is_iii);
                        if (this.III_Received != null)
                        {
                            this.III_Received(is_iii);
                        }
                        return;
                    }
                case Enums.Packets.ISP_VTN:
                    {
                        LFS_External.Packets.IS_VTN is_vtn = new LFS_External.Packets.IS_VTN();
                        is_vtn = (LFS_External.Packets.IS_VTN)Util.DataToPacket(packet, is_vtn);
                        if (this.VTN_Received != null)
                        {
                            this.VTN_Received(is_vtn);
                        }
                        return;
                    }
                case Enums.Packets.ISP_RST:
                    {
                        LFS_External.Packets.IS_RST is_rst = new LFS_External.Packets.IS_RST();
                        is_rst = (LFS_External.Packets.IS_RST)Util.DataToPacket(packet, is_rst);
                        if (this.RST_Received != null)
                        {
                            this.RST_Received(is_rst);
                        }
                        return;
                    }
                case Enums.Packets.ISP_NCN:
                    {
                        LFS_External.Packets.IS_NCN is_ncn = new LFS_External.Packets.IS_NCN();
                        is_ncn = (LFS_External.Packets.IS_NCN)Util.DataToPacket(packet, is_ncn);
                        if (this.NCN_Received != null)
                        {
                            this.NCN_Received(is_ncn);
                        }
                        return;
                    }
                case Enums.Packets.ISP_CNL:
                    {
                        LFS_External.Packets.IS_CNL is_cnl = new LFS_External.Packets.IS_CNL();
                        is_cnl = (LFS_External.Packets.IS_CNL)Util.DataToPacket(packet, is_cnl);
                        if (this.CNL_Received != null)
                        {
                            this.CNL_Received(is_cnl);
                        }
                        return;
                    }
                case Enums.Packets.ISP_CPR:
                    {
                        LFS_External.Packets.IS_CPR is_cpr = new LFS_External.Packets.IS_CPR();
                        is_cpr = (LFS_External.Packets.IS_CPR)Util.DataToPacket(packet, is_cpr);
                        if (this.CPR_Received != null)
                        {
                            this.CPR_Received(is_cpr);
                        }
                        return;
                    }
                case Enums.Packets.ISP_NPL:
                    {
                        LFS_External.Packets.IS_NPL is_npl = new LFS_External.Packets.IS_NPL();
                        is_npl = (LFS_External.Packets.IS_NPL)Util.DataToPacket(packet, is_npl);
                        if (this.NPL_Received != null)
                        {
                            this.NPL_Received(is_npl);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PLP:
                    {
                        LFS_External.Packets.IS_PLP is_plp = new LFS_External.Packets.IS_PLP();
                        is_plp = (LFS_External.Packets.IS_PLP)Util.DataToPacket(packet, is_plp);
                        if (this.PLP_Received != null)
                        {
                            this.PLP_Received(is_plp);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PLL:
                    {
                        LFS_External.Packets.IS_PLL is_pll = new LFS_External.Packets.IS_PLL();
                        is_pll = (LFS_External.Packets.IS_PLL)Util.DataToPacket(packet, is_pll);
                        if (this.PLL_Received != null)
                        {
                            this.PLL_Received(is_pll);
                        }
                        return;
                    }
                case Enums.Packets.ISP_LAP:
                    {
                        LFS_External.Packets.IS_LAP is_lap = new LFS_External.Packets.IS_LAP();
                        is_lap = (LFS_External.Packets.IS_LAP)Util.DataToPacket(packet, is_lap);
                        if (this.LAP_Received != null)
                        {
                            this.LAP_Received(is_lap);
                        }
                        return;
                    }
                case Enums.Packets.ISP_SPX:
                    {
                        LFS_External.Packets.IS_SPX is_spx = new LFS_External.Packets.IS_SPX();
                        is_spx = (LFS_External.Packets.IS_SPX)Util.DataToPacket(packet, is_spx);
                        if (this.SPX_Received != null)
                        {
                            this.SPX_Received(is_spx);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PIT:
                    {
                        LFS_External.Packets.IS_PIT is_pit = new LFS_External.Packets.IS_PIT();
                        is_pit = (LFS_External.Packets.IS_PIT)Util.DataToPacket(packet, is_pit);
                        if (this.PIT_Received != null)
                        {
                            this.PIT_Received(is_pit);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PSF:
                    {
                        LFS_External.Packets.IS_PSF is_psf = new LFS_External.Packets.IS_PSF();
                        is_psf = (LFS_External.Packets.IS_PSF)Util.DataToPacket(packet, is_psf);
                        if (this.PSF_Received != null)
                        {
                            this.PSF_Received(is_psf);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PLA:
                    {
                        LFS_External.Packets.IS_PLA is_pla = new LFS_External.Packets.IS_PLA();
                        is_pla = (LFS_External.Packets.IS_PLA)Util.DataToPacket(packet, is_pla);
                        if (this.PLA_Received != null)
                        {
                            this.PLA_Received(is_pla);
                        }
                        return;
                    }
                case Enums.Packets.ISP_CCH:
                    {
                        LFS_External.Packets.IS_CCH is_cch = new LFS_External.Packets.IS_CCH();
                        is_cch = (LFS_External.Packets.IS_CCH)Util.DataToPacket(packet, is_cch);
                        if (this.CCH_Received != null)
                        {
                            this.CCH_Received(is_cch);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PEN:
                    {
                        LFS_External.Packets.IS_PEN is_pen = new LFS_External.Packets.IS_PEN();
                        is_pen = (LFS_External.Packets.IS_PEN)Util.DataToPacket(packet, is_pen);
                        if (this.PEN_Received != null)
                        {
                            this.PEN_Received(is_pen);
                        }
                        return;
                    }
                case Enums.Packets.ISP_TOC:
                    {
                        LFS_External.Packets.IS_TOC is_toc = new LFS_External.Packets.IS_TOC();
                        is_toc = (LFS_External.Packets.IS_TOC)Util.DataToPacket(packet, is_toc);
                        if (this.TOC_Received != null)
                        {
                            this.TOC_Received(is_toc);
                        }
                        return;
                    }
                case Enums.Packets.ISP_FLG:
                    {
                        LFS_External.Packets.IS_FLG is_flg = new LFS_External.Packets.IS_FLG();
                        is_flg = (LFS_External.Packets.IS_FLG)Util.DataToPacket(packet, is_flg);
                        if (this.FLG_Received != null)
                        {
                            this.FLG_Received(is_flg);
                        }
                        return;
                    }
                case Enums.Packets.ISP_PFL:
                    {
                        LFS_External.Packets.IS_PFL is_pfl = new LFS_External.Packets.IS_PFL();
                        is_pfl = (LFS_External.Packets.IS_PFL)Util.DataToPacket(packet, is_pfl);
                        if (this.PFL_Received != null)
                        {
                            this.PFL_Received(is_pfl);
                        }
                        return;
                    }
                case Enums.Packets.ISP_FIN:
                    {
                        LFS_External.Packets.IS_FIN is_fin = new LFS_External.Packets.IS_FIN();
                        is_fin = (LFS_External.Packets.IS_FIN)Util.DataToPacket(packet, is_fin);
                        if (this.FIN_Received != null)
                        {
                            this.FIN_Received(is_fin);
                        }
                        return;
                    }
                case Enums.Packets.ISP_RES:
                    {
                        LFS_External.Packets.IS_RES is_res = new LFS_External.Packets.IS_RES();
                        is_res = (LFS_External.Packets.IS_RES)Util.DataToPacket(packet, is_res);
                        if (this.RES_Received != null)
                        {
                            this.RES_Received(is_res);
                        }
                        return;
                    }
                case Enums.Packets.ISP_REO:
                    {
                        LFS_External.Packets.IS_REO is_reo = new LFS_External.Packets.IS_REO();
                        is_reo = (LFS_External.Packets.IS_REO)Util.DataToPacket(packet, is_reo);
                        if (this.REO_Received != null)
                        {
                            this.REO_Received(is_reo);
                        }
                        return;
                    }
                case Enums.Packets.ISP_NLP:
                    {
                        LFS_External.Packets.IS_NLP is_nlp = new LFS_External.Packets.IS_NLP();
                        is_nlp = (LFS_External.Packets.IS_NLP)Util.DataToPacket(packet, is_nlp);
                        if (this.NLP_Received != null)
                        {
                            this.NLP_Received(is_nlp);
                        }
                        return;
                    }
                case Enums.Packets.ISP_MCI:
                    {
                        LFS_External.Packets.IS_MCI is_mci = new LFS_External.Packets.IS_MCI();
                        is_mci = (LFS_External.Packets.IS_MCI)Util.DataToPacket(packet, is_mci);
                        if (this.MCI_Received != null)
                        {
                            this.MCI_Received(is_mci);
                        }
                        return;
                    }
                case Enums.Packets.ISP_CRS:
                    {
                        LFS_External.Packets.IS_CRS is_crs = new LFS_External.Packets.IS_CRS();
                        is_crs = (LFS_External.Packets.IS_CRS)Util.DataToPacket(packet, is_crs);
                        if (this.CRS_Received != null)
                        {
                            this.CRS_Received(is_crs);
                        }
                        return;
                    }
                case Enums.Packets.ISP_BFN:
                    {
                        LFS_External.Packets.IS_BFN is_bfn = new LFS_External.Packets.IS_BFN();
                        is_bfn = (LFS_External.Packets.IS_BFN)Util.DataToPacket(packet, is_bfn);
                        if (this.BFN_Received != null)
                        {
                            this.BFN_Received(is_bfn);
                        }
                        return;
                    }
                case Enums.Packets.ISP_AXI:
                    {
                        LFS_External.Packets.IS_AXI is_axi = new LFS_External.Packets.IS_AXI();
                        is_axi = (LFS_External.Packets.IS_AXI)Util.DataToPacket(packet, is_axi);
                        if (this.AXI_Received != null)
                        {
                            this.AXI_Received(is_axi);
                        }
                        return;
                    }
                case Enums.Packets.ISP_AXO:
                    {
                        LFS_External.Packets.IS_AXO is_axo = new LFS_External.Packets.IS_AXO();
                        is_axo = (LFS_External.Packets.IS_AXO)Util.DataToPacket(packet, is_axo);
                        if (this.AXO_Received != null)
                        {
                            this.AXO_Received(is_axo);
                        }
                        return;
                    }
                case Enums.Packets.ISP_BTC:
                    {
                        LFS_External.Packets.IS_BTC is_btc = new LFS_External.Packets.IS_BTC();
                        is_btc = (LFS_External.Packets.IS_BTC)Util.DataToPacket(packet, is_btc);
                        if (this.BTC_Received != null)
                        {
                            this.BTC_Received(is_btc);
                        }
                        return;
                    }
                case Enums.Packets.ISP_BTT:
                    {
                        LFS_External.Packets.IS_BTT is_btt = new LFS_External.Packets.IS_BTT();
                        is_btt = (LFS_External.Packets.IS_BTT)Util.DataToPacket(packet, is_btt);
                        if (this.BTT_Received != null)
                        {
                            this.BTT_Received(is_btt);
                        }
                        return;
                    }
                case Enums.Packets.ISP_CON:
                    {
                        LFS_External.Packets.IS_CON is_con = new LFS_External.Packets.IS_CON();
                        is_con = (LFS_External.Packets.IS_CON)Util.DataToPacket(packet, is_con);
                        if (this.CON_Received != null)
                        {
                            this.CON_Received(is_con);
                        }
                        return;
                    }
                default:
                    Debug.WriteLine("Received unknown TCP packet: " + ((Enums.Packets)packet[1]).ToString());
                    return;
            }
            Debug.WriteLine("Received unknown TINY packet: " + ((Enums.Tiny)packet[3]).ToString());
        }

        public void Request_AXI_AutocrossLayoutInfo()
        {
            this.Request_AXI_AutocrossLayoutInfo(1);
        }

        public void Request_AXI_AutocrossLayoutInfo(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_AXI, RequestId));
        }

        public void Request_CCP_CameraPosition()
        {
            this.Request_CCP_CameraPosition(1);
        }

        public void Request_CCP_CameraPosition(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_SCP, RequestId));
        }

        public void Request_ISM_MutliplayerInfo()
        {
            this.Request_ISM_MutliplayerInfo(1);
        }

        public void Request_ISM_MutliplayerInfo(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_ISM, RequestId));
        }

        public void Request_MCI_MCIPacket()
        {
            this.Request_MCI_MCIPacket(1);
        }

        public void Request_MCI_MCIPacket(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_MCI, RequestId));
        }

        public void Request_NCN_AllConnections()
        {
            this.Request_NCN_AllConnections(1);
        }

        public void Request_NCN_AllConnections(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_NCN, RequestId));
        }

        public void Request_NLP_NodeLapPacket()
        {
            this.Request_VER_InSimVersionInfo(1);
        }

        public void Request_NLP_NodeLapPacket(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_NLP, RequestId));
        }

        public void Request_NPL_AllPlayers()
        {
            this.Request_NPL_AllPlayers(1);
        }

        public void Request_NPL_AllPlayers(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_NPL, RequestId));
        }

        public void Request_Ping()
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_PING, 1));
        }

        public void Request_REO_RaceStartOrder()
        {
            this.Request_REO_RaceStartOrder(1);
        }

        public void Request_REO_RaceStartOrder(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_REO, RequestId));
        }

        public void Request_RES_AllResults()
        {
            this.Request_RES_AllResults(1);
        }

        public void Request_RES_AllResults(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_RES, RequestId));
        }

        public void Request_RST_RaceStart()
        {
            this.Request_RST_RaceStart(1);
        }

        public void Request_RST_RaceStart(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_RST, RequestId));
        }

        public void Request_RTP_RaceTime()
        {
            this.Request_RTP_RaceTime(1);
        }

        public void Request_RTP_RaceTime(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_GTH, RequestId));
        }

        public void Request_STA_State()
        {
            this.Request_STA_State(1);
        }

        public void Request_STA_State(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_SST, RequestId));
        }

        public void Request_VER_InSimVersionInfo()
        {
            this.Request_VER_InSimVersionInfo(1);
        }

        public void Request_VER_InSimVersionInfo(byte RequestId)
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_VER, RequestId));
        }

        private void Send(byte[] Packet)
        {
            if (this._state == InSimState.Connected)
            {
                this.Stream.Write(Packet, 0, Packet.Length);
            }
        }

        public void Send_BFN_DeleteButton(Enums.BtnFunc Type, byte ClickID, byte UniqueID)
        {
            this.Send(MakePacket.ISP_BFN(Type, ClickID, UniqueID));
        }

        public void Send_BTN_CreateButton(string ButtonText, LFS_External.InSim.Flags.ButtonStyles Style, byte Height, byte Width, byte Top, byte Left, byte ClickID, byte UniqueID, byte RequestID, bool AlwaysVisible)
        {
            this.Send(MakePacket.ISP_BTN(ButtonText, Style, Height, Width, Top, Left, ClickID, UniqueID, RequestID, AlwaysVisible));
        }

        public void Send_BTN_CreateButton(string ButtonText, string DialogCaption, LFS_External.InSim.Flags.ButtonStyles Style, byte Height, byte Width, byte Top, byte Left, byte TypeIn, byte ClickID, byte UniqueID, byte RequestID, bool AlwaysVisible)
        {
            this.Send(MakePacket.ISP_BTN(ButtonText, DialogCaption, Style, Height, Width, Top, Left, TypeIn, ClickID, UniqueID, RequestID, AlwaysVisible));
        }

        public void Send_CPP_CameraPosition(int X, int Y, int Z, ushort H, ushort P, ushort R, byte PlayerID, byte InGameCam, float FOV, ushort Time, LFS_External.InSim.Flags.StateFlags Flags)
        {
            this.Send(MakePacket.ISP_CPP(X, Y, Z, H, P, R, PlayerID, InGameCam, FOV, Time, Flags));
        }

        public void Send_MOD_ScreenMode(int Bits16, int RefreshRate, int Width, int Height)
        {
            this.Send(MakePacket.ISP_MOD(Bits16, RefreshRate, Width, Height));
        }

        public void Send_MSL_LocalMessage(string Message, Enums.MSL_Sound Sound)
        {
            this.Send(MakePacket.ISP_MSL(Message, Sound));
        }

        public void Send_MST_Message(string Message)
        {
            this.Send(MakePacket.ISP_MST(Message));
        }

        public void Send_MSX_ExtendedMessage(string Message)
        {
            this.Send(MakePacket.ISP_MSX(Message));
        }

        public void Send_MTC_MessageToConnection(string Message, byte UniqueID, byte PlayerID)
        {
            this.Send(MakePacket.ISP_MTC(Message, UniqueID, PlayerID, Enums.MSL_Sound.SND_SILENT));
        }

        public void Send_MTC_MessageToConnection(string Message, byte UniqueID, byte PlayerID, Enums.MSL_Sound Sound)
        {
            this.Send(MakePacket.ISP_MTC(Message, UniqueID, PlayerID, Sound));
        }

        public void Send_SCC_SetCarCamera(byte PlayerID, byte InGameCamera)
        {
            this.Send(MakePacket.ISP_SCC(PlayerID, InGameCamera));
        }

        public void Send_SCH_SingleCharacter(char Char, LFS_External.InSim.Flags.SCHFlags Flags)
        {
            this.Send(MakePacket.ISP_SCH(Char, Flags));
        }

        public void Send_SFP_StateFlags(LFS_External.InSim.Flags.StateFlags Flags, byte OffOn)
        {
            this.Send(MakePacket.ISP_SFP(Flags, OffOn));
        }

        public void Send_SMALL(Enums.Small Type, byte ReqI, uint Value)
        {
            this.Send(MakePacket.ISP_SMALL(Type, ReqI, Value));
        }

        public void Send_TINY(Enums.Tiny type)
        {
            this.Send(MakePacket.ISP_TINY(type, 1));
        }

        public void Send_TINY(Enums.Tiny type, byte RequestID)
        {
            this.Send(MakePacket.ISP_TINY(type, RequestID));
        }

        public void Send_VTC_CancelVote()
        {
            this.Send(MakePacket.ISP_TINY(Enums.Tiny.TINY_VTC, 0));
        }

        private void TCP_PacketReceived(byte[] data)
        {
            this.ParsePacket(data, Enums.Protocol.TCP);
        }

        private void UDP_PacketReceived(byte[] data)
        {
            this.ParsePacket(data, Enums.Protocol.UDP);
        }

        public string Name
        {
            get
            {
                return this._name;
            }
            set
            {
                this._name = value;
            }
        }

        public InSimState State
        {
            get
            {
                return this._state;
            }
        }

        public delegate void AXC_EventHandler();

        public delegate void AXI_EventHandler(LFS_External.Packets.IS_AXI AXI);

        public delegate void AXO_EventHandler(LFS_External.Packets.IS_AXO AXO);

        public delegate void BFN_EventHandler(LFS_External.Packets.IS_BFN BFN);

        public delegate void BTC_EventHandler(LFS_External.Packets.IS_BTC BTC);

        public delegate void BTT_EventHandler(LFS_External.Packets.IS_BTT BTT);

        public delegate void CCH_EventHandler(LFS_External.Packets.IS_CCH CCH);

        public delegate void CLR_EventHandler();

        public delegate void CNL_EventHandler(LFS_External.Packets.IS_CNL CNL);

        public delegate void ConnectionLost_EventHandler();

        public delegate void CPP_EventHandler(LFS_External.Packets.IS_CPP CPP);

        public delegate void CPR_EventHandler(LFS_External.Packets.IS_CPR CPR);

        public delegate void CRS_EventHandler(LFS_External.Packets.IS_CRS CRS);

        public delegate void FIN_EventHandler(LFS_External.Packets.IS_FIN FIN);

        public delegate void FLG_EventHandler(LFS_External.Packets.IS_FLG FLG);

        public delegate void III_EventHandler(LFS_External.Packets.IS_III III);

        private enum InSimExceptions : byte
        {
            BadAdminPassword = 1,
            None = 0
        }

        public enum InSimState
        {
            Disconnected,
            Connected,
            LostConnection
        }

        public delegate void ISM_EventHandler(LFS_External.Packets.IS_ISM ISM);

        public delegate void LAP_EventHandler(LFS_External.Packets.IS_LAP LAP);

        public delegate void MCI_EventHandler(LFS_External.Packets.IS_MCI MCI);

        public delegate void MPE_EventHandler();

        public delegate void MSO_EventHandler(LFS_External.Packets.IS_MSO MSO);

        public delegate void NCN_EventHandler(LFS_External.Packets.IS_NCN NCN);

        public delegate void NLP_EventHandler(LFS_External.Packets.IS_NLP NLP);

        public delegate void NPL_EventHandler(LFS_External.Packets.IS_NPL NPL);

        public delegate void PEN_EventHandler(LFS_External.Packets.IS_PEN PEN);

        public delegate void PFL_EventHandler(LFS_External.Packets.IS_PFL PFL);

        public delegate void PIT_EventHandler(LFS_External.Packets.IS_PIT PIT);

        public delegate void PLA_EventHandler(LFS_External.Packets.IS_PLA PLA);

        public delegate void PLL_EventHandler(LFS_External.Packets.IS_PLL PLL);

        public delegate void PLP_EventHandler(LFS_External.Packets.IS_PLP PLP);

        public delegate void PSF_EventHandler(LFS_External.Packets.IS_PSF PSF);

        public delegate void Reconnected_EventHandler();

        public delegate void REN_EventHandler();

        public delegate void REO_EventHandler(LFS_External.Packets.IS_REO REO);

        public delegate void REPLY_EventHandler();

        public delegate void RES_EventHandler(LFS_External.Packets.IS_RES RES);

        public delegate void RST_EventHandler(LFS_External.Packets.IS_RST RST);

        public delegate void RTP_EventHandler(uint RaceTime);

        public delegate void SPX_EventHandler(LFS_External.Packets.IS_SPX SPX);

        public delegate void STA_EventHandler(LFS_External.Packets.IS_STA STA);

        public delegate void TOC_EventHandler(LFS_External.Packets.IS_TOC TOC);

        public delegate void VER_EventHandler(LFS_External.Packets.IS_VER VER);

        public delegate void VTA_EventHandler(byte Action);

        public delegate void VTC_EventHandler();

        public delegate void VTN_EventHandler(LFS_External.Packets.IS_VTN VTN);

        public delegate void CON_EventHandler(LFS_External.Packets.IS_CON CON);
    }
}

