#include "outgaugeClient.h"

#define OGPACK_SIZE 96

WSADATA wsaData;
SOCKET ogSock;

HANDLE rpmMutex;
HANDLE recvMutex;

BOOL receiveData = true;
FLOAT rpm;

typedef unsigned char byte;
typedef unsigned short word;

// Custom InSim specific database types
typedef struct NodeLap NodeLap;
typedef struct CompCar CompCar;
typedef struct
{
    int x;
    int y;
    int z;
} Vec;
typedef struct
{
    float x;
    float y;
    float z;
} Vector;

#include "insim.h"

HRESULT InitializeConnection()
{
	//Initialize WinSock
	if(WSAStartup(MAKEWORD(2,2), &wsaData) != 0)
	{
		MessageBox(NULL, L"Could not initialize WinSock", L"OutGauge Error", MB_ICONERROR | MB_OK);
		WSACleanup();
		return E_FAIL;
	}

	//Create UDP socket
	ogSock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if(ogSock == INVALID_SOCKET)
	{
		MessageBox(NULL, L"Could not create socket", L"OutGauge Error", MB_ICONERROR | MB_OK);
		WSACleanup();
		return E_FAIL;
	}

	//Bind socket
	sockaddr_in saddr;
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = inet_addr("127.0.0.1");
	saddr.sin_port = htons(30000);
	if(bind(ogSock, (sockaddr*)&saddr, sizeof(sockaddr)) == SOCKET_ERROR)
	{
		MessageBox(NULL, L"Could not bind socket", L"OutGauge Error", MB_ICONERROR | MB_OK);
		closesocket(ogSock);
		WSACleanup();
		return E_FAIL;
	}

	//Initialize mutex
	rpmMutex = CreateMutex(NULL, FALSE, NULL);
	recvMutex = CreateMutex(NULL, FALSE, NULL);

	return S_OK;
}

DWORD WINAPI ReceivePackets(LPVOID lpArg)
{
	CHAR recvBuf[512];
	ZeroMemory(recvBuf, sizeof(recvBuf));
	INT recvd = 0;
	
	while(true)
	{
		recvd = recv(ogSock, recvBuf, 512, 0);
		if(recvd > 0)
		{
			//Got data, process it
			ProcessPacket(recvBuf);
		}
		else if(recvd == 0)
		{
			MessageBox(NULL, L"Lost connection with LFS", L"OutGauge Error", MB_ICONERROR | MB_OK);
			closesocket(ogSock);
			return -1;
		}
		else
		{
			MessageBox(NULL, L"Error when receiving OutGauge packets", L"OutGauge Error", MB_ICONERROR | MB_OK);
			closesocket(ogSock);
			return -1;
		}

		DWORD waitResult = WaitForSingleObject(recvMutex, INFINITE);
		if(waitResult == WAIT_OBJECT_0)
		{
			if(!receiveData)
			{
				break;
			}
		}
		ReleaseMutex(recvMutex);
	}

	closesocket(ogSock);
	WSACleanup();
}

VOID ProcessPacket(CHAR* buffer)
{
	OutGaugePack* pack = (OutGaugePack*)buffer;
	
	DWORD waitResult = WaitForSingleObject(rpmMutex, INFINITE);
	if(waitResult == WAIT_OBJECT_0)
	{
		rpm = pack->RPM;
	}
	ReleaseMutex(rpmMutex);
}

FLOAT GetRPM(VOID)
{
	FLOAT retVal = 1;
	DWORD waitResult = WaitForSingleObject(rpmMutex, INFINITE);
	if(waitResult == WAIT_OBJECT_0)
	{
		retVal = rpm;
		ReleaseMutex(rpmMutex);
		return retVal;
	}
	return retVal;	//Should never happen
}

VOID CloseConnection(VOID)
{
	DWORD waitResult = WaitForSingleObject(recvMutex, INFINITE);
	if(waitResult == WAIT_OBJECT_0)
	{
		if(!receiveData)
		{
			receiveData = false;
		}
	}
	ReleaseMutex(recvMutex);
}