#include "outgaugeClient.h"
#include "wheelInterface.h"
#include <windows.h>

WNDCLASSEX wcx;
HWND hEdit;
MSG msg;
LPWSTR g_szClassName = L"TESTLEDS";

HANDLE hPollThread;
HANDLE hOGThread;

DWORD idPollThread;
DWORD idOGThread;

LRESULT CALLBACK WndProc(HWND _hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_CREATE:
			{	
				HFONT hfDefault;

				hEdit = CreateWindowEx(WS_EX_CLIENTEDGE, L"EDIT", L"", 
									   WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL | ES_MULTILINE | ES_AUTOVSCROLL | ES_AUTOHSCROLL, 
									   0, 0, 584, 240, _hWnd, (HMENU)IDC_NO, GetModuleHandle(NULL), NULL);
				if(hEdit == NULL)
				{
					MessageBox(_hWnd, L"Could not create edit box.", L"Error", MB_OK | MB_ICONERROR);
				}

				hfDefault = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
				SendMessage(hEdit, WM_SETFONT, (WPARAM)hfDefault, MAKELPARAM(FALSE, 0));
			}
			break;
		case WM_CLOSE:
			DestroyWindow(_hWnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(_hWnd, msg, wParam, lParam);
			break;
	}

	return S_OK;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	HWND hWnd;

	//Register window class
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = 0;
	wcx.lpfnWndProc = WndProc;
	wcx.cbClsExtra = 0;
	wcx.cbWndExtra = 0;
	wcx.hInstance = hInstance;
	wcx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wcx.lpszMenuName = NULL;
	wcx.lpszClassName = g_szClassName;
	wcx.hIconSm = LoadIcon(NULL, IDI_APPLICATION);

    if(!RegisterClassEx(&wcx))
	{
		//Error registering window class, tell user and exit
		MessageBox(NULL, L"Cannot register window class.", L"Error", MB_ICONERROR | MB_OK);
		return E_FAIL;
	}

	//Create the window
	hWnd = CreateWindowEx(WS_EX_CLIENTEDGE, g_szClassName, L"LedsTest", WS_OVERLAPPEDWINDOW,
		                  CW_USEDEFAULT, CW_USEDEFAULT, 600, 272, NULL, NULL, hInstance, NULL);

	if(hWnd == NULL)
	{
		//Error creating window, tell user and exit
		MessageBox(NULL, L"Cannot create window.", L"Error", MB_ICONERROR | MB_OK);
		return E_FAIL;
	}

	//Display window
	ShowWindow(hWnd, nShowCmd);
	UpdateWindow(hWnd);

	//Initialize DirectInput.
	HRESULT hr = InitializeDI(hWnd);
	if(FAILED(hr))
	{
		return E_FAIL;
	}

	InitializeConnection();

	//Start a new thread to poll the device
	hPollThread = CreateThread(NULL, 0, ContPolling, hEdit, NULL, &idPollThread);
	hOGThread = CreateThread(NULL, 0, ReceivePackets, NULL, NULL, &idOGThread);
	//Go into message loop
	while(GetMessage(&msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	//Stop polling and relase the device
	TerminatePolling();
	UnacquireDevice();
	CloseConnection();

	return msg.wParam;
}