<?php

	function generateDriverString ($team)
	{
		$driversInRace = array();
				
		$q = 0;
		foreach ($team['driver_lfs'] as $driver_lfs)
		{
			if ($team['driver_active'][$q])
				$driversInRace[] = $driver_lfs;
			$q++;
		}
		//print implode ("' OR lfsworld='", $driversInRace) . "'";
		return "lfsworld='" . implode ("' OR lfsworld='", $driversInRace) . "'";
	}
	function print_array($l)
	{
		foreach ($l as $i => $lap)
			print $i . " " . $lap['lap'] . " " . $lap['laptime'] . "<br>";
	}
	function inTeam ($string, $num)
	{	
		$pieces = explode (" - ", $string);
		return (substr($pitstop_value['value'], 0, 3) == addzeros($num) || intval ($pieces[0]) == $num);
	}

	function filterLaps ($laparray)
	{
		$j = 0;
		$lapblocks = array();
		
		//print "<table><tr>";
		
		while ($j < count($laparray))
		{
			if ($laparray[$j]['driverUserName'] == $laparray[$j+1]['driverUserName']
						&& $laparray[$j]['laptime'] == $laparray[$j+1]['laptime']
							&& ($laparray[$j+1]['logged'] - $laparray[$j]['logged']) < 20)
				{
					$laparray = deleteFromArray ($laparray, ($j +1));
					$j = 0;
				}
				else
					$j++;
		}
		$j=0;
		while ($j < count($laparray))
		{
			//ob_start();
			
			if ($laparray[$j]['lap'] == 0 && is_array($laparray[$j+1]))
				$laparray[$j]['lap'] = $laparray[$j+1]['lap'] -1;
				
			if ($laparray[$j]['lap'] == ($laparray[$j+1]['lap'] - 1))
			{
				$j++;
			}
			else
			{
				if ($laparray[$j]['lap'] == ($laparray[$j+2]['lap'] - 1))
				{
					//print $laparray[$j]['lap'] . " == " .  ($laparray[$j+2]['lap'] - 1) . "<br>";
					//print "deleting key " . ($j +1) . " from laparray." . "<br>";
					$laparray = deleteFromArray ($laparray, ($j +1));
					//print "</td><td width=150 valign=top>";
					//print_array ($laparray);
					//print "</td>";
					//die;
				}
				else if ($laparray[$j]['lap'] == ($laparray[$j+1]['lap'] - 2))
				{
					//print $laparray[$j]['lap'] . " == " . ($laparray[$j+1]['lap'] - 2) . "<br>";
					//print "adding value " . ($laparray[$j]['lap']+1) . " after key ". $j . " to laparray." . "<br>";
					$laparray = addToArray ($laparray, $j, $laparray[$j]['lap']+1);
					//print "</td><td width=150 valign=top>";
					//print_array ($laparray);
					//print "</td>";
					//die;
				}
				else if ($laparray[$j]['lap'] == ($laparray[$j+2]['lap'] - 2))
				{
					//print $laparray[$j]['lap'] . " == " . ($laparray[$j+2]['lap'] - 2) . "<br>";
					//print "changing key " . ($j +1) . " into " . ($laparray[$j]['lap']+1) . "<br>";
					$laparray = changeInArray ($laparray, ($j +1), $laparray[$j]['lap']+1);
					//print "</td><td width=150 valign=top>";
					//print_array ($laparray);
					//print "</td>";
					//die;
				}
				else
				// close current block and start new one
				{
					//print "cutting after " . $j . "<br>";
					
					$lapblocks[] = getFromArray ($laparray, $j);
					//print "</td><td width=150 valign=top>";
					//print_array (getFromArray ($laparray, $j));
					//print "</td>";
					
					$laparray = deleteFromArrayUntil ($laparray, $j);
					//print "</td><td width=150 valign=top>";
					//print_array ($laparray);
					//print "</td>";
					$j = 0;
					//die;
				}
				//print "</td>";
			}
			
		}
		
		//ob_clean();

		$lapblocks[] = $laparray;
		
		//print "now here...";
		//die;

		$filteredLapArray = array();
		//print_r ($lapblocks);
		
		$lap = 0;
		$r = 1;
		
		foreach ($lapblocks as $lapblock)
		{
			for ($i=0; $i < count($lapblock); $i++)
			{
				$filteredLapArray[$lap] = $lapblock[$i];
				$lap++;
			}
		}
		return $filteredLapArray;
	}
	
	function deleteFromArray ($a, $d)
	// delete key $d from array $a
	{
		$r = array();

		for ($i=0; $i < $d; $i++)
		{
			$r[$i]['lap'] = $a[$i]['lap'];
			$r[$i]['laptime'] = $a[$i]['laptime'];
			$r[$i]['driverUserName'] = $a[$i]['driverUserName'];
			$r[$i]['logged'] = $a[$i]['logged'];
			$r[$i]['mysqlid'] = $a[$i]['mysqlid'];
		}

		for ($i=($d+1); $i < count($a); $i++)
		{
			$r[$i-1]['lap'] = $a[$i]['lap'];
			$r[$i-1]['laptime'] = $a[$i]['laptime'];
			$r[$i-1]['driverUserName'] = $a[$i]['driverUserName'];
			$r[$i-1]['logged'] = $a[$i]['logged'];
			$r[$i-1]['mysqlid'] = $a[$i]['mysqlid'];
		}

		return $r;
	}

	function changeInArray ($a, $c, $v)
	{
		$a[$c]['lap'] = $v;
		return $a;
	}

	function addToArray ($a, $d, $v)
	// $a = array, $d = place value $v AT key $d, and move down from $d+1
	{
		$r = array();

		for ($i=0; $i <= $d; $i++)
		{
			$r[$i]['lap'] = $a[$i]['lap'];
			$r[$i]['laptime'] = $a[$i]['laptime'];
			$r[$i]['driverUserName'] = $a[$i]['driverUserName'];
			$r[$i]['logged'] = $a[$i]['logged'];
			$r[$i]['mysqlid'] = $a[$i]['mysqlid'];
		}

		$r[$i]['lap'] = $v;
		$r[$i]['laptime'] = 0;
		if ($r[$i-1]['driverUserName'] != "")
		{
			$r[$i]['laptime'] = $r[$i-1]['laptime'];
			$r[$i]['driverUserName'] = $r[$i-1]['driverUserName'];
			$r[$i]['logged'] = $r[$i-1]['logged'];
			$r[$i]['mysqlid'] = $r[$i-1]['mysqlid'] + 1;
		}
		else
		{
			$r[$i]['driverUserName'] = "";
			$r[$i]['logged'] = -1;
		}

		for ($i; $i < count($a); $i++)
		{
			$r[$i+1]['lap'] = $a[$i]['lap'];
			$r[$i+1]['laptime'] = $a[$i]['laptime'];
			$r[$i+1]['driverUserName'] = $a[$i]['driverUserName'];
			$r[$i+1]['logged'] = $a[$i]['logged'];
			$r[$i+1]['mysqlid'] = $a[$i]['mysqlid'];
		}
		return $r;
	}

	function getFromArray ($a, $u)
	// get the part of array $a until and including key $u
	{
		$r = array();

		for ($i=0; $i <= $u; $i++)
		{
			$r[$i]['lap'] = $a[$i]['lap'];
			$r[$i]['laptime'] = $a[$i]['laptime'];
			$r[$i]['driverUserName'] = $a[$i]['driverUserName'];
			$r[$i]['logged'] = $a[$i]['logged'];
			$r[$i]['mysqlid'] = $a[$i]['mysqlid'];
		}

		return $r;
	}

	function deleteFromArrayUntil ($a, $u)
	//delete the first part of an array until and including the key $u
	{
		$r = array();

		for ($i=($u+1); $i < count($a); $i++)
		{
			$r[$i-($u+1)]['lap'] = $a[$i]['lap'];                      
			$r[$i-($u+1)]['laptime'] = $a[$i]['laptime'];              
			$r[$i-($u+1)]['driverUserName'] = $a[$i]['driverUserName'];
			$r[$i-($u+1)]['logged'] = $a[$i]['logged'];
			$r[$i-($u+1)]['mysqlid'] = $a[$i]['mysqlid'];
		}
		return $r;
	}

	function print_html_r( $aData )
	{
		echo nl2br( eregi_replace( " ", " ", print_r( $data, TRUE ) ) );
	}

	function addzeros ($i)
	{
		if (strlen ($i) == 1)
			return "0".$i;
		else
			return $i;
	}
	function totalTime ($laps, $rs, $untilLap=99999)
	{
		$alt = ($laps[min((count($laps)-1), $untilLap)]['logged'] - $rs)*100;
		
		return $alt;
	}
	function countLaps ($laps)
	{
	    
	    $return = 0;
	    $last = 0;
		foreach ($laps as $lap) {
		    if ($last<=$lap['lap']) {
			$last=$lap['lap'];
		    }
		    else {
			$return += $last;
			$last = $lap['lap'];
		    }
		}
	    return $return + $last;
		//return count ($laps);
	}
	function getTeam ($name, $prefix=true)
	{
		$best_match = "";

		if ($prefix == true)
		{
			$bits = explode(" - ", $name);
			$bats = explode("-", $bits[0]);
			$number = trim($bats[0], "\0");

			foreach ($TEAMS as $k => $team)
			{
				if ($team['number'] == $number)
				{
					$best_match = $TEAMS[$k]['team_name'];
					$h = 100;
				}
			}
		}

		if ($prefix == false || $best_match == "")
		{
			$strpercent = 0;
			$h = -1;
			$match = array();

			global $TEAMS;

			foreach ($TEAMS as $k => $team)
			{
				foreach ($team['driver_real'] as $l => $array_name)
				{

					similar_text(trim($name), trim($array_name), $strpercent);

					if ($strpercent > $h)
					{
						$best_match = $TEAMS[$k]['team_name'];
						$h = $strpercent;
					}
				}

				foreach ($team['driver_lfs'] as $l => $array_name)
				{

					similar_text(trim($name), trim($array_name), $strpercent);

					if ($strpercent > $h)
					{
						$best_match = $TEAMS[$k]['team_name'];
						$h = $strpercent;
					}
				}
			}
		}

		$return['match'] = $best_match;
		$return['prc'] = $h;
		return $return;
	}


	function getInfo ($string)
	{
		$b = explode (" ", $string);

		$match = 0;

		for ($i=0; $i < count($b); $i++)
		{
			if ($b[$i] == "antwortet" || $b[$i] == "nimmt" || $b[$i] == "verlsst" || $b[$i] == "geht")
			{
				$match = $i;
			}
		}

		$tname = "";
		$error = $b[$match];

		while ($match > 0)
		{
			$tname = $b[$match-1] . " " . $tname;
			$match--;
		}

		$return['error'] = $error;
		$return['name'] = $tname;

		return $return;
	}

	function format_name ($n)
	{
		$bits = explode (" ", $n);
		$l = count ($bits);

		$initials = "";

		for ($g=0; $g < ($l - 1); $g++)
		{
			$initials .= substr($bits[$g], 0, 1) . ". ";
		}

		return $initials . $bits[$l-1];
	}

	function sort_standings ($a, $b)
	{
		if (($a['race_data']['laps']+$a['race_data']['penalty_laps']+$a['race_data']['correction_laps'])
					== ($b['race_data']['laps']+$b['race_data']['penalty_laps']+$b['race_data']['correction_laps']))
		{
			if ($a['race_data']['total_time'] < $b['race_data']['total_time'])
				return -1;
			else
				return 1;
		}
		else
		{
			if (($a['race_data']['laps']+$a['race_data']['penalty_laps']+$a['race_data']['correction_laps'])
					> ($b['race_data']['laps']+$b['race_data']['penalty_laps']+$b['race_data']['correction_laps']))
			{
				return -1;
			}
			else
			{
				return 1;
			}
		}
	}

	function normalTime ($time, $h=true)
	{

		$time = abs($time);

		if ($time == 0)
		{
			if ($h)
				$string = "0:00.00";
			else
				$string = "0:00";
		}
		else
		{
			$hour = floor ($time / (60 * 60 * 1000));
			$remain = $time % (60* 60 * 1000);
			
			$min = floor($remain / (60 * 1000));
			$remain = $time % (60 * 1000);
			$sec = floor ($remain / 1000);
			$hun = $remain % 1000;

			if (strlen($sec) == 1)
			{
				$sec = "0".$sec;
			}
			if (strlen($sec) == 0)
			{
				$sec = "00";
			}

			if (strlen($hun) == 2 ) {
				$hun = "0".$hun;
			}
			elseif (strlen($hun) == 1)
			{
				$hun = "00".$hun;
			}
			elseif (strlen($hun) == 0)
			{
				$hun = "000";
			}
			$string = 0;
			if ($hour > 0)
				$string = $hour . "h ";

			if ($h)
				$string = $string . $min . ":" . $sec . "." . $hun;
			else
				$string = $string . $min . ":" . $sec;
		}
		return $string;
	}

	function html_print_r($object, $returnValue = false)
	{
		$output = print_r($object, true);
		$output = htmlentities($output);
		$output = str_replace(" ", "&nbsp;", $output);
		$output = nl2br($output);

		if ($returnValue) {
			return $output;
		} else {
			//echo $output;
			return true;
		}
	}

	function writeToFile ($filename, $content)
	{
		if (!file_exists($filename))
		{
			if (!$handle = fopen($filename, 'w'))
			{
				echo "Cannot open file ($filename)";
				exit;
			}
			else
			{
				fclose($handle);
				chmod($filename, 06666);
			}
		}
		
		if (!$handle = fopen($filename, 'w'))
		{
			echo "Cannot open file ($filename)";
			exit;
		}
		
			
		if (is_writable($filename))
		{
			if (fwrite($handle, $content) === FALSE)
			{
				echo "Cannot write to file ($filename)";
				exit;
			} 
			
			//print "File written : " . $filename . "<br>";
			flush();
	   
			fclose($handle);
	
		}
		else
		{
			if (chmod($filename, 0666))
				writeToFile ($filename, $content);
		}
	}

?>