// --------------------
// Simon Willison - http://www.sitepoint.com/blog-post-view.php?id=171578
// --------------------
function addLoadEvent(func) 
{
	var oldonload = window.onload;
	if (typeof window.onload != 'function') 
		window.onload = func;
	else 
		window.onload = function() { oldonload(); func(); }
}

// --------------------
// Jeroen Mulder - http://www.jeroenmulder.com
// --------------------
function initCollapse ()
{
	if (!document.getElementsByTagName) return;
	
	// Suffix to identify matched element
	var suffix = '-collapse';
	
	// Class name to enable/disable collapsing behaviour
	var className = 'collapsable';
	
	var collapsables = new Array();
	var anchors = document.getElementsByTagName('a');
	
	for (var i = 0; i < anchors.length; i++)
	{
		var a = anchors[i];
		
		if (a.className == className)
		{
			collapsables[collapsables.length] = a;

			var collapsableObj = document.getElementById(a.id + suffix);
			collapsableObj.style.display = 'none';
			
			a.onclick = function e () { collapse(this); }
		}
	}
	
	function collapse (obj)
	{
		/*for (var j = 0; j < collapsables.length; j++)
		{
			if (collapsables[j] != obj)
			{
				var collapsableObj = document.getElementById(collapsables[j].id + suffix);
				collapsableObj.style.display = 'none';
			}
		}
		*/
		obj = document.getElementById(obj.id + suffix);
		obj.style.display = (obj.style.display == 'none') ? '' : 'none';
	}
}
addLoadEvent(initCollapse);