#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################
# This 'Newbie' addon by Sinanju using almost all Krayy's coding

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!noob":
		CASE "!newb":
			DoCifHelpNewbie(0, "gui_help_header_Newbie");
			BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "Newbie", "1.01");
EndCatchEvent

Sub DoCifHelpNewbie ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="Newbie";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Specific Help for Newbies", "DoCifHelp");
	openPrivButton ( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
EndSub

Lang "EN" # Race Events messages
	gui_help_contents_Newbie = "^2Some useful LFS related websites:"
			. "%nl%^3www.lfs.net ^8 the main LFS website (probably where you downloaded the game)"
			. "%nl%^3www.lfsworld.net ^8 LFS 'desktop' where you can see hotlaps, put your skins, etc."
			. "%nl%^3www.lfsmanual.net ^8 LFS (tracks, cars, setting up car, etc) explained in detail"
			. "%nl%^3www.lfsforum.net ^8 Online discussion site for all LFS members"
			. "%nl%"
			. "%nl%^2Trouble finding your way round the different track combos?"
			. "%nl%^3Press^7 4^3 to see the ^7AI ^3race line"
			. "%nl%^2GREEN^3 line means full throttle, and ^1RED ^3line means brake"
			. "%nl%^3(Yellow and Amber lines means somewhere in between)"
			. "%nl%"
			. "%nl%^2Don't know what to do when someone sends their setup?"
			. "%nl%^3Press ^7N^3 a few times until the 'Connections' screen opens (bottom right)"
			. "%nl%^3If you've been sent a set, then the ^7SS^3 will be highlighted"
      . "%nl%^3Click on ^7SS^3 and you will be prompted to save as filename"
			. "%nl%(Probably best to save with track abbreviation at start (e.g. SO1_sent_setX)"
			. "%nl%(No need to put car name as LFS will put that in your set name automatically)"			
			. "%nl%"
			. "%nl%^2Can't accelerate when leaving pits?"			
      . "%nl%^3Remember to press the '^7L^3' (limiter) button"
    	. "%nl%"
			. "%nl%^2!noob ^8 or ^2!newb ^3This will open this help file";
EndLang
