#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################
# News addon by Sinanju using almost all Krayy's coding!


CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!news":
			DoCifInfoNews(0, "gui_info_header_News");
			BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Info", "News", "1.01");
EndCatchEvent

Sub DoCifInfoNews ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Info";
	$cifModuleName="News";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Server News", "DoCifInfo");
	openPrivButton ( $DialogPrefix . "news",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_info_contents_" . $cifModuleName . "}%") );
EndSub

Lang "EN" # News messages
	gui_info_contents_News = "^2This is where any News regarding this server will be posted"
	. "%nl%"
	. "%nl%^3There is no news at this time"
	. "%nl%"
	. "%nl%^3No news is good news!"	
	. "%nl%"
	. "%nl%^3If there were any news, this is where you might expect"	
	. "%nl%^3to read about that news, along with in-depth comment and"	
	. "%nl%^3analysis of that news as well as opinion pieces"
  . "%nl%"
  . "%nl%^3Typing ^2!news ^3will bring up this news module"
  . "%nl%"
	. "%nl%^2Thank you for looking at the news";
EndLang
