#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################
# Rules addon by Sinanju using almost all Krayy's coding!


CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!rules":
			DoCifInfoRules(0, "gui_info_header_Rules");
			BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Info", "Rules", "1.01");
EndCatchEvent

Sub DoCifInfoRules ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Info";
	$cifModuleName="Rules";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Server Rules", "DoCifInfo"); #
	openPrivButton ( $DialogPrefix . "rules",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_info_contents_" . $cifModuleName . "}%") );
EndSub

Lang "EN" # Race Events messages
	gui_info_contents_Rules = "^2 This server is wholly paid for by this team, who have total rights to ban / kick unsporting visitors"
	. "%nl%"
	. "%nl%^3 This team has the rights to make up any rules it wants"
	. "%nl%"
	. "%nl%^3 The first rule of this server is ^1the rules must be obeyed"
	. "%nl%"
	. "%nl%^3 The second rule of this server is ^1re-read the first rule"
	. "%nl%"
	. "%nl%^3 Failure to obey these rules could result in being kicked from this server"	
	. "%nl%"	
	. "%nl%^3 Failure to obey a serious rule will result in being banned from this server"	
	. "%nl%"	
	. "%nl%^3 You must obey the Blue and Yellow flags"
	. "%nl%^7 - ^4Blue ^7means that you must let leader(s) past unhindered"
	. "%nl%^7 - ^3Yellow ^7means that an accident has happened somewhere on the track in front,"
	. "%nl%^8. . ^7and you must be prepared to slow down or even stop"
	. "%nl%"
	. "%nl%^3 Please obey these simple rules so that all drivers may enjoy this server"
	. "%nl%"
	. "%nl%^2 Thank You";
EndLang
