/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Collections;
using System.Threading;
using System.IO;
using System.Net;
using System.Net.Cache;
using System.Reflection;



namespace LapperThreads
{
    public class webCmd
    {
        public int UCID;
        public string url;
        public webCmd(int UCID , string url )
        {
            this.UCID = UCID;
            this.url = url;
        }
    }
    public class webReturn
    {
        public int UCID;
        public string WebRet;
        public webReturn(int UCID , string webRet )
        {
            this.UCID = UCID;
            this.WebRet = webRet;
        }
    }
    public class WebCmds
    {
        public Queue QwebCmd = new Queue(100);
        public Queue QwebReturn = new Queue(100);

        public void TWebCmds()
        {
            Console.WriteLine("Web Commands Thread Started...");
            while (true)
            {
                Monitor.Enter(QwebCmd);
                if (QwebCmd.Count == 0)
                {
                    Monitor.Exit(QwebCmd);
                    System.Threading.Thread.Sleep(100);
                    continue;
                }
                webCmd cmd = (webCmd)QwebCmd.Dequeue();
                Monitor.Exit(QwebCmd);

                try
                {
                    string readLine = "";
                    WebRequest req = WebRequest.Create( cmd.url );
                    req.Timeout = (int)lexCfg.paramLapper.webTimeOut;

                    RequestCachePolicy policy = new RequestCachePolicy(RequestCacheLevel.NoCacheNoStore);
//                    req.CachePolicy = policy;
                    WebResponse result = req.GetResponse();
                    Stream receiveStream = result.GetResponseStream();
                    using (StreamReader sr = new StreamReader(receiveStream))
                    {
                        readLine = sr.ReadToEnd();
                        Monitor.Enter(QwebReturn);
                        QwebReturn.Enqueue(new webReturn(cmd.UCID, readLine));
                        Monitor.Exit(QwebReturn);

                    }
                }
                catch
                {
                    Console.WriteLine("Error on web command");
                }
            }
        }
        public void sendWebCmd(int UCID, string url)
        {
            Monitor.Enter(QwebCmd);
            QwebCmd.Enqueue(new webCmd( UCID, url ));
            Monitor.Exit(QwebCmd);
        }
        public webReturn getWebReturn()
        {
            Monitor.Enter(QwebReturn);
            if (QwebReturn.Count == 0)
            {
                Monitor.Exit(QwebReturn);
                return null;
            }
            webReturn retValue = (webReturn)QwebReturn.Dequeue();
            Monitor.Exit(QwebReturn);
            return retValue;            
        }
    }
}
