/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections;
using System.Threading;
using System.IO;
using LFSLapper;


namespace LapperThreads
{
    public class info
    {
        public string userName;
        public string nickName;
        public long PBLTime;
        public long[] PBSplit;
        public string PBDate;
        public string PBTime;
        public string CName;
        public int laps;
        public string trackName;
        public long[] PBBestSplitDiff;
        public long PBBestSplitDiffLast;
        public info()
        {
            this.PBSplit = new long[(int)lexCfg.paramLapper.maxSplit];
            this.PBBestSplitDiff = new long[(int)lexCfg.paramLapper.maxSplit];
        }
        public info(LFSLapper.infoPlayer currInfoPlayer, string trackName)
        {
            this.PBSplit = new long[(int)lexCfg.paramLapper.maxSplit];
            this.PBBestSplitDiff = new long[(int)lexCfg.paramLapper.maxSplit];
            this.userName = currInfoPlayer.userName;
            this.nickName = currInfoPlayer.nickName;
            this.PBLTime = currInfoPlayer.PBLTime;
            this.PBDate = currInfoPlayer.PBDate;
            this.PBTime = currInfoPlayer.PBTime;
            this.trackName = trackName;
            this.CName = currInfoPlayer.CName;
            this.laps = currInfoPlayer.laps;
            for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
            {
                this.PBSplit[i] = currInfoPlayer.PBSplit[i];
                this.PBBestSplitDiff[i] = currInfoPlayer.PBBestSplitDiff[i];
            }
            this.PBBestSplitDiffLast = currInfoPlayer.PBBestSplitDiffLast;

        }
        public info(info currPlayer)
        {
            this.PBSplit = new long[(int)lexCfg.paramLapper.maxSplit];
            this.PBBestSplitDiff = new long[(int)lexCfg.paramLapper.maxSplit];
            this.userName = currPlayer.userName;
            this.nickName = currPlayer.nickName;
            this.PBLTime = currPlayer.PBLTime;
            this.PBDate = currPlayer.PBDate;
            this.PBTime = currPlayer.PBTime;
            this.trackName = currPlayer.trackName;
            this.CName = currPlayer.CName;
            this.laps = currPlayer.laps;
            for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
            {
                this.PBSplit[i] = currPlayer.PBSplit[i];
                this.PBBestSplitDiff[i] = currPlayer.PBBestSplitDiff[i];
            }
            this.PBBestSplitDiffLast = currPlayer.PBBestSplitDiffLast;

        }
    }
    public class clSyncUploadDownload
    {
//        public System.Collections.ArrayList uploadInfo = new System.Collections.ArrayList();
        public Queue listInfoUpload = new Queue(100);
        public Queue listInfoDownload = new Queue(100);
        string SyncID = null;
        string SyncDir = null;
        string[] SyncIDsToSync;

        public clSyncUploadDownload( string SyncID, string SyncDir, string[] SyncIDsToSync )
        {
            this.SyncID = SyncID;
            this.SyncDir = SyncDir;
            this.SyncIDsToSync = SyncIDsToSync;
        }
        public void pushInfoToSync( LFSLapper.infoPlayer currInfoPlayer, string trackName  ){
            Monitor.Enter(listInfoUpload);
            listInfoUpload.Enqueue(new info(currInfoPlayer, trackName));
            Monitor.Exit(listInfoUpload);
        }
// Thread to dequeue info to send to another Lapper(s)
        public void SendInfoToSync()
        {
            info currPlayer;
            Console.WriteLine("Sync Upload DB Thread Started...");
            DateTime nextUploadFile = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.delayedSave);
            bool fileOpen = false;
            System.IO.StreamWriter sw = null ;
            string filename = "";
            while (true)
            {
                try
                {
                    Monitor.Enter(listInfoUpload);
                    if (listInfoUpload.Count != 0)
                    {
                        currPlayer = (info)listInfoUpload.Dequeue();
                        Monitor.Exit(listInfoUpload);
                        if (!fileOpen)
                        {
                            filename = "./" + "LFSDB"
                                    + string.Format("{0:0000}", System.DateTime.Now.Year)
                                    + string.Format("{0:00}", System.DateTime.Now.Month)
                                    + string.Format("{0:00}", System.DateTime.Now.Day)
                                    + string.Format("{0:00}", System.DateTime.Now.Hour)
                                    + string.Format("{0:00}", System.DateTime.Now.Minute)
                                    + string.Format("{0:00}", System.DateTime.Now.Second)
                                    + string.Format("{0:000}", System.DateTime.Now.Millisecond)
                                    + ".syc";
                            //                        Console.WriteLine("Open File : " + filename);
                            sw = new System.IO.StreamWriter(filename);
                            fileOpen = true;
                            nextUploadFile = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.UploadSync);
                        }
                        //                    Console.WriteLine("Add to file " + currPlayer.userName);
                        string uname = currPlayer.userName.Replace("|", "{more}");
                        string nname = currPlayer.nickName.Replace("|", "{more}");
                        sw.Write(uname + "|");
                        sw.Write(nname + "|");
                        sw.Write(currPlayer.laps.ToString() + "|");
                        sw.Write(currPlayer.PBDate + "|");
                        sw.Write(currPlayer.PBTime + "|");
                        sw.Write(currPlayer.CName + "|");
                        sw.Write(currPlayer.PBLTime.ToString() + "|");
                        sw.Write(currPlayer.trackName + "|");
                        sw.Write(currPlayer.PBSplit[0].ToString() + "|");
                        sw.Write(currPlayer.PBSplit[1].ToString() + "|");
                        sw.Write(currPlayer.PBSplit[2].ToString() + "|");
                        sw.Write(currPlayer.PBBestSplitDiff[0].ToString() + "|");
                        sw.Write(currPlayer.PBBestSplitDiff[1].ToString() + "|");
                        sw.Write(currPlayer.PBBestSplitDiff[2].ToString() + "|");
                        sw.Write(currPlayer.PBBestSplitDiffLast.ToString() + "\n");

                    }
                    else
                    {
                        Monitor.Exit(listInfoUpload);
                        System.Threading.Thread.Sleep(1000);
                    }
                }
                catch
                {
                    Monitor.Exit(listInfoUpload);
                    System.Threading.Thread.Sleep(1000);
                }
                if (DateTime.Now > nextUploadFile && fileOpen )
                {
//                    Console.WriteLine("Upload This File " + filename );
                    sw.Close();
                    fileOpen = false;
                    for (int i = 0; i < SyncIDsToSync.Length; i++)
                    {
                        if (SyncIDsToSync[i] != "")
                        {
                            string destPath = SyncDir + "/" 
                                                    + SyncIDsToSync[i] 
                                                    + "/"
                                                    + filename;
//                            Console.WriteLine("Copie de " + filename + " Vers " + destPath);
                            File.Copy(filename, destPath);
                        }
                    }
                    File.Delete(filename);
                    nextUploadFile = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.UploadSync);
                }
            }
        }
// Thread to Download info to another Lapper and enqueue it
        public void GetInfoToSync()
        {
            string pathSync = SyncDir + "/" + SyncID;
            info currPlayer = new info();
            Console.WriteLine("Sync Download DB Thread Started...");
            while (true)
            {
                string[] files = Directory.GetFiles(pathSync, "LFSDB*.syc");
                if (files.Length != 0)
                {
                    Array.Sort(files);
                    for (int i = 0; i < files.Length; i++)
                    {
                        string readLine;
                        try
                        {
                            using (System.IO.StreamReader sr = new System.IO.StreamReader(files[i]))
                            {
                                while (true)
                                {
                                    readLine = sr.ReadLine();
                                    if (readLine == null)
                                        break;
                                    string[] readLineSplit = readLine.Split('|');
                                    try
                                    {
                                        currPlayer.userName = readLineSplit[0].Replace("{more}", "|");
                                        currPlayer.nickName = readLineSplit[1].Replace("{more}", "|");
                                        currPlayer.laps = int.Parse(readLineSplit[2]);
                                        currPlayer.PBDate = readLineSplit[3];
                                        currPlayer.PBTime = readLineSplit[4];
                                        currPlayer.CName = readLineSplit[5];
                                        currPlayer.PBLTime = long.Parse(readLineSplit[6]);
                                        currPlayer.trackName = readLineSplit[7];
                                        currPlayer.PBSplit[0] = long.Parse(readLineSplit[8]);
                                        currPlayer.PBSplit[1] = long.Parse(readLineSplit[9]);
                                        currPlayer.PBSplit[2] = long.Parse(readLineSplit[10]);
                                        currPlayer.PBBestSplitDiff[0] = long.Parse(readLineSplit[11]);
                                        currPlayer.PBBestSplitDiff[1] = long.Parse(readLineSplit[12]);
                                        currPlayer.PBBestSplitDiff[2] = long.Parse(readLineSplit[13]);
                                        currPlayer.PBBestSplitDiffLast = long.Parse(readLineSplit[14]);
/*
                                        Console.Write(currPlayer.userName + " : ");
                                        Console.Write(currPlayer.PBLTime + " : ");
                                        Console.Write(currPlayer.PBBestSplitDiffLast + " : ");
                                        Console.WriteLine();
*/
                                        Monitor.Enter(listInfoDownload);
                                        listInfoDownload.Enqueue(new info(currPlayer));
                                        Monitor.Exit(listInfoDownload);

                                    }
                                    catch
                                    {
                                        Console.WriteLine("Receive Sync Line error : " + readLine);
                                    }
                                }
                            }
                            File.Delete(files[i]);
                        }
                        catch
                        {
                            Console.WriteLine("Can't Open Sync File, Maybe Locked by Writer : " + files[i]);
                        }
                    }
                }
                System.Threading.Thread.Sleep(5000);
            }
        }
        public bool popInfoToSync(LFS.Db lfsDb )
        {
            info currPlayer;
            bool newPB = false;
            try
            {
                for (int i = 0; i < 10; i++)
                {
                    Monitor.Enter(listInfoDownload);
                    if (listInfoDownload.Count != 0)
                    {
                        currPlayer = (info)listInfoDownload.Dequeue();
                        Monitor.Exit(listInfoDownload);
                        newPB = true;
                        lfsDb.updateRow(currPlayer.userName,
                                            currPlayer.nickName,
                                            currPlayer.laps,
                                            currPlayer.PBDate,
                                            currPlayer.PBTime,
                                            currPlayer.CName,
                                            currPlayer.PBLTime,
                                            currPlayer.trackName,
                                            currPlayer.PBSplit,
                                            currPlayer.PBBestSplitDiff,
                                            currPlayer.PBBestSplitDiffLast,
                                            true);
                    }
                    else
                        Monitor.Exit(listInfoDownload);
                }
            }
            catch
            {
                Monitor.Exit(listInfoDownload);
            }
            return newPB;
        }

    }
}
