/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Text.RegularExpressions;
using LFSLapper;


namespace lexCfg
{
    enum tokenExpr
    {
        notfound,
        and,
        or,
        equal,
        diff,
        moreThan,
        lessThan,
        moreThanEqual,
        lessThanEqual,
        concat,
        plus,
        minus,
        mult,
        div,
        pow,
        nbVal,
    }
    enum typVal
    {
        num,
        str,
        time,
        undef,
    }
    class unionVal
    {
        public float fval;
        public string sval;
        public typVal typVal;
        public unionVal( float pfval,string psval,typVal ptypval ){
            this.fval = pfval;
            this.sval = psval;
            this.typVal = ptypval;
        }
    }
    class Parseur
    {
        public Parseur expra;
        public Parseur exprb;
        public tokenExpr operateur;
        public unionVal val = new unionVal( 0,"",typVal.undef );

        public Parseur(string str)
        {


            this.expra = null;
            this.exprb = null;
            this.operateur = tokenExpr.notfound;

            str = str.Trim();
            if (str == "")
            {
                this.val.sval = "\"\"";
                this.val.typVal = typVal.str;
            }
            else if (unitConv.isHMST( utils.unquote( str )))
            {
                this.val.fval = unitConv.HMSToLong(utils.unquote(str));
                this.val.typVal = typVal.time;
            }
            else if (this.isString(str))
            {
                this.val.sval = str;
                this.val.typVal = typVal.str;
            }
            else if (this.isNumeric(str))
            {
                this.val.fval = this.numval(str);
                this.val.typVal = typVal.num;
            }
            else
            {
                this.val.typVal = typVal.undef;
                int p = 0;
                int cp0 = 0;
                int l = str.Length;
                //on recupere la liste des operateurs
                bool[] operateurs = new bool[(int)tokenExpr.nbVal];

                for (int i = 0; i < (int)tokenExpr.nbVal; i++)
                    operateurs[i] = true;

                //on recupere la liste des operateurs
                bool inStr = false;
                for (int i = 0; i < l; i++)
                {
                    if( inStr && str[i] == '\\' ){
                        i++;
                        continue;
                    }
                    if (str[i] == '"')
                    {
                        if (inStr)
                            inStr = false;
                        else
                            inStr = true;
                    }
                    if (inStr)
                        continue;
                    if (str[i] == '(')
                    {
                        p++;
                    }
                    else if (str[i] == ')')
                        p--;
                    else if (p == 0)
                    {
                        tokenExpr token = tokenExpr.notfound;
                        if (str[i] == '&' && i < (l - 1) && str[i + 1] == '&')
                        {
                            token = tokenExpr.and;
                            i++;
                        }
                        else if (str[i] == '|' && i < (l - 1) && str[i + 1] == '|')
                        {
                            token = tokenExpr.or;
                            i++;
                        }
                        else if (str[i] == '=' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.equal;
                            i++;
                        }
                        else if (str[i] == '!' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.diff;
                            i++;
                        }
                        else if (str[i] == '>' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.moreThanEqual;
                            i++;
                        }
                        else if (str[i] == '<' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.lessThanEqual;
                            i++;
                        }
                        else if (str[i] == '>')
                            token = tokenExpr.moreThan;
                        else if (str[i] == '<')
                            token = tokenExpr.lessThan;
                        else if (str[i] == '.')
                            token = tokenExpr.concat;
                        else if (str[i] == '+')
                            token = tokenExpr.plus;
                        else if (str[i] == '-')
                            token = tokenExpr.minus;
                        else if (str[i] == '*')
                            token = tokenExpr.mult;
                        else if (str[i] == '/')
                            token = tokenExpr.div;
                        else if (str[i] == '^')
                            token = tokenExpr.pow;
                        if (token != tokenExpr.notfound)
                        {
                            for (int j = (int)token + 1; j < (int)tokenExpr.nbVal; j++)
                                operateurs[j] = false;
                        }
                    }
                }
                if (p != 0)
                {
                    throw new Exception("Nombre de parentheses incorrect");
                }
                inStr = false;
                for (int i = l - 1; i >= 0; i--)
                {
                    if (inStr && str[i] == '"' && i > 0 && str[i-1] == '\\')
                    {
                        i--;
                        continue;
                    }
                    if (str[i] == '"')
                    {
                        if (inStr)
                            inStr = false;
                        else
                            inStr = true;
                    }
                    if (inStr)
                        continue;

                    if (p == 0)
                    {
                        cp0++;
                    }
                    tokenExpr token = tokenExpr.notfound;
                    int firstPart = i;
                    int secondPart = i;
                    if (str[i] == '&' && i > 0 && str[i - 1] == '&')
                    {
                        token = tokenExpr.and;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '|' && i > 0 && str[i - 1] == '|')
                    {
                        token = tokenExpr.or;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '=')
                    {
                        token = tokenExpr.equal;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '!')
                    {
                        token = tokenExpr.diff;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '>')
                    {
                        token = tokenExpr.moreThanEqual;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '<')
                    {
                        token = tokenExpr.lessThanEqual;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '>')
                        token = tokenExpr.moreThan;
                    else if (str[i] == '<')
                        token = tokenExpr.lessThan;
                    else if (str[i] == '.')
                        token = tokenExpr.concat;
                    else if (str[i] == '+')
                        token = tokenExpr.plus;
                    else if (str[i] == '-')
                        token = tokenExpr.minus;
                    else if (str[i] == '*')
                        token = tokenExpr.mult;
                    else if (str[i] == '/')
                        token = tokenExpr.div;
                    else if (str[i] == '^')
                        token = tokenExpr.pow;

                    if (str[i] == '(')
                        p++;
                    else if (str[i] == ')')
                        p--;
                    else if (p == 0 && ( token != tokenExpr.notfound ) && (bool)operateurs[(int)token])
                    {
                        this.operateur = token;
                        this.expra = new Parseur(str.Substring(0, firstPart));
                        string titi = str.Substring(0,firstPart);
                        this.exprb = new Parseur(str.Substring(secondPart + 1));
                        string toto = str.Substring(secondPart + 1);
                        break;
                    }
                }
                if (this.expra == null && cp0 == 1)
                {
                    if (this.isString(str.Substring(1, l - 2)))
                    {
                        this.val.sval = str.Substring(1, l - 2);
                        this.val.typVal = typVal.str;
                    }
                    else if (this.isNumeric(str.Substring(1, l - 2)))
                    {
                        this.val.fval = this.numval(str.Substring(1, l - 2));
                        this.val.typVal = typVal.num;
                    }
                    else
                    {
                        this.expra = new Parseur(str.Substring(1, l - 2));
                    }
                }
            }
        }
        public bool isNumeric(string str)
        {
            try
            {
                float val = float.Parse(str);
                return true;
            }
            catch
            {
                return false;
            }
        }
        public bool isString(string str)
        {
            int l = str.Length;
            if (l < 2)
                return false;
            if (str[0] != '"')
            {
                return false;
            }
            for (int i = 1; i < l; i++)
            {
                if (str[i] == '\\'){
                    i++;
                    continue;
                }
                if (str[i] == '"')
                {
                    if (i == l - 1)
                        return true;
                    else
                        return false;
                }
            }
            return false;
        }

        public float numval(string str)
        {
            try
            {
                float val = float.Parse(str);
                return val;
            }
            catch
            {
                return 0;
            }
        }
        public unionVal getval()
        {
            unionVal retVal = getval2();
            if (retVal.typVal == typVal.time)
            {
                retVal.sval = "\"" + unitConv.LongToHMS( (long)retVal.fval ) + "\"";
                retVal.typVal = typVal.str;
            }

            return retVal;
        }
        public unionVal getval2()
        {
            if (this.val.typVal != typVal.undef)
                return this.val;
            else if (this.exprb == null)
            {
                if (this.expra == null)
                    throw new Exception("Erreur probablement dans l\'enchainement des operateurs...");
                else
                    return this.expra.getval();
            }
            unionVal reta = this.expra.getval2();
            unionVal retb = this.exprb.getval2();
            if (this.operateur == tokenExpr.equal
                || this.operateur == tokenExpr.diff
                || this.operateur == tokenExpr.moreThan
                || this.operateur == tokenExpr.lessThan
                || this.operateur == tokenExpr.moreThanEqual
                || this.operateur == tokenExpr.lessThanEqual
                )
            {
                if (reta.typVal == typVal.str || retb.typVal == typVal.str)
                {
                    if (reta.typVal != typVal.str)
                    {
                        reta.typVal = typVal.str;
                        reta.sval = "\"" + reta.sval.ToString() + "\"";
                    }
                    if (retb.typVal != typVal.str)
                    {
                        retb.typVal = typVal.str;
                        retb.sval = "\"" + retb.sval.ToString() + "\"";
                    }
                }

            }
            if (this.operateur == tokenExpr.concat)
            {
                if (reta.typVal == typVal.num)
                {
                    reta.sval = "\"" + reta.fval.ToString() + "\"";
                    reta.typVal = typVal.str;
                }
                else if (reta.typVal == typVal.time )
                {
                    reta.sval = "\"" + unitConv.LongToHMS( (long)reta.fval ) + "\"";
                    reta.typVal = typVal.str;
                }

                if (retb.typVal == typVal.num)
                {
                    retb.sval = "\"" + retb.fval.ToString() + "\"";
                    retb.typVal = typVal.str;
                }
                else if (retb.typVal == typVal.time)
                {
                    retb.sval = "\"" + unitConv.LongToHMS( (long)retb.fval ) + "\"";
                    retb.typVal = typVal.str;
                }
            }
            if (this.operateur == tokenExpr.plus
                || this.operateur == tokenExpr.or
                || this.operateur == tokenExpr.and
                || this.operateur == tokenExpr.minus
                || this.operateur == tokenExpr.mult
                || this.operateur == tokenExpr.div
                || this.operateur == tokenExpr.pow
                )
            {
                if (reta.typVal == typVal.str)
                {
                    reta.fval = this.numval(utils.unquote(reta.sval));
                    reta.typVal = typVal.num;
                }
                if (retb.typVal == typVal.str)
                {
                    retb.fval = this.numval(utils.unquote(retb.sval));
                    retb.typVal = typVal.num;
                }
            }
            switch (this.operateur)
            {
                case tokenExpr.and:
                    if (reta.fval != 0 && retb.fval != 0)
                        return new unionVal(1, "", typVal.num);
                    else
                        return new unionVal(0, "", typVal.num);
                case tokenExpr.or:
                    if (reta.fval != 0 || retb.fval != 0)
                        return new unionVal(1, "", typVal.num);
                    else
                        return new unionVal(0, "", typVal.num);
                case tokenExpr.equal:
                    if (reta.typVal == typVal.str)
                    {
                        if (reta.sval == retb.sval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval == retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.diff:
                    if (reta.typVal == typVal.str)
                    {
                        if (reta.sval != retb.sval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval != retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.moreThan:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) > 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval > retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.moreThanEqual:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) >= 0 )
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval >= retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.lessThan:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) < 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval < retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.lessThanEqual:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) <= 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval <= retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }

                case tokenExpr.concat:
                    return new unionVal(0, "\"" + utils.unquote(reta.sval) + utils.unquote(retb.sval) + "\"", typVal.str);
                case tokenExpr.plus:
                    {
                        typVal typ;
                        if (reta.typVal == typVal.time || retb.typVal == typVal.time)
                            typ = typVal.time;
                        else
                            typ = typVal.num;
                         return new unionVal(reta.fval + retb.fval, "", typ);
                    }
                case tokenExpr.minus:
                    {
                        typVal typ;
                        if (reta.typVal == typVal.time || retb.typVal == typVal.time)
                            typ = typVal.time;
                        else
                            typ = typVal.num;
                        return new unionVal(reta.fval - retb.fval, "", typ);
                    }
                case tokenExpr.mult:
                    {
                        typVal typ;
                        if (reta.typVal == typVal.time || retb.typVal == typVal.time)
                            typ = typVal.time;
                        else
                            typ = typVal.num;
                        return new unionVal(reta.fval * retb.fval, "", typ);
                    }
                case tokenExpr.div:
                    if (retb.fval == 0)
                        throw new Exception("Division par 0");
                    {
                        typVal typ;
                        if (reta.typVal == typVal.time || retb.typVal == typVal.time)
                            typ = typVal.time;
                        else
                            typ = typVal.num;
                        return new unionVal(reta.fval / retb.fval, "", typ);
                    }
                case tokenExpr.pow:
                    {
                        typVal typ;
                        if (reta.typVal == typVal.time || retb.typVal == typVal.time)
                            typ = typVal.time;
                        else
                            typ = typVal.num;
                        if (retb.fval == 0)
                        {
                            return new unionVal(1, "", typ);
                        }
                        else if (reta.fval == 0)
                        {
                            return new unionVal(0, "", typ);
                        }
                        else if (retb.fval != Math.Ceiling(retb.fval) && reta.fval <= 0)
                        {
                            if ((1 / retb.fval) == Math.Ceiling(1 / retb.fval) && Math.Abs(1 / retb.fval) % 2 == 1)
                            {
                                return new unionVal((float)(-Math.Pow(-reta.fval, retb.fval)), "", typ);
                            }
                            else
                            {
                                throw new Exception("On ne peut pas prendre un exposant non entier sur un nombre negatif");
                            }
                        }
                        else
                        {
                            return new unionVal((float)Math.Pow(reta.fval, Math.Ceiling(retb.fval)), "", typ);
                        }
                    }
                default:
                    throw new Exception("operateur " + this.operateur + "non definit");
                    return new unionVal( 0,"",typVal.num );
            }
        }
        public string ToRPN()
        {
            if (this.val.typVal != typVal.undef)
            {
                if (this.val.typVal == typVal.num)
                    return this.val.fval.ToString();
                else if ( this.val.typVal == typVal.str )
                    return this.val.sval;
                else if ( this.val.typVal == typVal.time )
                    return "\"" + unitConv.LongToHMS( (long)this.val.fval ) + "\"";
            }
            else if (this.exprb == null && this.expra != null)
            {
                return this.expra.ToRPN();
            }
            else if (this.expra == null && this.exprb != null)
            {
                if (this.operateur != tokenExpr.notfound)
                    return this.exprb.ToRPN() + " " + this.operateur;
                else
                    return this.exprb.ToRPN();
            }
            else if (this.expra != null && this.exprb != null)
            {
                return this.expra.ToRPN() + " " + this.exprb.ToRPN() + " " + this.operateur;
            }
            return "";
        }
    }
}
