package ogt;

import java.io.IOException;

import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;


public class UDPReceiver implements Runnable {
	
	private DatagramConnection con;
	private Datagram dgram;
	private boolean isOpened = false;
	private String port;
	
	private OutGaugeDump root;
	
	public UDPReceiver(OutGaugeDump inRoot, int inPort)
	{
		root = inRoot;
		port = Integer.toString(inPort);
	}
	
	public void closeConnection()
	{
		isOpened = false;
	}
	
	public boolean getIsOpened()
	{
		return isOpened;
	 }

	/** UDP receiving thread*/
	public void run()
	{
		openConnection();
		while(isOpened)
		{
			//Receive packet
			try 
			{
				con.receive(dgram);
			} catch (IOException ex)
			{
				ex.printStackTrace();
			}
				
			if(dgram.getLength() == 92)		//Check if the packet we received is a valid OutGauge packet
			{
				synchronized(root.packetLock)				//Avoid changing OutGauge data when the screen is being drawn
				{
					root.pData.parsePacket(dgram.getData());
				}
			}
		}
		
		//Close connection
		try
		{
			con.close();
		} catch (IOException ex)
		{
			ex.printStackTrace();
		}
	}
	
	private void openConnection()
	{
		try {
			con = (DatagramConnection)Connector.open("datagram://:"+port);
			dgram = con.newDatagram(con.getMaximumLength());
			isOpened = true;
		} catch (IOException ex)
		{
			ex.printStackTrace();
		}
	}
}
