package ogt;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class OutGaugeDump extends MIDlet implements CommandListener {
	
	Displayer disp;							//Draws output to the screen
	UDPReceiver recv;					//Receives UDP packet
	
	Thread udpThread;					//Drawing thread
	Thread drawThread;					//Network thread
	
	public ParsedData pData;		//Parsed data from OutGauge packet
	public Object packetLock;		//Mutex
	
	private Form initForm;				//Init form which asks user for the OutGauge port
	private TextField input;
	private Command ok;

	public OutGaugeDump() {
		//Preliminary initialization
		pData = new ParsedData();
		packetLock = new Object();
		
		//Ask user for a port on which we'll receive OutGauge packets
		ok = new Command("OK", Command.OK, 2);
		initForm = new Form("OutGauge Dump");
		input = new TextField("Port:", "30000", 5, TextField.NUMERIC);
		initForm.append(input);
		initForm.addCommand(ok);
		initForm.setCommandListener(this);
		Display.getDisplay(this).setCurrent(initForm);
	}

	protected void destroyApp(boolean arg0) throws MIDletStateChangeException
	{
		disp.stopDrawing();
		recv.closeConnection();
	}

	protected void pauseApp()
	{
	}

	protected void startApp() throws MIDletStateChangeException
	{
	}
	
	private void startThreads(int port)
	{
		//Destroy the init form
		initForm.deleteAll();
		initForm = null;
		
		disp = new Displayer(this);
		recv = new UDPReceiver(this, port);
		
		drawThread = new Thread(disp);
		udpThread = new Thread(recv);
		
		drawThread.start();
		udpThread.start();
	}

	public void commandAction(Command c, Displayable d)
	{
		String label = c.getLabel();
		if(label.equals("OK"))
		{
			int port = Integer.parseInt(input.getString());
			if(port > 0 && port < 65536) startThreads(port);		//If user entered a valid port, start UDP and drawing threads
		}
	}
}
