package ogt;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;


public class Displayer extends GameCanvas implements Runnable {
	
	OutGaugeDump root;
	Display display;
	
	boolean canDraw = true;
	
	//Offsets of drawn elements
	final int gearXOff = 6;
	final int gearYOff = 4;
	final int gearRevsYOff = 20;
	int warnLightXOff;
	int warnLightYOff;
	
	//Dimensions of gear digit
	int gearW;
	int gearH;
	int gearThickness;		//Thickness of lines composing the gear digit
	
	//Dimensions of the revcounter boxes
	int revW;						//Width of a revcounter box
	int revH;						//Height of a revcounter box
	int spcW;						//Space between two boxes
	
	public Displayer(OutGaugeDump inRoot)
	{
		super(true);
		root = inRoot;
	}
	
	public void stopDrawing()
	{
		canDraw = false;
	}
	
	/** Drawing thread*/
	public void run() 
	{
		//Acquire display
		display = Display.getDisplay(root);
		display.setCurrent(this);
		
		//Init graphics
		Graphics g = getGraphics();
		
		//Get display dimensions
		int w = getWidth();							//Width of the display
		int h = getHeight();							//Height of the display
		
		//Calculate dimensions of gear digits
		gearW = w/3 - gearXOff;
		gearH = (3*h/5) - gearYOff;
		gearThickness = 22*h*w/294/240;
		if(gearThickness < 2)
		{
			gearThickness = 2;
		}
		
		//Dimensions of revcounter boxes
		revW = 15*w/240;	
		revH = 70*h/291;
		//spcW = 5*w/240;
		spcW = (w - (2*gearXOff + 10*revW))/9;
		
		//Offset of the warning text
		warnLightXOff = gearXOff + gearW + 30*(w/240)+5;
		warnLightYOff = gearYOff + 40*(h/294);
		
		//Font for the warning text
		int fontSize;
		if(w > 160) fontSize = Font.SIZE_LARGE;
		else if(w > 125) fontSize = Font.SIZE_MEDIUM;
		else fontSize = Font.SIZE_SMALL;
		Font font = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, fontSize);
		g.setFont(font);
		
		//Drawing loop
		while(canDraw)
		{
			display.flashBacklight(100);		//Light up the display
			try {										//Draw at 50 FPS
				Thread.sleep(20);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			synchronized (root.packetLock)		//Avoid drawing while the OutGauge data is being changed
			{
				//Draw black background
				g.setColor(0, 0, 0);
				g.fillRect(0, 0, w, h);
				
				drawGear(gearW, gearH, root.pData.gear, root.pData.shiftL, g);
				drawRevs(revW, revH, spcW, root.pData.rpm, g);
				if(root.pData.fuel < 0.07f) drawRefuelLight(warnLightXOff, warnLightYOff, g);
				if(root.pData.oilL) drawOilPressLight(warnLightXOff, warnLightYOff, g);
				if(root.pData.batteryL) drawChargeLight(warnLightXOff, warnLightYOff, g);
				
				flushGraphics();
			}
		}
		
	}
	
	private void drawGear(int w, int h, int gear, boolean shift, Graphics g)
	{
		if(shift) 		//Shift light is on
		{
			//Draw a yellow box behind the gear indicator
			g.setColor(192, 192, 0);
			g.fillRect(gearXOff-3, 0, w +7 , h +7);
			
			//Draw the gear digit black
			g.setColor(0,0,0);
		}
		else g.setColor(0, 192, 192);		//Shift light is off
		
		switch(gear)
		{
		case 0:		//Reverse
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff, gearYOff+h/2, gearThickness, h/2);
			break;
		case 1:		//Neutral
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff, gearYOff+h/2, gearThickness, h/2);
			g.fillRect(gearXOff+w-gearThickness, gearYOff+h/2, gearThickness, h/2);
			break;
		case 2:		//1st
			g.fillRect(gearXOff+w-gearThickness, gearYOff, gearThickness, h);
			break;
		case 3:		//2nd
			g.fillRect(gearXOff, gearYOff, w, gearThickness);
			g.fillRect(gearXOff+w-gearThickness, gearYOff, gearThickness, h/2);
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff, gearYOff+h/2, gearThickness, h/2);
			g.fillRect(gearXOff, gearYOff+h-gearThickness, w, gearThickness);
			break;
		case 4:		//3rd
			g.fillRect(gearXOff, gearYOff, w, gearThickness);
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff, gearYOff+h-gearThickness, w, gearThickness);
			g.fillRect(gearXOff + w - gearThickness, gearYOff, gearThickness, h);
			break;
		case 5:		//4th
			g.fillRect(gearXOff, gearYOff, gearThickness, h/2);
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff + w - gearThickness, gearYOff, gearThickness, h);
			break;
		case 6:		//5th
			g.fillRect(gearXOff, gearYOff, w, gearThickness);
			g.fillRect(gearXOff, gearYOff, gearThickness, h/2);
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff+w-gearThickness, gearYOff+h/2, gearThickness, h/2);
			g.fillRect(gearXOff, gearYOff+h-gearThickness, w, gearThickness);
			break;
		case 7:		//6th
			g.fillRect(gearXOff, gearYOff, w, gearThickness);
			g.fillRect(gearXOff, gearYOff, gearThickness, h);
			g.fillRect(gearXOff, gearYOff+h/2, w, gearThickness);
			g.fillRect(gearXOff+w-gearThickness, gearYOff+h/2, gearThickness, h/2);
			g.fillRect(gearXOff, gearYOff+h-gearThickness, w, gearThickness);
			break;
		case 8:		//7th
			g.fillRect(gearXOff, gearYOff, w, gearThickness);
			g.fillRect(gearXOff+w-gearThickness, gearYOff, gearThickness, h);
			break;
		}
	}
	
	private void drawRevs(int w, int h, int spcW, int rpm, Graphics g)
	{
		//Divide RPM to 10 blocks, 1st block corresponds to redline/2 + rpmPerBox, 9th block corresponds to the redline	
		int rpmPerBox = root.pData.redline/20;
		
		int i = 0;
		while(rpm > ((root.pData.redline/2 + rpmPerBox) + i*rpmPerBox))
		{
			if(i < 5) g.setColor(0,128,0);				//First five boxes are green 
			else if(i < 8) g.setColor(128,128,0);	//Boxes from 5th to 8th are yellow
			else g.setColor(128,0,0);					//Last two boxes are red
			
			g.fillRect(gearXOff + i*(w + spcW), gearYOff + gearH + gearRevsYOff, w, h);
			if(++i > 9) break;								//Don't draw more than 10 boxes
		}
		
		//Draw the outlines
		g.setColor(255,255,255);
		for(int j = 0; j < 10; j++)
		{
			g.drawRect(gearXOff + j*(w + spcW), gearYOff + gearH + gearRevsYOff, w, h);
		}
	}
	
	private void drawRefuelLight(int xOff, int yOff, Graphics g)
	{
		g.setColor(255, 100, 0);
		g.drawString("LOW FUEL", xOff, yOff, Graphics.TOP | Graphics.LEFT);
	}
	
	private void drawOilPressLight(int xOff, int yOff, Graphics g)
	{
		g.setColor(255, 0, 0);
		g.drawString("OIL PRESS", xOff, 10+yOff*2, Graphics.TOP | Graphics.LEFT);
	}
	
	private void drawChargeLight(int xOff, int yOff, Graphics g)
	{
		g.setColor(255, 0, 0);
		g.drawString("CHARGE", xOff, 10+yOff*6, Graphics.TOP | Graphics.LEFT);
	}
}
