/*
 * Decompiled with CFR 0.152.
 */
package ogt;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;
import ogt.OutGaugeDump;

public class Displayer
extends GameCanvas
implements Runnable {
    OutGaugeDump root;
    Display display;
    boolean canDraw = true;
    final int gearXOff;
    final int gearYOff;
    final int gearRevsYOff;
    int warnLightXOff;
    int warnLightYOff;
    int gearW;
    int gearH;
    int gearThickness;
    int revW;
    int revH;
    int spcW;

    public Displayer(OutGaugeDump inRoot) {
        super(true);
        this.gearXOff = 6;
        this.gearYOff = 4;
        this.gearRevsYOff = 20;
        this.root = inRoot;
    }

    public void stopDrawing() {
        this.canDraw = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.display = Display.getDisplay((MIDlet)this.root);
        this.display.setCurrent((Displayable)this);
        Graphics g = this.getGraphics();
        int w = this.getWidth();
        int h = this.getHeight();
        this.gearW = w / 3 - 6;
        this.gearH = 3 * h / 5 - 4;
        this.gearThickness = 22 * h * w / 294 / 240;
        if (this.gearThickness < 2) {
            this.gearThickness = 2;
        }
        this.revW = 15 * w / 240;
        this.revH = 70 * h / 291;
        this.spcW = (w - (12 + 10 * this.revW)) / 9;
        this.warnLightXOff = 6 + this.gearW + 30 * (w / 240) + 5;
        this.warnLightYOff = 4 + 40 * (h / 294);
        int fontSize = w > 160 ? 16 : (w > 125 ? 0 : 8);
        Font font = Font.getFont((int)0, (int)1, (int)fontSize);
        g.setFont(font);
        while (this.canDraw) {
            this.display.flashBacklight(100);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Object object = this.root.packetLock;
            synchronized (object) {
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, w, h);
                this.drawGear(this.gearW, this.gearH, this.root.pData.gear, this.root.pData.shiftL, g);
                this.drawRevs(this.revW, this.revH, this.spcW, this.root.pData.rpm, g);
                if (this.root.pData.fuel < 0.07f) {
                    this.drawRefuelLight(this.warnLightXOff, this.warnLightYOff, g);
                }
                if (this.root.pData.oilL) {
                    this.drawOilPressLight(this.warnLightXOff, this.warnLightYOff, g);
                }
                if (this.root.pData.batteryL) {
                    this.drawChargeLight(this.warnLightXOff, this.warnLightYOff, g);
                }
                this.flushGraphics();
            }
        }
    }

    private void drawGear(int w, int h, int gear, boolean shift, Graphics g) {
        if (shift) {
            g.setColor(192, 192, 0);
            g.fillRect(3, 0, w + 7, h + 7);
            g.setColor(0, 0, 0);
        } else {
            g.setColor(0, 192, 192);
        }
        switch (gear) {
            case 0: {
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6, 4 + h / 2, this.gearThickness, h / 2);
                break;
            }
            case 1: {
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6, 4 + h / 2, this.gearThickness, h / 2);
                g.fillRect(6 + w - this.gearThickness, 4 + h / 2, this.gearThickness, h / 2);
                break;
            }
            case 2: {
                g.fillRect(6 + w - this.gearThickness, 4, this.gearThickness, h);
                break;
            }
            case 3: {
                g.fillRect(6, 4, w, this.gearThickness);
                g.fillRect(6 + w - this.gearThickness, 4, this.gearThickness, h / 2);
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6, 4 + h / 2, this.gearThickness, h / 2);
                g.fillRect(6, 4 + h - this.gearThickness, w, this.gearThickness);
                break;
            }
            case 4: {
                g.fillRect(6, 4, w, this.gearThickness);
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6, 4 + h - this.gearThickness, w, this.gearThickness);
                g.fillRect(6 + w - this.gearThickness, 4, this.gearThickness, h);
                break;
            }
            case 5: {
                g.fillRect(6, 4, this.gearThickness, h / 2);
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6 + w - this.gearThickness, 4, this.gearThickness, h);
                break;
            }
            case 6: {
                g.fillRect(6, 4, w, this.gearThickness);
                g.fillRect(6, 4, this.gearThickness, h / 2);
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6 + w - this.gearThickness, 4 + h / 2, this.gearThickness, h / 2);
                g.fillRect(6, 4 + h - this.gearThickness, w, this.gearThickness);
                break;
            }
            case 7: {
                g.fillRect(6, 4, w, this.gearThickness);
                g.fillRect(6, 4, this.gearThickness, h);
                g.fillRect(6, 4 + h / 2, w, this.gearThickness);
                g.fillRect(6 + w - this.gearThickness, 4 + h / 2, this.gearThickness, h / 2);
                g.fillRect(6, 4 + h - this.gearThickness, w, this.gearThickness);
                break;
            }
            case 8: {
                g.fillRect(6, 4, w, this.gearThickness);
                g.fillRect(6 + w - this.gearThickness, 4, this.gearThickness, h);
            }
        }
    }

    private void drawRevs(int w, int h, int spcW, int rpm, Graphics g) {
        int rpmPerBox = this.root.pData.redline / 20;
        int i = 0;
        while (rpm > this.root.pData.redline / 2 + rpmPerBox + i * rpmPerBox) {
            if (i < 5) {
                g.setColor(0, 128, 0);
            } else if (i < 8) {
                g.setColor(128, 128, 0);
            } else {
                g.setColor(128, 0, 0);
            }
            g.fillRect(6 + i * (w + spcW), 4 + this.gearH + 20, w, h);
            if (++i > 9) break;
        }
        g.setColor(255, 255, 255);
        int j = 0;
        while (j < 10) {
            g.drawRect(6 + j * (w + spcW), 4 + this.gearH + 20, w, h);
            ++j;
        }
    }

    private void drawRefuelLight(int xOff, int yOff, Graphics g) {
        g.setColor(255, 100, 0);
        g.drawString("LOW FUEL", xOff, yOff, 20);
    }

    private void drawOilPressLight(int xOff, int yOff, Graphics g) {
        g.setColor(255, 0, 0);
        g.drawString("OIL PRESS", xOff, 10 + yOff * 2, 20);
    }

    private void drawChargeLight(int xOff, int yOff, Graphics g) {
        g.setColor(255, 0, 0);
        g.drawString("CHARGE", xOff, 10 + yOff * 6, 20);
    }
}

