/*
 * Decompiled with CFR 0.152.
 */
package ogt;

public class ParsedData {
    public byte gear = 1;
    public float speed = 0.0f;
    public int rpm = 0;
    public float fuel = 1.0f;
    public boolean shiftL = false;
    public boolean pitspeedL = false;
    public boolean oilL = false;
    public boolean batteryL = false;
    private int showLights = 0;
    public int redline = 0;
    private char[] carCode = new char[3];
    private char[] prevCarCode = new char[3];
    private boolean refreshCarCode = true;

    public void parsePacket(byte[] inData) {
        this.carCode[0] = (char)inData[4];
        this.carCode[1] = (char)inData[5];
        this.carCode[2] = (char)inData[6];
        if (this.refreshCarCode) {
            System.arraycopy(this.carCode, 0, this.prevCarCode, 0, 3);
            this.setRedline();
            this.refreshCarCode = false;
        }
        this.refreshCarCode = this.checkCarCode();
        this.gear = inData[10];
        this.speed = this.segmentToFloat(inData, 12) * 3.6f;
        this.rpm = (int)this.segmentToFloat(inData, 16);
        this.fuel = this.segmentToFloat(inData, 28);
        this.showLights = this.segmentToInt(inData, 44);
        this.parseDashLights();
    }

    private boolean checkCarCode() {
        return this.carCode[0] != this.prevCarCode[0] || this.carCode[1] != this.prevCarCode[1] || this.carCode[2] != this.prevCarCode[2];
    }

    private float segmentToFloat(byte[] inData, int beg) {
        int bits = 0;
        int shiftBy = 0;
        while (shiftBy < 4) {
            bits |= (inData[beg++] & 0xFF) << shiftBy * 8;
            ++shiftBy;
        }
        return Float.intBitsToFloat(bits);
    }

    private int segmentToInt(byte[] inData, int beg) {
        int retVal = 0;
        int shiftBy = 0;
        while (shiftBy < 4) {
            retVal |= (inData[beg++] & 0xFF) << shiftBy * 8;
            ++shiftBy;
        }
        return retVal;
    }

    private void parseDashLights() {
        int mask = 1;
        this.shiftL = (this.showLights & mask) == mask;
        mask = 6;
        this.pitspeedL = (this.showLights & mask) == mask;
        mask = 256;
        this.oilL = (this.showLights & mask) == mask;
        mask = 512;
        this.batteryL = (this.showLights & mask) == mask;
    }

    private void setRedline() {
        if (this.carCode[0] == 'B') {
            this.redline = 20000;
        } else if (this.carCode[0] == 'F') {
            if (this.carCode[1] == 'B') {
                this.redline = 9000;
            } else if (this.carCode[1] == 'O') {
                this.redline = 7500;
            } else if (this.carCode[1] == 'X') {
                this.redline = this.carCode[2] == 'O' ? 7500 : 7500;
            } else if (this.carCode[1] == 'Z') {
                this.redline = this.carCode[2] == 'R' ? 8500 : 8000;
            } else if (this.carCode[1] == '0') {
                this.redline = 9500;
            }
        } else if (this.carCode[0] == 'L') {
            this.redline = 9000;
        } else if (this.carCode[0] == 'M') {
            this.redline = 13000;
        } else if (this.carCode[0] == 'R') {
            this.redline = this.carCode[1] == 'A' ? 7000 : 7500;
        } else if (this.carCode[0] == 'U') {
            this.redline = this.carCode[2] == 'R' ? 9000 : 7000;
        } else if (this.carCode[0] == 'X') {
            if (this.carCode[1] == 'F') {
                this.redline = 8000;
            } else if (this.carCode[1] == 'R') {
                this.redline = this.carCode[2] == 'G' ? 7000 : 7500;
            }
        }
    }
}

