/*
 * Decompiled with CFR 0.152.
 */
package ogt;

public class ParsedData {
    public byte gear = 1;
    public float speed = 0.0f;
    public int rpm = 0;
    public float fuel = 1.0f;
    public String dashLights = "0";
    public boolean shiftL = false;
    public boolean pitspeedL = false;
    public boolean oilL = false;
    public boolean batteryL = false;
    public int redline = 0;
    private char[] carCode = new char[3];

    public void parsePacket(byte[] inData) {
        this.carCode[0] = (char)inData[4];
        this.carCode[1] = (char)inData[5];
        this.carCode[2] = (char)inData[6];
        this.setRedline();
        this.gear = inData[10];
        this.speed = this.segmentToFloat(inData, 12) * 3.6f;
        this.rpm = (int)this.segmentToFloat(inData, 16);
        this.fuel = this.segmentToFloat(inData, 28);
        this.dashLights = Integer.toBinaryString(this.segmentToInt(inData, 44));
        this.parseDashLights();
    }

    private float segmentToFloat(byte[] inData, int beg) {
        int bits = 0;
        int shiftBy = 0;
        while (shiftBy < 4) {
            bits |= (inData[beg++] & 0xFF) << shiftBy * 8;
            ++shiftBy;
        }
        return Float.intBitsToFloat(bits);
    }

    private int segmentToInt(byte[] inData, int beg) {
        int bits = 0;
        int shiftBy = 0;
        while (shiftBy < 4) {
            bits |= (inData[beg++] & 0xFF) << shiftBy * 8;
            ++shiftBy;
        }
        return bits;
    }

    private void parseDashLights() {
        block5: {
            int len = this.dashLights.length();
            try {
                this.shiftL = this.dashLights.charAt(len - 1) == '1';
                this.pitspeedL = this.dashLights.charAt(len - 4) == '1';
                this.oilL = this.dashLights.charAt(len - 9) == '1';
                this.batteryL = this.dashLights.charAt(len - 10) == '1';
            }
            catch (StringIndexOutOfBoundsException ex) {
                if (len < 4) {
                    this.batteryL = false;
                    this.oilL = false;
                    this.pitspeedL = false;
                } else if (len < 9) {
                    this.batteryL = false;
                    this.oilL = false;
                }
                if (len >= 10) break block5;
                this.batteryL = false;
            }
        }
    }

    private void setRedline() {
        if (this.carCode[0] == 'B') {
            this.redline = 20000;
        } else if (this.carCode[0] == 'F') {
            if (this.carCode[1] == 'B') {
                this.redline = 9000;
            } else if (this.carCode[1] == 'O') {
                this.redline = 7500;
            } else if (this.carCode[1] == 'X') {
                this.redline = this.carCode[2] == 'O' ? 7500 : 7500;
            } else if (this.carCode[1] == 'Z') {
                this.redline = this.carCode[2] == 'R' ? 8500 : 8000;
            } else if (this.carCode[1] == '0') {
                this.redline = 9500;
            }
        } else if (this.carCode[0] == 'L') {
            this.redline = 9000;
        } else if (this.carCode[0] == 'M') {
            this.redline = 13000;
        } else if (this.carCode[0] == 'R') {
            this.redline = this.carCode[1] == 'A' ? 7000 : 7500;
        } else if (this.carCode[0] == 'U') {
            this.redline = this.carCode[2] == 'R' ? 9000 : 7000;
        } else if (this.carCode[0] == 'X') {
            if (this.carCode[1] == 'F') {
                this.redline = 8000;
            } else if (this.carCode[1] == 'R') {
                this.redline = this.carCode[2] == 'G' ? 7000 : 7500;
            }
        }
    }
}

