/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class SimpleMap {
    private Minecraft game;
    private ng game_ng;
    private BufferedImage map;
    private BufferedImage overlay;
    private BufferedImage pal;
    private int[] bc = new int[256];
    private int lx = 0;
    private int lz = 0;
    private int q = 0;
    private int r = 0;
    public boolean showmap = true;
    public boolean coords = false;
    private boolean rl = true;
    private boolean rh = true;
    private boolean rc = true;
    public Properties options;
    private ln game_ln;
    private String osd;
    private String modPath;
    private int up = 0;
    private int depthBias = 1;

    public SimpleMap(Minecraft minecraft) {
        File file;
        this.game = minecraft;
        this.game_ng = this.game.u;
        this.game_ln = this.game.o;
        this.map = new BufferedImage(64, 64, 2);
        this.overlay = new BufferedImage(64, 64, 2);
        this.pal = new BufferedImage(64, 64, 2);
        this.options = new Properties();
        this.osd = "";
        try {
            SimpleMap simpleMap = this;
            this.modPath = simpleMap.game.b().getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.modPath = this.modPath + "/mods/SimpleMap/";
        try {
            this.options.load(new FileInputStream(this.modPath + "SimpleMap.properties"));
            if (this.options.getProperty("showCoords").equals("true")) {
                this.coords = true;
            }
            if (this.options.getProperty("up").equals("east")) {
                this.up = 0;
            }
            if (this.options.getProperty("up").equals("north")) {
                this.up = 3;
            }
            if (this.options.getProperty("up").equals("west")) {
                this.up = 2;
            }
            if (this.options.getProperty("up").equals("south")) {
                this.up = 1;
            }
        }
        catch (Exception exception) {
            this.osd = exception.getMessage();
        }
        try {
            file = new File(this.modPath + "mmcolors.png");
            this.pal = ImageIO.read(file);
            for (int i2 = 0; i2 < 256; ++i2) {
                this.bc[i2] = this.pal.getRGB(i2 % 32, i2 / 32) & 0xFFFFFF;
            }
        }
        catch (Exception exception) {
            this.osd = "SIMPLEMAP error: missing mmcolors.png. Using default palette.";
            for (int i3 = 0; i3 < 256; ++i3) {
                this.bc[i3] = 6069298;
            }
            this.bc[1] = 0x747474;
            this.bc[3] = 9858122;
            this.bc[4] = 0x4E4E4E;
            this.bc[5] = 10454093;
            this.bc[7] = 0x222222;
            this.bc[9] = 17536;
            this.bc[8] = 17536;
            this.bc[11] = 0xAA4422;
            this.bc[10] = 0xAA4422;
            this.bc[12] = 14667945;
            this.bc[13] = 0x808050;
            this.bc[17] = 0x2B2B1B;
            this.bc[18] = 1824795;
            this.bc[35] = 0x909090;
            this.bc[41] = 0x898922;
            this.bc[42] = 0x606060;
            this.bc[44] = 0x808080;
            this.bc[43] = 0x808080;
            this.bc[49] = 0;
            this.bc[50] = 0xFFFF00;
            this.bc[57] = 0x34DDDD;
            this.bc[81] = 1779739;
        }
        try {
            file = new File(this.modPath + "overlay.png");
            this.overlay = ImageIO.read(file);
            this.r = this.game.n.a(this.overlay);
        }
        catch (Exception exception) {
            this.osd = "SIMPLEMAP error: minimap overlay not found!";
        }
    }

    public void render(int n2, int n3) {
        double d2 = 64.0;
        double d3 = 64.0;
        n2 -= 5;
        n3 -= 5;
        int n4 = (int)this.game.g.av - 32;
        int n5 = (int)this.game.g.ax - 32;
        if (n4 != this.lx || n5 != this.lz) {
            if (this.coords) {
                this.osd = "(" + (int)this.game.g.av + "," + (int)this.game.g.aw + "," + (int)this.game.g.ax + ")";
            }
            this.lx = n4;
            this.lz = n5;
            for (int i2 = 0; i2 < 64; ++i2) {
                for (int i3 = 0; i3 < 64; ++i3) {
                    int n6 = this.game.e.d(n4 + i2, n5 + i3);
                    int n7 = this.rc ? (this.game.e.f(n4 + i2, n6, n5 + i3) == gy.s || this.game.e.f(n4 + i2, n6, n5 + i3) == gy.t ? 0xFFFFFF : this.bc[this.game.e.a(n4 + i2, n6 - 1, n5 + i3)]) : 0xFFFFFF;
                    int n8 = this.rh ? (n6 - (int)this.game.g.aw) * this.depthBias : 255;
                    int n9 = this.rl ? this.game.e.a(n4 + i2, n6, n5 + i3, false) * 16 : 255;
                    int n10 = n8 + n9;
                    if (n10 > 255) {
                        n10 = 255;
                    }
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    n7 = n10 * 0x1000000 + n7;
                    this.map.setRGB(i2, i3, n7);
                }
            }
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.q != 0) {
            this.game.n.a(this.q);
        }
        this.q = this.game.n.a(this.map);
        ip ip2 = ip.a;
        switch (this.up) {
            case 0: {
                ip2.b();
                ip2.a((double)n2 - d2, d3 + 5.0, 0.0, 0.0, 1.0);
                ip2.a(n2, d3 + 5.0, 0.0, 1.0, 1.0);
                ip2.a(n2, 5.0, 0.0, 1.0, 0.0);
                ip2.a((double)n2 - d2, 5.0, 0.0, 0.0, 0.0);
                ip2.a();
                break;
            }
            case 1: {
                ip2.b();
                ip2.a((double)n2 - d2, d3 + 5.0, 0.0, 0.0, 0.0);
                ip2.a(n2, d3 + 5.0, 0.0, 0.0, 1.0);
                ip2.a(n2, 5.0, 0.0, 1.0, 1.0);
                ip2.a((double)n2 - d2, 5.0, 0.0, 1.0, 0.0);
                ip2.a();
                break;
            }
            case 2: {
                ip2.b();
                ip2.a((double)n2 - d2, d3 + 5.0, 0.0, 1.0, 0.0);
                ip2.a(n2, d3 + 5.0, 0.0, 0.0, 0.0);
                ip2.a(n2, 5.0, 0.0, 0.0, 1.0);
                ip2.a((double)n2 - d2, 5.0, 0.0, 1.0, 1.0);
                ip2.a();
                break;
            }
            case 3: {
                ip2.b();
                ip2.a((double)n2 - d2, d3 + 5.0, 0.0, 1.0, 1.0);
                ip2.a(n2, d3 + 5.0, 0.0, 1.0, 0.0);
                ip2.a(n2, 5.0, 0.0, 0.0, 0.0);
                ip2.a((double)n2 - d2, 5.0, 0.0, 0.0, 1.0);
                ip2.a();
            }
        }
        if (this.r > 0) {
            this.game.n.b(this.r);
            ip2.b();
            ip2.a((double)n2 - d2, d3 + 5.0, 1.0, 0.0, 1.0);
            ip2.a(n2, d3 + 5.0, 1.0, 1.0, 1.0);
            ip2.a(n2, 5.0, 1.0, 1.0, 0.0);
            ip2.a((double)n2 - d2, 5.0, 1.0, 0.0, 0.0);
            ip2.a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
        this.game_ln.a(this.osd, 20, 20, 0xFFFFFF);
    }

    public void MapOff() {
        this.showmap = false;
    }

    public void MapOn() {
        this.showmap = true;
    }

    public void MapToggle() {
        this.showmap = !this.showmap;
    }

    public void MapCoordToggle() {
        this.coords = !this.coords;
    }

    public String getName() {
        return "SimpleMap";
    }

    public void uiCommand(String string) {
        if (string.equals("ver")) {
            this.osd = "SimpleMap v0.9";
            return;
        }
        if (string.equals("coords")) {
            this.MapToggle();
            return;
        }
        if (string.equals("off")) {
            this.MapOff();
            return;
        }
        if (string.equals("on")) {
            this.MapOn();
            return;
        }
        if (string.equals("lightmap")) {
            this.rl = !this.rl;
            return;
        }
        if (string.equals("heightmap")) {
            this.rh = !this.rh;
            return;
        }
        if (string.equals("color")) {
            this.rc = !this.rc;
            return;
        }
        if (string.equals("east")) {
            this.up = 0;
            return;
        }
        if (string.equals("north")) {
            this.up = 3;
            return;
        }
        if (string.equals("west")) {
            this.up = 2;
            return;
        }
        if (string.equals("south")) {
            this.up = 1;
            return;
        }
        if (string.equals("deep")) {
            ++this.depthBias;
            return;
        }
        if (string.equals("shallow")) {
            --this.depthBias;
            if (this.depthBias < 1) {
                this.depthBias = 1;
            }
            return;
        }
    }
}

