// LogiWheelRange.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "InSimConnection.h"

#define PROGRAM_VER "0.03"
#define CODENAME "What's Left of Me" //:)


int _tmain(int argc, _TCHAR* argv[])
{
	//Greet the user
	std::wcout << "LogiWheelRange v.:" << PROGRAM_VER << " starting..." << std::endl;

	//Load config
	ConfigLoader cfgLdr;
	cfgLdr.LoadConfig();

	//Create WheelRangeSetter
	WheelRangeSetter wRSetter(&cfgLdr);

	//Probe the registry
	if(!wRSetter.ProbeRegistry())
	{
		std::wcout << "Bailing out!" << std::endl;
		return -1;
	}

	InSimConnection isc(&wRSetter, &cfgLdr);

	if(!isc.InitConnection())
	{
		std::wcout << "Bailing out!" << std::endl;
		return -1;
	}

	isc.StartLoop();

	//Say goodbye:)
	std::wcout << "Successfully terminating (what, no SEGFAULTs today?)" << std::endl;

	return 0;
}

