#include "StdAfx.h"
#include "InSimConnection.h"

#define SETRNG_LEN 8
#define FROMLFS_LEN 7 
#define EXIT_LEN 4

InSimConnection::InSimConnection(WheelRangeSetter* inWRSetter, ConfigLoader* inCfgLdr)
{
	wRSetter = inWRSetter;
	cfgLdr = inCfgLdr;

	ipAddress = cfgLdr->GetIpAddress();
	adminPass = cfgLdr->GetAdminPass();
	inSimPort = cfgLdr->GetPort();

	//Create ConFileReader
	conReader = new ConFileReader();
	useWTFromLFS = conReader->Initialize();
	
	//Something has gone wrong with ConFileReader, delete it and don't use it.
	if(useWTFromLFS == false)
	{
		std::wcout << "Getting wheel range from LFS configuration will be unavailable." << std::endl;
		delete conReader;
		conReader = NULL;
	}

	connAttempts = 0;

	inSim = new CInsim();
}

/** Initializes connection to InSim
* through CInsim. Returns false if
* an error occurs in the process
*/
bool InSimConnection::InitConnection(void)
{
	//CInSim doesn't work with unicode WCHAR, so we need to convert our input data to char
	//Check how long our input variables are
	int ipAddressLen = ipAddress.length() + 1;
	int adminPassLen = adminPass.length() + 1;

	if(ipAddressLen < 1)
	{
		std::wcout << "Critical: IP address not specified!" << std::endl;
		return false;
	}
	char* a_ipAddress = new char[ipAddressLen];
	wcstombs(a_ipAddress, ipAddress.c_str(), ipAddressLen);		   //Do the Unicode to ANSI conversion
	
	char* a_adminPass = new char[adminPassLen];
	wcstombs(a_adminPass, adminPass.c_str(), adminPassLen);		   //Do the Unicode to ANSI conversion

	//Prepare version packet
	struct IS_VER ISVersionPacket;
	ZeroMemory(&ISVersionPacket, sizeof(struct IS_VER));

	//Connect to InSim and return false if unsuccessfull
	while(inSim->init(a_ipAddress, inSimPort, "LogiWheelRange", a_adminPass, &ISVersionPacket, '|', ISF_LOCAL, 500, 0) < 0)
	{
		Sleep(1000);		//Wait 1000 msecs before reconnecting
		std::wcout << "(InSimConnection)Note: Cannot connect to InSim, retrying in 1 sec (attempt " << ++connAttempts << ")" << std::endl;
		if(connAttempts > 10)
		{
			std::wcout << "(InSimConnection)Critical: Cannot connect to InSim." << std::endl;
			return false;
		}
	}

	std::wcout << "(InSimConnection)Connected to InSim, LFS " << ISVersionPacket.Version << " InSim version " << ISVersionPacket.InSimVer << std::endl;

	return true;
}

/** Starts the packet recieving loop.
* If an IS_MSO packet is recieved, hands it
* off to further processing
*/
bool InSimConnection::StartLoop(void)
{
	canRun = true;
	int recvError = 0;
	
	//Main loop recieving and processing packets from InSim
	while(canRun)
	{
		//Recieves next packet and ends the loop if unsuccessful
		if(recvError = inSim->next_packet() < 0)
		{
			std::wcerr << "(InSimConnection)Critical: Error recievng next packet." << std::endl;
			return false;
		}

		//Check if we recieved an IS_MSO packet
		if(inSim->peek_packet() == ISP_MSO)
		{
			ProcessMSOPacket();
		}
	}

	return true;
}

/** Reads the IS_MSO packet and
* checks if it contains a valid command
*/
void InSimConnection::ProcessMSOPacket(void)
{
	//Get the packet from CInSim buffer
	struct IS_MSO* ISMsoPacket = (struct IS_MSO*)inSim->get_packet();
	char* inString = ISMsoPacket->Msg + (unsigned char)ISMsoPacket->TextStart;


	//Check if the message is from the user
	if(ISMsoPacket->UserType == MSO_O)
	{
		//Check if the packet contains valid data
		if(strncmp(inString, "setrange", SETRNG_LEN) == 0)	//User wants to set range manually
		{
			DWORD newRange;
			int inStringLen = strlen(inString);

			//Remove the command part of the string and leave only the parameter
			if((inStringLen - SETRNG_LEN) > 0)	//Only if there is a parameter
			{
				char* rangeRecvd = new char[inStringLen - (SETRNG_LEN - 1)];
				for(int idx = SETRNG_LEN; idx < inStringLen; idx++)
				{
					rangeRecvd[idx-SETRNG_LEN] = inString[idx];
				}

				//Add a terminating zero
				rangeRecvd[inStringLen - SETRNG_LEN] = 0;

				//Debug
				newRange = (DWORD)atoi(rangeRecvd);
			}

			if(newRange > 89 && newRange < 901)
			{
				if(!wRSetter->SetRange(newRange))
				{
					std::wcout << "Unable to change wheel range!" << std::endl;
				}

				std::wcout << "Request to change wheel range manually to " << newRange << " successfully completed." << std::endl;
			}

		}

		if((strncmp(inString, "fromlfs", FROMLFS_LEN) == 0) && useWTFromLFS)		//User wants to have the wheel range set to the same value as in LFS
		{
			DWORD newRange = conReader->GetUpdatedWheelRange();

			if(newRange != NULL)
			{
				if(!wRSetter->SetRange(newRange))
				{
					std::wcout << "Unable to change wheel range!" << std::endl;
				}

				std::wcout << "Request to match wheel range to LFS settings successfully completed. Range is now " << newRange << "." << std::endl;
			}

		}

		if(strncmp(inString, "exit", EXIT_LEN) == 0)		//User wants to end the app
		{
			std::wcout << "Request to end the app recieved." << std::endl;
			canRun = false;
		}

	}
}

	
InSimConnection::~InSimConnection(void)
{
	inSim->isclose();
	delete inSim;
}
