#include "StdAfx.h"
#include "ConfigLoader.h"

ConfigLoader::ConfigLoader(void)
{
	//Default config
	ipAddress = L"127.0.0.1";
	port = 29999;
	adminPass = L"";
	autoAltTab = true;
	restoreDelay = 1000;
}
/** Reads logiConf.ini file
* and stores it's contents
*/
bool ConfigLoader::ReadConfigFile()
{
	//Open "logiConf.ini" for reading
	std::ifstream fReader("./lwrconf.cfg", std::ios::in);

	//Were we able to open that file?
	if(!fReader)
	{
		std::wcout << L"(ConfigLoader)Non-critical: Cannot open config file, falling back to defaults." << std::endl;
		return false;
	}
	
	//Read all lines in the file
	char* tempArr = new char[1024];
	while(!fReader.eof())
	{
		memset(tempArr, NULL, sizeof(tempArr));
		fReader.getline(tempArr, 1024);
		configRawData.push_back(tempArr);
	}

	return true;
}

/** Goes through the data we got
* from the logiconf.ini and creates
* config accoringly.
*/
void ConfigLoader::ParseConfigFile()
{
	std::wstring keyword;
	std::wstring value;
	std::wstring temp;
	int delimiterPos = 0;
	for(unsigned int idx = 0; idx < configRawData.size(); idx++)
	{
		//Convert from ANSI string to Unicode string
		WCHAR* tempch = new WCHAR[1024];
		mbstowcs(tempch, configRawData.at(idx).c_str(), 1024);
		temp = tempch;
		delete[] tempch;

		//Find delimiter position. Used to separate keyword from value
		delimiterPos = temp.find((WCHAR)'=', 0);

		if(delimiterPos == std::wstring::npos)	//No delimiter found, line is invalid
		{
			continue;
		}

		//Get the keyword
		keyword = temp.substr(0, delimiterPos);
		//Convert keyword to lower case
		transform(keyword.begin(), keyword.end(), keyword.begin(), std::ptr_fun(::tolower));
		//Get the value
		value = temp.substr(delimiterPos+1, std::wstring::npos);

		//Find out if we've recieved any valid data. If we did, modify config accordingly
		if(wcscmp(keyword.c_str(), L"address") == 0)
		{
			ipAddress = value;
		}
		else if(wcscmp(keyword.c_str(), L"port") == 0)
		{
			port = _wtoi(value.c_str());
			if(port < 1)
			{
				port = 29999;
			}
		}
		else if(wcscmp(keyword.c_str(), L"adminpass") == 0)
		{
			adminPass = value;
		}
		else if(wcscmp(keyword.c_str(), L"auto-alttab") == 0)
		{
			if(_wtoi(value.c_str()) == 1)
			{
				autoAltTab = true;
			}
		}
		else if(wcscmp(keyword.c_str(), L"restoredelay") == 0)
		{
			restoreDelay = _wtoi(value.c_str());
			if(restoreDelay < 100)
			{
				restoreDelay = 100;
			}
		}
	}
}

std::wstring ConfigLoader::GetIpAddress()
{
	return ipAddress;
}

std::wstring ConfigLoader::GetAdminPass()
{
	return adminPass;
}

short ConfigLoader::GetPort()
{
	return port;
}

bool ConfigLoader::GetAutoAltTab()
{
	return autoAltTab;
}

DWORD ConfigLoader::GetRestoreDelay()
{
	return restoreDelay;
}

bool ConfigLoader::LoadConfig()
{
	if(!ReadConfigFile())
	{
		return false;
	}
	
	ParseConfigFile();

	//List current config
	std::wcout << "InSim address:  " << ipAddress << std::endl;
	std::wcout << "InSim port:     " << port << std::endl;
	std::wcout << "Admin password: " << adminPass << std::endl;
	std::wcout << "Auto AltTab:    " << autoAltTab << std::endl;
	std::wcout << "Restore delay:  " << restoreDelay << std::endl;

	return true;
}

ConfigLoader::~ConfigLoader(void)
{
}
