// wtHack.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include <iostream>
#include <fstream>
#include <vector>
#include <string>

#define MAX_WCHAR_ARR 255

//Global vars for the registry modifying
HKEY lgProfKey;				//Key which holds settings of all Logitech devices connected
HKEY deviceSettingsSubKey;	//Subkey holding settings for a device
WCHAR** validRegEntries;	
DWORD valRegEntriesIdx = 0;
LONG opRes;					//HRESULT of a registry function call
DWORD totalSubKeys;			//How many subkeys are in the lgProfKey key.
DWORD dwSize = 1024;		//Size of DWORD, Windows apparently doesn't know their own datatypes
DWORD dwType = REG_DWORD;	//Again...

//Global vars for file access
std::vector<std::wstring> filesInMisc;
std::wstring prependPath = L"./data/misc/";

//Global array containing wheel turn info stored in each file
int* allWTdata;

/** Scans the LFS/data/misc directory
* and finds all .con files. Name of all .con
* files are stored in vector for further use
*/
bool probeMiscDirectory()
{
	HANDLE fileHndl = NULL;		//Handle to a next file returned by FindFirstFile()
	
	WIN32_FIND_DATA fileFoundInfo;

	fileHndl = FindFirstFile(L"./data/misc/*.con", &fileFoundInfo);
	if(fileHndl == NULL)
	{
		std::wcout << "Fatal: No .con file found!" << std::endl;
		return false;
	}
	//We have a file, let's store it's name so we can use it later
	filesInMisc.push_back(fileFoundInfo.cFileName);

	//Now go through the rest of the directory to find all .con files
	while(FindNextFile(fileHndl, &fileFoundInfo))
	{
		filesInMisc.push_back(fileFoundInfo.cFileName);
	}

	FindClose(fileHndl);

	//Tell user what we found
	std::wcout << ".con files found in LFS/data/misc/: " << filesInMisc.size() << std::endl;
	std::wcout << "Listing found .con files:" << std::endl;
	for(unsigned int idx = 0; idx < filesInMisc.size(); idx++)
	{
		std::wcout << filesInMisc.at(idx) << std::endl;
	}
	std::wcout << std::endl;

	return true;
}

/** Scans the registry and find
* all keys which contain DWORD OperatingRange value
*/
bool probeRegistry()
{
	std::wcout << "Beginning registry probe" << std::endl;

	//Open registry key
	opRes = RegOpenKeyEx(HKEY_CURRENT_USER, L"Software\\Logitech\\Gaming Software\\GlobalDeviceSettings\\", 0, KEY_ALL_ACCESS, &lgProfKey);
	if(opRes != ERROR_SUCCESS)
	{
		std::wcout << L"Critical: Error in function \"probeRegistry()\", line 27." << std::endl;
		std::wcout << L"Error code returned: " << opRes << std::endl;
		exit(-1);
	}
	
	//Find how many subkeys are there in this key
	opRes = RegQueryInfoKey(lgProfKey, NULL, NULL, NULL, &totalSubKeys, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	if(opRes != ERROR_SUCCESS)
	{
		std::wcout << L"Critical: Error in function \"probeRegistry()\", line 34." << std::endl;
		std::wcout << L"Error code returned: " << opRes << std::endl;
		exit(-1);
	}

	std::wcout << "Subkeys found: " << totalSubKeys << std::endl;

	//Now we know with how many subkeys we have to deal with
	//so let's make sure we have where to store their names
	validRegEntries = new WCHAR*[totalSubKeys];
	for(DWORD idx = 0; idx < totalSubKeys; idx++)
	{
		validRegEntries[idx] = new WCHAR[MAX_WCHAR_ARR];
	}

	DWORD wcSize = MAX_WCHAR_ARR;

	//Now let's go through all keys in there and find out which ones contain DWORD OperatingRange
	for(DWORD idx = 0; idx < totalSubKeys; idx++)
	{
		//(Re)initialize variables
		HKEY tempRegKey = NULL;
		DWORD tempORValue = NULL;
		WCHAR tempRegKeyName[MAX_WCHAR_ARR];
		dwSize = 1024;

		std::wcout << "Probing subkey idx: " << idx << std::endl;
		//Get name of a subkey
		opRes = RegEnumKeyEx(lgProfKey, idx, tempRegKeyName, &dwSize, NULL, NULL, NULL, NULL);
		if(opRes != ERROR_SUCCESS)
		{	
			std::wcout << L"Non-critical error in function \"probeRegistry()\" RegEnumKeyEx()." << std::endl;
			std::wcout << L"Error code returned: " << opRes << std::endl;
			continue;
		}

		std::wcout << "Opening subkey idx: " << idx << " Name: " << tempRegKeyName << std::endl;
		//Open that subkey
		opRes = RegOpenKeyEx(lgProfKey, tempRegKeyName, NULL, KEY_ALL_ACCESS, &tempRegKey);
		if(opRes != ERROR_SUCCESS)
		{	
			std::wcout << L"Non-critical error in function \"probeRegistry()\" RegOpenKeyEx()." << std::endl;
			std::wcout << L"Error code returned: " << opRes << std::endl;
			continue;
		}
	
		std::wcout << "Reading data from subkey idx: " << idx << " HKEY: " << tempRegKey << std::endl;
		//Find if there is a DWORD OperatingRange value present
		opRes = RegQueryValueEx(tempRegKey, L"OperatingRange", NULL, &dwType, (LPBYTE)&tempORValue, &dwSize);
		if(opRes != ERROR_SUCCESS)
		{	
			std::wcout << L"Non-critical error in function \"probeRegistry()\" RegQueryValueEx()." << std::endl;
			std::wcout << L"Error code returned: " << opRes << std::endl;
			continue;
		}

		if(tempORValue != NULL)
		{
			std::wcout << "OperatingRange found!" << std::endl;
			wcscpy(validRegEntries[valRegEntriesIdx++], tempRegKeyName);
		}

		RegCloseKey(tempRegKey);
	}


	std::wcout << "Registry probing complete. Number of valid entries: " << valRegEntriesIdx << std::endl;
	std::wcout << "Names of valid subkeys:" << std::endl;
	for(DWORD idx = 0; idx < valRegEntriesIdx; idx++)
	{
		std::wcout << idx+1 << ") " << validRegEntries[idx] << std::endl;
	}

	if(valRegEntriesIdx == 0)
	{
		return false;
	}
	return true;
}

/** Processes data read from .con file
* and returns it as an integer
*/
int getWheelTurnFromData(unsigned char turnData[3])
{
	int addVal = 0;
	//3rd byte is a flag byte, so let's see what value it has
	if(turnData[2] == 66)	//3rd byte set to 66, wheel range is from 90 to 127 deg
	{
		return turnData[1]/2;
	}
	else if(turnData[2] == 67)	//3rd byte set to 67, wheel range is from 128 to 511
	{
		if(turnData[0] == 128)
		{
			addVal = 1;
		}
		if(turnData[1] < 129)
		{
			return turnData[1] + 128 + addVal;
		}
		else
		{
			return 2 * (turnData[1] - 128) + 256 + addVal;
		}
	}
	else if(turnData[2] == 68)	//3rd byte set to 38, wheel range is from 512 to 900
	{
		if(turnData[0] == 64)
		{
			addVal = 1;
		}
		else if(turnData[0] == 128)
		{
			addVal = 2;
		}
		else if(turnData[0] == 192)
		{
			addVal = 3;
		}
		return 4 * (turnData[1]) + 512 + addVal;
	}
  
	return 0;
}

/** Gets initial wheel turn values from .con files,
* we need them to monitor changes of wheel turn values
* user will make
*/
void getInitialWTFromLFS()
{
	//Iterate through all .con files stored in filesInMisc and look for
	//changes on the wheel turn value
	for(unsigned int idx = 0; idx < filesInMisc.size(); idx++)
	{
		std::wstring fullFileName = L"";
		fullFileName.append(prependPath);
		fullFileName.append(filesInMisc.at(idx));
		std::wcout << "Opening file " << fullFileName.c_str() << std::endl;

		//Open *.con for reading and get it's contents
		std::ifstream fl(fullFileName.c_str(), std::ios::in);
		fl.seekg(0, std::ios::end);
		size_t fileLength = fl.tellg();
		if(fileLength == 4294967295)
		{
			std::wcout << "Cannot open file " << filesInMisc.at(idx) << std::endl;
			allWTdata = 0;
			continue;
		}
		char* fileCon = new char[fileLength];
  
		//Read data
		fl.seekg(0, std::ios::beg);
		fl.read(fileCon, fileLength);
		fl.close();

		//Data read, now get offset 9, 10 and 11 from *.con
		unsigned char* turnData = new unsigned char[3];
		turnData[0] = fileCon[9];
		turnData[1] = fileCon[10];
		turnData[2] = fileCon[11];
  
		//std::cout << turnData[0] << " " << turnData[1] << " " << turnData[2] << std::endl;
  
		std::wcout << "Initial wheel turn in file: " << filesInMisc.at(idx) << ": " << getWheelTurnFromData(turnData) << std::endl;

		allWTdata[idx] =  getWheelTurnFromData(turnData);
	}
}
/** Reads all .con files and if there is
* a difference between last known and current
* value of wheel turn, returns the new value, otherwise
* returns -1
*/
int getWTFromLFS()
{
	int wheelTurnDataToReturn = 0;
	//Iterate through all .con files stored in filesInMisc and look for
	//changes on the wheel turn value
	for(unsigned int idx = 0; idx < filesInMisc.size(); idx++)
	{
		std::wstring fullFileName = L"";
		fullFileName.append(prependPath);
		fullFileName.append(filesInMisc.at(idx));

		//Open *.con for reading and get it's contents
		std::ifstream fl(fullFileName.c_str(), std::ios::in);
		fl.seekg(0, std::ios::end);
		size_t fileLength = fl.tellg();
		if(fileLength == 4294967295)
		{
			std::wcout << "Cannot open desired " << filesInMisc.at(idx) << " file" << std::endl;
			return -1;
		}
		char* fileCon = new char[fileLength];
  
		//Read data
		fl.seekg(0, std::ios::beg);
		fl.read(fileCon, fileLength);
		fl.close();

		//Data read, now get offset 9, 10 and 11 from *.con
		unsigned char* turnData = new unsigned char[3];
		turnData[0] = fileCon[9];
		turnData[1] = fileCon[10];
		turnData[2] = fileCon[11];
  
		//std::cout << turnData[0] << " " << turnData[1] << " " << turnData[2] << std::endl;
  
		//std::wcout << getWheelTurnFromData(turnData) << std::endl;

		//Check if the wheel turn data has changes since the last time
		wheelTurnDataToReturn = getWheelTurnFromData(turnData);

		if(wheelTurnDataToReturn != allWTdata[idx]) //In has, so let's set a new wheel turn
		{
			std::wcout << "Wheel turn value in file " << fullFileName << " changed from " << allWTdata[idx] << "to " << wheelTurnDataToReturn << std::endl;
			allWTdata[idx] = wheelTurnDataToReturn;
			return wheelTurnDataToReturn;
		}
	}

	//No change found
	return -1;
}

/** Attempts to store new wheel turn value to registry
*/
int hackRegistry(int wheelTurn)
{
	for(DWORD idx = 0; idx < valRegEntriesIdx; idx++)
	{
		//Open registry key
		HKEY settingsKey = NULL;

		opRes = RegOpenKeyEx(lgProfKey, validRegEntries[idx], NULL, KEY_ALL_ACCESS, &settingsKey);
		//std::wcout << logiKey << " " << res << std::endl ;
		if(opRes != ERROR_SUCCESS)
		{	
			std::wcout << L"Error opening registry key." << std::endl;
			return -1;
		}	

		DWORD currentValue;
		//Registry key opened, let's get the value of OperatingRange
		opRes = RegQueryValueEx(settingsKey, L"OperatingRange", 0, &dwType, (LPBYTE)&currentValue, &dwSize);
		//std::wcout << "Current wheel range: " << currentValue << std::endl;
		if(opRes != ERROR_SUCCESS)
		{
			std::wcout << L"Error retrieving wheel range value." << std::endl;
			return -1;
		}

		//std::wcout << "Current wheel turn: " << currentValue << std::endl;

		//Now we know there is a value we want to change, co let's do just that
		DWORD newWheelRange = wheelTurn;
		opRes = RegSetValueEx(settingsKey, L"OperatingRange", 0, dwType, (LPBYTE)&newWheelRange, dwSize);
		if(opRes != ERROR_SUCCESS)
		{
			std::wcout << L"Error setting new wheel range." << std::endl;
			return -1;
		}

		RegCloseKey(settingsKey);
	}

	return 0;
}

int _tmain(int argc, _TCHAR* argv[])
{
	//Greet the user
	std::wcout << "Starting Logitech Wheel Turn Hack v0.01, fasten your seatbelts..." << std::endl;
	HWND lfsHWnd = NULL;
	HWND lgProfHWnd = FindWindow(NULL, L"Logitech Profiler");
	HWND desktopHWnd = GetDesktopWindow();

	//Search the registry for the LGS entries we need
	if(!probeRegistry())
	{
		std::wcout << "Critical: No valid registry entries found!" << std::endl;
		return -1;
	}

	//Search LFS dir for the .con files we need
	if(!probeMiscDirectory())
	{
		return -1;
	}

	//Go through the .con files and read current wheel turn data from each file
	allWTdata = new int[filesInMisc.size()];
	getInitialWTFromLFS();


	std::wcout << "Waiting for LFS to start..." << std::endl;

	while(lfsHWnd == NULL)
	{
		lfsHWnd = FindWindow(L"LFS", NULL);
	}

	std::wcout << "We're all set, let's go!" << std::endl;
	/*if(lgProfHWnd == NULL)
	{
		std::wcout << "Cannot get Logitech Profiler window handle. Is Logitech Profiler running?" << std::endl;
		return -1;
	}*/

	while(true)
	{
		Sleep(1500);
		int wheelTurn = getWTFromLFS();
		if(wheelTurn == -1)
		{
			continue;
		}
		else
		{
			std::wcout << "Attempting to change wheel turn" << std::endl;
			hackRegistry(wheelTurn);

			ShowWindow(lfsHWnd, SW_FORCEMINIMIZE);
			Sleep(1500);
			ShowWindow(lfsHWnd, SW_RESTORE);
		}
	}

	std::wcout << "Still with me? Wow, I must have done a better job than I thought then..." << std::endl;

	WCHAR x;
	std::wcin >> x;

	return 0;
}



/** I am the one, who lost control,
* but in the end I'll be the
* Last Man Standing... (HammerFall)
*/