####	DRIFT METER
####	==========
####	Version 2

####	For Lapper V5.853 and later

####	by Sinanju / [DUB]Azzy / Updated By Gai-Luron for new catch features

####	Original Drift Meter and re-coding by Sinanju
####	Messaging idea / some coding by [DUB]Azzy

####	Thanks to Gui-luron, Yisc[NL] and Tim[NL]
####	For Lapper program, coding, patience and perseverance

#####################################################


##################
#Drifting options#
##################
#
#		IMPORTANT
#		==========
#	Drift option on !GUI must be set to Yes
#

$DriftDatabase = "./DriftPB";
$MinimumDriftSpeed = 25; # Minimum speed in km/h to maintain. Driving below that speed will reset score (25kmph is approx 16MPH)
$MinimumDriftAngle = 5; # Minimum angel to maintain. When angle is below value, score is reset
$MaximumDriftAngle = 75; # Maximum angel to maintain. When angle is above value, score is reset
$GoodDriftScore = 3000; # Value to be reached to execute action on good drift score
$MinimumDriftScore = 100; # Minimum drift score required

CatchEvent OnGoodDrift( $userName ) # Player event
	closePrivButton( "driftcomboboxtexttopmessage0&driftcomboboxtexttopmessage&driftcomboboxtexttopmessage1" );
	globalMsg( langEngine( "%{main_ongooddrift}%" ,GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("LastDriftScore") ) );
	openPrivButton( "driftcomboboxtexttopmessage2",85,19,30,5,3,8,16,langEngine( "%{driftmeter_driftcomboboxtexttopmessage2}%") );
EndCatchEvent



CatchEvent OnDriftLap( $userName ) # Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.
	globalMsg( langEngine( "%{driftmeter_driftlap}%" , GetCurrentPlayerVar("NickName"), GetCurrentPlayerVar("DriftScore")));
EndCatchEvent

CatchEvent OnDriftPB( $userName ) # Actions to do on new personal best drift lap.
	PrivRcm( langEngine( "%{driftmeter_newdriftpb}%" , GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("DriftScore")));
EndCatchEvent


CatchEvent OnDriftScore( $userName ) # This is the section for displaying the Drift Meter and Drift Messages

	$AngleVelocity = GetCurrentPlayerVar( "AngleVelocity" );
	$DriftScore = GetCurrentPlayerVar( "DriftScore" );
	$LastDriftScore = GetCurrentPlayerVar( "LastDriftScore" );

	openPrivButton( "mylogo",5,138,22,3,1,-1,16,langEngine( "%{driftmeter_mylogo}%" ));
	openPrivButton( "driftboxback",5,137,22,35,4,-1,32," ");
	openPrivButton( "driftanglebox",6,146,10,20,4,-1,32," ");
	openPrivButton( "driftcombbox",16,146,10,10,3,-1,32," ");
	openPrivButton( "driftscorebox",16,156,10,10,3,-1,32," ");
	openPrivButton( "driftangleboxtext",6,146,10,5,3,-1,0,langEngine( "%{driftmeter_driftangleboxtext}%" ));
	openPrivButton( "driftcomboboxtext",16,146,10,5,3,-1,0,langEngine( "%{driftmeter_driftcomboboxtext}%" ));
	openPrivButton( "driftscoreboxtext",16,156,10,5,3,-1,0,langEngine( "%{driftmeter_driftscoreboxtext}%" ));

	openPrivButton( "TDSM",6,140,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM}%" ) );

	openPrivButton( "driftcomboboxtexttop",85,1,30,7,4,-1,96,langEngine( "%{driftmeter_driftcomboboxtexttop}%" , $DriftScore ) );

	IF( $AngleVelocity < 0 )

	THEN
		$AngleVelocity = -$AngleVelocity ;

		SetCurrentPlayerVar("Angle_Reverse",$AngleVelocity);

		closePrivButton( "driftangle&driftzeroangleboxtext&driftzerocomboboxtext&driftzeroscoreboxtext&driftscoretext&driftcombotext&driftangleboxtextanglerev&driftangleboxtextangle");
		openPrivButton( "driftangleboxtextanglerev",9,152,6,5,3,-1,0,langEngine( "%{driftmeter_driftangleboxtextangle}%" ));
		openPrivButton( "driftanglerev",6,153,10,12,3,-1,64,langEngine( "%{driftmeter_driftanglerevbox}%" , GetCurrentPlayerVar( "Angle_Reverse")));
		openPrivButton( "driftscoretextrev",16,160,9,5,3,-1,0,langEngine( "%{driftmeter_driftscoretext}%" , $LastDriftScore ) );
		openPrivButton( "driftcombotextrev",17,150,9,7,3,-1,0,langEngine( "%{driftmeter_driftcombotext}%" , $DriftScore ) );

	ELSE

		closePrivButton( "driftanglerev&driftzeroangleboxtext&driftzerocomboboxtext&driftzeroscoreboxtext&driftscoretextrev&driftcombotextrev&driftangleboxtextanglerev&driftangleboxtextangle");
		openPrivButton( "driftangleboxtextangle",11,152,5,5,3,-1,128,langEngine( "%{driftmeter_driftangleboxtextangle}%" ));
		openPrivButton( "driftangle",6,154,10,12,3,-1,64,langEngine( "%{driftmeter_driftanglebox}%" , $AngleVelocity ));
		openPrivButton( "driftscoretextrev",16,160,9,5,3,-1,0,langEngine( "%{driftmeter_driftscoretext}%" , $LastDriftScore ) );
		openPrivButton( "driftcombotextrev",17,150,9,7,3,-1,0,langEngine( "%{driftmeter_driftcombotext}%" , $DriftScore ) );

	ENDIF


############    This section is for the messages and symbols invoked depending on the individual scores you make, and appear on the Drift Meter at bottom of screen

##	Scoring totals = message

## 	< 150 = rubbish (garbage/sucks)
##	> 150 = adequate
## 	> 300 = ok
## 	> 450 = good
## 	> 750 = great
## 	> 1200 = fantastic
## 	> 1950 = superb
## 	> 3150 = awesome
## 	> 5100 = insane

#	numbers can be changed if you think too high or too low - NO need to change anything else, unless you want to change the message in the LANG section(s)



	IF( $LastDriftScore > 150 )
	THEN

		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSLR&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

			openPrivButton( "TDSM2",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM2}%" ) );

		openPrivButton( "TDS21",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS21}%" ) );
		openPrivButton( "TDS22",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS22}%" ) );
		openPrivButton( "TDS23",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS23}%" ) );
		openPrivButton( "TDS24",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS24}%" ) );
		openPrivButton( "TDS25",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS25}%" ) );

	ENDIF

	IF( $LastDriftScore > 300 )
	THEN

		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

			openPrivButton( "TDSM3",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM3}%" ) );

		openPrivButton( "TDS31",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS31}%" ) );
		openPrivButton( "TDS32",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS32}%" ) );
		openPrivButton( "TDS33",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS33}%" ) );
		openPrivButton( "TDS34",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS34}%" ) );
		openPrivButton( "TDS35",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS35}%" ) );
	ENDIF

	IF( $LastDriftScore > 450 )
	THEN

		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

			openPrivButton( "TDSM4",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM4}%" ) );

		openPrivButton( "TDS41",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS41}%" ) );
		openPrivButton( "TDS42",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS42}%" ) );
		openPrivButton( "TDS43",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS43}%" ) );
		openPrivButton( "TDS44",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS44}%" ) );
		openPrivButton( "TDS45",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS45}%" ) );
	ENDIF

	IF( $LastDriftScore > 750 )
	THEN

		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM5",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM5}%" ) );

		openPrivButton( "TDS51",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS51}%" ) );
		openPrivButton( "TDS52",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS52}%" ) );
		openPrivButton( "TDS53",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS53}%" ) );
		openPrivButton( "TDS54",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS54}%" ) );
		openPrivButton( "TDS55",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS55}%" ) );

	ENDIF

	IF( $LastDriftScore > 1200 )
	THEN

		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM6",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM6}%" ) );

		openPrivButton( "TDS61",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS61}%" ) );
		openPrivButton( "TDS62",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS62}%" ) );
		openPrivButton( "TDS63",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS63}%" ) );
		openPrivButton( "TDS64",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS64}%" ) );
		openPrivButton( "TDS65",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS65}%" ) );

	ENDIF

	IF( $LastDriftScore > 1950 )
	THEN
		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM7",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM7}%" ) );

		openPrivButton( "TDS71",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS71}%" ) );
		openPrivButton( "TDS72",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS72}%" ) );
		openPrivButton( "TDS73",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS73}%" ) );
		openPrivButton( "TDS74",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS74}%" ) );
		openPrivButton( "TDS75",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS75}%" ) );

	ENDIF

	IF( $LastDriftScore > 3150 )
	THEN
		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM8",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM8}%" ) );

		openPrivButton( "TDS81",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS81}%" ) );
		openPrivButton( "TDS82",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS82}%" ) );
		openPrivButton( "TDS83",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS83}%" ) );
		openPrivButton( "TDS84",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS84}%" ) );
		openPrivButton( "TDS85",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS85}%" ) );
	ENDIF

	IF( $LastDriftScore > 5100 )
	THEN
		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM9",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM9}%" ) );

		openPrivButton( "TDS91",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS91}%" ) );
		openPrivButton( "TDS92",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS92}%" ) );
		openPrivButton( "TDS93",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS93}%" ) );
		openPrivButton( "TDS94",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS94}%" ) );
		openPrivButton( "TDS95",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS95}%" ) );
	ENDIF

	IF( $LastDriftScore < 150 )
	THEN
		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM1",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM1}%") );

		openPrivButton( "TDS11",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS11}%" ) );
		openPrivButton( "TDS12",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS12}%" ) );
		openPrivButton( "TDS13",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS13}%" ) );
		openPrivButton( "TDS14",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS14}%" ) );
		openPrivButton( "TDS15",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS15}%" ) );

	ENDIF

	IF( $LastDriftScore < 50 )
	THEN
		closePrivButton( "TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
		closePrivButton( "TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
		closePrivButton( "TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
		closePrivButton( "TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
		closePrivButton( "TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
		closePrivButton( "TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
		closePrivButton( "TDS01&TDS02&TDS03&TDS04&TDS05" );

		openPrivButton( "TDSM0",6,141,20,4,2,-1,16,langEngine( "%{driftmeter_TDSM0}%") );

		openPrivButton( "TDS01",6,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS01}%" ) );
		openPrivButton( "TDS02",10,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS02}%" ) );
		openPrivButton( "TDS03",14,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS03}%" ) );
		openPrivButton( "TDS04",18,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS04}%" ) );
		openPrivButton( "TDS05",22,167,4,4,2,-1,16,langEngine( "%{driftmeter_TDS05}%" ) );

	ENDIF

############    This section is for the messages invoked depending on the combined lap score you make, and appears at top of screen

##	Scoring totals = message

## 	< 400 = rubbish (garbage/sucks)
##	> 400 = barely adequate
## 	> 600 = adequate
## 	> 1250 = good
## 	> 2750 = superb
## 	> 5750 = outrageous
## 	> 11750 = insane
## 	> 15000 = drifting royalty
## 	> 20000 = drifting god
## 	> 30000 = we are not worthy

#	numbers can be changed if you think too high or too low - NO need to change anything else, unless you want to change the message in the LANG section(s)

	IF( $DriftScore > 400 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift399_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftbarelyadequate}%") );
	ENDIF

	IF( $DriftScore > 600 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift500_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftadequate}%") );
	ENDIF

	IF( $DriftScore > 1250 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift1000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftgood}%") );
	ENDIF

	IF( $DriftScore > 2750 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift2000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftsuperb}%") );
	ENDIF

	IF( $DriftScore > 5750 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift5000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftoutrageous}%") );
	ENDIF

	IF( $DriftScore > 11750 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift10000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftinsane}%") );
	ENDIF

	IF( $DriftScore > 15000 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift15000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftroyalty}%") );
	ENDIF

	IF( $DriftScore > 20000 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift20000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftgod}%") );
	ENDIF

	IF( $DriftScore > 30000 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift30000_1",85,9,30,5,3,-1,32,langEngine( "%{driftmeter_driftnotworthy}%") );
	ENDIF

	IF( $DriftScore < 400 )
	THEN
		closePrivButton( "driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&drift399_1&drift400_1&drift500_1&drift1000_1&drift2000_1&drift5000_1&drift10000_1&drift15000_1&drift20000_1&drift30000_1" );
		openPrivButton( "drift400_1",85,9,30,5,3,-1,0,langEngine( "%{driftmeter_drifttolow}%") );
	ENDIF

EndCatchEvent


################################

Lang "EN"

	driftmeter_TDS01 = "^8?";
	driftmeter_TDS02 = "^8?";
	driftmeter_TDS03 = "^8?";
	driftmeter_TDS04 = "^8?";
	driftmeter_TDS05 = "^8?";

	driftmeter_TDS11 = "^0:(";
	driftmeter_TDS12 = "^0:(";
	driftmeter_TDS13 = "^0:(";
	driftmeter_TDS14 = "^0:(";
	driftmeter_TDS15 = "^0:(";

	driftmeter_TDS21 = "^2+";
	driftmeter_TDS22 = "^2+";
	driftmeter_TDS23 = "^2+";
	driftmeter_TDS24 = "^2+";
	driftmeter_TDS25 = "^2+";

	driftmeter_TDS31 = "^3++";
	driftmeter_TDS32 = "^3++";
	driftmeter_TDS33 = "^3++";
	driftmeter_TDS34 = "^3++";
	driftmeter_TDS35 = "^3++";

	driftmeter_TDS41 = "^4*";
	driftmeter_TDS42 = "^4*";
	driftmeter_TDS43 = "^4*";
	driftmeter_TDS44 = "^4*";
	driftmeter_TDS45 = "^4*";

	driftmeter_TDS51 = "^5**";
	driftmeter_TDS52 = "^5**";
	driftmeter_TDS53 = "^5**";
	driftmeter_TDS54 = "^5**";
	driftmeter_TDS55 = "^5**";

	driftmeter_TDS61 = "^6:)";
	driftmeter_TDS62 = "^6*";
	driftmeter_TDS63 = "^6:)";
	driftmeter_TDS64 = "^6*";
	driftmeter_TDS65 = "^6:)";

	driftmeter_TDS71 = "^7!";
	driftmeter_TDS72 = "^7!";
	driftmeter_TDS73 = "^7!";
	driftmeter_TDS74 = "^7!";
	driftmeter_TDS75 = "^7!";

	driftmeter_TDS81 = "^8!!";
	driftmeter_TDS82 = "^8!!";
	driftmeter_TDS83 = "^8!!";
	driftmeter_TDS84 = "^8!!";
	driftmeter_TDS85 = "^8!!";

	driftmeter_TDS91 = "^1:)";
	driftmeter_TDS92 = "^1:)";
	driftmeter_TDS93 = "^1:)";
	driftmeter_TDS94 = "^1:)";
	driftmeter_TDS95 = "^1:)";

	driftmeter_TDSM = "^7How's my drifting?";
	driftmeter_TDSM0 = "^8How's my drifting?";
	driftmeter_TDSM1 = "^0That was rubbish!";
	driftmeter_TDSM2 = "^2That was adequate";
	driftmeter_TDSM3 = "^3That was ok";
	driftmeter_TDSM4 = "^4That was good";
	driftmeter_TDSM5 = "^5That was great";
	driftmeter_TDSM6 = "^6That was fantastic";
	driftmeter_TDSM7 = "^7That was superb";
	driftmeter_TDSM8 = "^8That was awesome";
	driftmeter_TDSM9 = "^1That was insane";

	driftmeter_driftbarelyadequate = "^3Barely any drifting skills";
	driftmeter_driftadequate = "^3Adequate drifting skills";
	driftmeter_driftgood = "^4Some good drifting skills";
	driftmeter_driftsuperb = "^5Some superb drifting skills!";
	driftmeter_driftoutrageous = "^6Outrageous drifting skills!";
	driftmeter_driftinsane = "^7Insane drifting!";
	driftmeter_driftroyalty = "^0DRIFT ROYALTY!";
	driftmeter_driftgod = "^1You are officially a%nl%^1! DRIFTING GOD !";
	driftmeter_driftnotworthy = "^0We are ^1NOT ^0worthy!";

	driftmeter_mylogo = "^1Put your individual/team logo here"; # Change message between quote marks to suit

	driftmeter_driftanglebox = "^3< ^7{0}";
	driftmeter_driftangleboxtext = "^8Drift Angle:";
	driftmeter_driftangleboxtextangle = "^1o";
	driftmeter_driftanglerevbox = "^7{0} ^2>";
	driftmeter_driftcombotext = "^7{0}";
	driftmeter_driftcomboboxtext = "^8Combo Score:";
	driftmeter_driftcomboboxtexttop = "^2Total Drift Score ^3this lap: ^7{0}";
	driftmeter_driftcomboboxtexttopmessage = "^3Absolutely%nl%^1rubbish ^3drifting";
	driftmeter_driftcomboboxtexttopmessage2 = "^3Great drifting";
	driftmeter_driftscoretext = "^1+ ^7{0}";
	driftmeter_driftscoreboxtext = "^8This Score:";
	driftmeter_drifttolow = "{0}^3 disqualified";

	driftmeter_driftlap = "{0} ^3drifted to ^7{1} ^3pts";
	driftmeter_newdriftpb = "{0}^3 made new PB: ^7{1} ^3pts!";
	driftmeter_ongooddrift = "{0} ^3made excellent drift: ^7{1} ^3pts";

EndLang

Lang "FR"
	driftmeter_TDSM = "^7Comment est mon drift?";
	driftmeter_TDSM0 = "^8Comment est mon drift?";
	driftmeter_TDSM1 = "^0C'est de la crotte!";
	driftmeter_TDSM2 = "^2C'est Suffisant";
	driftmeter_TDSM3 = "^3C'est ok";
	driftmeter_TDSM4 = "^4C'est bon";
	driftmeter_TDSM5 = "^5C'est grand";
	driftmeter_TDSM6 = "^6C'est fantastique";
	driftmeter_TDSM7 = "^7C'est superbe";
	driftmeter_TDSM8 = "^8C'est génial";
	driftmeter_TDSM9 = "^1C'est incroyable";

	driftmeter_driftbarelyadequate = "^3Drift insuffisants";
	driftmeter_driftadequate = "^3Drifts moyens";
	driftmeter_driftgood = "^4Quelques bons drifts";
	driftmeter_driftsuperb = "^5Quelques drifts superbes!";
	driftmeter_driftoutrageous = "^6Des drifts géniaux!";
	driftmeter_driftinsane = "^7Des drifts incroyables!";

	driftmeter_driftroyalty = "^0DRIFT ROYAL!";
	driftmeter_driftgod = "^1Vous êtes officiellement un%nl%^1! BON DRIFTEUR !";
	driftmeter_driftnotworthy = "^0Nous êtes ^1NOT ^0indigne!";

	driftmeter_mylogo = "^1Votre logo individuel/team ici"; # Message de changement entre guillemets en fonction de

	driftmeter_driftanglebox = "^3< ^7{0}";
	driftmeter_driftangleboxtext = "^8Angle drift:";
	driftmeter_driftangleboxtextangle = "^1o";
	driftmeter_driftanglerevbox = "^7{0} ^2>";
	driftmeter_driftcombotext = "^7{0}";
	driftmeter_driftcomboboxtext = "^8Points Combo:";
	driftmeter_driftcomboboxtexttop = "^2Points totaux ^3Ce tour: ^7{0}";
	driftmeter_driftcomboboxtexttopmessage = "^3Vraiment drift%nl%^1merde";
	driftmeter_driftcomboboxtexttopmessage2 = "^3Du grand drift";
	driftmeter_driftscoretext = "^1+ ^7{0}";
	driftmeter_driftscoreboxtext = "^8Points:";
	driftmeter_drifttolow = "{0}^3 disqualifié";

	driftmeter_newdriftpb = "{0}^3 rÃ©alise un nouveau PB: ^7{1} ^3pts!";
	driftmeter_driftlap = "{0} ^3rÃ©alise ^7{1} ^3pts de drift";
	driftmeter_ongooddrift = "{0} ^3rÃ©alise un drift excellent: ^7{1} ^3pts";

EndLang
Lang "NL" # NL Language made by $!N-Tim (emit-nl)
 driftmeter_TDSM = "^7Hoe drift ik?";
 driftmeter_TDSM0 = "^8Hoe drift ik?";
 driftmeter_TDSM1 = "^0Dat was niks..";
 driftmeter_TDSM2 = "^2Dat was matig";
 driftmeter_TDSM3 = "^3Dat was oke";
 driftmeter_TDSM4 = "^4Dat was goed";
 driftmeter_TDSM5 = "^5Dat was erg goed";
 driftmeter_TDSM6 = "^6Dat was geweldig";
 driftmeter_TDSM7 = "^7Dat was fantastisch";
 driftmeter_TDSM8 = "^8Dat was helemaal te gek!";
 driftmeter_TDSM9 = "^1Dat was SUPERB!!";
 driftmeter_driftbarelyadequate = "^3Bijna geen drift skills";
 driftmeter_driftadequate = "^3Matige drift skills";
 driftmeter_driftgood = "^4Goede drift skills";
 driftmeter_driftsuperb = "^5Geweldige drift skills";
 driftmeter_driftoutrageous = "^6Fantastische drift skills";
 driftmeter_driftinsane = "^7Helemaal te gekke drift skills!";
 driftmeter_driftroyalty = "^0DRIT ROALITY!";
 driftmeter_driftgod = "^1Je bent een officiële%nl%^1! DRIFTING GOD !";
 driftmeter_driftnotworthy = "^0Wij zijn het ^1NIET ^0waard!";
 driftmeter_mylogo = "^1Zet jouw logo hier"; # Change message between quote marks to suit
 driftmeter_driftanglebox = "^3< ^7{0}";
 driftmeter_driftangleboxtext = "^8Drift Hoek:";
 driftmeter_driftangleboxtextangle = "^1o";
 driftmeter_driftanglerevbox = "^7{0} ^2>";
 driftmeter_driftcombotext = "^7{0}";
 driftmeter_driftcomboboxtext = "^8Combo Score:";
 driftmeter_driftcomboboxtexttop = "^2Totale Drift Score ^3in deze ronde: ^7{0}";
 driftmeter_driftcomboboxtexttopmessage = "^3Absolute%nl%^1rotzooi ^3drift..";
 driftmeter_driftcomboboxtexttopmessage2 = "^3Geweldige drift";
 driftmeter_driftscoretext = "^1+ ^7{0}";
 driftmeter_driftscoreboxtext = "^8Deze Score:";
 driftmeter_drifttolow = "{0}^3 is gediskwalificeerd";
 driftmeter_driftlap = "{0} ^3drifte naar^7{1} ^3pts";
 driftmeter_newdriftpb = "{0}^3 heeft een nieuw PB: ^7{1} ^3pts!";
 driftmeter_ongooddrift = "{0} ^3maakte een hele nette drift: ^7{1} ^3pts";
EndLang
Lang "NO" #Translated by Carlos/DenonForce14
    driftmeter_TDSM = "^7Hvordan drifter jeg?";
    driftmeter_TDSM0 = "^8Hvordan er driftinga mi?";
    driftmeter_TDSM1 = "^0Det var dårlig!";
    driftmeter_TDSM2 = "^2Det var relevant";
    driftmeter_TDSM3 = "^3Det var helt ok";
    driftmeter_TDSM4 = "^4Det var bra";
    driftmeter_TDSM5 = "^5Det var utrolig!";
    driftmeter_TDSM6 = "^6Det var fantastisk";
    driftmeter_TDSM7 = "^7Det var superbra";
    driftmeter_TDSM8 = "^8Det var helt legendarisk";
    driftmeter_TDSM9 = "^1Du er reine Drift King!";

    driftmeter_driftbarelyadequate = "^3Du kan ikke drifte!";
    driftmeter_driftadequate = "^3Du har relevante drifteskills";
    driftmeter_driftgood = "^4Du begynner å bli bedre!";
    driftmeter_driftsuperb = "^5Du begynner å ta ledelsen!";
    driftmeter_driftoutrageous = "^6Utrolig drifting!";
    driftmeter_driftinsane = "^7Sinnsyk drifting";
    driftmeter_driftroyalty = "^0DRIFT KING!";
    driftmeter_driftgod = "^1Du er en offisiell %nl%^1! DRIFTEGUD !";
    driftmeter_driftnotworthy = "^Vi er ^1IKKE ^0verdt det!";

    driftmeter_mylogo = "^1Putt din teamlogo her"; # Change message between quote marks to suit

    driftmeter_driftanglebox = "^3< ^7{0}";
    driftmeter_driftangleboxtext = "^8Driftegrader:";
    driftmeter_driftangleboxtextangle = "^1o";
    driftmeter_driftanglerevbox = "^7{0} ^2>";
    driftmeter_driftcombotext = "^7{0}";
    driftmeter_driftcomboboxtext = "^8Combo Score:";
    driftmeter_driftcomboboxtexttop = "^2Totalt drifte score ^3denne runden: ^7{0}";
    driftmeter_driftcomboboxtexttopmessage = "^3Helt%nl%^1sinnsykt dårlig ^3drifting";
    driftmeter_driftcomboboxtexttopmessage2 = "^3Utmerket drifting";
    driftmeter_driftscoretext = "^1+ ^7{0}";
    driftmeter_driftscoreboxtext = "^8Denne scoringen:";
    driftmeter_drifttolow = "{0}^3 Diskvalifisert";

    driftmeter_driftlap = "{0} ^3driftet til ^7{1} ^3poeng";
    driftmeter_newdriftpb = "{0}^3gjorde ny banerekord: ^7{1} ^3poeng!";
    driftmeter_ongooddrift = "{0} ^3gjorde en utmerket drift: ^7{1} ^3poeng";

EndLang


