
####	DRIFT SKILLS
####	============

####	For Lapper V5.926 and later (may work with earlier versions)

####	idea by Ingolf (of Sweden)
####	basic coding by Sinanju (of Scotland)
          
#######################################################
#### 	Ver 0.1 - 24 Oct 2010 - Initial release (with bugs)
####	Ver 0.2 - 25 Oct 2010 - Converted laptime into number and changed button layout slightly - still some issues
#######################################################
####
####	ISSUES
####	======
####
####	Problems saving and outputting to a database
####	(suspect my coding!) so removed all trace of get/set database items
####
####	!DS TopUsers Table doesn't list cars / scores
####	- maybe lapper doesn't like 2 TopUsers tables?
####	Tim[NL]'s Points table also running in test config
####
####	As yet, untested in km/h mode
####
#######################################################
####
####	INFO
####	====
####	Add the following line into the /addonsused.lpr file
####
####	include( "./dskill.lpr");
####
######################################################


CatchEvent OnLap( $userName ) # Player event

  $NickName = GetCurrentPlayerVar("NickName");
  $DP = GetCurrentPlayerVar( "DriftScore" );
  $AS = GetCurrentPlayerVar( "AvgSpeed" ); # Average speed always measured in km/h
  $ASa = round(($AS*0.621371192),2); # Average speed converted to mph 
  $US = GetCurrentPlayerVar("UnitSpeed");
   
  $LT = NumToMSH(GetCurrentPlayerVar( "LapTime" ));
  $LP = (MSHToNum($LT)/1000);
                       
  $DS = round((100*(($DP+$AS)/($DP+$LP))),2); # Drift Score plus Average Speed divided by Drift Score plus Lap Time
  $DS1 = round(($DP/$LP),2); # Drift Score divided by Lap Time
  $DS2 = round(((100/$DP)*$AS),2); # 100 divided by Drift Score multiplied by Average Lap Speed
  $DS3 = round((($DP/$AS)*$LP),2); # Drift Score divided by Average Lap Speed multiplied Lap Time

	$DS4 = round((($DP/$LP)/10),2); # Drift Score divided by Laptime, with answer divided by 10 (this would be my second choice for Drift Skill Score)
	$DS5 = round(((($AS/$LP)*$DP)/4000),2); # Speed divided by Time, answer multiplied by Score, all divided by 4000 (this would be my first choice for Drift Skill Score)
	 
 	$topSpeed = ToPlayerUnit( GetCurrentPlayerVar( "BestSpeed" ));

	globalMsg( langEngine( "%{main_ds_msg}%",$NickName,$DS ));	# sms send to everyone

	### Set button and initial left/right and top/bottom coordinates ###
	$origL = 165;		# Left edge of button
	$origT = 100;		# Top edge of button
	$Width = 14;		# width of button
	$Height = 4;		# height of button
	$spacing = 4;		# text spacing
	$time = 8;			# display button for how many seconds (-1 = permanent)

	openPrivButton( "ds_back",$origL,$origT,$Width+15,$Height+45,$spacing,$time,16," ");
	openPrivButton( "ds_frnt",$origL+1,$origT+6,$Width+13,$Height+38,$spacing,$time,32," ");
	openPrivButton( "ds_name",$origL+2,$origT+1,$Width+11,$Height+1,$spacing+1,$time,0, $NickName); # player who will see board	

####  Button Labels
	openPrivButton( "ds_oads_label",$origL+2,$origT+7,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_oads_label}%")); # OverAll Drift Score
	openPrivButton( "ds_asfl_label",$origL+2,$origT+11,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_asfl_label}%")); # Average Speed For Lap (km/h))
	openPrivButton( "ds_asfla_label",$origL+2,$origT+15,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_asfla_label}%")); # Average Speed For Lap (mph))
	openPrivButton( "ds_avlt_label",$origL+2,$origT+19,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_avlt_label}%")); # Single Lap Time (in minutes/seconds)
  openPrivButton( "ds_drss_label",$origL+2,$origT+23,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_drss_label}%")); # Drift Skill Score
	openPrivButton( "ds_dss1_label",$origL+2,$origT+27,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_dss1_label}%")); # Drift Skill Score 1
	openPrivButton( "ds_dss2_label",$origL+2,$origT+31,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_dss2_label}%")); # Drift Skill Score 2
	openPrivButton( "ds_dss3_label",$origL+2,$origT+35,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_dss3_label}%")); # Drift Skill Score 3
	openPrivButton( "ds_dss4_label",$origL+2,$origT+39,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_dss4_label}%")); # Drift Skill Score 4
	openPrivButton( "ds_dss5_label",$origL+2,$origT+43,$Width,$Height,$spacing,$time,64,langEngine( "%{main_ds_dss5_label}%")); # Drift Skill Score 5

####  Score Buttons	  
	openPrivButton( "ds_oads",$origL+13,$origT+7,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_oads}%", $DP)); # OverAll Drift Score
	openPrivButton( "ds_asfl",$origL+13,$origT+11,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_asfl}%", $AS)); # Average Speed For Lap (km/h))
	openPrivButton( "ds_asfla",$origL+13,$origT+15,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_asfla}%", $ASa)); # Average Speed For Lap (mph))
	openPrivButton( "ds_avlt",$origL+13,$origT+19,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_avlt}%", $LT)); # Single Lap Time (in minutes/seconds)
  openPrivButton( "ds_drss",$origL+13,$origT+23,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_drss}%", $DS)); # Drift Skill Score
	openPrivButton( "ds_dss1",$origL+13,$origT+27,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_dss1}%", $DS1)); # Drift Skill Score 1
	openPrivButton( "ds_dss2",$origL+13,$origT+31,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_dss2}%", $DS2)); # Drift Skill Score 2
	openPrivButton( "ds_dss3",$origL+13,$origT+35,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_dss3}%", $DS3)); # Drift Skill Score 3
	openPrivButton( "ds_dss4",$origL+13,$origT+39,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_dss4}%", $DS4)); # Drift Skill Score 4
	openPrivButton( "ds_dss5",$origL+13,$origT+43,$Width,$Height,$spacing,$time,128,langEngine( "%{main_ds_dss5}%", $DS5)); # Drift Skill Score 5

EndCatchEvent


CatchEvent OnMSO( $userName, $text ) # Player event

	SWITCH( $command )

#	How to get Drift Skill Table

	CASE "!dskill":
	CASE "!dskills":
	CASE "!DSKILL":
	CASE "!DSKILLS":
		topUser( "^3Drift Skill Table","ds_score_total","DESC",argv ); #"DESC" or "ASC" Sort sum value descending or ascending - in this case descending
	BREAK;
		
	ENDSWITCH

EndCatchEvent


LANG "EN"

main_ds_msg = "{0} ^2has a Drift Skill Score of ^1{1}"; # where {0} = driver, and {1} = drift skill score

main_ds_oads_label = "^7Overall Drift Score";
main_ds_asfl_label = "^7Average Lap Speed";
main_ds_asfla_label = "^7Average Lap Speed";
main_ds_avlt_label = "^7Single Lap Time";
main_ds_drss_label = "^2Drift Skill Score";
main_ds_dss1_label = "^2Drift Skill Score 1";
main_ds_dss2_label = "^2Drift Skill Score 2";
main_ds_dss3_label = "^2Drift Skill Score 3";
main_ds_dss4_label = "^2Drift Skill Score 4";
main_ds_dss5_label = "^2Drift Skill Score 5";


main_ds_oads = "^1{0} ^7points";
main_ds_asfl = "^1{0} ^7km/h";
main_ds_asfla = "^1{0} ^7mph";
main_ds_avlt = "^1{0}";
main_ds_drss = "^1{0}";
main_ds_dss1 = "^1{0}";
main_ds_dss2 = "^1{0}";
main_ds_dss3 = "^1{0}";
main_ds_dss4 = "^1{0}";
main_ds_dss5 = "^1{0}";

built_score = "Percentage";

EndLang