
####	DRIFT SKILLS
####	============

####	For Lapper V5.926 and later (may work with earlier versions)

####	idea by Ingolf (of Sweden)
####	basic coding by Sinanju (of Scotland)
          
#######################################################
#### 	Ver 0.1 - 24 Oct 2010 - Initial release (with bugs)
#######################################################
####
####				ISSUES
####				======
####
####  Unable to convert (as yet) Laptime into a number.
####  Laptime to number conversion needed to use in 
####  any formula.
####
####	Problems saving and outputting to a database
####	(suspect my coding!)
####	so function will not work
####
####	!DS TopUsers Table doesn't list cars / scores
####	- maybe lapper doesn't like 2 TopUsers tables?
####	Tim[NL]'s Points table also running in test config
####
####	As yet, untested in km/h mode
####
####  Need to convert from mph to kph?
####  - may be needed otherwise kph scores
####  could be different to mph scores
####
#######################################################
####
####				INFO
####				====
####	Add the following line into the /addonsused.lpr file
####
####	include( "./dskill.lpr");
####
######################################################


CatchSub OnConnectClose( $KeyFlags,$id )
	  OnConnectClose_dskill();
EndCatchSub


Sub OnConnectClose_dskill()

	### Get UserName and search in dskill.dbs for saved values for this user ###
	$userName = GetCurrentPlayerVar( "UserName" );

 	SetCurrentPlayerVar( "ds_score_total", $DS), Getdskill( $userName . "ds_score_total", $DS );
 	SetCurrentPlayerVar(( "ds_driftscore_total",$DP),Getdskill( $userName . "ds_driftscore_total", $DP ) );
 	SetCurrentPlayerVar(( "ds_laptime_total",$LP),Getdskill( $userName . "ds_laptime_total", $LP ) );
 	SetCurrentPlayerVar(( "ds_avgspeed_total",$AS),Getdskill( $userName . "ds_avgspeed_total", $AS ) );
 	SetCurrentPlayerVar(( "ds_unitspeed_total",$US),Getdskill( $userName . "ds_unitspeed_total", $US ) );
 	SetCurrentPlayerVar(( "ds_skill1_total",$DS1),Getdskill( $userName . "ds_skill1_total", $DS1 ) );
 	SetCurrentPlayerVar(( "ds_skill2_total",$DS2),Getdskill( $userName . "ds_skill2_total", $DS2 ) );
 	SetCurrentPlayerVar(( "ds_skill3_total",$DS3),Getdskill( $userName . "ds_skill3_total", $DS3 ) );
 	SetCurrentPlayerVar(( "ds_speed_total",$topSpeed),Getdskill( $userName . "ds_speed_total", $topSpeed ) );

	### End ###

	### Set default values if no values are loaded ###
	IF ( GetCurrentPlayerVar( $DP ) == "")
	THEN
	  SetCurrentPlayerVar( $DP,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $LP ) == "")
	THEN
	  SetCurrentPlayerVar( $LP,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $AS ) == "")
	THEN
	  SetCurrentPlayerVar( $AS,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $US ) == "")
	THEN
	  SetCurrentPlayerVar( $US,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $DS ) == "")
	THEN
	  SetCurrentPlayerVar( $DS,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $DS1 ) == "")
	THEN
	  SetCurrentPlayerVar( $DS1,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $DS2 ) == "")
	THEN
	  SetCurrentPlayerVar( $DS2,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $DS3 ) == "")
	THEN
	  SetCurrentPlayerVar( $DS3,"0" );
	ENDIF

	IF ( GetCurrentPlayerVar( $topSpeed ) == "")
	THEN
	  SetCurrentPlayerVar( $topSpeed,"0" );
	ENDIF

EndSub


CatchEvent OnLap( $userName ) # Player event

	$NickName = GetCurrentPlayerVar("NickName");
  $DP = GetCurrentPlayerVar( "DriftScore" );
  $AS = GetCurrentPlayerVar( "AvgSpeed" ); # Average speed always measured in km/h
  $ASa = round(($AS*0.621371192),2); # Average speed converted to mph 
  $US = GetCurrentPlayerVar("UnitSpeed");
   
  $LP = NumToMSH(GetCurrentPlayerVar( "LapTime" ));


  $DS = round((100*(($DP+$AS)/($DP+$LP))),2); # Drift Score plus Average Speed divided by Drift Score plus Lap Time
#  $DS1 = round(($DP/$LP),2); # Drift Score divided by Lap Time
  $DS2 = round(((100/$DP)*$AS),2); # 100 divided by Drift Score multiplied by Average Lap Speed
#  $DS3 = round((($DP/$AS)*$LP),2); # Drift Score divided by Average Lap Speed multiplied Lap Time	 
  $topSpeed = ToPlayerUnit( GetCurrentPlayerVar( "BestSpeed" ));


# have to convert km/h to mph or overall scores will differ even if driver does same score/time/speed in mph compared to other in km/h

		#	1 kph = 0.621371192 mph
		#	1 mph = 1.609344 kph
    		
#	IF( GetCurrentPlayerVar( "UnitSpeed" ) != "mph" )  # nothing will work if == "km/h" or == "kmh" or != "mph"
#		THEN
#		  $AS = round(($AS*0.621371192),2);
#		  $US = round(($US*0.621371192),2);
#		  $DS = round(($DS*0.621371192),2);
#		  $DS1 = round(($DS1*0.621371192),2);
#		  $DS2 = round(($DS2*0.621371192),2);
#		  $DS3 = round(($DS3*0.621371192),2);		
#	ENDIF

#	IF( GetCurrentPlayerVar( "UnitSpeed" ) != "mph" )
#		THEN
#		  $AS = round(($AS/1.609344),2);
#		  $US = round(($US/1.609344),2);
#		  $DS = round(($DS/1.609344),2);
#		  $DS1 = round(($DS1/1.609344),2);
#		  $DS2 = round(($DS2/1.609344),2);
#		  $DS3 = round(($DS3/1.609344),2);	
#	ENDIF   
   
	globalMsg( langEngine( "%{main_ds_msg}%",$NickName,$DS ));	# sms send to everyone

	### Set button and initial left/right and top/bottom coordinates ###
	$origL = 165;			# Left edge of button
	$origT = 100;			# Top edge of button
	$Width = 25;			# width of button
	$Height = 4;			# height of button
	$spacing = 4;			# text spacing
	$time = 8;			# display button for how many seconds (-1 = permanent)

	openPrivButton( "ds_back",$origL,$origT,$Width+2,$Height+31,$spacing,$time,16," ");
	openPrivButton( "ds_name",$origL+1,$origT+1,$Width,$Height+1,$spacing+1,$time,0, $NickName); # player who will see board	
	openPrivButton( "ds_oads",$origL+1,$origT+6,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_oads}%", $DP)); # OverAll Drift Score
	openPrivButton( "ds_asfl",$origL+1,$origT+10,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_asfl}%", $AS)); # Average Speed For Lap (km/h))
	openPrivButton( "ds_asfla",$origL+1,$origT+14,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_asfla}%", $ASa)); # Average Speed For Lap (mph))
#	openPrivButton( "ds_avlt",$origL+1,$origT+14,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_avlt}%", $LP)); # Average Lap Time (in minutes)
	
  $laptime = MSHToNum(GetCurrentPlayerVar( "LapTime" );
  globalMsg( langEngine( "%{main_m2n_msg}%",$laptime); 	# debug message - can be removed when button proved to work	
  	
	openPrivButton( "ds_drss",$origL+1,$origT+18,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_drss}%", $DS)); # Drift Skill Score
	openPrivButton( "ds_dss1",$origL+1,$origT+22,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_dss1}%", $DS1)); # Drift Skill Score 1
	globalMsg( langEngine( "%{main_s1_msg}%",$NickName,$DS1 ));	# debug message - can be removed when button proved to work
	openPrivButton( "ds_dss2",$origL+1,$origT+26,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_dss2}%", $DS2)); # Drift Skill Score 2
	openPrivButton( "ds_dss3",$origL+1,$origT+30,$Width,$Height,$spacing,$time,32,langEngine( "%{main_ds_dss3}%", $DS3)); # Drift Skill Score 3
	globalMsg( langEngine( "%{main_s3_msg}%",$NickName,$DS3 ));	# debug message - can be removed when button proved to work

 	SetCurrentPlayerVar( "ds_score_total", $DS );
 	SetCurrentPlayerVar( "ds_driftscore_total",$DP );
 	SetCurrentPlayerVar( "ds_laptime_total", $LP );
 	SetCurrentPlayerVar( "ds_avgspeed_total", $AS );
 	SetCurrentPlayerVar( "ds_unitspeed_total",$US );
 	SetCurrentPlayerVar( "ds_skill1_total",$DS1 );
 	SetCurrentPlayerVar( "ds_skill2_total",$DS2 );
 	SetCurrentPlayerVar( "ds_skill3_total",$DS3 );
 	SetCurrentPlayerVar( "ds_speed_total",$topSpeed );

	setUserStoredValue( "ds_score_total",$DS );
	setUserStoredValue( "ds_driftscore_total",$DP );
	setUserStoredValue( "ds_laptime_total", $LP );
	setUserStoredValue( "ds_avgspeed_total", $AS );
	setUserStoredValue( "ds_unitspeed_total",$US );
	setUserStoredValue( "ds_skill1_total",$DS1 );
	setUserStoredValue( "ds_skill2_total",$DS2 );
	setUserStoredValue( "ds_skill3_total",$DS3 );
	setUserStoredValue( "ds_speed_total",$topSpeed );
 	
EndCatchEvent


CatchEvent OnMSO( $userName, $text ) # Player event

	SWITCH( $command )

#	How to get Drift Skill Table

		CASE "!dskill":
		CASE "!dskills":
		CASE "!DSKILL":
		CASE "!DSKILLS":
			topUser( "^3Drift Skill Table","ds_score_total","DESC",argv ); #"DESC" or "ASC" Sort sum value descending or ascending - in this case descending
		BREAK;
		
	ENDSWITCH

EndCatchEvent


LANG "EN"

main_ds_msg = "{0} ^2has a Drift Skill Score of ^1{1}"; # where {0} = driver, and {1} = drift skill score

main_s1_msg = "DEBUG: {0} ^2Has a S1 Drift Skill Score of ^1{1}";
main_s3_msg = "DEBUG: {0} ^2Has a S3 Drift Skill Score of ^1{1}";

main_m2n_msg = "DEBUG: ^2Laptime: ^1{0}";

main_ds_oads = "^7Overall Drift Score . . . ^1{0}";
main_ds_asfl = "^7Average Lap Speed  . . . ^1{0} ^7km/h";
main_ds_asfla = "^7Average Lap Speed  . . . ^1{0} ^7mph";
main_ds_avlt = "^7Average Lap Time . . . . ^1{0}";
main_ds_drss = "^7Drift Skill Score. . . . ^1{0}";
main_ds_dss1 = "^7Drift Skill Score 1. . . ^1{0}";
main_ds_dss2 = "^7Drift Skill Score 2. . . ^1{0}";
main_ds_dss3 = "^7Drift Skill Score 3. . . ^1{0}";
built_score = "Percentage";

EndLang