
####	CIRCULAR G-FORCE BUTTON
####	=======================

####	For Lapper V5.926 and later

####	by Sinanju 


#############################################################################
# Ver 0.1 - 21 Oct 2010 Initial release but normal button within the default lfslapper.lpr script
# Ver 0.2 - 21 Oct 2010 Made in circular button and as an add-on script
# Ver 0.3 - 22 Oct 2010 Moved button to less intrusive position and changed from red to yellow border
##############################################################################




###### INFO ######

##	Add the following line into the /addonsused.lpr file

##	include( "./gbutton.lpr");

##################


CatchEvent  OnAcceleration( $userName )

$AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
$AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph
$AccelerationStartSpeed = 1; # At which speed to start measuring time. In km/h
$AccelerationEndSpeed = 100; # At which speed to stop measuring time. In km/h

$gravity_mph = 21.93685; # An acceleration of 21.93685 mph per second is equal to 1g (0 - 100 mph in 1 second = 4.56g)
$gravity_kph =35.30394; # An acceleration of 35.30394 kp/h per second is equal to 1g

$ass = GetCurrentPlayerVar("AccelerationStartSpeed"); # Starting speed
$aes = GetCurrentPlayerVar("AccelerationEndSpeed"); # End speed
$at = GetCurrentPlayerVar("AccelerationTime"); # Acceleration time achieved from start to end speed
$us = GetCurrentPlayerVar("UnitSpeed"); # Unit of the speed of the player's car

$gforce_velocity_difference = ($aes - $ass);
$gforce_accel = $gforce_velocity_difference/$at;
$gforce_mph = round(($gforce_accel/$gravity_mph),2);
$gforce_kph = round(($gforce_accel/$gravity_kph),2);

	openPrivButton( "gforce_back",89,87,96,126,1,5,64,"^3•"); # yellow background
	openPrivButton( "gforce_front",91,91,88,118,1,5,64,"^7•"); # white foreground
	openPrivButton( "gforce_label",110,142,20,6,5,5,0,langEngine("%{main_gforce_label}%"));
	openPrivButton( "gforce_text",110,162,20,6,5,5,0,langEngine("%{main_gforce_text}%"));

IF ($us = "mph")
THEN
	openPrivButton( "gforce_score",110,145,20,20,5,5,0,langEngine("%{main_gforce_score}%",$gforce_mph ));
ELSE
	openPrivButton( "gforce_score",110,145,20,20,5,5,0,langEngine("%{main_gforce_score}%",$gforce_kph ));
ENDIF       		    			    			    			    			    			  

EndCatchEvent



LANG "EN"

main_gforce_label = "^0You pulled";

main_gforce_score = "^1{0}";

main_gforce_text = "^0g's";

EndLang