#ifndef _UDP_INSIM_H_
#define _UDP_INSIM_H_
/////////////////////


#include "WinSock2.h"


// Types

typedef unsigned short	word;
typedef unsigned char	byte;


// Constants

enum
{
	MUDP_INIT,
	MUDP_CONN,
	MUDP_ERROR,
};


// Config Settings

extern	word	ListenPort;
extern	word	SendPort;
extern	char	LFSIPAddress	[];
extern	char	AdminPass		[];


// Global Variables

extern	int		MUDPStatus;
extern	char	error_message	[];
extern	char	received_mess	[];
extern	char	custom_message	[];
extern	char	welcome_message	[];
extern	char	no_rst_message	[];


// Global functions

int		MUDPSetup			();						// Set up UDP port to listen
void	Listen				();						// Call this every frame
void	SendLFS				(char *buf, int size);	// Send a packet to LFS


// InSim Packets - all start with a 4-byte ID (3 characters + zero)

#define ISF_RACE_TRACKING	1	// bit 0 turns on race tracking
#define ISF_GUARANTEE		2	// bit 1 turns on guaranteed delivery
#define ISF_SPLIT_MESSAGE	4	// bit 2 makes LFS use MSS for user messages
#define ISF_NO_WARNINGS		8	// bit 3 turns off packet warnings
#define ISF_KEEP_ALIVE		16	// bit 4 makes LFS send keep alive packets
#define ISF_NLP_MCI			32	// bit 5 makes lfs send MCI instead of NLP

struct InSimInit
{
	char	Id[4];		// ISI
	word	Port;		// Port for UDP replies from LFS (1...65535)
	byte	Flags;		// Bit flags for options (see ISF flags above)
	byte	NodeSecs;	// Number of seconds between Node Updates (0=none)
	char	Admin[16];	// Admin password (if set in LFS)
};

struct InSimPack		// send to LFS for various requests
{
	char	Id[4];		// depends on the type of InSimPack
	int		Value;
};

struct InSimVersion
{
	char	Id		[4];	// VER
	char	Version	[8];	// Version, e.g. 0.3G
	char	Product	[6];	// Product, e.g. DEMO / S1
	word	InSimVer;		// InSim Version
};

struct InSimMulti
{
	char	Id[4];		// ISM
	byte	Host;		// 0 = guest / 1 = host
	byte	Sp1;
	byte	Sp2;
	byte	Sp3;
	char	Name[32];	// MAX_HOST_NAME - the name of the host joined or started
};

struct InSimVote
{
	char	Id[4];		// VTN
	byte	Conn;		// connection (0 is host)
	byte	Type;		// 1 - end race / 2 - restart / 3 - qualify
	byte	Spare2;
	byte	Spare3;
};

struct CamPosPack		// from LFS, report camera position / to LFS, set camera position (SHIFT+U mode)
{
	char	Id[4];		// CPP
	int		X;
	int		Y;
	int		Z;
	word	Heading;
	word	Pitch;
	word	Roll;
	byte	ViewPlayer;
	byte	InGameCam;
	float	FOV;
	word	Time;
	word	Flags;
};

struct SetCarCamera
{
	char	Id[4];		// SCC
	byte	ViewPlayer;	// Player Index of car to view (0 = pole...)
	byte	InGameCam;	// InGameCam (as reported in StatePack)
	byte	UniqueId;	// Overrides ViewPlayer if set
	byte	Spare3;
};

//OUTGAUGE!!!
#define OG_SHIFTLIGHT   1
#define OG_FULLBEAM     2
#define OG_HANDBRAKE    4
#define OG_PITSPEED     8
#define OG_TC           16
#define OG_HEADLIGHTS   32
#define OG_SIGNAL_L     64
#define OG_SIGNAL_R     128
#define OG_REDLINE      256
#define OG_OILWARN      512
#define OG_1            1024
#define OG_2            2048
#define OG_3            4096
#define OG_4            8192
#define OG_KM           16384
#define OG_BAR          32768

struct OutGauge
{
	unsigned int    Time;           // time in milliseconds (to check order)
	char            Car[4];         // Car name
	word            Flags;          // Combination of OG_FLAGS, see below
	byte            Gear;           // Reverse:0, Neutral:1, First:2...
	byte            SpareB;
	float           Speed;          // M/S
	float           RPM;            // RPM
	float           Turbo;          // BAR
	float           EngTemp;        // C
	float           Fuel;           // 0 to 1
	float           OilPress;       // BAR
	float           Spare1;
	float           Spare2;
	float           Spare3;
	float           Throttle;       // 0 to 1
	float           Brake;          // 0 to 1
	float           Clutch;         // 0 to 1
	char            Display1[16];   // Usually Fuel
	char            Display2[16];   // Usually Settings
	int             ID;             // (optional ID - if specified in cfg.txt)
};

// Bits for use in the StatePack

#define ISS_GAME			1		// in game (or MPR)
#define ISS_REPLAY			2		// in SPR
#define ISS_PAUSED			4		// paused
#define ISS_SHIFTU			8		// in SHIFT+U mode
#define ISS_SHIFTU_HIGH		16		// HIGH view
#define ISS_SHIFTU_FOLLOW	32		// following car
#define ISS_SHIFTU_NO_OPT	64		// buttons are hidden
#define ISS_SHOW_2D			128		// showing 2d display
#define ISS_FRONT_END		256		// in front end screen
#define ISS_MULTI			512		// multiplayer mode
#define ISS_MPSPEEDUP		1024	// showing 2d display
#define ISS_WINDOWED		2048	// windowed mode
#define ISS_SOUND_MUTE		4096	// sound mute
#define ISS_VIEW_OVERRIDE	8192	// override user view

struct StatePack		// from LFS, sent each time it changes, or on request
{
	char	Id[4];		// STA
	float	ReplaySpeed;

	word	Flags;
	byte	InGameCam;
	byte	ViewPlayer;

	byte	NumPlayers;
	byte	NumConns;
	byte	NumFinished;
	byte	RaceInProgress;

	byte	QualMins;
	byte	RaceLaps;
	byte	Spare2;
	byte	Spare3;

	char	Track[6];
	byte	Weather;
	byte	Wind;
};

struct StateFlagsPack
{
	char	Id[4];
	word	Flag;		// the state to set
	byte	OffOn;		// 0 = off / 1 = on
	byte	Sp3;		// spare
};

struct MsgOutPack		// 128 chars - LFS reports system messages (and user messages if ISF_SPLIT_MESSAGE is OFF)
{
	char	Id[4];		// MSO
	char	Msg[128];
};

struct MsgTypePack		// 64 chars - send to LFS to simulate typing message or command
{
	char	Id[4];		// MST
	char	Msg[64];
};

struct MsgOutSplit		// 64 chars - LFS reports user messages if ISF_SPLIT_MESSAGE flag is ON
{
	char	Id[4];		// MSS
	char	UName[24];
	char	PName[24];
	char	Msg[64];
};

struct MsgToConn		// 64 chars - send to LFS and on to a chosen connection (0 = host)
{
	char	Id[4];		// MTC
	byte	Conn;		// connection
	byte	UniqueId;	// destination player UniqueId : if set, Conn is ignored
	byte	Sp2;
	byte	Sp3;
	char	Msg[64];	// text message or /command, must end with zero
};

struct SingleCharPack	// send to LFS to simulate single character
{
	char	Id[4];		// SCH
	char	Char;
	byte	Flags;		// Flags : bit 0 : SHIFT / bit 1 : CTRL
	byte	Spare2;
	byte	Spare3;
};

struct InSimMode // send to LFS to change screen mode
{
	char	Id[4];		// MOD
	int		Bits16;		// set to choose 16-bit
	int		RR;			// refresh rate - zero for default
	int		Width;		// 0 means go to window
	int		Height;		// 0 means go to window
};


// RACE TRACKING...

struct MSHT
{
	byte	Minutes;
	byte	Seconds;
	byte	Hundredths;
	byte	Thousandths;
};

// Race tracking packets

struct IS_RST // Race STart
{
	char	RST		[4];

	byte	RaceLaps;		// 0 if qualifying
	byte	QualMins;		// 0 if race
	byte	NumInRace;
	byte	Spare;

	char	Track	[6];
	byte	Weather;
	byte	Wind;

	byte	Sp0;
	byte	Sp1;
	word	VerifyID;
};

struct IS_REN // Race ENd (return to entry screen)
{
	char	REN		[4];

	byte	Sp0;
	byte	Sp1;
	word	VerifyID;
};

struct IS_NCN // New ConN
{
	char	NCN		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	byte	Admin;
	byte	Sp1;
	byte	Sp2;
	byte	Sp3;

	byte	ConnNum;		// new conn's number (0 = host, 1, 2...)
	byte	Total;			// number of connections on host, including host
	word	VerifyID;
};

struct IS_CNL // ConN Leave (end connection is moved down into this slot)
{
	char	CNL		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	byte	ConnNum;
	byte	Total;
	word	VerifyID;
};

struct IS_NPL // New PLayer joining race (if number already exists, then leaving pits)
{
	char	NPL		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname
	char	Plate	[8];	// number plate - NO ZERO AT END!
	char	CName	[32];	// car name

	word	Flags;			// player flags
	byte	Type;			// bit 0 - female / bit 1 - AI
	byte	UniqueId;		// player's assigned unique id

	byte	PlyNum;			// player's number (0 = pole, 1, 2...)
	byte	Total;			// number in race (same when leaving pits, 1 more if new)
	word	VerifyID;
};

struct IS_PLP // PLayer Pits (go to settings - stays in player list)
{
	char	PLP		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	byte	UniqueId;		// player's assigned unique id
	byte	Sp1;
	byte	Sp2;
	byte	Sp3;

	byte	PlyNum;			// player's number (stays in list)
	byte	Total;			// new total (expect : same as before)
	word	VerifyID;
};

struct IS_PLL // PLayer Leave race (spectate - leaves player list, all are shunted down)
{
	char	PLL		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	byte	UniqueId;		// player's assigned unique id
	byte	Sp1;
	byte	Sp2;
	byte	Sp3;

	byte	PlyNum;			// player's number (others shunt down)
	byte	Total;			// new total (expect : 1 less than before)
	word	VerifyID;
};

struct IS_CPR // Conn Player Rename
{
	char	CPR		[4];

	char	UName	[24];	// username
	char	OldName	[24];	// old name
	char	NewName	[24];	// new name
	char	Plate	[8];	// number plate - NO ZERO AT END!

	byte	UniqueId;		// player's assigned unique id
	byte	Sp1;
	word	VerifyID;
};

struct IS_CLR // CLear Race - all players removed from race in one go
{
	char	CLR		[4];

	byte	Sp0;
	byte	Sp1;
	word	VerifyID;
};

struct IS_LAP // LAP time
{
	char	LAP		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname
	char	CName	[32];	// car name

	MSHT	Time;			// lap time

	byte	PlyNum;			// player's number
	byte	UniqueId;		// player's assigned unique id
	word	VerifyID;
};

struct IS_SPX // SPlit X time
{
	char	SPX		[4];	// SP1 / SP2 / SP3

	MSHT	Time;			// split time

	byte	PlyNum;			// player's number
	byte	UniqueId;		// player's assigned unique id
	word	VerifyID;
};

struct IS_RES // RESult (qualify or finish)
{
	char	RES		[4];

	char	UName	[24];	// username
	char	PName	[24];	// nickname
	char	Plate	[8];	// number plate - NO ZERO AT END!
	char	CName	[32];	// car name

	word	Flags;			// player flags
	byte	Type;			// bit 0 - female / bit 1 - AI
	byte	UniqueId;		// player's assigned unique id

	MSHT	TotalTime;		// race time
	MSHT	BestLap;		// best lap

	byte	ResultNum;		// position in results table (qualify may be inserted not at end)
	byte	NumResults;		// total number of results (qualify doesn't always add a new one)
	word	VerifyID;
};

struct PosId // small 2-byte structure - there is an array of these in the REO (below)
{
	byte	OldPos;			// old position in list
	byte	UniqueId;		// player's assigned unique id
};

struct IS_REO // REOrder (when race restarts after qualifying)
{
	char	REO		[4];

	PosId	Info	[28];	// old positions and unique id

	byte	Sp0;			// spare
	byte	NumPlayers;		// number of players in race
	word	VerifyID;
};

// Non-verified race tracking packets

struct NodeLap // small 4-byte structure - there is an array of these in the NLP (below)
{
	word	Node;			// current path node
	byte	Lap;			// current lap
	byte	UniqueId;		// player's assigned unique id
};

struct IS_NLP // Node and Lap Packet
{
	char	NLP		[4];

	word	NumNodes;		// total number of nodes in the path
	word	FinishLine;		// the node number of the finish line

	byte	NumPlayers;		// number of players in race
	byte	Sp1;			// spare
	byte	Sp2;			// spare
	byte	Sp3;			// spare

	NodeLap	Info	[28];	// node and lap of each player
};

struct CompCar // Car info in a 24-byte structure - there is an array of these in the MCI (below)
{
	word	Node;			// current path node
	byte	Lap;			// current lap
	byte	UniqueId;		// player's assigned unique id
	int		X;				// X map (65536 = 1 metre)
	int		Y;				// Y map (65536 = 1 metre)
	int		Z;				// Z alt (65536 = 1 metre)
	word	Speed;			// speed (32768 = 100 m/s)
	word	Direction;		// direction of car's motion : 0 = world y direction, 32768 = 180 deg
	word	Heading;		// direction of forward axis : 0 = world y direction, 32768 = 180 deg
	short	AngVel;			// signed, rate of change of heading : (16384 = 360 deg/s)
};

struct IS_MCI // MultiCarInfo - if more than 8 in race then more than one of these is sent
{
	char	MCI		[4];

	word	NumNodes;		// total number of nodes in the path
	word	FinishLine;		// the node number of the finish line

	byte	NumPlayers;		// number of players in race
	byte	FirstPly;		// first player in this packet
	byte	Sp2;			// spare
	byte	Sp3;			// spare

	CompCar	Info	[8];	// car info for each player
};

// End of race tracking packets


// Store a StatePack so the program can display the LFS State

extern	StatePack		LFSState;
extern	OutGauge        Gauge;

// Special structure for the TRACK LIMITATION

const int MAX_TRACKS = 256;

struct TrackName
{
	char Name[8];
};

extern int BadTrack; // set this variable if a disallowed track is selected
extern int NumTracks;
extern TrackName Tracks[];


// Loaded variable for RESTART LIMITATION - number of seconds to disable voting

extern unsigned NoRestartTime;


//////
#endif