#include "stdafx.h"
#include "stdio.h"
#include "UDPInSim.h"

// lib : wsock32.lib ws2_32.lib


// const

const int TESTBUFSIZE = 512;


// Config Settings

word			ListenPort;
word			SendPort;
char			LFSIPAddress	[16];
char			AdminPass		[16];


// Global Variables

int				MUDPStatus		= MUDP_INIT;
char			error_message	[256];
char			received_mess	[256];
char			custom_message	[64]; // limited to 64 bytes for send in packet
char			welcome_message	[64]; // limited to 64 bytes for send in packet
char			no_rst_message	[64]; // limited to 64 bytes for send in packet


// Loaded variables for TRACK LIMITATION

int				BadTrack;		// set this variable if a disallowed track is selected
int				NumTracks;
TrackName		Tracks			[MAX_TRACKS];


// Loaded variable for RESTART LIMITATION

unsigned		NoRestartTime;


// Local variable to store the time of race starts

unsigned		race_start_time;
unsigned		someone_finished;


// Store a StatePack so the program can display the LFS State

StatePack		LFSState;
OutGauge		Gauge;

// Local Variables

SOCKET			UDPSocket		= INVALID_SOCKET;
sockaddr_in		UDPSockAddr;
WSADATA			wsaData;


// local function prototypes

void ReadUDPSocket();

int TrackIsAllowed(char *track_info);

// functions

int MUDPSetup() // call after port has been determined
{
	if (WSAStartup(0x202, &wsaData) == SOCKET_ERROR)
	{
		strcpy(error_message, "Init : WSAStartup failed");
		WSACleanup(); 
		return 0;
	}

	// fill in some info into the address info thing to set up the socket
	UDPSockAddr.sin_family = AF_INET;
	UDPSockAddr.sin_addr.s_addr = INADDR_ANY;

	// Port MUST be in Network Byte Order
	UDPSockAddr.sin_port = htons(ListenPort); 		// any port (10000 to 65535)
	UDPSocket = socket(AF_INET, SOCK_DGRAM, 0);		// create UDP socket 
	
	if (UDPSocket == INVALID_SOCKET)
	{ 
		strcpy(error_message, "SetupUDPSocket : Error opening socket");
		WSACleanup(); 
		return 0;
	} 

	// bind
	if (bind(UDPSocket,(sockaddr*)&UDPSockAddr, sizeof(UDPSockAddr)) == SOCKET_ERROR)
	{ 
		strcpy(error_message, "SetupUDPSocket : bind failed");
		closesocket(UDPSocket);
		UDPSocket = INVALID_SOCKET;
		WSACleanup(); 
		return 0;
	} 
	
	// WSAEventSelect
	HANDLE hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	if (WSAEventSelect(UDPSocket, hEvent, FD_READ | FD_CLOSE) == SOCKET_ERROR)
	{
		strcpy(error_message, "SetupUDPSocket : WSAEventSelect failed");
		closesocket(UDPSocket);
		UDPSocket = INVALID_SOCKET;
		WSACleanup(); 
		return 0;
	}

	strcpy(error_message, "Press S to connect to LFS");

	MUDPStatus = MUDP_CONN;

	return 1;
}

void Listen() // function to be called every frame, listen for incoming packets
{
	if (MUDPStatus == MUDP_INIT) return;

	if (UDPSocket != INVALID_SOCKET)
	{
		int check_read = 1;
		while (check_read)
		{
			WSANETWORKEVENTS net_events;
			memset(&net_events, 0, sizeof(net_events));

			if (WSAEnumNetworkEvents(UDPSocket, NULL, &net_events) == SOCKET_ERROR)
			{
				check_read = 0; // got error, forget it until next frame
			}
			else
			{
				if (net_events.lNetworkEvents & FD_READ)
				{
					ReadUDPSocket(); // read the data then check events again
				}
				else
				{
					check_read = 0; // nothing to read
				}
			}
		}
	}
}

void ReadUDPSocket() // called from Listen function when a UDP packet arrives
{
	char buf[TESTBUFSIZE];

	int retval = recv(UDPSocket, buf, TESTBUFSIZE, 0);

	if (buf[3]) // 4th character must always be zero
	{
		strcpy(error_message, "INVALID PACKET");
		return;
	}

	if (strcmp(buf, "STA")==0) // StatePack
	{
		if (retval == sizeof(StatePack))
		{
			// store the received StatePack in "LFSState"
			memcpy(&LFSState, &buf, sizeof(StatePack));
			memcpy(&Gauge, &buf, sizeof(OutGauge));

			if (TrackIsAllowed(LFSState.Track))
			{
				BadTrack = 0;
			}
			else if (BadTrack == 0)
			{
				// TRACK IS NOT ALLOWED!

				BadTrack = 1;

				MsgTypePack send_pack;
				memset(&send_pack, 0, sizeof(MsgTypePack));
				strcpy(send_pack.Id, "MST");
				strcpy(send_pack.Msg, custom_message);
				SendLFS((char *)&send_pack, sizeof(MsgTypePack));
			}
		}
		else
		{
			strcpy(error_message, "INVALID STA");
		}
		return;
	}

	if (strcmp(buf, "MSO")==0) // MsgOutPack
	{
		if (retval == sizeof(MsgOutPack))
		{
			MsgOutPack *pack = (MsgOutPack *) buf;

			if (pack->Msg[127]) // final character must be zero
			{
				strcpy(error_message, "CORRUPTED MSO");
				return;
			}

			// store the message in the "received_mess" string
			strcpy(received_mess, pack->Msg);
		}
		else
		{
			strcpy(error_message, "INVALID MSO");
		}
		return;
	}

	if (strcmp(buf, "MSS")==0) // MsgOutSplit
	{
		if (retval == sizeof(MsgOutSplit))
		{
			MsgOutSplit *pack = (MsgOutSplit *) buf;

			if (pack->Msg[63]) // final character must be zero
			{
				strcpy(error_message, "CORRUPTED MSS");
				return;
			}

			// store the message in the "received_mess" string
			sprintf(received_mess, "%s / %s : %s", pack->UName, pack->PName, pack->Msg);
		}
		else
		{
			strcpy(error_message, "INVALID MSS");
		}
		return;
	}

	if (strcmp(buf, "VTN")==0) // InSimVote
	{
		if (retval == sizeof(InSimVote))
		{
			InSimVote *vtn = (InSimVote *) buf;

			if (someone_finished==0 && vtn->Conn != 0 && LFSState.NumPlayers > 1) // not host and more than one player in the race
			{
				unsigned current_time = GetTickCount();

				unsigned elapsed_time = current_time - race_start_time;

				if (elapsed_time < NoRestartTime * 1000) // too early
				{
					MsgToConn send_pack;
					memset(&send_pack, 0, sizeof(MsgToConn));
					strcpy(send_pack.Id, "MTC");
					send_pack.Conn = vtn->Conn;
					strcpy(send_pack.Msg, no_rst_message);
					SendLFS((char *)&send_pack, sizeof(MsgToConn));

					InSimPack vote_cancel;
					memset(&vote_cancel, 0, sizeof(InSimPack));
					strcpy(vote_cancel.Id, "VTC");
					SendLFS((char *)&vote_cancel, sizeof(InSimPack));
				}
			}
		}
		else
		{
			strcpy(error_message, "INVALID VTN");
		}
		return;
	}

	if (strcmp(buf, "RST")==0) // Race STart
	{
		if (retval == sizeof(IS_RST))
		{
			IS_RST *rst = (IS_RST *) buf;

			// store the current time

			race_start_time = GetTickCount();

			// reset the number of finishers

			someone_finished = 0;
		}
		else
		{
			strcpy(error_message, "INVALID RST");
		}
		return;
	}

	if (strcmp(buf, "RES")==0) // Race STart
	{
		if (retval == sizeof(IS_RES))
		{
			IS_RES *RES = (IS_RES *) buf;

			// count the people who finished

			someone_finished++;
		}
		else
		{
			strcpy(error_message, "INVALID RES");
		}
		return;
	}

	if (strcmp(buf, "RTP")==0) // RaceTimePacket
	{
		if (retval == sizeof(InSimPack))
		{
			InSimPack *rtp = (InSimPack *) buf;

			// something
		}
		else
		{
			strcpy(error_message, "INVALID RTP");
		}
		return;
	}

	if (strcmp(buf, "ISM")==0)
	{
		if (retval == sizeof(InSimMulti))
		{
			InSimMulti *pack = (InSimMulti *) buf;
			sprintf(error_message, "%s : %s", pack->Host ? "HOST" : "GUEST", pack->Name);
		}
		else
		{
			strcpy(error_message, "INVALID ISM");
		}
		return;
	}

	if (strcmp(buf, "MPE")==0)
	{
		strcpy(error_message, "End Multi");
		return;
	}
}

void SendLFS(char *buf, int size) // Send "buf" of size "size" to LFS
{
	sockaddr_in temp_addr;
	unsigned int addr = inet_addr(LFSIPAddress);

	memset(&temp_addr, 0, sizeof(temp_addr));
	memcpy(&temp_addr.sin_addr, &addr, sizeof(addr));
	temp_addr.sin_family = AF_INET;
	temp_addr.sin_port = htons(SendPort);

	sendto(UDPSocket, buf, size, 0, (sockaddr *)&temp_addr, sizeof(temp_addr));
}

int TrackIsAllowed(char *track_info)
{
	if (track_info[0]==0) return 1; // no name specified - can't say it's not allowed

	if (NumTracks==0) return 1; // no allowed track is specified - all are allowed

	for (int k=0; k<NumTracks; k++)
	{
		if (stricmp(Tracks[k].Name, track_info)==0)
		{
			return 1; // found an allowed track that matches the selected track - OK
		}
	}

	// still here - this track is not allowed

	return 0;
}
