#include "stdafx.h"
#include "resource.h"
#include "stdio.h"
#include "UDPInSim.h"
#include "App.h"

#define MAX_LOADSTRING 100

HINSTANCE			hInst;
TCHAR				szTitle			[MAX_LOADSTRING];
TCHAR				szWindowClass	[MAX_LOADSTRING];

HWND				hWnd			= NULL;

ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);


extern int immediate_refresh; // a variable in APP.cpp to make screen update instantly when typing

void SendInSimPack(const char *id, int value); // a function in App.cpp to send a InSimPack to LFS


// WinMain

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_LFSCONTROL, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	if (!InitInstance(hInstance, nCmdShow)) // application initialization
	{
		return FALSE;
	}
	
	if (LoadConfig()) // successfully loaded config file
	{
		strcpy(error_message, "Press H to initialise");
	}

	SetupTracks(); // load up the allowed tracks

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_LFSCONTROL);

	const int REFRESH_RATE		= 500;		// update screen every 2 secs
	const int CHECK_INTERVAL	= 4000;		// check track every 4 secs
	const int ALIVE_INTERVAL	= 30000;	// sand "keep alive" every 30 secs
	
	unsigned next_refresh		= GetTickCount() + REFRESH_RATE;
	unsigned next_track_check	= GetTickCount() + CHECK_INTERVAL;
	unsigned next_alive_msg		= GetTickCount() + ALIVE_INTERVAL;

	unsigned send_welcome_time	= 0; // zero means don't send message yet... see below

	// Main message loop

	int carry_on = 1;

	int previous_num_conns = 1;
	
	while (carry_on)
	{
		Sleep(100);	// Give up time to CPU for 100 ms

		Listen();	// Listen for UDP packets
		
		unsigned new_time = GetTickCount();

		// check for time to refresh screen

		if (immediate_refresh || new_time > next_refresh)
		{
			RECT rt;
			GetClientRect(hWnd, &rt);
			InvalidateRgn(hWnd, NULL, TRUE);

			frame_count++; // update screen refresh counter

			UpdateWindow(hWnd);
			next_refresh += REFRESH_RATE;

			immediate_refresh = 0;

			if (LFSState.NumConns > previous_num_conns) // NEW CONNECTION!
			{
				send_welcome_time = new_time + 4000; // send welcome message in 4 seconds
			}

			previous_num_conns = LFSState.NumConns;
		}

		if (send_welcome_time && new_time > send_welcome_time)
		{
			send_welcome_time = 0;

			MsgTypePack send_pack;
			memset(&send_pack, 0, sizeof(MsgTypePack));
			strcpy(send_pack.Id, "MST");
			strcpy(send_pack.Msg, welcome_message);
			SendLFS((char *)&send_pack, sizeof(MsgTypePack));
		}

		if (new_time > next_alive_msg)
		{
			SendInSimPack("ACK", 0); // send a blank acknowledgment packet

			next_alive_msg += REFRESH_RATE;
		}

		if (new_time > next_track_check)
		{
			if (BadTrack)
			{
				if (LFSState.Flags & ISS_FRONT_END)
				{
					// can't do anything in front end
				}
				else if (LFSState.Flags & ISS_GAME)
				{
					// in game, send a /end command
					MsgTypePack send_pack;
					memset(&send_pack, 0, sizeof(MsgTypePack));
					strcpy(send_pack.Id, "MST");
					strcpy(send_pack.Msg, "/end");
					SendLFS((char *)&send_pack, sizeof(MsgTypePack));
				}
				else // assume setup screen
				{
					// not in game, send a /track command
					MsgTypePack send_pack;
					memset(&send_pack, 0, sizeof(MsgTypePack));
					strcpy(send_pack.Id, "MST");

					// find a track to change to...
					char *allowed_track = NULL;
					for (int k=0; k<NumTracks && allowed_track==NULL; k++)
					{
						if (toupper(Tracks[k].Name[0])==LFSState.Track[0] &&
							toupper(Tracks[k].Name[1])==LFSState.Track[1])
						{
							// found one with a matching track ares
							allowed_track = Tracks[k].Name;
						}
					}

					// if none was found, go back to default
					if (allowed_track==NULL) allowed_track = Tracks[0].Name;

					sprintf(send_pack.Msg, "/track %s", allowed_track);
					SendLFS((char *)&send_pack, sizeof(MsgTypePack));
				}
			}

			next_track_check += CHECK_INTERVAL;
		}

		// check for windows messages

		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message != WM_QUIT)
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			else
			{
				carry_on = 0;
			}
		}
	}

	return msg.wParam;
}

// Register

ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_LFSCONTROL);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_LFSCONTROL;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

// Initialise

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	hInst = hInstance; // Store instance handle in our global variable

	hWnd = CreateWindowEx
	(
		0,
		szWindowClass,			// class_name
		szTitle,				// window_name
		WS_OVERLAPPEDWINDOW,
		320,
		32,
		320,	// w
		240,	// h
		NULL,
		NULL,
		hInstance,
		NULL
	);

   if (!hWnd)
   {
	   return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

// Process Windows Messages

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;

	switch (message) 
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Parse the menu selections:
		switch (wmId)
		{
			case IDM_ABOUT:
			   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
			   break;
			case IDM_EXIT:
			   DestroyWindow(hWnd);
			   break;
			default:
			   return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;

	case WM_PAINT:
		DrawScreen(hWnd);		// call function in App.cpp
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_LBUTTONDOWN:
		// left mouse click
		break;

	case WM_CHAR:
		ProcessChar(wParam);	// call function in App.cpp
		break;

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
   }

   return 0;
}

// Mesage handler for about box

LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
			return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
    return FALSE;
}
