#include "stdafx.h"
#include "stdio.h"
#include "UDPInSim.h"


// some text for display

const int ISS_NUM = 11;
//struct OutGauge gauge;
const char *flags_text[ISS_NUM] = 
{
	"game",			// 1	- in game (or MPR)
	"replay",		// 2	- in SPR
	"paused",		// 4	- paused
	"shiftu",		// 8	- SHIFT+U mode
	"su_high",		// 16	- SHIFT+U HIGH view
	"su_follow",	// 32	- SHIFT+U following car
	"su_no_opt",	// 64	- SHIFT+U no buttons
	"show_2d",		// 128	- showing 2d display
	"front end",	// 256	- in front end screen
	"multi",		// 512	- multiplayer mode
	"mp_speedup",	// 1024	- mp speedup option
};

const byte show_flag[ISS_NUM] = 
{
	1,
	1,
	1,
	0,
	0,
	0,
	0,
	0,
	1,
	1,
	0,
};


// Global variables

unsigned frame_count;
int immediate_refresh;

// Constants

const int			MAX_STRING_LEN	= 64;


// Local Variables

int					type_mode;
int					string_len;
char				string			[MAX_STRING_LEN];


// function to send a basic InSimPack

void SendInSimPack(const char *id, int value)
{
	InSimPack send;

	strcpy(send.Id, id);	// fill in Id
	send.Value = value;		// fill in value

	SendLFS((char *)&send, sizeof(InSimPack)); // send packet to LFS
}


// function to process individual key presses

void ProcessKeyActive(int key)
{
	error_message[0] = 0; // cancel error message

	switch (toupper(key))
	{
	case 'S': // Send Initial Packet (InSim Init)
		{
			InSimInit init_pack;
			memset(&init_pack, 0, sizeof(InSimInit));
			strcpy(init_pack.Id, "ISI");
			init_pack.Port = ListenPort;
			init_pack.Flags = ISF_SPLIT_MESSAGE | ISF_RACE_TRACKING;
			init_pack.NodeSecs = 0;
			strcpy(init_pack.Admin, AdminPass);
			SendLFS((char*)&init_pack, sizeof(InSimInit));

			// send a request for the current LFS state
			SendInSimPack("SST", 0);
		}
		break;

	case 'I': // Get Info (Send STate)
		sprintf(error_message, "HELLO!!!");
		SendInSimPack("SST", 0);
		break;

	case 'T': // go into type mode
		string[0] = 0;
		string_len = 0;
		type_mode = 1;
		break;

	case '/': // go into type command mode
		strcpy(string, "/");
		string_len = 1;
		type_mode = 1;
		break;

	case 'C': // go into press character mode
		type_mode = 2;
		break;

	case 'G':  //outgauge
		
		SendInSimPack("SSG", 1);
	    
		break;
	
	case 'R':
		break;
	
	default:
		{
			char cchar = key;
			sprintf(error_message, "123Unknown Key (%c)", cchar);
		}	
		break;
	}

	switch (type_mode)
	{
	case 0:
		break;
	case 1:
		strcpy(error_message, "Type message"); // use error_message to display this
		break;
	case 2:
		strcpy(error_message, "Press key to send"); // use error_message to display this
		break;
	}
}


// function to process keys when typing in a message

void ProcessKeyType(int key)
{
	switch (key)
	{
	case VK_ESCAPE: // cancel
		string[0] = 0;
		string_len = 0;
		type_mode = 0;
		break;

	case VK_RETURN: // send message to LFS - max 64 chars
		{
			MsgTypePack send_pack;
			memset(&send_pack, 0, sizeof(MsgTypePack));
			strcpy(send_pack.Id, "MST");
			strcpy(send_pack.Msg, string);
			SendLFS((char *)&send_pack, sizeof(MsgTypePack));
		}
		string[0] = 0;
		string_len = 0;
		type_mode = 0;
		break;

	case VK_TAB: // send message to LFS, connection 1 (first guest)
		{
			MsgToConn send_pack;
			memset(&send_pack, 0, sizeof(MsgToConn));
			strcpy(send_pack.Id, "MTC");
			strcpy(send_pack.Msg, string);
			send_pack.Conn = 1;
			SendLFS((char *)&send_pack, sizeof(MsgToConn));
		}
		string[0] = 0;
		string_len = 0;
		type_mode = 0;
		break;

	case VK_BACK: // delete end char
		if (string_len > 0)
		{
			string_len--;
			string[string_len] = 0;
		}
		break;

	default:
		if (string_len < 63 && key >= 32 && key <= 255)
		{
			string[string_len++] = key;
			string[string_len] = 0;
		}
		break;
	}

	if (!type_mode) error_message[0] = 0; // left type mode, cancel error_message
}


// ProcessChar - processes the WM_CHAR message

void ProcessChar(unsigned int wParam)
{
	immediate_refresh = 1;

	switch (MUDPStatus)
	{
	case MUDP_INIT:
		{
			switch (toupper(wParam))
			{
			case 'H':
				MUDPSetup();
				break;
			}
		}
		break;

	case MUDP_CONN:
		if (type_mode == 1) // typing a message
		{
			ProcessKeyType(wParam);
		}
		else if (type_mode == 2) // send single character
		{
			byte flags = 0;
			if (GetAsyncKeyState(VK_SHIFT)) flags |= 1;
			if (GetAsyncKeyState(VK_CONTROL)) flags |= 2;

			SingleCharPack send_pack;
			memset(&send_pack, 0, sizeof(SingleCharPack));
			strcpy(send_pack.Id, "SCH");
			send_pack.Char = wParam;
			send_pack.Flags = flags;
			SendLFS((char *)&send_pack, sizeof(SingleCharPack));

			type_mode = 0;
			error_message[0] = 0; // left type mode, cancel error_message
		}
		else // interpret key
		{
			ProcessKeyActive(wParam);
		}
		break; // MUDPStatus

	case MUDP_ERROR:
		{
			// Don't process any keys after a fatal error
		}
		break;
	}
}


// Draw screen function

void DrawScreen(HWND hwnd)
{
	PAINTSTRUCT ps;
	HDC hdc;
	RECT rt;

	hdc = BeginPaint(hwnd, &ps);
	GetClientRect(hwnd, &rt);

	// START DRAW

	char buf[256];
	sprintf(buf, "InSim for LFS - elapsed time : %d", frame_count);
	DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
	rt.top += 20;

	// State
	sprintf(buf, "%d Player%s / RPM %d Finished / %d Conn%s",
		(int)LFSState.NumPlayers, LFSState.NumPlayers==1 ? "" : "s",
		//(int)LFSState.NumFinished,
		(int)Gauge.Gear,
		(int)LFSState.NumConns, LFSState.NumConns==1 ? "" : "s");
	DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
	rt.top += 20;

	char *init = "NO RACE : ";
	switch (LFSState.RaceInProgress)
	{
	case 1:
		init = "RACE : ";
		break;
	case 2:
		init = "QUAL : ";
		break;
	}
	sprintf(buf, "%s Qual %d, Laps %d, Track %s",
		init, LFSState.QualMins, LFSState.RaceLaps, LFSState.Track);
	DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
	rt.top += 20;



	// State Flags
	buf[0] = 0;
	int have_drawn = 0;
	for (int k=0; k<ISS_NUM; k++)
	{
		if (show_flag[k] && (LFSState.Flags & (1 << k)))
		{
			if (have_drawn) strcat(buf, ", ");
			strcat(buf, flags_text[k]);
			have_drawn = 1;
		}
	}
	DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
	rt.top += 30;

	// Received text from last MSO packet
	DrawText(hdc, received_mess, strlen(received_mess), &rt, DT_CENTER);
	rt.top += 30;

	// Error message
	DrawText(hdc, error_message, strlen(error_message), &rt, DT_CENTER);
	rt.top += 30;

	// Typed string
//	sprintf(error_message, "gear(%f)", gauge.RPM);

	if (type_mode==0 && MUDPStatus==MUDP_CONN) // connected and not typing in anything
	{
		strcpy(string, "T : msg, C : char, S : start, I : info");
	}
	DrawText(hdc, string, strlen(string), &rt, DT_CENTER);

	// END DRAW

	EndPaint(hwnd, &ps);
}


// fatal error function for load config failure - stops the program

void fatal_error(char *error)
{
	MUDPStatus = MUDP_ERROR;
	strcpy(error_message, error);
}


// utility function for loading config file

void scan_to_end(FILE *fin, char *dst, int max_chars)
{
	int carry_on = 1, count = 0;

	while (carry_on)
	{
		int c = fgetc(fin);

		if (c == EOF) return;

		if (c==0 || c==13 || c=='\n')
		{
			dst[count] = 0;
			return;
		}

		dst[count++] = c;

		if (count==max_chars-1)
		{
			dst[count] = 0;
			return;
		}
	}
}


// function to load the small config file

int LoadConfig()
{
	FILE *fin = fopen("insim_cfg.txt", "rt");
	if (!fin)
	{
		fatal_error("Could not load insim_cfg.txt");
		return 0;
	}

	char comment	[64];
	char port		[16];
	int port_int;

	// Listen Port
	scan_to_end(fin, comment, 64);
	scan_to_end(fin, port, 16);
	sscanf(port, "%d", &port_int);
	if (port_int <= 0 || port_int > 65535)
	{
		fatal_error("Listen port is not valid");
		return 0;
	}
	ListenPort = port_int;

	// Send Port
	scan_to_end(fin, comment, 64);
	scan_to_end(fin, port, 16);
	sscanf(port, "%d", &port_int);
	if (port_int <= 0 || port_int > 65535)
	{
		fatal_error("Send port is not valid");
		return 0;
	}
	SendPort = port_int;

	// LFS IP Address
	scan_to_end(fin, comment, 64);
	scan_to_end(fin, LFSIPAddress, 16);

	// LFS Admin Password
	scan_to_end(fin, comment, 64);
	scan_to_end(fin, AdminPass, 16);
	fclose(fin);

	return 1;
}

// function to load the allowed track names

// TRACK LIMITATION - function to load up the Allowed Tracks

void SetupTracks()
{
	FILE *fin = fopen("Setup.txt", "rt");
	if (!fin) return;

	char comment	[128];
	char number		[16];

	// welcome message
	scan_to_end(fin, comment, 128);
	scan_to_end(fin, welcome_message, 64);

	// no restart message
	scan_to_end(fin, comment, 128);
	scan_to_end(fin, no_rst_message, 64);

	// no restart time
	scan_to_end(fin, comment, 128);
	scan_to_end(fin, number, 16);
	sscanf(number, "%d", &NoRestartTime);

	// track change message
	scan_to_end(fin, custom_message, 64);
	scan_to_end(fin, comment, 128);

	// number of tracks
	scan_to_end(fin, number, 16);
	sscanf(number, "%d", &NumTracks);

	// tracks
	scan_to_end(fin, comment, 128);
	if (NumTracks < 0 || NumTracks >= MAX_TRACKS)
	{
		NumTracks = 0;
		fclose(fin);
		return;
	}

	for (int k=0; k<NumTracks; k++)
	{
		scan_to_end(fin, Tracks[k].Name, 8);
	}

	fclose(fin);
}