﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Reflection;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;

namespace LFS_External_Client
{
    class misc
    {

        static public void manageHandledException(Exception e)
        {
            try
            {
                string mainErrorFile = "Last update: " + DateTime.Now.ToFileTime() + Environment.NewLine + Environment.NewLine;
                try
                {
                    StreamReader ErRe1 = new StreamReader(globalVars.globalHandledExceptionReportFilePath);
                    mainErrorFile += ErRe1.ReadToEnd();
                    ErRe1.Dispose();
                    ErRe1.Close();
                }
                catch { }

                using (StreamWriter writer = new StreamWriter(globalVars.globalHandledExceptionReportFilePath))
                {
                    writer.WriteLine(mainErrorFile);
                    writer.WriteLine();
                    writer.WriteLine("< < < < - - - - - - - - - - - - - - - - - - - > > > >");
                    writer.WriteLine();
                    writer.WriteLine("Name: " + Assembly.GetExecutingAssembly().GetName().Name);
                    writer.WriteLine("Version: " + Assembly.GetExecutingAssembly().GetName().Version.ToString());
                    writer.WriteLine("Date: " + DateTime.Now.ToString());
                    writer.WriteLine("OS: " + Environment.OSVersion.VersionString);
                    writer.WriteLine("Culture: " + Thread.CurrentThread.CurrentUICulture);
                    writer.WriteLine("Message: " + e.Message);
                    writer.WriteLine("Source: " + e.Source);
                    writer.WriteLine("Target: " + e.TargetSite);
                    writer.WriteLine("Stack Trace: " + e.StackTrace);
                    writer.WriteLine("Inner Exception: " + e.InnerException);
                }

                try
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Handled exception data written in log file!");
                }
                catch { }
            }
            catch
            {
                Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error! (Handled) exception unhandled!");
            }
        }

        static public clsPlayer convertToPlayer(clsConnection C)
        {
            for (int i = 0; i < Form1.Players.Count; i++)
            {
                if (Form1.Players[i].UniqueID == C.UniqueID)
                {
                    return Form1.Players[i];
                }
            }
            return new clsPlayer();
        }
        static public clsConnection convertToConnection(clsPlayer P)
        {
            for (int i = 0; i < Form1.Connections.Count; i++)
            {
                if (Form1.Connections[i].UniqueID == P.UniqueID)
                {
                    return Form1.Connections[i];
                }
            }
            return new clsConnection();
        }

        static public string getLocationOfPlayer(clsPlayer P)
        {
            if (P == null)
            {
                return "_error";
            }

            string trackName = globalVars.currentTrack;
            switch (trackName)
            {
                case "AS5":
                case "AS5R":
                    if ((P.CompCar.Node >= 731) && ((P.CompCar.X / 196608) <= -203) && ((P.CompCar.Y / 196608) <= -63) && ((P.CompCar.Y / 196608) >= -147))
                    {
                        P.speedLimit = 80;
                        P.location = "Pit Lane";
                        break;
                    }
                    if ((P.CompCar.Node >= 64) && (P.CompCar.Node < 107))
                    {
                        P.speedLimit = 100;
                        P.location = "Top Corner";
                    }
                    if ((P.CompCar.Node >= 107) && (P.CompCar.Node < 131))
                    {
                        P.speedLimit = 150;
                        P.location = "Moreland St.";
                    }
                    if ((P.CompCar.Node >= 131) && (P.CompCar.Node < 177))
                    {
                        P.speedLimit = 150;
                        P.location = "Sydney Rd";
                    }
                    if ((P.CompCar.Node >= 177) && (P.CompCar.Node < 192))
                    {
                        P.speedLimit = 50;
                        P.location = "Reynard's Corner";
                    }
                    if ((P.CompCar.Node >= 192) && (P.CompCar.Node < 215))
                    {
                        P.speedLimit = 200;
                        P.location = "Port St.";
                    }
                    if ((P.CompCar.Node >= 215) && (P.CompCar.Node < 240))
                    {
                        P.speedLimit = 80;
                        P.location = "Cumberland Road";
                    }
                    if ((P.CompCar.Node >= 240) && (P.CompCar.Node < 320))
                    {
                        P.speedLimit = 150;
                        P.location = "Western Ring Hwy";
                    }
                    if ((P.CompCar.Node >= 320) && (P.CompCar.Node < 374))
                    {
                        P.speedLimit = 60;
                        P.location = "Boundary Road";
                    }
                    if ((P.CompCar.Node >= 374) && (P.CompCar.Node < 404))
                    {
                        P.speedLimit = 90;
                        P.location = "Bank Pass";
                    }
                    if ((P.CompCar.Node >= 404) && (P.CompCar.Node < 537))
                    {
                        P.speedLimit = 50;
                        P.location = "Princess Hwy";
                    }
                    if ((P.CompCar.Node >= 537) && (P.CompCar.Node < 554))
                    {
                        P.speedLimit = 999;
                        P.location = "Market Pass";
                    }
                    if ((P.CompCar.Node >= 554) && (P.CompCar.Node < 634))
                    {
                        P.speedLimit = 80;
                        P.location = "Ruders' Drive";
                    }
                    if ((P.CompCar.Node >= 634) && (P.CompCar.Node < 653))
                    {
                        P.speedLimit = 40;
                        P.location = "Drifters' Bend";
                    }
                    if ((P.CompCar.Node >= 653) && (P.CompCar.Node < 691))
                    {
                        P.speedLimit = 60;
                        P.location = "Clifton Hill";
                    }
                    if ((P.CompCar.Node >= 691) && (P.CompCar.Node < 710))
                    {
                        P.speedLimit = 60;
                        P.location = "Harding St.";
                    }
                    if ((P.CompCar.Node >= 710) && ((P.CompCar.X / 196608) < -204) && ((P.CompCar.Y / 196608) > -63))
                    {
                        P.speedLimit = 150;
                        P.location = "Lygon St.";
                    }
                    if ((P.CompCar.Node >= 710) && ((P.CompCar.X / 196608) < -204) && ((P.CompCar.Y / 196608) < -147))
                    {
                        P.speedLimit = 150;
                        P.location = "Lygon St.";
                    }
                    if (P.CompCar.Node < 64)
                    {
                        P.speedLimit = 150;
                        P.location = "Lygon St.";
                    }
                    break;

                case "AS4":
                case "AS4R":
                    if ((P.CompCar.Node >= 731) && ((P.CompCar.X / 196608) <= -203) && ((P.CompCar.Y / 196608) <= -63) && ((P.CompCar.Y / 196608) >= -147))
                    {
                        P.speedLimit = 80;
                        P.location = "Pit Lane";
                    }
                    if ((P.CompCar.Node >= 65) && (P.CompCar.Node < 105))
                    {
                        P.speedLimit = 100;
                        P.location = "Top Corner";
                    }
                    if ((P.CompCar.Node >= 105) && (P.CompCar.Node < 135))
                    {
                        P.speedLimit = 150;
                        P.location = "Follow-Through";
                    }
                    if ((P.CompCar.Node >= 135) && (P.CompCar.Node < 172))
                    {
                        P.speedLimit = 150;
                        P.location = "Market Street";
                    }
                    if ((P.CompCar.Node >= 172) && (P.CompCar.Node < 245))
                    {
                        P.speedLimit = 50;
                        P.location = "Hammerhead";
                    }
                    if ((P.CompCar.Node >= 245) && (P.CompCar.Node < 317))
                    {
                        P.speedLimit = 200;
                        P.location = "Highway";
                    }
                    if ((P.CompCar.Node >= 317) && (P.CompCar.Node < 347))
                    {
                        P.speedLimit = 80;
                        P.location = "Cromo Corner";
                    }
                    if ((P.CompCar.Node >= 347) && (P.CompCar.Node < 377))
                    {
                        P.speedLimit = 150;
                        P.location = "Barnsby Road";
                    }
                    if ((P.CompCar.Node >= 377) && (P.CompCar.Node < 400))
                    {
                        P.speedLimit = 60;
                        P.location = "Embankment";
                    }
                    if ((P.CompCar.Node >= 400) && (P.CompCar.Node < 547))
                    {
                        P.speedLimit = 100;
                        P.location = "Intersection";
                    }
                    if ((P.CompCar.Node >= 547) && (P.CompCar.Node < 553))
                    {
                        P.speedLimit = 50;
                        P.location = "Roundabout";
                    }
                    if ((P.CompCar.Node >= 553) && (P.CompCar.Node < 608))
                    {
                        P.speedLimit = 120;
                        P.location = "Swooping Turns";
                    }
                    if ((P.CompCar.Node >= 608) && (P.CompCar.Node < 694))
                    {
                        P.speedLimit = 80;
                        P.location = "The Big Hill";
                    }
                    if ((P.CompCar.Node >= 694) && (P.CompCar.Node < 700))
                    {
                        P.speedLimit = 40;
                        P.location = "Bank Roundabout";
                    }
                    if ((P.CompCar.Node >= 700) && (P.CompCar.Node < 715))
                    {
                        P.speedLimit = 60;
                        P.location = "Final Furlong";
                    }
                    if ((P.CompCar.Node >= 715) && ((P.CompCar.X / 196608) > -204))
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    if ((P.CompCar.Node >= 715) && ((P.CompCar.X / 196608) < -204) && ((P.CompCar.Y / 196608) > -63))
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    if ((P.CompCar.Node >= 715) && ((P.CompCar.X / 196608) < -204) && ((P.CompCar.Y / 196608) < -147))
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    if (P.CompCar.Node < 65)
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    break;

                case "BL1":
                case "BL1R":
                    if ((P.CompCar.Node >= 731) && ((P.CompCar.X / 196608) <= -203) && ((P.CompCar.Y / 196608) <= -63) && ((P.CompCar.Y / 196608) >= -147))
                    {
                        P.speedLimit = 80;
                        P.location = "Pit Lane";
                    }
                    if ((P.CompCar.Node >= 65) && (P.CompCar.Node < 105))
                    {
                        P.speedLimit = 100;
                        P.location = "Top Corner";
                    }
                    if ((P.CompCar.Node >= 105) && (P.CompCar.Node < 135))
                    {
                        P.speedLimit = 150;
                        P.location = "Follow-Through";
                    }
                    if ((P.CompCar.Node >= 135) && (P.CompCar.Node < 172))
                    {
                        P.speedLimit = 150;
                        P.location = "Lotto straight";
                    }
                    if ((P.CompCar.Node >= 172) && (P.CompCar.Node < 245))
                    {
                        P.speedLimit = 50;
                        P.location = "Hammerhead";
                    }
                    if ((P.CompCar.Node >= 245) && (P.CompCar.Node < 317))
                    {
                        P.speedLimit = 200;
                        P.location = "Autobahn";
                    }
                    if ((P.CompCar.Node >= 317) && (P.CompCar.Node < 347))
                    {
                        P.speedLimit = 80;
                        P.location = "Cromo Corner";
                    }
                    if ((P.CompCar.Node >= 347) && (P.CompCar.Node < 377))
                    {
                        P.speedLimit = 150;
                        P.location = "Barnsby Road";
                    }
                    if ((P.CompCar.Node >= 377) && (P.CompCar.Node < 400))
                    {
                        P.speedLimit = 60;
                        P.location = "Embankment";
                    }
                    if ((P.CompCar.Node >= 400) && (P.CompCar.Node < 547))
                    {
                        P.speedLimit = 100;
                        P.location = "Intersection";
                    }
                    if ((P.CompCar.Node >= 547) && (P.CompCar.Node < 553))
                    {
                        P.speedLimit = 50;
                        P.location = "Roundabout";
                    }
                    if ((P.CompCar.Node >= 553) && (P.CompCar.Node < 608))
                    {
                        P.speedLimit = 120;
                        P.location = "Swooping Turns";
                    }
                    if ((P.CompCar.Node >= 608) && (P.CompCar.Node < 694))
                    {
                        P.speedLimit = 80;
                        P.location = "The Big Hill";
                    }
                    if ((P.CompCar.Node >= 694) && (P.CompCar.Node < 700))
                    {
                        P.speedLimit = 40;
                        P.location = "Bank Roundabout";
                    }
                    if ((P.CompCar.Node >= 700) && (P.CompCar.Node < 715))
                    {
                        P.speedLimit = 60;
                        P.location = "Final Furlong";
                    }
                    if ((P.CompCar.Node >= 715) && ((P.CompCar.X / 196608) > -204))
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    if ((P.CompCar.Node >= 715) && ((P.CompCar.X / 196608) < -204) && ((P.CompCar.Y / 196608) > -63))
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    if ((P.CompCar.Node >= 715) && ((P.CompCar.X / 196608) < -204) && ((P.CompCar.Y / 196608) < -147))
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    if (P.CompCar.Node < 65)
                    {
                        P.speedLimit = 150;
                        P.location = "Pit Straight";
                    }
                    break;
            }
            return P.location;
        }

        #region Matrix System

        public static string matrixAdd(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0').ToString().PadLeft(strIndex, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, "1".PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference - strIndex);
                string tempString2 = tempString1 + "1".PadLeft(strIndex, '0');
                return strIndex.ToString().PadLeft(2, '0').ToString().PadLeft(strIndex, '0') + tempString2;
            }
        }
        public static string matrixAdd(int index, string wholeString, string Stage)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, Stage.PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference - strIndex);
                string tempString2 = tempString1 + Stage.PadLeft(strIndex, '0');
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
        }
        public static string matrixAdd(int index, string wholeString, int Stage)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, Stage.ToString().PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference - strIndex);
                string tempString2 = tempString1 + Stage.ToString().PadLeft(strIndex, '0');
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
        }

        public static string matrixDel(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return strIndex.ToString().PadLeft(2, '0') + wholeString;
            }

            if (index * strIndex <= wholeString.Length)
            {
                string tempString1;
                string tempString2;
                tempString1 = wholeString.Remove(index * strIndex - strIndex, strIndex);
                tempString2 = tempString1.Insert(index * strIndex - strIndex, "0".PadLeft(strIndex, '0'));
                return strIndex.ToString().PadLeft(2, '0') + tempString2;
            }
            else
            {
                int idxDifference = index * strIndex - wholeString.Length;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
        }

        static public string matrixMerge(string wholeString1, string wholeString2, bool destroy)
        {
            string returnString = wholeString1;
            if (wholeString1 == wholeString2)
            {
                return returnString;
            }
            else
            {
                string idxString = wholeString1;
                if (matrixIndexSum(wholeString2) > matrixIndexSum(idxString))
                {
                    idxString = wholeString2;
                }

                for (int i = 1; i <= matrixIndexSum(idxString); i++)
                {
                    if (destroy == false)
                    {
                        if (misc.matrixIsNotZero(i, wholeString2) == true)
                        {
                            returnString = misc.matrixAdd(i, returnString);
                        }
                    }
                    else
                    {
                        if (misc.matrixIsNotZero(i, wholeString2) == false)
                        {
                            returnString = misc.matrixDel(i, returnString);
                        }
                    }
                }
            }
            return returnString;
        }

        public static string matrixRangeFix(int range, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (range * strIndex < wholeString.Length)
            {
                int idxDifference = wholeString.Length - range * strIndex;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            else if (range * strIndex > wholeString.Length)
            {
                if (wholeString.Remove(0, range * strIndex - strIndex).Contains("1") == false)
                {
                    int idxDifference = range * strIndex - wholeString.Length;
                    string tempString1 = wholeString.Remove(range * strIndex - strIndex);
                    return strIndex.ToString().PadLeft(2, '0') + tempString1;
                }
            }
            return strIndex.ToString().PadLeft(2, '0') + wholeString;
        }
        public static string matrixRangeFixToOne(int range, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (range * strIndex < wholeString.Length)
            {
                int idxDifference = wholeString.Length - range * strIndex;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            else if (range * strIndex > wholeString.Length)
            {
                if (wholeString.Remove(0, range * strIndex - strIndex).Contains("1") == false)
                {
                    string tempString1 = wholeString.Remove(range * strIndex - strIndex);
                    return strIndex.ToString().PadLeft(2, '0') + tempString1;
                }
                else
                {
                    string tempString1 = wholeString.Remove(wholeString.LastIndexOf('1'));
                    return strIndex.ToString().PadLeft(2, '0') + tempString1;
                }
            }
            return strIndex.ToString().PadLeft(2, '0') + wholeString;
        }
        public static string matrixRangeFixOverride(int range, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (range * strIndex < wholeString.Length)
            {
                int idxDifference = wholeString.Length - range * strIndex;
                string tempString1 = new string('0', idxDifference);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            else if (range * strIndex > wholeString.Length)
            {
                string tempString1 = wholeString.Remove(range * strIndex - strIndex);
                return strIndex.ToString().PadLeft(2, '0') + tempString1;
            }
            return strIndex.ToString().PadLeft(2, '0') + wholeString;
        }

        public static bool matrixIsNotZero(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return false;
            }

            Regex r = new Regex("[0-9]".PadLeft(strIndex, '|').Replace("|", "[0-9]"));
            string s = wholeString.Substring(index * strIndex - strIndex, strIndex);
            if (s != "0".PadLeft(strIndex, '0'))
            {
                return r.IsMatch(s);
            }
            else
            {
                return false;
            }
        }
        public static bool matrixIsOne(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return false;
            }

            return wholeString.Substring(index * strIndex - strIndex, strIndex).Contains("1".PadLeft(strIndex, '0'));
        }
        public static string matrixIndex(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return "0".PadLeft(strIndex, '0');
            }

            return wholeString.Substring((index * strIndex) - strIndex, strIndex);
        }
        public static int matrixIndexSum(string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            return wholeString.Length / strIndex;
        }
        public static int matrixIndexSum(string wholeString, bool zeroTracking)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            int indexSum = 0;
            wholeString = wholeString.Replace("9", "1");
            wholeString = wholeString.Replace("8", "1");
            wholeString = wholeString.Replace("7", "1");
            wholeString = wholeString.Replace("6", "1");
            wholeString = wholeString.Replace("5", "1");
            wholeString = wholeString.Replace("4", "1");
            wholeString = wholeString.Replace("3", "1");
            wholeString = wholeString.Replace("2", "1");

            for (int i = 0; i < wholeString.Length / strIndex; i++)
            {
                if (zeroTracking == false)
                {
                    if (wholeString.Contains("1") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == true)
                        {
                            indexSum += 1;
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
                else
                {
                    if (wholeString.Contains("0") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == false)
                        {
                            indexSum += 1;
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
            }
            return indexSum;
        }
        public static int matrixIndexSerialNumber(int index, string wholeString, bool zeroTracking)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            int indexSum = 0;
            wholeString = wholeString.Replace("9", "1");
            wholeString = wholeString.Replace("8", "1");
            wholeString = wholeString.Replace("7", "1");
            wholeString = wholeString.Replace("6", "1");
            wholeString = wholeString.Replace("5", "1");
            wholeString = wholeString.Replace("4", "1");
            wholeString = wholeString.Replace("3", "1");
            wholeString = wholeString.Replace("2", "1");

            for (int i = 0; i < wholeString.Length / strIndex; i++)
            {
                if (zeroTracking == false)
                {
                    if (wholeString.Contains("1") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == true)
                        {
                            indexSum += 1;
                            if (indexSum == index)
                            {
                                return i;
                            }
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
                else
                {
                    if (wholeString.Contains("0") == true && i < 100000)
                    {
                        if (matrixIsNotZero(i, strIndex.ToString().PadLeft(2, '0') + wholeString) == false)
                        {
                            indexSum += 1;
                            if (indexSum == index)
                            {
                                return i;
                            }
                        }
                    }
                    else
                    {
                        Form1.InSim.Send_MST_Message("/msg ^3» ^1ERROR: ^7matrixIndexSum receiver: REL");
                        Form1.InSim.Send_MST_Message("/msg ^3» ^7Function ^1stopped^7. A value of 0(zero) was returned.");
                        //REL = Risk of Endless Loop
                        return 0;
                    }
                }
            }
            return indexSum;
        }

        public static int matrixStage(int index, string wholeString)
        {
            int strIndex = int.Parse(wholeString.Remove(2));
            int maxIndex = int.Parse(new String('9', strIndex));
            wholeString = wholeString.Remove(0, 2);

            if (index < 1 || index > wholeString.Length)
            {
                return 0;
            }

            return int.Parse(wholeString.Substring(index * strIndex - strIndex, strIndex));
        }
        #endregion
    }
}
