﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace LFS_External_Client
{
    class globalVars
    {
        #region serverStats

        static public readonly string globalDataFolderPath = Path.Combine(Application.StartupPath, "data");
        static public readonly string globalOscFolderPath = Path.Combine(globalDataFolderPath, "osc");
        static public readonly string globalConfigBackupFolderPath = Path.Combine(globalOscFolderPath, "globalConfigBackup");
        static public readonly string globalHandledExceptionReportFilePath = Path.Combine(globalOscFolderPath, "handledErrorLog.osc");
        static public readonly string globalConfigFilePath = Path.Combine(globalOscFolderPath, "globalConfig.osc");
        static public readonly string globalRunningFilePath = Path.Combine(globalOscFolderPath, "runningFile.osc");
        static public readonly string globalUserMarksFilePath = Path.Combine(globalOscFolderPath, "userMarks.osc");
        static public readonly string globalSpecialSymbolsFilePath = Path.Combine(globalOscFolderPath, "specSymb.osc");
        static public readonly string globalConfigBackupFilePath = Path.Combine(globalConfigBackupFolderPath, "globalConfigBackup(" + System.DateTime.Now.ToFileTime() + ").osc");

        static public bool checkCreateDirsFiles()
        {
            try
            {
                if (Directory.Exists(globalDataFolderPath) == false)
                {
                    Directory.CreateDirectory(globalDataFolderPath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: Folder 1 - ^1missing^7. Folder created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: Folder 1 - ^2OK^7.");
                }

                if (Directory.Exists(globalOscFolderPath) == false)
                {
                    Directory.CreateDirectory(globalOscFolderPath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: Folder 2 - ^1missing^7. Folder created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: Folder 2 - ^2OK^7.");
                }

                if (Directory.Exists(globalConfigBackupFolderPath) == false)
                {
                    Directory.CreateDirectory(globalConfigBackupFolderPath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: Folder 3 - ^1missing^7. Folder created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: Folder 3 - ^2OK^7.");
                }

                // FOLDERS | FILES
                // <<<<<<< | >>>>>

                if (File.Exists(globalConfigFilePath) == false)
                {
                    File.Create(globalConfigFilePath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 1 - ^1missing^7. File created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 1 - ^2OK^7.");
                }

                if (File.Exists(globalConfigFilePath) == false)
                {
                    File.Create(globalConfigFilePath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 2 - ^1missing^7. File created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 2 - ^2OK^7.");
                }

                if (File.Exists(globalRunningFilePath) == false)
                {
                    File.Create(globalRunningFilePath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 3 - ^1missing^7. File created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 3 - ^2OK^7.");
                }

                if (File.Exists(globalUserMarksFilePath) == false)
                {
                    File.Create(globalUserMarksFilePath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 4 - ^1missing^7. File created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 4 - ^2OK^7.");
                }

                if (File.Exists(globalSpecialSymbolsFilePath) == false)
                {
                    File.Create(globalSpecialSymbolsFilePath);
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 5 - ^1missing^7. File created.");
                }
                else
                {
                    Form1.InSim.Send_MST_Message("/msg ^7Startup check: File 5 - ^2OK^7.");
                }
                return true;
            }
            catch (Exception E)
            {
                misc.manageHandledException(E);
                return false;
            }
        }

        //Encoded
        static public string rootEC = "0111111";
        //Internet Protocol
        static public string rootIP = "127.0.0.1";
        //Administration Password
        static public string rootAP = "";
        //Port
        static public ushort rootPT = 0;
        //Auto Connect
        static public bool rootAC = false;
        //MCI Interval
        static public ushort rootMI = 500;

        #endregion

        #region specialSymbols

        static public void updateSpecialSymbolsFromFile()
        {
            try
            {
                if (File.Exists(globalSpecialSymbolsFilePath) == true)
                {
                    StreamReader Sr = new StreamReader(globalSpecialSymbolsFilePath);

                    while (Sr.Peek() >= 0)
                    {
                        string Msg = Sr.ReadLine();
                        string[] StrLine = Msg.Split(' ');
                        switch (StrLine[0].ToLower())
                        {
                            case "arrowup":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowUp = StrLine[1].Trim();
                                }
                                break;

                            case "arrowupright":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowUpRight = StrLine[1].Trim();
                                }
                                break;

                            case "arrowright":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowRight = StrLine[1].Trim();
                                }
                                break;

                            case "arrowdownright":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowDownRight = StrLine[1].Trim();
                                }
                                break;

                            case "arrowdown":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowDown = StrLine[1].Trim();
                                }
                                break;

                            case "arrowdownleft":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowDownLeft = StrLine[1].Trim();
                                }
                                break;

                            case "arrowleft":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowLeft = StrLine[1].Trim();
                                }
                                break;

                            case "arrowupleft":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    arrowUpLeft = StrLine[1].Trim();
                                }
                                break;

                            case "filledcirle":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    filledCirle = StrLine[1].Trim();
                                }
                                break;

                            case "twolinedcirle":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    twoLinedCirle = StrLine[1].Trim();
                                }
                                break;

                            case "singlelinedcirle":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    singleLinedCirle = StrLine[1].Trim();
                                }
                                break;

                            case "moneysign":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    moneySign = StrLine[1].Trim();
                                }
                                break;

                            case "doublearrowleft":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    doubleArrowLeft = StrLine[1].Trim();
                                }
                                break;

                            case "doublearrowright":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    doubleArrowRight = StrLine[1].Trim();
                                }
                                break;

                            case "xclosedisablesign":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    xCloseDisableSign = StrLine[1].Trim();
                                }
                                break;

                            case "venablesign":
                                if (StrLine[1].Trim() != "ORG")
                                {
                                    vEnableSign = StrLine[1].Trim();
                                }
                                break;
                        }
                    }
                }
            }
            catch (Exception E)
            {
                misc.manageHandledException(E);
            }
        }
        static public void updateSpecialSymbolsToFile()
        {
            try
            {
                if (File.Exists(globalSpecialSymbolsFilePath) == false)
                {
                    File.Create(globalSpecialSymbolsFilePath);
                }
                StreamWriter Sw = new StreamWriter(globalSpecialSymbolsFilePath);
                Sw.WriteLine("arrowUp " + arrowUp);
                Sw.WriteLine("arrowUpRight " + arrowUpRight);
                Sw.WriteLine("arrowRight " + arrowRight);
                Sw.WriteLine("arrowDownRight " + arrowDownRight);
                Sw.WriteLine("arrowDown " + arrowDown);
                Sw.WriteLine("arrowDownLeft " + arrowDownLeft);
                Sw.WriteLine("arrowLeft " + arrowLeft);
                Sw.WriteLine("arrowUpLeft " + arrowUpLeft);
                Sw.WriteLine();
                Sw.WriteLine("filledCirle " + filledCirle);
                Sw.WriteLine("twoLinedCirle " + twoLinedCirle);
                Sw.WriteLine("singLelinedCirle " + singleLinedCirle);
                Sw.WriteLine();
                Sw.WriteLine("moneySign " + moneySign);
                Sw.WriteLine();
                Sw.WriteLine("doubleArrowLeft " + doubleArrowLeft);
                Sw.WriteLine("doubleArrowRight " + doubleArrowRight);
                Sw.WriteLine();
                Sw.WriteLine("xCloseDisableSign " + xCloseDisableSign);
                Sw.WriteLine("vEnableSign " + vEnableSign);
                Sw.Flush();
                Sw.Close();
            }
            catch (Exception E)
            {
                misc.manageHandledException(E);
            }
        }

        static public string arrowUp = "^HЎф";
        static public string arrowUpLeft = "^HЎш";
        static public string arrowUpRight = "^HЎщ";
        static public string arrowDown = "^HЎх";
        static public string arrowDownLeft = "^HЎъ";
        static public string arrowDownRight = "^HЎы";
        static public string arrowLeft = "^HЎц";
        static public string arrowRight = "^HЎч";

        static public string filledCirle = "^SЎр";
        static public string twoLinedCirle = "^SЎт";
        static public string singleLinedCirle = "^SЎс";

        static public string moneySign = "$";

        static public string doubleArrowLeft = "^JЃб";
        static public string doubleArrowRight = "^JЃв";

        static public string xCloseDisableSign = "^SЎБ";
        static public string vEnableSign = "^SЎМ";
        #endregion

        static public string[] HSDN = "None".Split(' ');
        static public string currentTrack = "";
        static public string serverName = "host";
        static public bool dbCanConnect = true;
        static public bool dbBlockOutgoing = false;
    }
}
