﻿using System;
using System.Collections.Generic;
using System.Text;

namespace LFS_External_Client
{
    class buttonSequence
    {
        static public void createSequence(string sequenceName, byte UCID, clsConnection C)
        {
            switch (sequenceName.ToLower())
            {
                case "hudfull":
                    createSequence("hudPart1", UCID, C, 3, 135, 0, 0, 0);
                    createSequence("hudPart2", UCID, C, 3, 183, 0, 0, 0);
                    break;

                case "hudpart1su":
                case "hudpart1smartupdate":
                    createSequence("hudPart1smartUpdate", UCID, C, 3, 135, 0, 0, 0);
                    break;

                case "hudpart2locspdlmt":
                    createSequence("hudpart2loc", UCID, C, 3, 183, 0, 0, 0);
                    createSequence("hudpart2spdlmt", UCID, C, 3, 183, 0, 0, 0);
                    break;
                case "hudpart2loc":
                    createSequence("hudpart2loc", UCID, C, 3, 183, 0, 0, 0);
                    break;
                case "hudpart2spdlmt":
                    createSequence("hudpart2spdlmt", UCID, C, 3, 183, 0, 0, 0);
                    break;
            }
        }
        static public void createSequence(string sequenceName, byte UCID, clsConnection C, byte posX, byte posY, int scalGlobal, int scalX, int scalY)
        {
            switch (sequenceName.ToLower())
            {
                case "hudpart1":
                    Form1.InSim.Send_BTN_CreateButton("", (LFS_External.InSim.Flags.ButtonStyles)(32), (byte)(48 + scalGlobal + scalY), (byte)(26 + scalGlobal + scalX), posY, posX, 10, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("^7-TAG- www.omgthatPWND.me", (LFS_External.InSim.Flags.ButtonStyles)(0), (byte)(4 + scalGlobal + scalY), (byte)(24 + scalGlobal + scalX), (byte)(posY + 2), (byte)(posX + 1), 11, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("^7Money", (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(7), (byte)(posY + 11), (byte)(posX + 2), 12, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("^6" + globalVars.moneySign + C.money, (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(15 + scalGlobal + scalX), (byte)(posY + 10), (byte)(posX + 9), 13, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("+" + globalVars.moneySign + (C.money - C.moneyInitial), (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(15 + scalGlobal + scalX), (byte)(posY + 14), (byte)(posX + 9), 14, UCID, 2, false);

                    int distanceSincePits = misc.convertToPlayer(C).distanceSincePits;
                    if (distanceSincePits > 50000)
                    {
                        distanceSincePits = 50000;
                    }
                    string bonusStr1 = new string('|', distanceSincePits / 1000);
                    string bonusStr2 = new string('|', 50 - distanceSincePits / 1000);
                    string bonusStr = "^2" + bonusStr1 + "^0" + bonusStr2;

                    Form1.InSim.Send_BTN_CreateButton("^7Bonus", (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 18), (byte)(posX + 2), 15, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("^7(^6" + misc.convertToPlayer(C).distanceSincePits / 500 + "%^7)", (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 18), (byte)(posX + 2), 16, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton(bonusStr, (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 22), (byte)(posX + 2), 17, UCID, 2, false);

                    int health = C.health;
                    if (health > 100000)
                    {
                        health = 100000;
                    }
                    string healthStr1 = new string('|', health / 2000);
                    string healthStr2 = new string('|', 50 - health / 2000);
                    string healthStr = "^2" + healthStr1 + "^0" + healthStr2;

                    Form1.InSim.Send_BTN_CreateButton("^7Health", (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 26), (byte)(posX + 2), 18, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("^7(^6" + C.health / 1000 + "%^7)", (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 26), (byte)(posX + 2), 19, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton(healthStr, (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 30), (byte)(posX + 2), 20, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton("^8" + C.distanceTotal.ToString().PadLeft(4, '0').Insert(C.distanceTotal.ToString().PadLeft(4, '0').Length - 3, ".") + "km", (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 36), (byte)(posX + 2), 21, UCID, 2, false);

                    string carsStr1 = "";
                    string carsStr2 = "";
                    try
                    {
                        for (int i = 1; i <= misc.matrixIndexSum(C.cars); i++)
                        {
                            if (i <= misc.matrixIndexSum(C.cars) / 2)
                            {
                                if (misc.matrixIsNotZero(i, C.cars) == true)
                                {
                                    carsStr1 += "^6" + CarHelper.getCarName(i) + " ";
                                }
                                else
                                {
                                    carsStr1 += "^7" + CarHelper.getCarName(i) + " ";
                                }
                            }
                            else
                            {
                                if (misc.matrixIsNotZero(i, C.cars) == true)
                                {
                                    carsStr2 += "^6" + CarHelper.getCarName(i) + " ";
                                }
                                else
                                {
                                    carsStr2 += "^7" + CarHelper.getCarName(i) + " ";
                                }
                            }
                        }
                        carsStr1.Remove(carsStr1.Length - 1);
                        carsStr2.Remove(carsStr2.Length - 1);
                    }
                    catch
                    {
                        carsStr1 = "^3UF1 XFG XRG LX4 LX6 RB4 FXO XRT";
                        carsStr2 = "^3VWS RAC FZ5 UFR XFR FXR XRR FZR";
                    }

                    Form1.InSim.Send_BTN_CreateButton(carsStr1, (LFS_External.InSim.Flags.ButtonStyles)(0), (byte)(3 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 40), (byte)(posX + 2), 22, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton(carsStr2, (LFS_External.InSim.Flags.ButtonStyles)(0), (byte)(3 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 43), (byte)(posX + 2), 23, UCID, 2, false);
                    break;

                case "hudpart1smartupdate":
                    if (C.money != C.moneyPrev)
                    {
                        Form1.InSim.Send_BTN_CreateButton("^6" + globalVars.moneySign + C.money, (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(15 + scalGlobal + scalX), (byte)(posY + 10), (byte)(posX + 9), 13, UCID, 2, false);
                        Form1.InSim.Send_BTN_CreateButton("+" + globalVars.moneySign + (C.money - C.moneyInitial), (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(15 + scalGlobal + scalX), (byte)(posY + 14), (byte)(posX + 9), 14, UCID, 2, false);
                        C.moneyPrev = C.money;
                    }

                    distanceSincePits = misc.convertToPlayer(C).distanceSincePits;
                    if (distanceSincePits > 50000)
                    {
                        distanceSincePits = 50000;
                    }
                    bonusStr1 = new string('|', distanceSincePits / 1000);
                    bonusStr2 = new string('|', 50 - distanceSincePits / 1000);
                    bonusStr = "^2" + bonusStr1 + "^0" + bonusStr2;
                    int distanceSincePitsPrev = misc.convertToPlayer(C).distanceSincePitsPrev;
                    if (distanceSincePitsPrev > 50000)
                    {
                        distanceSincePitsPrev = 50000;
                    }
                    string bonusStr1Prev = new string('|', distanceSincePitsPrev / 1000);
                    string bonusStr2Prev = new string('|', 50 - distanceSincePitsPrev / 1000);
                    string bonusStrPrev = "^2" + bonusStr1Prev + "^0" + bonusStr2Prev;
                    if (misc.convertToPlayer(C).distanceSincePits / 500 != misc.convertToPlayer(C).distanceSincePitsPrev / 500)
                    {
                        Form1.InSim.Send_BTN_CreateButton("^7(^6" + misc.convertToPlayer(C).distanceSincePits / 500 + "%^7)", (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 18), (byte)(posX + 2), 16, UCID, 2, false);
                        Form1.InSim.Send_BTN_CreateButton(bonusStr, (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 22), (byte)(posX + 2), 17, UCID, 2, false);
                    }
                    else if (bonusStr != bonusStrPrev)
                    {
                        Form1.InSim.Send_BTN_CreateButton(bonusStr, (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 22), (byte)(posX + 2), 17, UCID, 2, false);
                    }

                    health = C.health;
                    if (health > 100000)
                    {
                        health = 100000;
                    }
                    healthStr1 = new string('|', health / 2000);
                    healthStr2 = new string('|', 50 - health / 2000);
                    healthStr = "^2" + healthStr1 + "^0" + healthStr2;
                    int healthPrev = C.healthPrev;
                    if (healthPrev > 100000)
                    {
                        healthPrev = 100000;
                    }
                    string healthStr1Prev = new string('|', healthPrev / 2000);
                    string healthStr2Prev = new string('|', 50 - healthPrev / 2000);
                    string healthStrPrev = "^2" + healthStr1Prev + "^0" + healthStr2Prev;
                    if (C.health / 1000 != C.healthPrev / 1000)
                    {
                        Form1.InSim.Send_BTN_CreateButton("^7(^6" + C.health / 1000 + "%^7)", (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 26), (byte)(posX + 2), 19, UCID, 2, false);
                    }
                    if (healthStr != healthStrPrev)
                    {
                        Form1.InSim.Send_BTN_CreateButton(healthStr, (LFS_External.InSim.Flags.ButtonStyles)(64), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 30), (byte)(posX + 2), 20, UCID, 2, false);
                    }
                    if (C.distanceTotal.ToString().PadLeft(4, '0').Insert(C.distanceTotal.ToString().PadLeft(4, '0').Length - 3, ".") != C.distanceTotalPrev.ToString().PadLeft(4, '0').Insert(C.distanceTotalPrev.ToString().PadLeft(4, '0').Length - 3, "."))
                    {
                        Form1.InSim.Send_BTN_CreateButton("^8" + C.distanceTotal.ToString().PadLeft(4, '0').Insert(C.distanceTotal.ToString().PadLeft(4, '0').Length - 3, ".") + "km", (LFS_External.InSim.Flags.ButtonStyles)(128), (byte)(4 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 36), (byte)(posX + 2), 21, UCID, 2, false);
                    }

                    carsStr1 = "";
                    carsStr2 = "";
                    try
                    {
                        for (int i = 1; i <= misc.matrixIndexSum(C.cars); i++)
                        {
                            if (i <= misc.matrixIndexSum(C.cars) / 2)
                            {
                                if (misc.matrixIsNotZero(i, C.cars) == true)
                                {
                                    carsStr1 += "^6" + CarHelper.getCarName(i) + " ";
                                }
                                else
                                {
                                    carsStr1 += "^7" + CarHelper.getCarName(i) + " ";
                                }
                            }
                            else
                            {
                                if (misc.matrixIsNotZero(i, C.cars) == true)
                                {
                                    carsStr2 += "^6" + CarHelper.getCarName(i) + " ";
                                }
                                else
                                {
                                    carsStr2 += "^7" + CarHelper.getCarName(i) + " ";
                                }
                            }
                        }
                        carsStr1.Remove(carsStr1.Length - 1);
                        carsStr2.Remove(carsStr2.Length - 1);
                    }
                    catch
                    {
                        carsStr1 = "^3UF1 XFG XRG LX4 LX6 RB4 FXO XRT";
                        carsStr2 = "^3VWS RAC FZ5 UFR XFR FXR XRR FZR";
                    }

                    string carsStr1Prev = "";
                    string carsStr2Prev = "";
                    try
                    {
                        for (int i = 1; i <= misc.matrixIndexSum(C.carsPrev); i++)
                        {
                            if (i <= misc.matrixIndexSum(C.carsPrev) / 2)
                            {
                                if (misc.matrixIsNotZero(i, C.carsPrev) == true)
                                {
                                    carsStr1Prev += "^6" + CarHelper.getCarName(i) + " ";
                                }
                                else
                                {
                                    carsStr1Prev += "^7" + CarHelper.getCarName(i) + " ";
                                }
                            }
                            else
                            {
                                if (misc.matrixIsNotZero(i, C.carsPrev) == true)
                                {
                                    carsStr2Prev += "^6" + CarHelper.getCarName(i) + " ";
                                }
                                else
                                {
                                    carsStr2Prev += "^7" + CarHelper.getCarName(i) + " ";
                                }
                            }
                        }
                        carsStr1Prev.Remove(carsStr1Prev.Length - 1);
                        carsStr2Prev.Remove(carsStr2Prev.Length - 1);
                    }
                    catch
                    {
                        carsStr1Prev = "^3UF1 XFG XRG LX4 LX6 RB4 FXO XRT";
                        carsStr2Prev = "^3VWS RAC FZ5 UFR XFR FXR XRR FZR";
                    }

                    if (carsStr1 != carsStr1Prev)
                    {
                        Form1.InSim.Send_BTN_CreateButton(carsStr1, (LFS_External.InSim.Flags.ButtonStyles)(0), (byte)(3 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 40), (byte)(posX + 2), 22, UCID, 2, false);
                    }
                    if (carsStr2 != carsStr2Prev)
                    {
                        Form1.InSim.Send_BTN_CreateButton(carsStr2, (LFS_External.InSim.Flags.ButtonStyles)(0), (byte)(3 + scalGlobal + scalY), (byte)(22 + scalGlobal + scalX), (byte)(posY + 43), (byte)(posX + 2), 23, UCID, 2, false);
                    }
                    break;

                #region hudPart2
                case "hudpart2":
                    Form1.InSim.Send_BTN_CreateButton("", (LFS_External.InSim.Flags.ButtonStyles)(32), (byte)(10 + scalGlobal + scalY), (byte)(30 + scalGlobal + scalX), posY, posX, 24, UCID, 2, false);
                    Form1.InSim.Send_BTN_CreateButton(misc.getLocationOfPlayer(misc.convertToPlayer(C)), (LFS_External.InSim.Flags.ButtonStyles)(65), (byte)(4 + scalGlobal + scalY), (byte)(28 + scalGlobal + scalX), (byte)(posY + 1), (byte)(posX + 1), 25, UCID, 2, false);
                    string spdlmtclr1 = "";
                    if (misc.convertToPlayer(C).currentSpeedKph > misc.convertToPlayer(C).speedLimit)
                    {
                        spdlmtclr1 = "^1";
                    }
                    Form1.InSim.Send_BTN_CreateButton("Speed limit: " + spdlmtclr1 + misc.convertToPlayer(C).speedLimit + "km/h", (LFS_External.InSim.Flags.ButtonStyles)(65), (byte)(4 + scalGlobal + scalY), (byte)(28 + scalGlobal + scalX), (byte)(posY + 5), (byte)(posX + 1), 26, UCID, 2, false);
                    break;
                case "hudpart2back":
                    Form1.InSim.Send_BTN_CreateButton("", (LFS_External.InSim.Flags.ButtonStyles)(32), (byte)(10 + scalGlobal + scalY), (byte)(30 + scalGlobal + scalX), posY, posX, 24, UCID, 2, false);
                    break;
                case "hudpart2location":
                case "hudpart2loc":
                    Form1.InSim.Send_BTN_CreateButton(misc.getLocationOfPlayer(misc.convertToPlayer(C)), (LFS_External.InSim.Flags.ButtonStyles)(65), (byte)(4 + scalGlobal + scalY), (byte)(28 + scalGlobal + scalX), (byte)(posY + 1), (byte)(posX + 1), 25, UCID, 2, false);
                    break;
                case "hudpart2speedlimit":
                case "hudpart2spdlmt":
                    string spdlmtclr2 = "";
                    if (misc.convertToPlayer(C).currentSpeedKph > misc.convertToPlayer(C).speedLimit)
                    {
                        spdlmtclr2 = "^1";
                    }
                    Form1.InSim.Send_BTN_CreateButton("Speed limit: " + spdlmtclr2 + misc.convertToPlayer(C).speedLimit + "km/h", (LFS_External.InSim.Flags.ButtonStyles)(65), (byte)(4 + scalGlobal + scalY), (byte)(28 + scalGlobal + scalX), (byte)(posY + 5), (byte)(posX + 1), 26, UCID, 2, false);
                    break;
                #endregion
            }
        }

        static public void deleteSequence(string sequenceName, byte UCID)
        {
            byte startID = 0;
            byte endID = 0;
            switch (sequenceName.ToLower())
            {
                case "hudfull":
                    startID = 10;
                    endID = 23;
                    break;
            }

            #region Proccess of deletion
            if (startID < endID && endID > 1)
            {
                byte tempByte1 = startID;
                while (tempByte1 <= endID)
                {
                    Form1.InSim.Send_BFN_DeleteButton(LFS_External.Enums.BtnFunc.BFN_DEL_BTN, tempByte1, UCID);
                    tempByte1 += 1;
                }
            }
            #endregion
        }
    }
}
