﻿using System;
using System.Text.RegularExpressions;
using System.Net;

namespace LFS_External_Client
{
    public static class StringHelper
    {
        private static Regex coloursRegex = new Regex(@"\^[0-9]");

        public static string StripColours(string str)
        {
            return coloursRegex.Replace(str, string.Empty);
        }

        public static string TimeString(long ms)
        {
            return TimeString(ms, false);
        }

        public static string TimeString(long ms, bool hours)
        {
            int h = (int)Math.Floor((double)ms / 3600000);
            int m = (int)Math.Floor((double)ms / 1000 / 60) % 60;
            int s = (int)Math.Floor((double)ms / 1000) % 60;
            int t = (int)ms % 1000;

            if ((h > 0) || hours)
            {
                return string.Format("{0}:{1:00}:{2:00}.{3:000}", h, m, s, t);
            }
            return string.Format("{0}:{1:00}.{2:000}", m, s, t);
        }

        public static bool CheckIP(string ip)
        {
            IPAddress temp;
            return IPAddress.TryParse(ip, out temp);
        }

        public static bool CheckPort(string port)
        {
            ushort temp;
            return ushort.TryParse(port, out temp);
        }

        public static bool CheckPort(int port)
        {
            return port >= ushort.MinValue && port <= ushort.MaxValue;
        }
    }
}
