﻿using System;
using System.Collections.Generic;
using System.Text;

namespace LFS_External_Client
{
    public static class CarHelper
    {
        private static Dictionary<string, string> cars;

        static CarHelper()
        {
            cars = new Dictionary<string, string>()
            {
                { "XFG", "XF GTI" },
                { "XRG", "XR GT" },
                { "FBM", "Formula BMW" },
                { "XRT", "XR GT Turbo" },
                { "RB4", "RB4 GT" },
                { "FXO", "FXO Turbo" },
                { "LX4", "LX4" },
                { "LX6", "LX6" },
                { "MRT", "MRT5" },
                { "UF1", "UF 1000" },
                { "RAC", "RaceAbout" },
                { "FZ5", "FZ50" },
                { "XFR", "XF GTR" },
                { "UFR", "UF GTR" },
                { "FOX", "Formula XR" },
                { "FO8", "Formula V8" },
                { "BF1", "BMW Sauber F1" },
                { "FXR", "FXO GTR" },
                { "XRR", "XR GTR" },
                { "FZR", "FZ50 GTR" },
                { "VWS", "VW Scirocco" },
            };
        }

        public static string GetFullCarName(string shortCarName)
        {
            return cars[shortCarName];
        }

        public static string[] GetAllCars()
        {
            List<string> items = new List<string>();
            foreach (KeyValuePair<string, string> car in cars)
            {
                items.Add(car.Value);
            }
            return items.ToArray();
        }

        static public int getCarNumber(string carName)
        {
            switch (carName.ToUpper())
            {
                case "UF1": return 1;
                case "XFG": return 2;
                case "XRG": return 3;
                case "LX4": return 4;
                case "LX6": return 5;
                case "RB4": return 6;
                case "FXO": return 7;
                case "XRT": return 8;
                case "VWS": return 9;
                case "RAC": return 10;
                case "FZ5": return 11;
                case "UFR": return 12;
                case "XFR": return 13;
                case "FXR": return 14;
                case "XRR": return 15;
                case "FZR": return 16;
                case "MRT": return 17;
                case "FOX": return 18;
                case "FBM": return 19;
                case "FO8": return 20;
                case "BF1": return 21;
                case "SUM": return 21;
            }
            return 0;
        }

        static public string getCarName(int carNumber)
        {
            switch (carNumber)
            {
                case 1: return "UF1";
                case 2: return "XFG";
                case 3: return "XRG";
                case 4: return "LX4";
                case 5: return "LX6";
                case 6: return "RB4";
                case 7: return "FXO";
                case 8: return "XRT";
                case 9: return "VWS";
                case 10: return "RAC";
                case 11: return "FZ5";
                case 12: return "UFR";
                case 13: return "XFR";
                case 14: return "FXR";
                case 15: return "XRR";
                case 16: return "FZR";
                case 17: return "MRT";
                case 18: return "FOX";
                case 19: return "FBM";
                case 20: return "FO8";
                case 21: return "BF1";
            }
            return "XXX";
        }

        static public string getAllowedCarsString(string matrixString, bool zeroTracking)
        {
            string returnString = "";

            for (int i = 1; i <= getCarNumber("SUM"); i++)
            {
                if (zeroTracking == false)
                {
                    if (misc.matrixIsNotZero(i, matrixString) == true)
                    {
                        returnString += getCarName(i) + " ";
                    }
                }
                else
                {
                    if (misc.matrixIsNotZero(i, matrixString) == false)
                    {
                        returnString += getCarName(i) + " ";
                    }
                }
            }

            if (returnString == "")
            {
                return "_undetected";
            }
            else
            {
                return returnString.Remove(returnString.Length - 1);
            }
        }
    }
}
