import plugin
import datetime
import os

CURRENT_DIR = os.path.dirname(__file__)

# uname, pname, track, car, lap_num, sp1, sp2, sp3, time

class LapInfo(object):
    def __init__(self):
        self.splits = [0,0,0]
        self.last_split = 0

class LapCSV(plugin.Plugin):
    def __init__(self):
        plugin.Plugin.__init__(self)
        self.bind(plugin.ISP_RST, self.race_start)
        self.bind(plugin.ISP_TINY, self.tiny)
        self.bind(plugin.ISP_SPX, self.split)
        self.bind(plugin.ISP_LAP, self.lap)
        self.bind(plugin.ISP_MSO, self.message_out)
        
    def connected(self, host):
        host.send(plugin.ISP_TINY, ReqI=255, SubT=plugin.TINY_RST)
        
    def disconnected(self, host):
        if hasattr(host, 'logging') and host.logging:
            host.file.close()
            host.logging = False
        
    def create_name(self, track):
        now = datetime.datetime.now()
        return '%s_%s.csv' % (track, now.strftime('%d_%m_%Y_%H_%M_%S'))       
        
    def race_start(self, host, rst):
        if hasattr(host, 'logging') and host.logging:
            host.file.close()
            host.logging = False
        name = self.create_name(rst.Track)
        path = os.path.join(CURRENT_DIR, name)
        host.file = open(path, 'w')
        host.logging = True
        
    def tiny(self, host, tiny):
        if tiny.SubT == plugin.TINY_REN:
            if hasattr(host, 'logging') and host.logging:
                host.file.close()
                host.logging = False
        
    def split(self, host, spx):
        npl = host.players[spx.PLID]
        if not hasattr(npl, 'lap_info'):
            npl.lap_info = LapInfo()
        npl.lap_info.splits[spx.Split-1] = (spx.STime - npl.lap_info.last_split)
        npl.lap_info.last_split = spx.STime
        
    def lap(self, host, lap):
        if hasattr(host, 'logging') and host.logging:
            npl = host.players[lap.PLID]
            if not hasattr(npl, 'lap_info'):
                npl.lap_info = LapInfo()        
            ncn = host.conns[npl.UCID]
            sp1 = npl.lap_info.splits[0]
            sp2 = npl.lap_info.splits[1]
            sp3 = lap.LTime - npl.lap_info.last_split
            host.file.write('%s,%s,%s,%s,%d,%s,%s,%s,%s\n' % (ncn.UName, 
                                                              ncn.PName, 
                                                              host.state.Track, 
                                                              npl.CName, 
                                                              lap.LapsDone,
                                                              plugin.timestr(sp1), 
                                                              plugin.timestr(sp2), 
                                                              plugin.timestr(sp3), 
                                                              plugin.timestr(lap.LTime),))
        npl.lap_info.splits = [0,0,0]
        npl.lap_info.last_split = 0
        
    def message_out(self, host, mso):
        if mso.UserType == plugin.MSO_PREFIX:
            args = mso.Msg[mso.TextStart:].split()
            if args:
                cmd = args[0].lower()
                if cmd == '!start':
                    if hasattr(host, 'logging'):
                        host.logging = True
                        host.sendm('^3| ^7Started logging', mso.UCID)
                elif cmd == '!stop':
                    if hasattr(host, 'logging'):
                        host.logging = False
                        host.sendm('^3| ^7Stopped logging', mso.UCID)
        