# !/usr/bin/env python

import os
import cPickle

import host
import config
import plugin
import insim
     

APP_NAME = 'pyinsim'
APP_VERSION = '0.0.1 ALPHA'
APP_TITLE = '%s %s' % (APP_NAME, APP_VERSION)
STARTUP_DIR = os.path.dirname(__file__)
DATA_DIR = os.path.join(STARTUP_DIR, 'data')
PICKLE_PROTOCOL = 1
        
# Host init flags  
FLAGS = 0
if config.UPDATE == 1:
    FLAGS = FLAGS | insim.ISF_MCI
elif config.UPDATE == 2:
    FLAGS = FLAGS | insim.ISF_NLP
          

class App(object):   
    def __init__(self):
        print APP_TITLE
        print ''.rjust(len(APP_TITLE), '-')
        
        # Import plugin modules.
        self.plugins = []
        for module in config.PLUGINS:
            try:
                __import__(module)
            except ImportError:
                print 'Error: import plugin %s failed' % module
                
        # Create plugin objects and load plugin data.
        for subclass in plugin.get_plugin_subclasses():
            try:
                p = subclass() # Init plugin.
                try:
                    path = os.path.join(DATA_DIR, p.name)
                    if os.path.exists(path):
                        with open(path, 'rb') as f:
                            p.data = cPickle.load(f)
                except IOError as err:
                    print 'Error: could not load data for plugin %s (%s)' % (p.name, err[1])
                self.plugins.append(p)
                plugin.Plugin.plugin_map[p.name] = p                    
                print 'Loaded plugin: %s' % p.name
            except Exception as err:
                print 'Error: plugin load failed (%s)' % err
        
        # Initialize plugins, after data is loaded.
        [p.initialized() for p in self.plugins]
        
        # Init hosts
        self.hosts = []
        for name, info in config.HOSTS.iteritems():
            try:                
                h = host.Host(name, dispatch_to=self)
                h.init(info['host'], 
                       info['port'], 
                       UDPPort=info['udpport'], 
                       Admin=info['admin'], 
                       IName=APP_NAME,
                       Flags=FLAGS, 
                       Prefix=config.PREFIX, 
                       Interval=config.INTERVAL)
                self.hosts.append(h)
            except host.socket.error as err:
                print 'Error: could not init host %s:' % err[1]
                
        # Start polling hosts for packets. This blocks until all hosts close.
        host.run()
        
        # Shutdown...
        print 'No hosts connected'
        
        # Uninitialize plugins, before data is saved.
        [p.uninitialized() for p in self.plugins]
        
        # Save plugin data.
        for p in self.plugins:
            if p.data: # TODO: Issue as won't save if plugin has deleted all data?
                try:
                    path = os.path.join(DATA_DIR, p.name)
                    with open(path, 'wb') as f:
                        cPickle.dump(p.data, f, protocol=PICKLE_PROTOCOL) 
                except IOError as err:
                    print 'Error: could not save data for %s (%s)' % (p.name, err)
                
    def handle_connect(self, host):
        plugin.Plugin.host_map[host.name] = host
        [p.connected(host) for p in self.plugins]
        print 'Initialized host: %s (%s:%d)' % (host.name, host.hostaddr[0], host.hostaddr[1])        
        
    def handle_failed(self, host):
        # TODO: Get appropriate failed message?
        print 'Error: init host %s failed (%s:%d)' % (host.name, host.hostaddr[0], host.hostaddr[1])      
    
    def handle_lost(self, host):
        del plugin.Plugin.host_map[host.name]     
        [p.disconnected(host) for p in self.plugins]      
        print 'Error: lost host %s (%s:%d)' % (host.name, host.hostaddr[0], host.hostaddr[1])      
    
    def handle_packet(self, host, packet):
        [p.handle_packet(host, packet) for p in self.plugins]   
    
    def handle_error(self, host, err):
        # TODO: Improve this error message?
        print 'Error: host %s raised exception:' % host.name
        import traceback
        traceback.print_exc()
        
            
if __name__ == '__main__':   
    App()
    
