# speeding.py

import plugin

SPEED_LIMIT = 80 # Kph

class Speeding(plugin.Plugin):
    def __init__(self):
        plugin.Plugin.__init__(self)
        self.bind(plugin.ISP_MCI, self.car_update)

    def car_update(self, host, mci):
        for car in mci.Info:
            if plugin.kph(car.Speed) > SPEED_LIMIT:
                npl = host.players[car.PLID]
                host.sendm('/spec %s' % npl.PName)
                host.sendm('%s ^7spectated for speeding!' % npl.PName)
                host.sendm('Do not go above %d Kph!' % SPEED_LIMIT, ucid=npl.UCID)